/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.inject.Inject;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.Command;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.LoadedFiles;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.protocol.BrowserLog;
import com.google.jstestdriver.protocol.BrowserStreamAcknowledged;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BrowserQueryResponseHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(BrowserQueryResponseHandler.class);
    private final Gson gson = new Gson();
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final CapturedBrowsers browsers;
    private final ConcurrentMap<SlaveBrowser, List<String>> streamedResponses;

    @Inject
    public BrowserQueryResponseHandler(HttpServletRequest request, HttpServletResponse response, CapturedBrowsers browsers, ConcurrentMap<SlaveBrowser, List<String>> streamedResponses) {
        this.request = request;
        this.response = response;
        this.browsers = browsers;
        this.streamedResponses = streamedResponses;
    }

    @Override
    public void handleIt() throws IOException {
        logger.trace("Browser Query Post:\n\tpath:{}\n\tresponse:{}\n\tdone:{}\n\tresponseId:{}", new Object[]{this.request.getPathInfo().substring(1), this.request.getParameter("response"), this.request.getParameter("done"), this.request.getParameter("responseId")});
        this.response.setContentType("text/json;charset=UTF-8");
        this.service(this.request.getPathInfo().substring(1), this.request.getParameter("response"), this.request.getParameter("done"), this.request.getParameter("responseId"), this.response.getWriter());
    }

    public void service(String id, String response, String done, String responseId, PrintWriter writer) {
        SlaveBrowser browser = this.browsers.getBrowser(id);
        if (browser != null) {
            boolean isLast = Boolean.parseBoolean(done);
            try {
                this.serviceBrowser(response, isLast, responseId, writer, browser);
            }
            catch (JsonParseException e) {
                writer.print(this.gson.toJson(new JsonCommand(JsonCommand.CommandType.STOP, null)));
                writer.flush();
                throw new RuntimeException("Unable to parse: " + response, e);
            }
        }
        logger.error("Unknown browser {} with response {}", (Object)id, (Object)response);
        writer.print(this.gson.toJson(new JsonCommand(JsonCommand.CommandType.STOP, null)));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        writer.flush();
    }

    private void serviceBrowser(String response, Boolean done, String responseId, PrintWriter writer, SlaveBrowser browser) throws JsonParseException {
        this.addResponseId(responseId, browser);
        browser.heartBeat();
        Command command = null;
        if (this.isResponseValid(response) && browser.isCommandRunning()) {
            Response res = this.gson.fromJson(response, Response.class);
            logger.debug("response type: " + (Object)((Object)res.getResponseType()));
            switch (res.getResponseType()) {
                case FILE_LOAD_RESULT: {
                    LoadedFiles loadedFiles = (LoadedFiles)this.gson.fromJson(res.getResponse(), res.getGsonType());
                    Collection<FileResult> allLoadedFiles = loadedFiles.getLoadedFiles();
                    if (allLoadedFiles.isEmpty()) break;
                    LinkedHashSet<FileInfo> fileInfos = new LinkedHashSet<FileInfo>();
                    LinkedHashSet<FileSource> errorFiles = new LinkedHashSet<FileSource>();
                    for (FileResult fileResult : allLoadedFiles) {
                        FileSource fileSource = fileResult.getFileSource();
                        if (fileResult.isSuccess()) {
                            fileInfos.add(new FileInfo(fileSource.getBasePath(), fileSource.getTimestamp(), -1L, false, false, null, fileSource.getFileSrc()));
                            continue;
                        }
                        errorFiles.add(fileSource);
                    }
                    browser.addFiles(fileInfos);
                    if (errorFiles.size() <= 0) break;
                    logger.debug("clearing fileset on browser errors:" + errorFiles.size());
                    browser.resetFileSet();
                    break;
                }
                case NOOP: {
                    command = browser.getLastDequeuedCommand();
                    logger.warn("Got a NOOP with command {} running, which should not happen.", browser.getLastDequeuedCommand());
                    break;
                }
                case LOG: {
                    BrowserLog log = (BrowserLog)this.gson.fromJson(res.getResponse(), res.getGsonType());
                    if (log.getLevel() == 1000) {
                        logger.info("Error in browser: " + res.toString());
                        break;
                    }
                    logger.info("Message from the browser: " + res.toString());
                    break;
                }
                case RESET_RESULT: {
                    JsonCommand jsonCommand;
                    Command commandRunning = browser.getCommandRunning();
                    if (commandRunning != null && (jsonCommand = this.gson.fromJson(commandRunning.getCommand(), JsonCommand.class)).getCommand().equals(JsonCommand.CommandType.RESET.getCommand())) {
                        command = browser.getLastDequeuedCommand();
                    }
                }
                case BROWSER_READY: {
                    logger.debug("Clearing fileset for {}", browser);
                    browser.resetFileSet();
                    break;
                }
                case UNKNOWN: {
                    logger.error("Recieved Unknown: " + response);
                }
            }
            logger.debug("Received:\n done: {} \n res:\n {}\n", new Object[]{done, res});
            browser.addResponse(res, done);
        }
        if (this.isResponseIdValid(responseId) && !done.booleanValue() && !this.isResponseValid(response)) {
            logger.trace("Streaming query for ids {} from {}", this.streamedResponses.get(browser), (Object)browser);
        }
        if (!this.isResponseValid(response) && done.booleanValue() && browser.isCommandRunning()) {
            logger.error("Streaming ending, but no response sent for {} while running {}", browser, (Object)browser.getCommandRunning());
        }
        if (!done.booleanValue()) {
            String jsonResponse = this.gson.toJson(new BrowserStreamAcknowledged((List)this.streamedResponses.get(browser)));
            logger.trace("sending jsonResponse {}", (Object)jsonResponse);
            writer.print(jsonResponse);
            writer.flush();
            return;
        }
        this.streamedResponses.clear();
        if (command == null) {
            command = browser.dequeueCommand();
            browser.heartBeat();
        }
        logger.debug("sending command {}", (Object)(command == null ? "null" : command.getCommand()));
        writer.print(command.getCommand());
    }

    private boolean isResponseValid(String response) {
        return response != null && !"null".equals(response) && !"undefined".equals(response) && response.length() > 0;
    }

    private void addResponseId(String responseId, SlaveBrowser browser) {
        if (!this.streamedResponses.containsKey(browser)) {
            this.streamedResponses.put(browser, new CopyOnWriteArrayList());
        }
        if (this.isResponseIdValid(responseId)) {
            return;
        }
        ((List)this.streamedResponses.get(browser)).add(responseId);
    }

    private boolean isResponseIdValid(String responseId) {
        return responseId == null || "".equals(responseId);
    }
}

