/* affyProbe.h was originally generated by the autoSql program, which also 
 * generated affyProbe.c and affyProbe.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef AFFYPROBE_H
#define AFFYPROBE_H

#define AFFYPROBE_NUM_COLS 20

struct affyProbe
/* Data about an individual affy probe. */
    {
    struct affyProbe *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome. */
    unsigned chromStart;	/* Chrom start. */
    unsigned chromEnd;	/* End. */
    char *psName;	/* Probe Set name. */
    int transId;	/* Transcript Id */
    char strand[3];	/* Strand. */
    unsigned thickStart;	/* Start of where display should be thick (start codon for genes) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon for genes) */
    unsigned reserved;	/* Always zero for now. */
    unsigned blockCount;	/* Number of blocks. */
    int *blockSizes;	/* Comma separated list of block sizes.  */
    int *chromStarts;	/* Start positions inside chromosome.  Relative to chromStart */
    char *seq;	/* Sequence in 5'->3' orientation, NOT NORMAL JUST FOLLOWING AFFY FORMAT */
    int transcriptId;	/* Affy transcript identifier. */
    char *geneName;	/* Affy Gene name. */
    char *probeSetType;	/* Type of probeset. */
    double avgRawProbeScore;	/* Score of probe based on prior knowledge. */
    int exonPos;	/* ExonPos. */
    double rawProbeScore;	/* Score of individual probe. */
    int xhyCount;	/* xhyCount. */
    };

struct affyProbe *affyProbeLoad(char **row);
/* Load a affyProbe from row fetched with select * from affyProbe
 * from database.  Dispose of this with affyProbeFree(). */

struct affyProbe *affyProbeLoadAll(char *fileName);
/* Load all affyProbe from whitespace-separated file.
 * Dispose of this with affyProbeFreeList(). */

struct affyProbe *affyProbeLoadAllByChar(char *fileName, char chopper);
/* Load all affyProbe from chopper separated file.
 * Dispose of this with affyProbeFreeList(). */

#define affyProbeLoadAllByTab(a) affyProbeLoadAllByChar(a, '\t');
/* Load all affyProbe from tab separated file.
 * Dispose of this with affyProbeFreeList(). */

struct affyProbe *affyProbeCommaIn(char **pS, struct affyProbe *ret);
/* Create a affyProbe out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new affyProbe */

void affyProbeFree(struct affyProbe **pEl);
/* Free a single dynamically allocated affyProbe such as created
 * with affyProbeLoad(). */

void affyProbeFreeList(struct affyProbe **pList);
/* Free a list of dynamically allocated affyProbe's */

void affyProbeOutput(struct affyProbe *el, FILE *f, char sep, char lastSep);
/* Print out affyProbe.  Separate fields with sep. Follow last field with lastSep. */

#define affyProbeTabOut(el,f) affyProbeOutput(el,f,'\t','\n');
/* Print out affyProbe as a line in a tab-separated file. */

#define affyProbeCommaOut(el,f) affyProbeOutput(el,f,',',',');
/* Print out affyProbe as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* AFFYPROBE_H */

