/* itemDetailsHtml.c was originally generated by the autoSql program, which also 
 * generated itemDetailsHtml.h and itemDetailsHtml.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "itemDetailsHtml.h"


void itemDetailsHtmlStaticLoad(char **row, struct itemDetailsHtml *ret)
/* Load a row from itemDetailsHtml table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->html = row[1];
}

struct itemDetailsHtml *itemDetailsHtmlLoad(char **row)
/* Load a itemDetailsHtml from row fetched with select * from itemDetailsHtml
 * from database.  Dispose of this with itemDetailsHtmlFree(). */
{
struct itemDetailsHtml *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->html = cloneString(row[1]);
return ret;
}

struct itemDetailsHtml *itemDetailsHtmlLoadAll(char *fileName) 
/* Load all itemDetailsHtml from a whitespace-separated file.
 * Dispose of this with itemDetailsHtmlFreeList(). */
{
struct itemDetailsHtml *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = itemDetailsHtmlLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct itemDetailsHtml *itemDetailsHtmlLoadAllByChar(char *fileName, char chopper) 
/* Load all itemDetailsHtml from a chopper separated file.
 * Dispose of this with itemDetailsHtmlFreeList(). */
{
struct itemDetailsHtml *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = itemDetailsHtmlLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct itemDetailsHtml *itemDetailsHtmlCommaIn(char **pS, struct itemDetailsHtml *ret)
/* Create a itemDetailsHtml out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new itemDetailsHtml */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->html = sqlStringComma(&s);
*pS = s;
return ret;
}

void itemDetailsHtmlFree(struct itemDetailsHtml **pEl)
/* Free a single dynamically allocated itemDetailsHtml such as created
 * with itemDetailsHtmlLoad(). */
{
struct itemDetailsHtml *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->html);
freez(pEl);
}

void itemDetailsHtmlFreeList(struct itemDetailsHtml **pList)
/* Free a list of dynamically allocated itemDetailsHtml's */
{
struct itemDetailsHtml *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    itemDetailsHtmlFree(&el);
    }
*pList = NULL;
}

void itemDetailsHtmlOutput(struct itemDetailsHtml *el, FILE *f, char sep, char lastSep) 
/* Print out itemDetailsHtml.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->html);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

