/* tfbsConsMap.c was originally generated by the autoSql program, which also 
 * generated tfbsConsMap.h and tfbsConsMap.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "tfbsConsMap.h"


void tfbsConsMapStaticLoad(char **row, struct tfbsConsMap *ret)
/* Load a row from tfbsConsMap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = row[0];
ret->ac = row[1];
}

struct tfbsConsMap *tfbsConsMapLoad(char **row)
/* Load a tfbsConsMap from row fetched with select * from tfbsConsMap
 * from database.  Dispose of this with tfbsConsMapFree(). */
{
struct tfbsConsMap *ret;

AllocVar(ret);
ret->id = cloneString(row[0]);
ret->ac = cloneString(row[1]);
return ret;
}

struct tfbsConsMap *tfbsConsMapLoadAll(char *fileName) 
/* Load all tfbsConsMap from a whitespace-separated file.
 * Dispose of this with tfbsConsMapFreeList(). */
{
struct tfbsConsMap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = tfbsConsMapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct tfbsConsMap *tfbsConsMapLoadAllByChar(char *fileName, char chopper) 
/* Load all tfbsConsMap from a chopper separated file.
 * Dispose of this with tfbsConsMapFreeList(). */
{
struct tfbsConsMap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = tfbsConsMapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct tfbsConsMap *tfbsConsMapLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all tfbsConsMap from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with tfbsConsMapFreeList(). */
{
struct tfbsConsMap *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = tfbsConsMapLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void tfbsConsMapSaveToDb(struct sqlConnection *conn, struct tfbsConsMap *el, char *tableName, int updateSize)
/* Save tfbsConsMap as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s','%s')", 
	tableName,  el->id,  el->ac);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct tfbsConsMap *tfbsConsMapCommaIn(char **pS, struct tfbsConsMap *ret)
/* Create a tfbsConsMap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new tfbsConsMap */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlStringComma(&s);
ret->ac = sqlStringComma(&s);
*pS = s;
return ret;
}

void tfbsConsMapFree(struct tfbsConsMap **pEl)
/* Free a single dynamically allocated tfbsConsMap such as created
 * with tfbsConsMapLoad(). */
{
struct tfbsConsMap *el;

if ((el = *pEl) == NULL) return;
freeMem(el->id);
freeMem(el->ac);
freez(pEl);
}

void tfbsConsMapFreeList(struct tfbsConsMap **pList)
/* Free a list of dynamically allocated tfbsConsMap's */
{
struct tfbsConsMap *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    tfbsConsMapFree(&el);
    }
*pList = NULL;
}

void tfbsConsMapOutput(struct tfbsConsMap *el, FILE *f, char sep, char lastSep) 
/* Print out tfbsConsMap.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->id);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ac);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

