/* encodeErgeMethProm.h was originally generated by the autoSql program, which also 
 * generated encodeErgeMethProm.c and encodeErgeMethProm.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2008 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ENCODEERGEMETHPROM_H
#define ENCODEERGEMETHPROM_H

#define ENCODEERGEMETHPROM_NUM_COLS 14

struct encodeErgeMethProm
/* ENCODE experimental data from dbERGEII */
    {
    struct encodeErgeMethProm *next;  /* Next in singly linked list. */
    char *chrom;	/* Human chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of read - up to 255 characters */
    unsigned score;	/* Score from 0-1000.  1000 is best */
    char strand[2];	/* Value should be + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* Always zero for now */
    unsigned blockCount;	/* Number of separate blocks (regions without gaps) */
    unsigned *blockSizes;	/* Comma separated list of block sizes */
    unsigned *chromStarts;	/* Start position of each block in relative to chromStart */
    char *Id;	/* dbERGEII Id */
    char *color;	/* RGB color values */
    };

struct encodeErgeMethProm *encodeErgeMethPromLoad(char **row);
/* Load a encodeErgeMethProm from row fetched with select * from encodeErgeMethProm
 * from database.  Dispose of this with encodeErgeMethPromFree(). */

struct encodeErgeMethProm *encodeErgeMethPromLoadAll(char *fileName);
/* Load all encodeErgeMethProm from whitespace-separated file.
 * Dispose of this with encodeErgeMethPromFreeList(). */

struct encodeErgeMethProm *encodeErgeMethPromLoadAllByChar(char *fileName, char chopper);
/* Load all encodeErgeMethProm from chopper separated file.
 * Dispose of this with encodeErgeMethPromFreeList(). */

#define encodeErgeMethPromLoadAllByTab(a) encodeErgeMethPromLoadAllByChar(a, '\t');
/* Load all encodeErgeMethProm from tab separated file.
 * Dispose of this with encodeErgeMethPromFreeList(). */

struct encodeErgeMethProm *encodeErgeMethPromCommaIn(char **pS, struct encodeErgeMethProm *ret);
/* Create a encodeErgeMethProm out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new encodeErgeMethProm */

void encodeErgeMethPromFree(struct encodeErgeMethProm **pEl);
/* Free a single dynamically allocated encodeErgeMethProm such as created
 * with encodeErgeMethPromLoad(). */

void encodeErgeMethPromFreeList(struct encodeErgeMethProm **pList);
/* Free a list of dynamically allocated encodeErgeMethProm's */

void encodeErgeMethPromOutput(struct encodeErgeMethProm *el, FILE *f, char sep, char lastSep);
/* Print out encodeErgeMethProm.  Separate fields with sep. Follow last field with lastSep. */

#define encodeErgeMethPromTabOut(el,f) encodeErgeMethPromOutput(el,f,'\t','\n');
/* Print out encodeErgeMethProm as a line in a tab-separated file. */

#define encodeErgeMethPromCommaOut(el,f) encodeErgeMethPromOutput(el,f,',',',');
/* Print out encodeErgeMethProm as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ENCODEERGEMETHPROM_H */

