/* encodeErgeTransTransf.h was originally generated by the autoSql program, which also 
 * generated encodeErgeTransTransf.c and encodeErgeTransTransf.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2008 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ENCODEERGETRANSTRANSF_H
#define ENCODEERGETRANSTRANSF_H

#define ENCODEERGETRANSTRANSF_NUM_COLS 14

struct encodeErgeTransTransf
/* ENCODE experimental data from dbERGEII */
    {
    struct encodeErgeTransTransf *next;  /* Next in singly linked list. */
    char *chrom;	/* Human chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of read - up to 255 characters */
    unsigned score;	/* Score from 0-1000.  1000 is best */
    char strand[2];	/* Value should be + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* Always zero for now */
    unsigned blockCount;	/* Number of separate blocks (regions without gaps) */
    unsigned *blockSizes;	/* Comma separated list of block sizes */
    unsigned *chromStarts;	/* Start position of each block in relative to chromStart */
    char *Id;	/* dbERGEII Id */
    char *color;	/* RGB color values */
    };

struct encodeErgeTransTransf *encodeErgeTransTransfLoad(char **row);
/* Load a encodeErgeTransTransf from row fetched with select * from encodeErgeTransTransf
 * from database.  Dispose of this with encodeErgeTransTransfFree(). */

struct encodeErgeTransTransf *encodeErgeTransTransfLoadAll(char *fileName);
/* Load all encodeErgeTransTransf from whitespace-separated file.
 * Dispose of this with encodeErgeTransTransfFreeList(). */

struct encodeErgeTransTransf *encodeErgeTransTransfLoadAllByChar(char *fileName, char chopper);
/* Load all encodeErgeTransTransf from chopper separated file.
 * Dispose of this with encodeErgeTransTransfFreeList(). */

#define encodeErgeTransTransfLoadAllByTab(a) encodeErgeTransTransfLoadAllByChar(a, '\t');
/* Load all encodeErgeTransTransf from tab separated file.
 * Dispose of this with encodeErgeTransTransfFreeList(). */

struct encodeErgeTransTransf *encodeErgeTransTransfCommaIn(char **pS, struct encodeErgeTransTransf *ret);
/* Create a encodeErgeTransTransf out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new encodeErgeTransTransf */

void encodeErgeTransTransfFree(struct encodeErgeTransTransf **pEl);
/* Free a single dynamically allocated encodeErgeTransTransf such as created
 * with encodeErgeTransTransfLoad(). */

void encodeErgeTransTransfFreeList(struct encodeErgeTransTransf **pList);
/* Free a list of dynamically allocated encodeErgeTransTransf's */

void encodeErgeTransTransfOutput(struct encodeErgeTransTransf *el, FILE *f, char sep, char lastSep);
/* Print out encodeErgeTransTransf.  Separate fields with sep. Follow last field with lastSep. */

#define encodeErgeTransTransfTabOut(el,f) encodeErgeTransTransfOutput(el,f,'\t','\n');
/* Print out encodeErgeTransTransf as a line in a tab-separated file. */

#define encodeErgeTransTransfCommaOut(el,f) encodeErgeTransTransfOutput(el,f,',',',');
/* Print out encodeErgeTransTransf as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ENCODEERGETRANSTRANSF_H */

