/* megablastInfo.h was originally generated by the autoSql program, which also 
 * generated megablastInfo.c and megablastInfo.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2009 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef MEGABLASTINFO_H
#define MEGABLASTINFO_H

#define MEGABLASTINFO_NUM_COLS 10

struct megablastInfo
/* Conserved Domain Description */
    {
    struct megablastInfo *next;  /* Next in singly linked list. */
    char *chrom;	/* chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* hit name */
    unsigned score;	/* Score from 900-1000.  1000 is best */
    char strand[2];	/* Value should be + or - */
    double evalue;	/* Expect value */
    unsigned percentident;	/* Data source */
    char *fullname;	/* hit name */
    unsigned taxid;	/* Data source */
    };

void megablastInfoStaticLoad(char **row, struct megablastInfo *ret);
/* Load a row from megablastInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct megablastInfo *megablastInfoLoad(char **row);
/* Load a megablastInfo from row fetched with select * from megablastInfo
 * from database.  Dispose of this with megablastInfoFree(). */

struct megablastInfo *megablastInfoLoadAll(char *fileName);
/* Load all megablastInfo from whitespace-separated file.
 * Dispose of this with megablastInfoFreeList(). */

struct megablastInfo *megablastInfoLoadAllByChar(char *fileName, char chopper);
/* Load all megablastInfo from chopper separated file.
 * Dispose of this with megablastInfoFreeList(). */

#define megablastInfoLoadAllByTab(a) megablastInfoLoadAllByChar(a, '\t');
/* Load all megablastInfo from tab separated file.
 * Dispose of this with megablastInfoFreeList(). */

struct megablastInfo *megablastInfoCommaIn(char **pS, struct megablastInfo *ret);
/* Create a megablastInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new megablastInfo */

void megablastInfoFree(struct megablastInfo **pEl);
/* Free a single dynamically allocated megablastInfo such as created
 * with megablastInfoLoad(). */

void megablastInfoFreeList(struct megablastInfo **pList);
/* Free a list of dynamically allocated megablastInfo's */

void megablastInfoOutput(struct megablastInfo *el, FILE *f, char sep, char lastSep);
/* Print out megablastInfo.  Separate fields with sep. Follow last field with lastSep. */

#define megablastInfoTabOut(el,f) megablastInfoOutput(el,f,'\t','\n');
/* Print out megablastInfo as a line in a tab-separated file. */

#define megablastInfoCommaOut(el,f) megablastInfoOutput(el,f,',',',');
/* Print out megablastInfo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* MEGABLASTINFO_H */

