/* transMapSrc.h was originally generated by the autoSql program, which also 
 * generated transMapSrc.c and transMapSrc.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2008 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef TRANSMAPSRC_H
#define TRANSMAPSRC_H

#define TRANSMAPSRC_NUM_COLS 8

extern char *transMapSrcCommaSepFieldNames;

struct transMapSrc
/* shared about transMap source alignments */
    {
    struct transMapSrc *next;  /* Next in singly linked list. */
    char db[17];	/* source db */
    char *id;	/* id of source alignment */
    char *chrom;	/* chromosome */
    unsigned chromStart;	/* chrom start location */
    unsigned chromEnd;	/* chrom end location */
    char strand;	/* strand */
    float ident;	/* identity */
    float aligned;	/* fraction of sequence aligned */
    };

void transMapSrcStaticLoad(char **row, struct transMapSrc *ret);
/* Load a row from transMapSrc table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct transMapSrc *transMapSrcLoad(char **row);
/* Load a transMapSrc from row fetched with select * from transMapSrc
 * from database.  Dispose of this with transMapSrcFree(). */

struct transMapSrc *transMapSrcLoadAll(char *fileName);
/* Load all transMapSrc from whitespace-separated file.
 * Dispose of this with transMapSrcFreeList(). */

struct transMapSrc *transMapSrcLoadAllByChar(char *fileName, char chopper);
/* Load all transMapSrc from chopper separated file.
 * Dispose of this with transMapSrcFreeList(). */

#define transMapSrcLoadAllByTab(a) transMapSrcLoadAllByChar(a, '\t');
/* Load all transMapSrc from tab separated file.
 * Dispose of this with transMapSrcFreeList(). */

struct transMapSrc *transMapSrcCommaIn(char **pS, struct transMapSrc *ret);
/* Create a transMapSrc out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new transMapSrc */

void transMapSrcFree(struct transMapSrc **pEl);
/* Free a single dynamically allocated transMapSrc such as created
 * with transMapSrcLoad(). */

void transMapSrcFreeList(struct transMapSrc **pList);
/* Free a list of dynamically allocated transMapSrc's */

void transMapSrcOutput(struct transMapSrc *el, FILE *f, char sep, char lastSep);
/* Print out transMapSrc.  Separate fields with sep. Follow last field with lastSep. */

#define transMapSrcTabOut(el,f) transMapSrcOutput(el,f,'\t','\n');
/* Print out transMapSrc as a line in a tab-separated file. */

#define transMapSrcCommaOut(el,f) transMapSrcOutput(el,f,',',',');
/* Print out transMapSrc as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct transMapSrc *transMapSrcQuery(struct sqlConnection *conn,
                                     char *table, char *srcDb, char *srcId);
/* load a single transMapSrc object for an srcDb and srcId from a table,
 * or error if not found */

#endif /* TRANSMAPSRC_H */

