table cosmicNew
"Bed representation of the Catalog of Somatic Mutations in Cancer (COSMIC)"
    (
    string chrom;          "Reference sequence chromosome or scaffold"
    uint   chromStart;     "Start position in chromosome"
    uint   chromEnd;       "End position in chromosome"
    string name;           "COSMIC mutation ID"
	uint score;            "Unused. A score between 0 and 1000"    
   	char[1] strand;        "+ or - for strand. Use . if not applicable"
    uint   thickStart;     "Start position in chromosome"
    uint   thickEnd;       "End position in chromosome"
	string geneName;       "Gene: HUGO symbol, mir-* ID, etc" 
    string transcriptAcc;  "ENST, NM_, XM_ or other transcript accession"
    int geneCdsLength;     "Length of the gene (base pair) counts"
    int geneId;            "If gene is in HGNC, this id helps linking it to HGNC"
    string sampleName;     "A sample is an instance of a portion of a tumour being examined for mutations"
    int sampleId;          "A sample id is used to identify a sample within the COSMIC database"
    int idTumor;           "A number of samples can be taken from a single tumour and a number of tumours can be obtained from one individual"
    string primSite;       "Primary site of organ or tissue from which tumor sample was taken"
    string siteSubtype1;   "Subtype 1 site of organ or tissue from which tumor sample was taken"
    string siteSubtype2;   "Subtype 2 site of organ or tissue from which tumor sample was taken"
    string siteSubtype3;   "Subtype 3 site of organ or tissue from which tumor sample was taken"
    string primHistology;  "Primary histology of organ or tissue from which tumor sample was taken"
    string histSubtype1;   "Subtype 1 histology of organ or tissue from which tumor sample was taken"
    string histSubtype2;   "Subtype 2 histology of organ or tissue from which tumor sample was taken"
    string histSubtype3;   "Subtype 3 histology of organ or tissue from which tumor sample was taken"
    lstring ntChange;      "Nucleotide sequence change"
    lstring aaChange;      "Amino acid sequence change"
    string mutDescription; "Description of effect of variant on gene"
    string mutZygosity;    "Information on whether the mutation was reported to be homozygous , heterozygous or unknown within the sample"
    string loh;            "LOH Information on whether the gene was reported to have loss of heterozygosity in the sample, yes, no or unknown."
    char[1] snp;           "All the known SNPs are flagged as 'y' defined by the 1000 genomes project, dbSNP and a panel of 378 normal (non-cancer) samples from Sanger CGP sequencing"
    string resMut;         "Resistant mutation, mutation confers drug resistance"
    string fathmmPred;     "FATHMM (Functional Analysis through Hidden Markov Models) prediction"
    float fathmmScore;     "FATHMM score, a pvalue ranging from 0 to 1. Greater than .5 is signicant, less is benign"
    string mutSomStat;     "Mutation somatic status"
    int pubmedId;          "The PUBMED id for the paper the sample was noted in"
    string studyIds;       "Lists the unique Ids of studies that have involved this sample."
    string samSource;      "Describes where the sample has originated from"
    string tumSource;      "Describes the tumor type"
    float age;             "Age of the sample (if provided)"
	string cosmLabel;      "COSMIC external name"
	string _mouseOver;     "Mouseover label" 
	)
