/* hgnc.c was originally generated by the autoSql program, which also 
 * generated hgnc.h and hgnc.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "hgnc.h"


void hgncStaticLoadWithNull(char **row, struct hgnc *ret)
/* Load a row from hgnc table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->hgncId = row[0];
ret->symbol = row[1];
ret->name = row[2];
ret->status = row[3];
ret->locusType = row[4];
ret->locusGroup = row[5];
ret->prvSymbols = row[6];
ret->prvNames = row[7];
ret->synonyms = row[8];
ret->nameSyns = row[9];
ret->chrom = row[10];
ret->dateApprv = row[11];
ret->dateMod = row[12];
ret->dateSymChange = row[13];
ret->dateNmChange = row[14];
ret->accession = row[15];
ret->enzymeIds = row[16];
ret->entrezId = row[17];
ret->ensId = row[18];
ret->mgdId = row[19];
ret->miscDbs = row[20];
ret->miscIds = row[21];
ret->pubMed = row[22];
ret->refSeqIds = row[23];
ret->geneFamilyNm = row[24];
ret->geneFamilyDesc = row[25];
ret->recType = row[26];
ret->primaryId = row[27];
ret->secondaryId = row[28];
ret->ccdsId = row[29];
ret->vegaId = row[30];
ret->locusDbs = row[31];
ret->gdbMapped = row[32];
ret->entrezMapped = row[33];
ret->omimMapped = row[34];
ret->refSeqMapped = row[35];
ret->uniProtMapped = row[36];
ret->ensMapped = row[37];
ret->ucscMapped = row[38];
ret->mgiMapped = row[39];
ret->rgdMapped = row[40];
}

struct hgnc *hgncLoadWithNull(char **row)
/* Load a hgnc from row fetched with select * from hgnc
 * from database.  Dispose of this with hgncFree(). */
{
struct hgnc *ret;

AllocVar(ret);
ret->hgncId = cloneString(row[0]);
ret->symbol = cloneString(row[1]);
ret->name = cloneString(row[2]);
ret->status = cloneString(row[3]);
ret->locusType = cloneString(row[4]);
ret->locusGroup = cloneString(row[5]);
ret->prvSymbols = cloneString(row[6]);
ret->prvNames = cloneString(row[7]);
ret->synonyms = cloneString(row[8]);
ret->nameSyns = cloneString(row[9]);
ret->chrom = cloneString(row[10]);
ret->dateApprv = cloneString(row[11]);
ret->dateMod = cloneString(row[12]);
ret->dateSymChange = cloneString(row[13]);
ret->dateNmChange = cloneString(row[14]);
ret->accession = cloneString(row[15]);
ret->enzymeIds = cloneString(row[16]);
ret->entrezId = cloneString(row[17]);
ret->ensId = cloneString(row[18]);
ret->mgdId = cloneString(row[19]);
ret->miscDbs = cloneString(row[20]);
ret->miscIds = cloneString(row[21]);
ret->pubMed = cloneString(row[22]);
ret->refSeqIds = cloneString(row[23]);
ret->geneFamilyNm = cloneString(row[24]);
ret->geneFamilyDesc = cloneString(row[25]);
ret->recType = cloneString(row[26]);
ret->primaryId = cloneString(row[27]);
ret->secondaryId = cloneString(row[28]);
ret->ccdsId = cloneString(row[29]);
ret->vegaId = cloneString(row[30]);
ret->locusDbs = cloneString(row[31]);
ret->gdbMapped = cloneString(row[32]);
ret->entrezMapped = cloneString(row[33]);
ret->omimMapped = cloneString(row[34]);
ret->refSeqMapped = cloneString(row[35]);
ret->uniProtMapped = cloneString(row[36]);
ret->ensMapped = cloneString(row[37]);
ret->ucscMapped = cloneString(row[38]);
ret->mgiMapped = cloneString(row[39]);
ret->rgdMapped = cloneString(row[40]);
return ret;
}

struct hgnc *hgncLoadAll(char *fileName) 
/* Load all hgnc from a whitespace-separated file.
 * Dispose of this with hgncFreeList(). */
{
struct hgnc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[41];

while (lineFileRow(lf, row))
    {
    el = hgncLoadWithNull(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hgnc *hgncLoadAllByChar(char *fileName, char chopper) 
/* Load all hgnc from a chopper separated file.
 * Dispose of this with hgncFreeList(). */
{
struct hgnc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[41];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = hgncLoadWithNull(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hgnc *hgncCommaIn(char **pS, struct hgnc *ret)
/* Create a hgnc out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hgnc */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->hgncId = sqlStringComma(&s);
ret->symbol = sqlStringComma(&s);
ret->name = sqlStringComma(&s);
ret->status = sqlStringComma(&s);
ret->locusType = sqlStringComma(&s);
ret->locusGroup = sqlStringComma(&s);
ret->prvSymbols = sqlStringComma(&s);
ret->prvNames = sqlStringComma(&s);
ret->synonyms = sqlStringComma(&s);
ret->nameSyns = sqlStringComma(&s);
ret->chrom = sqlStringComma(&s);
ret->dateApprv = sqlStringComma(&s);
ret->dateMod = sqlStringComma(&s);
ret->dateSymChange = sqlStringComma(&s);
ret->dateNmChange = sqlStringComma(&s);
ret->accession = sqlStringComma(&s);
ret->enzymeIds = sqlStringComma(&s);
ret->entrezId = sqlStringComma(&s);
ret->ensId = sqlStringComma(&s);
ret->mgdId = sqlStringComma(&s);
ret->miscDbs = sqlStringComma(&s);
ret->miscIds = sqlStringComma(&s);
ret->pubMed = sqlStringComma(&s);
ret->refSeqIds = sqlStringComma(&s);
ret->geneFamilyNm = sqlStringComma(&s);
ret->geneFamilyDesc = sqlStringComma(&s);
ret->recType = sqlStringComma(&s);
ret->primaryId = sqlStringComma(&s);
ret->secondaryId = sqlStringComma(&s);
ret->ccdsId = sqlStringComma(&s);
ret->vegaId = sqlStringComma(&s);
ret->locusDbs = sqlStringComma(&s);
ret->gdbMapped = sqlStringComma(&s);
ret->entrezMapped = sqlStringComma(&s);
ret->omimMapped = sqlStringComma(&s);
ret->refSeqMapped = sqlStringComma(&s);
ret->uniProtMapped = sqlStringComma(&s);
ret->ensMapped = sqlStringComma(&s);
ret->ucscMapped = sqlStringComma(&s);
ret->mgiMapped = sqlStringComma(&s);
ret->rgdMapped = sqlStringComma(&s);
*pS = s;
return ret;
}

void hgncFree(struct hgnc **pEl)
/* Free a single dynamically allocated hgnc such as created
 * with hgncLoad(). */
{
struct hgnc *el;

if ((el = *pEl) == NULL) return;
freeMem(el->hgncId);
freeMem(el->symbol);
freeMem(el->name);
freeMem(el->status);
freeMem(el->locusType);
freeMem(el->locusGroup);
freeMem(el->prvSymbols);
freeMem(el->prvNames);
freeMem(el->synonyms);
freeMem(el->nameSyns);
freeMem(el->chrom);
freeMem(el->dateApprv);
freeMem(el->dateMod);
freeMem(el->dateSymChange);
freeMem(el->dateNmChange);
freeMem(el->accession);
freeMem(el->enzymeIds);
freeMem(el->entrezId);
freeMem(el->ensId);
freeMem(el->mgdId);
freeMem(el->miscDbs);
freeMem(el->miscIds);
freeMem(el->pubMed);
freeMem(el->refSeqIds);
freeMem(el->geneFamilyNm);
freeMem(el->geneFamilyDesc);
freeMem(el->recType);
freeMem(el->primaryId);
freeMem(el->secondaryId);
freeMem(el->ccdsId);
freeMem(el->vegaId);
freeMem(el->locusDbs);
freeMem(el->gdbMapped);
freeMem(el->entrezMapped);
freeMem(el->omimMapped);
freeMem(el->refSeqMapped);
freeMem(el->uniProtMapped);
freeMem(el->ensMapped);
freeMem(el->ucscMapped);
freeMem(el->mgiMapped);
freeMem(el->rgdMapped);
freez(pEl);
}

void hgncFreeList(struct hgnc **pList)
/* Free a list of dynamically allocated hgnc's */
{
struct hgnc *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    hgncFree(&el);
    }
*pList = NULL;
}

void hgncOutput(struct hgnc *el, FILE *f, char sep, char lastSep) 
/* Print out hgnc.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->hgncId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->symbol);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->status);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->locusType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->locusGroup);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->prvSymbols);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->prvNames);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->synonyms);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->nameSyns);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dateApprv);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dateMod);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dateSymChange);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dateNmChange);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->accession);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->enzymeIds);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->entrezId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ensId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mgdId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->miscDbs);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->miscIds);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pubMed);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->refSeqIds);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneFamilyNm);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneFamilyDesc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->recType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->primaryId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->secondaryId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ccdsId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->vegaId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->locusDbs);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gdbMapped);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->entrezMapped);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->omimMapped);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->refSeqMapped);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->uniProtMapped);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ensMapped);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ucscMapped);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mgiMapped);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rgdMapped);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

