/* refCluster.c was originally generated by the autoSql program, which also 
 * generated refCluster.h and refCluster.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2011 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "refCluster.h"


struct refCluster *refClusterLoad(char **row)
/* Load a refCluster from row fetched with select * from refCluster
 * from database.  Dispose of this with refClusterFree(). */
{
struct refCluster *ret;

AllocVar(ret);
ret->refCount = sqlSigned(row[5]);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlSigned(row[1]);
ret->chromEnd = sqlSigned(row[2]);
ret->name = cloneString(row[3]);
safecpy(ret->strand, sizeof(ret->strand), row[4]);
{
int sizeOne;
sqlStringDynamicArray(row[6], &ret->refArray, &sizeOne);
assert(sizeOne == ret->refCount);
}
return ret;
}

struct refCluster *refClusterLoadAll(char *fileName) 
/* Load all refCluster from a whitespace-separated file.
 * Dispose of this with refClusterFreeList(). */
{
struct refCluster *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = refClusterLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct refCluster *refClusterLoadAllByChar(char *fileName, char chopper) 
/* Load all refCluster from a chopper separated file.
 * Dispose of this with refClusterFreeList(). */
{
struct refCluster *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = refClusterLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct refCluster *refClusterCommaIn(char **pS, struct refCluster *ret)
/* Create a refCluster out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new refCluster */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlSignedComma(&s);
ret->chromEnd = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->refCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->refArray, ret->refCount);
for (i=0; i<ret->refCount; ++i)
    {
    ret->refArray[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void refClusterFree(struct refCluster **pEl)
/* Free a single dynamically allocated refCluster such as created
 * with refClusterLoad(). */
{
struct refCluster *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
/* All strings in refArray are allocated at once, so only need to free first. */
if (el->refArray != NULL)
    freeMem(el->refArray[0]);
freeMem(el->refArray);
freez(pEl);
}

void refClusterFreeList(struct refCluster **pList)
/* Free a list of dynamically allocated refCluster's */
{
struct refCluster *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    refClusterFree(&el);
    }
*pList = NULL;
}

void refClusterOutput(struct refCluster *el, FILE *f, char sep, char lastSep) 
/* Print out refCluster.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->chromStart);
fputc(sep,f);
fprintf(f, "%d", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->refCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->refCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->refArray[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

