/* freen - My Pet Freen. */
#include "common.h"
#include "memalloc.h"
#include "linefile.h"
#include "hash.h"
#include "options.h"
#include "axt.h"


void usage()
/* Print usage and exit. */
{
errAbort("usage: freen something");
}

int xenAlignAffine(char *query, int querySize, char *target, int targetSize, 
	struct axtScoreScheme *ss, FILE *f, boolean printExtraAtEnds);
/* Use dynamic programming to do protein/protein alignment. */


void freen(char *out)
/* Test some hair-brained thing. */
{
char *a = "CVMVFTVSCSKMSSIVDRDDSSIFDGLVEEDDKDKAKRVSRNKSEKKRRDQFNVLIKELG"
"SMLPGNARKMDKSTVLQKSIDFLRKHKETTAQSDASEIRQDWKPTFLSNEEFTQLMLEAL"
"DGFFLAIMTDGSIIYVSESVTSLLEHLPSDLVDQSIFNFIPEGEHSEVYKILSTHLLESD"
"SLTPEYLKSKNQLEFCCHMLRGTIDPKEPSTYEYVRFIGNFKSLTSVSTSTHNGFEGTIQ"
"RTHRPSYEDRVCFVATVRLATPQFIKEMCTVEEPNEEFTSRHSLEWKFLFLDHRAPPIIG"
"YLPFEVLGTSGYDYYHVDDLENLAKCHEHLMQYGKGKSCYYRFLTKGQQWIWLQTHYYIT"
"YHQWNSRPEFIVCTHTVVSYAEVRAERRRELGIEESLPETAADKSQDSGSDNRINTVSLK"
"EALERFDHSPTPSASSRSSRKSSHTAVSDPSSTPTKIPTDTSTPPRQHLPAHEKMTQRRS"
"SFSSQSINSQSVGPSLTQPAMSQAANLPIPQGMSQFQFSAQLGAMQHLKDQLEQRTRMIE"
"ANIHRQQEELRKIQEQLQMVHGQGLQMFLQQSNPGLNFGSVQLSSGNSNIQQLTPVNMQG"
"QVVPANQVQSGHISTGQHMIQQQTLQSTSTQQSQQSVMSGHSQQTSLPSQTPSTLTAPLY"
"NTMVISQPAAGSMVQIPSSMPQNSTQSATVTTFTQDRQIRFSQGQQLVTKLVTAPVACGA"
"VMVPSTMLMGQVVTAYPTFATQQQQAQTLSVTQQQQQQQQQPPQQQQQQQQSSQEQQLPS"
"VQQPAQAQLGQPPQQFLQTSRLLHGNPSTQLILSAAFPLQQSTFPPSHHQQHQPQQQQQL"
"PRHRTDSLTDPSKVQPQ";
char *b = "CVMVFTVSCSKMSSIVDRDDSSIFDGLVEEDDKDKAKRVSRNKSEKKRRDQFNVLIKELG"
"SMLPGNARKMDKSTVLQKSIDFLRKHKETTAQSDASEIRQDWKPTFLSNEEFTQLMLEAL"
"DGFFLAIMTDGSIIYVSESVTSLLEHLPSDLVDQSIFNFIPEGEHSEVYKILSTHLLESD"
"SLTPEYLKSKNQLEFCCHMLRGTIDPKEPSTYEYVRFIGNFKSLTSVSTSTHNGFEGTIQ"
"RTHRPSYEDRVCFVATVRLATPQFIKEMCTVEEPNEEFTSRHSLEWKFLFLDHRAPPIIG"
"xQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQ"
"YHQWNSRPEFIVCTHTVVSYAEVRAERRRELGIEESLPETAADKSQDSGSDNRINTVSLK"
"EALERFDHSPTPSASSRSSRKSSHTAVSDPSSTPTKIPTDTSTPPRQHLPAHEKMTQRRS"
"SFSSQSINSQSVGPSLTQPAMSQAANLPIPQGMSQFQFSAQLGAMQHLKDQLEQRTRMIE"
"ANIHRQQEELRKIQEQLQMVHGQGLQMFLQQSNPGLNFGSVQLSSGNSNIQQLTPVNMQG"
"QVVPANQVQSGHISTGQHMIQQQTLQSTSTQQSQQSVMSGHSQQTSLPSQTPSTLTAPLY"
"NTMVISQPAAGSMVQIPSSMPQNSTQSATVTTFTQDRQIRFSQGQQLVTKLVTAPVACGA"
"VMVPSTMLMGQVVTAYPTFATQQQQAQTLSVTQQQQQQQQQPPQQQQQQQQSSQEQQLPS"
"VQQPAQAQLGQPPQQFLQTSRLLHGNPSTQLILSAAFPLQQSTFPPSHHQQHQPQQQQQL"
"PRHRTDSLTDPSKVQPQ";
char *c = "CVMVFTVSCSKMSSIVDRDDSSIFDGLVEEDDKDKAKRVSRNKSEKKRRDQFNVLIKELG"
"xMLPGNARKMDKSTVLQKSIDFLRKHKETTAQSDASEIRQDWKPTFLSNEEFTQLMLEAL"
"xxFFLAIMTDGSIIYVSESVTSLLEHLPSDLVDQSIFNFIPEGEHSEVYKILSTHLLESD"
"xxxPEYLKSKNQLEFCCHMLRGTIDPKEPSTYEYVRFIGNFKSLTSVSTSTHNGFEGTIQ"
"xxxxPSYEDRVCFVATVRLATPQFIKEMCTVEEPNEEFTSRHSLEWKFLFLDHRAPPIIG"
"xxxxxVLGTSGYDYYHVDDLENLAKCHEHLMQYGKGKSCYYRFLTKGQQWIWLQTHYYIT"
"xxxxxxRPEFIVCTHTVVSYAEVRAERRRELGIEESLPETAADKSQDSGSDNRINTVSLK"
"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
"xxxxxxxxSQSVGPSLTQPAMSQAANLPIPQGMSQFQFSAQLGAMQHLKDQLEQRTRMIE"
"xxxxxxxxxLRKIQEQLQMVHGQGLQMFLQQSNPGLNFGSVQLSSGNSNIQQLTPVNMQG"
"xxxxxxxxxxGHISTGQHMIQQQTLQSTSTQQSQQSVMSGHSQQTSLPSQTPSTLTAPLY"
"xxxxxxxxxxxSMVQIPSSMPQNSTQSATVTTFTQDRQIRFSQGQQLVTKLVTAPVACGA"
"xxxxxxxxxxxxVTAYPTFATQQQQAQTLSVTQQQQQQQQQPPQQQQQQQQSSQEQQLPS"
"xxxxxxxxxxxxxQQFLQTSRLLHGNPSTQLILSAAFPLQQSTFPPSHHQQHQPQQQQQL"
"PRHRTDSLTDPSKVQPQ";
char *d = "CVMVFTVSCSKMSSIVDRDDSSIFDGLVEEDDKDKAKRVSRNKSEKKRRDQFNVLIKELG"
"SMLPGNARKMDKSTVLQKSIDFLRKHKETTAQSDASEIRQDWKPTFLSNEEFTQLMLEAL"
"DGFFLAIMTDGSIIYVSESVTSLLEHLPSDLVDQSIFNFIPEGEHSEVYKILSTHLLESD"
"SLTPEYLKSKNQLEFCCHMLRGTIDPKEPSTYEYVRFIGNFKSLTSVSTSTHNGFEGTIQ"
"RTHRPSYEDRVCFVATVRLATPQFIKEMCTVEEPNEEFTSRHSLEWKFLFLDHRAPPIIG"
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
"YHQWNSRPEFIVCTHTVVSYAEVRAERRRELGIEESLPETAADKSQDSGSDNRINTVSLK"
"EALERFDHSPTPSASSRSSRKSSHTAVSDPSSTPTKIPTDTSTPPRQHLPAHEKMTQRRS"
"SFSSQSINSQSVGPSLTQPAMSQAANLPIPQGMSQFQFSAQLGAMQHLKDQLEQRTRMIE"
"ANIHRQQEELRKIQEQLQMVHGQGLQMFLQQSNPGLNFGSVQLSSGNSNIQQLTPVNMQG"
"QVVPANQVQSGHISTGQHMIQQQTLQSTSTQQSQQSVMSGHSQQTSLPSQTPSTLTAPLY"
"NTMVISQPAAGSMVQIPSSMPQNSTQSATVTTFTQDRQIRFSQGQQLVTKLVTAPVACGA"
"VMVPSTMLMGQVVTAYPTFATQQQQAQTLSVTQQQQQQQQQPPQQQQQQQQSSQEQQLPS"
"VQQPAQAQLGQPPQQFLQTSRLLHGNPSTQLILSAAFPLQQSTFPPSHHQQHQPQQQQQL"
"PRHRTDSLTDPSKVQPQ";
char *e = "CVMVFTVSCSKMSSIVDRDDSSIFDGLVEEDDKDKAKRVSRNKSEKKRRDQFNVLIKELG"
"XXXXXXXXXXXXXXXXXXXXXXXXXHKETTAQSDASEIRQDWKPTFLSNEEFTQLMLEAL"
"XXXXXXXXXXXXXXXXXXXXXXXXEHLPSDLVDQSIFNFIPEGEHSEVYKILSTHLLESD"
"XXXXXXXXXXXXXXXXXXXXXXXIDPKEPSTYEYVRFIGNFKSLTSVSTSTHNGFEGTIQ"
"XXXXXXXXXXXXXXXXXXXXXXQFIKEMCTVEEPNEEFTSRHSLEWKFLFLDHRAPPIIG"
"XXXXXVXXXXXXXXXXXXXXXNLAKCHEHLMQYGKGKSCYYRFLTKGQQWIWLQTHYYIT"
"XXXXXXXXXXXXXXXXXXXXAEVRAERRRELGIEESLPETAADKSQDSGSDNRINTVSLK"
"XXXXXXXXXXXXXXXXXXXRKSSHTAVSDPSSTPTKIPTDTSTPPRQHLPAHEKMTQRRS"
"XXXXXXXXXXXXXXXXXXPAMSQAANLPIPQGMSQFQFSAQLGAMQHLKDQLEQRTRMIE"
"XXXXXXXXXXXXXXXXXQMVHGQGLQMFLQQSNPGLNFGSVQLSSGNSNIQQLTPVNMQG"
"XXXXXXXXXXXXXXXXQHMIQQQTLQSTSTQQSQQSVMSGHSQQTSLPSQTPSTLTAPLY"
"XXXXXXXXXXXXXXXIPSSMPQNSTQSATVTTFTQDRQIRFSQGQQLVTKLVTAPVACGA"
"XXXXXXXXXXXXXXAYPTFATQQQQAQTLSVTQQQQQQQQQPPQQQQQQQQSSQEQQLPS"
"XXXXXXXXXXXXXQQFLQTSRLLHGNPSTQLILSAAFPLQQSTFPPSHHQQHQPQQQQQL"
"PRHRTDSLTDPSKVQPQ";
a = cloneString(a);
// tolowers(a);
b = cloneString(b);
// tolowers(b);
xenAlignAffine(a, strlen(a), b, strlen(b), axtScoreSchemeProteinDefault(), stdout, FALSE);
}


int main(int argc, char *argv[])
/* Process command line. */
{
pushCarefulMemHandler(100000000);
if (argc != 2)
   usage();
freen(argv[1]);
return 0;
}
