---
title: "UCSC Genome Browser 101"
---

This tutorial is a basic introduction of the most common UCSC Genome Browser usage. This includes the
navigation menu, configuration of the tracks display, and where to find additional resources.

## Sections

Explore each of the three section below to learn the material in a different form.

<div class="row" style="padding-top: 15px">
<div class="col-md-4">
<div class="panel panel-default" style="padding-bottom: 10px">
<h3 class="panel-title" style="width: -webkit-fill-available;"
>Browser Interface Annotated Screenshot</h3>

This 'cheat sheet' highlights and describes the main features and functionalities of
the tracks display.

<p style="text-align: end">
<button>[View](#annotated-screenshot)</button>
</p>
</div>
</div>

<div class="col-md-4">
<div class="panel panel-default" style="padding-bottom: 10px">
<h3 class="panel-title" style="width: -webkit-fill-available;"
>Guided Walkthrough</h3>

A guided walkthrough that explains menu bar navigation, 
as well as using and configuring the tracks display.

<p style="text-align: end">
<button>[View](#guided-walkthrough)</button>
</p>
</div>
</div>

<div class="col-md-4">
<div class="panel panel-default" style="padding-bottom: 10px">
<h3 class="panel-title" style="width: -webkit-fill-available;"
>Interactive Tutorial</h4>

An interactive tutorial that covers the basic Browser introduction on this page.

<p style="text-align: end">
<button>[View](../cgi-bin/hgTracks?startTutorial=true)</button>
</p>
</div>
</div>
</div>

## Annotated Screenshot

```image
src=../images/gb101cheatSheet.png
width=90%
```

## Guided Walkthrough

### Navigating the Menus

<!--
We are going to use bootstrap columns to put the image/text side by side
Alternate the images left/right between different sections, mostly for aesthetics
--->

<div class="row">
<div class="col-md-6">

```image
src=../images/bluebarMenuGif.gif
width=70%
```

</div>
<div class="col-md-6">

The navigation bar at the top of the page will allow you to access our tools, downloads, and help pages.

There are five main drop-downs that are useful for most users:

- Genomes - switch between the many genomes available.
- Genome Browser - configure, search for tracks, and reset the Genome Browser back to the default settings.
- Tools - access to features such as [BLAT](../cgi-bin/hgBlat), [isPCR](../cgi-bin/hgPcr), and [LiftOver](../cgi-bin/hgLiftOver). The [Table Browser](../cgi-bin/hgTables) can also export track data in various file formats.
- My Data - create stable short links ([Sessions](../cgi-bin/hgSession)) and visualize your own data via [custom tracks](../cgi-bin/hgCustom) or [track hubs](../cgi-bin/hgHubConnect).
- Help - access contact information, FAQs, and Browser Documentation.

</div>
</div>

---
### Using the Search Box

<div class="row">
<div class="col-md-6">

The search bar allows you to navigate to a region on the genome using [genome coordinates](https://genome-blog.soe.ucsc.edu/blog/2016/12/12/the-ucsc-genome-browser-coordinate-counting-systems/),
[gene symbols](https://genome.ucsc.edu/FAQ/FAQgenes.html#genename),
[rsIDs](https://www.ncbi.nlm.nih.gov/snp/docs/RefSNP_about/#what-is-a-reference-snp),
[HGVS](http://varnomen.hgvs.org/) terms, or DNA sequence. You can even
search documentation and FAQ pages using this search bar. A few example queries
are:

- chr1:127140001-127140001
- SOD1
- rs2569190
- NM_198056.3:c.1654G>T
- CCTTCCTATAGTCCGGAATACGCC
AATGGCGCGGCCGGCCTGGACC
ACTCCCATTACGGGGGTGTCCC
GGGCAGCGGGGCCGGAGGCTTA
ATGCAAAGGC



Please note, [BLAT](https://genome.ucsc.edu/goldenPath/help/hgTracksHelp.html#BLATAlign)
is used if your search term is a DNA sequence. For the best
results, make sure your sequence is long enough to meet BLAT specifications.
The [examples](https://genome.ucsc.edu/goldenPath/help/query.html)
link next to the search bar contains even more search queries.

</div>
<div class="col-md-6">

```image
src=../images/hgTracksSearchBarExample.png
width=95%
```

</div>
</div>

---
### Highlights and Zooming

<div class="row">
<div class="col-md-6">

```image
src=../images/highlightZoomGif.gif
width=100%
```

</div>
<div class="col-md-6">

Dragging the Genome Browser image performs different tasks depending on where and how you click the image.

Click-and-Drag the ruler at the top of the image will bring up a menu to zoom
into or highlight the region. Click-and-Drag anywhere else on the Genome
Browser image to scroll to the left or right.

Alternatively, you can:

- Hold **Alt+drag** or **Option+drag** to highlight
- Hold **Ctrl+drag** or **Cmd+drag** to zoom

</div>
</div>

---
### Configuring Data Track Display

<div class="row">
<div class="col-md-6">

Clicking on the rectangle box next to a track is an easy way to go to that
track's settings page quickly.

[Right-clicking](../goldenPath/help/hgTracksHelp.html#RIGHT_CLICK_NAV)
on the track will also bring up a menu to change the display
mode, configure a track, or view a PNG image of the current window.

</div>
<div class="col-md-6">

```image
src=../images/rightClickAndGreyBarGif.gif
width=95%
```

</div>
</div>

---
### Track Display Modes

<div class="row">
<div class="col-md-6">

```image
src=../images/trackVisExamples.png
width=95%
```

</div>
<div class="col-md-6">

Annotation tracks can be entirely hidden or shown in four different ways that
take an increasing amount of vertical space: 
[dense, squish, pack, and full](../goldenPath/help/hgTracksHelp.html#TRACK_CONT).

*Pack display is the recommended visibility for most data types as it provides
the best balance of information and space.*

After changing a track's display mode, the change will not be applied until you
refresh the page. You can either refresh the page manually using your web
browser or click <button>refresh</button> on any of the track groups.

</div>
</div>

---
### Searching for Data Tracks

<div class="row">
<div class="col-md-6">

Having trouble finding a dataset for your genome assembly? The 
[Track Search](../cgi-bin/hgTracks?hgt_tSearch=track+search)
feature allows searching for terms in track names, descriptions, groups, and
ENCODE metadata.

More information about <button>track search</button> can be found on the following
[help page](../goldenPath/help/trackSearch.html). The Track Search feature can
also be accessed by hovering over the "Genome Browser" drop-down menu.

</div>
<div class="col-md-6">

```image
src=../images/trackSearchSimpleExample.png
width=90%
```

</div>
</div>

---
### Configuring the Genome Browser Display

<div class="row">
<div class="col-md-6">

```image
src=../images/configureGif.gif
width=90%
```

</div>
<div class="col-md-6">

Use the <button>configure</button> button to customize graphic font, size, gridlines, and more.
This can be helpful when exporting an image for publication.

You can also find a link to configure the browser image by hovering over the
"Genome Browser" drop-down menu.

</div>
</div>

---
### Viewing the Reverse Strand

<div class="row">
<div class="col-md-6">

By default, the UCSC Genome Browser displays the forward strand (5' to 3') but
can be configured to display the negative strand (3' to 5').

To reverse the genome orientation, click the <button>reverse</button> button, and the Genome
Browser image will flip to show either the negative or positive strand.

</div>
<div class="col-md-6">

```image
src=../images/reverseStrand.png
width=90%
```

</div>
</div>

---
### Getting Help Using the Genome Browser

<div class="row">
<div class="col-md-6">

```image
src=../images/gettingHelp.png
width=40%
```

</div>
<div class="col-md-6">

The [training page](../training/) has other guides and training videos. You can
also search the [mailing list archive](https://groups.google.com/a/soe.ucsc.edu/g/genome)
for previously answered questions.

If you still have questions after searching the [FAQ page](../FAQ/) or
[Genome Browser User Guide](../goldenPath/help/hgTracksHelp.html) pages,
you can email the suitable mailing list for your inquiry from the
[Contact Us](../contacts.html) page.

Follow our [citation guidelines](../cite.html) when using the Genome Browser
tool suite or data from the UCSC Genome Browser database in a research work
that will be published in a journal or on the Internet.

In addition to the [relevant paper](goldenPath/pubs.html), please reference the Genome Browser website
in your manuscript: *http://genome.ucsc.edu*.

</div>
</div>
