/* dgv.c was originally generated by the autoSql program, which also 
 * generated dgv.h and dgv.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "dgv.h"


void dgvStaticLoad(char **row, struct dgv *ret)
/* Load a row from dgv table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->itemRgb = sqlUnsigned(row[8]);
ret->landmark = row[9];
ret->varType = row[10];
ret->reference = row[11];
ret->pubMedId = sqlUnsigned(row[12]);
ret->method = row[13];
ret->sample = row[14];
}

struct dgv *dgvLoad(char **row)
/* Load a dgv from row fetched with select * from dgv
 * from database.  Dispose of this with dgvFree(). */
{
struct dgv *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->itemRgb = sqlUnsigned(row[8]);
ret->landmark = cloneString(row[9]);
ret->varType = cloneString(row[10]);
ret->reference = cloneString(row[11]);
ret->pubMedId = sqlUnsigned(row[12]);
ret->method = cloneString(row[13]);
ret->sample = cloneString(row[14]);
return ret;
}

struct dgv *dgvLoadAll(char *fileName) 
/* Load all dgv from a whitespace-separated file.
 * Dispose of this with dgvFreeList(). */
{
struct dgv *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[15];

while (lineFileRow(lf, row))
    {
    el = dgvLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct dgv *dgvLoadAllByChar(char *fileName, char chopper) 
/* Load all dgv from a chopper separated file.
 * Dispose of this with dgvFreeList(). */
{
struct dgv *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[15];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = dgvLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct dgv *dgvCommaIn(char **pS, struct dgv *ret)
/* Create a dgv out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dgv */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->itemRgb = sqlUnsignedComma(&s);
ret->landmark = sqlStringComma(&s);
ret->varType = sqlStringComma(&s);
ret->reference = sqlStringComma(&s);
ret->pubMedId = sqlUnsignedComma(&s);
ret->method = sqlStringComma(&s);
ret->sample = sqlStringComma(&s);
*pS = s;
return ret;
}

void dgvFree(struct dgv **pEl)
/* Free a single dynamically allocated dgv such as created
 * with dgvLoad(). */
{
struct dgv *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->landmark);
freeMem(el->varType);
freeMem(el->reference);
freeMem(el->method);
freeMem(el->sample);
freez(pEl);
}

void dgvFreeList(struct dgv **pList)
/* Free a list of dynamically allocated dgv's */
{
struct dgv *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    dgvFree(&el);
    }
*pList = NULL;
}

void dgvOutput(struct dgv *el, FILE *f, char sep, char lastSep) 
/* Print out dgv.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%u", el->itemRgb);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->landmark);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->varType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->reference);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->pubMedId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->method);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sample);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

