/* improbRunInfo.h was originally generated by the autoSql program, which also 
 * generated improbRunInfo.c and improbRunInfo.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef IMPROBRUNINFO_H
#define IMPROBRUNINFO_H

struct improbRunInfo
/* Information on one Improbizer run plus motifs. */
    {
    struct improbRunInfo *next;  /* Next in singly linked list. */
    char *name;	/* Motif name. */
    float runScore;	/* Score of motifFound. */
    float bestControlScore;	/* Score of best control run. */
    float meanControlScore;	/* Mean of control runs. */
    float sdControlScore;	/* Control run standard deviation. */
    int seqCount;	/* Number of sequences used to generate it. */
    char *consensus;	/* Motif consensus sequence. */
    float runPos;	/* Position of motif in run. */
    float runPosSd;	/* Standard deviation of position in run. */
    int columnCount;	/* Count of columns in motif. */
    float *aProb;	/* Probability of A's in each column. */
    float *cProb;	/* Probability of C's in each column. */
    float *gProb;	/* Probability of G's in each column. */
    float *tProb;	/* Probability of T's in each column. */
    int controlCount;	/* Count of controls. */
    float *controlScores;	/* Scores of controls. */
    };

#define improbRunInfoRowSize 16  /* Number of stored fields, not including next */

struct improbRunInfo *improbRunInfoLoad(char **row);
/* Load a improbRunInfo from row fetched with select * from improbRunInfo
 * from database.  Dispose of this with improbRunInfoFree(). */

struct improbRunInfo *improbRunInfoLoadAll(char *fileName);
/* Load all improbRunInfo from a tab-separated file.
 * Dispose of this with improbRunInfoFreeList(). */

struct improbRunInfo *improbRunInfoLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all improbRunInfo from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with improbRunInfoFreeList(). */

struct improbRunInfo *improbRunInfoCommaIn(char **pS, struct improbRunInfo *ret);
/* Create a improbRunInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new improbRunInfo */

void improbRunInfoFree(struct improbRunInfo **pEl);
/* Free a single dynamically allocated improbRunInfo such as created
 * with improbRunInfoLoad(). */

void improbRunInfoFreeList(struct improbRunInfo **pList);
/* Free a list of dynamically allocated improbRunInfo's */

void improbRunInfoOutput(struct improbRunInfo *el, FILE *f, char sep, char lastSep);
/* Print out improbRunInfo.  Separate fields with sep. Follow last field with lastSep. */

#define improbRunInfoTabOut(el,f) improbRunInfoOutput(el,f,'\t','\n');
/* Print out improbRunInfo as a line in a tab-separated file. */

#define improbRunInfoCommaOut(el,f) improbRunInfoOutput(el,f,',',',');
/* Print out improbRunInfo as a comma separated list including final comma. */

#endif /* IMPROBRUNINFO_H */

