/* bigChain.h was originally generated by the autoSql program, which also 
 * generated bigChain.c and bigChain.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BIGCHAIN_H
#define BIGCHAIN_H

#define BIGCHAIN_NUM_COLS 12

extern char *bigChainCommaSepFieldNames;

struct bigChain
/* bigChain pairwise alignment */
    {
    struct bigChain *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name or ID of item, ideally both human readable and unique */
    unsigned score;	/* Score (0-1000) */
    char strand[2];	/* + or - for strand */
    unsigned tSize;	/* size of target sequence */
    char *qName;	/* name of query sequence */
    unsigned qSize;	/* size of query sequence */
    unsigned qStart;	/* start of alignment on query sequence */
    unsigned qEnd;	/* end of alignment on query sequence */
    double chainScore;	/* score from chain */
    };

void bigChainStaticLoad(char **row, struct bigChain *ret);
/* Load a row from bigChain table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bigChain *bigChainLoad(char **row);
/* Load a bigChain from row fetched with select * from bigChain
 * from database.  Dispose of this with bigChainFree(). */

struct bigChain *bigChainLoadAll(char *fileName);
/* Load all bigChain from whitespace-separated file.
 * Dispose of this with bigChainFreeList(). */

struct bigChain *bigChainLoadAllByChar(char *fileName, char chopper);
/* Load all bigChain from chopper separated file.
 * Dispose of this with bigChainFreeList(). */

#define bigChainLoadAllByTab(a) bigChainLoadAllByChar(a, '\t');
/* Load all bigChain from tab separated file.
 * Dispose of this with bigChainFreeList(). */

struct bigChain *bigChainCommaIn(char **pS, struct bigChain *ret);
/* Create a bigChain out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bigChain */

void bigChainFree(struct bigChain **pEl);
/* Free a single dynamically allocated bigChain such as created
 * with bigChainLoad(). */

void bigChainFreeList(struct bigChain **pList);
/* Free a list of dynamically allocated bigChain's */

void bigChainOutput(struct bigChain *el, FILE *f, char sep, char lastSep);
/* Print out bigChain.  Separate fields with sep. Follow last field with lastSep. */

#define bigChainTabOut(el,f) bigChainOutput(el,f,'\t','\n');
/* Print out bigChain as a line in a tab-separated file. */

#define bigChainCommaOut(el,f) bigChainOutput(el,f,',',',');
/* Print out bigChain as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

int bigChainCmpTarget(const void *va, const void *vb);
/* Compare to sort based on target position. */

char *bigChainGetLinkFile(char *chainBigBedName);
/* Construct the file name of the chain link file from the name of a chain file. 
 * That is, change file.bb to file.link.bb */

#endif /* BIGCHAIN_H */

