/* cartDb.h was originally generated by the autoSql program, which also 
 * generated cartDb.c and cartDb.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef CARTDB_H
#define CARTDB_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

struct cartDb
/* A simple id/contents pair for persistent storing of cart variables */
    {
    struct cartDb *next;  /* Next in singly linked list. */
    unsigned int id;	/* Cart ID */
    char *contents;	/* Contents - encoded variables */
    int reserved;	/* Reserved, currently always zero. */
    char *firstUse;	/* First time this was used */
    char *lastUse;	/* Last time this was used */
    int useCount;	/* Number of times used */
    char *sessionKey;	/* Random Key for session security */
    };

boolean cartDbHasSessionKey(struct sqlConnection *conn, char *table);
/* Check to see if the table has the sessionKey field */

boolean cartDbUseSessionKey();
/* Check settings and and state to determine if sessionKey is in use */

void cartDbSecureId(char *buf, int bufSize, struct cartDb *cartDb);
/* Return combined string of session id plus sessionKey in buf if turned on.*/

unsigned int cartDbParseId(char *id, char **pSessionKey);
/* Parse out and return just the numeric id from the id_sessionKey string. */

void cartDbStaticLoad(char **row, struct cartDb *ret);
/* Load a row from cartDb table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cartDb *cartDbLoad(char **row);
/* Load a cartDb from row fetched with select * from cartDb
 * from database.  Dispose of this with cartDbFree(). */

struct cartDb *cartDbLoadAll(char *fileName);
/* Load all cartDb from a tab-separated file.
 * Dispose of this with cartDbFreeList(). */

struct cartDb *cartDbLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all cartDb from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with cartDbFreeList(). */

struct cartDb *cartDbCommaIn(char **pS, struct cartDb *ret);
/* Create a cartDb out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cartDb */

void cartDbFree(struct cartDb **pEl);
/* Free a single dynamically allocated cartDb such as created
 * with cartDbLoad(). */

void cartDbFreeList(struct cartDb **pList);
/* Free a list of dynamically allocated cartDb's */

void cartDbOutput(struct cartDb *el, FILE *f, char sep, char lastSep);
/* Print out cartDb.  Separate fields with sep. Follow last field with lastSep. */

#define cartDbTabOut(el,f) cartDbOutput(el,f,'\t','\n');
/* Print out cartDb as a line in a tab-separated file. */

#define cartDbCommaOut(el,f) cartDbOutput(el,f,',',',');
/* Print out cartDb as a comma separated list including final comma. */

#define sessionDbTableConfVariable      "sessionDbName"
#define defaultSessionDbTableName  "sessionDb"
#define userDbTableConfVariable         "userDbName"
#define defaultUserDbTableName     "userDb"
#define defaultCartTableConfVariable         "defaultCartName"
#define defaultDefaultCartTableName     "defaultCart"

char *sessionDbTable();
/* Return the name of the sessionDb table. */

char *userDbTable();
/* Return the name of the userDb table. */

char *defaultCartTable();
/* Return the name of the defaultCart table. */
#endif /* CARTDB_H */

