/* gbMiscDiff.h was originally generated by the autoSql program, which also 
 * generated gbMiscDiff.c and gbMiscDiff.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2006 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef GBMISCDIFF_H
#define GBMISCDIFF_H

#define GBMISCDIFF_NUM_COLS 6

struct gbMiscDiff
/* misc_difference annotations from Genbank */
    {
    struct gbMiscDiff *next;  /* Next in singly linked list. */
    char acc[13];	/* Genbank accession */
    int mrnaStart;	/* start within mRNA */
    int mrnaEnd;	/* end within mRNA */
    char *notes;	/* notes */
    char *gene;	/* gene name */
    char *replacement;	/* replace */
    };

void gbMiscDiffStaticLoad(char **row, struct gbMiscDiff *ret);
/* Load a row from gbMiscDiff table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct gbMiscDiff *gbMiscDiffLoad(char **row);
/* Load a gbMiscDiff from row fetched with select * from gbMiscDiff
 * from database.  Dispose of this with gbMiscDiffFree(). */

struct gbMiscDiff *gbMiscDiffLoadAll(char *fileName);
/* Load all gbMiscDiff from whitespace-separated file.
 * Dispose of this with gbMiscDiffFreeList(). */

struct gbMiscDiff *gbMiscDiffLoadAllByChar(char *fileName, char chopper);
/* Load all gbMiscDiff from chopper separated file.
 * Dispose of this with gbMiscDiffFreeList(). */

#define gbMiscDiffLoadAllByTab(a) gbMiscDiffLoadAllByChar(a, '\t');
/* Load all gbMiscDiff from tab separated file.
 * Dispose of this with gbMiscDiffFreeList(). */

struct gbMiscDiff *gbMiscDiffCommaIn(char **pS, struct gbMiscDiff *ret);
/* Create a gbMiscDiff out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gbMiscDiff */

void gbMiscDiffFree(struct gbMiscDiff **pEl);
/* Free a single dynamically allocated gbMiscDiff such as created
 * with gbMiscDiffLoad(). */

void gbMiscDiffFreeList(struct gbMiscDiff **pList);
/* Free a list of dynamically allocated gbMiscDiff's */

void gbMiscDiffOutput(struct gbMiscDiff *el, FILE *f, char sep, char lastSep);
/* Print out gbMiscDiff.  Separate fields with sep. Follow last field with lastSep. */

#define gbMiscDiffTabOut(el,f) gbMiscDiffOutput(el,f,'\t','\n');
/* Print out gbMiscDiff as a line in a tab-separated file. */

#define gbMiscDiffCommaOut(el,f) gbMiscDiffOutput(el,f,',',',');
/* Print out gbMiscDiff as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* GBMISCDIFF_H */

