/* snp132Ext.h was originally generated by the autoSql program, which also 
 * generated snp132Ext.c and snp132Ext.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2010 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef SNP132EXT_H
#define SNP132EXT_H

#define SNP132EXT_NUM_COLS 25

struct snp132Ext
/* Polymorphism data from dbSNP */
    {
    struct snp132Ext *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* dbSNP Reference SNP (rs) identifier */
    unsigned score;	/* Not used */
    char *strand;	/* Which DNA strand contains the observed alleles */
    char *refNCBI;	/* Reference genomic sequence from dbSNP */
    char *refUCSC;	/* Reference genomic sequence from UCSC lookup of chrom,chromStart,chromEnd */
    char *observed;	/* The sequences of the observed alleles from rs-fasta files */
    char *molType;	/* Sample type from exemplar submitted SNPs (ss) */
    char *class;	/* Class of variant (single, in-del, named, mixed, etc.) */
    char *valid;	/* Validation status of the SNP */
    float avHet;	/* Average heterozygosity from all observations.  Note: may be computed on small number of samples. */
    float avHetSE;	/* Standard Error for the average heterozygosity */
    char *func;	/* Functional category of the SNP (coding-synon, coding-nonsynon, intron, etc.) */
    char *locType;	/* Type of mapping inferred from size on reference; may not agree with class */
    unsigned weight;	/* The quality of the alignment: 1 = unique mapping, 2 = non-unique, 3 = many matches */
    char *exceptions;	/* Unusual conditions noted by UCSC that may indicate a problem with the data */
    int submitterCount;	/* Number of distinct submitter handles for submitted SNPs for this ref SNP */
    char **submitters;	/* List of submitter handles */
    int alleleFreqCount;	/* Number of observed alleles with frequency data */
    char **alleles;	/* Observed alleles for which frequency data are available */
    float *alleleNs;	/* Count of chromosomes (2N) on which each allele was observed. Note: this is extrapolated by dbSNP from submitted frequencies and total sample 2N, and is not always an integer. */
    float *alleleFreqs;	/* Allele frequencies */
    char *bitfields;	/* SNP attributes extracted from dbSNP's SNP_bitfield table */
    };

struct snp132Ext *snp132ExtLoad(char **row);
/* Load a snp132Ext from row fetched with select * from snp132Ext
 * from database.  Dispose of this with snp132ExtFree(). */

struct snp132Ext *snp132ExtLoadAll(char *fileName);
/* Load all snp132Ext from whitespace-separated file.
 * Dispose of this with snp132ExtFreeList(). */

struct snp132Ext *snp132ExtLoadAllByChar(char *fileName, char chopper);
/* Load all snp132Ext from chopper separated file.
 * Dispose of this with snp132ExtFreeList(). */

#define snp132ExtLoadAllByTab(a) snp132ExtLoadAllByChar(a, '\t');
/* Load all snp132Ext from tab separated file.
 * Dispose of this with snp132ExtFreeList(). */

struct snp132Ext *snp132ExtCommaIn(char **pS, struct snp132Ext *ret);
/* Create a snp132Ext out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new snp132Ext */

void snp132ExtFree(struct snp132Ext **pEl);
/* Free a single dynamically allocated snp132Ext such as created
 * with snp132ExtLoad(). */

void snp132ExtFreeList(struct snp132Ext **pList);
/* Free a list of dynamically allocated snp132Ext's */

void snp132ExtOutput(struct snp132Ext *el, FILE *f, char sep, char lastSep);
/* Print out snp132Ext.  Separate fields with sep. Follow last field with lastSep. */

#define snp132ExtTabOut(el,f) snp132ExtOutput(el,f,'\t','\n');
/* Print out snp132Ext as a line in a tab-separated file. */

#define snp132ExtCommaOut(el,f) snp132ExtOutput(el,f,',',',');
/* Print out snp132Ext as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* SNP132EXT_H */

