/* synMap.h was originally generated by the autoSql program, which also 
 * generated synMap.c and synMap.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2002 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef SYNMAP_H
#define SYNMAP_H

struct synMap
/* Synteny map from one genome to another */
    {
    struct synMap *next;  /* Next in singly linked list. */
    char *chromA;	/* chromosome in organism A */
    unsigned chromStartA;	/* chromosome start in orgainsm A */
    unsigned chromEndA;	/* chromosome end in orgainsm A */
    char *strandA;	/* Strand information can be things like '-+' */
    char *chromB;	/* chromosome in organism B */
    unsigned chromStartB;	/* chromosome start in orgainsm B */
    unsigned chromEndB;	/* chromosome end in orgainsm B */
    };

void synMapStaticLoad(char **row, struct synMap *ret);
/* Load a row from synMap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct synMap *synMapLoad(char **row);
/* Load a synMap from row fetched with select * from synMap
 * from database.  Dispose of this with synMapFree(). */

struct synMap *synMapLoadAll(char *fileName);
/* Load all synMap from a tab-separated file.
 * Dispose of this with synMapFreeList(). */

struct synMap *synMapCommaIn(char **pS, struct synMap *ret);
/* Create a synMap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new synMap */

void synMapFree(struct synMap **pEl);
/* Free a single dynamically allocated synMap such as created
 * with synMapLoad(). */

void synMapFreeList(struct synMap **pList);
/* Free a list of dynamically allocated synMap's */

void synMapOutput(struct synMap *el, FILE *f, char sep, char lastSep);
/* Print out synMap.  Separate fields with sep. Follow last field with lastSep. */

#define synMapTabOut(el,f) synMapOutput(el,f,'\t','\n');
/* Print out synMap as a line in a tab-separated file. */

#define synMapCommaOut(el,f) synMapOutput(el,f,',',',');
/* Print out synMap as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* SYNMAP_H */

