/* taxonGeneticCode.h was originally generated by the autoSql program, which also 
 * generated taxonGeneticCode.c and taxonGeneticCode.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef TAXONGENETICCODE_H
#define TAXONGENETICCODE_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define TAXONGENETICCODE_NUM_COLS 6

struct taxonGeneticCode
/* nbci genetic code table */
    {
    struct taxonGeneticCode *next;  /* Next in singly linked list. */
    unsigned id;	/* genetic code id in GenBank taxonomy database */
    char *abbr;	/* division code 3 characters  */
    char *name;	/* division name e.g. BCT, PLN, VRT, MAM, PRI... */
    char *tranlsation;	/* translation table for this genetic code (one AA per codon 1-64) */
    char *starts;	/* start codons for this genetic code (one AA per codon 1-64) */
    char *comments;	/* free-text comments  */
    };

void taxonGeneticCodeStaticLoad(char **row, struct taxonGeneticCode *ret);
/* Load a row from taxonGeneticCode table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct taxonGeneticCode *taxonGeneticCodeLoad(char **row);
/* Load a taxonGeneticCode from row fetched with select * from taxonGeneticCode
 * from database.  Dispose of this with taxonGeneticCodeFree(). */

struct taxonGeneticCode *taxonGeneticCodeLoadAll(char *fileName);
/* Load all taxonGeneticCode from whitespace-separated file.
 * Dispose of this with taxonGeneticCodeFreeList(). */

struct taxonGeneticCode *taxonGeneticCodeLoadAllByChar(char *fileName, char chopper);
/* Load all taxonGeneticCode from chopper separated file.
 * Dispose of this with taxonGeneticCodeFreeList(). */

#define taxonGeneticCodeLoadAllByTab(a) taxonGeneticCodeLoadAllByChar(a, '\t');
/* Load all taxonGeneticCode from tab separated file.
 * Dispose of this with taxonGeneticCodeFreeList(). */

struct taxonGeneticCode *taxonGeneticCodeLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all taxonGeneticCode from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with taxonGeneticCodeFreeList(). */

void taxonGeneticCodeSaveToDb(struct sqlConnection *conn, struct taxonGeneticCode *el, char *tableName, int updateSize);
/* Save taxonGeneticCode as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct taxonGeneticCode *taxonGeneticCodeCommaIn(char **pS, struct taxonGeneticCode *ret);
/* Create a taxonGeneticCode out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new taxonGeneticCode */

void taxonGeneticCodeFree(struct taxonGeneticCode **pEl);
/* Free a single dynamically allocated taxonGeneticCode such as created
 * with taxonGeneticCodeLoad(). */

void taxonGeneticCodeFreeList(struct taxonGeneticCode **pList);
/* Free a list of dynamically allocated taxonGeneticCode's */

void taxonGeneticCodeOutput(struct taxonGeneticCode *el, FILE *f, char sep, char lastSep);
/* Print out taxonGeneticCode.  Separate fields with sep. Follow last field with lastSep. */

#define taxonGeneticCodeTabOut(el,f) taxonGeneticCodeOutput(el,f,'\t','\n');
/* Print out taxonGeneticCode as a line in a tab-separated file. */

#define taxonGeneticCodeCommaOut(el,f) taxonGeneticCodeOutput(el,f,',',',');
/* Print out taxonGeneticCode as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* TAXONGENETICCODE_H */

