/* chainArrange.c was originally generated by the autoSql program, which also 
 * generated chainArrange.h and chainArrange.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "chainArrange.h"



char *chainArrangeCommaSepFieldNames = "chrom,chromStart,chromEnd,name,score,strand,thickStart,thickEnd,itemRgb,source,querySize,label";

void chainArrangeStaticLoad(char **row, struct chainArrange *ret)
/* Load a row from chainArrange table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->itemRgb = sqlUnsigned(row[8]);
ret->source = row[9];
ret->querySize = sqlUnsigned(row[10]);
ret->label = row[11];
}

struct chainArrange *chainArrangeLoad(char **row)
/* Load a chainArrange from row fetched with select * from chainArrange
 * from database.  Dispose of this with chainArrangeFree(). */
{
struct chainArrange *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->itemRgb = sqlUnsigned(row[8]);
ret->source = cloneString(row[9]);
ret->querySize = sqlUnsigned(row[10]);
ret->label = cloneString(row[11]);
return ret;
}

struct chainArrange *chainArrangeLoadAll(char *fileName) 
/* Load all chainArrange from a whitespace-separated file.
 * Dispose of this with chainArrangeFreeList(). */
{
struct chainArrange *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileRow(lf, row))
    {
    el = chainArrangeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct chainArrange *chainArrangeLoadAllByChar(char *fileName, char chopper) 
/* Load all chainArrange from a chopper separated file.
 * Dispose of this with chainArrangeFreeList(). */
{
struct chainArrange *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = chainArrangeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct chainArrange *chainArrangeCommaIn(char **pS, struct chainArrange *ret)
/* Create a chainArrange out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new chainArrange */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->itemRgb = sqlUnsignedComma(&s);
ret->source = sqlStringComma(&s);
ret->querySize = sqlUnsignedComma(&s);
ret->label = sqlStringComma(&s);
*pS = s;
return ret;
}

void chainArrangeFree(struct chainArrange **pEl)
/* Free a single dynamically allocated chainArrange such as created
 * with chainArrangeLoad(). */
{
struct chainArrange *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->source);
freeMem(el->label);
freez(pEl);
}

void chainArrangeFreeList(struct chainArrange **pList)
/* Free a list of dynamically allocated chainArrange's */
{
struct chainArrange *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    chainArrangeFree(&el);
    }
*pList = NULL;
}

void chainArrangeOutput(struct chainArrange *el, FILE *f, char sep, char lastSep) 
/* Print out chainArrange.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%u", el->itemRgb);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->source);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->querySize);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->label);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

