# encodePrimateAlleles.sql was originally generated by the autoSql program, which also 
# generated encodePrimateAlleles.c and encodePrimateAlleles.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Primate (chimp and macaque) alleles for ENCODE resequencing SNPs
CREATE TABLE encodePrimateAlleles (
    bin int unsigned not null,
    chrom varchar(255) not null,	# Chromosome
    chromStart int unsigned not null,	# Start position in chrom
    chromEnd int unsigned not null,	# End position in chrom
    name varchar(255) not null,	# Name of SNP - rsId or temporary name
    score int unsigned not null,	# 0
    strand char(1) not null,	# + or -
    refAllele char(1) not null,	# A, C, G, or T
    otherAllele char(1) not null,	# A, C, G, or T
    chimpChrom varchar(255) not null,	# Chimp Chromosome
    chimpPos int unsigned not null,	# End position in himpChrom
    chimpStrand char(1) not null,	# + or - or .
    chimpAllele varchar(255) not null,	# A, C, G, T, a, c, g, t, or .
    chimpQual int unsigned not null,	# Chimp quality score
    rhesusChrom varchar(255) not null,	# Rhesus Chromosome
    rhesusPos int unsigned not null,	# End position in rhesusChrom
    rhesusStrand char(1) not null,	# + or - or .
    rhesusAllele varchar(255) not null,	# A, C, G, T, a, c, g, t, or .
    rhesusQual int unsigned not null,	# Rhesus quality score
              #Indices
    INDEX chrom      (chrom,bin),
    INDEX chromStart (chrom,chromStart),
    INDEX name       (name)
);
