# wgEncodeGencodeAttrs.sql was originally generated by the autoSql program, which also 
# generated wgEncodeGencodeAttrs.c and wgEncodeGencodeAttrs.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Basic set of attributes associated with all Gencode transcripts.
CREATE TABLE wgEncodeGencodeAttrs (
    geneId varchar(255) not null,	# Gene identifier
    geneName varchar(255) not null,	# Gene name
    geneType varchar(255) not null,	# BioType of gene
    geneStatus varchar(255) not null,	# Status of gene (obsolete)
    transcriptId varchar(255) not null,	# Transcript identifier
    transcriptName varchar(255) not null,	# Transcript name
    transcriptType varchar(255) not null,	# BioType of transcript
    transcriptStatus varchar(255) not null,	# Status of transcript (obsolete)
    havanaGeneId varchar(255) not null,	# HAVANA identifier if gene is in HAVANA
    havanaTranscriptId varchar(255) not null,	# HAVANA identifier if transcript is in HAVANA
    ccdsId varchar(255) not null,	# CCDS identifier if transcript is in CCDS
    level int not null,	# GENCODE level: 1 = experimental confirmed, 2 = manual, 3 = automated
    transcriptClass varchar(255) not null,	# high level type of transcript
    proteinId varchar(255) not null,	# Protein identifier (not loaded on many older versions of GENCODE)
    transcriptRank int not null,	# Rank of transcript within the gene, smaller is more preferred
              #Indices
    index(geneId),
    index(geneName),
    PRIMARY KEY(transcriptId),
    index(havanaGeneId),
    index(havanaTranscriptId),
    index(ccdsId),
    index(proteinId)
);
