/* Copyright (C) 2005 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */


/* rosChr22Dat.c was originally generated by the autoSql program, which also 
 * generated rosChr22Dat.h and rosChr22Dat.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "jksql.h"
#include "rosChr22Dat.h"
#include "hash.h"
struct hash *expNameHash = NULL;
struct hash *expNumHash = NULL;
struct hash *geneNumHash = NULL;
struct hash *geneNameHash = NULL;
static int numTotalExperiments =0;
static int numTotalGenes=0;

void rosChr22DatStaticLoad(char **row, struct rosChr22Dat *ret)
/* Load a row from rosChr22Dat table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->probeType = sqlSigned(row[4]);
ret->labelType = sqlSigned(row[5]);
ret->strand = row[6];
ret->expName = row[7];
ret->fileName = row[8];
ret->exonName = row[9];
ret->controlType = row[10];
ret->probeID = sqlSigned(row[11]);
ret->nSigCy3 = atof(row[12]);
ret->rSigCy3 = atof(row[13]);
ret->pixelsCy3 = sqlSigned(row[14]);
ret->bgrdCy3 = atof(row[15]);
ret->nSigCy5 = atof(row[16]);
ret->rSigCy5 = atof(row[17]);
ret->pixelsCy5 = sqlSigned(row[18]);
ret->bgrdCy5 = atof(row[19]);
ret->logRatio = atof(row[20]);
ret->logError = atof(row[21]);
ret->xdev = atof(row[22]);
ret->pval = atof(row[23]);
}

struct rosChr22Dat *rosChr22DatLoad(char **row)
/* Load a rosChr22Dat from row fetched with select * from rosChr22Dat
 * from database.  Dispose of this with rosChr22DatFree(). */
{
struct rosChr22Dat *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->probeType = sqlSigned(row[4]);
ret->labelType = sqlSigned(row[5]);
ret->strand = cloneString(row[6]);
ret->expName = cloneString(row[7]);
ret->fileName = cloneString(row[8]);
ret->exonName = cloneString(row[9]);
ret->controlType = cloneString(row[10]);
ret->probeID = sqlSigned(row[11]);
ret->nSigCy3 = atof(row[12]);
ret->rSigCy3 = atof(row[13]);
ret->pixelsCy3 = sqlSigned(row[14]);
ret->bgrdCy3 = atof(row[15]);
ret->nSigCy5 = atof(row[16]);
ret->rSigCy5 = atof(row[17]);
ret->pixelsCy5 = sqlSigned(row[18]);
ret->bgrdCy5 = atof(row[19]);
ret->logRatio = atof(row[20]);
ret->logError = atof(row[21]);
ret->xdev = atof(row[22]);
ret->pval = atof(row[23]);
return ret;
}

struct rosChr22Dat *rosChr22DatLoadAll(char *fileName) 
/* Load all rosChr22Dat from a tab-separated file.
 * Dispose of this with rosChr22DatFreeList(). */
{
struct rosChr22Dat *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[24];

while (lineFileRow(lf, row))
    {
    el = rosChr22DatLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct rosChr22Dat *rosChr22DatCommaIn(char **pS, struct rosChr22Dat *ret)
/* Create a rosChr22Dat out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rosChr22Dat */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->probeType = sqlSignedComma(&s);
ret->labelType = sqlSignedComma(&s);
ret->strand = sqlStringComma(&s);
ret->expName = sqlStringComma(&s);
ret->fileName = sqlStringComma(&s);
ret->exonName = sqlStringComma(&s);
ret->controlType = sqlStringComma(&s);
ret->probeID = sqlSignedComma(&s);
ret->nSigCy3 = sqlSignedComma(&s);
ret->rSigCy3 = sqlSignedComma(&s);
ret->pixelsCy3 = sqlSignedComma(&s);
ret->bgrdCy3 = sqlSignedComma(&s);
ret->nSigCy5 = sqlSignedComma(&s);
ret->rSigCy5 = sqlSignedComma(&s);
ret->pixelsCy5 = sqlSignedComma(&s);
ret->bgrdCy5 = sqlSignedComma(&s);
ret->logRatio = sqlSignedComma(&s);
ret->logError = sqlSignedComma(&s);
ret->xdev = sqlSignedComma(&s);
ret->pval = sqlSignedComma(&s);
*pS = s;
return ret;
}

void rosChr22DatFree(struct rosChr22Dat **pEl)
/* Free a single dynamically allocated rosChr22Dat such as created
 * with rosChr22DatLoad(). */
{
struct rosChr22Dat *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->strand);
freeMem(el->expName);
freeMem(el->fileName);
freeMem(el->exonName);
freeMem(el->controlType);
freez(pEl);
}

void rosChr22DatFreeList(struct rosChr22Dat **pList)
/* Free a list of dynamically allocated rosChr22Dat's */
{
struct rosChr22Dat *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    rosChr22DatFree(&el);
    }
*pList = NULL;
}

void rosChr22DatOutput(struct rosChr22Dat *el, FILE *f, char sep, char lastSep) 
/* Print out rosChr22Dat.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->probeType);
fputc(sep,f);
fprintf(f, "%d", el->labelType);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->expName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fileName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->exonName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->controlType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->probeID);
fputc(sep,f);
fprintf(f, "%f", el->nSigCy3);
fputc(sep,f);
fprintf(f, "%f", el->rSigCy3);
fputc(sep,f);
fprintf(f, "%d", el->pixelsCy3);
fputc(sep,f);
fprintf(f, "%f", el->bgrdCy3);
fputc(sep,f);
fprintf(f, "%f", el->nSigCy5);
fputc(sep,f);
fprintf(f, "%f", el->rSigCy5);
fputc(sep,f);
fprintf(f, "%d", el->pixelsCy5);
fputc(sep,f);
fprintf(f, "%f", el->bgrdCy5);
fputc(sep,f);
fprintf(f, "%f", el->logRatio);
fputc(sep,f);
fprintf(f, "%f", el->logError);
fputc(sep,f);
fprintf(f, "%f", el->xdev);
fputc(sep,f);
fprintf(f, "%f", el->pval);
fputc(lastSep,f);
}


void createExpNameHash() 
{ 
int i=0;
char buff[32];
expNameHash = newHash(0);

sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "K562_RT_vs_Jurkat_RT");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Hep");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Testes_vs_Uterus");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Stomach_vs_Spinal_Chord");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Salivary_Gland_vs_Skeletal_Muscle");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Prostate_vs_Placenta");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pituitary_Gland_vs_Melanoma");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Lung_Carcinoma_vs_Lung");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Fetal_Liver_vs_Liver");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Bone_marrow_vs_Adrenal_Gland");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_vs_Heart");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(amygdala)_vs_Thymus");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(caudate_nucleus)_vs_Thyroid");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(cerebellum)_vs_Pancreas");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(corpus_callosum)_vs_Lymph_node");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(substantia_nigra)_vs_Kidney");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(thalamus)_vs_Fetal_lung");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Colorectal_adenocarcinoma_vs_Trachea");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Hela_cell_vs_Small_intestine");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Lymphoma_(Burkitt_Daudi)_vs_Leukemia_(lymphoblastic)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Lymphoma_(Burkitt_Raji)_vs_Leukemia_(promyelocytic)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Fetal_Kidney_vs_Fetal_Brain");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(amygdala)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(caudate_nucleus)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(cerebellum)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(corpus_callosum)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(substantia_nigra)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(thalamus)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Adrenal_Gland");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Bone_Marrow");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Colorectal_Adenocarcinoma");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Fetal_Brain");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Fetal_Kidney");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Fetal_Liver");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Leukemia_(Lymphoblastic)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Leukemia_(Promyelocytic)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Fetal_Lung");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Heart");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Hela_Cell");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Kidney");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Leukemia_(Chronic_Myelogenous)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Placenta");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Prostate");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Salivary_Gland");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Skeletal_Muscle");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Small_Intestine");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Spinal_Chord");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Stomach");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Testes");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Lymphoma_(Burkitt)");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Melanoma");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Pancreas");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Pituitary_Gland");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Liver");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Lung");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Lung_Carcinoma");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Lymph_Node");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Thymus");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Thyroid");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Trachea");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Jurkat_vs_Raji");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Hep_vs_Raji");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "293F_vs_Raji");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "pool_vs_Raji");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Hep_vs_Jurkat");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "K562_Agilent_vs_Jurkat_Agilent");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "293F_vs_Hep");
sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "293F_vs_Jurkat");


/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "293F_vs_Jurkat"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "293F_vs_Hep"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Hep_vs_Jurkat"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "K562_Agilent_vs_Jurkat_Agilent"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "pool_vs_Raji"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "293F_vs_Raji"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Hep_vs_Raji"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Jurkat_vs_Raji"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Trachea"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Thyroid"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Thymus"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Lymph_Node"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Lung_Carcinoma"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Lung"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Liver"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Pituitary_Gland"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Pancreas"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Melanoma"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Lymphoma_(Burkitt)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Testes"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Stomach"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Spinal_Chord"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Small_Intestine"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Prostate"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Placenta"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Skeletal_Muscle"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Salivary_Gland"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Leukemia_(Chronic_Myelogenous)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Kidney"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Hela_Cell"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Heart"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Fetal_Lung"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Leukemia_(Promyelocytic)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Leukemia_(Lymphoblastic)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Fetal_Liver"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Fetal_Kidney"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Fetal_Brain"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Colorectal_Adenocarcinoma"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Bone_Marrow"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Adrenal_Gland"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(thalamus)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(substantia_nigra)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(corpus_callosum)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(cerebellum)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(caudate_nucleus)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Brain_(amygdala)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Fetal_Kidney_vs_Fetal_Brain"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pool_vs_Hep"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Lymphoma_(Burkitt_Raji)_vs_Leukemia_(promyelocytic)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Lymphoma_(Burkitt_Daudi)_vs_Leukemia_(lymphoblastic)"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Hela_cell_vs_Small_intestine"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Colorectal_adenocarcinoma_vs_Trachea"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(thalamus)_vs_Fetal_lung"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(substantia_nigra)_vs_Kidney"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(corpus_callosum)_vs_Lymph_node"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(cerebellum)_vs_Pancreas"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(caudate_nucleus)_vs_Thyroid"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_(amygdala)_vs_Thymus"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Brain_vs_Heart"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Bone_marrow_vs_Adrenal_Gland"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Fetal_Liver_vs_Liver"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Lung_Carcinoma_vs_Lung"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Pituitary_Gland_vs_Melanoma"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Prostate_vs_Placenta"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Salivary_Gland_vs_Skeletal_Muscle"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Stomach_vs_Spinal_Chord"); */
/*  sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "Testes_vs_Uterus"); */
/*sprintf(buff,"%d",i); i++; hashAddUnique(expNameHash, buff, "K562_RT_vs_Jurkat_RT");  */
}

void createExpNumHash()
{
int i=0;
char buff[32];
expNumHash = newHash(0);

sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("K562_RT_vs_Jurkat_RT"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Hep"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Testes_vs_Uterus"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Stomach_vs_Spinal_Chord"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Salivary_Gland_vs_Skeletal_Muscle"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Prostate_vs_Placenta"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pituitary_Gland_vs_Melanoma"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Lung_Carcinoma_vs_Lung"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Fetal_Liver_vs_Liver"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Bone_marrow_vs_Adrenal_Gland"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Brain_vs_Heart"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Brain_(amygdala)_vs_Thymus"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Brain_(caudate_nucleus)_vs_Thyroid"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Brain_(cerebellum)_vs_Pancreas"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Brain_(corpus_callosum)_vs_Lymph_node"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Brain_(substantia_nigra)_vs_Kidney"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Brain_(thalamus)_vs_Fetal_lung"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Colorectal_adenocarcinoma_vs_Trachea"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Hela_cell_vs_Small_intestine"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Lymphoma_(Burkitt_Daudi)_vs_Leukemia_(lymphoblastic)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Lymphoma_(Burkitt_Raji)_vs_Leukemia_(promyelocytic)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Fetal_Kidney_vs_Fetal_Brain"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Brain_(amygdala)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Brain_(caudate_nucleus)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Brain_(cerebellum)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Brain_(corpus_callosum)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Brain_(substantia_nigra)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Brain_(thalamus)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Adrenal_Gland"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Bone_Marrow"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Brain"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Colorectal_Adenocarcinoma"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Fetal_Brain"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Fetal_Kidney"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Fetal_Liver"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Leukemia_(Lymphoblastic)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Leukemia_(Promyelocytic)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Fetal_Lung"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Heart"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Hela_Cell"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Kidney"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Leukemia_(Chronic_Myelogenous)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Placenta"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Prostate"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Salivary_Gland"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Skeletal_Muscle"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Small_Intestine"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Spinal_Chord"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Stomach"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Testes"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Lymphoma_(Burkitt)"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Melanoma"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Pancreas"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Pituitary_Gland"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Liver"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Lung"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Lung_Carcinoma"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Lymph_Node"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Thymus"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Thyroid"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Pool_vs_Trachea"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Jurkat_vs_Raji"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Hep_vs_Raji"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("293F_vs_Raji"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("pool_vs_Raji"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("Hep_vs_Jurkat"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("K562_Agilent_vs_Jurkat_Agilent"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("293F_vs_Hep"), cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(expNumHash, cloneString("293F_vs_Jurkat"), cloneString(buff));

}

void createGeneNameHash()
{
int i=0;
char buff[32];
geneNameHash = newHash(0);

sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("384D8-2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("4E-T"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("A14GALT"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ACO2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ACR"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ADORA2A"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ADRBK2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ADSL"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("AF060862"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("AP1B1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("APOL"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ARFGAP1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ARHGAP8"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ARSA"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ARVCF"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ATF4"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ATP6E"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("BCR"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("BID"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("BIK"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("BK1048E9.5"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("BK126B4.1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("BK65A6.2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("BRD1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("BZRP"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("C.ctg22fin3-000000.7.0"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("C.ctg22fin4-000000.0.0"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("C.ctg22fin4-000000.17.0"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("C.ctg22fin4-000001.17.0"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("C.ctg22fin4-000001.39.0"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("C.ctg22fin4-000001.58.0"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("C22ORF2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("C22ORF3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("C22ORF5"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CACNA1I"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CACNG2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CBX6"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CDC45L"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CECR1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CELSR1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CG12-1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CGI-51"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CGI-56"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CGI-96"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CHKL"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CLDN5"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CLTCL1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("COMT"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CPT1B"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CRKL"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CRYBA4"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CRYBB1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CRYBB2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CRYBB3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CSF2RB"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CSNK1E"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CST"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("CYP2D6"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DDT"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DDX17"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DGCR2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DGCR6"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DGCR8"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DIA1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DJ1042K10.2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DJ37E16.5"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DJ742C19.2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DKFZP434P211"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DMC1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DNAL4"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("DRG1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("E46L"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ECGF1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("EIF3S7"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("EP300"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("EWSR1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("FBLN1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("FBXO7"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("FKSG1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("FLJ10140"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("FLJ20185"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("FLJ20232"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("FLJ20454"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("FLJ20618"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("FLJ20635"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("FLJ20695"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("FLJ20699"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("G22P1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GALR3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GAR22"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GCAT"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GGA1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GGT1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GGTLA1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GIII-SPLA2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GNAZ"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GP1BB"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GPR24"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GRAP2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GSCL"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GSTT1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GSTT2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GTPBP1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("GTSE1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("H1F0"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HCF2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HIRA"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HMG17L1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HMOX1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HRIHFB2122"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HS322B1A"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HS747E2A"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HSN44A4A"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HSPC025"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HSPC051"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HSPC117"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HSPC242"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("HsPOX2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("IGLL1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("IL17R"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("IL2RB"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("KCNJ4"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("KCNMB3L"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("KDELR3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("KIAA0015"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("KIAA0063"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("KIAA0153"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("KIAA0330"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("KIAA0637"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("KIAA0645"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("KIAA0685"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("KIAA0852"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LARGE"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LGALS1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LGALS2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LIF"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LIMK2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LOC51219"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LOC51233"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LOC51733"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LOC55586"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LOC55954"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LOC56993"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LOC57168"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LOC63929"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("LZTR1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MAFF"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MAPK1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MAPK11"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MAPK12"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MAPK8IP2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MB"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MCM5"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MDS019"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MGAT3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MIF"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MIL1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MMP11"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MN1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MSE55"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("MTMR3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("NAGA"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("NCF4"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("NDUFA6"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("NEFH"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("NF2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("NHP2L1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("NIPSNAP1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("NLVCF"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("NPTXR"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("NUP50"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("OSM"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("P2RXL1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PACSIN2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PARVG"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PBI"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PDGFB"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PES1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PIK4CA"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PITPNB"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PK1.3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PKDREJ"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PLA2G6"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PMM1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PNUTL1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("POLR2F"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("POM121L1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PPARA"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PPIL2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PRAME"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PRKCABP"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PRODH"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PSCD4"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("PTD004"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RAB36"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RABL2B"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RAD53"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RANBP1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RANGAP1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RASD1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RAYL"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RBM9"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RBX1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RFPL1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RFPL2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RFPL3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("rhodanese"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RPL3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RRP22"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("RTDR1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SCO2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SDF2L1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SEC14L2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SEP3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SEZ6L"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SF3A1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SH3BP1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SLC16A8"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SLC25A17"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SLC5A1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SLC7A4"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SMARCB1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SMTN"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SNAP29"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SNRPD3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SOX10"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SREBF2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SSTR3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ST13"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SULTX3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SYN3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("SYNGR1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TAB1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TBX1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TCN2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TEF"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TIMP3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TIP39"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TOB2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TOM1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TOP3B"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TPST2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TR"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TST"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TTLL1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TUBA8"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("TXN2"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("UBE2L3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("UFD1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("UPK3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("USP18"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("VPREB3"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("XBP1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("YM-1"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("YWHAH"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ZNF278"));
sprintf(buff,"%d",i++); hashAddUnique(geneNameHash, cloneString(buff), cloneString("ZNF74"));
}
void createGeneNumHash()
{
int i=0;
char buff[32];
geneNumHash = newHash(0);

sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("384D8-2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("4E-T"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("A14GALT"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ACO2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ACR"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ADORA2A"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ADRBK2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ADSL"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("AF060862"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("AP1B1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("APOL"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ARFGAP1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ARHGAP8"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ARSA"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ARVCF"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ATF4"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ATP6E"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("BCR"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("BID"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("BIK"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("BK1048E9.5"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("BK126B4.1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("BK65A6.2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("BRD1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("BZRP"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("C.ctg22fin3-000000.7.0"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("C.ctg22fin4-000000.0.0"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("C.ctg22fin4-000000.17.0"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("C.ctg22fin4-000001.17.0"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("C.ctg22fin4-000001.39.0"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("C.ctg22fin4-000001.58.0"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("C22ORF2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("C22ORF3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("C22ORF5"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CACNA1I"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CACNG2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CBX6"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CDC45L"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CECR1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CELSR1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CG12-1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CGI-51"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CGI-56"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CGI-96"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CHKL"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CLDN5"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CLTCL1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("COMT"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CPT1B"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CRKL"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CRYBA4"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CRYBB1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CRYBB2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CRYBB3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CSF2RB"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CSNK1E"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CST"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("CYP2D6"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DDT"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DDX17"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DGCR2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DGCR6"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DGCR8"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DIA1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DJ1042K10.2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DJ37E16.5"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DJ742C19.2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DKFZP434P211"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DMC1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DNAL4"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("DRG1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("E46L"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ECGF1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("EIF3S7"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("EP300"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("EWSR1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("FBLN1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("FBXO7"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("FKSG1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("FLJ10140"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("FLJ20185"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("FLJ20232"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("FLJ20454"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("FLJ20618"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("FLJ20635"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("FLJ20695"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("FLJ20699"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("G22P1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GALR3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GAR22"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GCAT"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GGA1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GGT1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GGTLA1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GIII-SPLA2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GNAZ"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GP1BB"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GPR24"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GRAP2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GSCL"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GSTT1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GSTT2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GTPBP1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("GTSE1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("H1F0"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HCF2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HIRA"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HMG17L1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HMOX1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HRIHFB2122"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HS322B1A"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HS747E2A"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HSN44A4A"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HSPC025"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HSPC051"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HSPC117"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HSPC242"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("HsPOX2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("IGLL1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("IL17R"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("IL2RB"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("KCNJ4"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("KCNMB3L"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("KDELR3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("KIAA0015"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("KIAA0063"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("KIAA0153"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("KIAA0330"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("KIAA0637"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("KIAA0645"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("KIAA0685"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("KIAA0852"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LARGE"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LGALS1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LGALS2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LIF"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LIMK2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LOC51219"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LOC51233"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LOC51733"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LOC55586"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LOC55954"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LOC56993"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LOC57168"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LOC63929"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("LZTR1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MAFF"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MAPK1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MAPK11"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MAPK12"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MAPK8IP2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MB"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MCM5"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MDS019"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MGAT3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MIF"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MIL1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MMP11"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MN1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MSE55"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("MTMR3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("NAGA"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("NCF4"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("NDUFA6"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("NEFH"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("NF2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("NHP2L1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("NIPSNAP1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("NLVCF"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("NPTXR"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("NUP50"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("OSM"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("P2RXL1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PACSIN2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PARVG"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PBI"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PDGFB"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PES1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PIK4CA"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PITPNB"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PK1.3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PKDREJ"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PLA2G6"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PMM1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PNUTL1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("POLR2F"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("POM121L1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PPARA"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PPIL2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PRAME"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PRKCABP"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PRODH"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PSCD4"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("PTD004"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RAB36"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RABL2B"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RAD53"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RANBP1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RANGAP1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RASD1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RAYL"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RBM9"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RBX1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RFPL1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RFPL2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RFPL3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("rhodanese"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RPL3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RRP22"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("RTDR1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SCO2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SDF2L1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SEC14L2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SEP3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SEZ6L"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SF3A1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SH3BP1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SLC16A8"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SLC25A17"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SLC5A1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SLC7A4"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SMARCB1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SMTN"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SNAP29"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SNRPD3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SOX10"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SREBF2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SSTR3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ST13"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SULTX3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SYN3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("SYNGR1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TAB1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TBX1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TCN2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TEF"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TIMP3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TIP39"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TOB2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TOM1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TOP3B"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TPST2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TR"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TST"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TTLL1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TUBA8"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("TXN2"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("UBE2L3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("UFD1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("UPK3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("USP18"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("VPREB3"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("XBP1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("YM-1"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("YWHAH"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ZNF278"),cloneString(buff));
sprintf(buff,"%d",i); i++; hashAddUnique(geneNumHash, cloneString("ZNF74"),cloneString(buff));
}


int rcdLookUpExpNumber(char *name)
{
int ret=-1;
char *toRet = NULL;
if(expNumHash == NULL) 
return -2;
toRet = hashFindVal(expNumHash, name);
if(toRet == NULL) 
return ret;
else
return atoi(toRet);
}

char *rcdLookUpExpName(int expNum)
{
char buff[32];
char *expName = NULL;
if(expNameHash == NULL)
 errAbort("rcdLookUpExpName() - expNameHash is NULL");
sprintf(buff, "%d", expNum);
expName = hashFindVal(expNameHash, buff);
return cloneString(expName);
}

char *rcdLookUpGeneName(int geneNum)
{
char buff[32];
char *geneName = NULL;
if(geneNumHash == NULL)
 errAbort("rcdLookUpGeneName() - geneNumHash is NULL");
sprintf(buff, "%d", geneNum);
geneName = hashFindVal(geneNameHash, buff);
return cloneString(geneName);
}



void rcdInitExpTable() 
{
if(expNameHash == NULL)
 createExpNameHash();
if(expNumHash == NULL)
 createExpNumHash();
if(geneNumHash == NULL)
 createGeneNumHash();
if(geneNameHash == NULL)
    createGeneNameHash();
}

void countExpElements(void *val)
{
numTotalExperiments++;
}

void countGeneElements(void *val)
{
numTotalGenes++;
}


int rcdGetNumGenes() 
{
if(numTotalGenes != 0)
 return numTotalGenes;
else 
 {
 hashTraverseVals(geneNameHash, countGeneElements);
 return numTotalGenes;
 }
}


int rcdGetNumExp() 
{
if(numTotalExperiments != 0)
 return numTotalExperiments;
else 
 {
 hashTraverseVals(expNumHash, countExpElements);
 return numTotalExperiments;
 }
}
