# EnsGeneAutomate: mapping Ensembl species/gff file names to UCSC db
#
# DO NOT EDIT the /cluster/bin/scripts copy of this file --
# edit ~/kent/src/hg/utils/automation/EnsGeneAutomate.pm instead.

# $Id: EnsGeneAutomate.pm,v 1.24 2010/05/27 18:26:52 hiram Exp $
package EnsGeneAutomate;

use warnings;
use strict;
use Carp;
use vars qw(@ISA @EXPORT_OK);
use Exporter;

@ISA = qw(Exporter);

our @verToDate;

# This is a listing of the public methods and variables (which should be
# treated as constants) exported by this module:
@EXPORT_OK = (
    # Support for common command line options:
    qw( ensVersionList ensGeneVersioning @verToDate
      ),
);

#	Location of Ensembl FTP site for the releases
my $ensemblFTP = "ftp://ftp.ensembl.org/pub/";

#	version to date relationship for Ensembl archive reference
$verToDate[27] = "dec2004";
$verToDate[32] = "jul2005";
$verToDate[33] = "sep2005";
$verToDate[34] = "oct2005";
$verToDate[35] = "nov2005";
$verToDate[37] = "feb2006";
$verToDate[38] = "apr2006";
$verToDate[39] = "jun2006";
$verToDate[41] = "oct2006";
$verToDate[42] = "dec2006";
# before 43 there are no GTF files
$verToDate[43] = "feb2007";
$verToDate[44] = "apr2007";
$verToDate[45] = "jun2007";
$verToDate[46] = "aug2007";
$verToDate[47] = "oct2007";
$verToDate[48] = "dec2007";
$verToDate[49] = "mar2008";
$verToDate[50] = "jul2008";
$verToDate[51] = "nov2008";
$verToDate[52] = "dec2008";
$verToDate[54] = "may2009";
$verToDate[55] = "jul2009";
$verToDate[56] = "sep2009";
$verToDate[57] = "mar2010";
$verToDate[58] = "may2010";
$verToDate[59] = "aug2010";
$verToDate[60] = "nov2010";
$verToDate[61] = "feb2011";
$verToDate[62] = "apr2011";
$verToDate[63] = "jun2011";
$verToDate[64] = "sep2011";
$verToDate[65] = "dec2011";
$verToDate[67] = "jun2012";
$verToDate[68] = "aug2012";
$verToDate[69] = "oct2012";
$verToDate[70] = "jan2013";
$verToDate[71] = "apr2013";
$verToDate[72] = "jun2013";
$verToDate[73] = "sep2013";
$verToDate[74] = "dec2013";
$verToDate[75] = "feb2014";
$verToDate[76] = "aug2014";
$verToDate[77] = "sep2014";
$verToDate[78] = "dec2014";
$verToDate[79] = "mar2015";
$verToDate[81] = "jul2015";
$verToDate[83] = "dec2015";
$verToDate[85] = "jul2016";
$verToDate[86] = "oct2016";
$verToDate[89] = "may2017";
$verToDate[90] = "aug2017";
$verToDate[91] = "dec2017";
$verToDate[92] = "apr2018";
$verToDate[95] = "jan2019";
$verToDate[99] = "jan2020";
$verToDate[101] = "aug2020";
$verToDate[103] = "feb2021";
$verToDate[104] = "may2021";

#	older versions for archive purposes, there are different
#	directory structures for these, thus, the full path name
#	to append to the release-NN/ top level directory.
#  Fugu fr1 needs help here since there is no GTF file, fetch it from
#	EnsMart
my %ensGeneGtfFileNames_35 = (
'fr1' => 'fugu_rubripes_35_2g/data/fasta/dna/README',
);
my %ensGeneFtpPeptideFileNames_35 = (
'fr1' => 'fugu_rubripes_35_2g/data/fasta/pep/Fugu_rubripes.FUGU2.nov.pep.fa.gz',
);
my %ensGeneFtpMySqlFileNames_35 = (
'fr1' => 'fugu_rubripes_35_2g/data/mysql/fugu_rubripes_core_35_2g/assembly.txt.table.gz',
);

my %ensGeneGtfFileNames_46 = (
'mm8' => 'mus_musculus_46_36g/data/gtf/Mus_musculus.NCBIM36.46.gtf.gz',
);
my %ensGeneFtpPeptideFileNames_46 = (
'mm8' => 'mus_musculus_46_36g/data/fasta/pep/Mus_musculus.NCBIM36.46.pep.all.fa.gz',
);
my %ensGeneFtpMySqlFileNames_46 = (
'mm8' => 'mus_musculus_46_36g/data/mysql/mus_musculus_core_46_36g',
);

#	This listings are created by going to the FTP site and running
#	an ls on the gtf directory.  Edit that listing into this hash.
# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_47 = (
'aedAeg0' => 'Aedes_aegypti.AaegL1.47.gtf.gz',
'anoGam2' => 'Anopheles_gambiae.AgamP3.47.gtf.gz',
'bosTau3' => 'Bos_taurus.Btau_3.1.47.gtf.gz',
'ce5' => 'Caenorhabditis_elegans.WS180.47.gtf.gz',
'canFam2' => 'Canis_familiaris.BROADD2.47.gtf.gz',
'cavPor2' => 'Cavia_porcellus.GUINEAPIG.47.gtf.gz',
'ci2' => 'Ciona_intestinalis.JGI2.47.gtf.gz',
'cioSav2' => 'Ciona_savignyi.CSAV2.0.47.gtf.gz',
'danRer5' => 'Danio_rerio.ZFISH7.47.gtf.gz',
'dasNov1' => 'Dasypus_novemcinctus.ARMA.47.gtf.gz',
'dm4' => 'Drosophila_melanogaster.BDGP4.3.47.gtf.gz',
'echTel1' => 'Echinops_telfairi.TENREC.47.gtf.gz',
'eriEur1' => 'Erinaceus_europaeus.HEDGEHOG.47.gtf.gz',
'felCat3' => 'Felis_catus.CAT.47.gtf.gz',
'galGal3' => 'Gallus_gallus.WASHUC2.47.gtf.gz',
'gasAcu1' => 'Gasterosteus_aculeatus.BROADS1.47.gtf.gz',
'hg18' => 'Homo_sapiens.NCBI36.47.gtf.gz',
'loxAfr1' => 'Loxodonta_africana.BROADE1.47.gtf.gz',
'rheMac2' => 'Macaca_mulatta.MMUL_1.47.gtf.gz',
'monDom5' => 'Monodelphis_domestica.BROADO5.47.gtf.gz',
'mm9' => 'Mus_musculus.NCBIM37.47.gtf.gz',
'myoLuc1' => 'Myotis_lucifugus.MICROBAT1.47.gtf.gz',
'ornAna1' => 'Ornithorhynchus_anatinus.OANA5.47.gtf.gz',
'oryCun1' => 'Oryctolagus_cuniculus.RABBIT.47.gtf.gz',
'oryLat1' => 'Oryzias_latipes.MEDAKA1.47.gtf.gz',
'otoGar1' => 'Otolemur_garnettii.BUSHBABY1.47.gtf.gz',
'panTro2' => 'Pan_troglodytes.CHIMP2.1.47.gtf.gz',
'rn4' => 'Rattus_norvegicus.RGSC3.4.47.gtf.gz',
'sacCer1' => 'Saccharomyces_cerevisiae.SGD1.01.47.gtf.gz',
'sorAra0' => 'Sorex_araneus.COMMON_SHREW1.47.gtf.gz',
'speTri0' => 'Spermophilus_tridecemlineatus.SQUIRREL.47.gtf.gz',
'fr2' => 'Takifugu_rubripes.FUGU4.47.gtf.gz',
'tetNig1' => 'Tetraodon_nigroviridis.TETRAODON7.47.gtf.gz',
'tupBel1' => 'Tupaia_belangeri.TREESHREW.47.gtf.gz',
'xenTro2' => 'Xenopus_tropicalis.JGI4.1.47.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_47 = (
'aedAeg0' => 'aedes_aegypti_47_1a/pep/Aedes_aegypti.AaegL1.47.pep.all.fa.gz',
'anoGam2' => 'anopheles_gambiae_47_3i/pep/Anopheles_gambiae.AgamP3.47.pep.all.fa.gz',
'bosTau3' => 'bos_taurus_47_3d/pep/Bos_taurus.Btau_3.1.47.pep.all.fa.gz',
'ce5' => 'caenorhabditis_elegans_47_180/pep/Caenorhabditis_elegans.WS180.47.pep.all.fa.gz',
'canFam2' => 'canis_familiaris_47_2e/pep/Canis_familiaris.BROADD2.47.pep.all.fa.gz',
'cavPor2' => 'cavia_porcellus_47_1b/pep/Cavia_porcellus.GUINEAPIG.47.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis_47_2g/pep/Ciona_intestinalis.JGI2.47.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi_47_2e/pep/Ciona_savignyi.CSAV2.0.47.pep.all.fa.gz',
'danRer5' => 'danio_rerio_47_7a/pep/Danio_rerio.ZFISH7.47.pep.all.fa.gz',
'dasNov1' => 'dasypus_novemcinctus_47_1d/pep/Dasypus_novemcinctus.ARMA.47.pep.all.fa.gz',
'dm4' => 'drosophila_melanogaster_47_43b/pep/Drosophila_melanogaster.BDGP4.3.47.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi_47_1d/pep/Echinops_telfairi.TENREC.47.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus_47_1b/pep/Erinaceus_europaeus.HEDGEHOG.47.pep.all.fa.gz',
'felCat3' => 'felis_catus_47_1b/pep/Felis_catus.CAT.47.pep.all.fa.gz',
'galGal3' => 'gallus_gallus_47_2e/pep/Gallus_gallus.WASHUC2.47.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus_47_1d/pep/Gasterosteus_aculeatus.BROADS1.47.pep.all.fa.gz',
'hg18' => 'homo_sapiens_47_36i/pep/Homo_sapiens.NCBI36.47.pep.all.fa.gz',
'loxAfr1' => 'loxodonta_africana_47_1c/pep/Loxodonta_africana.BROADE1.47.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta_47_10f/pep/Macaca_mulatta.MMUL_1.47.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica_47_5b/pep/Monodelphis_domestica.BROADO5.47.pep.all.fa.gz',
'mm9' => 'mus_musculus_47_37/pep/Mus_musculus.NCBIM37.47.pep.all.fa.gz',
'myoLuc0' => 'myotis_lucifugus_47_1c/pep/Myotis_lucifugus.MICROBAT1.47.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus_47_1d/pep/Ornithorhynchus_anatinus.OANA5.47.pep.all.fa.gz',
'oryCun1' => 'oryctolagus_cuniculus_47_1d/pep/Oryctolagus_cuniculus.RABBIT.47.pep.all.fa.gz',
'oryLat1' => 'oryzias_latipes_47_1c/pep/Oryzias_latipes.MEDAKA1.47.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii_47_1a/pep/Otolemur_garnettii.BUSHBABY1.47.pep.all.fa',
'panTro2' => 'pan_troglodytes_47_21f/pep/Pan_troglodytes.CHIMP2.1.47.pep.all.fa.gz ',
'rn4' => 'rattus_norvegicus_47_34q/pep/Rattus_norvegicus.RGSC3.4.47.pep.all.fa.gz',
'sacCer1' => 'saccharomyces_cerevisiae_47_1g/pep/Saccharomyces_cerevisiae.SGD1.01.47.pep.all.fa.gz',
'sorAra0' => 'sorex_araneus_47_1a/pep/Sorex_araneus.COMMON_SHREW1.47.pep.all.fa.gz',
'speTri0' => 'spermophilus_tridecemlineatus_47_1c/pep/Spermophilus_tridecemlineatus.SQUIRREL.47.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes_47_4g/pep/Takifugu_rubripes.FUGU4.47.pep.all.fa.gz',
'tetNig1' => 'tetraodon_nigroviridis_47_1i/pep/Tetraodon_nigroviridis.TETRAODON7.47.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri_47_1b/pep/Tupaia_belangeri.TREESHREW.47.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis_47_41g/pep/Xenopus_tropicalis.JGI4.1.47.pep.all.fa.gz',
);

#	directory name under release-47/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_47 = (
'aedAeg0' => 'aedes_aegypti_core_47_1a',
'anoGam2' => 'anopheles_gambiae_core_47_3i',
'bosTau3' => 'bos_taurus_core_47_3d',
'ce5' => 'caenorhabditis_elegans_core_47_180',
'canFam2' => 'canis_familiaris_core_47_2e',
'cavPor2' => 'cavia_porcellus_core_47_1b',
'ci2' => 'ciona_intestinalis_core_47_2g',
'cioSav2' => 'ciona_savignyi_core_47_2e',
'danRer5' => 'danio_rerio_core_47_7a',
'dasNov1' => 'dasypus_novemcinctus_core_47_1d',
'dm4' => 'drosophila_melanogaster_core_47_43b',
'echTel1' => 'echinops_telfairi_core_47_1d',
'eriEur1' => 'erinaceus_europaeus_core_47_1b',
'felCat3' => 'felis_catus_core_47_1b',
'galGal3' => 'gallus_gallus_core_47_2e',
'gasAcu1' => 'gasterosteus_aculeatus_core_47_1d',
'hg18' => 'homo_sapiens_core_47_36i',
'loxAfr1' => 'loxodonta_africana_core_47_1c',
'rheMac2' => 'macaca_mulatta_core_47_10f',
'monDom5' => 'monodelphis_domestica_core_47_5b',
'mm9' => 'mus_musculus_core_47_37',
'myoLuc0' => 'myotis_lucifugus_core_47_1c',
'ornAna1' => 'ornithorhynchus_anatinus_core_47_1d',
'oryCun1' => 'oryctolagus_cuniculus_core_47_1d',
'oryLat1' => 'oryzias_latipes_core_47_1c',
'otoGar1' => 'otolemur_garnettii_core_47_1a',
'panTro2' => 'pan_troglodytes_core_47_21f',
'rn4' => 'rattus_norvegicus_core_47_34q',
'sacCer1' => 'saccharomyces_cerevisiae_core_47_1g',
'sorAra0' => 'sorex_araneus_core_47_1a',
'speTri0' => 'spermophilus_tridecemlineatus_core_47_1c',
'fr2' => 'takifugu_rubripes_core_47_4g',
'tetNig1' => 'tetraodon_nigroviridis_core_47_1i',
'tupBel1' => 'tupaia_belangeri_core_47_1b',
'xenTro2' => 'xenopus_tropicalis_core_47_41g',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_48 = (
'aedAeg0' => 'aedes_aegypti/Aedes_aegypti.AaegL1.48.gtf.gz',
'anoGam2' => 'anopheles_gambiae/Anopheles_gambiae.AgamP3.48.gtf.gz',
'bosTau3' => 'bos_taurus/Bos_taurus.Btau_3.1.48.gtf.gz',
'ce5' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS180.48.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.48.gtf.gz',
'cavPor2' => 'cavia_porcellus/Cavia_porcellus.GUINEAPIG.48.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.48.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.48.gtf.gz',
'danRer5' => 'danio_rerio/Danio_rerio.ZFISH7.48.gtf.gz',
'dasNov1' => 'dasypus_novemcinctus/Dasypus_novemcinctus.ARMA.48.gtf.gz',
'dm4' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP4.3.48.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.48.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.48.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.48.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.48.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.48.gtf.gz',
'hg18' => 'homo_sapiens/Homo_sapiens.NCBI36.48.gtf.gz',
'loxAfr1' => 'loxodonta_africana/Loxodonta_africana.BROADE1.48.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.48.gtf.gz',
'micMur0' => 'microcebus_murinus/Microcebus_murinus.micMur1.48.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.48.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.48.gtf.gz',
'myoLuc0' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.48.gtf.gz',
'ochPri0' => 'ochotona_princeps/Ochotona_princeps.pika.48.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.48.gtf.gz',
'oryCun1' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.RABBIT.48.gtf.gz',
'oryLat1' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.48.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.48.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.48.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.48.gtf.gz',
'sacCer1' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.SGD1.48.gtf.gz',
'sorAra0' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.48.gtf.gz',
'speTri0' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.48.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.48.gtf.gz',
'tetNig1' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON7.48.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.48.gtf.gz',
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.48.gtf.gz',
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_48 = (
'aedAeg0' => 'aedes_aegypti/pep/Aedes_aegypti.AaegL1.48.pep.all.fa.gz',
'anoGam2' => 'anopheles_gambiae/pep/Anopheles_gambiae.AgamP3.48.pep.all.fa.gz',
'bosTau3' => 'bos_taurus/pep/Bos_taurus.Btau_3.1.48.pep.all.fa.gz',
'ce5' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS180.48.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.48.pep.all.fa.gz',
'cavPor2' => 'cavia_porcellus/pep/Cavia_porcellus.GUINEAPIG.48.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.48.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.48.pep.all.fa.gz',
'danRer5' => 'danio_rerio/pep/Danio_rerio.ZFISH7.48.pep.all.fa.gz',
'dasNov1' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.ARMA.48.pep.all.fa.gz',
'dm4' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP4.3.48.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.48.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.48.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.48.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.48.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.48.pep.all.fa.gz',
'hg18' => 'homo_sapiens/pep/Homo_sapiens.NCBI36.48.pep.all.fa.gz',
'loxAfr1' => 'loxodonta_africana/pep/Loxodonta_africana.BROADE1.48.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.48.pep.all.fa.gz',
'micMur0' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.48.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.48.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.48.pep.all.fa.gz',
'myoLuc0' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.48.pep.all.fa.gz',
'ochPri0' => 'ochotona_princeps/pep/Ochotona_princeps.pika.48.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.48.pep.all.fa.gz',
'oryCun1' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.RABBIT.48.pep.all.fa.gz',
'oryLat1' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.48.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.48.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.48.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.48.pep.all.fa.gz',
'sacCer1' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.SGD1.48.pep.all.fa.gz',
'sorAra0' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.48.pep.all.fa.gz',
'speTri0' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.48.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.48.pep.all.fa.gz',
'tetNig1' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON7.48.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.48.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.48.pep.all.fa.gz',
);

#	directory name under release-48/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_48 = (
'aedAeg0' => 'aedes_aegypti_core_48_1b',
'anoGam2' => 'anopheles_gambiae_core_48_3j',
'bosTau3' => 'bos_taurus_core_48_3e',
'ce5' => 'caenorhabditis_elegans_core_48_180a',
'canFam2' => 'canis_familiaris_core_48_2f',
'cavPor2' => 'cavia_porcellus_core_48_1c',
'ci2' => 'ciona_intestinalis_core_48_2h',
'cioSav2' => 'ciona_savignyi_core_48_2f',
'danRer5' => 'danio_rerio_core_48_7b',
'dasNov1' => 'dasypus_novemcinctus_core_48_1e',
'dm4' => 'drosophila_melanogaster_core_48_43b',
'echTel1' => 'echinops_telfairi_core_48_1e',
'eriEur1' => 'erinaceus_europaeus_core_48_1c',
'felCat3' => 'felis_catus_core_48_1c',
'galGal3' => 'gallus_gallus_core_48_2f',
'gasAcu1' => 'gasterosteus_aculeatus_core_48_1e',
'hg18' => 'homo_sapiens_core_48_36j',
'loxAfr1' => 'loxodonta_africana_core_48_1d',
'rheMac2' => 'macaca_mulatta_core_48_10g',
'micMur0' => 'microcebus_murinus_core_48_1',
'monDom5' => 'monodelphis_domestica_core_48_5c',
'mm9' => 'mus_musculus_core_48_37a',
'myoLuc0' => 'myotis_lucifugus_core_48_1d',
'ochPri0' => 'ochotona_princeps_core_48_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_48_1e',
'oryCun1' => 'oryctolagus_cuniculus_core_48_1e',
'oryLat1' => 'oryzias_latipes_core_48_1d',
'otoGar1' => 'otolemur_garnettii_core_48_1b',
'panTro2' => 'pan_troglodytes_core_48_21g',
'rn4' => 'rattus_norvegicus_core_48_34r',
'sacCer1' => 'saccharomyces_cerevisiae_core_48_1h',
'sorAra0' => 'sorex_araneus_core_48_1b',
'speTri0' => 'spermophilus_tridecemlineatus_core_48_1d',
'fr2' => 'takifugu_rubripes_core_48_4h',
'tetNig1' => 'tetraodon_nigroviridis_core_48_1j',
'tupBel1' => 'tupaia_belangeri_core_48_1c',
'xenTro2' => 'xenopus_tropicalis_core_48_41h',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_49 = (
'aedAeg0' => 'aedes_aegypti/Aedes_aegypti.AaegL1.49.gtf.gz',
'anoGam2' => 'anopheles_gambiae/Anopheles_gambiae.AgamP3.49.gtf.gz',
'bosTau3' => 'bos_taurus/Bos_taurus.Btau_3.1.49.gtf.gz',
'ce5' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS180.49.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.49.gtf.gz',
'cavPor2' => 'cavia_porcellus/Cavia_porcellus.GUINEAPIG.49.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.49.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.49.gtf.gz',
'danRer5' => 'danio_rerio/Danio_rerio.ZFISH7.49.gtf.gz',
'dasNov1' => 'dasypus_novemcinctus/Dasypus_novemcinctus.ARMA.49.gtf.gz',
'dm5' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.4.49.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.49.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.49.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.49.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.49.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.49.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.49.gtf.gz',
'hg18' => 'homo_sapiens/Homo_sapiens.NCBI36.49.gtf.gz',
'loxAfr1' => 'loxodonta_africana/Loxodonta_africana.BROADE1.49.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.49.gtf.gz',
'micMur0' => 'microcebus_murinus/Microcebus_murinus.micMur1.49.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.49.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.49.gtf.gz',
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.49.gtf.gz',
'ochPri0' => 'ochotona_princeps/Ochotona_princeps.pika.49.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.49.gtf.gz',
'oryCun1' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.RABBIT.49.gtf.gz',
'oryLat1' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.49.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.49.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.49.gtf.gz',
'ponAbe2' => 'pongo_pygmaeus/Pongo_pygmaeus.PPYG2.49.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.49.gtf.gz',
'sacCer1' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.SGD1.01.49.gtf.gz',
'sorAra0' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.49.gtf',
'speTri0' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.49.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.49.gtf.gz',
'tetNig1' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON7.49.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.49.gtf.gz',
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.49.gtf.gz',
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_49 = (
'aedAeg0' => 'aedes_aegypti/pep/Aedes_aegypti.AaegL1.49.pep.all.fa.gz',
'anoGam2' => 'anopheles_gambiae/pep/Anopheles_gambiae.AgamP3.49.pep.all.fa.gz',
'bosTau3' => 'bos_taurus/pep/Bos_taurus.Btau_3.1.49.pep.all.fa.gz',
'ce5' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS180.49.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.49.pep.all.fa.gz',
'cavPor2' => 'cavia_porcellus/pep/Cavia_porcellus.GUINEAPIG.49.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.49.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.49.pep.all.fa.gz',
'danRer5' => 'danio_rerio/pep/Danio_rerio.ZFISH7.49.pep.all.fa.gz',
'dasNov1' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.ARMA.49.pep.all.fa.gz',
'dm5' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.4.49.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.49.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.49.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.49.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.49.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.49.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.49.pep.all.fa.gz',
'hg18' => 'homo_sapiens/pep/Homo_sapiens.NCBI36.49.pep.all.fa.gz',
'loxAfr1' => 'loxodonta_africana/pep/Loxodonta_africana.BROADE1.49.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.49.pep.all.fa.gz',
'micMur0' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.49.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.49.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.49.pep.all.fa.gz',
'myoLuc0' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.49.pep.all.fa.gz',
'ochPri0' => 'ochotona_princeps/pep/Ochotona_princeps.pika.49.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.49.pep.all.fa.gz',
'oryCun1' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.RABBIT.49.pep.all.fa.gz',
'oryLat1' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.49.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.49.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.49.pep.all.fa.gz',
'ponAbe2' => 'pongo_pygmaeus/pep/Pongo_pygmaeus.PPYG2.49.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.49.pep.all.fa.gz',
'sacCer1' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.SGD1.01.49.pep.all.fa.gz',
'sorAra0' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.49.pep.all.fa.gz',
'speTri0' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.49.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.49.pep.all.fa.gz',
'tetNig1' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON7.49.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.49.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.49.pep.all.fa.gz',
);

#	directory name under release-49/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_49 = (
'aedAeg0' => 'aedes_aegypti_core_49_1b',
'anoGam2' => 'anopheles_gambiae_core_49_3j',
'bosTau3' => 'bos_taurus_core_49_3f',
'ce5' => 'caenorhabditis_elegans_core_49_180a',
'canFam2' => 'canis_familiaris_core_49_2g',
'cavPor2' => 'cavia_porcellus_core_49_1c',
'ci2' => 'ciona_intestinalis_core_49_2i',
'cioSav2' => 'ciona_savignyi_core_49_2f',
'danRer5' => 'danio_rerio_core_49_7c',
'dasNov1' => 'dasypus_novemcinctus_core_49_1f',
'dm5' => 'drosophila_melanogaster_core_49_54',
'echTel1' => 'echinops_telfairi_core_49_1e',
'equCab2' => 'equus_caballus_core_49_2',
'eriEur1' => 'erinaceus_europaeus_core_49_1c',
'felCat3' => 'felis_catus_core_49_1c',
'galGal3' => 'gallus_gallus_core_49_2g',
'gasAcu1' => 'gasterosteus_aculeatus_core_49_1f',
'hg18' => 'homo_sapiens_core_49_36k',
'loxAfr1' => 'loxodonta_africana_core_49_1d',
'rheMac2' => 'macaca_mulatta_core_49_10h',
'micMur0' => 'microcebus_murinus_core_49_1',
'monDom5' => 'monodelphis_domestica_core_49_5d',
'mm9' => 'mus_musculus_core_49_37b',
'myoLuc0' => 'myotis_lucifugus_core_49_1e',
'ochPri0' => 'ochotona_princeps_core_49_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_49_1f',
'oryCun1' => 'oryctolagus_cuniculus_core_49_1f',
'oryLat1' => 'oryzias_latipes_core_49_1e',
'otoGar1' => 'otolemur_garnettii_core_49_1c',
'panTro2' => 'pan_troglodytes_core_49_21h',
'ponAbe2' => 'pongo_pygmaeus_core_49_1',
'rn4' => 'rattus_norvegicus_core_49_34s',
'sacCer1' => 'saccharomyces_cerevisiae_core_49_1h',
'sorAra0' => 'sorex_araneus_core_49_1b',
'speTri0' => 'spermophilus_tridecemlineatus_core_49_1e',
'fr2' => 'takifugu_rubripes_core_49_4i',
'tetNig1' => 'tetraodon_nigroviridis_core_49_1k',
'tupBel1' => 'tupaia_belangeri_core_49_1d',
'xenTro2' => 'xenopus_tropicalis_core_49_41i',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_50 = (
'aedAeg0' => 'aedes_aegypti/Aedes_aegypti.AaegL1.50.gtf.gz',
'anoGam2' => 'anopheles_gambiae/Anopheles_gambiae.AgamP3.50.gtf.gz',
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.50.gtf.gz',
'ce6' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS190.50.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.50.gtf.gz',
'cavPor2' => 'cavia_porcellus/Cavia_porcellus.GUINEAPIG.50.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.50.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.50.gtf.gz',
'danRer5' => 'danio_rerio/Danio_rerio.ZFISH7.50.gtf.gz',
'dasNov1' => 'dasypus_novemcinctus/Dasypus_novemcinctus.ARMA.50.gtf.gz',
'dm5' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.4.50.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.50.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.50.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.50.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.50.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.50.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.50.gtf.gz',
'hg18' => 'homo_sapiens/Homo_sapiens.NCBI36.50.gtf.gz',
'loxAfr1' => 'loxodonta_africana/Loxodonta_africana.BROADE1.50.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.50.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.50.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.50.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.50.gtf.gz',
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.50.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.50.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.50.gtf.gz',
'oryCun1' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.RABBIT.50.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.50.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.50.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.50.gtf.gz',
'ponAbe2' => 'pongo_pygmaeus/Pongo_pygmaeus.PPYG2.50.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.50.gtf.gz',
'sacCer1' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.SGD1.01.50.gtf.gz',
'sorAra0' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.50.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.50.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.50.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.50.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.50.gtf.gz',
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.50.gtf.gz',
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_50 = (
'aedAeg0' => 'aedes_aegypti/pep/Aedes_aegypti.AaegL1.50.pep.all.fa.gz',
'anoGam2' => 'anopheles_gambiae/pep/Anopheles_gambiae.AgamP3.50.pep.all.fa.gz',
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.50.pep.all.fa.gz',
'ce6' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS190.50.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.50.pep.all.fa.gz',
'cavPor2' => 'cavia_porcellus/pep/Cavia_porcellus.GUINEAPIG.50.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.50.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.50.pep.all.fa.gz',
'danRer5' => 'danio_rerio/pep/Danio_rerio.ZFISH7.50.pep.all.fa.gz',
'dasNov1' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.ARMA.50.pep.all.fa.gz',
'dm5' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.4.50.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.50.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.50.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.50.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.50.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.50.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.50.pep.all.fa.gz',
'hg18' => 'homo_sapiens/pep/Homo_sapiens.NCBI36.50.pep.all.fa.gz',
'loxAfr1' => 'loxodonta_africana/pep/Loxodonta_africana.BROADE1.50.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.50.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.50.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.50.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.50.pep.all.fa.gz',
'myoLuc1' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.50.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.50.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.50.pep.all.fa.gz',
'oryCun1' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.RABBIT.50.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.50.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.50.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.50.pep.all.fa.gz',
'ponAbe2' => 'pongo_pygmaeus/pep/Pongo_pygmaeus.PPYG2.50.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.50.pep.all.fa.gz',
'sacCer1' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.SGD1.01.50.pep.all.fa.gz',
'sorAra0' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.50.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.50.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.50.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.50.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.50.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.50.pep.all.fa.gz',
);

#	directory name under release-50/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_50 = (
'aedAeg0' => 'aedes_aegypti_core_50_1c',
'anoGam2' => 'anopheles_gambiae_core_50_3k',
'bosTau4' => 'bos_taurus_core_50_4',
'ce6' => 'caenorhabditis_elegans_core_50_190',
'canFam2' => 'canis_familiaris_core_50_2h',
'cavPor2' => 'cavia_porcellus_core_50_1d',
'ci2' => 'ciona_intestinalis_core_50_2j',
'cioSav2' => 'ciona_savignyi_core_50_2g',
'danRer5' => 'danio_rerio_core_50_7d',
'dasNov1' => 'dasypus_novemcinctus_core_50_1g',
'dm5' => 'drosophila_melanogaster_core_50_54a',
'echTel1' => 'echinops_telfairi_core_50_1f',
'equCab2' => 'equus_caballus_core_50_2a',
'eriEur1' => 'erinaceus_europaeus_core_50_1d',
'felCat3' => 'felis_catus_core_50_1d',
'galGal3' => 'gallus_gallus_core_50_2h',
'gasAcu1' => 'gasterosteus_aculeatus_core_50_1g',
'hg18' => 'homo_sapiens_core_50_36l',
'loxAfr1' => 'loxodonta_africana_core_50_1e',
'rheMac2' => 'macaca_mulatta_core_50_10i',
'micMur1' => 'microcebus_murinus_core_50_1a',
'monDom5' => 'monodelphis_domestica_core_50_5e',
'mm9' => 'mus_musculus_core_50_37c',
'myoLuc1' => 'myotis_lucifugus_core_50_1f',
'ochPri2' => 'ochotona_princeps_core_50_1a',
'ornAna1' => 'ornithorhynchus_anatinus_core_50_1g',
'oryCun1' => 'oryctolagus_cuniculus_core_50_1g',
'oryLat2' => 'oryzias_latipes_core_50_1f',
'otoGar1' => 'otolemur_garnettii_core_50_1d',
'panTro2' => 'pan_troglodytes_core_50_21i',
'ponAbe2' => 'pongo_pygmaeus_core_50_1a',
'rn4' => 'rattus_norvegicus_core_50_34t',
'sacCer1' => 'saccharomyces_cerevisiae_core_50_1i',
'sorAra0' => 'sorex_araneus_core_50_1d',
'speTri1' => 'spermophilus_tridecemlineatus_core_50_1f',
'fr2' => 'takifugu_rubripes_core_50_4j',
'tetNig2' => 'tetraodon_nigroviridis_core_50_8',
'tupBel1' => 'tupaia_belangeri_core_50_1e',
'xenTro2' => 'xenopus_tropicalis_core_50_41j',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_51 = (
'aedAeg0' => 'aedes_aegypti/Aedes_aegypti.AaegL1.51.gtf.gz',
'anoGam2' => 'anopheles_gambiae/Anopheles_gambiae.AgamP3.51.gtf.gz',
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.51.gtf.gz',
'ce6' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS190.51.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.51.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.51.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.51.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.51.gtf.gz',
'danRer5' => 'danio_rerio/Danio_rerio.ZFISH7.51.gtf.gz',
'dasNov1' => 'dasypus_novemcinctus/Dasypus_novemcinctus.ARMA.51.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.51.gtf.gz',
'dm5' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.4.51.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.51.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.51.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.51.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.51.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.51.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.51.gtf.gz',
'hg18' => 'homo_sapiens/Homo_sapiens.NCBI36.51.gtf.gz',
'loxAfr1' => 'loxodonta_africana/Loxodonta_africana.BROADE1.51.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.51.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.51.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.51.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.51.gtf.gz',
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.51.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.51.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.51.gtf.gz',
'oryCun1' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.RABBIT.51.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.51.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.51.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.51.gtf.gz',
'ponAbe2' => 'pongo_pygmaeus/Pongo_pygmaeus.PPYG2.51.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.51.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.51.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.51.gtf.gz',
'sacCer1' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.SGD1.01.51.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.51.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.51.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.51.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.51.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.51.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.51.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.51.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.51.gtf.gz',
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.51.gtf.gz',
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_51 = (
'aedAeg0' => 'aedes_aegypti/pep/Aedes_aegypti.AaegL1.51.pep.all.fa.gz',
'anoGam2' => 'anopheles_gambiae/pep/Anopheles_gambiae.AgamP3.51.pep.all.fa.gz',
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.51.pep.all.fa.gz',
'ce6' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS190.51.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.51.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.51.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.51.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.51.pep.all.fa.gz',
'danRer5' => 'danio_rerio/pep/Danio_rerio.ZFISH7.51.pep.all.fa.gz',
'dasNov1' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.ARMA.51.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.51.pep.all.fa.gz',
'dm5' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.4.51.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.51.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.51.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.51.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.51.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.51.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.51.pep.all.fa.gz',
'hg18' => 'homo_sapiens/pep/Homo_sapiens.NCBI36.51.pep.all.fa.gz',
'loxAfr1' => 'loxodonta_africana/pep/Loxodonta_africana.BROADE1.51.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.51.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.51.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.51.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.51.pep.all.fa.gz',
'myoLuc1' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.51.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.51.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.51.pep.all.fa.gz',
'oryCun1' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.RABBIT.51.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.51.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.51.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.51.pep.all.fa.gz',
'ponAbe2' => 'pongo_pygmaeus/pep/Pongo_pygmaeus.PPYG2.51.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.51.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.51.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.51.pep.all.fa.gz',
'sacCer1' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.SGD1.01.51.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.51.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.51.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.51.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.51.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.51.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.51.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.51.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.51.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.51.pep.all.fa.gz',
);

#	directory name under release-51/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_51 = (
'aedAeg0' => 'aedes_aegypti_core_51_1c',
'anoGam2' => 'anopheles_gambiae_core_51_3k',
'bosTau4' => 'bos_taurus_core_51_4a',
'ce6' => 'caenorhabditis_elegans_core_51_190',
'canFam2' => 'canis_familiaris_core_51_2i',
'cavPor3' => 'cavia_porcellus_core_51_3',
'ci2' => 'ciona_intestinalis_core_51_2k',
'cioSav2' => 'ciona_savignyi_core_51_2g',
'danRer5' => 'danio_rerio_core_51_7d',
'dasNov1' => 'dasypus_novemcinctus_core_51_1g',
'dipOrd1' => 'dipodomys_ordii_core_51_1',
'dm5' => 'drosophila_melanogaster_core_51_54a',
'echTel1' => 'echinops_telfairi_core_51_1f',
'equCab2' => 'equus_caballus_core_51_2a',
'eriEur1' => 'erinaceus_europaeus_core_51_1d',
'felCat3' => 'felis_catus_core_51_1e',
'galGal3' => 'gallus_gallus_core_51_2i',
'gasAcu1' => 'gasterosteus_aculeatus_core_51_1h',
'hg18' => 'homo_sapiens_core_51_36m',
'loxAfr1' => 'loxodonta_africana_core_51_1f',
'rheMac2' => 'macaca_mulatta_core_51_10i',
'micMur1' => 'microcebus_murinus_core_51_1a',
'monDom5' => 'monodelphis_domestica_core_51_5f',
'mm9' => 'mus_musculus_core_51_37d',
'myoLuc1' => 'myotis_lucifugus_core_51_1f',
'ochPri2' => 'ochotona_princeps_core_51_1b',
'ornAna1' => 'ornithorhynchus_anatinus_core_51_1h',
'oryCun1' => 'oryctolagus_cuniculus_core_51_1g',
'oryLat2' => 'oryzias_latipes_core_51_1g',
'otoGar1' => 'otolemur_garnettii_core_51_1d',
'panTro2' => 'pan_troglodytes_core_51_21i',
'ponAbe2' => 'pongo_pygmaeus_core_51_1b',
'proCap1' => 'procavia_capensis_core_51_1',
'pteVam1' => 'pteropus_vampyrus_core_51_1',
'rn4' => 'rattus_norvegicus_core_51_34t',
'sacCer1' => 'saccharomyces_cerevisiae_core_51_1i',
'sorAra1' => 'sorex_araneus_core_51_1d',
'speTri1' => 'spermophilus_tridecemlineatus_core_51_1f',
'fr2' => 'takifugu_rubripes_core_51_4j',
'tarSyr1' => 'tarsius_syrichta_core_51_1',
'tetNig2' => 'tetraodon_nigroviridis_core_51_8',
'tupBel1' => 'tupaia_belangeri_core_51_1e',
'turTru1' => 'tursiops_truncatus_core_51_1',
'vicPac1' => 'vicugna_pacos_core_51_1',
'xenTro2' => 'xenopus_tropicalis_core_51_41j',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_52 = (
'aedAeg0' => 'aedes_aegypti/Aedes_aegypti.AaegL1.52.gtf.gz',
'anoGam2' => 'anopheles_gambiae/Anopheles_gambiae.AgamP3.52.gtf.gz',
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.52.gtf.gz',
'ce6' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS190.52.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.52.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.52.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.52.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.52.gtf.gz',
'danRer5' => 'danio_rerio/Danio_rerio.ZFISH7.52.gtf.gz',
'dasNov1' => 'dasypus_novemcinctus/Dasypus_novemcinctus.ARMA.52.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.52.gtf.gz',
'dm5' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.4.52.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.52.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.52.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.52.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.52.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.52.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.52.gtf.gz',
'gorGor1' => 'gorilla_gorilla/Gorilla_gorilla.gorGor1.52.gtf.gz',
'hg18' => 'homo_sapiens/Homo_sapiens.NCBI36.52.gtf.gz',
'loxAfr1' => 'loxodonta_africana/Loxodonta_africana.BROADE1.52.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.52.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.52.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.52.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.52.gtf.gz',
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.52.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.52.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.52.gtf.gz',
'oryCun1' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.RABBIT.52.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.52.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.52.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.52.gtf.gz',
'ponAbe2' => 'pongo_pygmaeus/Pongo_pygmaeus.PPYG2.52.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.52.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.52.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.52.gtf.gz',
'sacCer2' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.SGD1.01.52.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.52.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.52.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.52.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.52.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.52.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.52.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.52.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.52.gtf.gz',
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.52.gtf.gz',
);


# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_52 = (
'aedAeg0' => 'aedes_aegypti/pep/Aedes_aegypti.AaegL1.52.pep.all.fa.gz',
'anoGam2' => 'anopheles_gambiae/pep/Anopheles_gambiae.AgamP3.52.pep.all.fa.gz',
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.52.pep.all.fa.gz',
'ce6' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS190.52.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.52.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.52.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.52.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.52.pep.all.fa.gz',
'danRer5' => 'danio_rerio/pep/Danio_rerio.ZFISH7.52.pep.all.fa.gz',
'dasNov1' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.ARMA.52.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.52.pep.all.fa.gz',
'dm5' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.4.52.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.52.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.52.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.52.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.52.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.52.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.52.pep.all.fa.gz',
'gorGor1' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor1.52.pep.all.fa.gz',
'hg18' => 'homo_sapiens/pep/Homo_sapiens.NCBI36.52.pep.all.fa.gz',
'loxAfr1' => 'loxodonta_africana/pep/Loxodonta_africana.BROADE1.52.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.52.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.52.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.52.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.52.pep.all.fa.gz',
'myoLuc1' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.52.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.52.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.52.pep.all.fa.gz',
'oryCun1' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.RABBIT.52.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.52.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.52.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.52.pep.all.fa.gz',
'ponAbe2' => 'pongo_pygmaeus/pep/Pongo_pygmaeus.PPYG2.52.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.52.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.52.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.52.pep.all.fa.gz',
'sacCer2' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.SGD1.01.52.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.52.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.52.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.52.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.52.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.52.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.52.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.52.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.52.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.52.pep.all.fa.gz',
);

#	directory name under release-52/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_52 = (
'aedAeg0' => 'aedes_aegypti_core_52_1d',
'anoGam2' => 'anopheles_gambiae_core_52_3k',
'bosTau4' => 'bos_taurus_core_52_4b',
'ce6' => 'caenorhabditis_elegans_core_52_190',
'canFam2' => 'canis_familiaris_core_52_2j',
'cavPor3' => 'cavia_porcellus_core_52_3a',
'ci2' => 'ciona_intestinalis_core_52_2l',
'cioSav2' => 'ciona_savignyi_core_52_2h',
'danRer5' => 'danio_rerio_core_52_7e',
'dasNov1' => 'dasypus_novemcinctus_core_52_1h',
'dipOrd1' => 'dipodomys_ordii_core_52_1a',
'dm5' => 'drosophila_melanogaster_core_52_54a',
'echTel1' => 'echinops_telfairi_core_52_1g',
'equCab2' => 'equus_caballus_core_52_2b',
'eriEur1' => 'erinaceus_europaeus_core_52_1e',
'felCat3' => 'felis_catus_core_52_1f',
'galGal3' => 'gallus_gallus_core_52_2j',
'gasAcu1' => 'gasterosteus_aculeatus_core_52_1i',
'gorGor1' => 'gorilla_gorilla_core_52_1',
'hg18' => 'homo_sapiens_core_52_36n',
'loxAfr1' => 'loxodonta_africana_core_52_1g',
'rheMac2' => 'macaca_mulatta_core_52_10j',
'micMur1' => 'microcebus_murinus_core_52_1b',
'monDom5' => 'monodelphis_domestica_core_52_5g',
'mm9' => 'mus_musculus_core_52_37e',
'myoLuc1' => 'myotis_lucifugus_core_52_1g',
'ochPri2' => 'ochotona_princeps_core_52_1c',
'ornAna1' => 'ornithorhynchus_anatinus_core_52_1i',
'oryCun1' => 'oryctolagus_cuniculus_core_52_1h',
'oryLat2' => 'oryzias_latipes_core_52_1h',
'otoGar1' => 'otolemur_garnettii_core_52_1e',
'panTro2' => 'pan_troglodytes_core_52_21j',
'ponAbe2' => 'pongo_pygmaeus_core_52_1c',
'proCap1' => 'procavia_capensis_core_52_1a',
'pteVam1' => 'pteropus_vampyrus_core_52_1a',
'rn4' => 'rattus_norvegicus_core_52_34u',
'sacCer2' => 'saccharomyces_cerevisiae_core_52_1i',
'sorAra1' => 'sorex_araneus_core_52_1e',
'speTri1' => 'spermophilus_tridecemlineatus_core_52_1g',
'fr2' => 'takifugu_rubripes_core_52_4k',
'tarSyr1' => 'tarsius_syrichta_core_52_1a',
'tetNig2' => 'tetraodon_nigroviridis_core_52_8b',
'tupBel1' => 'tupaia_belangeri_core_52_1f',
'turTru1' => 'tursiops_truncatus_core_52_1a',
'vicPac1' => 'vicugna_pacos_core_52_1a',
'xenTro2' => 'xenopus_tropicalis_core_52_41l',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_54 = (
'hg18' => 'homo_sapiens/Homo_sapiens.NCBI36.54.gtf.gz',
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_54 = (
'hg18' => 'homo_sapiens/pep/Homo_sapiens.NCBI36.54.pep.all.fa.gz',
);

#	directory name under release-53/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_54 = (
'hg18' => 'homo_sapiens_core_54_36p',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_55 = (
'aedAeg0' => 'aedes_aegypti/Aedes_aegypti.AaegL1.55.gtf.gz',
'anoCar1' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar1.0.55.gtf.gz',
'anoGam2' => 'anopheles_gambiae/Anopheles_gambiae.AgamP3.55.gtf.gz',
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.55.gtf.gz',
'ce7' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS200.55.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.55.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.55.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.55.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.55.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.55.gtf.gz',
'danRer6' => 'danio_rerio/Danio_rerio.Zv8.55.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.55.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.55.gtf.gz',
'dm5' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.4.55.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.55.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.55.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.55.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.55.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.55.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.55.gtf.gz',
'gorGor1' => 'gorilla_gorilla/Gorilla_gorilla.gorGor1.55.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.55.gtf.gz',
'loxAfr2' => 'loxodonta_africana/Loxodonta_africana.loxAfr2.55.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.55.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.55.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.55.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.55.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.55.gtf.gz',
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.55.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.55.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.55.gtf.gz',
'oryCun1' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.RABBIT.55.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.55.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.55.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.55.gtf.gz',
'ponAbe2' => 'pongo_pygmaeus/Pongo_pygmaeus.PPYG2.55.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.55.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.55.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.55.gtf.gz',
'sacCer2' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.SGD1.01.55.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.55.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.55.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.55.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.55.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.55.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.55.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.55.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.55.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.55.gtf.gz',
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.55.gtf.gz',
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_55 = (
'aedAeg0' => 'aedes_aegypti/pep/Aedes_aegypti.AaegL1.55.pep.all.fa.gz',
'anoCar1' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar1.0.55.pep.all.fa.gz',
'anoGam2' => 'anopheles_gambiae/pep/Anopheles_gambiae.AgamP3.55.pep.all.fa.gz',
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.55.pep.all.fa.gz',
'ce7' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS200.55.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.55.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.55.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.55.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.55.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.55.pep.all.fa.gz',
'danRer6' => 'danio_rerio/pep/Danio_rerio.Zv8.55.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.55.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.55.pep.all.fa.gz',
'dm5' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.4.55.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.55.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.55.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.55.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.55.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.55.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.55.pep.all.fa.gz',
'gorGor1' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor1.55.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.55.pep.all.fa.gz',
'loxAfr2' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr2.55.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.55.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.55.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.55.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.55.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.55.pep.all.fa.gz',
'myoLuc1' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.55.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.55.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.55.pep.all.fa.gz',
'oryCun1' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.RABBIT.55.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.55.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.55.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.55.pep.all.fa.gz',
'ponAbe2' => 'pongo_pygmaeus/pep/Pongo_pygmaeus.PPYG2.55.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.55.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.55.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.55.pep.all.fa.gz',
'sacCer2' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.SGD1.01.55.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.55.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.55.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.55.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.55.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.55.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.55.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.55.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.55.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.55.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.55.pep.all.fa.gz',
);

#	directory name under release-55/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_55 = (
'aedAeg0' => 'aedes_aegypti_core_55_1d',
'anoCar1' => 'anolis_carolinensis_core_55_1a',
'anoGam2' => 'anopheles_gambiae_core_55_3k',
'bosTau4' => 'bos_taurus_core_55_4e',
'ce7' => 'caenorhabditis_elegans_core_55_200',
'canFam2' => 'canis_familiaris_core_55_2m',
'cavPor3' => 'cavia_porcellus_core_55_3a',
'choHof1' => 'choloepus_hoffmanni_core_55_1a',
'ci2' => 'ciona_intestinalis_core_55_2m',
'cioSav2' => 'ciona_savignyi_core_55_2h',
'danRer6' => 'danio_rerio_core_55_8a',
'dasNov2' => 'dasypus_novemcinctus_core_55_2a',
'dipOrd1' => 'dipodomys_ordii_core_55_1c',
'dm5' => 'drosophila_melanogaster_core_55_54c',
'echTel1' => 'echinops_telfairi_core_55_1g',
'equCab2' => 'equus_caballus_core_55_2d',
'eriEur1' => 'erinaceus_europaeus_core_55_1e',
'felCat3' => 'felis_catus_core_55_1f',
'galGal3' => 'gallus_gallus_core_55_2m',
'gasAcu1' => 'gasterosteus_aculeatus_core_55_1j',
'gorGor1' => 'gorilla_gorilla_core_55_1',
'hg19' => 'homo_sapiens_core_55_37',
'loxAfr2' => 'loxodonta_africana_core_55_2a',
'rheMac2' => 'macaca_mulatta_core_55_10l',
'macEug1' => 'macropus_eugenii_core_55_1',
'micMur1' => 'microcebus_murinus_core_55_1b',
'monDom5' => 'monodelphis_domestica_core_55_5i',
'mm9' => 'mus_musculus_core_55_37h',
'myoLuc1' => 'myotis_lucifugus_core_55_1g',
'ochPri2' => 'ochotona_princeps_core_55_1c',
'ornAna1' => 'ornithorhynchus_anatinus_core_55_1k',
'oryCun1' => 'oryctolagus_cuniculus_core_55_1h',
'oryLat2' => 'oryzias_latipes_core_55_1i',
'otoGar1' => 'otolemur_garnettii_core_55_1e',
'panTro2' => 'pan_troglodytes_core_55_21l',
'ponAbe2' => 'pongo_pygmaeus_core_55_1c',
'proCap1' => 'procavia_capensis_core_55_1c',
'pteVam1' => 'pteropus_vampyrus_core_55_1c',
'rn4' => 'rattus_norvegicus_core_55_34w',
'sacCer2' => 'saccharomyces_cerevisiae_core_55_1j',
'sorAra1' => 'sorex_araneus_core_55_1e',
'speTri1' => 'spermophilus_tridecemlineatus_core_55_1g',
'taeGut1' => 'taeniopygia_guttata_core_55_1b',
'fr2' => 'takifugu_rubripes_core_55_4k',
'tarSyr1' => 'tarsius_syrichta_core_55_1c',
'tetNig2' => 'tetraodon_nigroviridis_core_55_8b',
'tupBel1' => 'tupaia_belangeri_core_55_1f',
'turTru1' => 'tursiops_truncatus_core_55_1c',
'vicPac1' => 'vicugna_pacos_core_55_1c',
'xenTro2' => 'xenopus_tropicalis_core_55_41n',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_56 = (
'anoCar1' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar1.0.56.gtf.gz',
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.56.gtf.gz',
'ce7' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS200.56.gtf.gz',
'calJac2' => 'callithrix_jacchus/Callithrix_jacchus.calJac3.56.gtf.gz' ,
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.56.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.56.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.56.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.56.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.56.gtf.gz',
'danRer6' => 'danio_rerio/Danio_rerio.Zv8.56.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.56.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.56.gtf.gz',
'dm5' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.13.56.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.56.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.56.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.56.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.56.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.56.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.56.gtf.gz',
'gorGor1' => 'gorilla_gorilla/Gorilla_gorilla.gorGor1.56.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.56.gtf.gz',
'loxAfr2' => 'loxodonta_africana/Loxodonta_africana.loxAfr2.56.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.56.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.56.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.56.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.56.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.56.gtf.gz',
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.56.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.56.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.56.gtf.gz',
'oryCun1' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.RABBIT.56.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.56.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.56.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.56.gtf.gz',
'ponAbe2' => 'pongo_pygmaeus/Pongo_pygmaeus.PPYG2.56.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.56.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.56.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.56.gtf.gz',
'sacCer2' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.SGD1.01.56.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.56.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.56.gtf.gz',
'susScr1' => 'sus_scrofa/Sus_scrofa.Sscrofa9.56.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.56.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.56.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.56.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.56.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.56.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.56.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.56.gtf.gz',
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.56.gtf.gz',
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_56 = (
'anoCar1' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar1.0.56.pep.all.fa.gz',
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.56.pep.all.fa.gz',
'ce7' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS200.56.pep.all.fa.gz',
'calJac2' => 'callithrix_jacchus/pep/Callithrix_jacchus.calJac3.56.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.56.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.56.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.56.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.56.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.56.pep.all.fa.gz',
'danRer6' => 'danio_rerio/pep/Danio_rerio.Zv8.56.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.56.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.56.pep.all.fa.gz',
'dm5' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.13.56.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.56.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.56.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.56.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.56.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.56.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.56.pep.all.fa.gz',
'gorGor1' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor1.56.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.56.pep.all.fa.gz',
'loxAfr2' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr2.56.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.56.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.56.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.56.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.56.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.56.pep.all.fa.gz',
'myoLuc1' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.56.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.56.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.56.pep.all.fa.gz',
'oryCun1' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.RABBIT.56.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.56.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.56.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.56.pep.all.fa.gz',
'ponAbe2' => 'pongo_pygmaeus/pep/Pongo_pygmaeus.PPYG2.56.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.56.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.56.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.56.pep.all.fa.gz',
'sacCer2' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.SGD1.01.56.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.56.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.56.pep.all.fa.gz',
'susScr1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa9.56.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.56.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.56.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.56.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.56.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.56.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.56.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.56.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.56.pep.all.fa.gz',
);

#	directory name under release-56/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_56 = (
'anoCar1' =>  'anolis_carolinensis_core_56_1a' ,
'bosTau4' => 'bos_taurus_core_56_4e' ,
'calJac2' => 'callithrix_jacchus_core_56_3' ,
'canFam2' => 'canis_familiaris_core_56_2m' ,
'cavPor3' => 'cavia_porcellus_core_56_3a',
'ce7' => 'caenorhabditis_elegans_core_56_200' ,
'choHof1' => 'choloepus_hoffmanni_core_56_1a',
'ci2' => 'ciona_intestinalis_core_56_2m',
'cioSav2' => 'ciona_savignyi_core_56_2h',
'danRer6' => 'danio_rerio_core_56_8b',
'dasNov2' => 'dasypus_novemcinctus_core_56_2a',
'dipOrd1' => 'dipodomys_ordii_core_56_1c',
'dm5' => 'drosophila_melanogaster_core_56_513a' ,
'echTel1' => 'echinops_telfairi_core_56_1g',
'equCab2' => 'equus_caballus_core_56_2d',
'eriEur1' => 'erinaceus_europaeus_core_56_1e',
'felCat3' => 'felis_catus_core_56_1f',
'galGal3' => 'gallus_gallus_core_56_2m',
'gasAcu1' => 'gasterosteus_aculeatus_core_56_1j',
'gorGor1' => 'gorilla_gorilla_core_56_1',
'hg19' => 'homo_sapiens_core_56_37a',
'loxAfr2' => 'loxodonta_africana_core_56_2a',
'rheMac2' => 'macaca_mulatta_core_56_10l',
'macEug1' => 'macropus_eugenii_core_56_1',
'micMur1' => 'microcebus_murinus_core_56_1b',
'monDom5' => 'monodelphis_domestica_core_56_5i',
'mm9' => 'mus_musculus_core_56_37i',
'myoLuc1' => 'myotis_lucifugus_core_56_1g',
'ochPri2' => 'ochotona_princeps_core_56_1c',
'ornAna1' => 'ornithorhynchus_anatinus_core_56_1k',
'oryCun1' => 'oryctolagus_cuniculus_core_56_1h',
'oryLat2' => 'oryzias_latipes_core_56_1i',
'otoGar1' => 'otolemur_garnettii_core_56_1e',
'panTro2' => 'pan_troglodytes_core_56_21l',
'ponAbe2' => 'pongo_pygmaeus_core_56_1c',
'proCap1' => 'procavia_capensis_core_56_1c',
'pteVam1' => 'pteropus_vampyrus_core_56_1c',
'rn4' => 'rattus_norvegicus_core_56_34x',
'sacCer2' => 'saccharomyces_cerevisiae_core_56_1j',
'sorAra1' => 'sorex_araneus_core_56_1e',
'speTri1' => 'spermophilus_tridecemlineatus_core_56_1g',
'susScr1' => 'sus_scrofa_core_56_9' ,
'taeGut1' => 'taeniopygia_guttata_core_56_1c',
'fr2' => 'takifugu_rubripes_core_56_4k',
'tarSyr1' => 'tarsius_syrichta_core_56_1c',
'tetNig2' => 'tetraodon_nigroviridis_core_56_8b',
'tupBel1' => 'tupaia_belangeri_core_56_1f',
'turTru1' => 'tursiops_truncatus_core_56_1c',
'vicPac1' => 'vicugna_pacos_core_56_1c',
'xenTro2' => 'xenopus_tropicalis_core_56_41n',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_57 = (
'anoCar1' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar1.0.57.gtf.gz',
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.57.gtf.gz',
'ce7' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS200.57.gtf.gz',
'calJac2' => 'callithrix_jacchus/Callithrix_jacchus.calJac3.57.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.57.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.57.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.57.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.57.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.57.gtf.gz',
'danRer6' => 'danio_rerio/Danio_rerio.Zv8.57.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.57.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.57.gtf.gz',
'dm5' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.13.57.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.57.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.57.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.57.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.57.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.57.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.57.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.57.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.57.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.57.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.57.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.57.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.57.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.57.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.57.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.57.gtf.gz',
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.57.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.57.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.57.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.57.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.57.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.57.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.57.gtf.gz',
'ponAbe2' => 'pongo_pygmaeus/Pongo_pygmaeus.PPYG2.57.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.57.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.57.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.57.gtf.gz',
'sacCer2' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.SGD1.01.57.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.57.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.57.gtf.gz',
'susScr1' => 'sus_scrofa/Sus_scrofa.Sscrofa9.57.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.57.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.57.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.57.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.57.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.57.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.57.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.57.gtf.gz',
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.57.gtf.gz',
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_57 = (
'anoCar1' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar1.0.57.pep.all.fa.gz',
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.57.pep.all.fa.gz',
'ce7' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS200.57.pep.all.fa.gz',
'calJac2' => 'callithrix_jacchus/pep/Callithrix_jacchus.calJac3.57.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.57.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.57.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.57.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.57.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.57.pep.all.fa.gz',
'danRer6' => 'danio_rerio/pep/Danio_rerio.Zv8.57.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.57.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.57.pep.all.fa.gz',
'dm5' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.13.57.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.57.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.57.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.57.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.57.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.57.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.57.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.57.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.57.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.57.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.57.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.57.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.57.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.57.pep.all.fa.gz ,',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.57.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.57.pep.all.fa.gz',
'myoLuc1' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.57.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.57.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.57.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.57.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.57.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.57.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.57.pep.all.fa.gz',
'ponAbe2' => 'pongo_pygmaeus/pep/Pongo_pygmaeus.PPYG2.57.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.57.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.57.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.57.pep.all.fa.gz',
'sacCer2' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.SGD1.01.57.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.57.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.57.pep.all.fa.gz',
'susScr1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa9.57.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.57.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.57.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.57.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.57.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.57.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.57.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.57.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.57.pep.all.fa.gz',
);

#	directory name under release-57/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_57 = (
'anoCar1' => 'anolis_carolinensis_core_57_1a' ,
'bosTau4' => 'bos_taurus_core_57_4f' ,
'calJac2' => 'callithrix_jacchus_core_57_3' ,
'canFam2' => 'canis_familiaris_core_57_2m' ,
'cavPor3' => 'cavia_porcellus_core_57_3a',
'ce7' => 'caenorhabditis_elegans_core_57_200a' ,
'choHof1' => 'choloepus_hoffmanni_core_57_1a',
'ci2' => 'ciona_intestinalis_core_57_2m',
'cioSav2' => 'ciona_savignyi_core_57_2h',
'danRer6' => 'danio_rerio_core_57_8c',
'dasNov2' => 'dasypus_novemcinctus_core_57_2a',
'dipOrd1' => 'dipodomys_ordii_core_57_1c',
'dm5' => 'drosophila_melanogaster_core_57_513b' ,
'echTel1' => 'echinops_telfairi_core_57_1g',
'equCab2' => 'equus_caballus_core_57_2d',
'eriEur1' => 'erinaceus_europaeus_core_57_1e',
'felCat3' => 'felis_catus_core_57_1f',
'galGal3' => 'gallus_gallus_core_57_2m',
'gasAcu1' => 'gasterosteus_aculeatus_core_57_1j',
'gorGor3' => 'gorilla_gorilla_core_57_3',
'hg19' => 'homo_sapiens_core_57_37b',
'loxAfr3' => 'loxodonta_africana_core_57_3',
'rheMac2' => 'macaca_mulatta_core_57_10l',
'macEug1' => 'macropus_eugenii_core_57_1',
'micMur1' => 'microcebus_murinus_core_57_1b',
'melGal1' => 'meleagris_gallopavo_core_57_2',
'monDom5' => 'monodelphis_domestica_core_57_5i',
'mm9' => 'mus_musculus_core_57_37j',
'myoLuc1' => 'myotis_lucifugus_core_57_1g',
'ochPri2' => 'ochotona_princeps_core_57_1c',
'ornAna1' => 'ornithorhynchus_anatinus_core_57_1k',
'oryCun2' => 'oryctolagus_cuniculus_core_57_2',
'oryLat2' => 'oryzias_latipes_core_57_1i',
'otoGar1' => 'otolemur_garnettii_core_57_1e',
'panTro2' => 'pan_troglodytes_core_57_21l',
'ponAbe2' => 'pongo_pygmaeus_core_57_1c',
'proCap1' => 'procavia_capensis_core_57_1c',
'pteVam1' => 'pteropus_vampyrus_core_57_1c',
'rn4' => 'rattus_norvegicus_core_57_34y',
'sacCer2' => 'saccharomyces_cerevisiae_core_57_1j',
'sorAra1' => 'sorex_araneus_core_57_1e',
'speTri1' => 'spermophilus_tridecemlineatus_core_57_1g',
'susScr1' => 'sus_scrofa_core_57_9a' ,
'taeGut1' => 'taeniopygia_guttata_core_57_1c',
'fr2' => 'takifugu_rubripes_core_57_4k',
'tarSyr1' => 'tarsius_syrichta_core_57_1c',
'tetNig2' => 'tetraodon_nigroviridis_core_57_8b',
'tupBel1' => 'tupaia_belangeri_core_57_1f',
'turTru1' => 'tursiops_truncatus_core_57_1c',
'vicPac1' => 'vicugna_pacos_core_57_1c',
'xenTro2' => 'xenopus_tropicalis_core_57_41n',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_58 = (
'anoCar1' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar1.0.58.gtf.gz',
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.58.gtf.gz',
'ce9' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS210.58.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.58.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.58.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.58.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.58.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.58.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.58.gtf.gz',
'danRer6' => 'danio_rerio/Danio_rerio.Zv8.58.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.58.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.58.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.13.58.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.58.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.58.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.58.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.58.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.58.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.58.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.58.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.58.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.58.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.58.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.58.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.58.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.58.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.58.gtf.gz',
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.58.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.58.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.58.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.58.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.58.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.58.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.58.gtf.gz',
'ponAbe2' => 'pongo_pygmaeus/Pongo_pygmaeus.PPYG2.58.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.58.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.58.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.58.gtf.gz',
'sacCer2' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.SGD1.01.58.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.58.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.58.gtf.gz',
'susScr1' => 'sus_scrofa/Sus_scrofa.Sscrofa9.58.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.58.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.58.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.58.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.58.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.58.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.58.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.58.gtf.gz',
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.58.gtf.gz',
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_58 = (
'anoCar1' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar1.0.58.pep.all.fa.gz',
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.58.pep.all.fa.gz',
'ce9' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS210.58.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.58.pep.all.fa.gz' ,
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.58.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.58.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.58.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.58.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.58.pep.all.fa.gz',
'danRer6' => 'danio_rerio/pep/Danio_rerio.Zv8.58.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.58.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.58.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.13.58.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.58.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.58.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.58.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.58.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.58.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.58.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.58.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.58.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.58.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.58.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.58.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.58.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.58.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.58.pep.all.fa.gz',
'myoLuc1' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.58.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.58.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.58.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.58.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.58.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.58.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.58.pep.all.fa.gz',
'ponAbe2' => 'pongo_pygmaeus/pep/Pongo_pygmaeus.PPYG2.58.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.58.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.58.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.58.pep.all.fa.gz',
'sacCer2' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.SGD1.01.58.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.58.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.58.pep.all.fa.gz',
'susScr1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa9.58.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.58.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.58.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.58.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.58.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.58.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.58.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.58.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.58.pep.all.fa.gz',
);

#	directory name under release-58/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_58 = (
'anoCar1' => 'anolis_carolinensis_core_58_1b' ,
'bosTau4' => 'bos_taurus_core_58_4g' ,
'calJac3' => 'callithrix_jacchus_core_58_321' ,
'canFam2' => 'canis_familiaris_core_58_2n' ,
'cavPor3' => 'cavia_porcellus_core_58_3b',
'ce9' =>  'caenorhabditis_elegans_core_58_210' ,
'choHof1' => 'choloepus_hoffmanni_core_58_1b',
'ci2' => 'ciona_intestinalis_core_58_2n',
'cioSav2' => 'ciona_savignyi_core_58_2i',
'danRer6' => 'danio_rerio_core_58_8d',
'dasNov2' => 'dasypus_novemcinctus_core_58_2b',
'dipOrd1' => 'dipodomys_ordii_core_58_1d',
'dm3' => 'drosophila_melanogaster_core_58_513b' ,
'echTel1' => 'echinops_telfairi_core_58_1h',
'equCab2' => 'equus_caballus_core_58_2e',
'eriEur1' => 'erinaceus_europaeus_core_58_1f',
'felCat3' => 'felis_catus_core_58_1g',
'galGal3' => 'gallus_gallus_core_58_2n',
'gasAcu1' => 'gasterosteus_aculeatus_core_58_1k',
'gorGor3' => 'gorilla_gorilla_core_58_3a',
'hg19' => 'homo_sapiens_core_58_37c',
'loxAfr3' => 'loxodonta_africana_core_58_3a',
'rheMac2' => 'macaca_mulatta_core_58_10m',
'macEug1' => 'macropus_eugenii_core_58_1a',
'micMur1' => 'microcebus_murinus_core_58_1c',
'monDom5' => 'monodelphis_domestica_core_58_5j',
'mm9' => 'mus_musculus_core_58_37k',
'myoLuc1' => 'myotis_lucifugus_core_58_1h',
'ochPri2' => 'ochotona_princeps_core_58_1d',
'ornAna1' => 'ornithorhynchus_anatinus_core_58_1l',
'oryCun2' => 'oryctolagus_cuniculus_core_58_2a',
'oryLat2' => 'oryzias_latipes_core_58_1j',
'otoGar1' => 'otolemur_garnettii_core_58_1f',
'panTro2' => 'pan_troglodytes_core_58_21m',
'ponAbe2' => 'pongo_pygmaeus_core_58_1d',
'proCap1' => 'procavia_capensis_core_58_1d',
'pteVam1' => 'pteropus_vampyrus_core_58_1d',
'rn4' => 'rattus_norvegicus_core_58_34z',
'sacCer2' => 'saccharomyces_cerevisiae_core_58_1j',
'sorAra1' => 'sorex_araneus_core_58_1f',
'speTri1' => 'spermophilus_tridecemlineatus_core_58_1h',
'susScr1' => 'sus_scrofa_core_58_9b' ,
'taeGut1' => 'taeniopygia_guttata_core_58_1d',
'fr2' => 'takifugu_rubripes_core_58_4l',
'tarSyr1' => 'tarsius_syrichta_core_58_1d',
'tetNig2' => 'tetraodon_nigroviridis_core_58_8c',
'tupBel1' => 'tupaia_belangeri_core_58_1g',
'turTru1' => 'tursiops_truncatus_core_58_1d',
'vicPac1' => 'vicugna_pacos_core_58_1d',
'xenTro2' => 'xenopus_tropicalis_core_58_41o',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_59 = (
'anoCar1' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar1.0.59.gtf.gz',
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.59.gtf.gz',
'ce9' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS210.59.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.59.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.59.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.59.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.59.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.59.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.59.gtf.gz',
'danRer6' => 'danio_rerio/Danio_rerio.Zv8.59.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.59.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.59.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.25.59.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.59.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.59.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.59.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.59.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.59.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.59.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.59.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.59.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.59.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.59.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.59.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.59.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.59.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.59.gtf.gz',
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.59.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.59.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.59.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.59.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.59.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.59.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.59.gtf.gz',
'ponAbe2' => 'pongo_pygmaeus/Pongo_pygmaeus.PPYG2.59.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.59.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.59.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.59.gtf.gz',
'sacCer2' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF2.59.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.59.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.59.gtf.gz',
'susScr1' => 'sus_scrofa/Sus_scrofa.Sscrofa9.59.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.59.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.59.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.59.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.59.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.59.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.59.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.59.gtf.gz',
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.59.gtf.gz',
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_59 = (
'anoCar1' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar1.0.59.pep.all.fa.gz',
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.59.pep.all.fa.gz',
'ce9' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS210.59.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.59.pep.all.fa.gz' ,
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.59.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.59.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.59.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.59.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.59.pep.all.fa.gz',
'danRer6' => 'danio_rerio/pep/Danio_rerio.Zv8.59.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.59.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.59.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.25.59.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.59.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.59.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.59.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.59.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.59.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.59.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.59.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.59.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.59.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.59.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.59.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.59.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.59.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.59.pep.all.fa.gz',
'myoLuc1' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.59.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.59.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.59.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.59.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.59.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.59.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.59.pep.all.fa.gz',
'ponAbe2' => 'pongo_pygmaeus/pep/Pongo_pygmaeus.PPYG2.59.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.59.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.59.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.59.pep.all.fa.gz',
'sacCer2' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF2.59.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.59.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.59.pep.all.fa.gz',
'susScr1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa9.59.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.59.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.59.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.59.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.59.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.59.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.59.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.59.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.59.pep.all.fa.gz',
);

#	directory name under release-59/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_59 = (
'anoCar1' => 'anolis_carolinensis_core_59_1c' ,
'bosTau4' => 'bos_taurus_core_59_4h' ,
'calJac3' => 'callithrix_jacchus_core_59_321a' ,
'canFam2' => 'canis_familiaris_core_59_2o' ,
'cavPor3' => 'cavia_porcellus_core_59_3c',
'ce9' =>  'caenorhabditis_elegans_core_59_210a' ,
'choHof1' => 'choloepus_hoffmanni_core_59_1c',
'ci2' => 'ciona_intestinalis_core_59_2o',
'cioSav2' => 'ciona_savignyi_core_59_2j',
'danRer6' => 'danio_rerio_core_59_8e',
'dasNov2' => 'dasypus_novemcinctus_core_59_2c',
'dipOrd1' => 'dipodomys_ordii_core_59_1e',
'dm3' => 'drosophila_melanogaster_core_59_525a' ,
'echTel1' => 'echinops_telfairi_core_59_1i',
'equCab2' => 'equus_caballus_core_59_2f',
'eriEur1' => 'erinaceus_europaeus_core_59_1g',
'felCat3' => 'felis_catus_core_59_1h',
'galGal3' => 'gallus_gallus_core_59_2o',
'gasAcu1' => 'gasterosteus_aculeatus_core_59_1l',
'gorGor3' => 'gorilla_gorilla_core_59_3b',
'hg19' => 'homo_sapiens_core_59_37d',
'loxAfr3' => 'loxodonta_africana_core_59_3b',
'rheMac2' => 'macaca_mulatta_core_59_10n',
'macEug1' => 'macropus_eugenii_core_59_1b',
'micMur1' => 'microcebus_murinus_core_59_1d',
'monDom5' => 'monodelphis_domestica_core_59_5k',
'mm9' => 'mus_musculus_core_59_37l',
'myoLuc1' => 'myotis_lucifugus_core_59_1i',
'ochPri2' => 'ochotona_princeps_core_59_1e',
'ornAna1' => 'ornithorhynchus_anatinus_core_59_1m',
'oryCun2' => 'oryctolagus_cuniculus_core_59_2b',
'oryLat2' => 'oryzias_latipes_core_59_1k',
'otoGar1' => 'otolemur_garnettii_core_59_1g',
'panTro2' => 'pan_troglodytes_core_59_21n',
'ponAbe2' => 'pongo_pygmaeus_core_59_1e',
'proCap1' => 'procavia_capensis_core_59_1e',
'pteVam1' => 'pteropus_vampyrus_core_59_1e',
'rn4' => 'rattus_norvegicus_core_59_34a',
'sacCer2' => 'saccharomyces_cerevisiae_core_59_2a',
'sorAra1' => 'sorex_araneus_core_59_1g',
'speTri1' => 'spermophilus_tridecemlineatus_core_59_1i',
'susScr1' => 'sus_scrofa_core_59_9c' ,
'taeGut1' => 'taeniopygia_guttata_core_59_1e',
'fr2' => 'takifugu_rubripes_core_59_4m',
'tarSyr1' => 'tarsius_syrichta_core_59_1e',
'tetNig2' => 'tetraodon_nigroviridis_core_59_8d',
'tupBel1' => 'tupaia_belangeri_core_59_1h',
'turTru1' => 'tursiops_truncatus_core_59_1e',
'vicPac1' => 'vicugna_pacos_core_59_1e',
'xenTro2' => 'xenopus_tropicalis_core_59_41p',
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_60 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.60.gtf.gz' ,
'anoCar1' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar1.0.60.gtf.gz' ,
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.60.gtf.gz' ,
'ce9' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS210.60.gtf.gz' ,
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.60.gtf.gz' ,
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.60.gtf.gz' ,
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.60.gtf.gz' ,
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.60.gtf.gz' ,
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.60.gtf.gz' ,
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.60.gtf.gz' ,
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.60.gtf.gz' ,
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.60.gtf.gz' ,
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.60.gtf.gz' ,
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.25.60.gtf.gz' ,
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.60.gtf.gz' ,
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.60.gtf.gz' ,
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.60.gtf.gz' ,
'felCat3' => 'felis_catus/Felis_catus.CAT.60.gtf.gz' ,
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.60.gtf.gz' ,
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.60.gtf.gz' ,
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.60.gtf.gz' ,
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.60.gtf.gz' ,
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.60.gtf.gz' ,
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.60.gtf.gz' ,
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.60.gtf.gz' ,
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.60.gtf.gz' ,
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.60.gtf.gz' ,
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.60.gtf.gz' ,
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.60.gtf.gz' ,
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.60.gtf.gz' ,
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.60.gtf.gz' ,
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.60.gtf.gz' ,
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.60.gtf.gz' ,
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.60.gtf.gz' ,
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.60.gtf.gz' ,
'ponAbe2' => 'pongo_pygmaeus/Pongo_pygmaeus.PPYG2.60.gtf.gz' ,
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.60.gtf.gz' ,
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.60.gtf.gz' ,
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.60.gtf.gz' ,
'sacCer2' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF2.60.gtf.gz' ,
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.60.gtf.gz' ,
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.60.gtf.gz' ,
'susScr1' => 'sus_scrofa/Sus_scrofa.Sscrofa9.60.gtf.gz' ,
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.60.gtf.gz' ,
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.60.gtf.gz' ,
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.60.gtf.gz' ,
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.60.gtf.gz' ,
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.60.gtf.gz' ,
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.60.gtf.gz' ,
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.60.gtf.gz' ,
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.60.gtf.gz' ,
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_60 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.60.pep.all.fa.gz' ,
'anoCar1' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar1.0.60.pep.all.fa.gz' ,
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.60.pep.all.fa.gz' ,
'ce9' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS210.60.pep.all.fa.gz' ,
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.60.pep.all.fa.gz' ,
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.60.pep.all.fa.gz' ,
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.60.pep.all.fa.gz' ,
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.60.pep.all.fa.gz' ,
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.60.pep.all.fa.gz' ,
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.60.pep.all.fa.gz' ,
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.60.pep.all.fa.gz' ,
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.60.pep.all.fa.gz' ,
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.60.pep.all.fa.gz' ,
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.25.60.pep.all.fa.gz' ,
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.60.pep.all.fa.gz' ,
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.60.pep.all.fa.gz' ,
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.60.pep.all.fa.gz' ,
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.60.pep.all.fa.gz' ,
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.60.pep.all.fa.gz' ,
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.60.pep.all.fa.gz' ,
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.60.pep.all.fa.gz' ,
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.60.pep.all.fa.gz' ,
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.60.pep.all.fa.gz' ,
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.60.pep.all.fa.gz' ,
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.60.pep.all.fa.gz' ,
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.60.pep.all.fa.gz' ,
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.60.pep.all.fa.gz' ,
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.60.pep.all.fa.gz' ,
'myoLuc1' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.60.pep.all.fa.gz' ,
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.60.pep.all.fa.gz' ,
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.60.pep.all.fa.gz' ,
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.60.pep.all.fa.gz' ,
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.60.pep.all.fa.gz' ,
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.60.pep.all.fa.gz' ,
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.60.pep.all.fa.gz' ,
'ponAbe2' => 'pongo_pygmaeus/pep/Pongo_pygmaeus.PPYG2.60.pep.all.fa.gz' ,
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.60.pep.all.fa.gz' ,
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.60.pep.all.fa.gz' ,
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.60.pep.all.fa.gz' ,
'sacCer2' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF2.60.pep.all.fa.gz' ,
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.60.pep.all.fa.gz' ,
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.60.pep.all.fa.gz' ,
'susScr1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa9.60.pep.all.fa.gz' ,
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.60.pep.all.fa.gz' ,
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.60.pep.all.fa.gz' ,
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.60.pep.all.fa.gz' ,
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.60.pep.all.fa.gz' ,
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.60.pep.all.fa.gz' ,
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.60.pep.all.fa.gz' ,
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.60.pep.all.fa.gz' ,
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.60.pep.all.fa.gz' ,
);

#	directory name under release-60/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_60 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_60_1' ,
'anoCar1' => 'anolis_carolinensis_core_60_1d' ,
'bosTau4' => 'bos_taurus_core_60_4i' ,
'ce9' => 'caenorhabditis_elegans_core_60_210b' ,
'calJac3' => 'callithrix_jacchus_core_60_321b' ,
'canFam2' => 'canis_familiaris_core_60_2p' ,
'cavPor3' => 'cavia_porcellus_core_60_3d' ,
'choHof1' => 'choloepus_hoffmanni_core_60_1d' ,
'ci2' => 'ciona_intestinalis_core_60_2p' ,
'cioSav2' => 'ciona_savignyi_core_60_2k' ,
'danRer7' => 'danio_rerio_core_60_9' ,
'dasNov2' => 'dasypus_novemcinctus_core_60_2d' ,
'dipOrd1' => 'dipodomys_ordii_core_60_1f' ,
'dm3' => 'drosophila_melanogaster_core_60_525b' ,
'echTel1' => 'echinops_telfairi_core_60_1j' ,
'equCab2' => 'equus_caballus_core_60_2g' ,
'eriEur1' => 'erinaceus_europaeus_core_60_1h' ,
'felCat3' => 'felis_catus_core_60_1i' ,
'galGal3' => 'gallus_gallus_core_60_2p' ,
'gasAcu1' => 'gasterosteus_aculeatus_core_60_1m' ,
'gorGor3' => 'gorilla_gorilla_core_60_3c' ,
'hg19' => 'homo_sapiens_core_60_37e' ,
'loxAfr3' => 'loxodonta_africana_core_60_3c' ,
'rheMac2' => 'macaca_mulatta_core_60_10o' ,
'macEug1' => 'macropus_eugenii_core_60_1c' ,
'micMur1' => 'microcebus_murinus_core_60_1e' ,
'monDom5' => 'monodelphis_domestica_core_60_5l' ,
'mm9' => 'mus_musculus_core_60_37m' ,
'myoLuc1' => 'myotis_lucifugus_core_60_1j' ,
'ochPri2' => 'ochotona_princeps_core_60_1f' ,
'ornAna1' => 'ornithorhynchus_anatinus_core_60_1n' ,
'oryCun2' => 'oryctolagus_cuniculus_core_60_3' ,
'oryLat2' => 'oryzias_latipes_core_60_1l' ,
'otoGar1' => 'otolemur_garnettii_core_60_1h' ,
'panTro2' => 'pan_troglodytes_core_60_21o' ,
'ponAbe2' => 'pongo_pygmaeus_core_60_1f' ,
'proCap1' => 'procavia_capensis_core_60_1f' ,
'pteVam1' => 'pteropus_vampyrus_core_60_1f' ,
'rn4' => 'rattus_norvegicus_core_60_34b' ,
'sacCer2' => 'saccharomyces_cerevisiae_core_60_2b' ,
'sorAra1' => 'sorex_araneus_core_60_1h' ,
'speTri1' => 'spermophilus_tridecemlineatus_core_60_1j' ,
'susScr1' => 'sus_scrofa_core_60_9d' ,
'taeGut1' => 'taeniopygia_guttata_core_60_1f' ,
'fr2' => 'takifugu_rubripes_core_60_4n' ,
'tarSyr1' => 'tarsius_syrichta_core_60_1f' ,
'tetNig2' => 'tetraodon_nigroviridis_core_60_8e' ,
'tupBel1' => 'tupaia_belangeri_core_60_1i' ,
'turTru1' => 'tursiops_truncatus_core_60_1f' ,
'vicPac1' => 'vicugna_pacos_core_60_1f' ,
'xenTro2' => 'xenopus_tropicalis_core_60_41q' ,
);

# key is UCSC db name, result is FTP file name under the gtf directory
my %ensGeneGtfFileNames_61 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.61.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.61.gtf.gz',
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.61.gtf.gz',
'ce10' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS220.61.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.61.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.61.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.61.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.61.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.61.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.61.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.61.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.61.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.61.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.25.61.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.61.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.61.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.61.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.61.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.61.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.61.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.61.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.61.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.61.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.61.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.61.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.61.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.61.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.61.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.61.gtf.gz',
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.61.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.61.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.61.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.61.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.61.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.61.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.61.gtf.gz',
'ponAbe2' => 'pongo_pygmaeus/Pongo_pygmaeus.PPYG2.61.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.61.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.61.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.61.gtf.gz',
'sacCer2' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF2.61.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.61.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.61.gtf.gz',
'susScr1' => 'sus_scrofa/Sus_scrofa.Sscrofa9.61.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.61.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.61.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.61.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.61.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.61.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.61.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.61.gtf.gz',
'xenTro2' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI4.1.61.gtf.gz',
);

# key is UCSC db name, result is FTP file name under the fasta directory
my %ensGeneFtpPeptideFileNames_61 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.61.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.61.pep.all.fa.gz',
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.61.pep.all.fa.gz',
'ce10' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS220.61.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.61.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.61.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.61.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.61.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.61.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.61.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.61.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.61.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.61.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.25.61.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.61.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.61.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.61.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.61.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.61.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.61.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.61.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.61.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.61.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.61.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.61.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.61.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.61.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.61.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.61.pep.all.fa.gz',
'myoLuc1' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.61.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.61.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.61.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.61.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.61.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.61.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.61.pep.all.fa.gz',
'ponAbe2' => 'pongo_pygmaeus/pep/Pongo_pygmaeus.PPYG2.61.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.61.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.61.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.61.pep.all.fa.gz',
'sacCer2' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF2.61.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.61.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.61.pep.all.fa.gz',
'susScr1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa9.61.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.61.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.61.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.61.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.61.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.61.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.61.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.61.pep.all.fa.gz',
'xenTro2' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI4.1.61.pep.all.fa.gz',
);

#	directory name under release-61/mysql/ to find 'seq_region' and
#	'assembly' table copies for GeneScaffold coordinate conversions
my %ensGeneFtpMySqlFileNames_61 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_61_1a',
'anoCar2' => 'anolis_carolinensis_core_61_2',
'bosTau4' => 'bos_taurus_core_61_4j',
'ce10' => 'caenorhabditis_elegans_core_61_220',
'calJac3' => 'callithrix_jacchus_core_61_321c',
'canFam2' => 'canis_familiaris_core_61_2q',
'cavPor3' => 'cavia_porcellus_core_61_3e',
'choHof1' => 'choloepus_hoffmanni_core_61_1e',
'ci2' => 'ciona_intestinalis_core_61_2q',
'cioSav2' => 'ciona_savignyi_core_61_2l',
'danRer7' => 'danio_rerio_core_61_9a',
'dasNov2' => 'dasypus_novemcinctus_core_61_2e',
'dipOrd1' => 'dipodomys_ordii_core_61_1g',
'dm3' => 'drosophila_melanogaster_core_61_525c',
'echTel1' => 'echinops_telfairi_core_61_1k',
'equCab2' => 'equus_caballus_core_61_2h',
'eriEur1' => 'erinaceus_europaeus_core_61_1i',
'felCat3' => 'felis_catus_core_61_1j',
'galGal3' => 'gallus_gallus_core_61_2q',
'gasAcu1' => 'gasterosteus_aculeatus_core_61_1n',
'gorGor3' => 'gorilla_gorilla_core_61_3d',
'hg19' => 'homo_sapiens_core_61_37f',
'loxAfr3' => 'loxodonta_africana_core_61_3d',
'rheMac2' => 'macaca_mulatta_core_61_10p',
'macEug1' => 'macropus_eugenii_core_61_1d',
'melGal1' => 'meleagris_gallopavo_core_61_21',
'micMur1' => 'microcebus_murinus_core_61_1f',
'monDom5' => 'monodelphis_domestica_core_61_5m',
'mm9' => 'mus_musculus_core_61_37n',
'myoLuc1' => 'myotis_lucifugus_core_61_1k',
'ochPri2' => 'ochotona_princeps_core_61_1g',
'ornAna1' => 'ornithorhynchus_anatinus_core_61_1o',
'oryCun2' => 'oryctolagus_cuniculus_core_61_3a',
'oryLat2' => 'oryzias_latipes_core_61_1m',
'otoGar1' => 'otolemur_garnettii_core_61_1i',
'panTro2' => 'pan_troglodytes_core_61_21p',
'ponAbe2' => 'pongo_pygmaeus_core_61_1g',
'proCap1' => 'procavia_capensis_core_61_1g',
'pteVam1' => 'pteropus_vampyrus_core_61_1g',
'rn4' => 'rattus_norvegicus_core_61_34c',
'sacCer2' => 'saccharomyces_cerevisiae_core_61_2c',
'sorAra1' => 'sorex_araneus_core_61_1i',
'speTri1' => 'spermophilus_tridecemlineatus_core_61_1k',
'susScr1' => 'sus_scrofa_core_61_9e',
'taeGut1' => 'taeniopygia_guttata_core_61_1g',
'fr2' => 'takifugu_rubripes_core_61_4o',
'tarSyr1' => 'tarsius_syrichta_core_61_1g',
'tetNig2' => 'tetraodon_nigroviridis_core_61_8f',
'tupBel1' => 'tupaia_belangeri_core_61_1j',
'turTru1' => 'tursiops_truncatus_core_61_1g',
'vicPac1' => 'vicugna_pacos_core_61_1g',
'xenTro2' => 'xenopus_tropicalis_core_61_41r',
);

my %ensGeneGtfFileNames_62 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.62.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.62.gtf.gz',
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.62.gtf.gz',
'ce10' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS220.62.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.62.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.62.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.62.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.62.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.62.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.62.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.62.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.62.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.62.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.25.62.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.62.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.62.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.62.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.62.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.62.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.62.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.62.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.62.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.62.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.62.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.62.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.62.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.62.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.62.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.62.gtf.gz',
'myoLuc1' => 'myotis_lucifugus/Myotis_lucifugus.MICROBAT1.62.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.62.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.62.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.62.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.62.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.62.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.62.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.62.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.62.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.62.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.62.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.62.gtf.gz',
'sacCer2' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF2.62.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.62.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.62.gtf.gz',
'susScr1' => 'sus_scrofa/Sus_scrofa.Sscrofa9.62.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.62.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.62.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.62.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.62.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.62.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.62.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.62.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.62.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_62 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.62.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.62.pep.all.fa.gz',
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.62.pep.all.fa.gz',
'ce10' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS220.62.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.62.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.62.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.62.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.62.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.62.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.62.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.62.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.62.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.62.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.25.62.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.62.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.62.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.62.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.62.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.62.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.62.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.62.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.62.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.62.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.62.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.62.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.62.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.62.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.62.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.62.pep.all.fa.gz',
'myoLuc1' => 'myotis_lucifugus/pep/Myotis_lucifugus.MICROBAT1.62.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.62.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.62.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.62.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.62.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.62.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.62.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.62.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.62.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.62.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.62.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.62.pep.all.fa.gz',
'sacCer2' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF2.62.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.62.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.62.pep.all.fa.gz',
'susScr1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa9.62.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.62.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.62.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.62.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.62.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.62.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.62.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.62.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.62.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_62 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_62_1b',
'anoCar2' => 'anolis_carolinensis_core_62_2a',
'bosTau4' => 'bos_taurus_core_62_4k',
'ce10' => 'caenorhabditis_elegans_core_62_220a',
'calJac3' => 'callithrix_jacchus_core_62_321d',
'canFam2' => 'canis_familiaris_core_62_2r',
'cavPor3' => 'cavia_porcellus_core_62_3f',
'choHof1' => 'choloepus_hoffmanni_core_62_1f',
'ci2' => 'ciona_intestinalis_core_62_2r',
'cioSav2' => 'ciona_savignyi_core_62_2m',
'danRer7' => 'danio_rerio_core_62_9b',
'dasNov2' => 'dasypus_novemcinctus_core_62_2f',
'dipOrd1' => 'dipodomys_ordii_core_62_1h',
'dm3' => 'drosophila_melanogaster_core_62_525d',
'echTel1' => 'echinops_telfairi_core_62_1l',
'equCab2' => 'equus_caballus_core_62_2i',
'eriEur1' => 'erinaceus_europaeus_core_62_1j',
'felCat3' => 'felis_catus_core_62_1k',
'galGal3' => 'gallus_gallus_core_62_2r',
'gasAcu1' => 'gasterosteus_aculeatus_core_62_1o',
'gorGor3' => 'gorilla_gorilla_core_62_3e',
'hg19' => 'homo_sapiens_core_62_37g',
'loxAfr3' => 'loxodonta_africana_core_62_3e',
'rheMac2' => 'macaca_mulatta_core_62_10q',
'macEug1' => 'macropus_eugenii_core_62_1e',
'melGal1' => 'meleagris_gallopavo_core_62_21a',
'micMur1' => 'microcebus_murinus_core_62_1g',
'monDom5' => 'monodelphis_domestica_core_62_5n',
'mm9' => 'mus_musculus_core_62_37o',
'myoLuc1' => 'myotis_lucifugus_core_62_1l',
'nomLeu1' => 'nomascus_leucogenys_core_62_1',
'ochPri2' => 'ochotona_princeps_core_62_1h',
'ornAna1' => 'ornithorhynchus_anatinus_core_62_1p',
'oryCun2' => 'oryctolagus_cuniculus_core_62_3b',
'oryLat2' => 'oryzias_latipes_core_62_1n',
'otoGar1' => 'otolemur_garnettii_core_62_1j',
'panTro2' => 'pan_troglodytes_core_62_21q',
'ponAbe2' => 'pongo_abelii_core_62_1h',
'proCap1' => 'procavia_capensis_core_62_1h',
'pteVam1' => 'pteropus_vampyrus_core_62_1h',
'rn4' => 'rattus_norvegicus_core_62_34d',
'sacCer2' => 'saccharomyces_cerevisiae_core_62_2d',
'sorAra1' => 'sorex_araneus_core_62_1j',
'speTri1' => 'spermophilus_tridecemlineatus_core_62_1l',
'susScr1' => 'sus_scrofa_core_62_9f',
'taeGut1' => 'taeniopygia_guttata_core_62_1h',
'fr2' => 'takifugu_rubripes_core_62_4p',
'tarSyr1' => 'tarsius_syrichta_core_62_1h',
'tetNig2' => 'tetraodon_nigroviridis_core_62_8g',
'tupBel1' => 'tupaia_belangeri_core_62_1k',
'turTru1' => 'tursiops_truncatus_core_62_1h',
'vicPac1' => 'vicugna_pacos_core_62_1h',
'xenTro3' => 'xenopus_tropicalis_core_62_42',
);

my %ensGeneGtfFileNames_63 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.63.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.63.gtf.gz',
'bosTau4' => 'bos_taurus/Bos_taurus.Btau_4.0.63.gtf.gz',
'ce10' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS220.63.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.63.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.63.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.63.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.63.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.63.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.63.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.63.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.63.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.63.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.25.63.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.63.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.63.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.63.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.63.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.63.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.63.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.63.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.63.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.63.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.63.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.63.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.63.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.63.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.63.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.63.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.63.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.63.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.63.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.63.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.63.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.63.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.63.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.63.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.63.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.63.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.63.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.63.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF3.63.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.63.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.63.gtf.gz',
'susScr1' => 'sus_scrofa/Sus_scrofa.Sscrofa9.63.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.63.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.63.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.63.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.63.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.63.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.63.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.63.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.63.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_63 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.63.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.63.pep.all.fa.gz',
'bosTau4' => 'bos_taurus/pep/Bos_taurus.Btau_4.0.63.pep.all.fa.gz',
'ce10' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS220.63.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.63.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.63.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.63.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.63.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.63.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.63.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.63.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.63.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.63.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.25.63.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.63.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.63.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.63.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.63.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.63.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.63.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.63.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.63.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.63.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.63.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.63.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.63.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.63.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.63.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.63.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.63.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.63.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.63.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.63.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.63.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.63.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.63.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.63.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.63.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.63.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.63.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.63.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF3.63.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.63.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.63.pep.all.fa.gz',
'susScr1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa9.63.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.63.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.63.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.63.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.63.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.63.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.63.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.63.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.63.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_63 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_63_1',
'anoCar2' => 'anolis_carolinensis_core_63_2',
'bosTau4' => 'bos_taurus_core_63_4',
'ce10' => 'caenorhabditis_elegans_core_63_220',
'calJac3' => 'callithrix_jacchus_core_63_321',
'canFam2' => 'canis_familiaris_core_63_2',
'cavPor3' => 'cavia_porcellus_core_63_3',
'choHof1' => 'choloepus_hoffmanni_core_63_1',
'ci2' => 'ciona_intestinalis_core_63_2',
'cioSav2' => 'ciona_savignyi_core_63_2',
'danRer7' => 'danio_rerio_core_63_9',
'dasNov2' => 'dasypus_novemcinctus_core_63_2',
'dipOrd1' => 'dipodomys_ordii_core_63_1',
'dm3' => 'drosophila_melanogaster_core_63_525',
'echTel1' => 'echinops_telfairi_core_63_1',
'equCab2' => 'equus_caballus_core_63_2',
'eriEur1' => 'erinaceus_europaeus_core_63_1',
'felCat3' => 'felis_catus_core_63_1',
'galGal3' => 'gallus_gallus_core_63_2',
'gasAcu1' => 'gasterosteus_aculeatus_core_63_1',
'gorGor3' => 'gorilla_gorilla_core_63_3',
'hg19' => 'homo_sapiens_core_63_37',
'loxAfr3' => 'loxodonta_africana_core_63_3',
'rheMac2' => 'macaca_mulatta_core_63_10',
'macEug1' => 'macropus_eugenii_core_63_1',
'melGal1' => 'meleagris_gallopavo_core_63_21',
'micMur1' => 'microcebus_murinus_core_63_1',
'monDom5' => 'monodelphis_domestica_core_63_5',
'mm9' => 'mus_musculus_core_63_37',
'myoLuc2' => 'myotis_lucifugus_core_63_2',
'nomLeu1' => 'nomascus_leucogenys_core_63_1',
'ochPri2' => 'ochotona_princeps_core_63_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_63_1',
'oryCun2' => 'oryctolagus_cuniculus_core_63_3',
'oryLat2' => 'oryzias_latipes_core_63_1',
'otoGar1' => 'otolemur_garnettii_core_63_1',
'panTro2' => 'pan_troglodytes_core_63_21',
'ponAbe2' => 'pongo_abelii_core_63_1',
'proCap1' => 'procavia_capensis_core_63_1',
'pteVam1' => 'pteropus_vampyrus_core_63_1',
'rn4' => 'rattus_norvegicus_core_63_34',
'sacCer3' => 'saccharomyces_cerevisiae_core_63_3',
'sorAra1' => 'sorex_araneus_core_63_1',
'speTri1' => 'spermophilus_tridecemlineatus_core_63_1',
'susScr1' => 'sus_scrofa_core_63_9',
'taeGut1' => 'taeniopygia_guttata_core_63_1',
'fr2' => 'takifugu_rubripes_core_63_4',
'tarSyr1' => 'tarsius_syrichta_core_63_1',
'tetNig2' => 'tetraodon_nigroviridis_core_63_8',
'tupBel1' => 'tupaia_belangeri_core_63_1',
'turTru1' => 'tursiops_truncatus_core_63_1',
'vicPac1' => 'vicugna_pacos_core_63_1',
'xenTro3' => 'xenopus_tropicalis_core_63_42',
);

my %ensGeneGtfFileNames_64 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.64.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.64.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.64.gtf.gz',
'ce10' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS220.64.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.64.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.64.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.64.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.64.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.64.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.64.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.64.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.64.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.64.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.25.64.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.64.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.64.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.64.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.64.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.64.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.64.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.64.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.64.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.64.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.64.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.64.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.64.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.64.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.64.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.64.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.64.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.64.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.64.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.64.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.64.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.64.gtf.gz',
'otoGar1' => 'otolemur_garnettii/Otolemur_garnettii.BUSHBABY1.64.gtf.gz',
'panTro2' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.64.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Petromyzon_marinus_7.0.64.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.64.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.64.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.64.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.64.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF3.64.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.64.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.64.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.64.gtf.gz',
'susScr1' => 'sus_scrofa/Sus_scrofa.Sscrofa9.64.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.64.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.64.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.64.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.64.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.64.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.64.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.64.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.64.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_64 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.64.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.64.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.64.pep.all.fa.gz',
'ce10' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS220.64.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.64.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.64.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.64.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.64.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.64.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.64.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.64.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.64.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.64.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.25.64.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.64.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.64.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.64.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.64.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.64.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.64.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.64.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.64.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.64.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.64.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.64.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.64.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.64.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.64.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.64.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.64.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.64.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.64.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.64.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.64.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.64.pep.all.fa.gz',
'otoGar1' => 'otolemur_garnettii/pep/Otolemur_garnettii.BUSHBABY1.64.pep.all.fa.gz',
'panTro2' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.64.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Petromyzon_marinus_7.0.64.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.64.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.64.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.64.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.64.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF3.64.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.64.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.64.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.64.pep.all.fa.gz',
'susScr1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa9.64.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.64.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.64.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.64.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.64.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.64.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.64.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.64.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.64.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_64 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_64_1',
'anoCar2' => 'anolis_carolinensis_core_64_2',
'bosTau6' => 'bos_taurus_core_64_31',
'ce10' => 'caenorhabditis_elegans_core_64_220',
'calJac3' => 'callithrix_jacchus_core_64_321',
'canFam2' => 'canis_familiaris_core_64_2',
'cavPor3' => 'cavia_porcellus_core_64_3',
'choHof1' => 'choloepus_hoffmanni_core_64_1',
'ci2' => 'ciona_intestinalis_core_64_2',
'cioSav2' => 'ciona_savignyi_core_64_2',
'danRer7' => 'danio_rerio_core_64_9',
'dasNov2' => 'dasypus_novemcinctus_core_64_2',
'dipOrd1' => 'dipodomys_ordii_core_64_1',
'dm3' => 'drosophila_melanogaster_core_64_525',
'echTel1' => 'echinops_telfairi_core_64_1',
'equCab2' => 'equus_caballus_core_64_2',
'eriEur1' => 'erinaceus_europaeus_core_64_1',
'felCat3' => 'felis_catus_core_64_1',
'galGal3' => 'gallus_gallus_core_64_2',
'gasAcu1' => 'gasterosteus_aculeatus_core_64_1',
'gorGor3' => 'gorilla_gorilla_core_64_31',
'hg19' => 'homo_sapiens_core_64_37',
'loxAfr3' => 'loxodonta_africana_core_64_3',
'rheMac2' => 'macaca_mulatta_core_64_10',
'macEug1' => 'macropus_eugenii_core_64_1',
'melGal1' => 'meleagris_gallopavo_core_64_21',
'micMur1' => 'microcebus_murinus_core_64_1',
'monDom5' => 'monodelphis_domestica_core_64_5',
'mm9' => 'mus_musculus_core_64_37',
'myoLuc2' => 'myotis_lucifugus_core_64_2',
'nomLeu1' => 'nomascus_leucogenys_core_64_1',
'ochPri2' => 'ochotona_princeps_core_64_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_64_1',
'oryCun2' => 'oryctolagus_cuniculus_core_64_3',
'oryLat2' => 'oryzias_latipes_core_64_1',
'otoGar1' => 'otolemur_garnettii_core_64_1',
'panTro2' => 'pan_troglodytes_core_64_21',
'petMar2' => 'petromyzon_marinus_core_64_7',
'ponAbe2' => 'pongo_abelii_core_64_1',
'proCap1' => 'procavia_capensis_core_64_1',
'pteVam1' => 'pteropus_vampyrus_core_64_1',
'rn4' => 'rattus_norvegicus_core_64_34',
'sacCer3' => 'saccharomyces_cerevisiae_core_64_3',
'sarHar1' => 'sarcophilus_harrisii_core_64_7',
'sorAra1' => 'sorex_araneus_core_64_1',
'speTri1' => 'spermophilus_tridecemlineatus_core_64_1',
'susScr1' => 'sus_scrofa_core_64_9',
'taeGut1' => 'taeniopygia_guttata_core_64_1',
'fr2' => 'takifugu_rubripes_core_64_4',
'tarSyr1' => 'tarsius_syrichta_core_64_1',
'tetNig2' => 'tetraodon_nigroviridis_core_64_8',
'tupBel1' => 'tupaia_belangeri_core_64_1',
'turTru1' => 'tursiops_truncatus_core_64_1',
'vicPac1' => 'vicugna_pacos_core_64_1',
'xenTro3' => 'xenopus_tropicalis_core_64_42',
);

my %ensGeneGtfFileNames_65 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.65.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.65.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.65.gtf.gz',
'ce10' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WS220.65.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.65.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.65.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.65.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.65.gtf.gz',
'ci2' => 'ciona_intestinalis/Ciona_intestinalis.JGI2.65.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.65.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.65.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.65.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.65.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.25.65.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.65.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.65.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.65.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.65.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.65.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.65.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.65.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.65.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.65.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.65.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.65.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.65.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.65.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.65.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.65.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.65.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.65.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.65.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.65.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.65.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.65.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.65.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.65.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.65.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.65.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.65.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.65.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.65.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.65.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF4.65.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.65.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.65.gtf.gz',
'speTri1' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.SQUIRREL.65.gtf.gz',
'susScr1' => 'sus_scrofa/Sus_scrofa.Sscrofa9.65.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.65.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.65.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.65.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.65.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.65.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.65.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.65.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.65.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_65 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.65.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.65.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.65.pep.all.fa.gz',
'ce10' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WS220.65.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.65.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.65.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.65.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.65.pep.all.fa.gz',
'ci2' => 'ciona_intestinalis/pep/Ciona_intestinalis.JGI2.65.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.65.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.65.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.65.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.65.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.65.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.65.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.65.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.65.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.65.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.65.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.65.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.65.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.65.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.65.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.65.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.65.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.65.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.65.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.65.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.65.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.65.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.65.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.65.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.65.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.65.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.65.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.65.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.65.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.65.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.65.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.65.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.65.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.65.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.65.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF4.65.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.65.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.65.pep.all.fa.gz',
'speTri1' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.SQUIRREL.65.pep.all.fa.gz',
'susScr1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa9.65.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.65.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.65.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.65.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.65.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.65.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.65.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.65.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.65.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_65 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_65_1',
'anoCar2' => 'anolis_carolinensis_core_65_2',
'bosTau6' => 'bos_taurus_core_65_31',
'ce10' => 'caenorhabditis_elegans_core_65_220',
'calJac3' => 'callithrix_jacchus_core_65_321',
'canFam2' => 'canis_familiaris_core_65_2',
'cavPor3' => 'cavia_porcellus_core_65_3',
'choHof1' => 'choloepus_hoffmanni_core_65_1',
'ci2' => 'ciona_intestinalis_core_65_2',
'cioSav2' => 'ciona_savignyi_core_65_2',
'danRer7' => 'danio_rerio_core_65_9',
'dasNov2' => 'dasypus_novemcinctus_core_65_2',
'dipOrd1' => 'dipodomys_ordii_core_65_1',
'dm3' => 'drosophila_melanogaster_core_65_539',
'echTel1' => 'echinops_telfairi_core_65_1',
'equCab2' => 'equus_caballus_core_65_2',
'eriEur1' => 'erinaceus_europaeus_core_65_1',
'felCat3' => 'felis_catus_core_65_1',
'gadMor1' => 'gadus_morhua_core_65_1',
'galGal3' => 'gallus_gallus_core_65_2',
'gasAcu1' => 'gasterosteus_aculeatus_core_65_1',
'gorGor3' => 'gorilla_gorilla_core_65_31',
'hg19' => 'homo_sapiens_core_65_37',
'loxAfr3' => 'loxodonta_africana_core_65_3',
'rheMac2' => 'macaca_mulatta_core_65_10',
'macEug1' => 'macropus_eugenii_core_65_1',
'melGal1' => 'meleagris_gallopavo_core_65_21',
'micMur1' => 'microcebus_murinus_core_65_1',
'monDom5' => 'monodelphis_domestica_core_65_5',
'mm9' => 'mus_musculus_core_65_37',
'myoLuc2' => 'myotis_lucifugus_core_65_2',
'nomLeu1' => 'nomascus_leucogenys_core_65_1',
'ochPri2' => 'ochotona_princeps_core_65_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_65_1',
'oryCun2' => 'oryctolagus_cuniculus_core_65_3',
'oryLat2' => 'oryzias_latipes_core_65_1',
'otoGar3' => 'otolemur_garnettii_core_65_3',
'panTro4' => 'pan_troglodytes_core_65_214',
'petMar2' => 'petromyzon_marinus_core_65_7',
'ponAbe2' => 'pongo_abelii_core_65_1',
'proCap1' => 'procavia_capensis_core_65_1',
'pteVam1' => 'pteropus_vampyrus_core_65_1',
'rn4' => 'rattus_norvegicus_core_65_34',
'sacCer3' => 'saccharomyces_cerevisiae_core_65_4',
'sarHar1' => 'sarcophilus_harrisii_core_65_7',
'sorAra1' => 'sorex_araneus_core_65_1',
'speTri1' => 'spermophilus_tridecemlineatus_core_65_1',
'susScr1' => 'sus_scrofa_core_65_9',
'taeGut1' => 'taeniopygia_guttata_core_65_1',
'fr2' => 'takifugu_rubripes_core_65_4',
'tarSyr1' => 'tarsius_syrichta_core_65_1',
'tetNig2' => 'tetraodon_nigroviridis_core_65_8',
'tupBel1' => 'tupaia_belangeri_core_65_1',
'turTru1' => 'tursiops_truncatus_core_65_1',
'vicPac1' => 'vicugna_pacos_core_65_1',
'xenTro3' => 'xenopus_tropicalis_core_65_42',
);

my %ensGeneGtfFileNames_67 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.67.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.67.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.67.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel215.67.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.67.gtf.gz',
'canFam2' => 'canis_familiaris/Canis_familiaris.BROADD2.67.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.67.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.67.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.67.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.67.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.67.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.67.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.67.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.67.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.67.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.67.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.67.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.67.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.67.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.67.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.67.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.67.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.67.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.67.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.67.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.67.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.67.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.67.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.67.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.67.gtf.gz',
'mm9' => 'mus_musculus/Mus_musculus.NCBIM37.67.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.67.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.67.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.67.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.67.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.67.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.67.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.67.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.67.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.67.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.67.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.67.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.67.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.67.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.67.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF4.67.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.67.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.67.gtf.gz',
'speTri2' => 'spermophilus_tridecemlineatus/Spermophilus_tridecemlineatus.spetri2.67.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.67.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.67.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.67.gtf.gz',
'tarSyr1' => 'Sarsius_syrichta/Tarsius_syrichta.tarSyr1.67.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.67.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.67.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.67.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.67.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.67.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_67 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.67.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.67.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.67.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel215.67.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.67.pep.all.fa.gz',
'canFam2' => 'canis_familiaris/pep/Canis_familiaris.BROADD2.67.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.67.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.67.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.67.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.67.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.67.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.67.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.67.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.67.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.67.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.67.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.67.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.67.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.67.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.67.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.67.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.67.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.67.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.67.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.67.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.67.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.67.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.67.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.67.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.67.pep.all.fa.gz',
'mm9' => 'mus_musculus/pep/Mus_musculus.NCBIM37.67.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.67.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.67.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.67.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.67.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.67.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.67.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.67.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.67.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.67.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.67.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.67.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.67.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.67.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.67.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF4.67.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.67.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.67.pep.all.fa.gz',
'speTri2' => 'spermophilus_tridecemlineatus/pep/Spermophilus_tridecemlineatus.spetri2.67.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.67.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.67.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.67.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.67.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.67.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.67.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.67.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.67.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.67.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_67 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_67_1',
'anoCar2' => 'anolis_carolinensis_core_67_2',
'bosTau6' => 'bos_taurus_core_67_31',
'ce11' => 'caenorhabditis_elegans_core_67_230',
'calJac3' => 'callithrix_jacchus_core_67_321',
'canFam2' => 'canis_familiaris_core_67_2',
'cavPor3' => 'cavia_porcellus_core_67_3',
'choHof1' => 'choloepus_hoffmanni_core_67_1',
'ci3' => 'ciona_intestinalis_core_67_3',
'cioSav2' => 'ciona_savignyi_core_67_2',
'danRer7' => 'danio_rerio_core_67_9',
'dasNov2' => 'dasypus_novemcinctus_core_67_2',
'dipOrd1' => 'dipodomys_ordii_core_67_1',
'dm3' => 'drosophila_melanogaster_core_67_539',
'echTel1' => 'echinops_telfairi_core_67_1',
'equCab2' => 'equus_caballus_core_67_2',
'eriEur1' => 'erinaceus_europaeus_core_67_1',
'felCat3' => 'felis_catus_core_67_1',
'gadMor1' => 'gadus_morhua_core_67_1',
'galGal3' => 'gallus_gallus_core_67_2',
'gasAcu1' => 'gasterosteus_aculeatus_core_67_1',
'gorGor3' => 'gorilla_gorilla_core_67_31',
'hg19' => 'homo_sapiens_core_67_37',
'latCha1' => 'latimeria_chalumnae_core_67_1',
'loxAfr3' => 'loxodonta_africana_core_67_3',
'rheMac2' => 'macaca_mulatta_core_67_10',
'macEug1' => 'macropus_eugenii_core_67_1',
'melGal1' => 'meleagris_gallopavo_core_67_21',
'micMur1' => 'microcebus_murinus_core_67_1',
'monDom5' => 'monodelphis_domestica_core_67_5',
'mm9' => 'mus_musculus_core_67_37',
'myoLuc2' => 'myotis_lucifugus_core_67_2',
'nomLeu1' => 'nomascus_leucogenys_core_67_1',
'ochPri2' => 'ochotona_princeps_core_67_1',
'oreNil1' => 'oreochromis_niloticus_core_67_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_67_1',
'oryCun2' => 'oryctolagus_cuniculus_core_67_3',
'oryLat2' => 'oryzias_latipes_core_67_1',
'otoGar3' => 'otolemur_garnettii_core_67_3',
'panTro4' => 'pan_troglodytes_core_67_214',
'petMar2' => 'petromyzon_marinus_core_67_7',
'ponAbe2' => 'pongo_abelii_core_67_1',
'proCap1' => 'procavia_capensis_core_67_1',
'pteVam1' => 'pteropus_vampyrus_core_67_1',
'rn4' => 'rattus_norvegicus_core_67_34',
'sacCer3' => 'saccharomyces_cerevisiae_core_67_4',
'sarHar1' => 'sarcophilus_harrisii_core_67_7',
'sorAra1' => 'sorex_araneus_core_67_1',
'speTri2' => 'spermophilus_tridecemlineatus_core_67_2',
'susScr3' => 'sus_scrofa_core_67_102',
'taeGut1' => 'taeniopygia_guttata_core_67_1',
'fr2' => 'takifugu_rubripes_core_67_4',
'tarSyr1' => 'tarsius_syrichta_core_67_1',
'tetNig2' => 'tetraodon_nigroviridis_core_67_8',
'tupBel1' => 'tupaia_belangeri_core_67_1',
'turTru1' => 'tursiops_truncatus_core_67_1',
'vicPac1' => 'vicugna_pacos_core_67_1',
'xenTro3' => 'xenopus_tropicalis_core_67_42',
);

my %ensGeneGtfFileNames_68 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.68.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.68.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.68.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel215.68.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.68.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.68.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.68.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.68.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.68.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.68.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.68.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.68.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.68.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.68.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.68.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.68.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.68.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.68.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.68.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.68.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.68.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.68.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.68.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.68.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.68.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.68.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.68.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.68.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.68.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.68.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.68.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.68.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.68.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.68.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.68.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.68.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.68.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.68.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.68.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.68.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.68.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.68.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.68.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.68.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.68.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.68.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.68.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF4.68.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.68.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.68.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.68.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.68.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.68.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.68.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.68.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.68.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.68.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.68.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.68.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_68 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.68.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.68.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.68.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel215.68.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.68.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.68.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.68.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.68.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.68.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.68.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.68.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.68.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.68.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.68.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.68.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.68.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.68.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.68.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.68.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.68.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.68.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.68.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.68.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.68.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.68.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.68.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.68.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.68.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.68.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.68.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.68.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.68.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.68.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.68.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.68.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.68.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.68.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.68.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.68.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.68.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.68.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.68.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.68.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.68.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.68.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.68.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.68.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF4.68.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.68.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.68.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.68.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.68.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.68.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.68.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.68.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.68.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.68.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.68.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.68.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_68 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_68_1',
'anoCar2' => 'anolis_carolinensis_core_68_2',
'bosTau6' => 'bos_taurus_core_68_31',
'ce11' => 'caenorhabditis_elegans_core_68_230',
'calJac3' => 'callithrix_jacchus_core_68_321',
'canFam3' => 'canis_familiaris_core_68_31',
'cavPor3' => 'cavia_porcellus_core_68_3',
'choHof1' => 'choloepus_hoffmanni_core_68_1',
'ci3' => 'ciona_intestinalis_core_68_3',
'cioSav2' => 'ciona_savignyi_core_68_2',
'danRer7' => 'danio_rerio_core_68_9',
'dasNov2' => 'dasypus_novemcinctus_core_68_2',
'dipOrd1' => 'dipodomys_ordii_core_68_1',
'dm3' => 'drosophila_melanogaster_core_68_539',
'echTel1' => 'echinops_telfairi_core_68_1',
'equCab2' => 'equus_caballus_core_68_2',
'eriEur1' => 'erinaceus_europaeus_core_68_1',
'felCat3' => 'felis_catus_core_68_1',
'gadMor1' => 'gadus_morhua_core_68_1',
'galGal3' => 'gallus_gallus_core_68_2',
'gasAcu1' => 'gasterosteus_aculeatus_core_68_1',
'gorGor3' => 'gorilla_gorilla_core_68_31',
'hg19' => 'homo_sapiens_core_68_37',
'speTri2' => 'ictidomys_tridecemlineatus_core_68_2',
'latCha1' => 'latimeria_chalumnae_core_68_1',
'loxAfr3' => 'loxodonta_africana_core_68_3',
'rheMac2' => 'macaca_mulatta_core_68_10',
'macEug1' => 'macropus_eugenii_core_68_1',
'melGal1' => 'meleagris_gallopavo_core_68_21',
'micMur1' => 'microcebus_murinus_core_68_1',
'monDom5' => 'monodelphis_domestica_core_68_5',
'mm10' => 'mus_musculus_core_68_38',
'myoLuc2' => 'myotis_lucifugus_core_68_2',
'nomLeu1' => 'nomascus_leucogenys_core_68_1',
'ochPri2' => 'ochotona_princeps_core_68_1',
'oreNil1' => 'oreochromis_niloticus_core_68_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_68_1',
'oryCun2' => 'oryctolagus_cuniculus_core_68_3',
'oryLat2' => 'oryzias_latipes_core_68_1',
'otoGar3' => 'otolemur_garnettii_core_68_3',
'panTro4' => 'pan_troglodytes_core_68_214',
'pelSin1' => 'pelodiscus_sinensis_core_68_1',
'petMar2' => 'petromyzon_marinus_core_68_7',
'ponAbe2' => 'pongo_abelii_core_68_1',
'proCap1' => 'procavia_capensis_core_68_1',
'pteVam1' => 'pteropus_vampyrus_core_68_1',
'rn4' => 'rattus_norvegicus_core_68_34',
'sacCer3' => 'saccharomyces_cerevisiae_core_68_4',
'sarHar1' => 'sarcophilus_harrisii_core_68_7',
'sorAra1' => 'sorex_araneus_core_68_1',
'susScr3' => 'sus_scrofa_core_68_102',
'taeGut1' => 'taeniopygia_guttata_core_68_1',
'fr2' => 'takifugu_rubripes_core_68_4',
'tarSyr1' => 'tarsius_syrichta_core_68_1',
'tetNig2' => 'tetraodon_nigroviridis_core_68_8',
'tupBel1' => 'tupaia_belangeri_core_68_1',
'turTru1' => 'tursiops_truncatus_core_68_1',
'vicPac1' => 'vicugna_pacos_core_68_1',
'xenTro3' => 'xenopus_tropicalis_core_68_42',
);

my %ensGeneGtfFileNames_69 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.69.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.69.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.69.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel215.69.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.69.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.69.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.69.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.69.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.69.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.69.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.69.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.69.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.69.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.69.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.69.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.69.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.69.gtf.gz',
'felCat3' => 'felis_catus/Felis_catus.CAT.69.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.69.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.69.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.69.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.69.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.69.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.69.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.69.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.69.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.69.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.69.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.69.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.69.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.69.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.69.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.69.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.69.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.69.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.69.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.69.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.69.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.69.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.69.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.69.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.69.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.69.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.69.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.69.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.69.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.69.gtf.gz',
'rn4' => 'rattus_norvegicus/Rattus_norvegicus.RGSC3.4.69.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF4.69.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.69.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.69.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.69.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.69.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.69.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.69.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.69.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.69.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.69.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.69.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.69.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.69.gtf.gz',
);


my %ensGeneFtpPeptideFileNames_69 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.69.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.69.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.69.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel215.69.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.69.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.69.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.69.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.69.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.69.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.69.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.69.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.69.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.69.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.69.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.69.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.69.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.69.pep.all.fa.gz',
'felCat3' => 'felis_catus/pep/Felis_catus.CAT.69.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.69.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.69.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.69.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.69.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.69.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.69.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.69.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.69.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.69.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.69.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.69.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.69.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.69.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.69.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.69.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.69.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.69.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.69.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.69.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.69.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.69.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.69.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.69.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.69.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.69.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.69.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.69.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.69.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.69.pep.all.fa.gz',
'rn4' => 'rattus_norvegicus/pep/Rattus_norvegicus.RGSC3.4.69.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF4.69.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.69.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.69.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.69.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.69.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.69.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.69.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.69.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.69.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.69.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.69.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.69.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.69.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_69 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_69_1',
'anoCar2' => 'anolis_carolinensis_core_69_2',
'bosTau6' => 'bos_taurus_core_69_31',
'ce11' => 'caenorhabditis_elegans_core_69_230',
'calJac3' => 'callithrix_jacchus_core_69_321',
'canFam3' => 'canis_familiaris_core_69_31',
'cavPor3' => 'cavia_porcellus_core_69_3',
'choHof1' => 'choloepus_hoffmanni_core_69_1',
'ci3' => 'ciona_intestinalis_core_69_3',
'cioSav2' => 'ciona_savignyi_core_69_2',
'danRer7' => 'danio_rerio_core_69_9',
'dasNov2' => 'dasypus_novemcinctus_core_69_2',
'dipOrd1' => 'dipodomys_ordii_core_69_1',
'dm3' => 'drosophila_melanogaster_core_69_539',
'echTel1' => 'echinops_telfairi_core_69_1',
'equCab2' => 'equus_caballus_core_69_2',
'eriEur1' => 'erinaceus_europaeus_core_69_1',
'felCat3' => 'felis_catus_core_69_1',
'gadMor1' => 'gadus_morhua_core_69_1',
'galGal3' => 'gallus_gallus_core_69_2',
'gasAcu1' => 'gasterosteus_aculeatus_core_69_1',
'gorGor3' => 'gorilla_gorilla_core_69_31',
'hg19' => 'homo_sapiens_core_69_37',
'speTri2' => 'ictidomys_tridecemlineatus_core_69_2',
'latCha1' => 'latimeria_chalumnae_core_69_1',
'loxAfr3' => 'loxodonta_africana_core_69_3',
'rheMac2' => 'macaca_mulatta_core_69_10',
'macEug1' => 'macropus_eugenii_core_69_1',
'melGal1' => 'meleagris_gallopavo_core_69_21',
'micMur1' => 'microcebus_murinus_core_69_1',
'monDom5' => 'monodelphis_domestica_core_69_5',
'mm10' => 'mus_musculus_core_69_38',
'musFur1' => 'mustela_putorius_furo_core_69_1',
'myoLuc2' => 'myotis_lucifugus_core_69_2',
'nomLeu1' => 'nomascus_leucogenys_core_69_1',
'ochPri2' => 'ochotona_princeps_core_69_1',
'oreNil1' => 'oreochromis_niloticus_core_69_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_69_1',
'oryCun2' => 'oryctolagus_cuniculus_core_69_3',
'oryLat2' => 'oryzias_latipes_core_69_1',
'otoGar3' => 'otolemur_garnettii_core_69_3',
'panTro4' => 'pan_troglodytes_core_69_214',
'pelSin1' => 'pelodiscus_sinensis_core_69_1',
'petMar2' => 'petromyzon_marinus_core_69_7',
'ponAbe2' => 'pongo_abelii_core_69_1',
'proCap1' => 'procavia_capensis_core_69_1',
'pteVam1' => 'pteropus_vampyrus_core_69_1',
'rn4' => 'rattus_norvegicus_core_69_34',
'sacCer3' => 'saccharomyces_cerevisiae_core_69_4',
'sarHar1' => 'sarcophilus_harrisii_core_69_7',
'sorAra1' => 'sorex_araneus_core_69_1',
'susScr3' => 'sus_scrofa_core_69_102',
'taeGut1' => 'taeniopygia_guttata_core_69_1',
'fr2' => 'takifugu_rubripes_core_69_4',
'tarSyr1' => 'tarsius_syrichta_core_69_1',
'tetNig2' => 'tetraodon_nigroviridis_core_69_8',
'tupBel1' => 'tupaia_belangeri_core_69_1',
'turTru1' => 'tursiops_truncatus_core_69_1',
'vicPac1' => 'vicugna_pacos_core_69_1',
'xenTro3' => 'xenopus_tropicalis_core_69_42',
'xipMac1' => 'xiphophorus_maculatus_core_69_1',
);


my %ensGeneGtfFileNames_70 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.70.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.70.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.70.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel215.70.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.70.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.70.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.70.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.70.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.70.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.70.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.70.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.70.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.70.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.70.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.70.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.70.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.70.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.70.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.70.gtf.gz',
'galGal3' => 'gallus_gallus/Gallus_gallus.WASHUC2.70.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.70.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.70.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.70.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.70.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.70.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.70.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.70.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.70.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.70.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.70.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.70.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.70.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.70.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.70.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.70.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.70.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.70.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.70.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.70.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.70.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.70.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.70.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.70.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.70.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.70.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.70.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.70.gtf.gz',
'rn5' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_5.0.70.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF4.70.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.70.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.70.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.70.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.70.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.70.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.70.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.70.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.70.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.70.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.70.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.70.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.70.gtf.gz',
);


my %ensGeneFtpPeptideFileNames_70 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.70.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.70.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.70.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel215.70.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.70.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.70.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.70.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.70.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.70.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.70.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.70.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.70.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.70.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.70.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.70.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.70.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.70.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.70.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.70.pep.all.fa.gz',
'galGal3' => 'gallus_gallus/pep/Gallus_gallus.WASHUC2.70.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.70.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.70.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.70.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.70.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.70.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.70.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.70.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.70.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.70.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.70.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.70.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.70.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.70.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.70.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.70.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.70.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.70.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.70.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.70.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.70.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.70.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.70.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.70.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.70.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.70.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.70.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.70.pep.all.fa.gz',
'rn5' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_5.0.70.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF4.70.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.70.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.70.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.70.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.70.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.70.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.70.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.70.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.70.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.70.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.70.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.70.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.70.pep.all.fa.gz',
);


my %ensGeneFtpMySqlFileNames_70 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_70_1',
'anoCar2' => 'anolis_carolinensis_core_70_2',
'bosTau6' => 'bos_taurus_core_70_31',
'ce11' => 'caenorhabditis_elegans_core_70_230',
'calJac3' => 'callithrix_jacchus_core_70_321',
'canFam3' => 'canis_familiaris_core_70_31',
'cavPor3' => 'cavia_porcellus_core_70_3',
'choHof1' => 'choloepus_hoffmanni_core_70_1',
'ci3' => 'ciona_intestinalis_core_70_3',
'cioSav2' => 'ciona_savignyi_core_70_2',
'danRer7' => 'danio_rerio_core_70_9',
'dasNov2' => 'dasypus_novemcinctus_core_70_2',
'dipOrd1' => 'dipodomys_ordii_core_70_1',
'dm3' => 'drosophila_melanogaster_core_70_546',
'echTel1' => 'echinops_telfairi_core_70_1',
'equCab2' => 'equus_caballus_core_70_2',
'eriEur1' => 'erinaceus_europaeus_core_70_1',
'felCat5' => 'felis_catus_core_70_62',
'gadMor1' => 'gadus_morhua_core_70_1',
'galGal3' => 'gallus_gallus_core_70_2',
'gasAcu1' => 'gasterosteus_aculeatus_core_70_1',
'gorGor3' => 'gorilla_gorilla_core_70_31',
'hg19' => 'homo_sapiens_core_70_37',
'speTri2' => 'ictidomys_tridecemlineatus_core_70_2',
'latCha1' => 'latimeria_chalumnae_core_70_1',
'loxAfr3' => 'loxodonta_africana_core_70_3',
'rheMac2' => 'macaca_mulatta_core_70_10',
'macEug1' => 'macropus_eugenii_core_70_1',
'melGal1' => 'meleagris_gallopavo_core_70_21',
'micMur1' => 'microcebus_murinus_core_70_1',
'monDom5' => 'monodelphis_domestica_core_70_5',
'mm10' => 'mus_musculus_core_70_38',
'musFur1' => 'mustela_putorius_furo_core_70_1',
'myoLuc2' => 'myotis_lucifugus_core_70_2',
'nomLeu1' => 'nomascus_leucogenys_core_70_1',
'ochPri2' => 'ochotona_princeps_core_70_1',
'oreNil1' => 'oreochromis_niloticus_core_70_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_70_1',
'oryCun2' => 'oryctolagus_cuniculus_core_70_3',
'oryLat2' => 'oryzias_latipes_core_70_1',
'otoGar3' => 'otolemur_garnettii_core_70_3',
'panTro4' => 'pan_troglodytes_core_70_214',
'pelSin1' => 'pelodiscus_sinensis_core_70_1',
'petMar2' => 'petromyzon_marinus_core_70_7',
'ponAbe2' => 'pongo_abelii_core_70_1',
'proCap1' => 'procavia_capensis_core_70_1',
'pteVam1' => 'pteropus_vampyrus_core_70_1',
'rn5' => 'rattus_norvegicus_core_70_5',
'sacCer3' => 'saccharomyces_cerevisiae_core_70_4',
'sarHar1' => 'sarcophilus_harrisii_core_70_7',
'sorAra1' => 'sorex_araneus_core_70_1',
'susScr3' => 'sus_scrofa_core_70_102',
'taeGut1' => 'taeniopygia_guttata_core_70_1',
'fr2' => 'takifugu_rubripes_core_70_4',
'tarSyr1' => 'tarsius_syrichta_core_70_1',
'tetNig2' => 'tetraodon_nigroviridis_core_70_8',
'tupBel1' => 'tupaia_belangeri_core_70_1',
'turTru1' => 'tursiops_truncatus_core_70_1',
'vicPac1' => 'vicugna_pacos_core_70_1',
'xenTro3' => 'xenopus_tropicalis_core_70_42',
'xipMac1' => 'xiphophorus_maculatus_core_70_1',
);

my %ensGeneGtfFileNames_71 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.71.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.71.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.71.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.71.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.71.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.71.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.71.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.71.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.71.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.71.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.71.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.71.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.71.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.71.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.71.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.71.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.71.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.71.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.71.gtf.gz',
'galGal4' => 'gallus_gallus/Gallus_gallus.Galgal4.71.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.71.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.71.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.71.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.71.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.71.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.71.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.71.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.71.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.71.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.71.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.71.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.71.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.71.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.71.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.71.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.71.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.71.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.71.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.71.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.71.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.71.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.71.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.71.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.71.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.71.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.71.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.71.gtf.gz',
'rn5' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_5.0.71.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF4.71.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.71.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.71.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.71.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.71.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.71.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.71.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.71.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.71.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.71.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.71.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.71.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.71.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_71 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.71.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.71.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.71.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.71.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.71.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.71.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.71.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.71.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.71.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.71.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.71.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.71.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.71.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.71.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.71.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.71.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.71.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.71.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.71.pep.all.fa.gz',
'galGal4' => 'gallus_gallus/pep/Gallus_gallus.Galgal4.71.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.71.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.71.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.71.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.71.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.71.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.71.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.71.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.71.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.71.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.71.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.71.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.71.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.71.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.71.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.71.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.71.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.71.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.71.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.71.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.71.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.71.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.71.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.71.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.71.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.71.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.71.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.71.pep.all.fa.gz',
'rn5' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_5.0.71.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF4.71.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.71.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.71.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.71.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.71.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.71.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.71.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.71.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.71.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.71.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.71.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.71.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.71.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_71 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_71_1',
'anoCar2' => 'anolis_carolinensis_core_71_2',
'bosTau6' => 'bos_taurus_core_71_31',
'ce11' => 'caenorhabditis_elegans_core_71_235',
'calJac3' => 'callithrix_jacchus_core_71_321',
'canFam3' => 'canis_familiaris_core_71_31',
'cavPor3' => 'cavia_porcellus_core_71_3',
'choHof1' => 'choloepus_hoffmanni_core_71_1',
'ci3' => 'ciona_intestinalis_core_71_3',
'cioSav2' => 'ciona_savignyi_core_71_2',
'danRer7' => 'danio_rerio_core_71_9',
'dasNov2' => 'dasypus_novemcinctus_core_71_2',
'dipOrd1' => 'dipodomys_ordii_core_71_1',
'dm3' => 'drosophila_melanogaster_core_71_546',
'echTel1' => 'echinops_telfairi_core_71_1',
'equCab2' => 'equus_caballus_core_71_2',
'eriEur1' => 'erinaceus_europaeus_core_71_1',
'felCat5' => 'felis_catus_core_71_62',
'gadMor1' => 'gadus_morhua_core_71_1',
'galGal4' => 'gallus_gallus_core_71_4',
'gasAcu1' => 'gasterosteus_aculeatus_core_71_1',
'gorGor3' => 'gorilla_gorilla_core_71_31',
'hg19' => 'homo_sapiens_core_71_37',
'speTri2' => 'ictidomys_tridecemlineatus_core_71_2',
'latCha1' => 'latimeria_chalumnae_core_71_1',
'loxAfr3' => 'loxodonta_africana_core_71_3',
'rheMac2' => 'macaca_mulatta_core_71_10',
'macEug1' => 'macropus_eugenii_core_71_1',
'melGal1' => 'meleagris_gallopavo_core_71_21',
'micMur1' => 'microcebus_murinus_core_71_1',
'monDom5' => 'monodelphis_domestica_core_71_5',
'mm10' => 'mus_musculus_core_71_38',
'musFur1' => 'mustela_putorius_furo_core_71_1',
'myoLuc2' => 'myotis_lucifugus_core_71_2',
'nomLeu1' => 'nomascus_leucogenys_core_71_1',
'ochPri2' => 'ochotona_princeps_core_71_1',
'oreNil1' => 'oreochromis_niloticus_core_71_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_71_1',
'oryCun2' => 'oryctolagus_cuniculus_core_71_3',
'oryLat2' => 'oryzias_latipes_core_71_1',
'otoGar3' => 'otolemur_garnettii_core_71_3',
'panTro4' => 'pan_troglodytes_core_71_214',
'pelSin1' => 'pelodiscus_sinensis_core_71_1',
'petMar2' => 'petromyzon_marinus_core_71_7',
'ponAbe2' => 'pongo_abelii_core_71_1',
'proCap1' => 'procavia_capensis_core_71_1',
'pteVam1' => 'pteropus_vampyrus_core_71_1',
'rn5' => 'rattus_norvegicus_core_71_5',
'sacCer3' => 'saccharomyces_cerevisiae_core_71_4',
'sarHar1' => 'sarcophilus_harrisii_core_71_7',
'sorAra1' => 'sorex_araneus_core_71_1',
'susScr3' => 'sus_scrofa_core_71_102',
'taeGut1' => 'taeniopygia_guttata_core_71_1',
'fr2' => 'takifugu_rubripes_core_71_4',
'tarSyr1' => 'tarsius_syrichta_core_71_1',
'tetNig2' => 'tetraodon_nigroviridis_core_71_8',
'tupBel1' => 'tupaia_belangeri_core_71_1',
'turTru1' => 'tursiops_truncatus_core_71_1',
'vicPac1' => 'vicugna_pacos_core_71_1',
'xenTro3' => 'xenopus_tropicalis_core_71_42',
'xipMac1' => 'xiphophorus_maculatus_core_71_1',
);

my %ensGeneGtfFileNames_72 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.72.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.72.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.72.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.72.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.72.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.72.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.72.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.72.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.72.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.72.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.72.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.72.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.72.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.72.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.72.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.72.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.72.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.72.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.72.gtf.gz',
'galGal4' => 'gallus_gallus/Gallus_gallus.Galgal4.72.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.72.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.72.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.72.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.72.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.72.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.72.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.72.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.72.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.72.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.72.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.72.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.72.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.72.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.72.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.72.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.72.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.72.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.72.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.oryCun2.72.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.72.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.72.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.72.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.72.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.72.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.72.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.72.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.72.gtf.gz',
'rn5' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_5.0.72.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF4.72.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.72.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.72.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.72.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.72.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.72.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.72.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.72.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.72.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.72.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.72.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.72.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.72.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_72 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.72.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.72.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.72.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.72.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.72.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.72.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.72.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.72.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.72.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.72.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.72.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.72.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.72.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.72.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.72.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.72.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.72.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.72.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.72.pep.all.fa.gz',
'galGal4' => 'gallus_gallus/pep/Gallus_gallus.Galgal4.72.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.72.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.72.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.72.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.72.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.72.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.72.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.72.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.72.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.72.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.72.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.72.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.72.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.72.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.72.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.72.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.72.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.72.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.72.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.oryCun2.72.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.72.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.72.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.72.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.72.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.72.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.72.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.72.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.72.pep.all.fa.gz',
'rn5' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_5.0.72.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF4.72.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.72.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.72.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.72.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.72.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.72.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.72.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.72.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.72.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.72.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.72.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.72.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.72.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_72 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_72_1',
'anoCar2' => 'anolis_carolinensis_core_72_2',
'bosTau6' => 'bos_taurus_core_72_31',
'ce11' => 'caenorhabditis_elegans_core_72_235',
'calJac3' => 'callithrix_jacchus_core_72_321',
'canFam3' => 'canis_familiaris_core_72_31',
'cavPor3' => 'cavia_porcellus_core_72_3',
'choHof1' => 'choloepus_hoffmanni_core_72_1',
'ci3' => 'ciona_intestinalis_core_72_3',
'cioSav2' => 'ciona_savignyi_core_72_2',
'danRer7' => 'danio_rerio_core_72_9',
'dasNov2' => 'dasypus_novemcinctus_core_72_2',
'dipOrd1' => 'dipodomys_ordii_core_72_1',
'dm3' => 'drosophila_melanogaster_core_72_546',
'echTel1' => 'echinops_telfairi_core_72_1',
'equCab2' => 'equus_caballus_core_72_2',
'eriEur1' => 'erinaceus_europaeus_core_72_1',
'felCat5' => 'felis_catus_core_72_62',
'gadMor1' => 'gadus_morhua_core_72_1',
'galGal4' => 'gallus_gallus_core_72_4',
'gasAcu1' => 'gasterosteus_aculeatus_core_72_1',
'gorGor3' => 'gorilla_gorilla_core_72_31',
'hg19' => 'homo_sapiens_core_72_37',
'speTri2' => 'ictidomys_tridecemlineatus_core_72_2',
'latCha1' => 'latimeria_chalumnae_core_72_1',
'loxAfr3' => 'loxodonta_africana_core_72_3',
'rheMac2' => 'macaca_mulatta_core_72_10',
'macEug1' => 'macropus_eugenii_core_72_1',
'melGal1' => 'meleagris_gallopavo_core_72_21',
'micMur1' => 'microcebus_murinus_core_72_1',
'monDom5' => 'monodelphis_domestica_core_72_5',
'mm10' => 'mus_musculus_core_72_38',
'musFur1' => 'mustela_putorius_furo_core_72_1',
'myoLuc2' => 'myotis_lucifugus_core_72_2',
'nomLeu1' => 'nomascus_leucogenys_core_72_1',
'ochPri2' => 'ochotona_princeps_core_72_1',
'oreNil1' => 'oreochromis_niloticus_core_72_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_72_1',
'oryCun2' => 'oryctolagus_cuniculus_core_72_3',
'oryLat2' => 'oryzias_latipes_core_72_1',
'otoGar3' => 'otolemur_garnettii_core_72_3',
'panTro4' => 'pan_troglodytes_core_72_214',
'pelSin1' => 'pelodiscus_sinensis_core_72_1',
'petMar2' => 'petromyzon_marinus_core_72_7',
'ponAbe2' => 'pongo_abelii_core_72_1',
'proCap1' => 'procavia_capensis_core_72_1',
'pteVam1' => 'pteropus_vampyrus_core_72_1',
'rn5' => 'rattus_norvegicus_core_72_5',
'sacCer3' => 'saccharomyces_cerevisiae_core_72_4',
'sarHar1' => 'sarcophilus_harrisii_core_72_7',
'sorAra1' => 'sorex_araneus_core_72_1',
'susScr3' => 'sus_scrofa_core_72_102',
'taeGut1' => 'taeniopygia_guttata_core_72_1',
'fr2' => 'takifugu_rubripes_core_72_4',
'tarSyr1' => 'tarsius_syrichta_core_72_1',
'tetNig2' => 'tetraodon_nigroviridis_core_72_8',
'tupBel1' => 'tupaia_belangeri_core_72_1',
'turTru1' => 'tursiops_truncatus_core_72_1',
'vicPac1' => 'vicugna_pacos_core_72_1',
'xenTro3' => 'xenopus_tropicalis_core_72_42',
'xipMac1' => 'xiphophorus_maculatus_core_72_1',
);

my %ensGeneGtfFileNames_73 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.73.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.73.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.73.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.73.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.73.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.73.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.73.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.73.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.73.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.73.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.73.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.73.gtf.gz',
'dasNov2' => 'dasypus_novemcinctus/Dasypus_novemcinctus.dasNov2.73.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.73.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.73.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.73.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.73.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.73.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.73.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.73.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.73.gtf.gz',
'galGal4' => 'gallus_gallus/Gallus_gallus.Galgal4.73.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.73.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.73.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.73.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.73.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.73.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.73.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.73.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.73.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.73.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.73.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.73.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.73.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.73.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.73.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.73.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.73.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.73.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.73.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.73.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.73.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.73.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.73.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.73.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.73.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.73.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.73.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.73.gtf.gz',
'rn5' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_5.0.73.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF4.73.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.73.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.73.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.73.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.73.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.73.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.73.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.73.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.73.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.73.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.73.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.73.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.73.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_73 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.73.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.73.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.73.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.73.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.73.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.73.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.73.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.73.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.73.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.73.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.73.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.73.pep.all.fa.gz',
'dasNov2' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.dasNov2.73.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.73.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.73.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.73.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.73.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.73.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.73.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.73.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.73.pep.all.fa.gz',
'galGal4' => 'gallus_gallus/pep/Gallus_gallus.Galgal4.73.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.73.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.73.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.73.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.73.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.73.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.73.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.73.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.73.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.73.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.73.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.73.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.73.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.73.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.73.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.73.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.73.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.73.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.73.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.73.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.73.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.73.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.73.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.73.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.73.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.73.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.73.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.73.pep.all.fa.gz',
'rn5' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_5.0.73.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF4.73.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.73.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.73.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.73.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.73.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.73.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.73.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.73.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.73.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.73.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.73.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.73.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.73.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_73 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_73_1',
'anaPla1' => 'anas_platyrhynchos_core_73_1',
'anoCar2' => 'anolis_carolinensis_core_73_2',
'bosTau6' => 'bos_taurus_core_73_31',
'ce11' => 'caenorhabditis_elegans_core_73_235',
'calJac3' => 'callithrix_jacchus_core_73_321',
'canFam3' => 'canis_familiaris_core_73_31',
'cavPor3' => 'cavia_porcellus_core_73_3',
'choHof1' => 'choloepus_hoffmanni_core_73_1',
'ci3' => 'ciona_intestinalis_core_73_3',
'cioSav2' => 'ciona_savignyi_core_73_2',
'danRer7' => 'danio_rerio_core_73_9',
'dasNov2' => 'dasypus_novemcinctus_core_73_2',
'dipOrd1' => 'dipodomys_ordii_core_73_1',
'dm3' => 'drosophila_melanogaster_core_73_546',
'echTel1' => 'echinops_telfairi_core_73_1',
'equCab2' => 'equus_caballus_core_73_2',
'eriEur1' => 'erinaceus_europaeus_core_73_1',
'felCat5' => 'felis_catus_core_73_62',
'ficAlb1' => 'ficedula_albicollis_core_73_1',
'gadMor1' => 'gadus_morhua_core_73_1',
'galGal4' => 'gallus_gallus_core_73_4',
'gasAcu1' => 'gasterosteus_aculeatus_core_73_1',
'gorGor3' => 'gorilla_gorilla_core_73_31',
'hg19' => 'homo_sapiens_core_73_37',
'speTri2' => 'ictidomys_tridecemlineatus_core_73_2',
'latCha1' => 'latimeria_chalumnae_core_73_1',
'loxAfr3' => 'loxodonta_africana_core_73_3',
'rheMac2' => 'macaca_mulatta_core_73_10',
'macEug1' => 'macropus_eugenii_core_73_1',
'melGal1' => 'meleagris_gallopavo_core_73_21',
'micMur1' => 'microcebus_murinus_core_73_1',
'monDom5' => 'monodelphis_domestica_core_73_5',
'mm10' => 'mus_musculus_core_73_38',
'musFur1' => 'mustela_putorius_furo_core_73_1',
'myoLuc2' => 'myotis_lucifugus_core_73_2',
'nomLeu1' => 'nomascus_leucogenys_core_73_1',
'ochPri2' => 'ochotona_princeps_core_73_1',
'oreNil1' => 'oreochromis_niloticus_core_73_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_73_1',
'oryCun2' => 'oryctolagus_cuniculus_core_73_2',
'oryLat2' => 'oryzias_latipes_core_73_1',
'otoGar3' => 'otolemur_garnettii_core_73_3',
'panTro4' => 'pan_troglodytes_core_73_214',
'pelSin1' => 'pelodiscus_sinensis_core_73_1',
'petMar2' => 'petromyzon_marinus_core_73_7',
'ponAbe2' => 'pongo_abelii_core_73_1',
'proCap1' => 'procavia_capensis_core_73_1',
'pteVam1' => 'pteropus_vampyrus_core_73_1',
'rn5' => 'rattus_norvegicus_core_73_5',
'sacCer3' => 'saccharomyces_cerevisiae_core_73_4',
'sarHar1' => 'sarcophilus_harrisii_core_73_7',
'sorAra1' => 'sorex_araneus_core_73_1',
'susScr3' => 'sus_scrofa_core_73_102',
'taeGut1' => 'taeniopygia_guttata_core_73_1',
'fr2' => 'takifugu_rubripes_core_73_4',
'tarSyr1' => 'tarsius_syrichta_core_73_1',
'tetNig2' => 'tetraodon_nigroviridis_core_73_8',
'tupBel1' => 'tupaia_belangeri_core_73_1',
'turTru1' => 'tursiops_truncatus_core_73_1',
'vicPac1' => 'vicugna_pacos_core_73_1',
'xenTro3' => 'xenopus_tropicalis_core_73_42',
'xipMac1' => 'xiphophorus_maculatus_core_73_1',
);

my %ensGeneGtfFileNames_74 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.74.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.74.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.74.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.74.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.74.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.74.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.74.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.74.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.74.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.74.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.74.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.74.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.74.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.74.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.74.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.74.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.74.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.74.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.74.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.74.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.74.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.74.gtf.gz',
'galGal4' => 'gallus_gallus/Gallus_gallus.Galgal4.74.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.74.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.74.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.74.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.74.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.74.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.74.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.74.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.74.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.74.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.74.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.74.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.74.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.74.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.74.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.74.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.74.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.74.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.74.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.74.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.74.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.74.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.74.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.74.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.74.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.74.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.74.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.74.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.74.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.74.gtf.gz',
'rn5' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_5.0.74.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.EF4.74.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.74.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.74.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.74.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.74.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.74.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.74.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.74.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.74.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.74.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.74.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.74.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.74.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_74 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.74.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.74.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.74.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.74.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.74.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.74.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.74.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.74.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.74.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.74.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.74.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.74.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.74.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.74.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.74.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.74.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.74.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.74.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.74.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.74.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.74.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.74.pep.all.fa.gz',
'galGal4' => 'gallus_gallus/pep/Gallus_gallus.Galgal4.74.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.74.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.74.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.74.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.74.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.74.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.74.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.74.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.74.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.74.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.74.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.74.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.74.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.74.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.74.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.74.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.74.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.74.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.74.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.74.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.74.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.74.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.74.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.74.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.74.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.74.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.74.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.74.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.74.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.74.pep.all.fa.gz',
'rn5' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_5.0.74.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.EF4.74.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.74.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.74.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.74.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.74.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.74.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.74.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.74.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.74.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.74.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.74.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.74.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.74.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_74 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_74_1',
'anaPla1' => 'anas_platyrhynchos_core_74_1',
'anoCar2' => 'anolis_carolinensis_core_74_2',
'astMex1' => 'astyanax_mexicanus_core_74_102',
'bosTau6' => 'bos_taurus_core_74_31',
'ce11' => 'caenorhabditis_elegans_core_74_235',
'calJac3' => 'callithrix_jacchus_core_74_321',
'canFam3' => 'canis_familiaris_core_74_31',
'cavPor3' => 'cavia_porcellus_core_74_3',
'choHof1' => 'choloepus_hoffmanni_core_74_1',
'ci3' => 'ciona_intestinalis_core_74_3',
'cioSav2' => 'ciona_savignyi_core_74_2',
'danRer7' => 'danio_rerio_core_74_9',
'dasNov3' => 'dasypus_novemcinctus_core_74_3',
'dipOrd1' => 'dipodomys_ordii_core_74_1',
'dm3' => 'drosophila_melanogaster_core_74_546',
'echTel1' => 'echinops_telfairi_core_74_1',
'equCab2' => 'equus_caballus_core_74_2',
'eriEur1' => 'erinaceus_europaeus_core_74_1',
'felCat5' => 'felis_catus_core_74_62',
'ficAlb1' => 'ficedula_albicollis_core_74_1',
'gadMor1' => 'gadus_morhua_core_74_1',
'galGal4' => 'gallus_gallus_core_74_4',
'gasAcu1' => 'gasterosteus_aculeatus_core_74_1',
'gorGor3' => 'gorilla_gorilla_core_74_31',
'hg19' => 'homo_sapiens_core_74_37',
'speTri2' => 'ictidomys_tridecemlineatus_core_74_2',
'latCha1' => 'latimeria_chalumnae_core_74_1',
'lepOcu1' => 'lepisosteus_oculatus_core_74_1',
'loxAfr3' => 'loxodonta_africana_core_74_3',
'rheMac2' => 'macaca_mulatta_core_74_10',
'macEug1' => 'macropus_eugenii_core_74_1',
'melGal1' => 'meleagris_gallopavo_core_74_21',
'micMur1' => 'microcebus_murinus_core_74_1',
'monDom5' => 'monodelphis_domestica_core_74_5',
'mm10' => 'mus_musculus_core_74_38',
'musFur1' => 'mustela_putorius_furo_core_74_1',
'myoLuc2' => 'myotis_lucifugus_core_74_2',
'nomLeu1' => 'nomascus_leucogenys_core_74_1',
'ochPri2' => 'ochotona_princeps_core_74_1',
'oreNil1' => 'oreochromis_niloticus_core_74_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_74_1',
'oryCun2' => 'oryctolagus_cuniculus_core_74_2',
'oryLat2' => 'oryzias_latipes_core_74_1',
'otoGar3' => 'otolemur_garnettii_core_74_3',
'oviAri3' => 'ovis_aries_core_74_31',
'panTro4' => 'pan_troglodytes_core_74_214',
'pelSin1' => 'pelodiscus_sinensis_core_74_1',
'petMar2' => 'petromyzon_marinus_core_74_7',
'ponAbe2' => 'pongo_abelii_core_74_1',
'proCap1' => 'procavia_capensis_core_74_1',
'pteVam1' => 'pteropus_vampyrus_core_74_1',
'rn5' => 'rattus_norvegicus_core_74_5',
'sacCer3' => 'saccharomyces_cerevisiae_core_74_4',
'sarHar1' => 'sarcophilus_harrisii_core_74_7',
'sorAra1' => 'sorex_araneus_core_74_1',
'susScr3' => 'sus_scrofa_core_74_102',
'taeGut1' => 'taeniopygia_guttata_core_74_1',
'fr2' => 'takifugu_rubripes_core_74_4',
'tarSyr1' => 'tarsius_syrichta_core_74_1',
'tetNig2' => 'tetraodon_nigroviridis_core_74_8',
'tupBel1' => 'tupaia_belangeri_core_74_1',
'turTru1' => 'tursiops_truncatus_core_74_1',
'vicPac1' => 'vicugna_pacos_core_74_1',
'xenTro3' => 'xenopus_tropicalis_core_74_42',
'xipMac1' => 'xiphophorus_maculatus_core_74_1',
);

my %ensGeneGtfFileNames_75 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.75.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.75.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.75.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.75.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.75.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.75.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.75.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.75.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.75.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.75.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.75.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.75.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.75.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.75.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.75.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.75.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.75.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.75.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.75.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.75.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.75.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.75.gtf.gz',
'galGal4' => 'gallus_gallus/Gallus_gallus.Galgal4.75.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.75.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.75.gtf.gz',
'hg19' => 'homo_sapiens/Homo_sapiens.GRCh37.75.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.75.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.75.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.75.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.75.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.75.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.75.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.75.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.75.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.75.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.75.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.75.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.75.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.75.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.75.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.75.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.75.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.75.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.75.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.75.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.75.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.75.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.75.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.75.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.75.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.75.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.75.gtf.gz',
'rn5' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_5.0.75.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.75.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.75.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.75.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.75.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.75.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.75.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.75.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.75.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.75.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.75.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.75.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.75.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.75.gtf.gz',
);
my %ensGeneFtpPeptideFileNames_75 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.75.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.75.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.75.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.75.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.75.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.75.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.75.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.75.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.75.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.75.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.75.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.75.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.75.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.75.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.75.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.75.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.75.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.75.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.75.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.75.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.75.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.75.pep.all.fa.gz',
'galGal4' => 'gallus_gallus/pep/Gallus_gallus.Galgal4.75.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.75.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.75.pep.all.fa.gz',
'hg19' => 'homo_sapiens/pep/Homo_sapiens.GRCh37.75.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.75.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.75.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.75.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.75.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.75.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.75.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.75.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.75.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.75.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.75.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.75.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.75.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.75.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.75.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.75.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.75.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.75.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.75.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.75.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.75.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.75.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.75.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.75.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.75.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.75.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.75.pep.all.fa.gz',
'rn5' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_5.0.75.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.75.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.75.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.75.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.75.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.75.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.75.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.75.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.75.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.75.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.75.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.75.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.75.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.75.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_75 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_75_1',
'anaPla1' => 'anas_platyrhynchos_core_75_1',
'anoCar2' => 'anolis_carolinensis_core_75_2',
'astMex1' => 'astyanax_mexicanus_core_75_102',
'bosTau6' => 'bos_taurus_core_75_31',
'ce11' => 'caenorhabditis_elegans_core_75_240',
'calJac3' => 'callithrix_jacchus_core_75_321',
'canFam3' => 'canis_familiaris_core_75_31',
'cavPor3' => 'cavia_porcellus_core_75_3',
'choHof1' => 'choloepus_hoffmanni_core_75_1',
'ci3' => 'ciona_intestinalis_core_75_3',
'cioSav2' => 'ciona_savignyi_core_75_2',
'danRer7' => 'danio_rerio_core_75_9',
'dasNov3' => 'dasypus_novemcinctus_core_75_3',
'dipOrd1' => 'dipodomys_ordii_core_75_1',
'dm3' => 'drosophila_melanogaster_core_75_546',
'echTel1' => 'echinops_telfairi_core_75_1',
'equCab2' => 'equus_caballus_core_75_2',
'eriEur1' => 'erinaceus_europaeus_core_75_1',
'felCat5' => 'felis_catus_core_75_62',
'ficAlb1' => 'ficedula_albicollis_core_75_1',
'gadMor1' => 'gadus_morhua_core_75_1',
'galGal4' => 'gallus_gallus_core_75_4',
'gasAcu1' => 'gasterosteus_aculeatus_core_75_1',
'gorGor3' => 'gorilla_gorilla_core_75_31',
'hg19' => 'homo_sapiens_core_75_37',
'speTri2' => 'ictidomys_tridecemlineatus_core_75_2',
'latCha1' => 'latimeria_chalumnae_core_75_1',
'lepOcu1' => 'lepisosteus_oculatus_core_75_1',
'loxAfr3' => 'loxodonta_africana_core_75_3',
'rheMac2' => 'macaca_mulatta_core_75_10',
'macEug1' => 'macropus_eugenii_core_75_1',
'melGal1' => 'meleagris_gallopavo_core_75_21',
'micMur1' => 'microcebus_murinus_core_75_1',
'monDom5' => 'monodelphis_domestica_core_75_5',
'mm10' => 'mus_musculus_core_75_38',
'musFur1' => 'mustela_putorius_furo_core_75_1',
'myoLuc2' => 'myotis_lucifugus_core_75_2',
'nomLeu1' => 'nomascus_leucogenys_core_75_1',
'ochPri2' => 'ochotona_princeps_core_75_1',
'oreNil1' => 'oreochromis_niloticus_core_75_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_75_1',
'oryCun2' => 'oryctolagus_cuniculus_core_75_2',
'oryLat2' => 'oryzias_latipes_core_75_1',
'otoGar3' => 'otolemur_garnettii_core_75_3',
'oviAri3' => 'ovis_aries_core_75_31',
'panTro4' => 'pan_troglodytes_core_75_214',
'pelSin1' => 'pelodiscus_sinensis_core_75_1',
'petMar2' => 'petromyzon_marinus_core_75_7',
'ponAbe2' => 'pongo_abelii_core_75_1',
'proCap1' => 'procavia_capensis_core_75_1',
'pteVam1' => 'pteropus_vampyrus_core_75_1',
'rn5' => 'rattus_norvegicus_core_75_5',
'sacCer3' => 'saccharomyces_cerevisiae_core_75_4',
'sarHar1' => 'sarcophilus_harrisii_core_75_7',
'sorAra1' => 'sorex_araneus_core_75_1',
'susScr3' => 'sus_scrofa_core_75_102',
'taeGut1' => 'taeniopygia_guttata_core_75_1',
'fr2' => 'takifugu_rubripes_core_75_4',
'tarSyr1' => 'tarsius_syrichta_core_75_1',
'tetNig2' => 'tetraodon_nigroviridis_core_75_8',
'tupBel1' => 'tupaia_belangeri_core_75_1',
'turTru1' => 'tursiops_truncatus_core_75_1',
'vicPac1' => 'vicugna_pacos_core_75_1',
'xenTro3' => 'xenopus_tropicalis_core_75_42',
'xipMac1' => 'xiphophorus_maculatus_core_75_1',
);

my %ensGeneGtfFileNames_76 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.76.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.76.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.76.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.76.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.76.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.76.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.76.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.76.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.76.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.76.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.76.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.76.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.76.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.76.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.76.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.76.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.76.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.76.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.76.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.76.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.76.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.76.gtf.gz',
'galGal4' => 'gallus_gallus/Gallus_gallus.Galgal4.76.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.76.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.76.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.76.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.76.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.76.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.76.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.76.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.76.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.76.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.76.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.76.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.76.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.76.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.76.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.76.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.76.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.76.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.76.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.76.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.76.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.76.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.76.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.76.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.76.gtf.gz',
'papAnu2' => 'papio_anubis/Papio_anubis.PapAnu2.0.76.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.76.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.76.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.76.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.76.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.76.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.76.gtf.gz',
'rn5' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_5.0.76.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.76.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.76.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.76.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.76.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.76.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.76.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.76.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.76.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.76.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.76.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.76.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.76.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.76.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_76 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal4' => 'gallus_gallus/pep/Gallus_gallus.Galgal4.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.pep.all.fa.gz',
'papAnu2' => 'papio_anubis/pep/Papio_anubis.PapAnu2.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'rn5' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_5.0.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_76 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_76_1',
'anaPla1' => 'anas_platyrhynchos_core_76_1',
'anoCar2' => 'anolis_carolinensis_core_76_2',
'astMex1' => 'astyanax_mexicanus_core_76_102',
'bosTau6' => 'bos_taurus_core_76_31',
'ce11' => 'caenorhabditis_elegans_core_76_240',
'calJac3' => 'callithrix_jacchus_core_76_321',
'canFam3' => 'canis_familiaris_core_76_31',
'cavPor3' => 'cavia_porcellus_core_76_3',
'choHof1' => 'choloepus_hoffmanni_core_76_1',
'ci3' => 'ciona_intestinalis_core_76_3',
'cioSav2' => 'ciona_savignyi_core_76_2',
'danRer7' => 'danio_rerio_core_76_9',
'dasNov3' => 'dasypus_novemcinctus_core_76_3',
'dipOrd1' => 'dipodomys_ordii_core_76_1',
'dm3' => 'drosophila_melanogaster_core_76_546',
'echTel1' => 'echinops_telfairi_core_76_1',
'equCab2' => 'equus_caballus_core_76_2',
'eriEur1' => 'erinaceus_europaeus_core_76_1',
'felCat5' => 'felis_catus_core_76_62',
'ficAlb1' => 'ficedula_albicollis_core_76_1',
'gadMor1' => 'gadus_morhua_core_76_1',
'galGal4' => 'gallus_gallus_core_76_4',
'gasAcu1' => 'gasterosteus_aculeatus_core_76_1',
'gorGor3' => 'gorilla_gorilla_core_76_31',
'hg38' => 'homo_sapiens_core_76_38',
'speTri2' => 'ictidomys_tridecemlineatus_core_76_2',
'latCha1' => 'latimeria_chalumnae_core_76_1',
'lepOcu1' => 'lepisosteus_oculatus_core_76_1',
'loxAfr3' => 'loxodonta_africana_core_76_3',
'rheMac2' => 'macaca_mulatta_core_76_10',
'macEug1' => 'macropus_eugenii_core_76_1',
'melGal1' => 'meleagris_gallopavo_core_76_21',
'micMur1' => 'microcebus_murinus_core_76_1',
'monDom5' => 'monodelphis_domestica_core_76_5',
'mm10' => 'mus_musculus_core_76_38',
'musFur1' => 'mustela_putorius_furo_core_76_1',
'myoLuc2' => 'myotis_lucifugus_core_76_2',
'nomLeu1' => 'nomascus_leucogenys_core_76_1',
'ochPri2' => 'ochotona_princeps_core_76_1',
'oreNil1' => 'oreochromis_niloticus_core_76_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_76_1',
'oryCun2' => 'oryctolagus_cuniculus_core_76_2',
'oryLat2' => 'oryzias_latipes_core_76_1',
'otoGar3' => 'otolemur_garnettii_core_76_3',
'oviAri3' => 'ovis_aries_core_76_31',
'panTro4' => 'pan_troglodytes_core_76_214',
'papAnu2' => 'papio_anubis_core_76_2',
'pelSin1' => 'pelodiscus_sinensis_core_76_1',
'petMar2' => 'petromyzon_marinus_core_76_7',
'poeFor1' => 'poecilia_formosa_core_76_512',
'ponAbe2' => 'pongo_abelii_core_76_1',
'proCap1' => 'procavia_capensis_core_76_1',
'pteVam1' => 'pteropus_vampyrus_core_76_1',
'rn5' => 'rattus_norvegicus_core_76_5',
'sacCer3' => 'saccharomyces_cerevisiae_core_76_4',
'sarHar1' => 'sarcophilus_harrisii_core_76_7',
'sorAra1' => 'sorex_araneus_core_76_1',
'susScr3' => 'sus_scrofa_core_76_102',
'taeGut1' => 'taeniopygia_guttata_core_76_1',
'fr2' => 'takifugu_rubripes_core_76_4',
'tarSyr1' => 'tarsius_syrichta_core_76_1',
'tetNig2' => 'tetraodon_nigroviridis_core_76_8',
'tupBel1' => 'tupaia_belangeri_core_76_1',
'turTru1' => 'tursiops_truncatus_core_76_1',
'vicPac1' => 'vicugna_pacos_core_76_1',
'xenTro3' => 'xenopus_tropicalis_core_76_42',
'xipMac1' => 'xiphophorus_maculatus_core_76_1',
);

my %ensGeneGtfFileNames_78 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.78.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.78.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.78.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.78.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.78.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.78.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.78.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.78.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.78.gtf.gz',
'chlSab1' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.78.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.78.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.78.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.78.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.78.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.78.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.78.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP5.78.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.78.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.78.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.78.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.78.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.78.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.78.gtf.gz',
'galGal4' => 'gallus_gallus/Gallus_gallus.Galgal4.78.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.78.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.78.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.78.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.78.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.78.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.78.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.78.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.78.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.78.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.78.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.78.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.78.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.78.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.78.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.78.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.78.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.78.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.78.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.78.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.78.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.78.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.78.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.78.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.78.gtf.gz',
'papAnu2' => 'papio_anubis/Papio_anubis.PapAnu2.0.78.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.78.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.78.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.78.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.78.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.78.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.78.gtf.gz',
'rn5' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_5.0.78.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.78.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.78.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.78.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.78.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.78.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.78.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.78.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.78.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.78.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.78.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.78.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.78.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.78.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_78 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.pep.all.fa.gz',
'chlSab1' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP5.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal4' => 'gallus_gallus/pep/Gallus_gallus.Galgal4.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.pep.all.fa.gz',
'papAnu2' => 'papio_anubis/pep/Papio_anubis.PapAnu2.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'rn5' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_5.0.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_78 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_78_1',
'anaPla1' => 'anas_platyrhynchos_core_78_1',
'anoCar2' => 'anolis_carolinensis_core_78_2',
'astMex1' => 'astyanax_mexicanus_core_78_102',
'bosTau6' => 'bos_taurus_core_78_31',
'ce11' => 'caenorhabditis_elegans_core_78_240',
'calJac3' => 'callithrix_jacchus_core_78_321',
'canFam3' => 'canis_familiaris_core_78_31',
'chlSab1' => 'chlorocebus_sabaeus_core_78_1',
'cavPor3' => 'cavia_porcellus_core_78_3',
'choHof1' => 'choloepus_hoffmanni_core_78_1',
'ci3' => 'ciona_intestinalis_core_78_3',
'cioSav2' => 'ciona_savignyi_core_78_2',
'danRer7' => 'danio_rerio_core_78_9',
'dasNov3' => 'dasypus_novemcinctus_core_78_3',
'dipOrd1' => 'dipodomys_ordii_core_78_1',
'dm3' => 'drosophila_melanogaster_core_78_546',
'echTel1' => 'echinops_telfairi_core_78_1',
'equCab2' => 'equus_caballus_core_78_2',
'eriEur1' => 'erinaceus_europaeus_core_78_1',
'felCat5' => 'felis_catus_core_78_62',
'ficAlb1' => 'ficedula_albicollis_core_78_1',
'gadMor1' => 'gadus_morhua_core_78_1',
'galGal4' => 'gallus_gallus_core_78_4',
'gasAcu1' => 'gasterosteus_aculeatus_core_78_1',
'gorGor3' => 'gorilla_gorilla_core_78_31',
'hg38' => 'homo_sapiens_core_78_38',
'speTri2' => 'ictidomys_tridecemlineatus_core_78_2',
'latCha1' => 'latimeria_chalumnae_core_78_1',
'lepOcu1' => 'lepisosteus_oculatus_core_78_1',
'loxAfr3' => 'loxodonta_africana_core_78_3',
'rheMac2' => 'macaca_mulatta_core_78_10',
'macEug1' => 'macropus_eugenii_core_78_1',
'melGal1' => 'meleagris_gallopavo_core_78_21',
'micMur1' => 'microcebus_murinus_core_78_1',
'monDom5' => 'monodelphis_domestica_core_78_5',
'mm10' => 'mus_musculus_core_78_38',
'musFur1' => 'mustela_putorius_furo_core_78_1',
'myoLuc2' => 'myotis_lucifugus_core_78_2',
'nomLeu1' => 'nomascus_leucogenys_core_78_1',
'ochPri2' => 'ochotona_princeps_core_78_1',
'oreNil1' => 'oreochromis_niloticus_core_78_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_78_1',
'oryCun2' => 'oryctolagus_cuniculus_core_78_2',
'oryLat2' => 'oryzias_latipes_core_78_1',
'otoGar3' => 'otolemur_garnettii_core_78_3',
'oviAri3' => 'ovis_aries_core_78_31',
'panTro4' => 'pan_troglodytes_core_78_214',
'papAnu2' => 'papio_anubis_core_78_2',
'pelSin1' => 'pelodiscus_sinensis_core_78_1',
'petMar2' => 'petromyzon_marinus_core_78_7',
'poeFor1' => 'poecilia_formosa_core_78_512',
'ponAbe2' => 'pongo_abelii_core_78_1',
'proCap1' => 'procavia_capensis_core_78_1',
'pteVam1' => 'pteropus_vampyrus_core_78_1',
'rn5' => 'rattus_norvegicus_core_78_5',
'sacCer3' => 'saccharomyces_cerevisiae_core_78_4',
'sarHar1' => 'sarcophilus_harrisii_core_78_7',
'sorAra1' => 'sorex_araneus_core_78_1',
'susScr3' => 'sus_scrofa_core_78_102',
'taeGut1' => 'taeniopygia_guttata_core_78_1',
'fr2' => 'takifugu_rubripes_core_78_4',
'tarSyr1' => 'tarsius_syrichta_core_78_1',
'tetNig2' => 'tetraodon_nigroviridis_core_78_8',
'tupBel1' => 'tupaia_belangeri_core_78_1',
'turTru1' => 'tursiops_truncatus_core_78_1',
'vicPac1' => 'vicugna_pacos_core_78_1',
'xenTro3' => 'xenopus_tropicalis_core_78_42',
'xipMac1' => 'xiphophorus_maculatus_core_78_1',
);

my %ensGeneGtfFileNames_79 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.79.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.79.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.79.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.79.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.79.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.79.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.79.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.79.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.79.gtf.gz',
'chlSab1' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.79.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.79.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.79.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.79.gtf.gz',
'danRer7' => 'danio_rerio/Danio_rerio.Zv9.79.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.79.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.79.gtf.gz',
'dm3' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.79.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.79.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.79.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.79.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.79.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.79.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.79.gtf.gz',
'galGal4' => 'gallus_gallus/Gallus_gallus.Galgal4.79.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.79.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.79.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.79.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.79.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.79.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.79.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.79.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.79.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.79.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.79.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.79.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.79.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.79.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.79.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.79.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.79.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.79.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.79.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.79.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.79.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.79.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.79.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.79.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.79.gtf.gz',
'papAnu2' => 'papio_anubis/Papio_anubis.PapAnu2.0.79.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.79.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.79.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.79.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.79.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.79.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.79.gtf.gz',
'rn5' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_5.0.79.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.79.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.79.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.79.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.79.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.79.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.79.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.79.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.79.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.79.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.79.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.79.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.79.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.79.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_79 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.pep.all.fa.gz',
'chlSab1' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'danRer7' => 'danio_rerio/pep/Danio_rerio.Zv9.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.pep.all.fa.gz',
'dm3' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal4' => 'gallus_gallus/pep/Gallus_gallus.Galgal4.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.pep.all.fa.gz',
'papAnu2' => 'papio_anubis/pep/Papio_anubis.PapAnu2.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'rn5' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_5.0.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_79 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_79_1',
'anaPla1' => 'anas_platyrhynchos_core_79_1',
'anoCar2' => 'anolis_carolinensis_core_79_2',
'astMex1' => 'astyanax_mexicanus_core_79_102',
'bosTau6' => 'bos_taurus_core_79_31',
'ce11' => 'caenorhabditis_elegans_core_79_245',
'calJac3' => 'callithrix_jacchus_core_79_321',
'canFam3' => 'canis_familiaris_core_79_31',
'chlSab1' => 'cavia_porcellus_core_79_3',
'cavPor3' => 'chlorocebus_sabaeus_core_79_1',
'choHof1' => 'choloepus_hoffmanni_core_79_1',
'ci3' => 'ciona_intestinalis_core_79_3',
'cioSav2' => 'ciona_savignyi_core_79_2',
'danRer7' => 'danio_rerio_core_79_9',
'dasNov3' => 'dasypus_novemcinctus_core_79_3',
'dipOrd1' => 'dipodomys_ordii_core_79_1',
'dm3' => 'drosophila_melanogaster_core_79_602',
'echTel1' => 'echinops_telfairi_core_79_1',
'equCab2' => 'equus_caballus_core_79_2',
'eriEur1' => 'erinaceus_europaeus_core_79_1',
'felCat5' => 'felis_catus_core_79_62',
'ficAlb1' => 'ficedula_albicollis_core_79_1',
'gadMor1' => 'gadus_morhua_core_79_1',
'galGal4' => 'gallus_gallus_core_79_4',
'gasAcu1' => 'gasterosteus_aculeatus_core_79_1',
'gorGor3' => 'gorilla_gorilla_core_79_31',
'hg38' => 'homo_sapiens_core_79_38',
'speTri2' => 'ictidomys_tridecemlineatus_core_79_2',
'latCha1' => 'latimeria_chalumnae_core_79_1',
'lepOcu1' => 'lepisosteus_oculatus_core_79_1',
'loxAfr3' => 'loxodonta_africana_core_79_3',
'rheMac2' => 'macaca_mulatta_core_79_10',
'macEug1' => 'macropus_eugenii_core_79_1',
'melGal1' => 'meleagris_gallopavo_core_79_21',
'micMur1' => 'microcebus_murinus_core_79_1',
'monDom5' => 'monodelphis_domestica_core_79_5',
'mm10' => 'mus_musculus_core_79_38',
'musFur1' => 'mustela_putorius_furo_core_79_1',
'myoLuc2' => 'myotis_lucifugus_core_79_2',
'nomLeu1' => 'nomascus_leucogenys_core_79_1',
'ochPri2' => 'ochotona_princeps_core_79_1',
'oreNil1' => 'oreochromis_niloticus_core_79_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_79_1',
'oryCun2' => 'oryctolagus_cuniculus_core_79_2',
'oryLat2' => 'oryzias_latipes_core_79_1',
'otoGar3' => 'otolemur_garnettii_core_79_3',
'oviAri3' => 'ovis_aries_core_79_31',
'panTro4' => 'pan_troglodytes_core_79_214',
'papAnu2' => 'papio_anubis_core_79_2',
'pelSin1' => 'pelodiscus_sinensis_core_79_1',
'petMar2' => 'petromyzon_marinus_core_79_7',
'poeFor1' => 'poecilia_formosa_core_79_512',
'ponAbe2' => 'pongo_abelii_core_79_1',
'proCap1' => 'procavia_capensis_core_79_1',
'pteVam1' => 'pteropus_vampyrus_core_79_1',
'rn5' => 'rattus_norvegicus_core_79_5',
'sacCer3' => 'saccharomyces_cerevisiae_core_79_4',
'sarHar1' => 'sarcophilus_harrisii_core_79_7',
'sorAra1' => 'sorex_araneus_core_79_1',
'susScr3' => 'sus_scrofa_core_79_102',
'taeGut1' => 'taeniopygia_guttata_core_79_1',
'fr2' => 'takifugu_rubripes_core_79_4',
'tarSyr1' => 'tarsius_syrichta_core_79_1',
'tetNig2' => 'tetraodon_nigroviridis_core_79_8',
'tupBel1' => 'tupaia_belangeri_core_79_1',
'turTru1' => 'tursiops_truncatus_core_79_1',
'vicPac1' => 'vicugna_pacos_core_79_1',
'xenTro3' => 'xenopus_tropicalis_core_79_42',
'xipMac1' => 'xiphophorus_maculatus_core_79_1',
);

my %ensGeneGtfFileNames_81 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.81.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.81.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.81.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.81.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.81.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.81.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.81.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.81.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.81.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.81.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.81.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.81.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.81.gtf.gz',
'danRer10' => 'danio_rerio/Danio_rerio.GRCz10.81.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.81.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.81.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.81.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.81.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.81.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.81.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.81.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.81.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.81.gtf.gz',
'galGal4' => 'gallus_gallus/Gallus_gallus.Galgal4.81.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.81.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.81.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.81.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.81.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.81.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.81.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.81.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.81.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.81.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.81.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.81.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.81.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.81.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.81.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.81.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.81.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.81.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.81.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.81.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.81.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.81.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.81.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.81.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.81.gtf.gz',
'papAnu2' => 'papio_anubis/Papio_anubis.PapAnu2.0.81.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.81.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.81.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.81.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.81.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.81.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.81.gtf.gz',
'rn6' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.81.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.81.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.81.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.81.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.81.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.81.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.81.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.81.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.81.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.81.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.81.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.81.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.81.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.81.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_81 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'danRer10' => 'danio_rerio/pep/Danio_rerio.GRCz10.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal4' => 'gallus_gallus/pep/Gallus_gallus.Galgal4.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.pep.all.fa.gz',
'papAnu2' => 'papio_anubis/pep/Papio_anubis.PapAnu2.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'rn6' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_81 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_81_1',
'anaPla1' => 'anas_platyrhynchos_core_81_1',
'anoCar2' => 'anolis_carolinensis_core_81_2',
'astMex1' => 'astyanax_mexicanus_core_81_102',
'bosTau6' => 'bos_taurus_core_81_31',
'ce11' => 'caenorhabditis_elegans_core_81_245',
'calJac3' => 'callithrix_jacchus_core_81_321',
'canFam3' => 'canis_familiaris_core_81_31',
'cavPor3' => 'cavia_porcellus_core_81_3',
'chlSab2' => 'chlorocebus_sabaeus_core_81_1',
'choHof1' => 'choloepus_hoffmanni_core_81_1',
'ci3' => 'ciona_intestinalis_core_81_3',
'cioSav2' => 'ciona_savignyi_core_81_2',
'danRer10' => 'danio_rerio_core_81_10',
'dasNov3' => 'dasypus_novemcinctus_core_81_3',
'dipOrd1' => 'dipodomys_ordii_core_81_1',
'dm6' => 'drosophila_melanogaster_core_81_602',
'echTel1' => 'echinops_telfairi_core_81_1',
'equCab2' => 'equus_caballus_core_81_2',
'eriEur1' => 'erinaceus_europaeus_core_81_1',
'felCat5' => 'felis_catus_core_81_62',
'ficAlb1' => 'ficedula_albicollis_core_81_1',
'gadMor1' => 'gadus_morhua_core_81_1',
'galGal4' => 'gallus_gallus_core_81_4',
'gasAcu1' => 'gasterosteus_aculeatus_core_81_1',
'gorGor3' => 'gorilla_gorilla_core_81_31',
'hg38' => 'homo_sapiens_core_81_38',
'speTri2' => 'ictidomys_tridecemlineatus_core_81_2',
'latCha1' => 'latimeria_chalumnae_core_81_1',
'lepOcu1' => 'lepisosteus_oculatus_core_81_1',
'loxAfr3' => 'loxodonta_africana_core_81_3',
'rheMac2' => 'macaca_mulatta_core_81_10',
'macEug1' => 'macropus_eugenii_core_81_1',
'melGal1' => 'meleagris_gallopavo_core_81_21',
'micMur1' => 'microcebus_murinus_core_81_1',
'monDom5' => 'monodelphis_domestica_core_81_5',
'mm10' => 'mus_musculus_core_81_38',
'musFur1' => 'mustela_putorius_furo_core_81_1',
'myoLuc2' => 'myotis_lucifugus_core_81_2',
'nomLeu1' => 'nomascus_leucogenys_core_81_1',
'ochPri2' => 'ochotona_princeps_core_81_1',
'oreNil1' => 'oreochromis_niloticus_core_81_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_81_1',
'oryCun2' => 'oryctolagus_cuniculus_core_81_2',
'oryLat2' => 'oryzias_latipes_core_81_1',
'otoGar3' => 'otolemur_garnettii_core_81_3',
'oviAri3' => 'ovis_aries_core_81_31',
'panTro4' => 'pan_troglodytes_core_81_214',
'papAnu2' => 'papio_anubis_core_81_2',
'pelSin1' => 'pelodiscus_sinensis_core_81_1',
'petMar2' => 'petromyzon_marinus_core_81_7',
'poeFor1' => 'poecilia_formosa_core_81_512',
'ponAbe2' => 'pongo_abelii_core_81_1',
'proCap1' => 'procavia_capensis_core_81_1',
'pteVam1' => 'pteropus_vampyrus_core_81_1',
'rn6' => 'rattus_norvegicus_core_81_6',
'sacCer3' => 'saccharomyces_cerevisiae_core_81_4',
'sarHar1' => 'sarcophilus_harrisii_core_81_7',
'sorAra1' => 'sorex_araneus_core_81_1',
'susScr3' => 'sus_scrofa_core_81_102',
'taeGut1' => 'taeniopygia_guttata_core_81_1',
'fr2' => 'takifugu_rubripes_core_81_4',
'tarSyr1' => 'tarsius_syrichta_core_81_1',
'tetNig2' => 'tetraodon_nigroviridis_core_81_8',
'tupBel1' => 'tupaia_belangeri_core_81_1',
'turTru1' => 'tursiops_truncatus_core_81_1',
'vicPac1' => 'vicugna_pacos_core_81_1',
'xenTro3' => 'xenopus_tropicalis_core_81_42',
'xipMac1' => 'xiphophorus_maculatus_core_81_1',
);

my %ensGeneGtfFileNames_83 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.83.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.83.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.83.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.83.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.83.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.83.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.83.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.83.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.83.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.83.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.83.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.83.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.83.gtf.gz',
'danRer10' => 'danio_rerio/Danio_rerio.GRCz10.83.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.83.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.83.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.83.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.83.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.83.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.83.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.83.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.83.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.83.gtf.gz',
'galGal4' => 'gallus_gallus/Gallus_gallus.Galgal4.83.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.83.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.83.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.83.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.83.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.83.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.83.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.83.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.83.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.83.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.83.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.83.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.83.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.83.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.83.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.83.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.83.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.83.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.83.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.83.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.83.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.83.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.83.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.83.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.83.gtf.gz',
'papAnu2' => 'papio_anubis/Papio_anubis.PapAnu2.0.83.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.83.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.83.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.83.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.83.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.83.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.83.gtf.gz',
'rn6' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.83.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.83.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.83.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.83.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.83.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.83.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.83.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.83.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.83.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.83.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.83.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.83.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.83.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.83.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_83 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'danRer10' => 'danio_rerio/pep/Danio_rerio.GRCz10.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal4' => 'gallus_gallus/pep/Gallus_gallus.Galgal4.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.pep.all.fa.gz',
'papAnu2' => 'papio_anubis/pep/Papio_anubis.PapAnu2.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'rn6' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_83 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_83_1',
'anaPla1' => 'anas_platyrhynchos_core_83_1',
'anoCar2' => 'anolis_carolinensis_core_83_2',
'astMex1' => 'astyanax_mexicanus_core_83_102',
'bosTau6' => 'bos_taurus_core_83_31',
'ce11' => 'caenorhabditis_elegans_core_83_245',
'calJac3' => 'callithrix_jacchus_core_83_321',
'canFam3' => 'canis_familiaris_core_83_31',
'cavPor3' => 'cavia_porcellus_core_83_3',
'chlSab2' => 'chlorocebus_sabaeus_core_83_1',
'choHof1' => 'choloepus_hoffmanni_core_83_1',
'ci3' => 'ciona_intestinalis_core_83_3',
'cioSav2' => 'ciona_savignyi_core_83_2',
'danRer10' => 'danio_rerio_core_83_10',
'dasNov3' => 'dasypus_novemcinctus_core_83_3',
'dipOrd1' => 'dipodomys_ordii_core_83_1',
'dm6' => 'drosophila_melanogaster_core_83_602',
'echTel1' => 'echinops_telfairi_core_83_1',
'equCab2' => 'equus_caballus_core_83_2',
'eriEur1' => 'erinaceus_europaeus_core_83_1',
'felCat5' => 'felis_catus_core_83_62',
'ficAlb1' => 'ficedula_albicollis_core_83_1',
'gadMor1' => 'gadus_morhua_core_83_1',
'galGal4' => 'gallus_gallus_core_83_4',
'gasAcu1' => 'gasterosteus_aculeatus_core_83_1',
'gorGor3' => 'gorilla_gorilla_core_83_31',
'hg38' => 'homo_sapiens_core_83_38',
'speTri2' => 'ictidomys_tridecemlineatus_core_83_2',
'latCha1' => 'latimeria_chalumnae_core_83_1',
'lepOcu1' => 'lepisosteus_oculatus_core_83_1',
'loxAfr3' => 'loxodonta_africana_core_83_3',
'rheMac2' => 'macaca_mulatta_core_83_10',
'macEug1' => 'macropus_eugenii_core_83_1',
'melGal1' => 'meleagris_gallopavo_core_83_21',
'micMur1' => 'microcebus_murinus_core_83_1',
'monDom5' => 'monodelphis_domestica_core_83_5',
'mm10' => 'mus_musculus_core_83_38',
'musFur1' => 'mustela_putorius_furo_core_83_1',
'myoLuc2' => 'myotis_lucifugus_core_83_2',
'nomLeu1' => 'nomascus_leucogenys_core_83_1',
'ochPri2' => 'ochotona_princeps_core_83_1',
'oreNil1' => 'oreochromis_niloticus_core_83_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_83_1',
'oryCun2' => 'oryctolagus_cuniculus_core_83_2',
'oryLat2' => 'oryzias_latipes_core_83_1',
'otoGar3' => 'otolemur_garnettii_core_83_3',
'oviAri3' => 'ovis_aries_core_83_31',
'panTro4' => 'pan_troglodytes_core_83_214',
'papAnu2' => 'papio_anubis_core_83_2',
'pelSin1' => 'pelodiscus_sinensis_core_83_1',
'petMar2' => 'petromyzon_marinus_core_83_7',
'poeFor1' => 'poecilia_formosa_core_83_512',
'ponAbe2' => 'pongo_abelii_core_83_1',
'proCap1' => 'procavia_capensis_core_83_1',
'pteVam1' => 'pteropus_vampyrus_core_83_1',
'rn6' => 'rattus_norvegicus_core_83_6',
'sacCer3' => 'saccharomyces_cerevisiae_core_83_4',
'sarHar1' => 'sarcophilus_harrisii_core_83_7',
'sorAra1' => 'sorex_araneus_core_83_1',
'susScr3' => 'sus_scrofa_core_83_102',
'taeGut1' => 'taeniopygia_guttata_core_83_1',
'fr2' => 'takifugu_rubripes_core_83_4',
'tarSyr1' => 'tarsius_syrichta_core_83_1',
'tetNig2' => 'tetraodon_nigroviridis_core_83_8',
'tupBel1' => 'tupaia_belangeri_core_83_1',
'turTru1' => 'tursiops_truncatus_core_83_1',
'vicPac1' => 'vicugna_pacos_core_83_1',
'xenTro3' => 'xenopus_tropicalis_core_83_42',
'xipMac1' => 'xiphophorus_maculatus_core_83_1',
);

my %ensGeneGtfFileNames_85 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.85.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.85.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.85.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.85.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.85.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.85.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.85.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.85.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.85.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.85.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.85.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.85.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.85.gtf.gz',
'danRer10' => 'danio_rerio/Danio_rerio.GRCz10.85.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.85.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.85.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.85.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.85.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.85.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.85.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.85.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.85.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.85.gtf.gz',
'galGal4' => 'gallus_gallus/Gallus_gallus.Galgal4.85.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.85.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.85.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.85.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.85.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.85.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.85.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.85.gtf.gz',
'rheMac2' => 'macaca_mulatta/Macaca_mulatta.MMUL_1.85.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.85.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.85.gtf.gz',
'micMur1' => 'microcebus_murinus/Microcebus_murinus.micMur1.85.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.85.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.85.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.85.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.85.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.85.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.85.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.85.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.85.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.85.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.85.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.85.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.85.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.85.gtf.gz',
'papAnu2' => 'papio_anubis/Papio_anubis.PapAnu2.0.85.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.85.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.85.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.85.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.85.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.85.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.85.gtf.gz',
'rn6' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.85.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.85.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.85.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.85.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.85.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.85.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.85.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.85.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.85.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.85.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.85.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.85.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.85.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.85.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_85 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'danRer10' => 'danio_rerio/pep/Danio_rerio.GRCz10.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal4' => 'gallus_gallus/pep/Gallus_gallus.Galgal4.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'rheMac2' => 'macaca_mulatta/pep/Macaca_mulatta.MMUL_1.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'micMur1' => 'microcebus_murinus/pep/Microcebus_murinus.micMur1.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.pep.all.fa.gz',
'papAnu2' => 'papio_anubis/pep/Papio_anubis.PapAnu2.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'rn6' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_85 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_85_1',
'anaPla1' => 'anas_platyrhynchos_core_85_1',
'anoCar2' => 'anolis_carolinensis_core_85_2',
'astMex1' => 'astyanax_mexicanus_core_85_102',
'bosTau6' => 'bos_taurus_core_85_31',
'ce11' => 'caenorhabditis_elegans_core_85_250',
'calJac3' => 'callithrix_jacchus_core_85_321',
'canFam3' => 'canis_familiaris_core_85_31',
'cavPor3' => 'cavia_porcellus_core_85_3',
'chlSab2' => 'chlorocebus_sabaeus_core_85_1',
'choHof1' => 'choloepus_hoffmanni_core_85_1',
'ci3' => 'ciona_intestinalis_core_85_3',
'cioSav2' => 'ciona_savignyi_core_85_2',
'danRer10' => 'danio_rerio_core_85_10',
'dasNov3' => 'dasypus_novemcinctus_core_85_3',
'dipOrd1' => 'dipodomys_ordii_core_85_1',
'dm6' => 'drosophila_melanogaster_core_85_602',
'echTel1' => 'echinops_telfairi_core_85_1',
'equCab2' => 'equus_caballus_core_85_2',
'eriEur1' => 'erinaceus_europaeus_core_85_1',
'felCat5' => 'felis_catus_core_85_62',
'ficAlb1' => 'ficedula_albicollis_core_85_1',
'gadMor1' => 'gadus_morhua_core_85_1',
'galGal4' => 'gallus_gallus_core_85_4',
'gasAcu1' => 'gasterosteus_aculeatus_core_85_1',
'gorGor3' => 'gorilla_gorilla_core_85_31',
'hg38' => 'homo_sapiens_core_85_38',
'speTri2' => 'ictidomys_tridecemlineatus_core_85_2',
'latCha1' => 'latimeria_chalumnae_core_85_1',
'lepOcu1' => 'lepisosteus_oculatus_core_85_1',
'loxAfr3' => 'loxodonta_africana_core_85_3',
'rheMac2' => 'macaca_mulatta_core_85_10',
'macEug1' => 'macropus_eugenii_core_85_1',
'melGal1' => 'meleagris_gallopavo_core_85_21',
'micMur1' => 'microcebus_murinus_core_85_1',
'monDom5' => 'monodelphis_domestica_core_85_5',
'mm10' => 'mus_musculus_core_85_38',
'musFur1' => 'mustela_putorius_furo_core_85_1',
'myoLuc2' => 'myotis_lucifugus_core_85_2',
'nomLeu1' => 'nomascus_leucogenys_core_85_1',
'ochPri2' => 'ochotona_princeps_core_85_1',
'oreNil1' => 'oreochromis_niloticus_core_85_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_85_1',
'oryCun2' => 'oryctolagus_cuniculus_core_85_2',
'oryLat2' => 'oryzias_latipes_core_85_1',
'otoGar3' => 'otolemur_garnettii_core_85_3',
'oviAri3' => 'ovis_aries_core_85_31',
'panTro4' => 'pan_troglodytes_core_85_214',
'papAnu2' => 'papio_anubis_core_85_2',
'pelSin1' => 'pelodiscus_sinensis_core_85_1',
'petMar2' => 'petromyzon_marinus_core_85_7',
'poeFor1' => 'poecilia_formosa_core_85_512',
'ponAbe2' => 'pongo_abelii_core_85_1',
'proCap1' => 'procavia_capensis_core_85_1',
'pteVam1' => 'pteropus_vampyrus_core_85_1',
'rn6' => 'rattus_norvegicus_core_85_6',
'sacCer3' => 'saccharomyces_cerevisiae_core_85_4',
'sarHar1' => 'sarcophilus_harrisii_core_85_7',
'sorAra1' => 'sorex_araneus_core_85_1',
'susScr3' => 'sus_scrofa_core_85_102',
'taeGut1' => 'taeniopygia_guttata_core_85_1',
'fr2' => 'takifugu_rubripes_core_85_4',
'tarSyr1' => 'tarsius_syrichta_core_85_1',
'tetNig2' => 'tetraodon_nigroviridis_core_85_8',
'tupBel1' => 'tupaia_belangeri_core_85_1',
'turTru1' => 'tursiops_truncatus_core_85_1',
'vicPac1' => 'vicugna_pacos_core_85_1',
'xenTro3' => 'xenopus_tropicalis_core_85_42',
'xipMac1' => 'xiphophorus_maculatus_core_85_1',
);

my %ensGeneGtfFileNames_86 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.86.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.86.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.86.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.86.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.86.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.86.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.86.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.86.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.86.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.86.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.86.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.86.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.86.gtf.gz',
'danRer10' => 'danio_rerio/Danio_rerio.GRCz10.86.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.86.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.86.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.86.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.86.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.86.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.86.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.86.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.86.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.86.gtf.gz',
'galGal5' => 'gallus_gallus/Gallus_gallus.Gallus_gallus-5.0.86.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.86.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.86.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.86.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.86.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.86.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.86.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.86.gtf.gz',
'rheMac8' => 'macaca_mulatta/Macaca_mulatta.Mmul_8.0.1.86.gtf.gz',
'macEug1' => 'macropus_eugenii/Macropus_eugenii.Meug_1.0.86.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.86.gtf.gz',
'micMur2' => 'microcebus_murinus/Microcebus_murinus.Mmur_2.0.86.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.86.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.86.gtf.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/Mus_musculus_129s1svimj.129S1_SvImJ_v1.86.gtf.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/Mus_musculus_aj.A_J_v1.86.gtf.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/Mus_musculus_akrj.AKR_J_v1.86.gtf.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/Mus_musculus_balbcj.BALB_cJ_v1.86.gtf.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/Mus_musculus_c3hhej.C3H_HeJ_v1.86.gtf.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.86.gtf.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/Mus_musculus_casteij.CAST_EiJ_v1.86.gtf.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/Mus_musculus_cbaj.CBA_J_v1.86.gtf.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/Mus_musculus_dba2j.DBA_2J_v1.86.gtf.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/Mus_musculus_fvbnj.FVB_NJ_v1.86.gtf.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/Mus_musculus_lpj.LP_J_v1.86.gtf.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.86.gtf.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.86.gtf.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/Mus_musculus_pwkphj.PWK_PhJ_v1.86.gtf.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/Mus_musculus_wsbeij.WSB_EiJ_v1.86.gtf.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij/Mus_spretus_spreteij.SPRET_EiJ_v1.86.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.86.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.86.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.86.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.pika.86.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.86.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.86.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.86.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.86.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.86.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.86.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.86.gtf.gz',
'papAnu2' => 'papio_anubis/Papio_anubis.PapAnu2.0.86.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.86.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.86.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.86.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.86.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.86.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.86.gtf.gz',
'rn6' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.86.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.86.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.86.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.86.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.86.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.86.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.86.gtf.gz',
'tarSyr1' => 'tarsius_syrichta/Tarsius_syrichta.tarSyr1.86.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.86.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.86.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.86.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.86.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.86.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.86.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_86 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'danRer10' => 'danio_rerio/pep/Danio_rerio.GRCz10.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal5' => 'gallus_gallus/pep/Gallus_gallus.Gallus_gallus-5.0.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'rheMac8' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_8.0.1.pep.all.fa.gz',
'macEug1' => 'macropus_eugenii/pep/Macropus_eugenii.Meug_1.0.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'micMur2' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_2.0.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/pep/Mus_musculus_129s1svimj.129S1_SvImJ_v1.pep.all.fa.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/pep/Mus_musculus_aj.A_J_v1.pep.all.fa.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/pep/Mus_musculus_akrj.AKR_J_v1.pep.all.fa.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_balbcj.BALB_cJ_v1.pep.all.fa.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/pep/Mus_musculus_c3hhej.C3H_HeJ_v1.pep.all.fa.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/pep/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.pep.all.fa.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/pep/Mus_musculus_casteij.CAST_EiJ_v1.pep.all.fa.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_cbaj.CBA_J_v1.pep.all.fa.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/pep/Mus_musculus_dba2j.DBA_2J_v1.pep.all.fa.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/pep/Mus_musculus_fvbnj.FVB_NJ_v1.pep.all.fa.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/pep/Mus_musculus_lpj.LP_J_v1.pep.all.fa.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/pep/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.pep.all.fa.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/pep/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.pep.all.fa.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/pep/Mus_musculus_pwkphj.PWK_PhJ_v1.pep.all.fa.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/pep/Mus_musculus_wsbeij.WSB_EiJ_v1.pep.all.fa.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij/pep/Mus_spretus_spreteij.SPRET_EiJ_v1.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.pika.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.pep.all.fa.gz',
'papAnu2' => 'papio_anubis/pep/Papio_anubis.PapAnu2.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'rn6' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.pep.all.fa.gz',
'tarSyr1' => 'tarsius_syrichta/pep/Tarsius_syrichta.tarSyr1.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_86 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_86_1',
'anaPla1' => 'anas_platyrhynchos_core_86_1',
'anoCar2' => 'anolis_carolinensis_core_86_2',
'astMex1' => 'astyanax_mexicanus_core_86_102',
'bosTau6' => 'bos_taurus_core_86_31',
'ce11' => 'caenorhabditis_elegans_core_86_250',
'calJac3' => 'callithrix_jacchus_core_86_321',
'canFam3' => 'canis_familiaris_core_86_31',
'cavPor3' => 'cavia_porcellus_core_86_3',
'chlSab2' => 'chlorocebus_sabaeus_core_86_1',
'choHof1' => 'choloepus_hoffmanni_core_86_1',
'ci3' => 'ciona_intestinalis_core_86_3',
'cioSav2' => 'ciona_savignyi_core_86_2',
'danRer10' => 'danio_rerio_core_86_10',
'dasNov3' => 'dasypus_novemcinctus_core_86_3',
'dipOrd1' => 'dipodomys_ordii_core_86_1',
'dm6' => 'drosophila_melanogaster_core_86_602',
'echTel1' => 'echinops_telfairi_core_86_1',
'equCab2' => 'equus_caballus_core_86_2',
'eriEur1' => 'erinaceus_europaeus_core_86_1',
'felCat5' => 'felis_catus_core_86_62',
'ficAlb1' => 'ficedula_albicollis_core_86_1',
'gadMor1' => 'gadus_morhua_core_86_1',
'galGal5' => 'gallus_gallus_core_86_5',
'gasAcu1' => 'gasterosteus_aculeatus_core_86_1',
'gorGor3' => 'gorilla_gorilla_core_86_31',
'hg38' => 'homo_sapiens_core_86_38',
'speTri2' => 'ictidomys_tridecemlineatus_core_86_2',
'latCha1' => 'latimeria_chalumnae_core_86_1',
'lepOcu1' => 'lepisosteus_oculatus_core_86_1',
'loxAfr3' => 'loxodonta_africana_core_86_3',
'rheMac8' => 'macaca_mulatta_core_86_801',
'macEug1' => 'macropus_eugenii_core_86_1',
'melGal1' => 'meleagris_gallopavo_core_86_21',
'micMur2' => 'microcebus_murinus_core_86_20',
'monDom5' => 'monodelphis_domestica_core_86_5',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj_core_86_1',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj_core_86_1',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj_core_86_1',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj_core_86_1',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej_core_86_1',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj_core_86_1',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij_core_86_1',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj_core_86_1',
'mm10' => 'mus_musculus_core_86_38',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j_core_86_1',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj_core_86_1',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj_core_86_1',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj_core_86_1',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj_core_86_1',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj_core_86_1',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij_core_86_1',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij_core_86_1',
'musFur1' => 'mustela_putorius_furo_core_86_1',
'myoLuc2' => 'myotis_lucifugus_core_86_2',
'nomLeu1' => 'nomascus_leucogenys_core_86_1',
'ochPri2' => 'ochotona_princeps_core_86_1',
'oreNil1' => 'oreochromis_niloticus_core_86_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_86_1',
'oryCun2' => 'oryctolagus_cuniculus_core_86_2',
'oryLat2' => 'oryzias_latipes_core_86_1',
'otoGar3' => 'otolemur_garnettii_core_86_3',
'oviAri3' => 'ovis_aries_core_86_31',
'panTro4' => 'pan_troglodytes_core_86_214',
'papAnu2' => 'papio_anubis_core_86_2',
'pelSin1' => 'pelodiscus_sinensis_core_86_1',
'petMar2' => 'petromyzon_marinus_core_86_7',
'poeFor1' => 'poecilia_formosa_core_86_512',
'ponAbe2' => 'pongo_abelii_core_86_1',
'proCap1' => 'procavia_capensis_core_86_1',
'pteVam1' => 'pteropus_vampyrus_core_86_1',
'rn6' => 'rattus_norvegicus_core_86_6',
'sacCer3' => 'saccharomyces_cerevisiae_core_86_4',
'sarHar1' => 'sarcophilus_harrisii_core_86_7',
'sorAra1' => 'sorex_araneus_core_86_1',
'susScr3' => 'sus_scrofa_core_86_102',
'taeGut1' => 'taeniopygia_guttata_core_86_1',
'fr2' => 'takifugu_rubripes_core_86_4',
'tarSyr1' => 'tarsius_syrichta_core_86_1',
'tetNig2' => 'tetraodon_nigroviridis_core_86_8',
'tupBel1' => 'tupaia_belangeri_core_86_1',
'turTru1' => 'tursiops_truncatus_core_86_1',
'vicPac1' => 'vicugna_pacos_core_86_1',
'xenTro3' => 'xenopus_tropicalis_core_86_42',
'xipMac1' => 'xiphophorus_maculatus_core_86_1',
);

my %ensGeneGtfFileNames_89 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.89.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.89.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.89.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.89.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.89.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.89.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.89.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.89.gtf.gz',
'tarSyr1' => 'carlito_syrichta/Carlito_syrichta.tarSyr1.89.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.cavPor3.89.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.89.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.89.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.89.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.89.gtf.gz',
'danRer10' => 'danio_rerio/Danio_rerio.GRCz10.89.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.89.gtf.gz',
'dipOrd1' => 'dipodomys_ordii/Dipodomys_ordii.dipOrd1.89.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.89.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.89.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.89.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.89.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.89.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.89.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.89.gtf.gz',
'galGal5' => 'gallus_gallus/Gallus_gallus.Gallus_gallus-5.0.89.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.89.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.89.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.89.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.spetri2.89.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.89.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.89.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.89.gtf.gz',
'rheMac8' => 'macaca_mulatta/Macaca_mulatta.Mmul_8.0.1.89.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.89.gtf.gz',
'micMur2' => 'microcebus_murinus/Microcebus_murinus.Mmur_2.0.89.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.89.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.89.gtf.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/Mus_musculus_129s1svimj.129S1_SvImJ_v1.86.gtf.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/Mus_musculus_aj.A_J_v1.86.gtf.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/Mus_musculus_akrj.AKR_J_v1.86.gtf.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/Mus_musculus_balbcj.BALB_cJ_v1.86.gtf.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/Mus_musculus_c3hhej.C3H_HeJ_v1.86.gtf.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.86.gtf.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/Mus_musculus_casteij.CAST_EiJ_v1.86.gtf.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/Mus_musculus_cbaj.CBA_J_v1.86.gtf.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/Mus_musculus_dba2j.DBA_2J_v1.86.gtf.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/Mus_musculus_fvbnj.FVB_NJ_v1.86.gtf.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/Mus_musculus_lpj.LP_J_v1.86.gtf.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.86.gtf.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.86.gtf.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/Mus_musculus_pwkphj.PWK_PhJ_v1.86.gtf.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/Mus_musculus_wsbeij.WSB_EiJ_v1.86.gtf.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij/Mus_spretus_spreteij.SPRET_EiJ_v1.86.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.89.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.89.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.89.gtf.gz',
'macEug1' => 'notamacropus_eugenii/Notamacropus_eugenii.Meug_1.0.89.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.OchPri2.0-Ens.89.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.89.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.89.gtf.gz',
'ornAna2' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.89.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.89.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.89.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.89.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.89.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.89.gtf.gz',
'papAnu2' => 'papio_anubis/Papio_anubis.PapAnu2.0.89.gtf.gz',
'papAnu3' => 'papio_anubis/Papio_anubis.PapAnu2.0.89.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.89.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.89.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.89.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.89.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.89.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.89.gtf.gz',
'rn6' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.89.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.89.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.89.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.89.gtf.gz',
'susScr3' => 'sus_scrofa/Sus_scrofa.Sscrofa10.2.89.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.89.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.89.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.89.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.89.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.89.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.89.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.89.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.89.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_89 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'tarSyr1' => 'carlito_syrichta/pep/Carlito_syrichta.tarSyr1.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.cavPor3.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'danRer10' => 'danio_rerio/pep/Danio_rerio.GRCz10.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd1' => 'dipodomys_ordii/pep/Dipodomys_ordii.dipOrd1.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal5' => 'gallus_gallus/pep/Gallus_gallus.Gallus_gallus-5.0.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.spetri2.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'rheMac8' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_8.0.1.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'micMur2' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_2.0.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus/pep/Mus_musculus_129s1svimj.129S1_SvImJ_v1.pep.all.fa.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/pep/Mus_musculus_aj.A_J_v1.pep.all.fa.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/pep/Mus_musculus_akrj.AKR_J_v1.pep.all.fa.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_balbcj.BALB_cJ_v1.pep.all.fa.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_c3hhej.C3H_HeJ_v1.pep.all.fa.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.pep.all.fa.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/pep/Mus_musculus_casteij.CAST_EiJ_v1.pep.all.fa.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_cbaj.CBA_J_v1.pep.all.fa.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_casteij/pep/Mus_musculus_dba2j.DBA_2J_v1.pep.all.fa.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/pep/Mus_musculus_fvbnj.FVB_NJ_v1.pep.all.fa.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/pep/Mus_musculus_lpj.LP_J_v1.pep.all.fa.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/pep/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.pep.all.fa.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/pep/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.pep.all.fa.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/pep/Mus_musculus_pwkphj.PWK_PhJ_v1.pep.all.fa.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/pep/Mus_musculus_wsbeij.WSB_EiJ_v1.pep.all.fa.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij/pep/Mus_spretus_spreteij.SPRET_EiJ_v1.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.pep.all.fa.gz',
'macEug1' => 'notamacropus_eugenii/pep/Notamacropus_eugenii.Meug_1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.OchPri2.0-Ens.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'ornAna2' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.pep.all.fa.gz',
'papAnu2' => 'papio_anubis/pep/Papio_anubis.PapAnu2.0.pep.all.fa.gz',
'papAnu3' => 'papio_anubis/pep/Papio_anubis.PapAnu2.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'rn6' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'susScr3' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa10.2.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_89 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_89_1',
'anaPla1' => 'anas_platyrhynchos_core_89_1',
'anoCar2' => 'anolis_carolinensis_core_89_2',
'astMex1' => 'astyanax_mexicanus_core_89_102',
'bosTau6' => 'bos_taurus_core_89_31',
'ce11' => 'caenorhabditis_elegans_core_89_250',
'calJac3' => 'callithrix_jacchus_core_89_321',
'canFam3' => 'canis_familiaris_core_89_31',
'tarSyr1' => 'carlito_syrichta_core_89_1',
'cavPor3' => 'cavia_porcellus_core_89_3',
'chlSab2' => 'chlorocebus_sabaeus_core_89_1',
'choHof1' => 'choloepus_hoffmanni_core_89_1',
'ci3' => 'ciona_intestinalis_core_89_3',
'cioSav2' => 'ciona_savignyi_core_89_2',
'danRer10' => 'danio_rerio_core_89_10',
'dasNov3' => 'dasypus_novemcinctus_core_89_3',
'dipOrd1' => 'dipodomys_ordii_core_89_1',
'dm6' => 'drosophila_melanogaster_core_89_6',
'echTel1' => 'echinops_telfairi_core_89_1',
'equCab2' => 'equus_caballus_core_89_2',
'eriEur1' => 'erinaceus_europaeus_core_89_1',
'felCat5' => 'felis_catus_core_89_62',
'ficAlb1' => 'ficedula_albicollis_core_89_1',
'gadMor1' => 'gadus_morhua_core_89_1',
'galGal5' => 'gallus_gallus_core_89_5',
'gasAcu1' => 'gasterosteus_aculeatus_core_89_1',
'gorGor3' => 'gorilla_gorilla_core_89_31',
'hg38' => 'homo_sapiens_core_89_38',
'speTri2' => 'ictidomys_tridecemlineatus_core_89_2',
'latCha1' => 'latimeria_chalumnae_core_89_1',
'lepOcu1' => 'lepisosteus_oculatus_core_89_1',
'loxAfr3' => 'loxodonta_africana_core_89_3',
'rheMac8' => 'macaca_mulatta_core_89_801',
'melGal1' => 'meleagris_gallopavo_core_89_21',
'micMur2' => 'microcebus_murinus_core_89_20',
'monDom5' => 'monodelphis_domestica_core_89_5',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj_core_89_1',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj_core_89_1',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj_core_89_1',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj_core_89_1',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej_core_89_1',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj_core_89_1',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij_core_89_1',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj_core_89_1',
'mm10' => 'mus_musculus_core_89_38',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j_core_89_1',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj_core_89_1',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj_core_89_1',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj_core_89_1',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj_core_89_1',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj_core_89_1',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij_core_89_1',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij_core_89_1',
'musFur1' => 'mustela_putorius_furo_core_89_1',
'myoLuc2' => 'myotis_lucifugus_core_89_2',
'nomLeu1' => 'nomascus_leucogenys_core_89_1',
'macEug1' => 'notamacropus_eugenii_core_89_1',
'ochPri2' => 'ochotona_princeps_core_89_1',
'oreNil1' => 'oreochromis_niloticus_core_89_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_89_1',
'ornAna2' => 'ornithorhynchus_anatinus_core_89_1',
'oryCun2' => 'oryctolagus_cuniculus_core_89_2',
'oryLat2' => 'oryzias_latipes_core_89_1',
'otoGar3' => 'otolemur_garnettii_core_89_3',
'oviAri3' => 'ovis_aries_core_89_31',
'panTro4' => 'pan_troglodytes_core_89_214',
'papAnu2' => 'papio_anubis_core_89_2',
'papAnu3' => 'papio_anubis_core_89_2',
'pelSin1' => 'pelodiscus_sinensis_core_89_1',
'petMar2' => 'petromyzon_marinus_core_89_7',
'poeFor1' => 'poecilia_formosa_core_89_512',
'ponAbe2' => 'pongo_abelii_core_89_1',
'proCap1' => 'procavia_capensis_core_89_1',
'pteVam1' => 'pteropus_vampyrus_core_89_1',
'rn6' => 'rattus_norvegicus_core_89_6',
'sacCer3' => 'saccharomyces_cerevisiae_core_89_4',
'sarHar1' => 'sarcophilus_harrisii_core_89_7',
'sorAra1' => 'sorex_araneus_core_89_1',
'susScr3' => 'sus_scrofa_core_89_102',
'taeGut1' => 'taeniopygia_guttata_core_89_1',
'fr2' => 'takifugu_rubripes_core_89_4',
'tetNig2' => 'tetraodon_nigroviridis_core_89_8',
'tupBel1' => 'tupaia_belangeri_core_89_1',
'turTru1' => 'tursiops_truncatus_core_89_1',
'vicPac1' => 'vicugna_pacos_core_89_1',
'xenTro3' => 'xenopus_tropicalis_core_89_42',
'xipMac1' => 'xiphophorus_maculatus_core_89_1',
);

my %ensGeneGtfFileNames_90 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.90.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.90.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.90.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.90.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.90.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.90.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.90.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.90.gtf.gz',
'tarSyr1' => 'carlito_syrichta/Carlito_syrichta.tarSyr1.90.gtf.gz',
'cavApe1' => 'cavia_aperea/Cavia_aperea.CavAp1.0.90.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.90.gtf.gz',
'chiLan1' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.90.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.90.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.90.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.90.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.90.gtf.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.90.gtf.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.90.gtf.gz',
'danRer10' => 'danio_rerio/Danio_rerio.GRCz10.90.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.90.gtf.gz',
'dipOrd2' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.90.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.90.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.90.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.90.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.90.gtf.gz',
'felCat5' => 'felis_catus/Felis_catus.Felis_catus_6.2.90.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.90.gtf.gz',
'fukDam1' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.90.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.90.gtf.gz',
'galGal5' => 'gallus_gallus/Gallus_gallus.Gallus_gallus-5.0.90.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.90.gtf.gz',
'gorGor3' => 'gorilla_gorilla/Gorilla_gorilla.gorGor3.1.90.gtf.gz',
'hetGla2' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.90.gtf.gz',
'hetGla1' => 'heterocephalus_glaber_male/Heterocephalus_glaber_male.HetGla_1.0.90.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.90.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.90.gtf.gz',
'jacJac1' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.90.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.90.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.90.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.90.gtf.gz',
'rheMac8' => 'macaca_mulatta/Macaca_mulatta.Mmul_8.0.1.90.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.90.gtf.gz',
'mesAur1' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.90.gtf.gz',
'micMur2' => 'microcebus_murinus/Microcebus_murinus.Mmur_2.0.90.gtf.gz',
'micOch1' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.90.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.BROADO5.90.gtf.gz',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli/Mus_caroli.CAROLI_EIJ_v1.1.90.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.90.gtf.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/Mus_musculus_129s1svimj.129S1_SvImJ_v1.86.gtf.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/Mus_musculus_aj.A_J_v1.86.gtf.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/Mus_musculus_akrj.AKR_J_v1.86.gtf.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/Mus_musculus_balbcj.BALB_cJ_v1.86.gtf.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/Mus_musculus_c3hhej.C3H_HeJ_v1.86.gtf.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.86.gtf.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/Mus_musculus_casteij.CAST_EiJ_v1.86.gtf.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/Mus_musculus_cbaj.CBA_J_v1.86.gtf.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/Mus_musculus_dba2j.DBA_2J_v1.86.gtf.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/Mus_musculus_fvbnj.FVB_NJ_v1.86.gtf.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/Mus_musculus_lpj.LP_J_v1.86.gtf.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.86.gtf.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.86.gtf.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/Mus_musculus_pwkphj.PWK_PhJ_v1.86.gtf.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/Mus_musculus_wsbeij.WSB_EiJ_v1.86.gtf.gz',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari/Mus_pahari.PAHARI_EIJ_v1.1.90.gtf.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij/Mus_spretus_spreteij.SPRET_EiJ_v1.86.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.90.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.90.gtf.gz',
'nanGal1' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.90.gtf.gz',
'nomLeu1' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu1.0.90.gtf.gz',
'macEug1' => 'notamacropus_eugenii/Notamacropus_eugenii.Meug_1.0.90.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.OchPri2.0-Ens.90.gtf.gz',
'octDeg1' => 'octodon_degus/Octodon_degus.OctDeg1.0.90.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.90.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.90.gtf.gz',
'ornAna2' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.90.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.90.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.90.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.90.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.90.gtf.gz',
'panTro4' => 'pan_troglodytes/Pan_troglodytes.CHIMP2.1.4.90.gtf.gz',
'papAnu2' => 'papio_anubis/Papio_anubis.PapAnu2.0.90.gtf.gz',
'papAnu3' => 'papio_anubis/Papio_anubis.PapAnu2.0.90.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.90.gtf.gz',
'perManBai1' => 'peromyscus_maniculatus_bairdii/Peromyscus_maniculatus_bairdii.Pman_1.0.90.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.90.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.90.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.90.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.90.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.90.gtf.gz',
'rn6' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.90.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.90.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.90.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.90.gtf.gz',
'susScr11' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.90.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.90.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.90.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.90.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.90.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.90.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.90.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.90.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.90.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_90 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'tarSyr1' => 'carlito_syrichta/pep/Carlito_syrichta.tarSyr1.pep.all.fa.gz',
'cavApe1' => 'cavia_aperea/pep/Cavia_aperea.CavAp1.0.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'chiLan1' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'criGriChoV2' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.pep.all.fa.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'danRer10' => 'danio_rerio/pep/Danio_rerio.GRCz10.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd2' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'felCat5' => 'felis_catus/pep/Felis_catus.Felis_catus_6.2.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'fukDam1' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal5' => 'gallus_gallus/pep/Gallus_gallus.Gallus_gallus-5.0.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gorGor3' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor3.1.pep.all.fa.gz',
'hetGla2' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'hetGla1' => 'heterocephalus_glaber_male/pep/Heterocephalus_glaber_male.HetGla_1.0.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'jacJac1' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'rheMac8' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_8.0.1.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'mesAur1' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'micMur2' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_2.0.pep.all.fa.gz',
'micOch1' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.BROADO5.pep.all.fa.gz',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli/pep/Mus_caroli.CAROLI_EIJ_v1.1.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus/pep/Mus_musculus_129s1svimj.129S1_SvImJ_v1.pep.all.fa.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/pep/Mus_musculus_aj.A_J_v1.pep.all.fa.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/pep/Mus_musculus_akrj.AKR_J_v1.pep.all.fa.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_balbcj.BALB_cJ_v1.pep.all.fa.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_c3hhej.C3H_HeJ_v1.pep.all.fa.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.pep.all.fa.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/pep/Mus_musculus_casteij.CAST_EiJ_v1.pep.all.fa.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_cbaj.CBA_J_v1.pep.all.fa.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_casteij/pep/Mus_musculus_dba2j.DBA_2J_v1.pep.all.fa.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/pep/Mus_musculus_fvbnj.FVB_NJ_v1.pep.all.fa.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/pep/Mus_musculus_lpj.LP_J_v1.pep.all.fa.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/pep/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.pep.all.fa.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/pep/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.pep.all.fa.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/pep/Mus_musculus_pwkphj.PWK_PhJ_v1.pep.all.fa.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/pep/Mus_musculus_wsbeij.WSB_EiJ_v1.pep.all.fa.gz',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari/pep/Mus_pahari.PAHARI_EIJ_v1.1.pep.all.fa.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij/pep/Mus_spretus_spreteij.SPRET_EiJ_v1.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nanGal1' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'nomLeu1' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu1.0.pep.all.fa.gz',
'macEug1' => 'notamacropus_eugenii/pep/Notamacropus_eugenii.Meug_1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.OchPri2.0-Ens.pep.all.fa.gz',
'octDeg1' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'ornAna2' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panTro4' => 'pan_troglodytes/pep/Pan_troglodytes.CHIMP2.1.4.pep.all.fa.gz',
'papAnu2' => 'papio_anubis/pep/Papio_anubis.PapAnu2.0.pep.all.fa.gz',
'papAnu3' => 'papio_anubis/pep/Papio_anubis.PapAnu2.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'perManBai1' => 'peromyscus_maniculatus_bairdii/pep/Peromyscus_maniculatus_bairdii.Pman_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'rn6' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'susScr11' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_90 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_90_1',
'anaPla1' => 'anas_platyrhynchos_core_90_1',
'anoCar2' => 'anolis_carolinensis_core_90_2',
'astMex1' => 'astyanax_mexicanus_core_90_102',
'bosTau6' => 'bos_taurus_core_90_31',
'ce11' => 'caenorhabditis_elegans_core_90_250',
'calJac3' => 'callithrix_jacchus_core_90_321',
'canFam3' => 'canis_familiaris_core_90_31',
'tarSyr1' => 'carlito_syrichta_core_90_1',
'cavApe1' => 'cavia_aperea_core_90_10',
'cavPor3' => 'cavia_porcellus_core_90_4',
'chiLan1' => 'chinchilla_lanigera_core_90_1',
'chlSab2' => 'chlorocebus_sabaeus_core_90_1',
'choHof1' => 'choloepus_hoffmanni_core_90_1',
'ci3' => 'ciona_intestinalis_core_90_3',
'cioSav2' => 'ciona_savignyi_core_90_2',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd_core_90_1',
'criGriChoV1' => 'cricetulus_griseus_crigri_core_90_1',
'danRer10' => 'danio_rerio_core_90_10',
'dasNov3' => 'dasypus_novemcinctus_core_90_3',
'dipOrd2' => 'dipodomys_ordii_core_90_2',
'dm6' => 'drosophila_melanogaster_core_90_6',
'echTel1' => 'echinops_telfairi_core_90_1',
'equCab2' => 'equus_caballus_core_90_2',
'eriEur1' => 'erinaceus_europaeus_core_90_1',
'felCat5' => 'felis_catus_core_90_62',
'ficAlb1' => 'ficedula_albicollis_core_90_1',
'fukDam1' => 'fukomys_damarensis_core_90_1',
'gadMor1' => 'gadus_morhua_core_90_1',
'galGal5' => 'gallus_gallus_core_90_5',
'gasAcu1' => 'gasterosteus_aculeatus_core_90_1',
'gorGor3' => 'gorilla_gorilla_core_90_31',
'hetGla2' => 'heterocephalus_glaber_female_core_90_1',
'hetGla1' => 'heterocephalus_glaber_male_core_90_1',
'hg38' => 'homo_sapiens_core_90_38',
'speTri2' => 'ictidomys_tridecemlineatus_core_90_3',
'jacJac1' => 'jaculus_jaculus_core_90_10',
'latCha1' => 'latimeria_chalumnae_core_90_1',
'lepOcu1' => 'lepisosteus_oculatus_core_90_1',
'loxAfr3' => 'loxodonta_africana_core_90_3',
'rheMac8' => 'macaca_mulatta_core_90_801',
'melGal1' => 'meleagris_gallopavo_core_90_21',
'mesAur1' => 'mesocricetus_auratus_core_90_10',
'micMur2' => 'microcebus_murinus_core_90_20',
'micOch1' => 'microtus_ochrogaster_core_90_10',
'monDom5' => 'monodelphis_domestica_core_90_5',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli_core_90_11',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj_core_90_1',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj_core_90_1',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj_core_90_1',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj_core_90_1',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej_core_90_1',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj_core_90_1',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij_core_90_1',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj_core_90_1',
'mm10' => 'mus_musculus_core_90_38',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j_core_90_1',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj_core_90_1',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj_core_90_1',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj_core_90_1',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj_core_90_1',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj_core_90_1',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij_core_90_1',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari_core_90_11',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij_core_90_1',
'musFur1' => 'mustela_putorius_furo_core_90_1',
'myoLuc2' => 'myotis_lucifugus_core_90_2',
'nanGal1' => 'nannospalax_galili_core_90_10',
'nomLeu1' => 'nomascus_leucogenys_core_90_1',
'macEug1' => 'notamacropus_eugenii_core_90_1',
'ochPri2' => 'ochotona_princeps_core_90_1',
'octDeg1' => 'octodon_degus_core_90_1',
'oreNil1' => 'oreochromis_niloticus_core_90_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_90_1',
'ornAna2' => 'ornithorhynchus_anatinus_core_90_1',
'oryCun2' => 'oryctolagus_cuniculus_core_90_2',
'oryLat2' => 'oryzias_latipes_core_90_1',
'otoGar3' => 'otolemur_garnettii_core_90_3',
'oviAri3' => 'ovis_aries_core_90_31',
'panTro4' => 'pan_troglodytes_core_90_214',
'papAnu2' => 'papio_anubis_core_90_2',
'papAnu3' => 'papio_anubis_core_90_2',
'pelSin1' => 'pelodiscus_sinensis_core_90_1',
'perManBai1' => 'peromyscus_maniculatus_bairdii_core_90_10',
'petMar2' => 'petromyzon_marinus_core_90_7',
'poeFor1' => 'poecilia_formosa_core_90_512',
'ponAbe2' => 'pongo_abelii_core_90_1',
'proCap1' => 'procavia_capensis_core_90_1',
'pteVam1' => 'pteropus_vampyrus_core_90_1',
'rn6' => 'rattus_norvegicus_core_90_6',
'sacCer3' => 'saccharomyces_cerevisiae_core_90_4',
'sarHar1' => 'sarcophilus_harrisii_core_90_7',
'sorAra1' => 'sorex_araneus_core_90_1',
'susScr11' => 'sus_scrofa_core_90_111',
'taeGut1' => 'taeniopygia_guttata_core_90_1',
'fr2' => 'takifugu_rubripes_core_90_4',
'tetNig2' => 'tetraodon_nigroviridis_core_90_8',
'tupBel1' => 'tupaia_belangeri_core_90_1',
'turTru1' => 'tursiops_truncatus_core_90_1',
'vicPac1' => 'vicugna_pacos_core_90_1',
'xenTro3' => 'xenopus_tropicalis_core_90_42',
'xipMac1' => 'xiphophorus_maculatus_core_90_1',
);

my %ensGeneGtfFileNames_91 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.91.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.91.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.91.gtf.gz',
'aotNan1' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.91.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.91.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.91.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.91.gtf.gz',
'calJac3' => 'callithrix_jacchus/Callithrix_jacchus.C_jacchus3.2.1.91.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.91.gtf.gz',
'tarSyr2' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.91.gtf.gz',
'cavApe1' => 'cavia_aperea/Cavia_aperea.CavAp1.0.91.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.91.gtf.gz',
'cebCap1' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.91.gtf.gz',
'cerAty1' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.91.gtf.gz',
'chiLan1' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.91.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.91.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.91.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.91.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.91.gtf.gz',
'colAng1' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.91.gtf.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.91.gtf.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.91.gtf.gz',
'danRer10' => 'danio_rerio/Danio_rerio.GRCz10.91.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.91.gtf.gz',
'dipOrd2' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.91.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.91.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.91.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.91.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.91.gtf.gz',
'felCat8' => 'felis_catus/Felis_catus.Felis_catus_8.0.91.gtf.gz',
'ficAlb0' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.91.gtf.gz',
'fukDam1' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.91.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.91.gtf.gz',
'galGal5' => 'gallus_gallus/Gallus_gallus.Gallus_gallus-5.0.91.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.91.gtf.gz',
'gorGor4' => 'gorilla_gorilla/Gorilla_gorilla.gorGor4.91.gtf.gz',
'hetGla2' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.91.gtf.gz',
'hetGla1' => 'heterocephalus_glaber_male/Heterocephalus_glaber_male.HetGla_1.0.91.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.91.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.91.gtf.gz',
'jacJac1' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.91.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.91.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.91.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.91.gtf.gz',
'macFas5' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_5.0.91.gtf.gz',
'rheMac8' => 'macaca_mulatta/Macaca_mulatta.Mmul_8.0.1.91.gtf.gz',
'macNem1' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.91.gtf.gz',
'manLeu1' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.91.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.91.gtf.gz',
'mesAur1' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.91.gtf.gz',
'micMur3' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.91.gtf.gz',
'micOch1' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.91.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.monDom5.91.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.91.gtf.gz',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli/Mus_caroli.CAROLI_EIJ_v1.1.90.gtf.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/Mus_musculus_129s1svimj.129S1_SvImJ_v1.86.gtf.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/Mus_musculus_aj.A_J_v1.86.gtf.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/Mus_musculus_akrj.AKR_J_v1.86.gtf.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/Mus_musculus_balbcj.BALB_cJ_v1.86.gtf.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/Mus_musculus_c3hhej.C3H_HeJ_v1.86.gtf.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.86.gtf.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/Mus_musculus_casteij.CAST_EiJ_v1.86.gtf.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/Mus_musculus_cbaj.CBA_J_v1.86.gtf.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/Mus_musculus_dba2j.DBA_2J_v1.86.gtf.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/Mus_musculus_fvbnj.FVB_NJ_v1.86.gtf.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/Mus_musculus_lpj.LP_J_v1.86.gtf.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.86.gtf.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.86.gtf.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/Mus_musculus_pwkphj.PWK_PhJ_v1.86.gtf.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/Mus_musculus_wsbeij.WSB_EiJ_v1.86.gtf.gz',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari/Mus_pahari.PAHARI_EIJ_v1.1.90.gtf.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij/Mus_spretus_spreteij.SPRET_EiJ_v1.86.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.91.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.91.gtf.gz',
'nanGal1' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.91.gtf.gz',
'nomLeu3' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu_3.0.91.gtf.gz',
'macEug1' => 'notamacropus_eugenii/Notamacropus_eugenii.Meug_1.0.91.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.OchPri2.0-Ens.91.gtf.gz',
'octDeg1' => 'octodon_degus/Octodon_degus.OctDeg1.0.91.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.91.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.91.gtf.gz',
'ornAna2' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.91.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.91.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.91.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.91.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.91.gtf.gz',
'panPan2' => 'pan_paniscus/Pan_paniscus.panpan1.1.91.gtf.gz',
'panTro5' => 'pan_troglodytes/Pan_troglodytes.Pan_tro_3.0.91.gtf.gz',
'papAnu4' => 'papio_anubis/Papio_anubis.Panu_3.0.91.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.91.gtf.gz',
'perManBai1' => 'peromyscus_maniculatus_bairdii/Peromyscus_maniculatus_bairdii.Pman_1.0.91.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.91.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.91.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.91.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.91.gtf.gz',
'proCoq1' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.91.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.91.gtf.gz',
'rn6' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.91.gtf.gz',
'rhiBie1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.91.gtf.gz',
'rhiRox1' => 'rhinopithecus_roxellana/Rhinopithecus_roxellana.Rrox_v1.91.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.91.gtf.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.91.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.91.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.91.gtf.gz',
'susScr11' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.91.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.91.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.91.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.91.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.91.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.91.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.91.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.91.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.91.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_91 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'aotNan1' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac3' => 'callithrix_jacchus/pep/Callithrix_jacchus.C_jacchus3.2.1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'tarSyr2' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'cavApe1' => 'cavia_aperea/pep/Cavia_aperea.CavAp1.0.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'cebCap1' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'cerAty1' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'chiLan1' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'colAng1' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/pep/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.pep.all.fa.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'danRer10' => 'danio_rerio/pep/Danio_rerio.GRCz10.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd2' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'felCat8' => 'felis_catus/pep/Felis_catus.Felis_catus_8.0.pep.all.fa.gz',
'ficAlb0' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'fukDam1' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal5' => 'gallus_gallus/pep/Gallus_gallus.Gallus_gallus-5.0.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gorGor4' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor4.pep.all.fa.gz',
'hetGla2' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'hetGla1' => 'heterocephalus_glaber_male/pep/Heterocephalus_glaber_male.HetGla_1.0.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'jacJac1' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'macFas5' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_5.0.pep.all.fa.gz',
'rheMac8' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_8.0.1.pep.all.fa.gz',
'macNem1' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'manLeu1' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'mesAur1' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'micMur3' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'micOch1' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.monDom5.pep.all.fa.gz',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli/pep/Mus_caroli.CAROLI_EIJ_v1.1.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus/pep/Mus_musculus_129s1svimj.129S1_SvImJ_v1.pep.all.fa.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/pep/Mus_musculus_aj.A_J_v1.pep.all.fa.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/pep/Mus_musculus_akrj.AKR_J_v1.pep.all.fa.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_balbcj.BALB_cJ_v1.pep.all.fa.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_c3hhej.C3H_HeJ_v1.pep.all.fa.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.pep.all.fa.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/pep/Mus_musculus_casteij.CAST_EiJ_v1.pep.all.fa.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_cbaj.CBA_J_v1.pep.all.fa.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_dba2j.DBA_2J_v1.pep.all.fa.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/pep/Mus_musculus_fvbnj.FVB_NJ_v1.pep.all.fa.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/pep/Mus_musculus_lpj.LP_J_v1.pep.all.fa.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/pep/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.pep.all.fa.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/pep/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.pep.all.fa.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/pep/Mus_musculus_pwkphj.PWK_PhJ_v1.pep.all.fa.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/pep/Mus_musculus_wsbeij.WSB_EiJ_v1.pep.all.fa.gz',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari/pep/Mus_pahari.PAHARI_EIJ_v1.1.pep.all.fa',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij/pep/Mus_spretus_spreteij.SPRET_EiJ_v1.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nanGal1' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'nomLeu3' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu_3.0.pep.all.fa.gz',
'macEug1' => 'notamacropus_eugenii/pep/Notamacropus_eugenii.Meug_1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.OchPri2.0-Ens.pep.all.fa.gz',
'octDeg1' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'ornAna2' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panPan2' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'panTro5' => 'pan_troglodytes/pep/Pan_troglodytes.Pan_tro_3.0.pep.all.fa.gz',
'papAnu4' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'perManBai1' => 'peromyscus_maniculatus_bairdii/pep/Peromyscus_maniculatus_bairdii.Pman_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'proCoq1' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'rn6' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'rhiBie1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'rhiRox1' => 'rhinopithecus_roxellana/pep/Rhinopithecus_roxellana.Rrox_v1.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'susScr11' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_91 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_91_1',
'anaPla1' => 'anas_platyrhynchos_core_91_1',
'anoCar2' => 'anolis_carolinensis_core_91_2',
'aotNan1' => 'aotus_nancymaae_core_91_1',
'astMex1' => 'astyanax_mexicanus_core_91_102',
'bosTau6' => 'bos_taurus_core_91_31',
'ce11' => 'caenorhabditis_elegans_core_91_260',
'calJac3' => 'callithrix_jacchus_core_91_321',
'canFam3' => 'canis_familiaris_core_91_31',
'tarSyr2' => 'carlito_syrichta_core_91_2',
'cavApe1' => 'cavia_aperea_core_91_10',
'cavPor3' => 'cavia_porcellus_core_91_4',
'cebCap1' => 'cebus_capucinus_core_91_1',
'cerAty1' => 'cercocebus_atys_core_91_1',
'chiLan1' => 'chinchilla_lanigera_core_91_1',
'chlSab2' => 'chlorocebus_sabaeus_core_91_1',
'choHof1' => 'choloepus_hoffmanni_core_91_1',
'ci3' => 'ciona_intestinalis_core_91_3',
'cioSav2' => 'ciona_savignyi_core_91_2',
'colAng1' => 'colobus_angolensis_palliatus_core_91_1',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd_core_91_1',
'criGriChoV1' => 'cricetulus_griseus_crigri_core_91_1',
'danRer10' => 'danio_rerio_core_91_10',
'dasNov3' => 'dasypus_novemcinctus_core_91_3',
'dipOrd2' => 'dipodomys_ordii_core_91_2',
'dm6' => 'drosophila_melanogaster_core_91_6',
'echTel1' => 'echinops_telfairi_core_91_1',
'equCab2' => 'equus_caballus_core_91_2',
'eriEur1' => 'erinaceus_europaeus_core_91_1',
'felCat8' => 'felis_catus_core_91_8',
'ficAlb0' => 'ficedula_albicollis_core_91_1',
'fukDam1' => 'fukomys_damarensis_core_91_1',
'gadMor1' => 'gadus_morhua_core_91_1',
'galGal5' => 'gallus_gallus_core_91_5',
'gasAcu1' => 'gasterosteus_aculeatus_core_91_1',
'gorGor4' => 'gorilla_gorilla_core_91_4',
'hetGla2' => 'heterocephalus_glaber_female_core_91_1',
'hetGla1' => 'heterocephalus_glaber_male_core_91_1',
'hg38' => 'homo_sapiens_core_91_38',
'speTri2' => 'ictidomys_tridecemlineatus_core_91_3',
'jacJac1' => 'jaculus_jaculus_core_91_10',
'latCha1' => 'latimeria_chalumnae_core_91_1',
'lepOcu1' => 'lepisosteus_oculatus_core_91_1',
'loxAfr3' => 'loxodonta_africana_core_91_3',
'macFas5' => 'macaca_fascicularis_core_91_5',
'rheMac8' => 'macaca_mulatta_core_91_801',
'macNem1' => 'macaca_nemestrina_core_91_1',
'manLeu1' => 'mandrillus_leucophaeus_core_91_1',
'melGal1' => 'meleagris_gallopavo_core_91_21',
'mesAur1' => 'mesocricetus_auratus_core_91_10',
'micMur3' => 'microcebus_murinus_core_91_3',
'micOch1' => 'microtus_ochrogaster_core_91_10',
'monDom5' => 'monodelphis_domestica_core_91_5',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli_core_91_11',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj_core_91_1',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj_core_91_1',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj_core_91_1',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj_core_91_1',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej_core_91_1',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj_core_91_1',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij_core_91_1',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj_core_91_1',
'mm10' => 'mus_musculus_core_91_38',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j_core_91_1',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj_core_91_1',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj_core_91_1',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj_core_91_1',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj_core_91_1',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj_core_91_1',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij_core_91_1',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari_core_91_11',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_spreteij_core_91_1',
'musFur1' => 'mustela_putorius_furo_core_91_1',
'myoLuc2' => 'myotis_lucifugus_core_91_2',
'nanGal1' => 'nannospalax_galili_core_91_10',
'nomLeu3' => 'nomascus_leucogenys_core_91_3',
'macEug1' => 'notamacropus_eugenii_core_91_1',
'ochPri2' => 'ochotona_princeps_core_91_1',
'octDeg1' => 'octodon_degus_core_91_1',
'oreNil1' => 'oreochromis_niloticus_core_91_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_91_1',
'ornAna2' => 'ornithorhynchus_anatinus_core_91_1',
'oryCun2' => 'oryctolagus_cuniculus_core_91_2',
'oryLat2' => 'oryzias_latipes_core_91_1',
'otoGar3' => 'otolemur_garnettii_core_91_3',
'oviAri3' => 'ovis_aries_core_91_31',
'panPan2' => 'pan_paniscus_core_91_1',
'panTro5' => 'pan_troglodytes_core_91_3',
'papAnu4' => 'papio_anubis_core_91_3',
'pelSin1' => 'pelodiscus_sinensis_core_91_1',
'perManBai1' => 'peromyscus_maniculatus_bairdii_core_91_10',
'petMar2' => 'petromyzon_marinus_core_91_7',
'poeFor1' => 'poecilia_formosa_core_91_512',
'ponAbe2' => 'pongo_abelii_core_91_1',
'proCap1' => 'procavia_capensis_core_91_1',
'proCoq1' => 'propithecus_coquereli_core_91_1',
'pteVam1' => 'pteropus_vampyrus_core_91_1',
'rn6' => 'rattus_norvegicus_core_91_6',
'rhiBie1' => 'rhinopithecus_bieti_core_91_1',
'rhiRox1' => 'rhinopithecus_roxellana_core_91_1',
'sacCer3' => 'saccharomyces_cerevisiae_core_91_4',
'saiBol1' => 'saimiri_boliviensis_boliviensis_core_91_1',
'sarHar1' => 'sarcophilus_harrisii_core_91_7',
'sorAra1' => 'sorex_araneus_core_91_1',
'susScr11' => 'sus_scrofa_core_91_111',
'taeGut1' => 'taeniopygia_guttata_core_91_1',
'fr2' => 'takifugu_rubripes_core_91_4',
'tetNig2' => 'tetraodon_nigroviridis_core_91_8',
'tupBel1' => 'tupaia_belangeri_core_91_1',
'turTru1' => 'tursiops_truncatus_core_91_1',
'vicPac1' => 'vicugna_pacos_core_91_1',
'xenTro3' => 'xenopus_tropicalis_core_91_42',
'xipMac1' => 'xiphophorus_maculatus_core_91_1',
);

my %ensGeneGtfFileNames_92 = (
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.92.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.92.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.92.gtf.gz',
'aotNan1' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.92.gtf.gz',
'astMex1' => 'astyanax_mexicanus/Astyanax_mexicanus.AstMex102.92.gtf.gz',
'bosTau6' => 'bos_taurus/Bos_taurus.UMD3.1.92.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.92.gtf.gz',
'calJac4' => 'callithrix_jacchus/Callithrix_jacchus.ASM275486v1.92.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.92.gtf.gz',
'capHir2' => 'capra_hircus/Capra_hircus.ARS1.92.gtf.gz',
'tarSyr2' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.92.gtf.gz',
'cavApe1' => 'cavia_aperea/Cavia_aperea.CavAp1.0.92.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.92.gtf.gz',
'cebCap1' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.92.gtf.gz',
'cerAty1' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.92.gtf.gz',
'chiLan1' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.92.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.92.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.92.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.92.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.92.gtf.gz',
'colAng1' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.92.gtf.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.92.gtf.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.92.gtf.gz',
'danRer11' => 'danio_rerio/Danio_rerio.GRCz11.92.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.92.gtf.gz',
'dipOrd2' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.92.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.92.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.92.gtf.gz',
'equCab2' => 'equus_caballus/Equus_caballus.EquCab2.92.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.92.gtf.gz',
'felCat8' => 'felis_catus/Felis_catus.Felis_catus_8.0.92.gtf.gz',
'ficAlb0' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.92.gtf.gz',
'fukDam1' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.92.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.92.gtf.gz',
'galGal5' => 'gallus_gallus/Gallus_gallus.Gallus_gallus-5.0.92.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.92.gtf.gz',
'gorGor4' => 'gorilla_gorilla/Gorilla_gorilla.gorGor4.92.gtf.gz',
'hetGla2' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.92.gtf.gz',
'hetGla1' => 'heterocephalus_glaber_male/Heterocephalus_glaber_male.HetGla_1.0.92.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.92.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.92.gtf.gz',
'jacJac1' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.92.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.92.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.92.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.92.gtf.gz',
'macFas5' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_5.0.92.gtf.gz',
'rheMac8' => 'macaca_mulatta/Macaca_mulatta.Mmul_8.0.1.92.gtf.gz',
'macNem1' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.92.gtf.gz',
'manLeu1' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.92.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.92.gtf.gz',
'mesAur1' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.92.gtf.gz',
'micMur3' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.92.gtf.gz',
'micOch1' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.92.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.monDom5.92.gtf.gz',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli/Mus_caroli.CAROLI_EIJ_v1.1.92.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.92.gtf.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/Mus_musculus_129s1svimj.129S1_SvImJ_v1.92.gtf.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/Mus_musculus_aj.A_J_v1.92.gtf.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/Mus_musculus_akrj.AKR_J_v1.92.gtf.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/Mus_musculus_balbcj.BALB_cJ_v1.92.gtf.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/Mus_musculus_c3hhej.C3H_HeJ_v1.92.gtf.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.92.gtf.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/Mus_musculus_casteij.CAST_EiJ_v1.92.gtf.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/Mus_musculus_cbaj.CBA_J_v1.92.gtf.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/Mus_musculus_dba2j.DBA_2J_v1.92.gtf.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/Mus_musculus_fvbnj.FVB_NJ_v1.92.gtf.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/Mus_musculus_lpj.LP_J_v1.92.gtf.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.92.gtf.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.92.gtf.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/Mus_musculus_pwkphj.PWK_PhJ_v1.92.gtf.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/Mus_musculus_wsbeij.WSB_EiJ_v1.92.gtf.gz',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari/Mus_pahari.PAHARI_EIJ_v1.1.92.gtf.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/Mus_spretus.SPRET_EiJ_v1.92.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.92.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.92.gtf.gz',
'nanGal1' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.92.gtf.gz',
'nomLeu3' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu_3.0.92.gtf.gz',
'macEug1' => 'notamacropus_eugenii/Notamacropus_eugenii.Meug_1.0.92.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.OchPri2.0-Ens.92.gtf.gz',
'octDeg1' => 'octodon_degus/Octodon_degus.OctDeg1.0.92.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.92.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.92.gtf.gz',
'ornAna2' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.92.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.92.gtf.gz',
'oryLat2' => 'oryzias_latipes/Oryzias_latipes.MEDAKA1.92.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.92.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.92.gtf.gz',
'panPan2' => 'pan_paniscus/Pan_paniscus.panpan1.1.92.gtf.gz',
'panTro5' => 'pan_troglodytes/Pan_troglodytes.Pan_tro_3.0.92.gtf.gz',
'papAnu4' => 'papio_anubis/Papio_anubis.Panu_3.0.92.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.92.gtf.gz',
'perManBai1' => 'peromyscus_maniculatus_bairdii/Peromyscus_maniculatus_bairdii.Pman_1.0.92.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.92.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.92.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.92.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.92.gtf.gz',
'proCoq1' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.92.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.92.gtf.gz',
'rn6' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.92.gtf.gz',
'rhiBie1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.92.gtf.gz',
'rhiRox1' => 'rhinopithecus_roxellana/Rhinopithecus_roxellana.Rrox_v1.92.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.92.gtf.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.92.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.92.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.92.gtf.gz',
'susScr11' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.92.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.92.gtf.gz',
'fr2' => 'takifugu_rubripes/Takifugu_rubripes.FUGU4.92.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.92.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.92.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.92.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.92.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.92.gtf.gz',
'xipMac1' => 'xiphophorus_maculatus/Xiphophorus_maculatus.Xipmac4.4.2.92.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_92 = (
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'aotNan1' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.AstMex102.pep.all.fa.gz',
'bosTau6' => 'bos_taurus/pep/Bos_taurus.UMD3.1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac4' => 'callithrix_jacchus/pep/Callithrix_jacchus.ASM275486v1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'capHir2' => 'capra_hircus/pep/Capra_hircus.ARS1.pep.all.fa.gz',
'tarSyr2' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'cavApe1' => 'cavia_aperea/pep/Cavia_aperea.CavAp1.0.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'cebCap1' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'cerAty1' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'chiLan1' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'colAng1' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/pep/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.pep.all.fa.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'danRer11' => 'danio_rerio/pep/Danio_rerio.GRCz11.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd2' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'equCab2' => 'equus_caballus/pep/Equus_caballus.EquCab2.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'felCat8' => 'felis_catus/pep/Felis_catus.Felis_catus_8.0.pep.all.fa.gz',
'ficAlb0' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'fukDam1' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal5' => 'gallus_gallus/pep/Gallus_gallus.Gallus_gallus-5.0.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gorGor4' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor4.pep.all.fa.gz',
'hetGla2' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'hetGla1' => 'heterocephalus_glaber_male/pep/Heterocephalus_glaber_male.HetGla_1.0.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'jacJac1' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'macFas5' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_5.0.pep.all.fa.gz',
'rheMac8' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_8.0.1.pep.all.fa.gz',
'macNem1' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'manLeu1' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'mesAur1' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'micMur3' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'micOch1' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.monDom5.pep.all.fa.gz',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli/pep/Mus_caroli.CAROLI_EIJ_v1.1.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus/pep/Mus_musculus_129s1svimj.129S1_SvImJ_v1.pep.all.fa.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/pep/Mus_musculus_aj.A_J_v1.pep.all.fa.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/pep/Mus_musculus_akrj.AKR_J_v1.pep.all.fa.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_balbcj.BALB_cJ_v1.pep.all.fa.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_c3hhej.C3H_HeJ_v1.pep.all.fa.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.pep.all.fa.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/pep/Mus_musculus_casteij.CAST_EiJ_v1.pep.all.fa.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_cbaj.CBA_J_v1.pep.all.fa.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_dba2j.DBA_2J_v1.pep.all.fa.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/pep/Mus_musculus_fvbnj.FVB_NJ_v1.pep.all.fa.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/pep/Mus_musculus_lpj.LP_J_v1.pep.all.fa.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/pep/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.pep.all.fa.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/pep/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.pep.all.fa.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/pep/Mus_musculus_pwkphj.PWK_PhJ_v1.pep.all.fa.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/pep/Mus_musculus_wsbeij.WSB_EiJ_v1.pep.all.fa.gz',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari/pep/Mus_pahari.PAHARI_EIJ_v1.1.pep.all.fa.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/pep/Mus_spretus.SPRET_EiJ_v1.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nanGal1' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'nomLeu3' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu_3.0.pep.all.fa.gz',
'macEug1' => 'notamacropus_eugenii/pep/Notamacropus_eugenii.Meug_1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.OchPri2.0-Ens.pep.all.fa.gz',
'octDeg1' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'ornAna2' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat2' => 'oryzias_latipes/pep/Oryzias_latipes.MEDAKA1.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panPan2' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'panTro5' => 'pan_troglodytes/pep/Pan_troglodytes.Pan_tro_3.0.pep.all.fa.gz',
'papAnu4' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'perManBai1' => 'peromyscus_maniculatus_bairdii/pep/Peromyscus_maniculatus_bairdii.Pman_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'proCoq1' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'rn6' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'rhiBie1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'rhiRox1' => 'rhinopithecus_roxellana/pep/Rhinopithecus_roxellana.Rrox_v1.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'susScr11' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr2' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU4.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipMac1' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.Xipmac4.4.2.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_92 = (
'ailMel1' => 'ailuropoda_melanoleuca_core_92_1',
'anaPla1' => 'anas_platyrhynchos_core_92_1',
'anoCar2' => 'anolis_carolinensis_core_92_2',
'aotNan1' => 'aotus_nancymaae_core_92_1',
'astMex1' => 'astyanax_mexicanus_core_92_102',
'bosTau6' => 'bos_taurus_core_92_31',
'ce11' => 'caenorhabditis_elegans_core_92_260',
'calJac4' => 'callithrix_jacchus_core_92_1',
'canFam3' => 'canis_familiaris_core_92_31',
'capHir2' => 'capra_hircus_core_92_1',
'tarSyr2' => 'carlito_syrichta_core_92_2',
'cavApe1' => 'cavia_aperea_core_92_10',
'cavPor3' => 'cavia_porcellus_core_92_4',
'cebCap1' => 'cebus_capucinus_core_92_1',
'cerAty1' => 'cercocebus_atys_core_92_1',
'chiLan1' => 'chinchilla_lanigera_core_92_1',
'chlSab2' => 'chlorocebus_sabaeus_core_92_1',
'choHof1' => 'choloepus_hoffmanni_core_92_1',
'ci3' => 'ciona_intestinalis_core_92_3',
'cioSav2' => 'ciona_savignyi_core_92_2',
'colAng1' => 'colobus_angolensis_palliatus_core_92_1',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd_core_92_1',
'criGriChoV1' => 'cricetulus_griseus_crigri_core_92_1',
'danRer11' => 'danio_rerio_core_92_11',
'dasNov3' => 'dasypus_novemcinctus_core_92_3',
'dipOrd2' => 'dipodomys_ordii_core_92_2',
'dm6' => 'drosophila_melanogaster_core_92_6',
'echTel1' => 'echinops_telfairi_core_92_1',
'equCab2' => 'equus_caballus_core_92_2',
'eriEur1' => 'erinaceus_europaeus_core_92_1',
'felCat8' => 'felis_catus_core_92_8',
'ficAlb0' => 'ficedula_albicollis_core_92_1',
'fukDam1' => 'fukomys_damarensis_core_92_1',
'gadMor1' => 'gadus_morhua_core_92_1',
'galGal5' => 'gallus_gallus_core_92_5',
'gasAcu1' => 'gasterosteus_aculeatus_core_92_1',
'gorGor4' => 'gorilla_gorilla_core_92_4',
'hetGla2' => 'heterocephalus_glaber_female_core_92_1',
'hetGla1' => 'heterocephalus_glaber_male_core_92_1',
'hg38' => 'homo_sapiens_core_92_38',
'speTri2' => 'ictidomys_tridecemlineatus_core_92_3',
'jacJac1' => 'jaculus_jaculus_core_92_10',
'latCha1' => 'latimeria_chalumnae_core_92_1',
'lepOcu1' => 'lepisosteus_oculatus_core_92_1',
'loxAfr3' => 'loxodonta_africana_core_92_3',
'macFas5' => 'macaca_fascicularis_core_92_5',
'rheMac8' => 'macaca_mulatta_core_92_801',
'macNem1' => 'macaca_nemestrina_core_92_1',
'manLeu1' => 'mandrillus_leucophaeus_core_92_1',
'melGal1' => 'meleagris_gallopavo_core_92_21',
'mesAur1' => 'mesocricetus_auratus_core_92_10',
'micMur3' => 'microcebus_murinus_core_92_3',
'micOch1' => 'microtus_ochrogaster_core_92_10',
'monDom5' => 'monodelphis_domestica_core_92_5',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli_core_92_11',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj_core_92_1',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj_core_92_1',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj_core_92_1',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj_core_92_1',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej_core_92_1',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj_core_92_1',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij_core_92_1',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj_core_92_1',
'mm10' => 'mus_musculus_core_92_38',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j_core_92_1',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj_core_92_1',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj_core_92_1',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj_core_92_1',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj_core_92_1',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj_core_92_1',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij_core_92_1',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari_core_92_11',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_core_92_1',
'musFur1' => 'mustela_putorius_furo_core_92_1',
'myoLuc2' => 'myotis_lucifugus_core_92_2',
'nanGal1' => 'nannospalax_galili_core_92_10',
'nomLeu3' => 'nomascus_leucogenys_core_92_3',
'macEug1' => 'notamacropus_eugenii_core_92_1',
'ochPri2' => 'ochotona_princeps_core_92_1',
'octDeg1' => 'octodon_degus_core_92_1',
'oreNil1' => 'oreochromis_niloticus_core_92_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_92_1',
'ornAna2' => 'ornithorhynchus_anatinus_core_92_1',
'oryCun2' => 'oryctolagus_cuniculus_core_92_2',
'oryLat2' => 'oryzias_latipes_core_92_1',
'otoGar3' => 'otolemur_garnettii_core_92_3',
'oviAri3' => 'ovis_aries_core_92_31',
'panPan2' => 'pan_paniscus_core_92_1',
'panTro5' => 'pan_troglodytes_core_92_3',
'papAnu4' => 'papio_anubis_core_92_3',
'pelSin1' => 'pelodiscus_sinensis_core_92_1',
'perManBai1' => 'peromyscus_maniculatus_bairdii_core_92_10',
'petMar2' => 'petromyzon_marinus_core_92_7',
'poeFor1' => 'poecilia_formosa_core_92_512',
'ponAbe2' => 'pongo_abelii_core_92_1',
'proCap1' => 'procavia_capensis_core_92_1',
'proCoq1' => 'propithecus_coquereli_core_92_1',
'pteVam1' => 'pteropus_vampyrus_core_92_1',
'rn6' => 'rattus_norvegicus_core_92_6',
'rhiBie1' => 'rhinopithecus_bieti_core_92_1',
'rhiRox1' => 'rhinopithecus_roxellana_core_92_1',
'sacCer3' => 'saccharomyces_cerevisiae_core_92_4',
'saiBol1' => 'saimiri_boliviensis_boliviensis_core_92_1',
'sarHar1' => 'sarcophilus_harrisii_core_92_7',
'sorAra1' => 'sorex_araneus_core_92_1',
'susScr11' => 'sus_scrofa_core_92_111',
'taeGut1' => 'taeniopygia_guttata_core_92_1',
'fr2' => 'takifugu_rubripes_core_92_4',
'tetNig2' => 'tetraodon_nigroviridis_core_92_8',
'tupBel1' => 'tupaia_belangeri_core_92_1',
'turTru1' => 'tursiops_truncatus_core_92_1',
'vicPac1' => 'vicugna_pacos_core_92_1',
'xenTro3' => 'xenopus_tropicalis_core_92_42',
'xipMac1' => 'xiphophorus_maculatus_core_92_1',
);

my %ensGeneGtfFileNames_95 = (
'acaPol1' => 'acanthochromis_polyacanthus/Acanthochromis_polyacanthus.ASM210954v1.95.gtf.gz',
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.95.gtf.gz',
'ampCit1' => 'amphilophus_citrinellus/Amphilophus_citrinellus.Midas_v5.95.gtf.gz',
'ampOce1' => 'amphiprion_ocellaris/Amphiprion_ocellaris.AmpOce1.0.95.gtf.gz',
'ampPer1' => 'amphiprion_percula/Amphiprion_percula.Nemo_v1.95.gtf.gz',
'anaTes1' => 'anabas_testudineus/Anabas_testudineus.fAnaTes1.1.95.gtf.gz',
'anaPla1' => 'anas_platyrhynchos/Anas_platyrhynchos.BGI_duck_1.0.95.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.95.gtf.gz',
'aotNan1' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.95.gtf.gz',
'astCal1' => 'astatotilapia_calliptera/Astatotilapia_calliptera.fAstCal1.2.95.gtf.gz',
'astMex2' => 'astyanax_mexicanus/Astyanax_mexicanus.Astyanax_mexicanus-2.0.95.gtf.gz',
'bosTau9' => 'bos_taurus/Bos_taurus.ARS-UCD1.2.95.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.95.gtf.gz',
'calJac4' => 'callithrix_jacchus/Callithrix_jacchus.ASM275486v1.95.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.95.gtf.gz',
'canLupDin1' => 'canis_lupus_dingo/Canis_lupus_dingo.ASM325472v1.95.gtf.gz',
'capHir2' => 'capra_hircus/Capra_hircus.ARS1.95.gtf.gz',
'tarSyr2' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.95.gtf.gz',
'cavApe1' => 'cavia_aperea/Cavia_aperea.CavAp1.0.95.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.95.gtf.gz',
'cebCap1' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.95.gtf.gz',
'cerAty1' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.95.gtf.gz',
'chiLan1' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.95.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.95.gtf.gz',
'choHof1' => 'choloepus_hoffmanni/Choloepus_hoffmanni.choHof1.95.gtf.gz',
'chrPic2' => 'chrysemys_picta_bellii/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.95.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.95.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.95.gtf.gz',
'colAng1' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.95.gtf.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.95.gtf.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.95.gtf.gz',
'cynSem1' => 'cynoglossus_semilaevis/Cynoglossus_semilaevis.Cse_v1.0.95.gtf.gz',
'cypVar1' => 'cyprinodon_variegatus/Cyprinodon_variegatus.C_variegatus-1.0.95.gtf.gz',
'danRer11' => 'danio_rerio/Danio_rerio.GRCz11.95.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.95.gtf.gz',
'dipOrd2' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.95.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.95.gtf.gz',
'echTel1' => 'echinops_telfairi/Echinops_telfairi.TENREC.95.gtf.gz',
'eptBur1' => 'eptatretus_burgeri/Eptatretus_burgeri.Eburgeri_3.2.95.gtf.gz',
'equAsi1' => 'equus_asinus_asinus/Equus_asinus_asinus.ASM303372v1.95.gtf.gz',
'equCab3' => 'equus_caballus/Equus_caballus.EquCab3.0.95.gtf.gz',
'eriEur1' => 'erinaceus_europaeus/Erinaceus_europaeus.HEDGEHOG.95.gtf.gz',
'esoLuc2' => 'esox_lucius/Esox_lucius.Eluc_V3.95.gtf.gz',
'felCat9' => 'felis_catus/Felis_catus.Felis_catus_9.0.95.gtf.gz',
'ficAlb0' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb_1.4.95.gtf.gz',
'fukDam1' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.95.gtf.gz',
'funHet1' => 'fundulus_heteroclitus/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.95.gtf.gz',
'gadMor1' => 'gadus_morhua/Gadus_morhua.gadMor1.95.gtf.gz',
'galGal6' => 'gallus_gallus/Gallus_gallus.GRCg6a.95.gtf.gz',
'gamAff1' => 'gambusia_affinis/Gambusia_affinis.ASM309773v1.95.gtf.gz',
'gasAcu1' => 'gasterosteus_aculeatus/Gasterosteus_aculeatus.BROADS1.95.gtf.gz',
'gopAga1' => 'gopherus_agassizii/Gopherus_agassizii.ASM289641v1.95.gtf.gz',
'gorGor4' => 'gorilla_gorilla/Gorilla_gorilla.gorGor4.95.gtf.gz',
'hapBur1' => 'haplochromis_burtoni/Haplochromis_burtoni.AstBur1.0.95.gtf.gz',
'hetGla2' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.95.gtf.gz',
'hetGla1' => 'heterocephalus_glaber_male/Heterocephalus_glaber_male.HetGla_1.0.95.gtf.gz',
'hipCom1' => 'hippocampus_comes/Hippocampus_comes.H_comes_QL1_v1.95.gtf.gz',
'hg38' => 'homo_sapiens/Homo_sapiens.GRCh38.95.gtf.gz',
'ictPun1' => 'ictalurus_punctatus/Ictalurus_punctatus.IpCoco_1.2.95.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.95.gtf.gz',
'jacJac1' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.95.gtf.gz',
'kryMar1' => 'kryptolebias_marmoratus/Kryptolebias_marmoratus.ASM164957v1.95.gtf.gz',
'labBer1' => 'labrus_bergylta/Labrus_bergylta.BallGen_V1.95.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.95.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.95.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.95.gtf.gz',
'macFas5' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_5.0.95.gtf.gz',
'rheMac8' => 'macaca_mulatta/Macaca_mulatta.Mmul_8.0.1.95.gtf.gz',
'macNem1' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.95.gtf.gz',
'manLeu1' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.95.gtf.gz',
'masArm1' => 'mastacembelus_armatus/Mastacembelus_armatus.fMasArm1.1.95.gtf.gz',
'mayZeb2' => 'maylandia_zebra/Maylandia_zebra.M_zebra_UMD2a.95.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.UMD2.95.gtf.gz',
'mesAur1' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.95.gtf.gz',
'micMur3' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.95.gtf.gz',
'micOch1' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.95.gtf.gz',
'molMol1' => 'mola_mola/Mola_mola.ASM169857v1.95.gtf.gz',
'monDom5' => 'monodelphis_domestica/Monodelphis_domestica.monDom5.95.gtf.gz',
'monAlb1' => 'monopterus_albus/Monopterus_albus.M_albus_1.0.95.gtf.gz',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli/Mus_caroli.CAROLI_EIJ_v1.1.95.gtf.gz',
'mm10' => 'mus_musculus/Mus_musculus.GRCm38.95.gtf.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/Mus_musculus_129s1svimj.129S1_SvImJ_v1.95.gtf.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/Mus_musculus_aj.A_J_v1.95.gtf.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/Mus_musculus_akrj.AKR_J_v1.95.gtf.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/Mus_musculus_balbcj.BALB_cJ_v1.95.gtf.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/Mus_musculus_c3hhej.C3H_HeJ_v1.95.gtf.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.95.gtf.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/Mus_musculus_casteij.CAST_EiJ_v1.95.gtf.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/Mus_musculus_cbaj.CBA_J_v1.95.gtf.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/Mus_musculus_dba2j.DBA_2J_v1.95.gtf.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/Mus_musculus_fvbnj.FVB_NJ_v1.95.gtf.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/Mus_musculus_lpj.LP_J_v1.95.gtf.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.95.gtf.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.95.gtf.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/Mus_musculus_pwkphj.PWK_PhJ_v1.95.gtf.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/Mus_musculus_wsbeij.WSB_EiJ_v1.95.gtf.gz',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari/Mus_pahari.PAHARI_EIJ_v1.1.95.gtf.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/Mus_spretus.SPRET_EiJ_v1.95.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.95.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.95.gtf.gz',
'nanGal1' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.95.gtf.gz',
'neoBri1' => 'neolamprologus_brichardi/Neolamprologus_brichardi.NeoBri1.0.95.gtf.gz',
'nomLeu3' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu_3.0.95.gtf.gz',
'macEug1' => 'notamacropus_eugenii/Notamacropus_eugenii.Meug_1.0.95.gtf.gz',
'ochPri2' => 'ochotona_princeps/Ochotona_princeps.OchPri2.0-Ens.95.gtf.gz',
'octDeg1' => 'octodon_degus/Octodon_degus.OctDeg1.0.95.gtf.gz',
'oreNil1' => 'oreochromis_niloticus/Oreochromis_niloticus.Orenil1.0.95.gtf.gz',
'ornAna1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.95.gtf.gz',
'ornAna2' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.OANA5.95.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.95.gtf.gz',
'oryLat4' => 'oryzias_latipes/Oryzias_latipes.ASM223467v1.95.gtf.gz',
'oryLat5' => 'oryzias_latipes_hni/Oryzias_latipes_hni.ASM223471v1.95.gtf.gz',
'oryLat6' => 'oryzias_latipes_hsok/Oryzias_latipes_hsok.ASM223469v1.95.gtf.gz',
'oryMel1' => 'oryzias_melastigma/Oryzias_melastigma.Om_v0.7.RACA.95.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.95.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.95.gtf.gz',
'panPan2' => 'pan_paniscus/Pan_paniscus.panpan1.1.95.gtf.gz',
'panTro5' => 'pan_troglodytes/Pan_troglodytes.Pan_tro_3.0.95.gtf.gz',
'panPar1' => 'panthera_pardus/Panthera_pardus.PanPar1.0.95.gtf.gz',
'panTig1' => 'panthera_tigris_altaica/Panthera_tigris_altaica.PanTig1.0.95.gtf.gz',
'papAnu4' => 'papio_anubis/Papio_anubis.Panu_3.0.95.gtf.gz',
'parKin1' => 'paramormyrops_kingsleyae/Paramormyrops_kingsleyae.PKINGS_0.1.95.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.95.gtf.gz',
'perMag1' => 'periophthalmus_magnuspinnatus/Periophthalmus_magnuspinnatus.PM.fa.95.gtf.gz',
'perManBai1' => 'peromyscus_maniculatus_bairdii/Peromyscus_maniculatus_bairdii.Pman_1.0.95.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.95.gtf.gz',
'phaCin1' => 'phascolarctos_cinereus/Phascolarctos_cinereus.phaCin_tgac_v2.0.95.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.95.gtf.gz',
'poeLat1' => 'poecilia_latipinna/Poecilia_latipinna.P_latipinna-1.0.95.gtf.gz',
'poeMex1' => 'poecilia_mexicana/Poecilia_mexicana.P_mexicana-1.0.95.gtf.gz',
'poeRet1' => 'poecilia_reticulata/Poecilia_reticulata.Guppy_female_1.0_MT.95.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.95.gtf.gz',
'proCap1' => 'procavia_capensis/Procavia_capensis.proCap1.95.gtf.gz',
'proCoq1' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.95.gtf.gz',
'pteVam1' => 'pteropus_vampyrus/Pteropus_vampyrus.pteVam1.95.gtf.gz',
'punNye1' => 'pundamilia_nyererei/Pundamilia_nyererei.PunNye1.0.95.gtf.gz',
'pygNat1' => 'pygocentrus_nattereri/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.95.gtf.gz',
'rn6' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.95.gtf.gz',
'rhiBie1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.95.gtf.gz',
'rhiRox1' => 'rhinopithecus_roxellana/Rhinopithecus_roxellana.Rrox_v1.95.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.95.gtf.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.95.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.95.gtf.gz',
'sclFor1' => 'scleropages_formosus/Scleropages_formosus.ASM162426v1.95.gtf.gz',
'scoMax1' => 'scophthalmus_maximus/Scophthalmus_maximus.ASM318616v1.95.gtf.gz',
'serDum1' => 'seriola_dumerili/Seriola_dumerili.Sdu_1.0.95.gtf.gz',
'serDor1' => 'seriola_lalandi_dorsalis/Seriola_lalandi_dorsalis.Sedor1.95.gtf.gz',
'sorAra1' => 'sorex_araneus/Sorex_araneus.COMMON_SHREW1.95.gtf.gz',
'sphPun1' => 'sphenodon_punctatus/Sphenodon_punctatus.ASM311381v1.95.gtf.gz',
'stePar1' => 'stegastes_partitus/Stegastes_partitus.Stegastes_partitus-1.0.2.95.gtf.gz',
'susScr11' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.95.gtf.gz',
'taeGut1' => 'taeniopygia_guttata/Taeniopygia_guttata.taeGut3.2.4.95.gtf.gz',
'fr3' => 'takifugu_rubripes/Takifugu_rubripes.FUGU5.95.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.95.gtf.gz',
'tupBel1' => 'tupaia_belangeri/Tupaia_belangeri.TREESHREW.95.gtf.gz',
'turTru1' => 'tursiops_truncatus/Tursiops_truncatus.turTru1.95.gtf.gz',
'ursAme1' => 'ursus_americanus/Ursus_americanus.ASM334442v1.95.gtf.gz',
'ursMar1' => 'ursus_maritimus/Ursus_maritimus.UrsMar_1.0.95.gtf.gz',
'vicPac1' => 'vicugna_pacos/Vicugna_pacos.vicPac1.95.gtf.gz',
'vulVul1' => 'vulpes_vulpes/Vulpes_vulpes.VulVul2.2.95.gtf.gz',
'xenTro3' => 'xenopus_tropicalis/Xenopus_tropicalis.JGI_4.2.95.gtf.gz',
'xipCou1' => 'xiphophorus_couchianus/Xiphophorus_couchianus.Xiphophorus_couchianus-4.0.1.95.gtf.gz',
'xipMac2' => 'xiphophorus_maculatus/Xiphophorus_maculatus.X_maculatus-5.0-male.95.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_95 = (
'acaPol1' => 'acanthochromis_polyacanthus/pep/Acanthochromis_polyacanthus.ASM210954v1.pep.all.fa.gz',
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'ampCit1' => 'amphilophus_citrinellus/pep/Amphilophus_citrinellus.Midas_v5.pep.all.fa.gz',
'ampOce1' => 'amphiprion_ocellaris/pep/Amphiprion_ocellaris.AmpOce1.0.pep.all.fa.gz',
'ampPer1' => 'amphiprion_percula/pep/Amphiprion_percula.Nemo_v1.pep.all.fa.gz',
'anaTes1' => 'anabas_testudineus/pep/Anabas_testudineus.fAnaTes1.1.pep.all.fa.gz',
'anaPla1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.BGI_duck_1.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'aotNan1' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'astCal1' => 'astatotilapia_calliptera/pep/Astatotilapia_calliptera.fAstCal1.2.pep.all.fa.gz',
'astMex2' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.Astyanax_mexicanus-2.0.pep.all.fa.gz',
'bosTau9' => 'bos_taurus/pep/Bos_taurus.ARS-UCD1.2.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'calJac4' => 'callithrix_jacchus/pep/Callithrix_jacchus.ASM275486v1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'canLupDin1' => 'canis_lupus_dingo/pep/Canis_lupus_dingo.ASM325472v1.pep.all.fa.gz',
'capHir2' => 'capra_hircus/pep/Capra_hircus.ARS1.pep.all.fa.gz',
'tarSyr2' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'cavApe1' => 'cavia_aperea/pep/Cavia_aperea.CavAp1.0.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'cebCap1' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'cerAty1' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'chiLan1' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'choHof1' => 'choloepus_hoffmanni/pep/Choloepus_hoffmanni.choHof1.pep.all.fa.gz',
'chrPic2' => 'chrysemys_picta_bellii/pep/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'colAng1' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/pep/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.pep.all.fa.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'cynSem1' => 'cynoglossus_semilaevis/pep/Cynoglossus_semilaevis.Cse_v1.0.pep.all.fa.gz',
'cypVar1' => 'cyprinodon_variegatus/pep/Cyprinodon_variegatus.C_variegatus-1.0.pep.all.fa.gz',
'danRer11' => 'danio_rerio/pep/Danio_rerio.GRCz11.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dipOrd2' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.pep.all.fa.gz',
'echTel1' => 'echinops_telfairi/pep/Echinops_telfairi.TENREC.pep.all.fa.gz',
'eptBur1' => 'eptatretus_burgeri/pep/Eptatretus_burgeri.Eburgeri_3.2.pep.all.fa.gz',
'equAsi1' => 'equus_asinus_asinus/pep/Equus_asinus_asinus.ASM303372v1.pep.all.fa.gz',
'equCab3' => 'equus_caballus/pep/Equus_caballus.EquCab3.0.pep.all.fa.gz',
'eriEur1' => 'erinaceus_europaeus/pep/Erinaceus_europaeus.HEDGEHOG.pep.all.fa.gz',
'esoLuc2' => 'esox_lucius/pep/Esox_lucius.Eluc_V3.pep.all.fa.gz',
'felCat9' => 'felis_catus/pep/Felis_catus.Felis_catus_9.0.pep.all.fa.gz',
'ficAlb0' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb_1.4.pep.all.fa.gz',
'fukDam1' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'funHet1' => 'fundulus_heteroclitus/pep/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.pep.all.fa.gz',
'gadMor1' => 'gadus_morhua/pep/Gadus_morhua.gadMor1.pep.all.fa.gz',
'galGal6' => 'gallus_gallus/pep/Gallus_gallus.GRCg6a.pep.all.fa.gz',
'gamAff1' => 'gambusia_affinis/pep/Gambusia_affinis.ASM309773v1.pep.all.fa.gz',
'gasAcu1' => 'gasterosteus_aculeatus/pep/Gasterosteus_aculeatus.BROADS1.pep.all.fa.gz',
'gopAga1' => 'gopherus_agassizii/pep/Gopherus_agassizii.ASM289641v1.pep.all.fa.gz',
'gorGor4' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor4.pep.all.fa.gz',
'hapBur1' => 'haplochromis_burtoni/pep/Haplochromis_burtoni.AstBur1.0.pep.all.fa.gz',
'hetGla2' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'hetGla1' => 'heterocephalus_glaber_male/pep/Heterocephalus_glaber_male.HetGla_1.0.pep.all.fa.gz',
'hipCom1' => 'hippocampus_comes/pep/Hippocampus_comes.H_comes_QL1_v1.pep.all.fa.gz',
'hg38' => 'homo_sapiens/pep/Homo_sapiens.GRCh38.pep.all.fa.gz',
'ictPun1' => 'ictalurus_punctatus/pep/Ictalurus_punctatus.IpCoco_1.2.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'jacJac1' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'kryMar1' => 'kryptolebias_marmoratus/pep/Kryptolebias_marmoratus.ASM164957v1.pep.all.fa.gz',
'labBer1' => 'labrus_bergylta/pep/Labrus_bergylta.BallGen_V1.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'macFas5' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_5.0.pep.all.fa.gz',
'rheMac8' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_8.0.1.pep.all.fa.gz',
'macNem1' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'manLeu1' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'masArm1' => 'mastacembelus_armatus/pep/Mastacembelus_armatus.fMasArm1.1.pep.all.fa.gz',
'mayZeb2' => 'maylandia_zebra/pep/Maylandia_zebra.M_zebra_UMD2a.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.UMD2.pep.all.fa.gz',
'mesAur1' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'micMur3' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'micOch1' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'molMol1' => 'mola_mola/pep/Mola_mola.ASM169857v1.pep.all.fa.gz',
'monDom5' => 'monodelphis_domestica/pep/Monodelphis_domestica.monDom5.pep.all.fa.gz',
'monAlb1' => 'monopterus_albus/pep/Monopterus_albus.M_albus_1.0.pep.all.fa.gz',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli/pep/Mus_caroli.CAROLI_EIJ_v1.1.pep.all.fa.gz',
'mm10' => 'mus_musculus/pep/Mus_musculus.GRCm38.pep.all.fa.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus/pep/Mus_musculus_129s1svimj.129S1_SvImJ_v1.pep.all.fa.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/pep/Mus_musculus_aj.A_J_v1.pep.all.fa.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/pep/Mus_musculus_akrj.AKR_J_v1.pep.all.fa.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_balbcj.BALB_cJ_v1.pep.all.fa.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_c3hhej.C3H_HeJ_v1.pep.all.fa.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.pep.all.fa.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/pep/Mus_musculus_casteij.CAST_EiJ_v1.pep.all.fa.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_cbaj.CBA_J_v1.pep.all.fa.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_dba2j.DBA_2J_v1.pep.all.fa.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/pep/Mus_musculus_fvbnj.FVB_NJ_v1.pep.all.fa.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/pep/Mus_musculus_lpj.LP_J_v1.pep.all.fa.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/pep/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.pep.all.fa.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/pep/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.pep.all.fa.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/pep/Mus_musculus_pwkphj.PWK_PhJ_v1.pep.all.fa.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/pep/Mus_musculus_wsbeij.WSB_EiJ_v1.pep.all.fa.gz',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari/pep/Mus_pahari.PAHARI_EIJ_v1.1.pep.all.fa.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/pep/Mus_spretus.SPRET_EiJ_v1.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'nanGal1' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'neoBri1' => 'neolamprologus_brichardi/pep/Neolamprologus_brichardi.NeoBri1.0.pep.all.fa.gz',
'nomLeu3' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu_3.0.pep.all.fa.gz',
'macEug1' => 'notamacropus_eugenii/pep/Notamacropus_eugenii.Meug_1.0.pep.all.fa.gz',
'ochPri2' => 'ochotona_princeps/pep/Ochotona_princeps.OchPri2.0-Ens.pep.all.fa.gz',
'octDeg1' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'oreNil1' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.Orenil1.0.pep.all.fa.gz',
'ornAna1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'ornAna2' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.OANA5.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryLat4' => 'oryzias_latipes/pep/Oryzias_latipes.ASM223467v1.pep.all.fa.gz',
'oryLat5' => 'oryzias_latipes_hni/pep/Oryzias_latipes_hni.ASM223471v1.pep.all.fa.gz',
'oryLat6' => 'oryzias_latipes_hsok/pep/Oryzias_latipes_hsok.ASM223469v1.pep.all.fa.gz',
'oryMel1' => 'oryzias_melastigma/pep/Oryzias_melastigma.Om_v0.7.RACA.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panPan2' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'panTro5' => 'pan_troglodytes/pep/Pan_troglodytes.Pan_tro_3.0.pep.all.fa.gz',
'panPar1' => 'panthera_pardus/pep/Panthera_pardus.PanPar1.0.pep.all.fa.gz',
'panTig1' => 'panthera_tigris_altaica/pep/Panthera_tigris_altaica.PanTig1.0.pep.all.fa.gz',
'papAnu4' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'parKin1' => 'paramormyrops_kingsleyae/pep/Paramormyrops_kingsleyae.PKINGS_0.1.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'perMag1' => 'periophthalmus_magnuspinnatus/pep/Periophthalmus_magnuspinnatus.PM.fa.pep.all.fa.gz',
'perManBai1' => 'peromyscus_maniculatus_bairdii/pep/Peromyscus_maniculatus_bairdii.Pman_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'phaCin1' => 'phascolarctos_cinereus/pep/Phascolarctos_cinereus.phaCin_tgac_v2.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'poeLat1' => 'poecilia_latipinna/pep/Poecilia_latipinna.P_latipinna-1.0.pep.all.fa.gz',
'poeMex1' => 'poecilia_mexicana/pep/Poecilia_mexicana.P_mexicana-1.0.pep.all.fa.gz',
'poeRet1' => 'poecilia_reticulata/pep/Poecilia_reticulata.Guppy_female_1.0_MT.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'proCap1' => 'procavia_capensis/pep/Procavia_capensis.proCap1.pep.all.fa.gz',
'proCoq1' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'pteVam1' => 'pteropus_vampyrus/pep/Pteropus_vampyrus.pteVam1.pep.all.fa.gz',
'punNye1' => 'pundamilia_nyererei/pep/Pundamilia_nyererei.PunNye1.0.pep.all.fa.gz',
'pygNat1' => 'pygocentrus_nattereri/pep/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.pep.all.fa.gz',
'rn6' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'rhiBie1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'rhiRox1' => 'rhinopithecus_roxellana/pep/Rhinopithecus_roxellana.Rrox_v1.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sclFor1' => 'scleropages_formosus/pep/Scleropages_formosus.ASM162426v1.pep.all.fa.gz',
'scoMax1' => 'scophthalmus_maximus/pep/Scophthalmus_maximus.ASM318616v1.pep.all.fa.gz',
'serDum1' => 'seriola_dumerili/pep/Seriola_dumerili.Sdu_1.0.pep.all.fa.gz',
'serDor1' => 'seriola_lalandi_dorsalis/pep/Seriola_lalandi_dorsalis.Sedor1.pep.all.fa.gz',
'sorAra1' => 'sorex_araneus/pep/Sorex_araneus.COMMON_SHREW1.pep.all.fa.gz',
'sphPun1' => 'sphenodon_punctatus/pep/Sphenodon_punctatus.ASM311381v1.pep.all.fa.gz',
'stePar1' => 'stegastes_partitus/pep/Stegastes_partitus.Stegastes_partitus-1.0.2.pep.all.fa.gz',
'susScr11' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'taeGut1' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.taeGut3.2.4.pep.all.fa.gz',
'fr3' => 'takifugu_rubripes/pep/Takifugu_rubripes.FUGU5.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'tupBel1' => 'tupaia_belangeri/pep/Tupaia_belangeri.TREESHREW.pep.all.fa.gz',
'turTru1' => 'tursiops_truncatus/pep/Tursiops_truncatus.turTru1.pep.all.fa.gz',
'ursAme1' => 'ursus_americanus/pep/Ursus_americanus.ASM334442v1.pep.all.fa.gz',
'ursMar1' => 'ursus_maritimus/pep/Ursus_maritimus.UrsMar_1.0.pep.all.fa.gz',
'vicPac1' => 'vicugna_pacos/pep/Vicugna_pacos.vicPac1.pep.all.fa.gz',
'vulVul1' => 'vulpes_vulpes/pep/Vulpes_vulpes.VulVul2.2.pep.all.fa.gz',
'xenTro3' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.JGI_4.2.pep.all.fa.gz',
'xipCou1' => 'xiphophorus_couchianus/pep/Xiphophorus_couchianus.Xiphophorus_couchianus-4.0.1.pep.all.fa.gz',
'xipMac2' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.X_maculatus-5.0-male.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_95 = (
'acaPol1' => 'acanthochromis_polyacanthus_core_95_1',
'ailMel1' => 'ailuropoda_melanoleuca_core_95_1',
'ampCit1' => 'amphilophus_citrinellus_core_95_5',
'ampOce1' => 'amphiprion_ocellaris_core_95_1',
'ampPer1' => 'amphiprion_percula_core_95_1',
'anaTes1' => 'anabas_testudineus_core_95_11',
'anaPla1' => 'anas_platyrhynchos_core_95_1',
'anoCar2' => 'anolis_carolinensis_core_95_2',
'aotNan1' => 'aotus_nancymaae_core_95_1',
'astCal1' => 'astatotilapia_calliptera_core_95_12',
'astMex2' => 'astyanax_mexicanus_core_95_2',
'bosTau9' => 'bos_taurus_core_95_12',
'ce11' => 'caenorhabditis_elegans_core_95_260',
'calJac4' => 'callithrix_jacchus_core_95_1',
'canFam3' => 'canis_familiaris_core_95_31',
'canLupDin1' => 'canis_lupus_dingo_core_95_1',
'capHir2' => 'capra_hircus_core_95_1',
'tarSyr2' => 'carlito_syrichta_core_95_2',
'cavApe1' => 'cavia_aperea_core_95_10',
'cavPor3' => 'cavia_porcellus_core_95_4',
'cebCap1' => 'cebus_capucinus_core_95_1',
'cerAty1' => 'cercocebus_atys_core_95_1',
'chiLan1' => 'chinchilla_lanigera_core_95_1',
'chlSab2' => 'chlorocebus_sabaeus_core_95_1',
'choHof1' => 'choloepus_hoffmanni_core_95_1',
'chrPic2' => 'chrysemys_picta_bellii_core_95_303',
'ci3' => 'ciona_intestinalis_core_95_3',
'cioSav2' => 'ciona_savignyi_core_95_2',
'colAng1' => 'colobus_angolensis_palliatus_core_95_1',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd_core_95_1',
'criGriChoV1' => 'cricetulus_griseus_crigri_core_95_1',
'cynSem1' => 'cynoglossus_semilaevis_core_95_1',
'cypVar1' => 'cyprinodon_variegatus_core_95_1',
'danRer11' => 'danio_rerio_core_95_11',
'dasNov3' => 'dasypus_novemcinctus_core_95_3',
'dipOrd2' => 'dipodomys_ordii_core_95_2',
'dm6' => 'drosophila_melanogaster_core_95_6',
'echTel1' => 'echinops_telfairi_core_95_1',
'eptBur1' => 'eptatretus_burgeri_core_95_32',
'equAsi1' => 'equus_asinus_asinus_core_95_1',
'equCab3' => 'equus_caballus_core_95_3',
'eriEur1' => 'erinaceus_europaeus_core_95_1',
'esoLuc2' => 'esox_lucius_core_95_3',
'felCat9' => 'felis_catus_core_95_9',
'ficAlb0' => 'ficedula_albicollis_core_95_1',
'fukDam1' => 'fukomys_damarensis_core_95_1',
'funHet1' => 'fundulus_heteroclitus_core_95_302',
'gadMor1' => 'gadus_morhua_core_95_1',
'galGal6' => 'gallus_gallus_core_95_6',
'gamAff1' => 'gambusia_affinis_core_95_1',
'gasAcu1' => 'gasterosteus_aculeatus_core_95_1',
'gopAga1' => 'gopherus_agassizii_core_95_1',
'gorGor4' => 'gorilla_gorilla_core_95_4',
'hapBur1' => 'haplochromis_burtoni_core_95_1',
'hetGla2' => 'heterocephalus_glaber_female_core_95_1',
'hetGla1' => 'heterocephalus_glaber_male_core_95_1',
'hipCom1' => 'hippocampus_comes_core_95_1',
'hg38' => 'homo_sapiens_core_95_38',
'ictPun1' => 'ictalurus_punctatus_core_95_12',
'speTri2' => 'ictidomys_tridecemlineatus_core_95_3',
'jacJac1' => 'jaculus_jaculus_core_95_10',
'kryMar1' => 'kryptolebias_marmoratus_core_95_1',
'labBer1' => 'labrus_bergylta_core_95_1',
'latCha1' => 'latimeria_chalumnae_core_95_1',
'lepOcu1' => 'lepisosteus_oculatus_core_95_1',
'loxAfr3' => 'loxodonta_africana_core_95_3',
'macFas5' => 'macaca_fascicularis_core_95_5',
'rheMac8' => 'macaca_mulatta_core_95_801',
'macNem1' => 'macaca_nemestrina_core_95_1',
'manLeu1' => 'mandrillus_leucophaeus_core_95_1',
'masArm1' => 'mastacembelus_armatus_core_95_11',
'mayZeb2' => 'maylandia_zebra_core_95_2',
'melGal1' => 'meleagris_gallopavo_core_95_21',
'mesAur1' => 'mesocricetus_auratus_core_95_10',
'micMur3' => 'microcebus_murinus_core_95_3',
'micOch1' => 'microtus_ochrogaster_core_95_10',
'molMol1' => 'mola_mola_core_95_1',
'monDom5' => 'monodelphis_domestica_core_95_5',
'monAlb1' => 'monopterus_albus_core_95_1',
'GCA_900094665.1_CAROLI_EIJ_v1' => 'mus_caroli_core_95_11',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj_core_95_1',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj_core_95_1',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj_core_95_1',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj_core_95_1',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej_core_95_1',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj_core_95_1',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij_core_95_1',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj_core_95_1',
'mm10' => 'mus_musculus_core_95_38',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j_core_95_1',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj_core_95_1',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj_core_95_1',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj_core_95_1',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj_core_95_1',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj_core_95_1',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij_core_95_1',
'GCA_900095145.1_PAHARI_EIJ_v1' => 'mus_pahari_core_95_11',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_core_95_1',
'musFur1' => 'mustela_putorius_furo_core_95_1',
'myoLuc2' => 'myotis_lucifugus_core_95_2',
'nanGal1' => 'nannospalax_galili_core_95_10',
'neoBri1' => 'neolamprologus_brichardi_core_95_1',
'nomLeu3' => 'nomascus_leucogenys_core_95_3',
'macEug1' => 'notamacropus_eugenii_core_95_1',
'ochPri2' => 'ochotona_princeps_core_95_1',
'octDeg1' => 'octodon_degus_core_95_1',
'oreNil1' => 'oreochromis_niloticus_core_95_1',
'ornAna1' => 'ornithorhynchus_anatinus_core_95_1',
'ornAna2' => 'ornithorhynchus_anatinus_core_95_1',
'oryCun2' => 'oryctolagus_cuniculus_core_95_2',
'oryLat4' => 'oryzias_latipes_core_95_1',
'oryLat5' => 'oryzias_latipes_hni_core_95_1',
'oryLat6' => 'oryzias_latipes_hsok_core_95_1',
'oryMel1' => 'oryzias_melastigma_core_95_07',
'otoGar3' => 'otolemur_garnettii_core_95_3',
'oviAri3' => 'ovis_aries_core_95_31',
'panPan2' => 'pan_paniscus_core_95_1',
'panTro5' => 'pan_troglodytes_core_95_3',
'panPar1' => 'panthera_pardus_core_95_1',
'panTig1' => 'panthera_tigris_altaica_core_95_1',
'papAnu4' => 'papio_anubis_core_95_3',
'parKin1' => 'paramormyrops_kingsleyae_core_95_1',
'pelSin1' => 'pelodiscus_sinensis_core_95_1',
'perMag1' => 'periophthalmus_magnuspinnatus_core_95_1',
'perManBai1' => 'peromyscus_maniculatus_bairdii_core_95_10',
'petMar2' => 'petromyzon_marinus_core_95_7',
'phaCin1' => 'phascolarctos_cinereus_core_95_2',
'poeFor1' => 'poecilia_formosa_core_95_512',
'poeLat1' => 'poecilia_latipinna_core_95_1',
'poeMex1' => 'poecilia_mexicana_core_95_1',
'poeRet1' => 'poecilia_reticulata_core_95_1',
'ponAbe2' => 'pongo_abelii_core_95_1',
'proCap1' => 'procavia_capensis_core_95_1',
'proCoq1' => 'propithecus_coquereli_core_95_1',
'pteVam1' => 'pteropus_vampyrus_core_95_1',
'punNye1' => 'pundamilia_nyererei_core_95_1',
'pygNat1' => 'pygocentrus_nattereri_core_95_102',
'rn6' => 'rattus_norvegicus_core_95_6',
'rhiBie1' => 'rhinopithecus_bieti_core_95_1',
'rhiRox1' => 'rhinopithecus_roxellana_core_95_1',
'sacCer3' => 'saccharomyces_cerevisiae_core_95_4',
'saiBol1' => 'saimiri_boliviensis_boliviensis_core_95_1',
'sarHar1' => 'sarcophilus_harrisii_core_95_7',
'sclFor1' => 'scleropages_formosus_core_95_1',
'scoMax1' => 'scophthalmus_maximus_core_95_1',
'serDum1' => 'seriola_dumerili_core_95_1',
'serDor1' => 'seriola_lalandi_dorsalis_core_95_1',
'sorAra1' => 'sorex_araneus_core_95_1',
'sphPun1' => 'sphenodon_punctatus_core_95_1',
'stePar1' => 'stegastes_partitus_core_95_1',
'susScr11' => 'sus_scrofa_core_95_111',
'taeGut1' => 'taeniopygia_guttata_core_95_1',
'fr3' => 'takifugu_rubripes_core_95_5',
'tetNig2' => 'tetraodon_nigroviridis_core_95_8',
'tupBel1' => 'tupaia_belangeri_core_95_1',
'turTru1' => 'tursiops_truncatus_core_95_1',
'ursAme1' => 'ursus_americanus_core_95_1',
'ursMar1' => 'ursus_maritimus_core_95_1',
'vicPac1' => 'vicugna_pacos_core_95_1',
'vulVul1' => 'vulpes_vulpes_core_95_22',
'xenTro3' => 'xenopus_tropicalis_core_95_42',
'xipCou1' => 'xiphophorus_couchianus_core_95_401',
'xipMac2' => 'xiphophorus_maculatus_core_95_5',
);

my %ensGeneGtfFileNames_99 = (
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/Acanthochromis_polyacanthus.ASM210954v1.99.gtf.gz',
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.99.gtf.gz',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/Amphiprion_ocellaris.AmpOce1.0.99.gtf.gz',
'GCF_900324465.1_fAnaTes1.1' => 'anabas_testudineus/Anabas_testudineus.fAnaTes1.1.99.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.99.gtf.gz',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.99.gtf.gz',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi/Apteryx_rowi.aptRow1.99.gtf.gz',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera/Astatotilapia_calliptera.fAstCal1.2.99.gtf.gz',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/Astyanax_mexicanus.Astyanax_mexicanus-2.0.99.gtf.gz',
'astMex1' => 'astyanax_mexicanus_pachon/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.99.gtf.gz',
'GCF_003259725.1_athCun1' => 'athene_cunicularia/Athene_cunicularia.athCun1.99.gtf.gz',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens/Betta_splendens.fBetSpl5.2.99.gtf.gz',
'bisBis1' => 'bison_bison_bison/Bison_bison_bison.Bison_UMD1.0.99.gtf.gz',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid/Bos_indicus_hybrid.UOA_Brahman_1.99.gtf.gz',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus/Bos_mutus.BosGru_v2.0.99.gtf.gz',
'bosTau9' => 'bos_taurus/Bos_taurus.ARS-UCD1.2.99.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.99.gtf.gz',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax/Calidris_pugnax.ASM143184v1.99.gtf.gz',
'calMil1' => 'callorhinchus_milii/Callorhinchus_milii.Callorhinchus_milii-6.1.3.99.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.99.gtf.gz',
'GCF_000002285.3_CanFam3.1' => 'canis_familiaris/Canis_familiaris.CanFam3.1.99.gtf.gz',
'GCF_001704415.1_ARS1' => 'capra_hircus/Capra_hircus.ARS1.99.gtf.gz',
'tarSyr2' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.99.gtf.gz',
'casCan1' => 'castor_canadensis/Castor_canadensis.C.can_genome_v1.0.99.gtf.gz',
'cavApe1' => 'cavia_aperea/Cavia_aperea.CavAp1.0.99.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.99.gtf.gz',
'cebCap1' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.99.gtf.gz',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.99.gtf.gz',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.99.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.99.gtf.gz',
'chrPic2' => 'chrysemys_picta_bellii/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.99.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.99.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.99.gtf.gz',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus/Clupea_harengus.Ch_v2.0.2.99.gtf.gz',
'colAng1' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.99.gtf.gz',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio/Cottoperca_gobio.fCotGob3.1.99.gtf.gz',
'cotJap2' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.99.gtf.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.99.gtf.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.99.gtf.gz',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/Cricetulus_griseus_picr.CriGri-PICR.99.gtf.gz',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus/Crocodylus_porosus.CroPor_comp1.99.gtf.gz',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus/Cyanistes_caeruleus.cyaCae2.99.gtf.gz',
'cynSem1' => 'cynoglossus_semilaevis/Cynoglossus_semilaevis.Cse_v1.0.99.gtf.gz',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/Cyprinodon_variegatus.C_variegatus-1.0.99.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.99.gtf.gz',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/Denticeps_clupeoides.fDenClu1.1.99.gtf.gz',
'dipOrd2' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.99.gtf.gz',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae/Dromaius_novaehollandiae.droNov1.99.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.28.99.gtf.gz',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/Echeneis_naucrates.fEcheNa1.1.99.gtf.gz',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.99.gtf.gz',
'equCab3' => 'equus_caballus/Equus_caballus.EquCab3.0.99.gtf.gz',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus/Erpetoichthys_calabaricus.fErpCal1.1.99.gtf.gz',
'felCat9' => 'felis_catus/Felis_catus.Felis_catus_9.0.99.gtf.gz',
'fukDam1' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.99.gtf.gz',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.99.gtf.gz',
'galGal6' => 'gallus_gallus/Gallus_gallus.GRCg6a.99.gtf.gz',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla/Gorilla_gorilla.gorGor4.99.gtf.gz',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi/Gouania_willdenowi.fGouWil2.1.99.gtf.gz',
'hapBur1' => 'haplochromis_burtoni/Haplochromis_burtoni.AstBur1.0.99.gtf.gz',
'hetGla2' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.99.gtf.gz',
'hetGla1' => 'heterocephalus_glaber_male/Heterocephalus_glaber_male.HetGla_1.0.99.gtf.gz',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/Hippocampus_comes.H_comes_QL1_v1.99.gtf.gz',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/Ictalurus_punctatus.IpCoco_1.2.99.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.99.gtf.gz',
'jacJac1' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.99.gtf.gz',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/Kryptolebias_marmoratus.ASM164957v1.99.gtf.gz',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta/Labrus_bergylta.BallGen_V1.99.gtf.gz',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/Larimichthys_crocea.L_crocea_2.0.99.gtf.gz',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer/Lates_calcarifer.ASB_HGAPassembly_v1.99.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.99.gtf.gz',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/Lepidothrix_coronata.Lepidothrix_coronata-1.0.99.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.99.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.99.gtf.gz',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/Lynx_canadensis.mLynCan4_v1.p.99.gtf.gz',
'macFas5' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_5.0.99.gtf.gz',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_5.0.99.gtf.gz',
'rheMac10' => 'macaca_mulatta/Macaca_mulatta.Mmul_10.99.gtf.gz',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.99.gtf.gz',
'manLeu1' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.99.gtf.gz',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota/Marmota_marmota_marmota.marMar2.1.99.gtf.gz',
'GCF_900324485.1_fMasArm1.1' => 'mastacembelus_armatus/Mastacembelus_armatus.fMasArm1.1.99.gtf.gz',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra/Maylandia_zebra.M_zebra_UMD2a.99.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.Turkey_2.01.99.gtf.gz',
'melUnd1' => 'melopsittacus_undulatus/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.99.gtf.gz',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/Meriones_unguiculatus.MunDraft-v1.0.99.gtf.gz',
'mesAur1' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.99.gtf.gz',
'micMur3' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.99.gtf.gz',
'micOch1' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.99.gtf.gz',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica/Monodelphis_domestica.ASM229v1.99.gtf.gz',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus/Monopterus_albus.M_albus_1.0.99.gtf.gz',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli/Mus_caroli.CAROLI_EIJ_v1.1.99.gtf.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/Mus_musculus_129s1svimj.129S1_SvImJ_v1.99.gtf.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/Mus_musculus_aj.A_J_v1.99.gtf.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/Mus_musculus_akrj.AKR_J_v1.99.gtf.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/Mus_musculus_balbcj.BALB_cJ_v1.99.gtf.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/Mus_musculus_c3hhej.C3H_HeJ_v1.99.gtf.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.99.gtf.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/Mus_musculus_casteij.CAST_EiJ_v1.99.gtf.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/Mus_musculus_cbaj.CBA_J_v1.99.gtf.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/Mus_musculus_dba2j.DBA_2J_v1.99.gtf.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/Mus_musculus_fvbnj.FVB_NJ_v1.99.gtf.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/Mus_musculus_lpj.LP_J_v1.99.gtf.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.99.gtf.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.99.gtf.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/Mus_musculus_pwkphj.PWK_PhJ_v1.99.gtf.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/Mus_musculus_wsbeij.WSB_EiJ_v1.99.gtf.gz',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari/Mus_pahari.PAHARI_EIJ_v1.1.99.gtf.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/Mus_spretus.SPRET_EiJ_v1.99.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.99.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.99.gtf.gz',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/Myripristis_murdjan.fMyrMur1.1.99.gtf.gz',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.99.gtf.gz',
'nomLeu3' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu_3.0.99.gtf.gz',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/Notechis_scutatus.TS10Xv2-PRI.99.gtf.gz',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria/Nothoprocta_perdicaria.notPer1.99.gtf.gz',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris/Numida_meleagris.NumMel1.0.99.gtf.gz',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus/Octodon_degus.OctDeg1.0.99.gtf.gz',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus/Oreochromis_aureus.ASM587006v1.99.gtf.gz',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/Oreochromis_niloticus.O_niloticus_UMD_NMBU.99.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.99.gtf.gz',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes/Oryzias_latipes.ASM223467v1.99.gtf.gz',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/Oryzias_melastigma.Om_v0.7.RACA.99.gtf.gz',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.99.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.99.gtf.gz',
'panPan2' => 'pan_paniscus/Pan_paniscus.panpan1.1.99.gtf.gz',
'panTro5' => 'pan_troglodytes/Pan_troglodytes.Pan_tro_3.0.99.gtf.gz',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus/Panthera_pardus.PanPar1.0.99.gtf.gz',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/Panthera_tigris_altaica.PanTig1.0.99.gtf.gz',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis/Papio_anubis.Panu_3.0.99.gtf.gz',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga/Parambassis_ranga.fParRan2.1.99.gtf.gz',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/Paramormyrops_kingsleyae.PKINGS_0.1.99.gtf.gz',
'GCF_001522545.2_Parus_major1.1' => 'parus_major/Parus_major.Parus_major1.1.99.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.99.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.99.gtf.gz',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/Phascolarctos_cinereus.phaCin_unsw_v4.1.99.gtf.gz',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus/Phasianus_colchicus.ASM414374v1.99.gtf.gz',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon/Physeter_catodon.ASM283717v2.99.gtf.gz',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/Piliocolobus_tephrosceles.ASM277652v2.99.gtf.gz',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis/Podarcis_muralis.PodMur_1.0.99.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.99.gtf.gz',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/Poecilia_latipinna.P_latipinna-1.0.99.gtf.gz',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/Poecilia_mexicana.P_mexicana-1.0.99.gtf.gz',
'poeRet1' => 'poecilia_reticulata/Poecilia_reticulata.Guppy_female_1.0_MT.99.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.99.gtf.gz',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus/Prolemur_simus.Prosim_1.0.99.gtf.gz',
'proCoq1' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.99.gtf.gz',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/Pseudonaja_textilis.EBS10Xv2-PRI.99.gtf.gz',
'punNye1' => 'pundamilia_nyererei/Pundamilia_nyererei.PunNye1.0.99.gtf.gz',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.99.gtf.gz',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.99.gtf.gz',
'rhiBie1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.99.gtf.gz',
'rhiRox1' => 'rhinopithecus_roxellana/Rhinopithecus_roxellana.Rrox_v1.99.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.99.gtf.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.99.gtf.gz',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/Salarias_fasciatus.fSalaFa1.1.99.gtf.gz',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta/Salmo_trutta.fSalTru1.1.99.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.99.gtf.gz',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus/Scleropages_formosus.fSclFor1.1.99.gtf.gz',
'serCan1' => 'serinus_canaria/Serinus_canaria.SCA1.99.gtf.gz',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili/Seriola_dumerili.Sdu_1.0.99.gtf.gz',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/Seriola_lalandi_dorsalis.Sedor1.99.gtf.gz',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.99.gtf.gz',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.99.gtf.gz',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.99.gtf.gz',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata/Sparus_aurata.fSpaAur1.1.99.gtf.gz',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/Sphaeramia_orbicularis.fSphaOr1.1.99.gtf.gz',
'stePar1' => 'stegastes_partitus/Stegastes_partitus.Stegastes_partitus-1.0.2.99.gtf.gz',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/Strigops_habroptila.bStrHab1_v1.p.99.gtf.gz',
'strCam1' => 'struthio_camelus_australis/Struthio_camelus_australis.ASM69896v1.99.gtf.gz',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.99.gtf.gz',
'susScr11' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.99.gtf.gz',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata/Taeniopygia_guttata.bTaeGut1_v1.p.99.gtf.gz',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes/Takifugu_rubripes.fTakRub1.2.99.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.99.gtf.gz',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada/Theropithecus_gelada.Tgel_1.0.99.gtf.gz',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii/Urocitellus_parryii.ASM342692v1.99.gtf.gz',
'ursMar1' => 'ursus_maritimus/Ursus_maritimus.UrsMar_1.0.99.gtf.gz',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes/Vulpes_vulpes.VulVul2.2.99.gtf.gz',
'xenTro9' => 'xenopus_tropicalis/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.99.gtf.gz',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus/Xiphophorus_maculatus.X_maculatus-5.0-male.99.gtf.gz',
'zonAlb1' => 'zonotrichia_albicollis/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.99.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_99 = (
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/pep/Acanthochromis_polyacanthus.ASM210954v1.pep.all.fa.gz',
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/pep/Amphiprion_ocellaris.AmpOce1.0.pep.all.fa.gz',
'GCF_900324465.1_fAnaTes1.1' => 'anabas_testudineus/pep/Anabas_testudineus.fAnaTes1.1.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi/pep/Apteryx_rowi.aptRow1.pep.all.fa.gz',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera/pep/Astatotilapia_calliptera.fAstCal1.2.pep.all.fa.gz',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.Astyanax_mexicanus-2.0.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus_pachon/pep/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.pep.all.fa.gz',
'GCF_003259725.1_athCun1' => 'athene_cunicularia/pep/Athene_cunicularia.athCun1.pep.all.fa.gz',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens/pep/Betta_splendens.fBetSpl5.2.pep.all.fa.gz',
'bisBis1' => 'bison_bison_bison/pep/Bison_bison_bison.Bison_UMD1.0.pep.all.fa.gz',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid/pep/Bos_indicus_hybrid.UOA_Brahman_1.pep.all.fa.gz',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus/pep/Bos_mutus.BosGru_v2.0.pep.all.fa.gz',
'bosTau9' => 'bos_taurus/pep/Bos_taurus.ARS-UCD1.2.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax/pep/Calidris_pugnax.ASM143184v1.pep.all.fa.gz',
'calMil1' => 'callorhinchus_milii/pep/Callorhinchus_milii.Callorhinchus_milii-6.1.3.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'GCF_000002285.3_CanFam3.1' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'GCF_001704415.1_ARS1' => 'capra_hircus/pep/Capra_hircus.ARS1.pep.all.fa.gz',
'tarSyr2' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'casCan1' => 'castor_canadensis/pep/Castor_canadensis.C.can_genome_v1.0.pep.all.fa.gz',
'cavApe1' => 'cavia_aperea/pep/Cavia_aperea.CavAp1.0.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'cebCap1' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'chrPic2' => 'chrysemys_picta_bellii/pep/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus/pep/Clupea_harengus.Ch_v2.0.2.pep.all.fa.gz',
'colAng1' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio/pep/Cottoperca_gobio.fCotGob3.1.pep.all.fa.gz',
'cotJap2' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/pep/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.pep.all.fa.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/pep/Cricetulus_griseus_picr.CriGri-PICR.pep.all.fa.gz',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus/pep/Crocodylus_porosus.CroPor_comp1.pep.all.fa.gz',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus/pep/Cyanistes_caeruleus.cyaCae2.pep.all.fa.gz',
'cynSem1' => 'cynoglossus_semilaevis/pep/Cynoglossus_semilaevis.Cse_v1.0.pep.all.fa.gz',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/pep/Cyprinodon_variegatus.C_variegatus-1.0.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/pep/Denticeps_clupeoides.fDenClu1.1.pep.all.fa.gz',
'dipOrd2' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae/pep/Dromaius_novaehollandiae.droNov1.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.28.pep.all.fa.gz',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/pep/Echeneis_naucrates.fEcheNa1.1.pep.all.fa.gz',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/pep/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.pep.all.fa.gz',
'equCab3' => 'equus_caballus/pep/Equus_caballus.EquCab3.0.pep.all.fa.gz',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus/pep/Erpetoichthys_calabaricus.fErpCal1.1.pep.all.fa.gz',
'felCat9' => 'felis_catus/pep/Felis_catus.Felis_catus_9.0.pep.all.fa.gz',
'fukDam1' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/pep/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.pep.all.fa.gz',
'galGal6' => 'gallus_gallus/pep/Gallus_gallus.GRCg6a.pep.all.fa.gz',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor4.pep.all.fa.gz',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi/pep/Gouania_willdenowi.fGouWil2.1.pep.all.fa.gz',
'hapBur1' => 'haplochromis_burtoni/pep/Haplochromis_burtoni.AstBur1.0.pep.all.fa.gz',
'hetGla2' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'hetGla1' => 'heterocephalus_glaber_male/pep/Heterocephalus_glaber_male.HetGla_1.0.pep.all.fa.gz',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/pep/Hippocampus_comes.H_comes_QL1_v1.pep.all.fa.gz',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/pep/Ictalurus_punctatus.IpCoco_1.2.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'jacJac1' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/pep/Kryptolebias_marmoratus.ASM164957v1.pep.all.fa.gz',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta/pep/Labrus_bergylta.BallGen_V1.pep.all.fa.gz',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/pep/Larimichthys_crocea.L_crocea_2.0.pep.all.fa.gz',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer/pep/Lates_calcarifer.ASB_HGAPassembly_v1.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/pep/Lepidothrix_coronata.Lepidothrix_coronata-1.0.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/pep/Lynx_canadensis.mLynCan4_v1.p.pep.all.fa.gz',
'macFas5' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_5.0.pep.all.fa.gz',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_5.0.pep.all.fa.gz',
'rheMac10' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_10.pep.all.fa.gz',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'manLeu1' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota/pep/Marmota_marmota_marmota.marMar2.1.pep.all.fa.gz',
'GCF_900324485.1_fMasArm1.1' => 'mastacembelus_armatus/pep/Mastacembelus_armatus.fMasArm1.1.pep.all.fa.gz',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra/pep/Maylandia_zebra.M_zebra_UMD2a.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.Turkey_2.01.pep.all.fa.gz',
'melUnd1' => 'melopsittacus_undulatus/pep/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.pep.all.fa.gz',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/pep/Meriones_unguiculatus.MunDraft-v1.0.pep.all.fa.gz',
'mesAur1' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'micMur3' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'micOch1' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica/pep/Monodelphis_domestica.ASM229v1.pep.all.fa.gz',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus/pep/Monopterus_albus.M_albus_1.0.pep.all.fa.gz',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli/pep/Mus_caroli.CAROLI_EIJ_v1.1.pep.all.fa.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/pep/Mus_musculus_129s1svimj.129S1_SvImJ_v1.pep.all.fa.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/pep/Mus_musculus_aj.A_J_v1.pep.all.fa.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/pep/Mus_musculus_akrj.AKR_J_v1.pep.all.fa.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_balbcj.BALB_cJ_v1.pep.all.fa.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/pep/Mus_musculus_c3hhej.C3H_HeJ_v1.pep.all.fa.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/pep/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.pep.all.fa.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/pep/Mus_musculus_casteij.CAST_EiJ_v1.pep.all.fa.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_cbaj.CBA_J_v1.pep.all.fa.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/pep/Mus_musculus_dba2j.DBA_2J_v1.pep.all.fa.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/pep/Mus_musculus_fvbnj.FVB_NJ_v1.pep.all.fa.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/pep/Mus_musculus_lpj.LP_J_v1.pep.all.fa.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/pep/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.pep.all.fa.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/pep/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.pep.all.fa.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/pep/Mus_musculus_pwkphj.PWK_PhJ_v1.pep.all.fa.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/pep/Mus_musculus_wsbeij.WSB_EiJ_v1.pep.all.fa.gz',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari/pep/Mus_pahari.PAHARI_EIJ_v1.1.pep.all.fa.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/pep/Mus_spretus.SPRET_EiJ_v1.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/pep/Myripristis_murdjan.fMyrMur1.1.pep.all.fa.gz',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'nomLeu3' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu_3.0.pep.all.fa.gz',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/pep/Notechis_scutatus.TS10Xv2-PRI.pep.all.fa.gz',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria/pep/Nothoprocta_perdicaria.notPer1.pep.all.fa.gz',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris/pep/Numida_meleagris.NumMel1.0.pep.all.fa.gz',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus/pep/Oreochromis_aureus.ASM587006v1.pep.all.fa.gz',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.O_niloticus_UMD_NMBU.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes/pep/Oryzias_latipes.ASM223467v1.pep.all.fa.gz',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/pep/Oryzias_melastigma.Om_v0.7.RACA.pep.all.fa.gz',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'panPan2' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'panTro5' => 'pan_troglodytes/pep/Pan_troglodytes.Pan_tro_3.0.pep.all.fa.gz',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus/pep/Panthera_pardus.PanPar1.0.pep.all.fa.gz',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/pep/Panthera_tigris_altaica.PanTig1.0.pep.all.fa.gz',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga/pep/Parambassis_ranga.fParRan2.1.pep.all.fa.gz',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/pep/Paramormyrops_kingsleyae.PKINGS_0.1.pep.all.fa.gz',
'GCF_001522545.2_Parus_major1.1' => 'parus_major/pep/Parus_major.Parus_major1.1.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/pep/Phascolarctos_cinereus.phaCin_unsw_v4.1.pep.all.fa.gz',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus/pep/Phasianus_colchicus.ASM414374v1.pep.all.fa.gz',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon/pep/Physeter_catodon.ASM283717v2.pep.all.fa.gz',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/pep/Piliocolobus_tephrosceles.ASM277652v2.pep.all.fa.gz',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis/pep/Podarcis_muralis.PodMur_1.0.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/pep/Poecilia_latipinna.P_latipinna-1.0.pep.all.fa.gz',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/pep/Poecilia_mexicana.P_mexicana-1.0.pep.all.fa.gz',
'poeRet1' => 'poecilia_reticulata/pep/Poecilia_reticulata.Guppy_female_1.0_MT.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus/pep/Prolemur_simus.Prosim_1.0.pep.all.fa.gz',
'proCoq1' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/pep/Pseudonaja_textilis.EBS10Xv2-PRI.pep.all.fa.gz',
'punNye1' => 'pundamilia_nyererei/pep/Pundamilia_nyererei.PunNye1.0.pep.all.fa.gz',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/pep/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.pep.all.fa.gz',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/pep/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.pep.all.fa.gz',
'rhiBie1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'rhiRox1' => 'rhinopithecus_roxellana/pep/Rhinopithecus_roxellana.Rrox_v1.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/pep/Salarias_fasciatus.fSalaFa1.1.pep.all.fa.gz',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta/pep/Salmo_trutta.fSalTru1.1.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus/pep/Scleropages_formosus.fSclFor1.1.pep.all.fa.gz',
'serCan1' => 'serinus_canaria/pep/Serinus_canaria.SCA1.pep.all.fa.gz',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili/pep/Seriola_dumerili.Sdu_1.0.pep.all.fa.gz',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/pep/Seriola_lalandi_dorsalis.Sedor1.pep.all.fa.gz',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/pep/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.pep.all.fa.gz',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/pep/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.pep.all.fa.gz',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/pep/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.pep.all.fa.gz',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata/pep/Sparus_aurata.fSpaAur1.1.pep.all.fa.gz',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/pep/Sphaeramia_orbicularis.fSphaOr1.1.pep.all.fa.gz',
'stePar1' => 'stegastes_partitus/pep/Stegastes_partitus.Stegastes_partitus-1.0.2.pep.all.fa.gz',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/pep/Strigops_habroptila.bStrHab1_v1.p.pep.all.fa.gz',
'strCam1' => 'struthio_camelus_australis/pep/Struthio_camelus_australis.ASM69896v1.pep.all.fa.gz',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/pep/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.pep.all.fa.gz',
'susScr11' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.bTaeGut1_v1.p.pep.all.fa.gz',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes/pep/Takifugu_rubripes.fTakRub1.2.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada/pep/Theropithecus_gelada.Tgel_1.0.pep.all.fa.gz',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii/pep/Urocitellus_parryii.ASM342692v1.pep.all.fa.gz',
'ursMar1' => 'ursus_maritimus/pep/Ursus_maritimus.UrsMar_1.0.pep.all.fa.gz',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes/pep/Vulpes_vulpes.VulVul2.2.pep.all.fa.gz',
'xenTro9' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.pep.all.fa.gz',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.X_maculatus-5.0-male.pep.all.fa.gz',
'zonAlb1' => 'zonotrichia_albicollis/pep/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_99 = (
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus_core_99_1',
'ailMel1' => 'ailuropoda_melanoleuca_core_99_1',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris_core_99_1',
'GCF_900324465.1_fAnaTes1.1' => 'anabas_testudineus_core_99_11',
'anoCar2' => 'anolis_carolinensis_core_99_2',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae_core_99_1',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi_core_99_1',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera_core_99_12',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus_core_99_2',
'astMex1' => 'astyanax_mexicanus_pachon_core_99_102',
'GCF_003259725.1_athCun1' => 'athene_cunicularia_core_99_1',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens_core_99_52',
'bisBis1' => 'bison_bison_bison_core_99_1',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid_core_99_1',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus_core_99_2',
'bosTau9' => 'bos_taurus_core_99_12',
'ce11' => 'caenorhabditis_elegans_core_99_269',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax_core_99_1',
'calMil1' => 'callorhinchus_milii_core_99_613',
'canFam3' => 'canis_familiaris_core_99_31',
'GCF_000002285.3_CanFam3.1' => 'canis_familiaris_core_99_31',
'GCF_001704415.1_ARS1' => 'capra_hircus_core_99_1',
'tarSyr2' => 'carlito_syrichta_core_99_2',
'casCan1' => 'castor_canadensis_core_99_1',
'cavApe1' => 'cavia_aperea_core_99_10',
'cavPor3' => 'cavia_porcellus_core_99_4',
'cebCap1' => 'cebus_capucinus_core_99_1',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys_core_99_1',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera_core_99_1',
'chlSab2' => 'chlorocebus_sabaeus_core_99_1',
'chrPic2' => 'chrysemys_picta_bellii_core_99_303',
'ci3' => 'ciona_intestinalis_core_99_3',
'cioSav2' => 'ciona_savignyi_core_99_2',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus_core_99_202',
'colAng1' => 'colobus_angolensis_palliatus_core_99_1',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio_core_99_31',
'cotJap2' => 'coturnix_japonica_core_99_2',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd_core_99_1',
'criGriChoV1' => 'cricetulus_griseus_crigri_core_99_1',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr_core_99_1',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus_core_99_1',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus_core_99_2',
'cynSem1' => 'cynoglossus_semilaevis_core_99_1',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus_core_99_1',
'dasNov3' => 'dasypus_novemcinctus_core_99_3',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides_core_99_11',
'dipOrd2' => 'dipodomys_ordii_core_99_2',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae_core_99_1',
'dm6' => 'drosophila_melanogaster_core_99_8',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates_core_99_11',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus_core_99_2',
'equCab3' => 'equus_caballus_core_99_3',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus_core_99_11',
'felCat9' => 'felis_catus_core_99_9',
'fukDam1' => 'fukomys_damarensis_core_99_1',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus_core_99_302',
'galGal6' => 'gallus_gallus_core_99_6',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla_core_99_4',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi_core_99_21',
'hapBur1' => 'haplochromis_burtoni_core_99_1',
'hetGla2' => 'heterocephalus_glaber_female_core_99_1',
'hetGla1' => 'heterocephalus_glaber_male_core_99_1',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes_core_99_1',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus_core_99_12',
'speTri2' => 'ictidomys_tridecemlineatus_core_99_3',
'jacJac1' => 'jaculus_jaculus_core_99_10',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus_core_99_1',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta_core_99_1',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea_core_99_20',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer_core_99_1',
'latCha1' => 'latimeria_chalumnae_core_99_1',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata_core_99_1',
'lepOcu1' => 'lepisosteus_oculatus_core_99_1',
'loxAfr3' => 'loxodonta_africana_core_99_3',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis_core_99_41',
'macFas5' => 'macaca_fascicularis_core_99_5',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis_core_99_5',
'rheMac10' => 'macaca_mulatta_core_99_10',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina_core_99_1',
'manLeu1' => 'mandrillus_leucophaeus_core_99_1',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota_core_99_21',
'GCF_900324485.1_fMasArm1.1' => 'mastacembelus_armatus_core_99_11',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra_core_99_2',
'melGal1' => 'meleagris_gallopavo_core_99_21',
'melUnd1' => 'melopsittacus_undulatus_core_99_63',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus_core_99_1',
'mesAur1' => 'mesocricetus_auratus_core_99_10',
'micMur3' => 'microcebus_murinus_core_99_3',
'micOch1' => 'microtus_ochrogaster_core_99_10',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica_core_99_1',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus_core_99_1',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli_core_99_11',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj_core_99_1',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj_core_99_1',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj_core_99_1',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj_core_99_1',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej_core_99_1',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj_core_99_1',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij_core_99_1',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj_core_99_1',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j_core_99_1',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj_core_99_1',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj_core_99_1',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj_core_99_1',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj_core_99_1',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj_core_99_1',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij_core_99_1',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari_core_99_11',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_core_99_1',
'musFur1' => 'mustela_putorius_furo_core_99_1',
'myoLuc2' => 'myotis_lucifugus_core_99_2',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan_core_99_11',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili_core_99_10',
'nomLeu3' => 'nomascus_leucogenys_core_99_3',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus_core_99_2',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria_core_99_1',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris_core_99_1',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus_core_99_1',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus_core_99_1',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus_core_99_3',
'oryCun2' => 'oryctolagus_cuniculus_core_99_2',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes_core_99_1',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma_core_99_07',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii_core_99_3',
'oviAri3' => 'ovis_aries_core_99_31',
'panPan2' => 'pan_paniscus_core_99_1',
'panTro5' => 'pan_troglodytes_core_99_3',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus_core_99_1',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica_core_99_1',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis_core_99_3',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga_core_99_21',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae_core_99_1',
'GCF_001522545.2_Parus_major1.1' => 'parus_major_core_99_1',
'pelSin1' => 'pelodiscus_sinensis_core_99_1',
'petMar2' => 'petromyzon_marinus_core_99_7',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus_core_99_41',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus_core_99_1',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon_core_99_2',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles_core_99_2',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis_core_99_1',
'poeFor1' => 'poecilia_formosa_core_99_512',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna_core_99_1',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana_core_99_1',
'poeRet1' => 'poecilia_reticulata_core_99_1',
'ponAbe2' => 'pongo_abelii_core_99_1',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus_core_99_1',
'proCoq1' => 'propithecus_coquereli_core_99_1',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis_core_99_2',
'punNye1' => 'pundamilia_nyererei_core_99_1',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri_core_99_102',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum_core_99_1',
'rhiBie1' => 'rhinopithecus_bieti_core_99_1',
'rhiRox1' => 'rhinopithecus_roxellana_core_99_1',
'sacCer3' => 'saccharomyces_cerevisiae_core_99_4',
'saiBol1' => 'saimiri_boliviensis_boliviensis_core_99_1',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus_core_99_11',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta_core_99_11',
'sarHar1' => 'sarcophilus_harrisii_core_99_7',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus_core_99_11',
'serCan1' => 'serinus_canaria_core_99_12',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili_core_99_1',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis_core_99_1',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis_core_99_11',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami_core_99_11',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous_core_99_11',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata_core_99_11',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis_core_99_11',
'stePar1' => 'stegastes_partitus_core_99_1',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila_core_99_11',
'strCam1' => 'struthio_camelus_australis_core_99_1',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta_core_99_1',
'susScr11' => 'sus_scrofa_core_99_111',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata_core_99_12',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes_core_99_12',
'tetNig2' => 'tetraodon_nigroviridis_core_99_8',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada_core_99_1',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii_core_99_1',
'ursMar1' => 'ursus_maritimus_core_99_1',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes_core_99_22',
'xenTro9' => 'xenopus_tropicalis_core_99_91',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus_core_99_5',
'zonAlb1' => 'zonotrichia_albicollis_core_99_101',
);

my %ensGeneGtfFileNames_101 = (
'GCA_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/Acanthochromis_polyacanthus.ASM210954v1.101.gtf.gz',
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/Acanthochromis_polyacanthus.ASM210954v1.101.gtf.gz',
'GCA_004320145.1_Accipiter_nisus_ver1.0' => 'accipiter_nisus/Accipiter_nisus.Accipiter_nisus_ver1.0.101.gtf.gz',
'GCA_000004335.1_AilMel_1.0' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.101.gtf.gz',
'GCF_000004335.2_AilMel_1.0' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.101.gtf.gz',
'ailMel1' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.101.gtf.gz',
'GCA_003947215.1_ASM394721v1' => 'amazona_collaria/Amazona_collaria.ASM394721v1.101.gtf.gz',
'GCA_000751415.1_Midas_v5' => 'amphilophus_citrinellus/Amphilophus_citrinellus.Midas_v5.101.gtf.gz',
'GCA_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/Amphiprion_ocellaris.AmpOce1.0.101.gtf.gz',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/Amphiprion_ocellaris.AmpOce1.0.101.gtf.gz',
'GCA_003047355.1_Nemo_v1' => 'amphiprion_percula/Amphiprion_percula.Nemo_v1.101.gtf.gz',
'GCA_900324465.1_fAnaTes1.1' => 'anabas_testudineus/Anabas_testudineus.fAnaTes1.1.101.gtf.gz',
'GCF_900324465.1_fAnaTes1.1' => 'anabas_testudineus/Anabas_testudineus.fAnaTes1.1.101.gtf.gz',
'GCA_008746955.1_ASM874695v1' => 'anas_platyrhynchos/Anas_platyrhynchos.ASM874695v1.101.gtf.gz',
'GCA_002743455.1_CAU_duck1.0' => 'anas_platyrhynchos_platyrhynchos/Anas_platyrhynchos_platyrhynchos.CAU_duck1.0.101.gtf.gz',
'GCA_002224875.1_ASM222487v1' => 'anas_zonorhyncha/Anas_zonorhyncha.ASM222487v1.101.gtf.gz',
'GCA_000090745.2_AnoCar2.0' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.101.gtf.gz',
'GCF_000090745.1_AnoCar2.0' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.101.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.101.gtf.gz',
'GCA_002592135.1_ASM259213v1' => 'anser_brachyrhynchus/Anser_brachyrhynchus.ASM259213v1.101.gtf.gz',
'GCA_002166845.1_GooseV1.0' => 'anser_cygnoides/Anser_cygnoides.GooseV1.0.101.gtf.gz',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.101.gtf.gz',
'GCF_000952055.2_Anan_2.0' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.101.gtf.gz',
'aotNan1' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.101.gtf.gz',
'GCA_003342985.1_aptHaa1' => 'apteryx_haastii/Apteryx_haastii.aptHaa1.101.gtf.gz',
'GCA_003342965.1_aptOwe1' => 'apteryx_owenii/Apteryx_owenii.aptOwe1.101.gtf.gz',
'GCA_003343035.1_aptRow1' => 'apteryx_rowi/Apteryx_rowi.aptRow1.101.gtf.gz',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi/Apteryx_rowi.aptRow1.101.gtf.gz',
'GCA_900496995.2_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/Aquila_chrysaetos_chrysaetos.bAquChr1.2.101.gtf.gz',
'GCF_900496995.1_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/Aquila_chrysaetos_chrysaetos.bAquChr1.2.101.gtf.gz',
'GCA_900246225.3_fAstCal1.2' => 'astatotilapia_calliptera/Astatotilapia_calliptera.fAstCal1.2.101.gtf.gz',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera/Astatotilapia_calliptera.fAstCal1.2.101.gtf.gz',
'GCA_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/Astyanax_mexicanus.Astyanax_mexicanus-2.0.101.gtf.gz',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/Astyanax_mexicanus.Astyanax_mexicanus-2.0.101.gtf.gz',
'GCA_004802775.1_Astyanax_mexicanus-1.0.2' => 'astyanax_mexicanus_pachon/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.101.gtf.gz',
'astMex1' => 'astyanax_mexicanus_pachon/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.101.gtf.gz',
'GCA_003259725.1_athCun1' => 'athene_cunicularia/Athene_cunicularia.athCun1.101.gtf.gz',
'GCF_003259725.1_athCun1' => 'athene_cunicularia/Athene_cunicularia.athCun1.101.gtf.gz',
'GCA_900634795.2_fBetSpl5.2' => 'betta_splendens/Betta_splendens.fBetSpl5.2.101.gtf.gz',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens/Betta_splendens.fBetSpl5.2.101.gtf.gz',
'GCA_000754665.1_Bison_UMD1.0' => 'bison_bison_bison/Bison_bison_bison.Bison_UMD1.0.101.gtf.gz',
'bisBis1' => 'bison_bison_bison/Bison_bison_bison.Bison_UMD1.0.101.gtf.gz',
'GCA_005887515.1_LU_Bosgru_v3.0' => 'bos_grunniens/Bos_grunniens.LU_Bosgru_v3.0.101.gtf.gz',
'GCA_003369695.2_UOA_Brahman_1' => 'bos_indicus_hybrid/Bos_indicus_hybrid.UOA_Brahman_1.101.gtf.gz',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid/Bos_indicus_hybrid.UOA_Brahman_1.101.gtf.gz',
'GCA_000298355.1_BosGru_v2.0' => 'bos_mutus/Bos_mutus.BosGru_v2.0.101.gtf.gz',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus/Bos_mutus.BosGru_v2.0.101.gtf.gz',
'bosMut1' => 'bos_mutus/Bos_mutus.BosGru_v2.0.101.gtf.gz',
'GCA_002263795.2_ARS-UCD1.2' => 'bos_taurus/Bos_taurus.ARS-UCD1.2.101.gtf.gz',
'GCF_002263795.1_ARS-UCD1.2' => 'bos_taurus/Bos_taurus.ARS-UCD1.2.101.gtf.gz',
'bosTau9' => 'bos_taurus/Bos_taurus.ARS-UCD1.2.101.gtf.gz',
'GCA_003369685.2_UOA_Angus_1' => 'bos_taurus_hybrid/Bos_taurus_hybrid.UOA_Angus_1.101.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.101.gtf.gz',
'GCA_001431845.1_ASM143184v1' => 'calidris_pugnax/Calidris_pugnax.ASM143184v1.101.gtf.gz',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax/Calidris_pugnax.ASM143184v1.101.gtf.gz',
'GCA_003697955.1_ASM369795v1' => 'calidris_pygmaea/Calidris_pygmaea.ASM369795v1.101.gtf.gz',
'GCA_002754865.1_ASM275486v1' => 'callithrix_jacchus/Callithrix_jacchus.ASM275486v1.101.gtf.gz',
'GCA_000165045.2_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/Callorhinchus_milii.Callorhinchus_milii-6.1.3.101.gtf.gz',
'GCF_000165045.1_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/Callorhinchus_milii.Callorhinchus_milii-6.1.3.101.gtf.gz',
'calMil1' => 'callorhinchus_milii/Callorhinchus_milii.Callorhinchus_milii-6.1.3.101.gtf.gz',
'GCA_901933205.1_STF_HiC' => 'camarhynchus_parvulus/Camarhynchus_parvulus.STF_HiC.101.gtf.gz',
'GCF_901933205.1_STF_HiC' => 'camarhynchus_parvulus/Camarhynchus_parvulus.STF_HiC.101.gtf.gz',
'GCA_000803125.2_CamDro2' => 'camelus_dromedarius/Camelus_dromedarius.CamDro2.101.gtf.gz',
'GCA_000002285.2_CanFam3.1' => 'canis_familiaris/Canis_familiaris.CanFam3.1.101.gtf.gz',
'GCF_000002285.3_CanFam3.1' => 'canis_familiaris/Canis_familiaris.CanFam3.1.101.gtf.gz',
'canFam3' => 'canis_familiaris/Canis_familiaris.CanFam3.1.101.gtf.gz',
'GCA_003254725.1_ASM325472v1' => 'canis_lupus_dingo/Canis_lupus_dingo.ASM325472v1.101.gtf.gz',
'GCF_003254725.1_ASM325472v1' => 'canis_lupus_dingo/Canis_lupus_dingo.ASM325472v1.101.gtf.gz',
'GCF_000002285.3_CanFam3.1' => 'canis_lupus_familiaris/Canis_lupus_familiaris.CanFam3.1.101.gtf.gz',
'canFam3' => 'canis_lupus_familiaris/Canis_lupus_familiaris.CanFam3.1.101.gtf.gz',
'GCA_004886185.1_Basenji_breed-1.1' => 'canis_lupus_familiarisbasenji/Canis_lupus_familiarisbasenji.Basenji_breed-1.1.101.gtf.gz',
'GCA_005444595.1_UMICH_Zoey_3.1' => 'canis_lupus_familiarisgreatdane/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.101.gtf.gz',
'canFam5' => 'canis_lupus_familiarisgreatdane/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.101.gtf.gz',
'GCA_001704415.1_ARS1' => 'capra_hircus/Capra_hircus.ARS1.101.gtf.gz',
'GCF_001704415.1_ARS1' => 'capra_hircus/Capra_hircus.ARS1.101.gtf.gz',
'GCA_004361675.1_CVASU_BBG_1.0' => 'capra_hircus_blackbengal/Capra_hircus_blackbengal.CVASU_BBG_1.0.101.gtf.gz',
'GCF_003368295.1_ASM336829v1' => 'carassius_auratus/Carassius_auratus.ASM336829v1.101.gtf.gz',
'GCA_000164805.2_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.101.gtf.gz',
'GCF_000164805.1_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.101.gtf.gz',
'tarSyr2' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.101.gtf.gz',
'GCA_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/Castor_canadensis.C.can_genome_v1.0.101.gtf.gz',
'GCF_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/Castor_canadensis.C.can_genome_v1.0.101.gtf.gz',
'casCan1' => 'castor_canadensis/Castor_canadensis.C.can_genome_v1.0.101.gtf.gz',
'GCA_004024745.2_CatWag_v2_BIUU_UCD' => 'catagonus_wagneri/Catagonus_wagneri.CatWag_v2_BIUU_UCD.101.gtf.gz',
'GCF_009819885.1_bCatUst1.pri' => 'catharus_ustulatus/Catharus_ustulatus.bCatUst1.pri.101.gtf.gz',
'GCA_000688575.1_CavAp1.0' => 'cavia_aperea/Cavia_aperea.CavAp1.0.101.gtf.gz',
'cavApe1' => 'cavia_aperea/Cavia_aperea.CavAp1.0.101.gtf.gz',
'GCA_000151735.1_Cavpor3.0' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.101.gtf.gz',
'GCF_000151735.1_Cavpor3.0' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.101.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.101.gtf.gz',
'GCA_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.101.gtf.gz',
'GCF_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.101.gtf.gz',
'cebCap1' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.101.gtf.gz',
'GCA_000955945.1_Caty_1.0' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.101.gtf.gz',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.101.gtf.gz',
'cerAty1' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.101.gtf.gz',
'GCA_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii/Chelonoidis_abingdonii.ASM359739v1.101.gtf.gz',
'GCA_007922165.1_Chelydra_serpentina-1.0' => 'chelydra_serpentina/Chelydra_serpentina.Chelydra_serpentina-1.0.101.gtf.gz',
'GCA_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.101.gtf.gz',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.101.gtf.gz',
'chiLan1' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.101.gtf.gz',
'GCA_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.101.gtf.gz',
'GCF_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.101.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.101.gtf.gz',
'GCA_000241765.2_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.101.gtf.gz',
'GCF_000241765.3_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.101.gtf.gz',
'chrPic2' => 'chrysemys_picta_bellii/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.101.gtf.gz',
'GCA_003413605.1_Chrysolophus_pictus_GenomeV1.0' => 'chrysolophus_pictus/Chrysolophus_pictus.Chrysolophus_pictus_GenomeV1.0.101.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.101.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.101.gtf.gz',
'GCA_900700415.1_Ch_v2.0.2' => 'clupea_harengus/Clupea_harengus.Ch_v2.0.2.101.gtf.gz',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus/Clupea_harengus.Ch_v2.0.2.101.gtf.gz',
'GCA_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.101.gtf.gz',
'GCF_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.101.gtf.gz',
'colAng1' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.101.gtf.gz',
'GCA_900634415.1_fCotGob3.1' => 'cottoperca_gobio/Cottoperca_gobio.fCotGob3.1.101.gtf.gz',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio/Cottoperca_gobio.fCotGob3.1.101.gtf.gz',
'GCA_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.101.gtf.gz',
'GCA_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.101.gtf.gz',
'GCF_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.101.gtf.gz',
'GCF_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.101.gtf.gz',
'cotJap2' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.101.gtf.gz',
'GCA_900186095.1_CHOK1S_HZDv1' => 'cricetulus_griseus_chok1gshd/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.101.gtf.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.101.gtf.gz',
'GCA_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.101.gtf.gz',
'GCF_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.101.gtf.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.101.gtf.gz',
'GCA_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/Cricetulus_griseus_picr.CriGri-PICR.101.gtf.gz',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/Cricetulus_griseus_picr.CriGri-PICR.101.gtf.gz',
'GCA_001723895.1_CroPor_comp1' => 'crocodylus_porosus/Crocodylus_porosus.CroPor_comp1.101.gtf.gz',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus/Crocodylus_porosus.CroPor_comp1.101.gtf.gz',
'GCA_002901205.1_cyaCae2' => 'cyanistes_caeruleus/Cyanistes_caeruleus.cyaCae2.101.gtf.gz',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus/Cyanistes_caeruleus.cyaCae2.101.gtf.gz',
'GCA_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/Cynoglossus_semilaevis.Cse_v1.0.101.gtf.gz',
'GCF_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/Cynoglossus_semilaevis.Cse_v1.0.101.gtf.gz',
'cynSem1' => 'cynoglossus_semilaevis/Cynoglossus_semilaevis.Cse_v1.0.101.gtf.gz',
'GCA_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/Cyprinodon_variegatus.C_variegatus-1.0.101.gtf.gz',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/Cyprinodon_variegatus.C_variegatus-1.0.101.gtf.gz',
'cypVar1' => 'cyprinodon_variegatus/Cyprinodon_variegatus.C_variegatus-1.0.101.gtf.gz',
'GCF_000951615.1_common_carp_genome' => 'cyprinus_carpio/Cyprinus_carpio.common_carp_genome.101.gtf.gz',
'GCA_004011555.1_German_Mirror_carp_1.0' => 'cyprinus_carpio_germanmirror/Cyprinus_carpio_germanmirror.German_Mirror_carp_1.0.101.gtf.gz',
'GCA_004011595.1_Hebao_red_carp_1.0' => 'cyprinus_carpio_hebaored/Cyprinus_carpio_hebaored.Hebao_red_carp_1.0.101.gtf.gz',
'GCA_004011575.1_Hunaghe_carp_2.0' => 'cyprinus_carpio_huanghe/Cyprinus_carpio_huanghe.Hunaghe_carp_2.0.101.gtf.gz',
'GCA_000208655.2_Dasnov3.0' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.101.gtf.gz',
'GCF_000208655.1_Dasnov3.0' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.101.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.101.gtf.gz',
'GCF_002288925.2_ASM228892v3' => 'delphinapterus_leucas/Delphinapterus_leucas.ASM228892v3.101.gtf.gz',
'GCA_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/Denticeps_clupeoides.fDenClu1.1.101.gtf.gz',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/Denticeps_clupeoides.fDenClu1.1.101.gtf.gz',
'GCA_000689215.1_seabass_V1.0' => 'dicentrarchus_labrax/Dicentrarchus_labrax.seabass_V1.0.101.gtf.gz',
'dicLab1' => 'dicentrarchus_labrax/Dicentrarchus_labrax.seabass_V1.0.101.gtf.gz',
'GCA_000151885.2_Dord_2.0' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.101.gtf.gz',
'GCF_000151885.1_Dord_2.0' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.101.gtf.gz',
'dipOrd2' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.101.gtf.gz',
'GCA_003342905.1_droNov1' => 'dromaius_novaehollandiae/Dromaius_novaehollandiae.droNov1.101.gtf.gz',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae/Dromaius_novaehollandiae.droNov1.101.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.28.101.gtf.gz',
'GCA_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/Echeneis_naucrates.fEcheNa1.1.101.gtf.gz',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/Echeneis_naucrates.fEcheNa1.1.101.gtf.gz',
'GCA_003665695.2_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.101.gtf.gz',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.101.gtf.gz',
'GCA_900186335.2_Eburgeri_3.2' => 'eptatretus_burgeri/Eptatretus_burgeri.Eburgeri_3.2.101.gtf.gz',
'GCA_003033725.1_ASM303372v1' => 'equus_asinus_asinus/Equus_asinus_asinus.ASM303372v1.101.gtf.gz',
'GCA_002863925.1_EquCab3.0' => 'equus_caballus/Equus_caballus.EquCab3.0.101.gtf.gz',
'GCF_002863925.1_EquCab3.0' => 'equus_caballus/Equus_caballus.EquCab3.0.101.gtf.gz',
'equCab3' => 'equus_caballus/Equus_caballus.EquCab3.0.101.gtf.gz',
'GCA_900747795.2_fErpCal1.1' => 'erpetoichthys_calabaricus/Erpetoichthys_calabaricus.fErpCal1.1.101.gtf.gz',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus/Erpetoichthys_calabaricus.fErpCal1.1.101.gtf.gz',
'GCA_003676055.1_GouldianFinch' => 'erythrura_gouldiae/Erythrura_gouldiae.GouldianFinch.101.gtf.gz',
'GCA_000721915.3_Eluc_V3' => 'esox_lucius/Esox_lucius.Eluc_V3.101.gtf.gz',
'GCF_004634155.1_Eluc_v4' => 'esox_lucius/Esox_lucius.Eluc_v4.101.gtf.gz',
'GCA_000181335.4_Felis_catus_9.0' => 'felis_catus/Felis_catus.Felis_catus_9.0.101.gtf.gz',
'GCF_000181335.3_Felis_catus_9.0' => 'felis_catus/Felis_catus.Felis_catus_9.0.101.gtf.gz',
'felCat9' => 'felis_catus/Felis_catus.Felis_catus_9.0.101.gtf.gz',
'GCA_000743615.1_DMR_v1.0' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.101.gtf.gz',
'GCF_000743615.1_DMR_v1.0' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.101.gtf.gz',
'fukDam1' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.101.gtf.gz',
'GCA_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.101.gtf.gz',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.101.gtf.gz',
'GCA_000002315.5_GRCg6a' => 'gallus_gallus/Gallus_gallus.GRCg6a.101.gtf.gz',
'GCF_000002315.6_GRCg6a' => 'gallus_gallus/Gallus_gallus.GRCg6a.101.gtf.gz',
'galGal6' => 'gallus_gallus/Gallus_gallus.GRCg6a.101.gtf.gz',
'GCA_003097735.1_ASM309773v1' => 'gambusia_affinis/Gambusia_affinis.ASM309773v1.101.gtf.gz',
'GCA_000277835.1_GeoFor_1.0' => 'geospiza_fortis/Geospiza_fortis.GeoFor_1.0.101.gtf.gz',
'GCF_000277835.1_GeoFor_1.0' => 'geospiza_fortis/Geospiza_fortis.GeoFor_1.0.101.gtf.gz',
'geoFor1' => 'geospiza_fortis/Geospiza_fortis.GeoFor_1.0.101.gtf.gz',
'GCA_002896415.1_ASM289641v1' => 'gopherus_agassizii/Gopherus_agassizii.ASM289641v1.101.gtf.gz',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla/Gorilla_gorilla.gorGor4.101.gtf.gz',
'gorGor4' => 'gorilla_gorilla/Gorilla_gorilla.gorGor4.101.gtf.gz',
'GCA_900634775.1_fGouWil2.1' => 'gouania_willdenowi/Gouania_willdenowi.fGouWil2.1.101.gtf.gz',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi/Gouania_willdenowi.fGouWil2.1.101.gtf.gz',
'GCA_000239415.1_AstBur1.0' => 'haplochromis_burtoni/Haplochromis_burtoni.AstBur1.0.101.gtf.gz',
'GCF_000239415.1_AstBur1.0' => 'haplochromis_burtoni/Haplochromis_burtoni.AstBur1.0.101.gtf.gz',
'hapBur1' => 'haplochromis_burtoni/Haplochromis_burtoni.AstBur1.0.101.gtf.gz',
'GCA_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.101.gtf.gz',
'GCF_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.101.gtf.gz',
'hetGla2' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.101.gtf.gz',
'GCA_000230445.1_HetGla_1.0' => 'heterocephalus_glaber_male/Heterocephalus_glaber_male.HetGla_1.0.101.gtf.gz',
'hetGla1' => 'heterocephalus_glaber_male/Heterocephalus_glaber_male.HetGla_1.0.101.gtf.gz',
'GCA_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/Hippocampus_comes.H_comes_QL1_v1.101.gtf.gz',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/Hippocampus_comes.H_comes_QL1_v1.101.gtf.gz',
'GCA_003317085.1_ASM331708v1' => 'hucho_hucho/Hucho_hucho.ASM331708v1.101.gtf.gz',
'GCA_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/Ictalurus_punctatus.IpCoco_1.2.101.gtf.gz',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/Ictalurus_punctatus.IpCoco_1.2.101.gtf.gz',
'GCA_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.101.gtf.gz',
'GCF_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.101.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.101.gtf.gz',
'GCA_000280705.1_JacJac1.0' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.101.gtf.gz',
'GCF_000280705.1_JacJac1.0' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.101.gtf.gz',
'jacJac1' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.101.gtf.gz',
'GCA_003829775.1_ASM382977v1' => 'junco_hyemalis/Junco_hyemalis.ASM382977v1.101.gtf.gz',
'GCA_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/Kryptolebias_marmoratus.ASM164957v1.101.gtf.gz',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/Kryptolebias_marmoratus.ASM164957v1.101.gtf.gz',
'GCA_900080235.1_BallGen_V1' => 'labrus_bergylta/Labrus_bergylta.BallGen_V1.101.gtf.gz',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta/Labrus_bergylta.BallGen_V1.101.gtf.gz',
'GCA_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/Larimichthys_crocea.L_crocea_2.0.101.gtf.gz',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/Larimichthys_crocea.L_crocea_2.0.101.gtf.gz',
'GCA_001640805.1_ASM164080v1' => 'lates_calcarifer/Lates_calcarifer.ASB_HGAPassembly_v1.101.gtf.gz',
'GCA_900066035.1_ASB_HGAPassembly_v1' => 'lates_calcarifer/Lates_calcarifer.ASB_HGAPassembly_v1.101.gtf.gz',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer/Lates_calcarifer.ASB_HGAPassembly_v1.101.gtf.gz',
'GCA_004320025.1_latLat_1.0' => 'laticauda_laticaudata/Laticauda_laticaudata.latLat_1.0.101.gtf.gz',
'GCA_000225785.1_LatCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.101.gtf.gz',
'GCF_000225785.1_LatCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.101.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.101.gtf.gz',
'GCA_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/Lepidothrix_coronata.Lepidothrix_coronata-1.0.101.gtf.gz',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/Lepidothrix_coronata.Lepidothrix_coronata-1.0.101.gtf.gz',
'GCA_000242695.1_LepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.101.gtf.gz',
'GCF_000242695.1_LepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.101.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.101.gtf.gz',
'GCA_002197715.1_LonStrDom1' => 'lonchura_striata_domestica/Lonchura_striata_domestica.LonStrDom1.101.gtf.gz',
'GCA_000001905.1_Loxafr3.0' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.101.gtf.gz',
'GCF_000001905.1_Loxafr3.0' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.101.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.101.gtf.gz',
'GCA_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/Lynx_canadensis.mLynCan4_v1.p.101.gtf.gz',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/Lynx_canadensis.mLynCan4_v1.p.101.gtf.gz',
'GCA_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_5.0.101.gtf.gz',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_5.0.101.gtf.gz',
'macFas5' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_5.0.101.gtf.gz',
'GCA_003339765.3_Mmul_10' => 'macaca_mulatta/Macaca_mulatta.Mmul_10.101.gtf.gz',
'GCF_003339765.1_Mmul_10' => 'macaca_mulatta/Macaca_mulatta.Mmul_10.101.gtf.gz',
'rheMac10' => 'macaca_mulatta/Macaca_mulatta.Mmul_10.101.gtf.gz',
'GCA_000956065.1_Mnem_1.0' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.101.gtf.gz',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.101.gtf.gz',
'macNem1' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.101.gtf.gz',
'GCA_001715985.2_ASM171598v2' => 'manacus_vitellinus/Manacus_vitellinus.ASM171598v2.101.gtf.gz',
'GCA_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.101.gtf.gz',
'GCF_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.101.gtf.gz',
'manLeu1' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.101.gtf.gz',
'GCA_001458135.1_marMar2.1' => 'marmota_marmota_marmota/Marmota_marmota_marmota.marMar2.1.101.gtf.gz',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota/Marmota_marmota_marmota.marMar2.1.101.gtf.gz',
'GCA_900324485.1_fMasArm1.1' => 'mastacembelus_armatus/Mastacembelus_armatus.fMasArm1.1.101.gtf.gz',
'GCF_900324485.1_fMasArm1.1' => 'mastacembelus_armatus/Mastacembelus_armatus.fMasArm1.1.101.gtf.gz',
'GCF_900324485.2_fMasArm1.2' => 'mastacembelus_armatus/Mastacembelus_armatus.fMasArm1.1.101.gtf.gz',
'GCA_000238955.5_M_zebra_UMD2a' => 'maylandia_zebra/Maylandia_zebra.M_zebra_UMD2a.101.gtf.gz',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra/Maylandia_zebra.M_zebra_UMD2a.101.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.Turkey_2.01.101.gtf.gz',
'GCA_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.101.gtf.gz',
'GCF_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.101.gtf.gz',
'melUnd1' => 'melopsittacus_undulatus/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.101.gtf.gz',
'GCA_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/Meriones_unguiculatus.MunDraft-v1.0.101.gtf.gz',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/Meriones_unguiculatus.MunDraft-v1.0.101.gtf.gz',
'GCA_000349665.1_MesAur1.0' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.101.gtf.gz',
'GCF_000349665.1_MesAur1.0' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.101.gtf.gz',
'mesAur1' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.101.gtf.gz',
'GCA_000165445.3_Mmur_3.0' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.101.gtf.gz',
'GCF_000165445.2_Mmur_3.0' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.101.gtf.gz',
'micMur3' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.101.gtf.gz',
'GCA_000317375.1_MicOch1.0' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.101.gtf.gz',
'GCF_000317375.1_MicOch1.0' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.101.gtf.gz',
'micOch1' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.101.gtf.gz',
'GCA_001698575.1_ASM169857v1' => 'mola_mola/Mola_mola.ASM169857v1.101.gtf.gz',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica/Monodelphis_domestica.ASM229v1.101.gtf.gz',
'GCF_005190385.1_NGI_Narwhal_1' => 'monodon_monoceros/Monodon_monoceros.NGI_Narwhal_1.101.gtf.gz',
'GCA_001952655.1_M_albus_1.0' => 'monopterus_albus/Monopterus_albus.M_albus_1.0.101.gtf.gz',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus/Monopterus_albus.M_albus_1.0.101.gtf.gz',
'GCA_004024705.2_MosMos_v2_BIUU_UCD' => 'moschus_moschiferus/Moschus_moschiferus.MosMos_v2_BIUU_UCD.101.gtf.gz',
'GCA_900094665.2_CAROLI_EIJ_v1.1' => 'mus_caroli/Mus_caroli.CAROLI_EIJ_v1.1.101.gtf.gz',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli/Mus_caroli.CAROLI_EIJ_v1.1.101.gtf.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/Mus_musculus_129s1svimj.129S1_SvImJ_v1.101.gtf.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/Mus_musculus_aj.A_J_v1.101.gtf.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/Mus_musculus_akrj.AKR_J_v1.101.gtf.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/Mus_musculus_balbcj.BALB_cJ_v1.101.gtf.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/Mus_musculus_c3hhej.C3H_HeJ_v1.101.gtf.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.101.gtf.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/Mus_musculus_casteij.CAST_EiJ_v1.101.gtf.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/Mus_musculus_cbaj.CBA_J_v1.101.gtf.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/Mus_musculus_dba2j.DBA_2J_v1.101.gtf.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/Mus_musculus_fvbnj.FVB_NJ_v1.101.gtf.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/Mus_musculus_lpj.LP_J_v1.101.gtf.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.101.gtf.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.101.gtf.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/Mus_musculus_pwkphj.PWK_PhJ_v1.101.gtf.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/Mus_musculus_wsbeij.WSB_EiJ_v1.101.gtf.gz',
'GCA_900095145.2_PAHARI_EIJ_v1.1' => 'mus_pahari/Mus_pahari.PAHARI_EIJ_v1.1.101.gtf.gz',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari/Mus_pahari.PAHARI_EIJ_v1.1.101.gtf.gz',
'GCA_003336285.1_MUSP714' => 'mus_spicilegus/Mus_spicilegus.MUSP714.101.gtf.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/Mus_spretus.SPRET_EiJ_v1.101.gtf.gz',
'GCA_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.101.gtf.gz',
'GCF_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.101.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.101.gtf.gz',
'GCA_000147115.1_Myoluc2.0' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.101.gtf.gz',
'GCF_000147115.1_Myoluc2.0' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.101.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.101.gtf.gz',
'GCA_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/Myripristis_murdjan.fMyrMur1.1.101.gtf.gz',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/Myripristis_murdjan.fMyrMur1.1.101.gtf.gz',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.101.gtf.gz',
'GCF_000622305.1_S.galili_v1.0' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.101.gtf.gz',
'nanGal1' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.101.gtf.gz',
'GCA_007210695.1_RGoby_Basel_V2' => 'neogobius_melanostomus/Neogobius_melanostomus.RGoby_Basel_V2.101.gtf.gz',
'GCA_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/Neolamprologus_brichardi.NeoBri1.0.101.gtf.gz',
'GCF_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/Neolamprologus_brichardi.NeoBri1.0.101.gtf.gz',
'neoBri1' => 'neolamprologus_brichardi/Neolamprologus_brichardi.NeoBri1.0.101.gtf.gz',
'GCA_900108605.1_NNQGG.v01' => 'neovison_vison/Neovison_vison.NNQGG.v01.101.gtf.gz',
'GCA_000146795.3_Nleu_3.0' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu_3.0.101.gtf.gz',
'nomLeu3' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu_3.0.101.gtf.gz',
'GCA_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/Notechis_scutatus.TS10Xv2-PRI.101.gtf.gz',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/Notechis_scutatus.TS10Xv2-PRI.101.gtf.gz',
'GCF_001465895.1_Nfu_20140520' => 'nothobranchius_furzeri/Nothobranchius_furzeri.Nfu_20140520.101.gtf.gz',
'GCA_003342845.1_notPer1' => 'nothoprocta_perdicaria/Nothoprocta_perdicaria.notPer1.101.gtf.gz',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria/Nothoprocta_perdicaria.notPer1.101.gtf.gz',
'GCA_002078875.2_NumMel1.0' => 'numida_meleagris/Numida_meleagris.NumMel1.0.101.gtf.gz',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris/Numida_meleagris.NumMel1.0.101.gtf.gz',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus/Octodon_degus.OctDeg1.0.101.gtf.gz',
'GCF_000260255.1_OctDeg1.0' => 'octodon_degus/Octodon_degus.OctDeg1.0.101.gtf.gz',
'octDeg1' => 'octodon_degus/Octodon_degus.OctDeg1.0.101.gtf.gz',
'GCF_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss/Oncorhynchus_mykiss.Omyk_1.0.101.gtf.gz',
'GCF_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha/Oncorhynchus_tshawytscha.Otsh_v1.0.101.gtf.gz',
'GCA_005870065.1_ASM587006v1' => 'oreochromis_aureus/Oreochromis_aureus.ASM587006v1.101.gtf.gz',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus/Oreochromis_aureus.ASM587006v1.101.gtf.gz',
'GCA_001858045.3_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/Oreochromis_niloticus.O_niloticus_UMD_NMBU.101.gtf.gz',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/Oreochromis_niloticus.O_niloticus_UMD_NMBU.101.gtf.gz',
'GCF_004115215.1_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.mOrnAna1.p.v1.101.gtf.gz',
'GCA_000003625.1_OryCun2.0' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.101.gtf.gz',
'GCF_000003625.3_OryCun2.0' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.101.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.101.gtf.gz',
'GCA_003999625.1_OJAV_1.1' => 'oryzias_javanicus/Oryzias_javanicus.OJAV_1.1.101.gtf.gz',
'GCA_002234675.1_ASM223467v1' => 'oryzias_latipes/Oryzias_latipes.ASM223467v1.101.gtf.gz',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes/Oryzias_latipes.ASM223467v1.101.gtf.gz',
'GCA_002234715.1_ASM223471v1' => 'oryzias_latipes_hni/Oryzias_latipes_hni.ASM223471v1.101.gtf.gz',
'GCA_002234695.1_ASM223469v1' => 'oryzias_latipes_hsok/Oryzias_latipes_hsok.ASM223469v1.101.gtf.gz',
'GCA_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/Oryzias_melastigma.Om_v0.7.RACA.101.gtf.gz',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/Oryzias_melastigma.Om_v0.7.RACA.101.gtf.gz',
'GCA_008586565.1_ASM858656v1' => 'oryzias_sinensis/Oryzias_sinensis.ASM858656v1.101.gtf.gz',
'GCA_000181295.3_OtoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.101.gtf.gz',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.101.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.101.gtf.gz',
'GCA_000298735.1_Oar_v3.1' => 'ovis_aries/Ovis_aries.Oar_v3.1.101.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.101.gtf.gz',
'GCF_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet/Ovis_aries_rambouillet.Oar_rambouillet_v1.0.101.gtf.gz',
'GCA_000258655.2_panpan1.1' => 'pan_paniscus/Pan_paniscus.panpan1.1.101.gtf.gz',
'GCF_000258655.2_panpan1.1' => 'pan_paniscus/Pan_paniscus.panpan1.1.101.gtf.gz',
'panPan2' => 'pan_paniscus/Pan_paniscus.panpan1.1.101.gtf.gz',
'GCA_000001515.5_Pan_tro_3.0' => 'pan_troglodytes/Pan_troglodytes.Pan_tro_3.0.101.gtf.gz',
'panTro5' => 'pan_troglodytes/Pan_troglodytes.Pan_tro_3.0.101.gtf.gz',
'GCA_008795835.1_PanLeo1.0' => 'panthera_leo/Panthera_leo.PanLeo1.0.101.gtf.gz',
'GCA_001857705.1_PanPar1.0' => 'panthera_pardus/Panthera_pardus.PanPar1.0.101.gtf.gz',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus/Panthera_pardus.PanPar1.0.101.gtf.gz',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/Panthera_tigris_altaica.PanTig1.0.101.gtf.gz',
'GCF_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/Panthera_tigris_altaica.PanTig1.0.101.gtf.gz',
'panTig1' => 'panthera_tigris_altaica/Panthera_tigris_altaica.PanTig1.0.101.gtf.gz',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis/Papio_anubis.Panu_3.0.101.gtf.gz',
'GCF_000264685.3_Panu_3.0' => 'papio_anubis/Papio_anubis.Panu_3.0.101.gtf.gz',
'papAnu4' => 'papio_anubis/Papio_anubis.Panu_3.0.101.gtf.gz',
'GCA_900634625.1_fParRan2.1' => 'parambassis_ranga/Parambassis_ranga.fParRan2.1.101.gtf.gz',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga/Parambassis_ranga.fParRan2.1.101.gtf.gz',
'GCA_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/Paramormyrops_kingsleyae.PKINGS_0.1.101.gtf.gz',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/Paramormyrops_kingsleyae.PKINGS_0.1.101.gtf.gz',
'GCA_001522545.2_Parus_major1.1' => 'parus_major/Parus_major.Parus_major1.1.101.gtf.gz',
'GCF_001522545.3_Parus_major1.1' => 'parus_major/Parus_major.Parus_major1.1.101.gtf.gz',
'GCA_005519975.1_AIIM_Pcri_1.0' => 'pavo_cristatus/Pavo_cristatus.AIIM_Pcri_1.0.101.gtf.gz',
'GCA_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.101.gtf.gz',
'GCF_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.101.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.101.gtf.gz',
'GCA_007922175.1_Pelusios_castaneus-1.0' => 'pelusios_castaneus/Pelusios_castaneus.Pelusios_castaneus-1.0.101.gtf.gz',
'GCA_000787105.1_PM.fa' => 'periophthalmus_magnuspinnatus/Periophthalmus_magnuspinnatus.PM.fa.101.gtf.gz',
'GCA_003704035.1_HU_Pman_2.1' => 'peromyscus_maniculatus_bairdii/Peromyscus_maniculatus_bairdii.HU_Pman_2.1.101.gtf.gz',
'GCA_000148955.1_Petromyzon_marinus-7.0' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.101.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.101.gtf.gz',
'GCA_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/Phascolarctos_cinereus.phaCin_unsw_v4.1.101.gtf.gz',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/Phascolarctos_cinereus.phaCin_unsw_v4.1.101.gtf.gz',
'GCA_004143745.1_ASM414374v1' => 'phasianus_colchicus/Phasianus_colchicus.ASM414374v1.101.gtf.gz',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus/Phasianus_colchicus.ASM414374v1.101.gtf.gz',
'GCF_008692025.1_mPhoSin1.pri' => 'phocoena_sinus/Phocoena_sinus.mPhoSin1.pri.101.gtf.gz',
'GCA_002837175.2_ASM283717v2' => 'physeter_catodon/Physeter_catodon.ASM283717v2.101.gtf.gz',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon/Physeter_catodon.ASM283717v2.101.gtf.gz',
'GCA_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/Piliocolobus_tephrosceles.ASM277652v2.101.gtf.gz',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/Piliocolobus_tephrosceles.ASM277652v2.101.gtf.gz',
'GCA_004329235.1_PodMur_1.0' => 'podarcis_muralis/Podarcis_muralis.PodMur_1.0.101.gtf.gz',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis/Podarcis_muralis.PodMur_1.0.101.gtf.gz',
'GCA_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.101.gtf.gz',
'GCF_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.101.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.101.gtf.gz',
'GCA_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/Poecilia_latipinna.P_latipinna-1.0.101.gtf.gz',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/Poecilia_latipinna.P_latipinna-1.0.101.gtf.gz',
'GCA_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/Poecilia_mexicana.P_mexicana-1.0.101.gtf.gz',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/Poecilia_mexicana.P_mexicana-1.0.101.gtf.gz',
'GCA_000633615.2_Guppy_female_1.0_MT' => 'poecilia_reticulata/Poecilia_reticulata.Guppy_female_1.0_MT.101.gtf.gz',
'GCF_000633615.1_Guppy_female_1.0_MT' => 'poecilia_reticulata/Poecilia_reticulata.Guppy_female_1.0_MT.101.gtf.gz',
'poeRet1' => 'poecilia_reticulata/Poecilia_reticulata.Guppy_female_1.0_MT.101.gtf.gz',
'GCA_900067755.1_pvi1.1' => 'pogona_vitticeps/Pogona_vitticeps.pvi1.1.101.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.101.gtf.gz',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus/Prolemur_simus.Prosim_1.0.101.gtf.gz',
'GCA_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.101.gtf.gz',
'GCF_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.101.gtf.gz',
'proCoq1' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.101.gtf.gz',
'GCA_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/Pseudonaja_textilis.EBS10Xv2-PRI.101.gtf.gz',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/Pseudonaja_textilis.EBS10Xv2-PRI.101.gtf.gz',
'GCA_000239375.1_PunNye1.0' => 'pundamilia_nyererei/Pundamilia_nyererei.PunNye1.0.101.gtf.gz',
'GCF_000239375.1_PunNye1.0' => 'pundamilia_nyererei/Pundamilia_nyererei.PunNye1.0.101.gtf.gz',
'punNye1' => 'pundamilia_nyererei/Pundamilia_nyererei.PunNye1.0.101.gtf.gz',
'GCA_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.101.gtf.gz',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.101.gtf.gz',
'GCA_000001895.4_Rnor_6.0' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.101.gtf.gz',
'GCF_000001895.5_Rnor_6.0' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.101.gtf.gz',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.101.gtf.gz',
'GCF_004115265.1_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.101.gtf.gz',
'GCA_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.101.gtf.gz',
'GCF_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.101.gtf.gz',
'rhiBie1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.101.gtf.gz',
'GCA_000769185.1_Rrox_v1' => 'rhinopithecus_roxellana/Rhinopithecus_roxellana.Rrox_v1.101.gtf.gz',
'rhiRox1' => 'rhinopithecus_roxellana/Rhinopithecus_roxellana.Rrox_v1.101.gtf.gz',
'GCA_000146045.2_R64-1-1' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.101.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.101.gtf.gz',
'GCA_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.101.gtf.gz',
'GCF_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.101.gtf.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.101.gtf.gz',
'GCA_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/Salarias_fasciatus.fSalaFa1.1.101.gtf.gz',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/Salarias_fasciatus.fSalaFa1.1.101.gtf.gz',
'GCA_000233375.4_ICSASG_v2' => 'salmo_salar/Salmo_salar.ICSASG_v2.101.gtf.gz',
'GCA_901001165.1_fSalTru1.1' => 'salmo_trutta/Salmo_trutta.fSalTru1.1.101.gtf.gz',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta/Salmo_trutta.fSalTru1.1.101.gtf.gz',
'GCA_003586115.1_HLtupMer3' => 'salvator_merianae/Salvator_merianae.HLtupMer3.101.gtf.gz',
'GCF_008315115.1_SLUC_FBN_1' => 'sander_lucioperca/Sander_lucioperca.SLUC_FBN_1.101.gtf.gz',
'GCA_000189315.1_Devil_ref_v7.0' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.101.gtf.gz',
'GCF_000189315.1_Devil_ref_v7.0' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.101.gtf.gz',
'sarHar1' => 'sarcophilus_harrisii/Sarcophilus_harrisii.DEVIL7.0.101.gtf.gz',
'GCA_902686455.1_mSciVul1.1' => 'sciurus_vulgaris/Sciurus_vulgaris.mSciVul1.1.101.gtf.gz',
'GCA_900964775.1_fSclFor1.1' => 'scleropages_formosus/Scleropages_formosus.fSclFor1.1.101.gtf.gz',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus/Scleropages_formosus.fSclFor1.1.101.gtf.gz',
'GCA_003186165.1_ASM318616v1' => 'scophthalmus_maximus/Scophthalmus_maximus.ASM318616v1.101.gtf.gz',
'GCA_000534875.1_SCA1' => 'serinus_canaria/Serinus_canaria.SCA1.101.gtf.gz',
'serCan1' => 'serinus_canaria/Serinus_canaria.SCA1.101.gtf.gz',
'GCA_002260705.1_Sdu_1.0' => 'seriola_dumerili/Seriola_dumerili.Sdu_1.0.101.gtf.gz',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili/Seriola_dumerili.Sdu_1.0.101.gtf.gz',
'GCA_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/Seriola_lalandi_dorsalis.Sedor1.101.gtf.gz',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/Seriola_lalandi_dorsalis.Sedor1.101.gtf.gz',
'GCA_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.101.gtf.gz',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.101.gtf.gz',
'GCA_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.101.gtf.gz',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.101.gtf.gz',
'GCA_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.101.gtf.gz',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.101.gtf.gz',
'GCA_900880675.1_fSpaAur1.1' => 'sparus_aurata/Sparus_aurata.fSpaAur1.1.101.gtf.gz',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata/Sparus_aurata.fSpaAur1.1.101.gtf.gz',
'GCA_002406435.1_ASM240643v1' => 'spermophilus_dauricus/Spermophilus_dauricus.ASM240643v1.101.gtf.gz',
'GCA_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/Sphaeramia_orbicularis.fSphaOr1.1.101.gtf.gz',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/Sphaeramia_orbicularis.fSphaOr1.1.101.gtf.gz',
'GCA_003113815.1_ASM311381v1' => 'sphenodon_punctatus/Sphenodon_punctatus.ASM311381v1.101.gtf.gz',
'GCA_008694505.1_ASM869450v1' => 'stachyris_ruficeps/Stachyris_ruficeps.ASM869450v1.101.gtf.gz',
'GCA_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/Stegastes_partitus.Stegastes_partitus-1.0.2.101.gtf.gz',
'GCF_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/Stegastes_partitus.Stegastes_partitus-1.0.2.101.gtf.gz',
'stePar1' => 'stegastes_partitus/Stegastes_partitus.Stegastes_partitus-1.0.2.101.gtf.gz',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/Strigops_habroptila.bStrHab1_v1.p.101.gtf.gz',
'GCF_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/Strigops_habroptila.bStrHab1_v1.p.101.gtf.gz',
'GCA_002372975.1_Soccid_v01' => 'strix_occidentalis_caurina/Strix_occidentalis_caurina.Soccid_v01.101.gtf.gz',
'GCA_000698965.1_ASM69896v1' => 'struthio_camelus_australis/Struthio_camelus_australis.ASM69896v1.101.gtf.gz',
'GCF_000698965.1_ASM69896v1' => 'struthio_camelus_australis/Struthio_camelus_australis.ASM69896v1.101.gtf.gz',
'strCam1' => 'struthio_camelus_australis/Struthio_camelus_australis.ASM69896v1.101.gtf.gz',
'GCA_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.101.gtf.gz',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.101.gtf.gz',
'GCA_000003025.6_Sscrofa11.1' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.101.gtf.gz',
'GCF_000003025.6_Sscrofa11.1' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.101.gtf.gz',
'susScr11' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.101.gtf.gz',
'GCA_001700235.1_Bamei_pig_v1' => 'sus_scrofa_bamei/Sus_scrofa_bamei.Bamei_pig_v1.101.gtf.gz',
'GCA_001700575.1_Berkshire_pig_v1' => 'sus_scrofa_berkshire/Sus_scrofa_berkshire.Berkshire_pig_v1.101.gtf.gz',
'GCA_001700165.1_Hampshire_pig_v1' => 'sus_scrofa_hampshire/Sus_scrofa_hampshire.Hampshire_pig_v1.101.gtf.gz',
'GCA_001700295.1_Jinhua_pig_v1' => 'sus_scrofa_jinhua/Sus_scrofa_jinhua.Jinhua_pig_v1.101.gtf.gz',
'GCA_001700215.1_Landrace_pig_v1' => 'sus_scrofa_landrace/Sus_scrofa_landrace.Landrace_pig_v1.101.gtf.gz',
'GCA_001700135.1_Large_White_v1' => 'sus_scrofa_largewhite/Sus_scrofa_largewhite.Large_White_v1.101.gtf.gz',
'GCA_001700195.1_Meishan_pig_v1' => 'sus_scrofa_meishan/Sus_scrofa_meishan.Meishan_pig_v1.101.gtf.gz',
'GCA_001700255.1_Pietrain_pig_v1' => 'sus_scrofa_pietrain/Sus_scrofa_pietrain.Pietrain_pig_v1.101.gtf.gz',
'GCA_001700155.1_Rongchang_pig_v1' => 'sus_scrofa_rongchang/Sus_scrofa_rongchang.Rongchang_pig_v1.101.gtf.gz',
'GCA_000472085.2_Tibetan_Pig_v2' => 'sus_scrofa_tibetan/Sus_scrofa_tibetan.Tibetan_Pig_v2.101.gtf.gz',
'GCA_002844635.1_USMARCv1.0' => 'sus_scrofa_usmarc/Sus_scrofa_usmarc.USMARCv1.0.101.gtf.gz',
'GCA_000325925.2_minipig_v1.0' => 'sus_scrofa_wuzhishan/Sus_scrofa_wuzhishan.minipig_v1.0.101.gtf.gz',
'GCA_003957565.2_bTaeGut1_v1.p' => 'taeniopygia_guttata/Taeniopygia_guttata.bTaeGut1_v1.p.101.gtf.gz',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata/Taeniopygia_guttata.bTaeGut1_v1.p.101.gtf.gz',
'GCA_901000725.2_fTakRub1.2' => 'takifugu_rubripes/Takifugu_rubripes.fTakRub1.2.101.gtf.gz',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes/Takifugu_rubripes.fTakRub1.2.101.gtf.gz',
'GCA_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis/Terrapene_carolina_triunguis.T_m_triunguis-2.0.101.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.101.gtf.gz',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada/Theropithecus_gelada.Tgel_1.0.101.gtf.gz',
'GCF_003255815.1_Tgel_1.0' => 'theropithecus_gelada/Theropithecus_gelada.Tgel_1.0.101.gtf.gz',
'GCA_003426925.1_ASM342692v1' => 'urocitellus_parryii/Urocitellus_parryii.ASM342692v1.101.gtf.gz',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii/Urocitellus_parryii.ASM342692v1.101.gtf.gz',
'GCA_003344425.1_ASM334442v1' => 'ursus_americanus/Ursus_americanus.ASM334442v1.101.gtf.gz',
'GCA_000687225.1_UrsMar_1.0' => 'ursus_maritimus/Ursus_maritimus.UrsMar_1.0.101.gtf.gz',
'GCF_000687225.1_UrsMar_1.0' => 'ursus_maritimus/Ursus_maritimus.UrsMar_1.0.101.gtf.gz',
'ursMar1' => 'ursus_maritimus/Ursus_maritimus.UrsMar_1.0.101.gtf.gz',
'GCA_004798865.1_ASM479886v1' => 'varanus_komodoensis/Varanus_komodoensis.ASM479886v1.101.gtf.gz',
'GCA_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.101.gtf.gz',
'GCF_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.101.gtf.gz',
'GCA_003160815.1_VulVul2.2' => 'vulpes_vulpes/Vulpes_vulpes.VulVul2.2.101.gtf.gz',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes/Vulpes_vulpes.VulVul2.2.101.gtf.gz',
'GCA_000004195.3_Xenopus_tropicalis_v9.1' => 'xenopus_tropicalis/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.101.gtf.gz',
'xenTro9' => 'xenopus_tropicalis/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.101.gtf.gz',
'GCA_001444195.1_Xiphophorus_couchianus-4.0.1' => 'xiphophorus_couchianus/Xiphophorus_couchianus.Xiphophorus_couchianus-4.0.1.101.gtf.gz',
'GCA_002775205.2_X_maculatus-5.0-male' => 'xiphophorus_maculatus/Xiphophorus_maculatus.X_maculatus-5.0-male.101.gtf.gz',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus/Xiphophorus_maculatus.X_maculatus-5.0-male.101.gtf.gz',
'GCA_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.101.gtf.gz',
'GCF_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.101.gtf.gz',
'zonAlb1' => 'zonotrichia_albicollis/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.101.gtf.gz',
'GCA_001281735.1_ASM128173v1' => 'zosterops_lateralis_melanops/Zosterops_lateralis_melanops.ASM128173v1.101.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_101 = (
'GCA_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/pep/Acanthochromis_polyacanthus.ASM210954v1.pep.all.fa.gz',
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/pep/Acanthochromis_polyacanthus.ASM210954v1.pep.all.fa.gz',
'GCA_004320145.1_Accipiter_nisus_ver1.0' => 'accipiter_nisus/pep/Accipiter_nisus.Accipiter_nisus_ver1.0.pep.all.fa.gz',
'GCA_000004335.1_AilMel_1.0' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'GCF_000004335.2_AilMel_1.0' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'ailMel1' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'GCA_003947215.1_ASM394721v1' => 'amazona_collaria/pep/Amazona_collaria.ASM394721v1.pep.all.fa.gz',
'GCA_000751415.1_Midas_v5' => 'amphilophus_citrinellus/pep/Amphilophus_citrinellus.Midas_v5.pep.all.fa.gz',
'GCA_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/pep/Amphiprion_ocellaris.AmpOce1.0.pep.all.fa.gz',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/pep/Amphiprion_ocellaris.AmpOce1.0.pep.all.fa.gz',
'GCA_003047355.1_Nemo_v1' => 'amphiprion_percula/pep/Amphiprion_percula.Nemo_v1.pep.all.fa.gz',
'GCA_900324465.1_fAnaTes1.1' => 'anabas_testudineus/pep/Anabas_testudineus.fAnaTes1.1.pep.all.fa.gz',
'GCF_900324465.1_fAnaTes1.1' => 'anabas_testudineus/pep/Anabas_testudineus.fAnaTes1.1.pep.all.fa.gz',
'GCA_008746955.1_ASM874695v1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.ASM874695v1.pep.all.fa.gz',
'GCA_002743455.1_CAU_duck1.0' => 'anas_platyrhynchos_platyrhynchos/pep/Anas_platyrhynchos_platyrhynchos.CAU_duck1.0.pep.all.fa.gz',
'GCA_002224875.1_ASM222487v1' => 'anas_zonorhyncha/pep/Anas_zonorhyncha.ASM222487v1.pep.all.fa.gz',
'GCA_000090745.2_AnoCar2.0' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'GCF_000090745.1_AnoCar2.0' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'GCA_002592135.1_ASM259213v1' => 'anser_brachyrhynchus/pep/Anser_brachyrhynchus.ASM259213v1.pep.all.fa.gz',
'GCA_002166845.1_GooseV1.0' => 'anser_cygnoides/pep/Anser_cygnoides.GooseV1.0.pep.all.fa.gz',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'GCF_000952055.2_Anan_2.0' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'aotNan1' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'GCA_003342985.1_aptHaa1' => 'apteryx_haastii/pep/Apteryx_haastii.aptHaa1.pep.all.fa.gz',
'GCA_003342965.1_aptOwe1' => 'apteryx_owenii/pep/Apteryx_owenii.aptOwe1.pep.all.fa.gz',
'GCA_003343035.1_aptRow1' => 'apteryx_rowi/pep/Apteryx_rowi.aptRow1.pep.all.fa.gz',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi/pep/Apteryx_rowi.aptRow1.pep.all.fa.gz',
'GCA_900496995.2_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/pep/Aquila_chrysaetos_chrysaetos.bAquChr1.2.pep.all.fa.gz',
'GCF_900496995.1_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/pep/Aquila_chrysaetos_chrysaetos.bAquChr1.2.pep.all.fa.gz',
'GCA_900246225.3_fAstCal1.2' => 'astatotilapia_calliptera/pep/Astatotilapia_calliptera.fAstCal1.2.pep.all.fa.gz',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera/pep/Astatotilapia_calliptera.fAstCal1.2.pep.all.fa.gz',
'GCA_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.Astyanax_mexicanus-2.0.pep.all.fa.gz',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.Astyanax_mexicanus-2.0.pep.all.fa.gz',
'GCA_004802775.1_Astyanax_mexicanus-1.0.2' => 'astyanax_mexicanus_pachon/pep/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus_pachon/pep/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.pep.all.fa.gz',
'GCA_003259725.1_athCun1' => 'athene_cunicularia/pep/Athene_cunicularia.athCun1.pep.all.fa.gz',
'GCF_003259725.1_athCun1' => 'athene_cunicularia/pep/Athene_cunicularia.athCun1.pep.all.fa.gz',
'GCA_900634795.2_fBetSpl5.2' => 'betta_splendens/pep/Betta_splendens.fBetSpl5.2.pep.all.fa.gz',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens/pep/Betta_splendens.fBetSpl5.2.pep.all.fa.gz',
'GCA_000754665.1_Bison_UMD1.0' => 'bison_bison_bison/pep/Bison_bison_bison.Bison_UMD1.0.pep.all.fa.gz',
'bisBis1' => 'bison_bison_bison/pep/Bison_bison_bison.Bison_UMD1.0.pep.all.fa.gz',
'GCA_005887515.1_LU_Bosgru_v3.0' => 'bos_grunniens/pep/Bos_grunniens.LU_Bosgru_v3.0.pep.all.fa.gz',
'GCA_003369695.2_UOA_Brahman_1' => 'bos_indicus_hybrid/pep/Bos_indicus_hybrid.UOA_Brahman_1.pep.all.fa.gz',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid/pep/Bos_indicus_hybrid.UOA_Brahman_1.pep.all.fa.gz',
'GCA_000298355.1_BosGru_v2.0' => 'bos_mutus/pep/Bos_mutus.BosGru_v2.0.pep.all.fa.gz',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus/pep/Bos_mutus.BosGru_v2.0.pep.all.fa.gz',
'bosMut1' => 'bos_mutus/pep/Bos_mutus.BosGru_v2.0.pep.all.fa.gz',
'GCA_002263795.2_ARS-UCD1.2' => 'bos_taurus/pep/Bos_taurus.ARS-UCD1.2.pep.all.fa.gz',
'GCF_002263795.1_ARS-UCD1.2' => 'bos_taurus/pep/Bos_taurus.ARS-UCD1.2.pep.all.fa.gz',
'bosTau9' => 'bos_taurus/pep/Bos_taurus.ARS-UCD1.2.pep.all.fa.gz',
'GCA_003369685.2_UOA_Angus_1' => 'bos_taurus_hybrid/pep/Bos_taurus_hybrid.UOA_Angus_1.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'GCA_001431845.1_ASM143184v1' => 'calidris_pugnax/pep/Calidris_pugnax.ASM143184v1.pep.all.fa.gz',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax/pep/Calidris_pugnax.ASM143184v1.pep.all.fa.gz',
'GCA_003697955.1_ASM369795v1' => 'calidris_pygmaea/pep/Calidris_pygmaea.ASM369795v1.pep.all.fa.gz',
'GCA_002754865.1_ASM275486v1' => 'callithrix_jacchus/pep/Callithrix_jacchus.ASM275486v1.pep.all.fa.gz',
'GCA_000165045.2_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/pep/Callorhinchus_milii.Callorhinchus_milii-6.1.3.pep.all.fa.gz',
'GCF_000165045.1_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/pep/Callorhinchus_milii.Callorhinchus_milii-6.1.3.pep.all.fa.gz',
'calMil1' => 'callorhinchus_milii/pep/Callorhinchus_milii.Callorhinchus_milii-6.1.3.pep.all.fa.gz',
'GCA_901933205.1_STF_HiC' => 'camarhynchus_parvulus/pep/Camarhynchus_parvulus.STF_HiC.pep.all.fa.gz',
'GCF_901933205.1_STF_HiC' => 'camarhynchus_parvulus/pep/Camarhynchus_parvulus.STF_HiC.pep.all.fa.gz',
'GCA_000803125.2_CamDro2' => 'camelus_dromedarius/pep/Camelus_dromedarius.CamDro2.pep.all.fa.gz',
'GCA_000002285.2_CanFam3.1' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'GCF_000002285.3_CanFam3.1' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'canFam3' => 'canis_familiaris/pep/Canis_familiaris.CanFam3.1.pep.all.fa.gz',
'GCA_003254725.1_ASM325472v1' => 'canis_lupus_dingo/pep/Canis_lupus_dingo.ASM325472v1.pep.all.fa.gz',
'GCF_003254725.1_ASM325472v1' => 'canis_lupus_dingo/pep/Canis_lupus_dingo.ASM325472v1.pep.all.fa.gz',
'GCF_000002285.3_CanFam3.1' => 'canis_lupus_familiaris/pep/Canis_lupus_familiaris.CanFam3.1.pep.all.fa.gz',
'canFam3' => 'canis_lupus_familiaris/pep/Canis_lupus_familiaris.CanFam3.1.pep.all.fa.gz',
'GCA_004886185.1_Basenji_breed-1.1' => 'canis_lupus_familiarisbasenji/pep/Canis_lupus_familiarisbasenji.Basenji_breed-1.1.pep.all.fa.gz',
'GCA_005444595.1_UMICH_Zoey_3.1' => 'canis_lupus_familiarisgreatdane/pep/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.pep.all.fa.gz',
'canFam5' => 'canis_lupus_familiarisgreatdane/pep/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.pep.all.fa.gz',
'GCA_001704415.1_ARS1' => 'capra_hircus/pep/Capra_hircus.ARS1.pep.all.fa.gz',
'GCF_001704415.1_ARS1' => 'capra_hircus/pep/Capra_hircus.ARS1.pep.all.fa.gz',
'GCA_004361675.1_CVASU_BBG_1.0' => 'capra_hircus_blackbengal/pep/Capra_hircus_blackbengal.CVASU_BBG_1.0.pep.all.fa.gz',
'GCF_003368295.1_ASM336829v1' => 'carassius_auratus/pep/Carassius_auratus.ASM336829v1.pep.all.fa.gz',
'GCA_000164805.2_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'GCF_000164805.1_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'tarSyr2' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'GCA_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/pep/Castor_canadensis.C.can_genome_v1.0.pep.all.fa.gz',
'GCF_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/pep/Castor_canadensis.C.can_genome_v1.0.pep.all.fa.gz',
'casCan1' => 'castor_canadensis/pep/Castor_canadensis.C.can_genome_v1.0.pep.all.fa.gz',
'GCA_004024745.2_CatWag_v2_BIUU_UCD' => 'catagonus_wagneri/pep/Catagonus_wagneri.CatWag_v2_BIUU_UCD.pep.all.fa.gz',
'GCF_009819885.1_bCatUst1.pri' => 'catharus_ustulatus/pep/Catharus_ustulatus.bCatUst1.pri.pep.all.fa.gz',
'GCA_000688575.1_CavAp1.0' => 'cavia_aperea/pep/Cavia_aperea.CavAp1.0.pep.all.fa.gz',
'cavApe1' => 'cavia_aperea/pep/Cavia_aperea.CavAp1.0.pep.all.fa.gz',
'GCA_000151735.1_Cavpor3.0' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'GCF_000151735.1_Cavpor3.0' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'GCA_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'GCF_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'cebCap1' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'GCA_000955945.1_Caty_1.0' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'cerAty1' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'GCA_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii/pep/Chelonoidis_abingdonii.ASM359739v1.pep.all.fa.gz',
'GCA_007922165.1_Chelydra_serpentina-1.0' => 'chelydra_serpentina/pep/Chelydra_serpentina.Chelydra_serpentina-1.0.pep.all.fa.gz',
'GCA_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'chiLan1' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'GCA_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'GCF_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'GCA_000241765.2_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/pep/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.pep.all.fa.gz',
'GCF_000241765.3_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/pep/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.pep.all.fa.gz',
'chrPic2' => 'chrysemys_picta_bellii/pep/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.pep.all.fa.gz',
'GCA_003413605.1_Chrysolophus_pictus_GenomeV1.0' => 'chrysolophus_pictus/pep/Chrysolophus_pictus.Chrysolophus_pictus_GenomeV1.0.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'GCA_900700415.1_Ch_v2.0.2' => 'clupea_harengus/pep/Clupea_harengus.Ch_v2.0.2.pep.all.fa.gz',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus/pep/Clupea_harengus.Ch_v2.0.2.pep.all.fa.gz',
'GCA_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'GCF_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'colAng1' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'GCA_900634415.1_fCotGob3.1' => 'cottoperca_gobio/pep/Cottoperca_gobio.fCotGob3.1.pep.all.fa.gz',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio/pep/Cottoperca_gobio.fCotGob3.1.pep.all.fa.gz',
'GCA_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCA_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCF_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCF_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'cotJap2' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCA_900186095.1_CHOK1S_HZDv1' => 'cricetulus_griseus_chok1gshd/pep/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.pep.all.fa.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/pep/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.pep.all.fa.gz',
'GCA_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'GCF_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'GCA_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/pep/Cricetulus_griseus_picr.CriGri-PICR.pep.all.fa.gz',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/pep/Cricetulus_griseus_picr.CriGri-PICR.pep.all.fa.gz',
'GCA_001723895.1_CroPor_comp1' => 'crocodylus_porosus/pep/Crocodylus_porosus.CroPor_comp1.pep.all.fa.gz',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus/pep/Crocodylus_porosus.CroPor_comp1.pep.all.fa.gz',
'GCA_002901205.1_cyaCae2' => 'cyanistes_caeruleus/pep/Cyanistes_caeruleus.cyaCae2.pep.all.fa.gz',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus/pep/Cyanistes_caeruleus.cyaCae2.pep.all.fa.gz',
'GCA_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/pep/Cynoglossus_semilaevis.Cse_v1.0.pep.all.fa.gz',
'GCF_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/pep/Cynoglossus_semilaevis.Cse_v1.0.pep.all.fa.gz',
'cynSem1' => 'cynoglossus_semilaevis/pep/Cynoglossus_semilaevis.Cse_v1.0.pep.all.fa.gz',
'GCA_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/pep/Cyprinodon_variegatus.C_variegatus-1.0.pep.all.fa.gz',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/pep/Cyprinodon_variegatus.C_variegatus-1.0.pep.all.fa.gz',
'cypVar1' => 'cyprinodon_variegatus/pep/Cyprinodon_variegatus.C_variegatus-1.0.pep.all.fa.gz',
'GCF_000951615.1_common_carp_genome' => 'cyprinus_carpio/pep/Cyprinus_carpio.common_carp_genome.pep.all.fa.gz',
'GCA_004011555.1_German_Mirror_carp_1.0' => 'cyprinus_carpio_germanmirror/pep/Cyprinus_carpio_germanmirror.German_Mirror_carp_1.0.pep.all.fa.gz',
'GCA_004011595.1_Hebao_red_carp_1.0' => 'cyprinus_carpio_hebaored/pep/Cyprinus_carpio_hebaored.Hebao_red_carp_1.0.pep.all.fa.gz',
'GCA_004011575.1_Hunaghe_carp_2.0' => 'cyprinus_carpio_huanghe/pep/Cyprinus_carpio_huanghe.Hunaghe_carp_2.0.pep.all.fa.gz',
'GCA_000208655.2_Dasnov3.0' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'GCF_000208655.1_Dasnov3.0' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'GCF_002288925.2_ASM228892v3' => 'delphinapterus_leucas/pep/Delphinapterus_leucas.ASM228892v3.pep.all.fa.gz',
'GCA_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/pep/Denticeps_clupeoides.fDenClu1.1.pep.all.fa.gz',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/pep/Denticeps_clupeoides.fDenClu1.1.pep.all.fa.gz',
'GCA_000689215.1_seabass_V1.0' => 'dicentrarchus_labrax/pep/Dicentrarchus_labrax.seabass_V1.0.pep.all.fa.gz',
'dicLab1' => 'dicentrarchus_labrax/pep/Dicentrarchus_labrax.seabass_V1.0.pep.all.fa.gz',
'GCA_000151885.2_Dord_2.0' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'GCF_000151885.1_Dord_2.0' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'dipOrd2' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'GCA_003342905.1_droNov1' => 'dromaius_novaehollandiae/pep/Dromaius_novaehollandiae.droNov1.pep.all.fa.gz',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae/pep/Dromaius_novaehollandiae.droNov1.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.28.pep.all.fa.gz',
'GCA_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/pep/Echeneis_naucrates.fEcheNa1.1.pep.all.fa.gz',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/pep/Echeneis_naucrates.fEcheNa1.1.pep.all.fa.gz',
'GCA_003665695.2_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/pep/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.pep.all.fa.gz',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/pep/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.pep.all.fa.gz',
'GCA_900186335.2_Eburgeri_3.2' => 'eptatretus_burgeri/pep/Eptatretus_burgeri.Eburgeri_3.2.pep.all.fa.gz',
'GCA_003033725.1_ASM303372v1' => 'equus_asinus_asinus/pep/Equus_asinus_asinus.ASM303372v1.pep.all.fa.gz',
'GCA_002863925.1_EquCab3.0' => 'equus_caballus/pep/Equus_caballus.EquCab3.0.pep.all.fa.gz',
'GCF_002863925.1_EquCab3.0' => 'equus_caballus/pep/Equus_caballus.EquCab3.0.pep.all.fa.gz',
'equCab3' => 'equus_caballus/pep/Equus_caballus.EquCab3.0.pep.all.fa.gz',
'GCA_900747795.2_fErpCal1.1' => 'erpetoichthys_calabaricus/pep/Erpetoichthys_calabaricus.fErpCal1.1.pep.all.fa.gz',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus/pep/Erpetoichthys_calabaricus.fErpCal1.1.pep.all.fa.gz',
'GCA_003676055.1_GouldianFinch' => 'erythrura_gouldiae/pep/Erythrura_gouldiae.GouldianFinch.pep.all.fa.gz',
'GCA_000721915.3_Eluc_V3' => 'esox_lucius/pep/Esox_lucius.Eluc_V3.pep.all.fa.gz',
'GCF_004634155.1_Eluc_v4' => 'esox_lucius/pep/Esox_lucius.Eluc_v4.pep.all.fa.gz',
'GCA_000181335.4_Felis_catus_9.0' => 'felis_catus/pep/Felis_catus.Felis_catus_9.0.pep.all.fa.gz',
'GCF_000181335.3_Felis_catus_9.0' => 'felis_catus/pep/Felis_catus.Felis_catus_9.0.pep.all.fa.gz',
'felCat9' => 'felis_catus/pep/Felis_catus.Felis_catus_9.0.pep.all.fa.gz',
'GCA_000743615.1_DMR_v1.0' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'GCF_000743615.1_DMR_v1.0' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'fukDam1' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'GCA_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/pep/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.pep.all.fa.gz',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/pep/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.pep.all.fa.gz',
'GCA_000002315.5_GRCg6a' => 'gallus_gallus/pep/Gallus_gallus.GRCg6a.pep.all.fa.gz',
'GCF_000002315.6_GRCg6a' => 'gallus_gallus/pep/Gallus_gallus.GRCg6a.pep.all.fa.gz',
'galGal6' => 'gallus_gallus/pep/Gallus_gallus.GRCg6a.pep.all.fa.gz',
'GCA_003097735.1_ASM309773v1' => 'gambusia_affinis/pep/Gambusia_affinis.ASM309773v1.pep.all.fa.gz',
'GCA_000277835.1_GeoFor_1.0' => 'geospiza_fortis/pep/Geospiza_fortis.GeoFor_1.0.pep.all.fa.gz',
'GCF_000277835.1_GeoFor_1.0' => 'geospiza_fortis/pep/Geospiza_fortis.GeoFor_1.0.pep.all.fa.gz',
'geoFor1' => 'geospiza_fortis/pep/Geospiza_fortis.GeoFor_1.0.pep.all.fa.gz',
'GCA_002896415.1_ASM289641v1' => 'gopherus_agassizii/pep/Gopherus_agassizii.ASM289641v1.pep.all.fa.gz',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor4.pep.all.fa.gz',
'gorGor4' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor4.pep.all.fa.gz',
'GCA_900634775.1_fGouWil2.1' => 'gouania_willdenowi/pep/Gouania_willdenowi.fGouWil2.1.pep.all.fa.gz',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi/pep/Gouania_willdenowi.fGouWil2.1.pep.all.fa.gz',
'GCA_000239415.1_AstBur1.0' => 'haplochromis_burtoni/pep/Haplochromis_burtoni.AstBur1.0.pep.all.fa.gz',
'GCF_000239415.1_AstBur1.0' => 'haplochromis_burtoni/pep/Haplochromis_burtoni.AstBur1.0.pep.all.fa.gz',
'hapBur1' => 'haplochromis_burtoni/pep/Haplochromis_burtoni.AstBur1.0.pep.all.fa.gz',
'GCA_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'GCF_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'hetGla2' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'GCA_000230445.1_HetGla_1.0' => 'heterocephalus_glaber_male/pep/Heterocephalus_glaber_male.HetGla_1.0.pep.all.fa.gz',
'hetGla1' => 'heterocephalus_glaber_male/pep/Heterocephalus_glaber_male.HetGla_1.0.pep.all.fa.gz',
'GCA_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/pep/Hippocampus_comes.H_comes_QL1_v1.pep.all.fa.gz',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/pep/Hippocampus_comes.H_comes_QL1_v1.pep.all.fa.gz',
'GCA_003317085.1_ASM331708v1' => 'hucho_hucho/pep/Hucho_hucho.ASM331708v1.pep.all.fa.gz',
'GCA_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/pep/Ictalurus_punctatus.IpCoco_1.2.pep.all.fa.gz',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/pep/Ictalurus_punctatus.IpCoco_1.2.pep.all.fa.gz',
'GCA_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'GCF_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'GCA_000280705.1_JacJac1.0' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'GCF_000280705.1_JacJac1.0' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'jacJac1' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'GCA_003829775.1_ASM382977v1' => 'junco_hyemalis/pep/Junco_hyemalis.ASM382977v1.pep.all.fa.gz',
'GCA_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/pep/Kryptolebias_marmoratus.ASM164957v1.pep.all.fa.gz',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/pep/Kryptolebias_marmoratus.ASM164957v1.pep.all.fa.gz',
'GCA_900080235.1_BallGen_V1' => 'labrus_bergylta/pep/Labrus_bergylta.BallGen_V1.pep.all.fa.gz',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta/pep/Labrus_bergylta.BallGen_V1.pep.all.fa.gz',
'GCA_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/pep/Larimichthys_crocea.L_crocea_2.0.pep.all.fa.gz',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/pep/Larimichthys_crocea.L_crocea_2.0.pep.all.fa.gz',
'GCA_001640805.1_ASM164080v1' => 'lates_calcarifer/pep/Lates_calcarifer.ASB_HGAPassembly_v1.pep.all.fa.gz',
'GCA_900066035.1_ASB_HGAPassembly_v1' => 'lates_calcarifer/pep/Lates_calcarifer.ASB_HGAPassembly_v1.pep.all.fa.gz',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer/pep/Lates_calcarifer.ASB_HGAPassembly_v1.pep.all.fa.gz',
'GCA_004320025.1_latLat_1.0' => 'laticauda_laticaudata/pep/Laticauda_laticaudata.latLat_1.0.pep.all.fa.gz',
'GCA_000225785.1_LatCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'GCF_000225785.1_LatCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'GCA_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/pep/Lepidothrix_coronata.Lepidothrix_coronata-1.0.pep.all.fa.gz',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/pep/Lepidothrix_coronata.Lepidothrix_coronata-1.0.pep.all.fa.gz',
'GCA_000242695.1_LepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'GCF_000242695.1_LepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'GCA_002197715.1_LonStrDom1' => 'lonchura_striata_domestica/pep/Lonchura_striata_domestica.LonStrDom1.pep.all.fa.gz',
'GCA_000001905.1_Loxafr3.0' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'GCF_000001905.1_Loxafr3.0' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'GCA_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/pep/Lynx_canadensis.mLynCan4_v1.p.pep.all.fa.gz',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/pep/Lynx_canadensis.mLynCan4_v1.p.pep.all.fa.gz',
'GCA_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_5.0.pep.all.fa.gz',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_5.0.pep.all.fa.gz',
'macFas5' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_5.0.pep.all.fa.gz',
'GCA_003339765.3_Mmul_10' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_10.pep.all.fa.gz',
'GCF_003339765.1_Mmul_10' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_10.pep.all.fa.gz',
'rheMac10' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_10.pep.all.fa.gz',
'GCA_000956065.1_Mnem_1.0' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'macNem1' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'GCA_001715985.2_ASM171598v2' => 'manacus_vitellinus/pep/Manacus_vitellinus.ASM171598v2.pep.all.fa.gz',
'GCA_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'GCF_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'manLeu1' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'GCA_001458135.1_marMar2.1' => 'marmota_marmota_marmota/pep/Marmota_marmota_marmota.marMar2.1.pep.all.fa.gz',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota/pep/Marmota_marmota_marmota.marMar2.1.pep.all.fa.gz',
'GCA_900324485.1_fMasArm1.1' => 'mastacembelus_armatus/pep/Mastacembelus_armatus.fMasArm1.1.pep.all.fa.gz',
'GCF_900324485.1_fMasArm1.1' => 'mastacembelus_armatus/pep/Mastacembelus_armatus.fMasArm1.1.pep.all.fa.gz',
'GCF_900324485.2_fMasArm1.2' => 'mastacembelus_armatus/pep/Mastacembelus_armatus.fMasArm1.1.pep.all.fa.gz',
'GCA_000238955.5_M_zebra_UMD2a' => 'maylandia_zebra/pep/Maylandia_zebra.M_zebra_UMD2a.pep.all.fa.gz',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra/pep/Maylandia_zebra.M_zebra_UMD2a.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.Turkey_2.01.pep.all.fa.gz',
'GCA_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/pep/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.pep.all.fa.gz',
'GCF_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/pep/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.pep.all.fa.gz',
'melUnd1' => 'melopsittacus_undulatus/pep/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.pep.all.fa.gz',
'GCA_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/pep/Meriones_unguiculatus.MunDraft-v1.0.pep.all.fa.gz',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/pep/Meriones_unguiculatus.MunDraft-v1.0.pep.all.fa.gz',
'GCA_000349665.1_MesAur1.0' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'GCF_000349665.1_MesAur1.0' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'mesAur1' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'GCA_000165445.3_Mmur_3.0' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'GCF_000165445.2_Mmur_3.0' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'micMur3' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'GCA_000317375.1_MicOch1.0' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'GCF_000317375.1_MicOch1.0' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'micOch1' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'GCA_001698575.1_ASM169857v1' => 'mola_mola/pep/Mola_mola.ASM169857v1.pep.all.fa.gz',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica/pep/Monodelphis_domestica.ASM229v1.pep.all.fa.gz',
'GCF_005190385.1_NGI_Narwhal_1' => 'monodon_monoceros/pep/Monodon_monoceros.NGI_Narwhal_1.pep.all.fa.gz',
'GCA_001952655.1_M_albus_1.0' => 'monopterus_albus/pep/Monopterus_albus.M_albus_1.0.pep.all.fa.gz',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus/pep/Monopterus_albus.M_albus_1.0.pep.all.fa.gz',
'GCA_004024705.2_MosMos_v2_BIUU_UCD' => 'moschus_moschiferus/pep/Moschus_moschiferus.MosMos_v2_BIUU_UCD.pep.all.fa.gz',
'GCA_900094665.2_CAROLI_EIJ_v1.1' => 'mus_caroli/pep/Mus_caroli.CAROLI_EIJ_v1.1.pep.all.fa.gz',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli/pep/Mus_caroli.CAROLI_EIJ_v1.1.pep.all.fa.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/pep/Mus_musculus_129s1svimj.129S1_SvImJ_v1.pep.all.fa.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/pep/Mus_musculus_aj.A_J_v1.pep.all.fa.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/pep/Mus_musculus_akrj.AKR_J_v1.pep.all.fa.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_balbcj.BALB_cJ_v1.pep.all.fa.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/pep/Mus_musculus_c3hhej.C3H_HeJ_v1.pep.all.fa.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/pep/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.pep.all.fa.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/pep/Mus_musculus_casteij.CAST_EiJ_v1.pep.all.fa.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_cbaj.CBA_J_v1.pep.all.fa.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/pep/Mus_musculus_dba2j.DBA_2J_v1.pep.all.fa.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/pep/Mus_musculus_fvbnj.FVB_NJ_v1.pep.all.fa.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/pep/Mus_musculus_lpj.LP_J_v1.pep.all.fa.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/pep/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.pep.all.fa.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/pep/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.pep.all.fa.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/pep/Mus_musculus_pwkphj.PWK_PhJ_v1.pep.all.fa.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/pep/Mus_musculus_wsbeij.WSB_EiJ_v1.pep.all.fa.gz',
'GCA_900095145.2_PAHARI_EIJ_v1.1' => 'mus_pahari/pep/Mus_pahari.PAHARI_EIJ_v1.1.pep.all.fa.gz',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari/pep/Mus_pahari.PAHARI_EIJ_v1.1.pep.all.fa.gz',
'GCA_003336285.1_MUSP714' => 'mus_spicilegus/pep/Mus_spicilegus.MUSP714.pep.all.fa.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/pep/Mus_spretus.SPRET_EiJ_v1.pep.all.fa.gz',
'GCA_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'GCF_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'GCA_000147115.1_Myoluc2.0' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'GCF_000147115.1_Myoluc2.0' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'GCA_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/pep/Myripristis_murdjan.fMyrMur1.1.pep.all.fa.gz',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/pep/Myripristis_murdjan.fMyrMur1.1.pep.all.fa.gz',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'GCF_000622305.1_S.galili_v1.0' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'nanGal1' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'GCA_007210695.1_RGoby_Basel_V2' => 'neogobius_melanostomus/pep/Neogobius_melanostomus.RGoby_Basel_V2.pep.all.fa.gz',
'GCA_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/pep/Neolamprologus_brichardi.NeoBri1.0.pep.all.fa.gz',
'GCF_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/pep/Neolamprologus_brichardi.NeoBri1.0.pep.all.fa.gz',
'neoBri1' => 'neolamprologus_brichardi/pep/Neolamprologus_brichardi.NeoBri1.0.pep.all.fa.gz',
'GCA_900108605.1_NNQGG.v01' => 'neovison_vison/pep/Neovison_vison.NNQGG.v01.pep.all.fa.gz',
'GCA_000146795.3_Nleu_3.0' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu_3.0.pep.all.fa.gz',
'nomLeu3' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu_3.0.pep.all.fa.gz',
'GCA_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/pep/Notechis_scutatus.TS10Xv2-PRI.pep.all.fa.gz',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/pep/Notechis_scutatus.TS10Xv2-PRI.pep.all.fa.gz',
'GCF_001465895.1_Nfu_20140520' => 'nothobranchius_furzeri/pep/Nothobranchius_furzeri.Nfu_20140520.pep.all.fa.gz',
'GCA_003342845.1_notPer1' => 'nothoprocta_perdicaria/pep/Nothoprocta_perdicaria.notPer1.pep.all.fa.gz',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria/pep/Nothoprocta_perdicaria.notPer1.pep.all.fa.gz',
'GCA_002078875.2_NumMel1.0' => 'numida_meleagris/pep/Numida_meleagris.NumMel1.0.pep.all.fa.gz',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris/pep/Numida_meleagris.NumMel1.0.pep.all.fa.gz',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'GCF_000260255.1_OctDeg1.0' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'octDeg1' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'GCF_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss/pep/Oncorhynchus_mykiss.Omyk_1.0.pep.all.fa.gz',
'GCF_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha/pep/Oncorhynchus_tshawytscha.Otsh_v1.0.pep.all.fa.gz',
'GCA_005870065.1_ASM587006v1' => 'oreochromis_aureus/pep/Oreochromis_aureus.ASM587006v1.pep.all.fa.gz',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus/pep/Oreochromis_aureus.ASM587006v1.pep.all.fa.gz',
'GCA_001858045.3_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.O_niloticus_UMD_NMBU.pep.all.fa.gz',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.O_niloticus_UMD_NMBU.pep.all.fa.gz',
'GCF_004115215.1_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.mOrnAna1.p.v1.pep.all.fa.gz',
'GCA_000003625.1_OryCun2.0' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'GCF_000003625.3_OryCun2.0' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'GCA_003999625.1_OJAV_1.1' => 'oryzias_javanicus/pep/Oryzias_javanicus.OJAV_1.1.pep.all.fa.gz',
'GCA_002234675.1_ASM223467v1' => 'oryzias_latipes/pep/Oryzias_latipes.ASM223467v1.pep.all.fa.gz',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes/pep/Oryzias_latipes.ASM223467v1.pep.all.fa.gz',
'GCA_002234715.1_ASM223471v1' => 'oryzias_latipes_hni/pep/Oryzias_latipes_hni.ASM223471v1.pep.all.fa.gz',
'GCA_002234695.1_ASM223469v1' => 'oryzias_latipes_hsok/pep/Oryzias_latipes_hsok.ASM223469v1.pep.all.fa.gz',
'GCA_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/pep/Oryzias_melastigma.Om_v0.7.RACA.pep.all.fa.gz',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/pep/Oryzias_melastigma.Om_v0.7.RACA.pep.all.fa.gz',
'GCA_008586565.1_ASM858656v1' => 'oryzias_sinensis/pep/Oryzias_sinensis.ASM858656v1.pep.all.fa.gz',
'GCA_000181295.3_OtoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'GCA_000298735.1_Oar_v3.1' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'GCF_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet/pep/Ovis_aries_rambouillet.Oar_rambouillet_v1.0.pep.all.fa.gz',
'GCA_000258655.2_panpan1.1' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'GCF_000258655.2_panpan1.1' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'panPan2' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'GCA_000001515.5_Pan_tro_3.0' => 'pan_troglodytes/pep/Pan_troglodytes.Pan_tro_3.0.pep.all.fa.gz',
'panTro5' => 'pan_troglodytes/pep/Pan_troglodytes.Pan_tro_3.0.pep.all.fa.gz',
'GCA_008795835.1_PanLeo1.0' => 'panthera_leo/pep/Panthera_leo.PanLeo1.0.pep.all.fa.gz',
'GCA_001857705.1_PanPar1.0' => 'panthera_pardus/pep/Panthera_pardus.PanPar1.0.pep.all.fa.gz',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus/pep/Panthera_pardus.PanPar1.0.pep.all.fa.gz',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/pep/Panthera_tigris_altaica.PanTig1.0.pep.all.fa.gz',
'GCF_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/pep/Panthera_tigris_altaica.PanTig1.0.pep.all.fa.gz',
'panTig1' => 'panthera_tigris_altaica/pep/Panthera_tigris_altaica.PanTig1.0.pep.all.fa.gz',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'GCF_000264685.3_Panu_3.0' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'papAnu4' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'GCA_900634625.1_fParRan2.1' => 'parambassis_ranga/pep/Parambassis_ranga.fParRan2.1.pep.all.fa.gz',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga/pep/Parambassis_ranga.fParRan2.1.pep.all.fa.gz',
'GCA_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/pep/Paramormyrops_kingsleyae.PKINGS_0.1.pep.all.fa.gz',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/pep/Paramormyrops_kingsleyae.PKINGS_0.1.pep.all.fa.gz',
'GCA_001522545.2_Parus_major1.1' => 'parus_major/pep/Parus_major.Parus_major1.1.pep.all.fa.gz',
'GCF_001522545.3_Parus_major1.1' => 'parus_major/pep/Parus_major.Parus_major1.1.pep.all.fa.gz',
'GCA_005519975.1_AIIM_Pcri_1.0' => 'pavo_cristatus/pep/Pavo_cristatus.AIIM_Pcri_1.0.pep.all.fa.gz',
'GCA_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'GCF_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'GCA_007922175.1_Pelusios_castaneus-1.0' => 'pelusios_castaneus/pep/Pelusios_castaneus.Pelusios_castaneus-1.0.pep.all.fa.gz',
'GCA_000787105.1_PM.fa' => 'periophthalmus_magnuspinnatus/pep/Periophthalmus_magnuspinnatus.PM.fa.pep.all.fa.gz',
'GCA_003704035.1_HU_Pman_2.1' => 'peromyscus_maniculatus_bairdii/pep/Peromyscus_maniculatus_bairdii.HU_Pman_2.1.pep.all.fa.gz',
'GCA_000148955.1_Petromyzon_marinus-7.0' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'GCA_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/pep/Phascolarctos_cinereus.phaCin_unsw_v4.1.pep.all.fa.gz',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/pep/Phascolarctos_cinereus.phaCin_unsw_v4.1.pep.all.fa.gz',
'GCA_004143745.1_ASM414374v1' => 'phasianus_colchicus/pep/Phasianus_colchicus.ASM414374v1.pep.all.fa.gz',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus/pep/Phasianus_colchicus.ASM414374v1.pep.all.fa.gz',
'GCF_008692025.1_mPhoSin1.pri' => 'phocoena_sinus/pep/Phocoena_sinus.mPhoSin1.pri.pep.all.fa.gz',
'GCA_002837175.2_ASM283717v2' => 'physeter_catodon/pep/Physeter_catodon.ASM283717v2.pep.all.fa.gz',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon/pep/Physeter_catodon.ASM283717v2.pep.all.fa.gz',
'GCA_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/pep/Piliocolobus_tephrosceles.ASM277652v2.pep.all.fa.gz',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/pep/Piliocolobus_tephrosceles.ASM277652v2.pep.all.fa.gz',
'GCA_004329235.1_PodMur_1.0' => 'podarcis_muralis/pep/Podarcis_muralis.PodMur_1.0.pep.all.fa.gz',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis/pep/Podarcis_muralis.PodMur_1.0.pep.all.fa.gz',
'GCA_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'GCF_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'GCA_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/pep/Poecilia_latipinna.P_latipinna-1.0.pep.all.fa.gz',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/pep/Poecilia_latipinna.P_latipinna-1.0.pep.all.fa.gz',
'GCA_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/pep/Poecilia_mexicana.P_mexicana-1.0.pep.all.fa.gz',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/pep/Poecilia_mexicana.P_mexicana-1.0.pep.all.fa.gz',
'GCA_000633615.2_Guppy_female_1.0_MT' => 'poecilia_reticulata/pep/Poecilia_reticulata.Guppy_female_1.0_MT.pep.all.fa.gz',
'GCF_000633615.1_Guppy_female_1.0_MT' => 'poecilia_reticulata/pep/Poecilia_reticulata.Guppy_female_1.0_MT.pep.all.fa.gz',
'poeRet1' => 'poecilia_reticulata/pep/Poecilia_reticulata.Guppy_female_1.0_MT.pep.all.fa.gz',
'GCA_900067755.1_pvi1.1' => 'pogona_vitticeps/pep/Pogona_vitticeps.pvi1.1.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus/pep/Prolemur_simus.Prosim_1.0.pep.all.fa.gz',
'GCA_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'GCF_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'proCoq1' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'GCA_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/pep/Pseudonaja_textilis.EBS10Xv2-PRI.pep.all.fa.gz',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/pep/Pseudonaja_textilis.EBS10Xv2-PRI.pep.all.fa.gz',
'GCA_000239375.1_PunNye1.0' => 'pundamilia_nyererei/pep/Pundamilia_nyererei.PunNye1.0.pep.all.fa.gz',
'GCF_000239375.1_PunNye1.0' => 'pundamilia_nyererei/pep/Pundamilia_nyererei.PunNye1.0.pep.all.fa.gz',
'punNye1' => 'pundamilia_nyererei/pep/Pundamilia_nyererei.PunNye1.0.pep.all.fa.gz',
'GCA_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/pep/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.pep.all.fa.gz',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/pep/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.pep.all.fa.gz',
'GCA_000001895.4_Rnor_6.0' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'GCF_000001895.5_Rnor_6.0' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/pep/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.pep.all.fa.gz',
'GCF_004115265.1_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/pep/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.pep.all.fa.gz',
'GCA_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'GCF_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'rhiBie1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'GCA_000769185.1_Rrox_v1' => 'rhinopithecus_roxellana/pep/Rhinopithecus_roxellana.Rrox_v1.pep.all.fa.gz',
'rhiRox1' => 'rhinopithecus_roxellana/pep/Rhinopithecus_roxellana.Rrox_v1.pep.all.fa.gz',
'GCA_000146045.2_R64-1-1' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'GCA_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'GCF_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'GCA_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/pep/Salarias_fasciatus.fSalaFa1.1.pep.all.fa.gz',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/pep/Salarias_fasciatus.fSalaFa1.1.pep.all.fa.gz',
'GCA_000233375.4_ICSASG_v2' => 'salmo_salar/pep/Salmo_salar.ICSASG_v2.pep.all.fa.gz',
'GCA_901001165.1_fSalTru1.1' => 'salmo_trutta/pep/Salmo_trutta.fSalTru1.1.pep.all.fa.gz',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta/pep/Salmo_trutta.fSalTru1.1.pep.all.fa.gz',
'GCA_003586115.1_HLtupMer3' => 'salvator_merianae/pep/Salvator_merianae.HLtupMer3.pep.all.fa.gz',
'GCF_008315115.1_SLUC_FBN_1' => 'sander_lucioperca/pep/Sander_lucioperca.SLUC_FBN_1.pep.all.fa.gz',
'GCA_000189315.1_Devil_ref_v7.0' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'GCF_000189315.1_Devil_ref_v7.0' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'sarHar1' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.DEVIL7.0.pep.all.fa.gz',
'GCA_902686455.1_mSciVul1.1' => 'sciurus_vulgaris/pep/Sciurus_vulgaris.mSciVul1.1.pep.all.fa.gz',
'GCA_900964775.1_fSclFor1.1' => 'scleropages_formosus/pep/Scleropages_formosus.fSclFor1.1.pep.all.fa.gz',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus/pep/Scleropages_formosus.fSclFor1.1.pep.all.fa.gz',
'GCA_003186165.1_ASM318616v1' => 'scophthalmus_maximus/pep/Scophthalmus_maximus.ASM318616v1.pep.all.fa.gz',
'GCA_000534875.1_SCA1' => 'serinus_canaria/pep/Serinus_canaria.SCA1.pep.all.fa.gz',
'serCan1' => 'serinus_canaria/pep/Serinus_canaria.SCA1.pep.all.fa.gz',
'GCA_002260705.1_Sdu_1.0' => 'seriola_dumerili/pep/Seriola_dumerili.Sdu_1.0.pep.all.fa.gz',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili/pep/Seriola_dumerili.Sdu_1.0.pep.all.fa.gz',
'GCA_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/pep/Seriola_lalandi_dorsalis.Sedor1.pep.all.fa.gz',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/pep/Seriola_lalandi_dorsalis.Sedor1.pep.all.fa.gz',
'GCA_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/pep/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.pep.all.fa.gz',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/pep/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.pep.all.fa.gz',
'GCA_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/pep/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.pep.all.fa.gz',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/pep/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.pep.all.fa.gz',
'GCA_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/pep/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.pep.all.fa.gz',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/pep/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.pep.all.fa.gz',
'GCA_900880675.1_fSpaAur1.1' => 'sparus_aurata/pep/Sparus_aurata.fSpaAur1.1.pep.all.fa.gz',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata/pep/Sparus_aurata.fSpaAur1.1.pep.all.fa.gz',
'GCA_002406435.1_ASM240643v1' => 'spermophilus_dauricus/pep/Spermophilus_dauricus.ASM240643v1.pep.all.fa.gz',
'GCA_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/pep/Sphaeramia_orbicularis.fSphaOr1.1.pep.all.fa.gz',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/pep/Sphaeramia_orbicularis.fSphaOr1.1.pep.all.fa.gz',
'GCA_003113815.1_ASM311381v1' => 'sphenodon_punctatus/pep/Sphenodon_punctatus.ASM311381v1.pep.all.fa.gz',
'GCA_008694505.1_ASM869450v1' => 'stachyris_ruficeps/pep/Stachyris_ruficeps.ASM869450v1.pep.all.fa.gz',
'GCA_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/pep/Stegastes_partitus.Stegastes_partitus-1.0.2.pep.all.fa.gz',
'GCF_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/pep/Stegastes_partitus.Stegastes_partitus-1.0.2.pep.all.fa.gz',
'stePar1' => 'stegastes_partitus/pep/Stegastes_partitus.Stegastes_partitus-1.0.2.pep.all.fa.gz',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/pep/Strigops_habroptila.bStrHab1_v1.p.pep.all.fa.gz',
'GCF_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/pep/Strigops_habroptila.bStrHab1_v1.p.pep.all.fa.gz',
'GCA_002372975.1_Soccid_v01' => 'strix_occidentalis_caurina/pep/Strix_occidentalis_caurina.Soccid_v01.pep.all.fa.gz',
'GCA_000698965.1_ASM69896v1' => 'struthio_camelus_australis/pep/Struthio_camelus_australis.ASM69896v1.pep.all.fa.gz',
'GCF_000698965.1_ASM69896v1' => 'struthio_camelus_australis/pep/Struthio_camelus_australis.ASM69896v1.pep.all.fa.gz',
'strCam1' => 'struthio_camelus_australis/pep/Struthio_camelus_australis.ASM69896v1.pep.all.fa.gz',
'GCA_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/pep/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.pep.all.fa.gz',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/pep/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.pep.all.fa.gz',
'GCA_000003025.6_Sscrofa11.1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'GCF_000003025.6_Sscrofa11.1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'susScr11' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'GCA_001700235.1_Bamei_pig_v1' => 'sus_scrofa_bamei/pep/Sus_scrofa_bamei.Bamei_pig_v1.pep.all.fa.gz',
'GCA_001700575.1_Berkshire_pig_v1' => 'sus_scrofa_berkshire/pep/Sus_scrofa_berkshire.Berkshire_pig_v1.pep.all.fa.gz',
'GCA_001700165.1_Hampshire_pig_v1' => 'sus_scrofa_hampshire/pep/Sus_scrofa_hampshire.Hampshire_pig_v1.pep.all.fa.gz',
'GCA_001700295.1_Jinhua_pig_v1' => 'sus_scrofa_jinhua/pep/Sus_scrofa_jinhua.Jinhua_pig_v1.pep.all.fa.gz',
'GCA_001700215.1_Landrace_pig_v1' => 'sus_scrofa_landrace/pep/Sus_scrofa_landrace.Landrace_pig_v1.pep.all.fa.gz',
'GCA_001700135.1_Large_White_v1' => 'sus_scrofa_largewhite/pep/Sus_scrofa_largewhite.Large_White_v1.pep.all.fa.gz',
'GCA_001700195.1_Meishan_pig_v1' => 'sus_scrofa_meishan/pep/Sus_scrofa_meishan.Meishan_pig_v1.pep.all.fa.gz',
'GCA_001700255.1_Pietrain_pig_v1' => 'sus_scrofa_pietrain/pep/Sus_scrofa_pietrain.Pietrain_pig_v1.pep.all.fa.gz',
'GCA_001700155.1_Rongchang_pig_v1' => 'sus_scrofa_rongchang/pep/Sus_scrofa_rongchang.Rongchang_pig_v1.pep.all.fa.gz',
'GCA_000472085.2_Tibetan_Pig_v2' => 'sus_scrofa_tibetan/pep/Sus_scrofa_tibetan.Tibetan_Pig_v2.pep.all.fa.gz',
'GCA_002844635.1_USMARCv1.0' => 'sus_scrofa_usmarc/pep/Sus_scrofa_usmarc.USMARCv1.0.pep.all.fa.gz',
'GCA_000325925.2_minipig_v1.0' => 'sus_scrofa_wuzhishan/pep/Sus_scrofa_wuzhishan.minipig_v1.0.pep.all.fa.gz',
'GCA_003957565.2_bTaeGut1_v1.p' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.bTaeGut1_v1.p.pep.all.fa.gz',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.bTaeGut1_v1.p.pep.all.fa.gz',
'GCA_901000725.2_fTakRub1.2' => 'takifugu_rubripes/pep/Takifugu_rubripes.fTakRub1.2.pep.all.fa.gz',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes/pep/Takifugu_rubripes.fTakRub1.2.pep.all.fa.gz',
'GCA_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis/pep/Terrapene_carolina_triunguis.T_m_triunguis-2.0.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada/pep/Theropithecus_gelada.Tgel_1.0.pep.all.fa.gz',
'GCF_003255815.1_Tgel_1.0' => 'theropithecus_gelada/pep/Theropithecus_gelada.Tgel_1.0.pep.all.fa.gz',
'GCA_003426925.1_ASM342692v1' => 'urocitellus_parryii/pep/Urocitellus_parryii.ASM342692v1.pep.all.fa.gz',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii/pep/Urocitellus_parryii.ASM342692v1.pep.all.fa.gz',
'GCA_003344425.1_ASM334442v1' => 'ursus_americanus/pep/Ursus_americanus.ASM334442v1.pep.all.fa.gz',
'GCA_000687225.1_UrsMar_1.0' => 'ursus_maritimus/pep/Ursus_maritimus.UrsMar_1.0.pep.all.fa.gz',
'GCF_000687225.1_UrsMar_1.0' => 'ursus_maritimus/pep/Ursus_maritimus.UrsMar_1.0.pep.all.fa.gz',
'ursMar1' => 'ursus_maritimus/pep/Ursus_maritimus.UrsMar_1.0.pep.all.fa.gz',
'GCA_004798865.1_ASM479886v1' => 'varanus_komodoensis/pep/Varanus_komodoensis.ASM479886v1.pep.all.fa.gz',
'GCA_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/pep/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.pep.all.fa.gz',
'GCF_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/pep/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.pep.all.fa.gz',
'GCA_003160815.1_VulVul2.2' => 'vulpes_vulpes/pep/Vulpes_vulpes.VulVul2.2.pep.all.fa.gz',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes/pep/Vulpes_vulpes.VulVul2.2.pep.all.fa.gz',
'GCA_000004195.3_Xenopus_tropicalis_v9.1' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.pep.all.fa.gz',
'xenTro9' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.pep.all.fa.gz',
'GCA_001444195.1_Xiphophorus_couchianus-4.0.1' => 'xiphophorus_couchianus/pep/Xiphophorus_couchianus.Xiphophorus_couchianus-4.0.1.pep.all.fa.gz',
'GCA_002775205.2_X_maculatus-5.0-male' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.X_maculatus-5.0-male.pep.all.fa.gz',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.X_maculatus-5.0-male.pep.all.fa.gz',
'GCA_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/pep/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.pep.all.fa.gz',
'GCF_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/pep/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.pep.all.fa.gz',
'zonAlb1' => 'zonotrichia_albicollis/pep/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.pep.all.fa.gz',
'GCA_001281735.1_ASM128173v1' => 'zosterops_lateralis_melanops/pep/Zosterops_lateralis_melanops.ASM128173v1.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_101 = (
'GCA_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus_core_101_1',
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus_core_101_1',
'GCA_004320145.1_Accipiter_nisus_ver1.0' => 'accipiter_nisus_core_101_1',
'GCA_000004335.1_AilMel_1.0' => 'ailuropoda_melanoleuca_core_101_1',
'GCF_000004335.2_AilMel_1.0' => 'ailuropoda_melanoleuca_core_101_1',
'ailMel1' => 'ailuropoda_melanoleuca_core_101_1',
'GCA_003947215.1_ASM394721v1' => 'amazona_collaria_core_101_1',
'GCA_000751415.1_Midas_v5' => 'amphilophus_citrinellus_core_101_5',
'GCA_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris_core_101_1',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris_core_101_1',
'GCA_003047355.1_Nemo_v1' => 'amphiprion_percula_core_101_1',
'GCA_900324465.1_fAnaTes1.1' => 'anabas_testudineus_core_101_11',
'GCF_900324465.1_fAnaTes1.1' => 'anabas_testudineus_core_101_11',
'GCA_008746955.1_ASM874695v1' => 'anas_platyrhynchos_core_101_1',
'GCA_002743455.1_CAU_duck1.0' => 'anas_platyrhynchos_platyrhynchos_core_101_1',
'GCA_002224875.1_ASM222487v1' => 'anas_zonorhyncha_core_101_1',
'GCA_000090745.2_AnoCar2.0' => 'anolis_carolinensis_core_101_2',
'GCF_000090745.1_AnoCar2.0' => 'anolis_carolinensis_core_101_2',
'anoCar2' => 'anolis_carolinensis_core_101_2',
'GCA_002592135.1_ASM259213v1' => 'anser_brachyrhynchus_core_101_1',
'GCA_002166845.1_GooseV1.0' => 'anser_cygnoides_core_101_1',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae_core_101_1',
'GCF_000952055.2_Anan_2.0' => 'aotus_nancymaae_core_101_1',
'aotNan1' => 'aotus_nancymaae_core_101_1',
'GCA_003342985.1_aptHaa1' => 'apteryx_haastii_core_101_1',
'GCA_003342965.1_aptOwe1' => 'apteryx_owenii_core_101_1',
'GCA_003343035.1_aptRow1' => 'apteryx_rowi_core_101_1',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi_core_101_1',
'GCA_900496995.2_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos_core_101_12',
'GCF_900496995.1_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos_core_101_12',
'GCA_900246225.3_fAstCal1.2' => 'astatotilapia_calliptera_core_101_12',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera_core_101_12',
'GCA_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus_core_101_2',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus_core_101_2',
'GCA_004802775.1_Astyanax_mexicanus-1.0.2' => 'astyanax_mexicanus_pachon_core_101_102',
'astMex1' => 'astyanax_mexicanus_pachon_core_101_102',
'GCA_003259725.1_athCun1' => 'athene_cunicularia_core_101_1',
'GCF_003259725.1_athCun1' => 'athene_cunicularia_core_101_1',
'GCA_900634795.2_fBetSpl5.2' => 'betta_splendens_core_101_52',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens_core_101_52',
'GCA_000754665.1_Bison_UMD1.0' => 'bison_bison_bison_core_101_1',
'bisBis1' => 'bison_bison_bison_core_101_1',
'GCA_005887515.1_LU_Bosgru_v3.0' => 'bos_grunniens_core_101_3',
'GCA_003369695.2_UOA_Brahman_1' => 'bos_indicus_hybrid_core_101_1',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid_core_101_1',
'GCA_000298355.1_BosGru_v2.0' => 'bos_mutus_core_101_2',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus_core_101_2',
'bosMut1' => 'bos_mutus_core_101_2',
'GCA_002263795.2_ARS-UCD1.2' => 'bos_taurus_core_101_12',
'GCF_002263795.1_ARS-UCD1.2' => 'bos_taurus_core_101_12',
'bosTau9' => 'bos_taurus_core_101_12',
'GCA_003369685.2_UOA_Angus_1' => 'bos_taurus_hybrid_core_101_1',
'ce11' => 'caenorhabditis_elegans_core_101_269',
'GCA_001431845.1_ASM143184v1' => 'calidris_pugnax_core_101_1',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax_core_101_1',
'GCA_003697955.1_ASM369795v1' => 'calidris_pygmaea_core_101_1',
'GCA_002754865.1_ASM275486v1' => 'callithrix_jacchus_core_101_1',
'GCA_000165045.2_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii_core_101_613',
'GCF_000165045.1_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii_core_101_613',
'calMil1' => 'callorhinchus_milii_core_101_613',
'GCA_901933205.1_STF_HiC' => 'camarhynchus_parvulus_core_101_1',
'GCF_901933205.1_STF_HiC' => 'camarhynchus_parvulus_core_101_1',
'GCA_000803125.2_CamDro2' => 'camelus_dromedarius_core_101_2',
'GCA_003254725.1_ASM325472v1' => 'canis_lupus_dingo_core_101_1',
'GCF_003254725.1_ASM325472v1' => 'canis_lupus_dingo_core_101_1',
'GCF_000002285.3_CanFam3.1' => 'canis_lupus_familiaris_core_101_31',
'canFam3' => 'canis_lupus_familiaris_core_101_31',
'GCA_004886185.1_Basenji_breed-1.1' => 'canis_lupus_familiarisbasenji_core_101_11',
'GCA_005444595.1_UMICH_Zoey_3.1' => 'canis_lupus_familiarisgreatdane_core_101_31',
'canFam5' => 'canis_lupus_familiarisgreatdane_core_101_31',
'GCA_001704415.1_ARS1' => 'capra_hircus_core_101_1',
'GCF_001704415.1_ARS1' => 'capra_hircus_core_101_1',
'GCA_004361675.1_CVASU_BBG_1.0' => 'capra_hircus_blackbengal_core_101_1',
'GCF_003368295.1_ASM336829v1' => 'carassius_auratus_core_101_1',
'GCA_000164805.2_Tarsius_syrichta-2.0.1' => 'carlito_syrichta_core_101_2',
'GCF_000164805.1_Tarsius_syrichta-2.0.1' => 'carlito_syrichta_core_101_2',
'tarSyr2' => 'carlito_syrichta_core_101_2',
'GCA_001984765.1_C.can_genome_v1.0' => 'castor_canadensis_core_101_1',
'GCF_001984765.1_C.can_genome_v1.0' => 'castor_canadensis_core_101_1',
'casCan1' => 'castor_canadensis_core_101_1',
'GCA_004024745.2_CatWag_v2_BIUU_UCD' => 'catagonus_wagneri_core_101_2',
'GCF_009819885.1_bCatUst1.pri' => 'catharus_ustulatus_core_101_1',
'GCA_000688575.1_CavAp1.0' => 'cavia_aperea_core_101_10',
'cavApe1' => 'cavia_aperea_core_101_10',
'GCA_000151735.1_Cavpor3.0' => 'cavia_porcellus_core_101_4',
'GCF_000151735.1_Cavpor3.0' => 'cavia_porcellus_core_101_4',
'cavPor3' => 'cavia_porcellus_core_101_4',
'GCA_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus_core_101_1',
'GCF_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus_core_101_1',
'cebCap1' => 'cebus_capucinus_core_101_1',
'GCA_000955945.1_Caty_1.0' => 'cercocebus_atys_core_101_1',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys_core_101_1',
'cerAty1' => 'cercocebus_atys_core_101_1',
'GCA_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii_core_101_1',
'GCA_007922165.1_Chelydra_serpentina-1.0' => 'chelydra_serpentina_core_101_1',
'GCA_000276665.1_ChiLan1.0' => 'chinchilla_lanigera_core_101_1',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera_core_101_1',
'chiLan1' => 'chinchilla_lanigera_core_101_1',
'GCA_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus_core_101_1',
'GCF_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus_core_101_1',
'chlSab2' => 'chlorocebus_sabaeus_core_101_1',
'GCA_000241765.2_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii_core_101_303',
'GCF_000241765.3_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii_core_101_303',
'chrPic2' => 'chrysemys_picta_bellii_core_101_303',
'GCA_003413605.1_Chrysolophus_pictus_GenomeV1.0' => 'chrysolophus_pictus_core_101_1',
'ci3' => 'ciona_intestinalis_core_101_3',
'cioSav2' => 'ciona_savignyi_core_101_2',
'GCA_900700415.1_Ch_v2.0.2' => 'clupea_harengus_core_101_202',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus_core_101_202',
'GCA_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus_core_101_1',
'GCF_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus_core_101_1',
'colAng1' => 'colobus_angolensis_palliatus_core_101_1',
'GCA_900634415.1_fCotGob3.1' => 'cottoperca_gobio_core_101_31',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio_core_101_31',
'GCA_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica_core_101_2',
'GCA_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica_core_101_2',
'GCF_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica_core_101_2',
'GCF_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica_core_101_2',
'cotJap2' => 'coturnix_japonica_core_101_2',
'GCA_900186095.1_CHOK1S_HZDv1' => 'cricetulus_griseus_chok1gshd_core_101_1',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd_core_101_1',
'GCA_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri_core_101_1',
'GCF_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri_core_101_1',
'criGriChoV1' => 'cricetulus_griseus_crigri_core_101_1',
'GCA_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr_core_101_1',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr_core_101_1',
'GCA_001723895.1_CroPor_comp1' => 'crocodylus_porosus_core_101_1',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus_core_101_1',
'GCA_002901205.1_cyaCae2' => 'cyanistes_caeruleus_core_101_2',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus_core_101_2',
'GCA_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis_core_101_1',
'GCF_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis_core_101_1',
'cynSem1' => 'cynoglossus_semilaevis_core_101_1',
'GCA_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus_core_101_1',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus_core_101_1',
'cypVar1' => 'cyprinodon_variegatus_core_101_1',
'GCF_000951615.1_common_carp_genome' => 'cyprinus_carpio_core_101_2',
'GCA_004011555.1_German_Mirror_carp_1.0' => 'cyprinus_carpio_germanmirror_core_101_10',
'GCA_004011595.1_Hebao_red_carp_1.0' => 'cyprinus_carpio_hebaored_core_101_10',
'GCA_004011575.1_Hunaghe_carp_2.0' => 'cyprinus_carpio_huanghe_core_101_20',
'GCA_000208655.2_Dasnov3.0' => 'dasypus_novemcinctus_core_101_3',
'GCF_000208655.1_Dasnov3.0' => 'dasypus_novemcinctus_core_101_3',
'dasNov3' => 'dasypus_novemcinctus_core_101_3',
'GCF_002288925.2_ASM228892v3' => 'delphinapterus_leucas_core_101_3',
'GCA_900700375.1_fDenClu1.1' => 'denticeps_clupeoides_core_101_11',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides_core_101_11',
'GCA_000689215.1_seabass_V1.0' => 'dicentrarchus_labrax_core_101_1',
'dicLab1' => 'dicentrarchus_labrax_core_101_1',
'GCA_000151885.2_Dord_2.0' => 'dipodomys_ordii_core_101_2',
'GCF_000151885.1_Dord_2.0' => 'dipodomys_ordii_core_101_2',
'dipOrd2' => 'dipodomys_ordii_core_101_2',
'GCA_003342905.1_droNov1' => 'dromaius_novaehollandiae_core_101_1',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae_core_101_1',
'dm6' => 'drosophila_melanogaster_core_101_8',
'GCA_900963305.1_fEcheNa1.1' => 'echeneis_naucrates_core_101_11',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates_core_101_11',
'GCA_003665695.2_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus_core_101_2',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus_core_101_2',
'GCA_900186335.2_Eburgeri_3.2' => 'eptatretus_burgeri_core_101_32',
'GCA_003033725.1_ASM303372v1' => 'equus_asinus_asinus_core_101_1',
'GCA_002863925.1_EquCab3.0' => 'equus_caballus_core_101_3',
'GCF_002863925.1_EquCab3.0' => 'equus_caballus_core_101_3',
'equCab3' => 'equus_caballus_core_101_3',
'GCA_900747795.2_fErpCal1.1' => 'erpetoichthys_calabaricus_core_101_11',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus_core_101_11',
'GCA_003676055.1_GouldianFinch' => 'erythrura_gouldiae_core_101_1',
'GCA_000721915.3_Eluc_V3' => 'esox_lucius_core_101_4',
'GCF_004634155.1_Eluc_v4' => 'esox_lucius_core_101_4',
'GCA_000181335.4_Felis_catus_9.0' => 'felis_catus_core_101_9',
'GCF_000181335.3_Felis_catus_9.0' => 'felis_catus_core_101_9',
'felCat9' => 'felis_catus_core_101_9',
'GCA_000743615.1_DMR_v1.0' => 'fukomys_damarensis_core_101_1',
'GCF_000743615.1_DMR_v1.0' => 'fukomys_damarensis_core_101_1',
'fukDam1' => 'fukomys_damarensis_core_101_1',
'GCA_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus_core_101_302',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus_core_101_302',
'GCA_000002315.5_GRCg6a' => 'gallus_gallus_core_101_6',
'GCF_000002315.6_GRCg6a' => 'gallus_gallus_core_101_6',
'galGal6' => 'gallus_gallus_core_101_6',
'GCA_003097735.1_ASM309773v1' => 'gambusia_affinis_core_101_1',
'GCA_000277835.1_GeoFor_1.0' => 'geospiza_fortis_core_101_1',
'GCF_000277835.1_GeoFor_1.0' => 'geospiza_fortis_core_101_1',
'geoFor1' => 'geospiza_fortis_core_101_1',
'GCA_002896415.1_ASM289641v1' => 'gopherus_agassizii_core_101_1',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla_core_101_4',
'gorGor4' => 'gorilla_gorilla_core_101_4',
'GCA_900634775.1_fGouWil2.1' => 'gouania_willdenowi_core_101_21',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi_core_101_21',
'GCA_000239415.1_AstBur1.0' => 'haplochromis_burtoni_core_101_1',
'GCF_000239415.1_AstBur1.0' => 'haplochromis_burtoni_core_101_1',
'hapBur1' => 'haplochromis_burtoni_core_101_1',
'GCA_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female_core_101_1',
'GCF_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female_core_101_1',
'hetGla2' => 'heterocephalus_glaber_female_core_101_1',
'GCA_000230445.1_HetGla_1.0' => 'heterocephalus_glaber_male_core_101_1',
'hetGla1' => 'heterocephalus_glaber_male_core_101_1',
'GCA_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes_core_101_1',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes_core_101_1',
'GCA_003317085.1_ASM331708v1' => 'hucho_hucho_core_101_1',
'GCA_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus_core_101_12',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus_core_101_12',
'GCA_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus_core_101_3',
'GCF_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus_core_101_3',
'speTri2' => 'ictidomys_tridecemlineatus_core_101_3',
'GCA_000280705.1_JacJac1.0' => 'jaculus_jaculus_core_101_10',
'GCF_000280705.1_JacJac1.0' => 'jaculus_jaculus_core_101_10',
'jacJac1' => 'jaculus_jaculus_core_101_10',
'GCA_003829775.1_ASM382977v1' => 'junco_hyemalis_core_101_1',
'GCA_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus_core_101_1',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus_core_101_1',
'GCA_900080235.1_BallGen_V1' => 'labrus_bergylta_core_101_1',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta_core_101_1',
'GCA_000972845.2_L_crocea_2.0' => 'larimichthys_crocea_core_101_20',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea_core_101_20',
'GCA_001640805.1_ASM164080v1' => 'lates_calcarifer_core_101_1',
'GCA_900066035.1_ASB_HGAPassembly_v1' => 'lates_calcarifer_core_101_1',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer_core_101_1',
'GCA_004320025.1_latLat_1.0' => 'laticauda_laticaudata_core_101_1',
'GCA_000225785.1_LatCha1' => 'latimeria_chalumnae_core_101_1',
'GCF_000225785.1_LatCha1' => 'latimeria_chalumnae_core_101_1',
'latCha1' => 'latimeria_chalumnae_core_101_1',
'GCA_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata_core_101_1',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata_core_101_1',
'GCA_000242695.1_LepOcu1' => 'lepisosteus_oculatus_core_101_1',
'GCF_000242695.1_LepOcu1' => 'lepisosteus_oculatus_core_101_1',
'lepOcu1' => 'lepisosteus_oculatus_core_101_1',
'GCA_002197715.1_LonStrDom1' => 'lonchura_striata_domestica_core_101_1',
'GCA_000001905.1_Loxafr3.0' => 'loxodonta_africana_core_101_3',
'GCF_000001905.1_Loxafr3.0' => 'loxodonta_africana_core_101_3',
'loxAfr3' => 'loxodonta_africana_core_101_3',
'GCA_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis_core_101_41',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis_core_101_41',
'GCA_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis_core_101_5',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis_core_101_5',
'macFas5' => 'macaca_fascicularis_core_101_5',
'GCA_003339765.3_Mmul_10' => 'macaca_mulatta_core_101_10',
'GCF_003339765.1_Mmul_10' => 'macaca_mulatta_core_101_10',
'rheMac10' => 'macaca_mulatta_core_101_10',
'GCA_000956065.1_Mnem_1.0' => 'macaca_nemestrina_core_101_1',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina_core_101_1',
'macNem1' => 'macaca_nemestrina_core_101_1',
'GCA_001715985.2_ASM171598v2' => 'manacus_vitellinus_core_101_2',
'GCA_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus_core_101_1',
'GCF_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus_core_101_1',
'manLeu1' => 'mandrillus_leucophaeus_core_101_1',
'GCA_001458135.1_marMar2.1' => 'marmota_marmota_marmota_core_101_21',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota_core_101_21',
'GCA_900324485.1_fMasArm1.1' => 'mastacembelus_armatus_core_101_11',
'GCF_900324485.1_fMasArm1.1' => 'mastacembelus_armatus_core_101_11',
'GCF_900324485.2_fMasArm1.2' => 'mastacembelus_armatus_core_101_11',
'GCA_000238955.5_M_zebra_UMD2a' => 'maylandia_zebra_core_101_2',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra_core_101_2',
'melGal1' => 'meleagris_gallopavo_core_101_21',
'GCA_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus_core_101_63',
'GCF_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus_core_101_63',
'melUnd1' => 'melopsittacus_undulatus_core_101_63',
'GCA_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus_core_101_1',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus_core_101_1',
'GCA_000349665.1_MesAur1.0' => 'mesocricetus_auratus_core_101_10',
'GCF_000349665.1_MesAur1.0' => 'mesocricetus_auratus_core_101_10',
'mesAur1' => 'mesocricetus_auratus_core_101_10',
'GCA_000165445.3_Mmur_3.0' => 'microcebus_murinus_core_101_3',
'GCF_000165445.2_Mmur_3.0' => 'microcebus_murinus_core_101_3',
'micMur3' => 'microcebus_murinus_core_101_3',
'GCA_000317375.1_MicOch1.0' => 'microtus_ochrogaster_core_101_10',
'GCF_000317375.1_MicOch1.0' => 'microtus_ochrogaster_core_101_10',
'micOch1' => 'microtus_ochrogaster_core_101_10',
'GCA_001698575.1_ASM169857v1' => 'mola_mola_core_101_1',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica_core_101_1',
'GCF_005190385.1_NGI_Narwhal_1' => 'monodon_monoceros_core_101_1',
'GCA_001952655.1_M_albus_1.0' => 'monopterus_albus_core_101_1',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus_core_101_1',
'GCA_004024705.2_MosMos_v2_BIUU_UCD' => 'moschus_moschiferus_core_101_2',
'GCA_900094665.2_CAROLI_EIJ_v1.1' => 'mus_caroli_core_101_11',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli_core_101_11',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj_core_101_1',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj_core_101_1',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj_core_101_1',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj_core_101_1',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej_core_101_1',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj_core_101_1',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij_core_101_1',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj_core_101_1',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j_core_101_1',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj_core_101_1',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj_core_101_1',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj_core_101_1',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj_core_101_1',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj_core_101_1',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij_core_101_1',
'GCA_900095145.2_PAHARI_EIJ_v1.1' => 'mus_pahari_core_101_11',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari_core_101_11',
'GCA_003336285.1_MUSP714' => 'mus_spicilegus_core_101_714',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_core_101_1',
'GCA_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo_core_101_1',
'GCF_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo_core_101_1',
'musFur1' => 'mustela_putorius_furo_core_101_1',
'GCA_000147115.1_Myoluc2.0' => 'myotis_lucifugus_core_101_2',
'GCF_000147115.1_Myoluc2.0' => 'myotis_lucifugus_core_101_2',
'myoLuc2' => 'myotis_lucifugus_core_101_2',
'GCA_902150065.1_fMyrMur1.1' => 'myripristis_murdjan_core_101_11',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan_core_101_11',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili_core_101_10',
'GCF_000622305.1_S.galili_v1.0' => 'nannospalax_galili_core_101_10',
'nanGal1' => 'nannospalax_galili_core_101_10',
'GCA_007210695.1_RGoby_Basel_V2' => 'neogobius_melanostomus_core_101_2',
'GCA_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi_core_101_1',
'GCF_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi_core_101_1',
'neoBri1' => 'neolamprologus_brichardi_core_101_1',
'GCA_900108605.1_NNQGG.v01' => 'neovison_vison_core_101_1',
'GCA_000146795.3_Nleu_3.0' => 'nomascus_leucogenys_core_101_3',
'nomLeu3' => 'nomascus_leucogenys_core_101_3',
'GCA_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus_core_101_2',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus_core_101_2',
'GCF_001465895.1_Nfu_20140520' => 'nothobranchius_furzeri_core_101_2',
'GCA_003342845.1_notPer1' => 'nothoprocta_perdicaria_core_101_1',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria_core_101_1',
'GCA_002078875.2_NumMel1.0' => 'numida_meleagris_core_101_1',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris_core_101_1',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus_core_101_1',
'GCF_000260255.1_OctDeg1.0' => 'octodon_degus_core_101_1',
'octDeg1' => 'octodon_degus_core_101_1',
'GCF_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss_core_101_1',
'GCF_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha_core_101_1',
'GCA_005870065.1_ASM587006v1' => 'oreochromis_aureus_core_101_1',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus_core_101_1',
'GCA_001858045.3_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus_core_101_3',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus_core_101_3',
'GCF_004115215.1_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus_core_101_1',
'GCA_000003625.1_OryCun2.0' => 'oryctolagus_cuniculus_core_101_2',
'GCF_000003625.3_OryCun2.0' => 'oryctolagus_cuniculus_core_101_2',
'oryCun2' => 'oryctolagus_cuniculus_core_101_2',
'GCA_003999625.1_OJAV_1.1' => 'oryzias_javanicus_core_101_11',
'GCA_002234675.1_ASM223467v1' => 'oryzias_latipes_core_101_1',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes_core_101_1',
'GCA_002234715.1_ASM223471v1' => 'oryzias_latipes_hni_core_101_1',
'GCA_002234695.1_ASM223469v1' => 'oryzias_latipes_hsok_core_101_1',
'GCA_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma_core_101_07',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma_core_101_07',
'GCA_008586565.1_ASM858656v1' => 'oryzias_sinensis_core_101_1',
'GCA_000181295.3_OtoGar3' => 'otolemur_garnettii_core_101_3',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii_core_101_3',
'otoGar3' => 'otolemur_garnettii_core_101_3',
'GCA_000298735.1_Oar_v3.1' => 'ovis_aries_core_101_31',
'oviAri3' => 'ovis_aries_core_101_31',
'GCF_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet_core_101_1',
'GCA_000258655.2_panpan1.1' => 'pan_paniscus_core_101_1',
'GCF_000258655.2_panpan1.1' => 'pan_paniscus_core_101_1',
'panPan2' => 'pan_paniscus_core_101_1',
'GCA_000001515.5_Pan_tro_3.0' => 'pan_troglodytes_core_101_3',
'panTro5' => 'pan_troglodytes_core_101_3',
'GCA_008795835.1_PanLeo1.0' => 'panthera_leo_core_101_1',
'GCA_001857705.1_PanPar1.0' => 'panthera_pardus_core_101_1',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus_core_101_1',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica_core_101_1',
'GCF_000464555.1_PanTig1.0' => 'panthera_tigris_altaica_core_101_1',
'panTig1' => 'panthera_tigris_altaica_core_101_1',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis_core_101_3',
'GCF_000264685.3_Panu_3.0' => 'papio_anubis_core_101_3',
'papAnu4' => 'papio_anubis_core_101_3',
'GCA_900634625.1_fParRan2.1' => 'parambassis_ranga_core_101_21',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga_core_101_21',
'GCA_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae_core_101_1',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae_core_101_1',
'GCA_001522545.2_Parus_major1.1' => 'parus_major_core_101_1',
'GCF_001522545.3_Parus_major1.1' => 'parus_major_core_101_1',
'GCA_005519975.1_AIIM_Pcri_1.0' => 'pavo_cristatus_core_101_1',
'GCA_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis_core_101_1',
'GCF_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis_core_101_1',
'pelSin1' => 'pelodiscus_sinensis_core_101_1',
'GCA_007922175.1_Pelusios_castaneus-1.0' => 'pelusios_castaneus_core_101_1',
'GCA_000787105.1_PM.fa' => 'periophthalmus_magnuspinnatus_core_101_1',
'GCA_003704035.1_HU_Pman_2.1' => 'peromyscus_maniculatus_bairdii_core_101_21',
'GCA_000148955.1_Petromyzon_marinus-7.0' => 'petromyzon_marinus_core_101_7',
'petMar2' => 'petromyzon_marinus_core_101_7',
'GCA_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus_core_101_41',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus_core_101_41',
'GCA_004143745.1_ASM414374v1' => 'phasianus_colchicus_core_101_1',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus_core_101_1',
'GCF_008692025.1_mPhoSin1.pri' => 'phocoena_sinus_core_101_1',
'GCA_002837175.2_ASM283717v2' => 'physeter_catodon_core_101_2',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon_core_101_2',
'GCA_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles_core_101_2',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles_core_101_2',
'GCA_004329235.1_PodMur_1.0' => 'podarcis_muralis_core_101_1',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis_core_101_1',
'GCA_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa_core_101_512',
'GCF_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa_core_101_512',
'poeFor1' => 'poecilia_formosa_core_101_512',
'GCA_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna_core_101_1',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna_core_101_1',
'GCA_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana_core_101_1',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana_core_101_1',
'GCA_000633615.2_Guppy_female_1.0_MT' => 'poecilia_reticulata_core_101_1',
'GCF_000633615.1_Guppy_female_1.0_MT' => 'poecilia_reticulata_core_101_1',
'poeRet1' => 'poecilia_reticulata_core_101_1',
'GCA_900067755.1_pvi1.1' => 'pogona_vitticeps_core_101_11',
'ponAbe2' => 'pongo_abelii_core_101_1',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus_core_101_1',
'GCA_000956105.1_Pcoq_1.0' => 'propithecus_coquereli_core_101_1',
'GCF_000956105.1_Pcoq_1.0' => 'propithecus_coquereli_core_101_1',
'proCoq1' => 'propithecus_coquereli_core_101_1',
'GCA_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis_core_101_2',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis_core_101_2',
'GCA_000239375.1_PunNye1.0' => 'pundamilia_nyererei_core_101_1',
'GCF_000239375.1_PunNye1.0' => 'pundamilia_nyererei_core_101_1',
'punNye1' => 'pundamilia_nyererei_core_101_1',
'GCA_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri_core_101_102',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri_core_101_102',
'GCA_000001895.4_Rnor_6.0' => 'rattus_norvegicus_core_101_6',
'GCF_000001895.5_Rnor_6.0' => 'rattus_norvegicus_core_101_6',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum_core_101_1',
'GCF_004115265.1_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum_core_101_1',
'GCA_001698545.1_ASM169854v1' => 'rhinopithecus_bieti_core_101_1',
'GCF_001698545.1_ASM169854v1' => 'rhinopithecus_bieti_core_101_1',
'rhiBie1' => 'rhinopithecus_bieti_core_101_1',
'GCA_000769185.1_Rrox_v1' => 'rhinopithecus_roxellana_core_101_1',
'rhiRox1' => 'rhinopithecus_roxellana_core_101_1',
'GCA_000146045.2_R64-1-1' => 'saccharomyces_cerevisiae_core_101_4',
'sacCer3' => 'saccharomyces_cerevisiae_core_101_4',
'GCA_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis_core_101_1',
'GCF_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis_core_101_1',
'saiBol1' => 'saimiri_boliviensis_boliviensis_core_101_1',
'GCA_902148845.1_fSalaFa1.1' => 'salarias_fasciatus_core_101_11',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus_core_101_11',
'GCA_000233375.4_ICSASG_v2' => 'salmo_salar_core_101_2',
'GCA_901001165.1_fSalTru1.1' => 'salmo_trutta_core_101_11',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta_core_101_11',
'GCA_003586115.1_HLtupMer3' => 'salvator_merianae_core_101_3',
'GCF_008315115.1_SLUC_FBN_1' => 'sander_lucioperca_core_101_1',
'GCA_000189315.1_Devil_ref_v7.0' => 'sarcophilus_harrisii_core_101_7',
'GCF_000189315.1_Devil_ref_v7.0' => 'sarcophilus_harrisii_core_101_7',
'sarHar1' => 'sarcophilus_harrisii_core_101_7',
'GCA_902686455.1_mSciVul1.1' => 'sciurus_vulgaris_core_101_1',
'GCA_900964775.1_fSclFor1.1' => 'scleropages_formosus_core_101_11',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus_core_101_11',
'GCA_003186165.1_ASM318616v1' => 'scophthalmus_maximus_core_101_1',
'GCA_000534875.1_SCA1' => 'serinus_canaria_core_101_12',
'serCan1' => 'serinus_canaria_core_101_12',
'GCA_002260705.1_Sdu_1.0' => 'seriola_dumerili_core_101_1',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili_core_101_1',
'GCA_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis_core_101_1',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis_core_101_1',
'GCA_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis_core_101_11',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis_core_101_11',
'GCA_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami_core_101_11',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami_core_101_11',
'GCA_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous_core_101_11',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous_core_101_11',
'GCA_900880675.1_fSpaAur1.1' => 'sparus_aurata_core_101_11',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata_core_101_11',
'GCA_002406435.1_ASM240643v1' => 'spermophilus_dauricus_core_101_1',
'GCA_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis_core_101_11',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis_core_101_11',
'GCA_003113815.1_ASM311381v1' => 'sphenodon_punctatus_core_101_1',
'GCA_008694505.1_ASM869450v1' => 'stachyris_ruficeps_core_101_1',
'GCA_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus_core_101_1',
'GCF_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus_core_101_1',
'stePar1' => 'stegastes_partitus_core_101_1',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila_core_101_11',
'GCF_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila_core_101_11',
'GCA_002372975.1_Soccid_v01' => 'strix_occidentalis_caurina_core_101_1',
'GCA_000698965.1_ASM69896v1' => 'struthio_camelus_australis_core_101_1',
'GCF_000698965.1_ASM69896v1' => 'struthio_camelus_australis_core_101_1',
'strCam1' => 'struthio_camelus_australis_core_101_1',
'GCA_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta_core_101_1',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta_core_101_1',
'GCA_000003025.6_Sscrofa11.1' => 'sus_scrofa_core_101_111',
'GCF_000003025.6_Sscrofa11.1' => 'sus_scrofa_core_101_111',
'susScr11' => 'sus_scrofa_core_101_111',
'GCA_001700235.1_Bamei_pig_v1' => 'sus_scrofa_bamei_core_101_1',
'GCA_001700575.1_Berkshire_pig_v1' => 'sus_scrofa_berkshire_core_101_1',
'GCA_001700165.1_Hampshire_pig_v1' => 'sus_scrofa_hampshire_core_101_1',
'GCA_001700295.1_Jinhua_pig_v1' => 'sus_scrofa_jinhua_core_101_1',
'GCA_001700215.1_Landrace_pig_v1' => 'sus_scrofa_landrace_core_101_1',
'GCA_001700135.1_Large_White_v1' => 'sus_scrofa_largewhite_core_101_1',
'GCA_001700195.1_Meishan_pig_v1' => 'sus_scrofa_meishan_core_101_1',
'GCA_001700255.1_Pietrain_pig_v1' => 'sus_scrofa_pietrain_core_101_1',
'GCA_001700155.1_Rongchang_pig_v1' => 'sus_scrofa_rongchang_core_101_1',
'GCA_000472085.2_Tibetan_Pig_v2' => 'sus_scrofa_tibetan_core_101_2',
'GCA_002844635.1_USMARCv1.0' => 'sus_scrofa_usmarc_core_101_1',
'GCA_000325925.2_minipig_v1.0' => 'sus_scrofa_wuzhishan_core_101_10',
'GCA_003957565.2_bTaeGut1_v1.p' => 'taeniopygia_guttata_core_101_12',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata_core_101_12',
'GCA_901000725.2_fTakRub1.2' => 'takifugu_rubripes_core_101_12',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes_core_101_12',
'GCA_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis_core_101_2',
'tetNig2' => 'tetraodon_nigroviridis_core_101_8',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada_core_101_1',
'GCF_003255815.1_Tgel_1.0' => 'theropithecus_gelada_core_101_1',
'GCA_003426925.1_ASM342692v1' => 'urocitellus_parryii_core_101_1',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii_core_101_1',
'GCA_003344425.1_ASM334442v1' => 'ursus_americanus_core_101_1',
'GCA_000687225.1_UrsMar_1.0' => 'ursus_maritimus_core_101_1',
'GCF_000687225.1_UrsMar_1.0' => 'ursus_maritimus_core_101_1',
'ursMar1' => 'ursus_maritimus_core_101_1',
'GCA_004798865.1_ASM479886v1' => 'varanus_komodoensis_core_101_1',
'GCA_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus_core_101_1',
'GCF_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus_core_101_1',
'GCA_003160815.1_VulVul2.2' => 'vulpes_vulpes_core_101_22',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes_core_101_22',
'GCA_000004195.3_Xenopus_tropicalis_v9.1' => 'xenopus_tropicalis_core_101_91',
'xenTro9' => 'xenopus_tropicalis_core_101_91',
'GCA_001444195.1_Xiphophorus_couchianus-4.0.1' => 'xiphophorus_couchianus_core_101_401',
'GCA_002775205.2_X_maculatus-5.0-male' => 'xiphophorus_maculatus_core_101_5',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus_core_101_5',
'GCA_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis_core_101_101',
'GCF_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis_core_101_101',
'zonAlb1' => 'zonotrichia_albicollis_core_101_101',
'GCA_001281735.1_ASM128173v1' => 'zosterops_lateralis_melanops_core_101_1',
);

my %ensGeneGtfFileNames_103 = (
'GCA_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/Acanthochromis_polyacanthus.ASM210954v1.103.gtf.gz',
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/Acanthochromis_polyacanthus.ASM210954v1.103.gtf.gz',
'GCA_004320145.1_Accipiter_nisus_ver1.0' => 'accipiter_nisus/Accipiter_nisus.Accipiter_nisus_ver1.0.103.gtf.gz',
'GCF_002007445.1_ASM200744v2' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ASM200744v2.103.gtf.gz',
'GCF_000004335.2_AilMel_1.0' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ailMel1.103.gtf.gz',
'GCA_003947215.1_ASM394721v1' => 'amazona_collaria/Amazona_collaria.ASM394721v1.103.gtf.gz',
'GCA_000751415.1_Midas_v5' => 'amphilophus_citrinellus/Amphilophus_citrinellus.Midas_v5.103.gtf.gz',
'GCA_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/Amphiprion_ocellaris.AmpOce1.0.103.gtf.gz',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/Amphiprion_ocellaris.AmpOce1.0.103.gtf.gz',
'GCA_003047355.1_Nemo_v1' => 'amphiprion_percula/Amphiprion_percula.Nemo_v1.103.gtf.gz',
'GCA_900324465.1_fAnaTes1.1' => 'anabas_testudineus/Anabas_testudineus.fAnaTes1.1.103.gtf.gz',
'GCA_900324465.2_fAnaTes1.2' => 'anabas_testudineus/Anabas_testudineus.fAnaTes1.2.103.gtf.gz',
'GCF_900324465.2_fAnaTes1.2' => 'anabas_testudineus/Anabas_testudineus.fAnaTes1.2.103.gtf.gz',
'GCA_008746955.1_ASM874695v1' => 'anas_platyrhynchos/Anas_platyrhynchos.ASM874695v1.103.gtf.gz',
'GCA_002743455.1_CAU_duck1.0' => 'anas_platyrhynchos_platyrhynchos/Anas_platyrhynchos_platyrhynchos.CAU_duck1.0.103.gtf.gz',
'GCA_002224875.1_ASM222487v1' => 'anas_zonorhyncha/Anas_zonorhyncha.ASM222487v1.103.gtf.gz',
'GCA_000090745.2_AnoCar2.0' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.103.gtf.gz',
'GCF_000090745.1_AnoCar2.0' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.103.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0.103.gtf.gz',
'GCA_002592135.1_ASM259213v1' => 'anser_brachyrhynchus/Anser_brachyrhynchus.ASM259213v1.103.gtf.gz',
'GCA_002166845.1_GooseV1.0' => 'anser_cygnoides/Anser_cygnoides.GooseV1.0.103.gtf.gz',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.103.gtf.gz',
'GCF_000952055.2_Anan_2.0' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.103.gtf.gz',
'aotNan1' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.103.gtf.gz',
'GCA_003342985.1_aptHaa1' => 'apteryx_haastii/Apteryx_haastii.aptHaa1.103.gtf.gz',
'GCA_003342965.1_aptOwe1' => 'apteryx_owenii/Apteryx_owenii.aptOwe1.103.gtf.gz',
'GCA_003343035.1_aptRow1' => 'apteryx_rowi/Apteryx_rowi.aptRow1.103.gtf.gz',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi/Apteryx_rowi.aptRow1.103.gtf.gz',
'GCA_900496995.2_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/Aquila_chrysaetos_chrysaetos.bAquChr1.2.103.gtf.gz',
'GCF_900496995.1_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/Aquila_chrysaetos_chrysaetos.bAquChr1.2.103.gtf.gz',
'GCA_900246225.3_fAstCal1.2' => 'astatotilapia_calliptera/Astatotilapia_calliptera.fAstCal1.2.103.gtf.gz',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera/Astatotilapia_calliptera.fAstCal1.2.103.gtf.gz',
'GCA_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/Astyanax_mexicanus.Astyanax_mexicanus-2.0.103.gtf.gz',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/Astyanax_mexicanus.Astyanax_mexicanus-2.0.103.gtf.gz',
'GCA_004802775.1_Astyanax_mexicanus-1.0.2' => 'astyanax_mexicanus_pachon/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.103.gtf.gz',
'astMex1' => 'astyanax_mexicanus_pachon/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.103.gtf.gz',
'GCA_003259725.1_athCun1' => 'athene_cunicularia/Athene_cunicularia.athCun1.103.gtf.gz',
'GCF_003259725.1_athCun1' => 'athene_cunicularia/Athene_cunicularia.athCun1.103.gtf.gz',
'GCA_009873245.2_mBalMus1.v2' => 'balaenoptera_musculus/Balaenoptera_musculus.mBalMus1.v2.103.gtf.gz',
'GCA_900634795.2_fBetSpl5.2' => 'betta_splendens/Betta_splendens.fBetSpl5.2.103.gtf.gz',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens/Betta_splendens.fBetSpl5.2.103.gtf.gz',
'GCA_000754665.1_Bison_UMD1.0' => 'bison_bison_bison/Bison_bison_bison.Bison_UMD1.0.103.gtf.gz',
'bisBis1' => 'bison_bison_bison/Bison_bison_bison.Bison_UMD1.0.103.gtf.gz',
'GCA_005887515.1_LU_Bosgru_v3.0' => 'bos_grunniens/Bos_grunniens.LU_Bosgru_v3.0.103.gtf.gz',
'GCA_003369695.2_UOA_Brahman_1' => 'bos_indicus_hybrid/Bos_indicus_hybrid.UOA_Brahman_1.103.gtf.gz',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid/Bos_indicus_hybrid.UOA_Brahman_1.103.gtf.gz',
'GCA_000298355.1_BosGru_v2.0' => 'bos_mutus/Bos_mutus.BosGru_v2.0.103.gtf.gz',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus/Bos_mutus.BosGru_v2.0.103.gtf.gz',
'bosMut1' => 'bos_mutus/Bos_mutus.BosGru_v2.0.103.gtf.gz',
'GCA_002263795.2_ARS-UCD1.2' => 'bos_taurus/Bos_taurus.ARS-UCD1.2.103.gtf.gz',
'GCF_002263795.1_ARS-UCD1.2' => 'bos_taurus/Bos_taurus.ARS-UCD1.2.103.gtf.gz',
'bosTau9' => 'bos_taurus/Bos_taurus.ARS-UCD1.2.103.gtf.gz',
'GCA_003369685.2_UOA_Angus_1' => 'bos_taurus_hybrid/Bos_taurus_hybrid.UOA_Angus_1.103.gtf.gz',
'GCF_000002985.6_WBcel235' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.103.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.103.gtf.gz',
'GCA_009194515.1_CaiMos1.0' => 'cairina_moschata_domestica/Cairina_moschata_domestica.CaiMos1.0.103.gtf.gz',
'GCA_001431845.1_ASM143184v1' => 'calidris_pugnax/Calidris_pugnax.ASM143184v1.103.gtf.gz',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax/Calidris_pugnax.ASM143184v1.103.gtf.gz',
'GCA_003697955.1_ASM369795v1' => 'calidris_pygmaea/Calidris_pygmaea.ASM369795v1.103.gtf.gz',
'GCA_002754865.1_ASM275486v1' => 'callithrix_jacchus/Callithrix_jacchus.ASM275486v1.103.gtf.gz',
'GCA_000165045.2_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/Callorhinchus_milii.Callorhinchus_milii-6.1.3.103.gtf.gz',
'GCF_000165045.1_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/Callorhinchus_milii.Callorhinchus_milii-6.1.3.103.gtf.gz',
'calMil1' => 'callorhinchus_milii/Callorhinchus_milii.Callorhinchus_milii-6.1.3.103.gtf.gz',
'GCA_901933205.1_STF_HiC' => 'camarhynchus_parvulus/Camarhynchus_parvulus.STF_HiC.103.gtf.gz',
'GCF_901933205.1_STF_HiC' => 'camarhynchus_parvulus/Camarhynchus_parvulus.STF_HiC.103.gtf.gz',
'GCA_000803125.2_CamDro2' => 'camelus_dromedarius/Camelus_dromedarius.CamDro2.103.gtf.gz',
'GCA_003254725.1_ASM325472v1' => 'canis_lupus_dingo/Canis_lupus_dingo.ASM325472v1.103.gtf.gz',
'GCF_003254725.1_ASM325472v1' => 'canis_lupus_dingo/Canis_lupus_dingo.ASM325472v1.103.gtf.gz',
'GCA_000002285.2_CanFam3.1' => 'canis_lupus_familiaris/Canis_lupus_familiaris.CanFam3.1.103.gtf.gz',
'GCF_000002285.3_CanFam3.1' => 'canis_lupus_familiaris/Canis_lupus_familiaris.CanFam3.1.103.gtf.gz',
'canFam3' => 'canis_lupus_familiaris/Canis_lupus_familiaris.CanFam3.1.103.gtf.gz',
'GCA_004886185.1_Basenji_breed-1.1' => 'canis_lupus_familiarisbasenji/Canis_lupus_familiarisbasenji.Basenji_breed-1.1.103.gtf.gz',
'GCA_005444595.1_UMICH_Zoey_3.1' => 'canis_lupus_familiarisgreatdane/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.103.gtf.gz',
'canFam5' => 'canis_lupus_familiarisgreatdane/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.103.gtf.gz',
'GCA_001704415.1_ARS1' => 'capra_hircus/Capra_hircus.ARS1.103.gtf.gz',
'GCF_001704415.1_ARS1' => 'capra_hircus/Capra_hircus.ARS1.103.gtf.gz',
'GCA_004361675.1_CVASU_BBG_1.0' => 'capra_hircus_blackbengal/Capra_hircus_blackbengal.CVASU_BBG_1.0.103.gtf.gz',
'GCA_003368295.1_ASM336829v1' => 'carassius_auratus/Carassius_auratus.ASM336829v1.103.gtf.gz',
'GCF_003368295.1_ASM336829v1' => 'carassius_auratus/Carassius_auratus.ASM336829v1.103.gtf.gz',
'GCA_000164805.2_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.103.gtf.gz',
'GCF_000164805.1_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.103.gtf.gz',
'tarSyr2' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.103.gtf.gz',
'GCA_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/Castor_canadensis.C.can_genome_v1.0.103.gtf.gz',
'GCF_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/Castor_canadensis.C.can_genome_v1.0.103.gtf.gz',
'casCan1' => 'castor_canadensis/Castor_canadensis.C.can_genome_v1.0.103.gtf.gz',
'GCA_004024745.2_CatWag_v2_BIUU_UCD' => 'catagonus_wagneri/Catagonus_wagneri.CatWag_v2_BIUU_UCD.103.gtf.gz',
'GCA_009819885.1_bCatUst1.pri' => 'catharus_ustulatus/Catharus_ustulatus.bCatUst1.pri.103.gtf.gz',
'GCF_009819885.1_bCatUst1.pri' => 'catharus_ustulatus/Catharus_ustulatus.bCatUst1.pri.103.gtf.gz',
'GCA_000688575.1_CavAp1.0' => 'cavia_aperea/Cavia_aperea.CavAp1.0.103.gtf.gz',
'cavApe1' => 'cavia_aperea/Cavia_aperea.CavAp1.0.103.gtf.gz',
'GCA_000151735.1_Cavpor3.0' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.103.gtf.gz',
'GCF_000151735.1_Cavpor3.0' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.103.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.103.gtf.gz',
'GCA_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.103.gtf.gz',
'GCF_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.103.gtf.gz',
'cebCap1' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.103.gtf.gz',
'GCA_000955945.1_Caty_1.0' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.103.gtf.gz',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.103.gtf.gz',
'cerAty1' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.103.gtf.gz',
'GCA_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii/Chelonoidis_abingdonii.ASM359739v1.103.gtf.gz',
'GCF_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii/Chelonoidis_abingdonii.ASM359739v1.103.gtf.gz',
'GCA_007922165.1_Chelydra_serpentina-1.0' => 'chelydra_serpentina/Chelydra_serpentina.Chelydra_serpentina-1.0.103.gtf.gz',
'GCA_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.103.gtf.gz',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.103.gtf.gz',
'chiLan1' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.103.gtf.gz',
'GCA_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.103.gtf.gz',
'GCF_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.103.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.103.gtf.gz',
'GCA_000241765.2_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.103.gtf.gz',
'GCF_000241765.3_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.103.gtf.gz',
'chrPic2' => 'chrysemys_picta_bellii/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.103.gtf.gz',
'GCA_003413605.1_Chrysolophus_pictus_GenomeV1.0' => 'chrysolophus_pictus/Chrysolophus_pictus.Chrysolophus_pictus_GenomeV1.0.103.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.103.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.103.gtf.gz',
'GCA_900700415.1_Ch_v2.0.2' => 'clupea_harengus/Clupea_harengus.Ch_v2.0.2.103.gtf.gz',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus/Clupea_harengus.Ch_v2.0.2.103.gtf.gz',
'GCA_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.103.gtf.gz',
'GCF_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.103.gtf.gz',
'colAng1' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.103.gtf.gz',
'GCA_900634415.1_fCotGob3.1' => 'cottoperca_gobio/Cottoperca_gobio.fCotGob3.1.103.gtf.gz',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio/Cottoperca_gobio.fCotGob3.1.103.gtf.gz',
'GCA_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.103.gtf.gz',
'GCA_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.103.gtf.gz',
'GCF_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.103.gtf.gz',
'GCF_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.103.gtf.gz',
'cotJap2' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.103.gtf.gz',
'GCA_900186095.1_CHOK1S_HZDv1' => 'cricetulus_griseus_chok1gshd/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.103.gtf.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.103.gtf.gz',
'GCA_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.103.gtf.gz',
'GCF_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.103.gtf.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.103.gtf.gz',
'GCA_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/Cricetulus_griseus_picr.CriGri-PICR.103.gtf.gz',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/Cricetulus_griseus_picr.CriGri-PICR.103.gtf.gz',
'GCA_001723895.1_CroPor_comp1' => 'crocodylus_porosus/Crocodylus_porosus.CroPor_comp1.103.gtf.gz',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus/Crocodylus_porosus.CroPor_comp1.103.gtf.gz',
'GCA_002901205.1_cyaCae2' => 'cyanistes_caeruleus/Cyanistes_caeruleus.cyaCae2.103.gtf.gz',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus/Cyanistes_caeruleus.cyaCae2.103.gtf.gz',
'GCA_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus/Cyclopterus_lumpus.fCycLum1.pri.103.gtf.gz',
'GCF_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus/Cyclopterus_lumpus.fCycLum1.pri.103.gtf.gz',
'GCA_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/Cynoglossus_semilaevis.Cse_v1.0.103.gtf.gz',
'GCF_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/Cynoglossus_semilaevis.Cse_v1.0.103.gtf.gz',
'cynSem1' => 'cynoglossus_semilaevis/Cynoglossus_semilaevis.Cse_v1.0.103.gtf.gz',
'GCA_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/Cyprinodon_variegatus.C_variegatus-1.0.103.gtf.gz',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/Cyprinodon_variegatus.C_variegatus-1.0.103.gtf.gz',
'cypVar1' => 'cyprinodon_variegatus/Cyprinodon_variegatus.C_variegatus-1.0.103.gtf.gz',
'GCA_000951615.2_common_carp_genome' => 'cyprinus_carpio/Cyprinus_carpio.common_carp_genome.103.gtf.gz',
'GCF_000951615.1_common_carp_genome' => 'cyprinus_carpio/Cyprinus_carpio.common_carp_genome.103.gtf.gz',
'GCA_004011555.1_German_Mirror_carp_1.0' => 'cyprinus_carpio_germanmirror/Cyprinus_carpio_germanmirror.German_Mirror_carp_1.0.103.gtf.gz',
'GCA_004011595.1_Hebao_red_carp_1.0' => 'cyprinus_carpio_hebaored/Cyprinus_carpio_hebaored.Hebao_red_carp_1.0.103.gtf.gz',
'GCA_004011575.1_Hunaghe_carp_2.0' => 'cyprinus_carpio_huanghe/Cyprinus_carpio_huanghe.Hunaghe_carp_2.0.103.gtf.gz',
'GCA_000208655.2_Dasnov3.0' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.103.gtf.gz',
'GCF_000208655.1_Dasnov3.0' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.103.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.103.gtf.gz',
'GCA_002288925.3_ASM228892v3' => 'delphinapterus_leucas/Delphinapterus_leucas.ASM228892v3.103.gtf.gz',
'GCF_002288925.2_ASM228892v3' => 'delphinapterus_leucas/Delphinapterus_leucas.ASM228892v3.103.gtf.gz',
'GCA_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/Denticeps_clupeoides.fDenClu1.1.103.gtf.gz',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/Denticeps_clupeoides.fDenClu1.1.103.gtf.gz',
'GCA_000689215.1_seabass_V1.0' => 'dicentrarchus_labrax/Dicentrarchus_labrax.seabass_V1.0.103.gtf.gz',
'dicLab1' => 'dicentrarchus_labrax/Dicentrarchus_labrax.seabass_V1.0.103.gtf.gz',
'GCA_000151885.2_Dord_2.0' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.103.gtf.gz',
'GCF_000151885.1_Dord_2.0' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.103.gtf.gz',
'dipOrd2' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.103.gtf.gz',
'GCA_003342905.1_droNov1' => 'dromaius_novaehollandiae/Dromaius_novaehollandiae.droNov1.103.gtf.gz',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae/Dromaius_novaehollandiae.droNov1.103.gtf.gz',
'GCF_000001215.4_Release_6_plus_ISO1_MT' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.32.103.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.32.103.gtf.gz',
'GCA_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/Echeneis_naucrates.fEcheNa1.1.103.gtf.gz',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/Echeneis_naucrates.fEcheNa1.1.103.gtf.gz',
'GCA_003665695.2_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.103.gtf.gz',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.103.gtf.gz',
'GCA_900186335.2_Eburgeri_3.2' => 'eptatretus_burgeri/Eptatretus_burgeri.Eburgeri_3.2.103.gtf.gz',
'GCA_003033725.1_ASM303372v1' => 'equus_asinus_asinus/Equus_asinus_asinus.ASM303372v1.103.gtf.gz',
'GCA_002863925.1_EquCab3.0' => 'equus_caballus/Equus_caballus.EquCab3.0.103.gtf.gz',
'GCF_002863925.1_EquCab3.0' => 'equus_caballus/Equus_caballus.EquCab3.0.103.gtf.gz',
'equCab3' => 'equus_caballus/Equus_caballus.EquCab3.0.103.gtf.gz',
'GCA_900747795.2_fErpCal1.1' => 'erpetoichthys_calabaricus/Erpetoichthys_calabaricus.fErpCal1.1.103.gtf.gz',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus/Erpetoichthys_calabaricus.fErpCal1.1.103.gtf.gz',
'GCA_003676055.1_GouldianFinch' => 'erythrura_gouldiae/Erythrura_gouldiae.GouldianFinch.103.gtf.gz',
'GCA_004634155.1_Eluc_v4' => 'esox_lucius/Esox_lucius.Eluc_v4.103.gtf.gz',
'GCF_004634155.1_Eluc_v4' => 'esox_lucius/Esox_lucius.Eluc_v4.103.gtf.gz',
'GCA_000181335.4_Felis_catus_9.0' => 'felis_catus/Felis_catus.Felis_catus_9.0.103.gtf.gz',
'GCF_000181335.3_Felis_catus_9.0' => 'felis_catus/Felis_catus.Felis_catus_9.0.103.gtf.gz',
'felCat9' => 'felis_catus/Felis_catus.Felis_catus_9.0.103.gtf.gz',
'GCA_000743615.1_DMR_v1.0' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.103.gtf.gz',
'GCF_000743615.1_DMR_v1.0' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.103.gtf.gz',
'fukDam1' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.103.gtf.gz',
'GCA_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.103.gtf.gz',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.103.gtf.gz',
'GCA_902167405.1_gadMor3.0' => 'gadus_morhua/Gadus_morhua.gadMor3.0.103.gtf.gz',
'GCF_902167405.1_gadMor3.0' => 'gadus_morhua/Gadus_morhua.gadMor3.0.103.gtf.gz',
'GCA_000002315.5_GRCg6a' => 'gallus_gallus/Gallus_gallus.GRCg6a.103.gtf.gz',
'GCF_000002315.6_GRCg6a' => 'gallus_gallus/Gallus_gallus.GRCg6a.103.gtf.gz',
'galGal6' => 'gallus_gallus/Gallus_gallus.GRCg6a.103.gtf.gz',
'GCA_003097735.1_ASM309773v1' => 'gambusia_affinis/Gambusia_affinis.ASM309773v1.103.gtf.gz',
'GCA_000277835.1_GeoFor_1.0' => 'geospiza_fortis/Geospiza_fortis.GeoFor_1.0.103.gtf.gz',
'GCF_000277835.1_GeoFor_1.0' => 'geospiza_fortis/Geospiza_fortis.GeoFor_1.0.103.gtf.gz',
'geoFor1' => 'geospiza_fortis/Geospiza_fortis.GeoFor_1.0.103.gtf.gz',
'GCA_002896415.1_ASM289641v1' => 'gopherus_agassizii/Gopherus_agassizii.ASM289641v1.103.gtf.gz',
'GCA_007399415.1_rGopEvg1_v1.p' => 'gopherus_evgoodei/Gopherus_evgoodei.rGopEvg1_v1.p.103.gtf.gz',
'GCF_007399415.2_rGopEvg1_v1.p' => 'gopherus_evgoodei/Gopherus_evgoodei.rGopEvg1_v1.p.103.gtf.gz',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla/Gorilla_gorilla.gorGor4.103.gtf.gz',
'gorGor4' => 'gorilla_gorilla/Gorilla_gorilla.gorGor4.103.gtf.gz',
'GCA_900634775.1_fGouWil2.1' => 'gouania_willdenowi/Gouania_willdenowi.fGouWil2.1.103.gtf.gz',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi/Gouania_willdenowi.fGouWil2.1.103.gtf.gz',
'GCA_000239415.1_AstBur1.0' => 'haplochromis_burtoni/Haplochromis_burtoni.AstBur1.0.103.gtf.gz',
'GCF_000239415.1_AstBur1.0' => 'haplochromis_burtoni/Haplochromis_burtoni.AstBur1.0.103.gtf.gz',
'hapBur1' => 'haplochromis_burtoni/Haplochromis_burtoni.AstBur1.0.103.gtf.gz',
'GCA_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.103.gtf.gz',
'GCF_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.103.gtf.gz',
'hetGla2' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.103.gtf.gz',
'GCA_000230445.1_HetGla_1.0' => 'heterocephalus_glaber_male/Heterocephalus_glaber_male.HetGla_1.0.103.gtf.gz',
'hetGla1' => 'heterocephalus_glaber_male/Heterocephalus_glaber_male.HetGla_1.0.103.gtf.gz',
'GCA_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/Hippocampus_comes.H_comes_QL1_v1.103.gtf.gz',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/Hippocampus_comes.H_comes_QL1_v1.103.gtf.gz',
'GCA_003317085.1_ASM331708v1' => 'hucho_hucho/Hucho_hucho.ASM331708v1.103.gtf.gz',
'GCA_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/Ictalurus_punctatus.IpCoco_1.2.103.gtf.gz',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/Ictalurus_punctatus.IpCoco_1.2.103.gtf.gz',
'GCA_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.103.gtf.gz',
'GCF_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.103.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.103.gtf.gz',
'GCA_000280705.1_JacJac1.0' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.103.gtf.gz',
'GCF_000280705.1_JacJac1.0' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.103.gtf.gz',
'jacJac1' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.103.gtf.gz',
'GCA_003829775.1_ASM382977v1' => 'junco_hyemalis/Junco_hyemalis.ASM382977v1.103.gtf.gz',
'GCA_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/Kryptolebias_marmoratus.ASM164957v1.103.gtf.gz',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/Kryptolebias_marmoratus.ASM164957v1.103.gtf.gz',
'GCA_900080235.1_BallGen_V1' => 'labrus_bergylta/Labrus_bergylta.BallGen_V1.103.gtf.gz',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta/Labrus_bergylta.BallGen_V1.103.gtf.gz',
'GCA_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/Larimichthys_crocea.L_crocea_2.0.103.gtf.gz',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/Larimichthys_crocea.L_crocea_2.0.103.gtf.gz',
'GCA_001640805.1_ASM164080v1' => 'lates_calcarifer/Lates_calcarifer.ASB_HGAPassembly_v1.103.gtf.gz',
'GCA_900066035.1_ASB_HGAPassembly_v1' => 'lates_calcarifer/Lates_calcarifer.ASB_HGAPassembly_v1.103.gtf.gz',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer/Lates_calcarifer.ASB_HGAPassembly_v1.103.gtf.gz',
'GCA_004320025.1_latLat_1.0' => 'laticauda_laticaudata/Laticauda_laticaudata.latLat_1.0.103.gtf.gz',
'GCA_000225785.1_LatCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.103.gtf.gz',
'GCF_000225785.1_LatCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.103.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.103.gtf.gz',
'GCA_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/Lepidothrix_coronata.Lepidothrix_coronata-1.0.103.gtf.gz',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/Lepidothrix_coronata.Lepidothrix_coronata-1.0.103.gtf.gz',
'GCA_000242695.1_LepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.103.gtf.gz',
'GCF_000242695.1_LepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.103.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.103.gtf.gz',
'GCA_002197715.1_LonStrDom1' => 'lonchura_striata_domestica/Lonchura_striata_domestica.LonStrDom1.103.gtf.gz',
'GCA_000001905.1_Loxafr3.0' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.103.gtf.gz',
'GCF_000001905.1_Loxafr3.0' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.103.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.103.gtf.gz',
'GCA_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/Lynx_canadensis.mLynCan4_v1.p.103.gtf.gz',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/Lynx_canadensis.mLynCan4_v1.p.103.gtf.gz',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_5.0.103.gtf.gz',
'GCA_011100615.1_Macaca_fascicularis_6.0' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_6.0.103.gtf.gz',
'GCA_003339765.3_Mmul_10' => 'macaca_mulatta/Macaca_mulatta.Mmul_10.103.gtf.gz',
'GCF_003339765.1_Mmul_10' => 'macaca_mulatta/Macaca_mulatta.Mmul_10.103.gtf.gz',
'rheMac10' => 'macaca_mulatta/Macaca_mulatta.Mmul_10.103.gtf.gz',
'GCA_000956065.1_Mnem_1.0' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.103.gtf.gz',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.103.gtf.gz',
'macNem1' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.103.gtf.gz',
'GCA_009741485.1_mCya_1.0' => 'malurus_cyaneus_samueli/Malurus_cyaneus_samueli.mCya_1.0.103.gtf.gz',
'GCA_001715985.2_ASM171598v2' => 'manacus_vitellinus/Manacus_vitellinus.ASM171598v2.103.gtf.gz',
'GCA_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.103.gtf.gz',
'GCF_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.103.gtf.gz',
'manLeu1' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.103.gtf.gz',
'GCA_001458135.1_marMar2.1' => 'marmota_marmota_marmota/Marmota_marmota_marmota.marMar2.1.103.gtf.gz',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota/Marmota_marmota_marmota.marMar2.1.103.gtf.gz',
'GCA_900324485.1_fMasArm1.1' => 'mastacembelus_armatus/Mastacembelus_armatus.fMasArm1.1.103.gtf.gz',
'GCA_900324485.2_fMasArm1.2' => 'mastacembelus_armatus/Mastacembelus_armatus.fMasArm1.2.103.gtf.gz',
'GCF_900324485.2_fMasArm1.2' => 'mastacembelus_armatus/Mastacembelus_armatus.fMasArm1.2.103.gtf.gz',
'GCA_000238955.5_M_zebra_UMD2a' => 'maylandia_zebra/Maylandia_zebra.M_zebra_UMD2a.103.gtf.gz',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra/Maylandia_zebra.M_zebra_UMD2a.103.gtf.gz',
'melGal1' => 'meleagris_gallopavo/Meleagris_gallopavo.Turkey_2.01.103.gtf.gz',
'GCA_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.103.gtf.gz',
'GCF_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.103.gtf.gz',
'melUnd1' => 'melopsittacus_undulatus/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.103.gtf.gz',
'GCA_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/Meriones_unguiculatus.MunDraft-v1.0.103.gtf.gz',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/Meriones_unguiculatus.MunDraft-v1.0.103.gtf.gz',
'GCA_000349665.1_MesAur1.0' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.103.gtf.gz',
'GCF_000349665.1_MesAur1.0' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.103.gtf.gz',
'mesAur1' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.103.gtf.gz',
'GCA_000165445.3_Mmur_3.0' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.103.gtf.gz',
'GCF_000165445.2_Mmur_3.0' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.103.gtf.gz',
'micMur3' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.103.gtf.gz',
'GCA_000317375.1_MicOch1.0' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.103.gtf.gz',
'GCF_000317375.1_MicOch1.0' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.103.gtf.gz',
'micOch1' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.103.gtf.gz',
'GCA_001698575.1_ASM169857v1' => 'mola_mola/Mola_mola.ASM169857v1.103.gtf.gz',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica/Monodelphis_domestica.ASM229v1.103.gtf.gz',
'GCA_005190385.2_NGI_Narwhal_1' => 'monodon_monoceros/Monodon_monoceros.NGI_Narwhal_1.103.gtf.gz',
'GCF_005190385.1_NGI_Narwhal_1' => 'monodon_monoceros/Monodon_monoceros.NGI_Narwhal_1.103.gtf.gz',
'GCA_001952655.1_M_albus_1.0' => 'monopterus_albus/Monopterus_albus.M_albus_1.0.103.gtf.gz',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus/Monopterus_albus.M_albus_1.0.103.gtf.gz',
'GCA_004024705.2_MosMos_v2_BIUU_UCD' => 'moschus_moschiferus/Moschus_moschiferus.MosMos_v2_BIUU_UCD.103.gtf.gz',
'GCA_900094665.2_CAROLI_EIJ_v1.1' => 'mus_caroli/Mus_caroli.CAROLI_EIJ_v1.1.103.gtf.gz',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli/Mus_caroli.CAROLI_EIJ_v1.1.103.gtf.gz',
'GCF_000001635.27_GRCm39' => 'mus_musculus/Mus_musculus.GRCm39.103.gtf.gz',
'mm39' => 'mus_musculus/Mus_musculus.GRCm39.103.gtf.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/Mus_musculus_129s1svimj.129S1_SvImJ_v1.103.gtf.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/Mus_musculus_aj.A_J_v1.103.gtf.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/Mus_musculus_akrj.AKR_J_v1.103.gtf.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/Mus_musculus_balbcj.BALB_cJ_v1.103.gtf.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/Mus_musculus_c3hhej.C3H_HeJ_v1.103.gtf.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.103.gtf.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/Mus_musculus_casteij.CAST_EiJ_v1.103.gtf.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/Mus_musculus_cbaj.CBA_J_v1.103.gtf.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/Mus_musculus_dba2j.DBA_2J_v1.103.gtf.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/Mus_musculus_fvbnj.FVB_NJ_v1.103.gtf.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/Mus_musculus_lpj.LP_J_v1.103.gtf.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.103.gtf.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.103.gtf.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/Mus_musculus_pwkphj.PWK_PhJ_v1.103.gtf.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/Mus_musculus_wsbeij.WSB_EiJ_v1.103.gtf.gz',
'GCA_900095145.2_PAHARI_EIJ_v1.1' => 'mus_pahari/Mus_pahari.PAHARI_EIJ_v1.1.103.gtf.gz',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari/Mus_pahari.PAHARI_EIJ_v1.1.103.gtf.gz',
'GCA_003336285.1_MUSP714' => 'mus_spicilegus/Mus_spicilegus.MUSP714.103.gtf.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/Mus_spretus.SPRET_EiJ_v1.103.gtf.gz',
'GCA_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.103.gtf.gz',
'GCF_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.103.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.103.gtf.gz',
'GCA_000147115.1_Myoluc2.0' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.103.gtf.gz',
'GCF_000147115.1_Myoluc2.0' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.103.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.103.gtf.gz',
'GCA_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/Myripristis_murdjan.fMyrMur1.1.103.gtf.gz',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/Myripristis_murdjan.fMyrMur1.1.103.gtf.gz',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.103.gtf.gz',
'GCF_000622305.1_S.galili_v1.0' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.103.gtf.gz',
'nanGal1' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.103.gtf.gz',
'GCA_007210695.1_RGoby_Basel_V2' => 'neogobius_melanostomus/Neogobius_melanostomus.RGoby_Basel_V2.103.gtf.gz',
'GCA_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/Neolamprologus_brichardi.NeoBri1.0.103.gtf.gz',
'GCF_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/Neolamprologus_brichardi.NeoBri1.0.103.gtf.gz',
'neoBri1' => 'neolamprologus_brichardi/Neolamprologus_brichardi.NeoBri1.0.103.gtf.gz',
'GCA_900108605.1_NNQGG.v01' => 'neovison_vison/Neovison_vison.NNQGG.v01.103.gtf.gz',
'GCA_000146795.3_Nleu_3.0' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu_3.0.103.gtf.gz',
'nomLeu3' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu_3.0.103.gtf.gz',
'GCA_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/Notechis_scutatus.TS10Xv2-PRI.103.gtf.gz',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/Notechis_scutatus.TS10Xv2-PRI.103.gtf.gz',
'GCA_001465895.2_Nfu_20140520' => 'nothobranchius_furzeri/Nothobranchius_furzeri.Nfu_20140520.103.gtf.gz',
'GCF_001465895.1_Nfu_20140520' => 'nothobranchius_furzeri/Nothobranchius_furzeri.Nfu_20140520.103.gtf.gz',
'GCA_003342845.1_notPer1' => 'nothoprocta_perdicaria/Nothoprocta_perdicaria.notPer1.103.gtf.gz',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria/Nothoprocta_perdicaria.notPer1.103.gtf.gz',
'GCA_002078875.2_NumMel1.0' => 'numida_meleagris/Numida_meleagris.NumMel1.0.103.gtf.gz',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris/Numida_meleagris.NumMel1.0.103.gtf.gz',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus/Octodon_degus.OctDeg1.0.103.gtf.gz',
'GCF_000260255.1_OctDeg1.0' => 'octodon_degus/Octodon_degus.OctDeg1.0.103.gtf.gz',
'octDeg1' => 'octodon_degus/Octodon_degus.OctDeg1.0.103.gtf.gz',
'GCA_002021735.2_Okis_V2' => 'oncorhynchus_kisutch/Oncorhynchus_kisutch.Okis_V2.103.gtf.gz',
'GCF_002021735.2_Okis_V2' => 'oncorhynchus_kisutch/Oncorhynchus_kisutch.Okis_V2.103.gtf.gz',
'GCA_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss/Oncorhynchus_mykiss.Omyk_1.0.103.gtf.gz',
'GCF_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss/Oncorhynchus_mykiss.Omyk_1.0.103.gtf.gz',
'GCA_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha/Oncorhynchus_tshawytscha.Otsh_v1.0.103.gtf.gz',
'GCF_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha/Oncorhynchus_tshawytscha.Otsh_v1.0.103.gtf.gz',
'GCA_005870065.1_ASM587006v1' => 'oreochromis_aureus/Oreochromis_aureus.ASM587006v1.103.gtf.gz',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus/Oreochromis_aureus.ASM587006v1.103.gtf.gz',
'GCA_001858045.3_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/Oreochromis_niloticus.O_niloticus_UMD_NMBU.103.gtf.gz',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/Oreochromis_niloticus.O_niloticus_UMD_NMBU.103.gtf.gz',
'GCA_004115215.2_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.mOrnAna1.p.v1.103.gtf.gz',
'GCF_004115215.1_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.mOrnAna1.p.v1.103.gtf.gz',
'GCA_000003625.1_OryCun2.0' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.103.gtf.gz',
'GCF_000003625.3_OryCun2.0' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.103.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.103.gtf.gz',
'GCA_003999625.1_OJAV_1.1' => 'oryzias_javanicus/Oryzias_javanicus.OJAV_1.1.103.gtf.gz',
'GCA_002234675.1_ASM223467v1' => 'oryzias_latipes/Oryzias_latipes.ASM223467v1.103.gtf.gz',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes/Oryzias_latipes.ASM223467v1.103.gtf.gz',
'GCA_002234715.1_ASM223471v1' => 'oryzias_latipes_hni/Oryzias_latipes_hni.ASM223471v1.103.gtf.gz',
'GCA_002234695.1_ASM223469v1' => 'oryzias_latipes_hsok/Oryzias_latipes_hsok.ASM223469v1.103.gtf.gz',
'GCA_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/Oryzias_melastigma.Om_v0.7.RACA.103.gtf.gz',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/Oryzias_melastigma.Om_v0.7.RACA.103.gtf.gz',
'GCA_008586565.1_ASM858656v1' => 'oryzias_sinensis/Oryzias_sinensis.ASM858656v1.103.gtf.gz',
'GCA_000181295.3_OtoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.103.gtf.gz',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.103.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.103.gtf.gz',
'GCA_000298735.1_Oar_v3.1' => 'ovis_aries/Ovis_aries.Oar_v3.1.103.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.103.gtf.gz',
'GCA_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet/Ovis_aries_rambouillet.Oar_rambouillet_v1.0.103.gtf.gz',
'GCF_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet/Ovis_aries_rambouillet.Oar_rambouillet_v1.0.103.gtf.gz',
'GCA_000258655.2_panpan1.1' => 'pan_paniscus/Pan_paniscus.panpan1.1.103.gtf.gz',
'GCF_000258655.2_panpan1.1' => 'pan_paniscus/Pan_paniscus.panpan1.1.103.gtf.gz',
'panPan2' => 'pan_paniscus/Pan_paniscus.panpan1.1.103.gtf.gz',
'GCA_000001515.5_Pan_tro_3.0' => 'pan_troglodytes/Pan_troglodytes.Pan_tro_3.0.103.gtf.gz',
'panTro5' => 'pan_troglodytes/Pan_troglodytes.Pan_tro_3.0.103.gtf.gz',
'GCA_008795835.1_PanLeo1.0' => 'panthera_leo/Panthera_leo.PanLeo1.0.103.gtf.gz',
'GCA_001857705.1_PanPar1.0' => 'panthera_pardus/Panthera_pardus.PanPar1.0.103.gtf.gz',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus/Panthera_pardus.PanPar1.0.103.gtf.gz',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/Panthera_tigris_altaica.PanTig1.0.103.gtf.gz',
'GCF_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/Panthera_tigris_altaica.PanTig1.0.103.gtf.gz',
'panTig1' => 'panthera_tigris_altaica/Panthera_tigris_altaica.PanTig1.0.103.gtf.gz',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis/Papio_anubis.Panu_3.0.103.gtf.gz',
'GCF_000264685.3_Panu_3.0' => 'papio_anubis/Papio_anubis.Panu_3.0.103.gtf.gz',
'papAnu4' => 'papio_anubis/Papio_anubis.Panu_3.0.103.gtf.gz',
'GCA_900634625.1_fParRan2.1' => 'parambassis_ranga/Parambassis_ranga.fParRan2.1.103.gtf.gz',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga/Parambassis_ranga.fParRan2.1.103.gtf.gz',
'GCA_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/Paramormyrops_kingsleyae.PKINGS_0.1.103.gtf.gz',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/Paramormyrops_kingsleyae.PKINGS_0.1.103.gtf.gz',
'GCA_001522545.2_Parus_major1.1' => 'parus_major/Parus_major.Parus_major1.1.103.gtf.gz',
'GCF_001522545.3_Parus_major1.1' => 'parus_major/Parus_major.Parus_major1.1.103.gtf.gz',
'GCA_005519975.1_AIIM_Pcri_1.0' => 'pavo_cristatus/Pavo_cristatus.AIIM_Pcri_1.0.103.gtf.gz',
'GCA_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.103.gtf.gz',
'GCF_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.103.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.103.gtf.gz',
'GCA_007922175.1_Pelusios_castaneus-1.0' => 'pelusios_castaneus/Pelusios_castaneus.Pelusios_castaneus-1.0.103.gtf.gz',
'GCA_000787105.1_PM.fa' => 'periophthalmus_magnuspinnatus/Periophthalmus_magnuspinnatus.PM.fa.103.gtf.gz',
'GCA_003704035.1_HU_Pman_2.1' => 'peromyscus_maniculatus_bairdii/Peromyscus_maniculatus_bairdii.HU_Pman_2.1.103.gtf.gz',
'GCA_000148955.1_Petromyzon_marinus-7.0' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.103.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.103.gtf.gz',
'GCA_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/Phascolarctos_cinereus.phaCin_unsw_v4.1.103.gtf.gz',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/Phascolarctos_cinereus.phaCin_unsw_v4.1.103.gtf.gz',
'GCA_004143745.1_ASM414374v1' => 'phasianus_colchicus/Phasianus_colchicus.ASM414374v1.103.gtf.gz',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus/Phasianus_colchicus.ASM414374v1.103.gtf.gz',
'GCA_008692025.1_mPhoSin1.pri' => 'phocoena_sinus/Phocoena_sinus.mPhoSin1.pri.103.gtf.gz',
'GCF_008692025.1_mPhoSin1.pri' => 'phocoena_sinus/Phocoena_sinus.mPhoSin1.pri.103.gtf.gz',
'GCA_002837175.2_ASM283717v2' => 'physeter_catodon/Physeter_catodon.ASM283717v2.103.gtf.gz',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon/Physeter_catodon.ASM283717v2.103.gtf.gz',
'GCA_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/Piliocolobus_tephrosceles.ASM277652v2.103.gtf.gz',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/Piliocolobus_tephrosceles.ASM277652v2.103.gtf.gz',
'GCA_004329235.1_PodMur_1.0' => 'podarcis_muralis/Podarcis_muralis.PodMur_1.0.103.gtf.gz',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis/Podarcis_muralis.PodMur_1.0.103.gtf.gz',
'GCA_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.103.gtf.gz',
'GCF_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.103.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.103.gtf.gz',
'GCA_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/Poecilia_latipinna.P_latipinna-1.0.103.gtf.gz',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/Poecilia_latipinna.P_latipinna-1.0.103.gtf.gz',
'GCA_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/Poecilia_mexicana.P_mexicana-1.0.103.gtf.gz',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/Poecilia_mexicana.P_mexicana-1.0.103.gtf.gz',
'GCA_000633615.2_Guppy_female_1.0_MT' => 'poecilia_reticulata/Poecilia_reticulata.Guppy_female_1.0_MT.103.gtf.gz',
'GCF_000633615.1_Guppy_female_1.0_MT' => 'poecilia_reticulata/Poecilia_reticulata.Guppy_female_1.0_MT.103.gtf.gz',
'poeRet1' => 'poecilia_reticulata/Poecilia_reticulata.Guppy_female_1.0_MT.103.gtf.gz',
'GCA_900067755.1_pvi1.1' => 'pogona_vitticeps/Pogona_vitticeps.pvi1.1.103.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.103.gtf.gz',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus/Prolemur_simus.Prosim_1.0.103.gtf.gz',
'GCA_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.103.gtf.gz',
'GCF_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.103.gtf.gz',
'proCoq1' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.103.gtf.gz',
'GCA_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/Pseudonaja_textilis.EBS10Xv2-PRI.103.gtf.gz',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/Pseudonaja_textilis.EBS10Xv2-PRI.103.gtf.gz',
'GCA_000239375.1_PunNye1.0' => 'pundamilia_nyererei/Pundamilia_nyererei.PunNye1.0.103.gtf.gz',
'GCF_000239375.1_PunNye1.0' => 'pundamilia_nyererei/Pundamilia_nyererei.PunNye1.0.103.gtf.gz',
'punNye1' => 'pundamilia_nyererei/Pundamilia_nyererei.PunNye1.0.103.gtf.gz',
'GCA_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.103.gtf.gz',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.103.gtf.gz',
'GCA_000001895.4_Rnor_6.0' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.103.gtf.gz',
'GCF_000001895.5_Rnor_6.0' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.103.gtf.gz',
'rn6' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.103.gtf.gz',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.103.gtf.gz',
'GCF_004115265.1_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.103.gtf.gz',
'GCA_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.103.gtf.gz',
'GCF_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.103.gtf.gz',
'rhiBie1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.103.gtf.gz',
'GCA_000769185.1_Rrox_v1' => 'rhinopithecus_roxellana/Rhinopithecus_roxellana.Rrox_v1.103.gtf.gz',
'rhiRox1' => 'rhinopithecus_roxellana/Rhinopithecus_roxellana.Rrox_v1.103.gtf.gz',
'GCA_000146045.2_R64-1-1' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.103.gtf.gz',
'GCF_000146045.2_R64' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.103.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.103.gtf.gz',
'GCA_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.103.gtf.gz',
'GCF_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.103.gtf.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.103.gtf.gz',
'GCA_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/Salarias_fasciatus.fSalaFa1.1.103.gtf.gz',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/Salarias_fasciatus.fSalaFa1.1.103.gtf.gz',
'GCA_000233375.4_ICSASG_v2' => 'salmo_salar/Salmo_salar.ICSASG_v2.103.gtf.gz',
'GCA_901001165.1_fSalTru1.1' => 'salmo_trutta/Salmo_trutta.fSalTru1.1.103.gtf.gz',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta/Salmo_trutta.fSalTru1.1.103.gtf.gz',
'GCA_003586115.1_HLtupMer3' => 'salvator_merianae/Salvator_merianae.HLtupMer3.103.gtf.gz',
'GCA_008315115.1_SLUC_FBN_1' => 'sander_lucioperca/Sander_lucioperca.SLUC_FBN_1.103.gtf.gz',
'GCF_008315115.1_SLUC_FBN_1' => 'sander_lucioperca/Sander_lucioperca.SLUC_FBN_1.103.gtf.gz',
'GCA_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii/Sarcophilus_harrisii.mSarHar1.11.103.gtf.gz',
'GCF_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii/Sarcophilus_harrisii.mSarHar1.11.103.gtf.gz',
'GCA_902686455.1_mSciVul1.1' => 'sciurus_vulgaris/Sciurus_vulgaris.mSciVul1.1.103.gtf.gz',
'GCA_900964775.1_fSclFor1.1' => 'scleropages_formosus/Scleropages_formosus.fSclFor1.1.103.gtf.gz',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus/Scleropages_formosus.fSclFor1.1.103.gtf.gz',
'GCA_003186165.1_ASM318616v1' => 'scophthalmus_maximus/Scophthalmus_maximus.ASM318616v1.103.gtf.gz',
'GCA_000534875.1_SCA1' => 'serinus_canaria/Serinus_canaria.SCA1.103.gtf.gz',
'serCan1' => 'serinus_canaria/Serinus_canaria.SCA1.103.gtf.gz',
'GCA_002260705.1_Sdu_1.0' => 'seriola_dumerili/Seriola_dumerili.Sdu_1.0.103.gtf.gz',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili/Seriola_dumerili.Sdu_1.0.103.gtf.gz',
'GCA_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/Seriola_lalandi_dorsalis.Sedor1.103.gtf.gz',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/Seriola_lalandi_dorsalis.Sedor1.103.gtf.gz',
'GCA_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.103.gtf.gz',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.103.gtf.gz',
'GCA_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.103.gtf.gz',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.103.gtf.gz',
'GCA_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.103.gtf.gz',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.103.gtf.gz',
'GCA_900880675.1_fSpaAur1.1' => 'sparus_aurata/Sparus_aurata.fSpaAur1.1.103.gtf.gz',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata/Sparus_aurata.fSpaAur1.1.103.gtf.gz',
'GCA_002406435.1_ASM240643v1' => 'spermophilus_dauricus/Spermophilus_dauricus.ASM240643v1.103.gtf.gz',
'GCA_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/Sphaeramia_orbicularis.fSphaOr1.1.103.gtf.gz',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/Sphaeramia_orbicularis.fSphaOr1.1.103.gtf.gz',
'GCA_003113815.1_ASM311381v1' => 'sphenodon_punctatus/Sphenodon_punctatus.ASM311381v1.103.gtf.gz',
'GCA_008694505.1_ASM869450v1' => 'stachyris_ruficeps/Stachyris_ruficeps.ASM869450v1.103.gtf.gz',
'GCA_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/Stegastes_partitus.Stegastes_partitus-1.0.2.103.gtf.gz',
'GCF_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/Stegastes_partitus.Stegastes_partitus-1.0.2.103.gtf.gz',
'stePar1' => 'stegastes_partitus/Stegastes_partitus.Stegastes_partitus-1.0.2.103.gtf.gz',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/Strigops_habroptila.bStrHab1_v1.p.103.gtf.gz',
'GCF_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/Strigops_habroptila.bStrHab1_v1.p.103.gtf.gz',
'GCA_002372975.1_Soccid_v01' => 'strix_occidentalis_caurina/Strix_occidentalis_caurina.Soccid_v01.103.gtf.gz',
'GCA_000698965.1_ASM69896v1' => 'struthio_camelus_australis/Struthio_camelus_australis.ASM69896v1.103.gtf.gz',
'GCF_000698965.1_ASM69896v1' => 'struthio_camelus_australis/Struthio_camelus_australis.ASM69896v1.103.gtf.gz',
'strCam1' => 'struthio_camelus_australis/Struthio_camelus_australis.ASM69896v1.103.gtf.gz',
'GCA_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.103.gtf.gz',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.103.gtf.gz',
'GCA_000003025.6_Sscrofa11.1' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.103.gtf.gz',
'GCF_000003025.6_Sscrofa11.1' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.103.gtf.gz',
'susScr11' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.103.gtf.gz',
'GCA_001700235.1_Bamei_pig_v1' => 'sus_scrofa_bamei/Sus_scrofa_bamei.Bamei_pig_v1.103.gtf.gz',
'GCA_001700575.1_Berkshire_pig_v1' => 'sus_scrofa_berkshire/Sus_scrofa_berkshire.Berkshire_pig_v1.103.gtf.gz',
'GCA_001700165.1_Hampshire_pig_v1' => 'sus_scrofa_hampshire/Sus_scrofa_hampshire.Hampshire_pig_v1.103.gtf.gz',
'GCA_001700295.1_Jinhua_pig_v1' => 'sus_scrofa_jinhua/Sus_scrofa_jinhua.Jinhua_pig_v1.103.gtf.gz',
'GCA_001700215.1_Landrace_pig_v1' => 'sus_scrofa_landrace/Sus_scrofa_landrace.Landrace_pig_v1.103.gtf.gz',
'GCA_001700135.1_Large_White_v1' => 'sus_scrofa_largewhite/Sus_scrofa_largewhite.Large_White_v1.103.gtf.gz',
'GCA_001700195.1_Meishan_pig_v1' => 'sus_scrofa_meishan/Sus_scrofa_meishan.Meishan_pig_v1.103.gtf.gz',
'GCA_001700255.1_Pietrain_pig_v1' => 'sus_scrofa_pietrain/Sus_scrofa_pietrain.Pietrain_pig_v1.103.gtf.gz',
'GCA_001700155.1_Rongchang_pig_v1' => 'sus_scrofa_rongchang/Sus_scrofa_rongchang.Rongchang_pig_v1.103.gtf.gz',
'GCA_000472085.2_Tibetan_Pig_v2' => 'sus_scrofa_tibetan/Sus_scrofa_tibetan.Tibetan_Pig_v2.103.gtf.gz',
'GCA_002844635.1_USMARCv1.0' => 'sus_scrofa_usmarc/Sus_scrofa_usmarc.USMARCv1.0.103.gtf.gz',
'GCA_000325925.2_minipig_v1.0' => 'sus_scrofa_wuzhishan/Sus_scrofa_wuzhishan.minipig_v1.0.103.gtf.gz',
'GCA_003957565.2_bTaeGut1_v1.p' => 'taeniopygia_guttata/Taeniopygia_guttata.bTaeGut1_v1.p.103.gtf.gz',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata/Taeniopygia_guttata.bTaeGut1_v1.p.103.gtf.gz',
'GCA_901000725.2_fTakRub1.2' => 'takifugu_rubripes/Takifugu_rubripes.fTakRub1.2.103.gtf.gz',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes/Takifugu_rubripes.fTakRub1.2.103.gtf.gz',
'GCA_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis/Terrapene_carolina_triunguis.T_m_triunguis-2.0.103.gtf.gz',
'GCF_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis/Terrapene_carolina_triunguis.T_m_triunguis-2.0.103.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.103.gtf.gz',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada/Theropithecus_gelada.Tgel_1.0.103.gtf.gz',
'GCF_003255815.1_Tgel_1.0' => 'theropithecus_gelada/Theropithecus_gelada.Tgel_1.0.103.gtf.gz',
'GCA_003426925.1_ASM342692v1' => 'urocitellus_parryii/Urocitellus_parryii.ASM342692v1.103.gtf.gz',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii/Urocitellus_parryii.ASM342692v1.103.gtf.gz',
'GCA_003344425.1_ASM334442v1' => 'ursus_americanus/Ursus_americanus.ASM334442v1.103.gtf.gz',
'GCA_000687225.1_UrsMar_1.0' => 'ursus_maritimus/Ursus_maritimus.UrsMar_1.0.103.gtf.gz',
'GCF_000687225.1_UrsMar_1.0' => 'ursus_maritimus/Ursus_maritimus.UrsMar_1.0.103.gtf.gz',
'ursMar1' => 'ursus_maritimus/Ursus_maritimus.UrsMar_1.0.103.gtf.gz',
'GCA_009660055.1_ASM966005v1' => 'ursus_thibetanus_thibetanus/Ursus_thibetanus_thibetanus.ASM966005v1.103.gtf.gz',
'GCA_004798865.1_ASM479886v1' => 'varanus_komodoensis/Varanus_komodoensis.ASM479886v1.103.gtf.gz',
'GCA_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.103.gtf.gz',
'GCF_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.103.gtf.gz',
'GCA_003160815.1_VulVul2.2' => 'vulpes_vulpes/Vulpes_vulpes.VulVul2.2.103.gtf.gz',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes/Vulpes_vulpes.VulVul2.2.103.gtf.gz',
'GCA_000004195.3_Xenopus_tropicalis_v9.1' => 'xenopus_tropicalis/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.103.gtf.gz',
'xenTro9' => 'xenopus_tropicalis/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.103.gtf.gz',
'GCA_001444195.1_Xiphophorus_couchianus-4.0.1' => 'xiphophorus_couchianus/Xiphophorus_couchianus.Xiphophorus_couchianus-4.0.1.103.gtf.gz',
'GCA_002775205.2_X_maculatus-5.0-male' => 'xiphophorus_maculatus/Xiphophorus_maculatus.X_maculatus-5.0-male.103.gtf.gz',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus/Xiphophorus_maculatus.X_maculatus-5.0-male.103.gtf.gz',
'GCA_009762305.1_mZalCal1.pri' => 'zalophus_californianus/Zalophus_californianus.mZalCal1.pri.103.gtf.gz',
'GCA_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.103.gtf.gz',
'GCF_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.103.gtf.gz',
'zonAlb1' => 'zonotrichia_albicollis/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.103.gtf.gz',
'GCA_001281735.1_ASM128173v1' => 'zosterops_lateralis_melanops/Zosterops_lateralis_melanops.ASM128173v1.103.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_103 = (
'GCA_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/pep/Acanthochromis_polyacanthus.ASM210954v1.pep.all.fa.gz',
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/pep/Acanthochromis_polyacanthus.ASM210954v1.pep.all.fa.gz',
'GCA_004320145.1_Accipiter_nisus_ver1.0' => 'accipiter_nisus/pep/Accipiter_nisus.Accipiter_nisus_ver1.0.pep.all.fa.gz',
'GCF_002007445.1_ASM200744v2' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ASM200744v2.pep.all.fa.gz',
'GCF_000004335.2_AilMel_1.0' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ailMel1.pep.all.fa.gz',
'GCA_003947215.1_ASM394721v1' => 'amazona_collaria/pep/Amazona_collaria.ASM394721v1.pep.all.fa.gz',
'GCA_000751415.1_Midas_v5' => 'amphilophus_citrinellus/pep/Amphilophus_citrinellus.Midas_v5.pep.all.fa.gz',
'GCA_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/pep/Amphiprion_ocellaris.AmpOce1.0.pep.all.fa.gz',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/pep/Amphiprion_ocellaris.AmpOce1.0.pep.all.fa.gz',
'GCA_003047355.1_Nemo_v1' => 'amphiprion_percula/pep/Amphiprion_percula.Nemo_v1.pep.all.fa.gz',
'GCA_900324465.1_fAnaTes1.1' => 'anabas_testudineus/pep/Anabas_testudineus.fAnaTes1.1.pep.all.fa.gz',
'GCA_900324465.2_fAnaTes1.2' => 'anabas_testudineus/pep/Anabas_testudineus.fAnaTes1.2.pep.all.fa.gz',
'GCF_900324465.2_fAnaTes1.2' => 'anabas_testudineus/pep/Anabas_testudineus.fAnaTes1.2.pep.all.fa.gz',
'GCA_008746955.1_ASM874695v1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.ASM874695v1.pep.all.fa.gz',
'GCA_002743455.1_CAU_duck1.0' => 'anas_platyrhynchos_platyrhynchos/pep/Anas_platyrhynchos_platyrhynchos.CAU_duck1.0.pep.all.fa.gz',
'GCA_002224875.1_ASM222487v1' => 'anas_zonorhyncha/pep/Anas_zonorhyncha.ASM222487v1.pep.all.fa.gz',
'GCA_000090745.2_AnoCar2.0' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'GCF_000090745.1_AnoCar2.0' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0.pep.all.fa.gz',
'GCA_002592135.1_ASM259213v1' => 'anser_brachyrhynchus/pep/Anser_brachyrhynchus.ASM259213v1.pep.all.fa.gz',
'GCA_002166845.1_GooseV1.0' => 'anser_cygnoides/pep/Anser_cygnoides.GooseV1.0.pep.all.fa.gz',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'GCF_000952055.2_Anan_2.0' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'aotNan1' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'GCA_003342985.1_aptHaa1' => 'apteryx_haastii/pep/Apteryx_haastii.aptHaa1.pep.all.fa.gz',
'GCA_003342965.1_aptOwe1' => 'apteryx_owenii/pep/Apteryx_owenii.aptOwe1.pep.all.fa.gz',
'GCA_003343035.1_aptRow1' => 'apteryx_rowi/pep/Apteryx_rowi.aptRow1.pep.all.fa.gz',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi/pep/Apteryx_rowi.aptRow1.pep.all.fa.gz',
'GCA_900496995.2_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/pep/Aquila_chrysaetos_chrysaetos.bAquChr1.2.pep.all.fa.gz',
'GCF_900496995.1_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/pep/Aquila_chrysaetos_chrysaetos.bAquChr1.2.pep.all.fa.gz',
'GCA_900246225.3_fAstCal1.2' => 'astatotilapia_calliptera/pep/Astatotilapia_calliptera.fAstCal1.2.pep.all.fa.gz',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera/pep/Astatotilapia_calliptera.fAstCal1.2.pep.all.fa.gz',
'GCA_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.Astyanax_mexicanus-2.0.pep.all.fa.gz',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.Astyanax_mexicanus-2.0.pep.all.fa.gz',
'GCA_004802775.1_Astyanax_mexicanus-1.0.2' => 'astyanax_mexicanus_pachon/pep/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus_pachon/pep/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.pep.all.fa.gz',
'GCA_003259725.1_athCun1' => 'athene_cunicularia/pep/Athene_cunicularia.athCun1.pep.all.fa.gz',
'GCF_003259725.1_athCun1' => 'athene_cunicularia/pep/Athene_cunicularia.athCun1.pep.all.fa.gz',
'GCA_009873245.2_mBalMus1.v2' => 'balaenoptera_musculus/pep/Balaenoptera_musculus.mBalMus1.v2.pep.all.fa.gz',
'GCA_900634795.2_fBetSpl5.2' => 'betta_splendens/pep/Betta_splendens.fBetSpl5.2.pep.all.fa.gz',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens/pep/Betta_splendens.fBetSpl5.2.pep.all.fa.gz',
'GCA_000754665.1_Bison_UMD1.0' => 'bison_bison_bison/pep/Bison_bison_bison.Bison_UMD1.0.pep.all.fa.gz',
'bisBis1' => 'bison_bison_bison/pep/Bison_bison_bison.Bison_UMD1.0.pep.all.fa.gz',
'GCA_005887515.1_LU_Bosgru_v3.0' => 'bos_grunniens/pep/Bos_grunniens.LU_Bosgru_v3.0.pep.all.fa.gz',
'GCA_003369695.2_UOA_Brahman_1' => 'bos_indicus_hybrid/pep/Bos_indicus_hybrid.UOA_Brahman_1.pep.all.fa.gz',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid/pep/Bos_indicus_hybrid.UOA_Brahman_1.pep.all.fa.gz',
'GCA_000298355.1_BosGru_v2.0' => 'bos_mutus/pep/Bos_mutus.BosGru_v2.0.pep.all.fa.gz',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus/pep/Bos_mutus.BosGru_v2.0.pep.all.fa.gz',
'bosMut1' => 'bos_mutus/pep/Bos_mutus.BosGru_v2.0.pep.all.fa.gz',
'GCA_002263795.2_ARS-UCD1.2' => 'bos_taurus/pep/Bos_taurus.ARS-UCD1.2.pep.all.fa.gz',
'GCF_002263795.1_ARS-UCD1.2' => 'bos_taurus/pep/Bos_taurus.ARS-UCD1.2.pep.all.fa.gz',
'bosTau9' => 'bos_taurus/pep/Bos_taurus.ARS-UCD1.2.pep.all.fa.gz',
'GCA_003369685.2_UOA_Angus_1' => 'bos_taurus_hybrid/pep/Bos_taurus_hybrid.UOA_Angus_1.pep.all.fa.gz',
'GCF_000002985.6_WBcel235' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'GCA_009194515.1_CaiMos1.0' => 'cairina_moschata_domestica/pep/Cairina_moschata_domestica.CaiMos1.0.pep.all.fa.gz',
'GCA_001431845.1_ASM143184v1' => 'calidris_pugnax/pep/Calidris_pugnax.ASM143184v1.pep.all.fa.gz',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax/pep/Calidris_pugnax.ASM143184v1.pep.all.fa.gz',
'GCA_003697955.1_ASM369795v1' => 'calidris_pygmaea/pep/Calidris_pygmaea.ASM369795v1.pep.all.fa.gz',
'GCA_002754865.1_ASM275486v1' => 'callithrix_jacchus/pep/Callithrix_jacchus.ASM275486v1.pep.all.fa.gz',
'GCA_000165045.2_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/pep/Callorhinchus_milii.Callorhinchus_milii-6.1.3.pep.all.fa.gz',
'GCF_000165045.1_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/pep/Callorhinchus_milii.Callorhinchus_milii-6.1.3.pep.all.fa.gz',
'calMil1' => 'callorhinchus_milii/pep/Callorhinchus_milii.Callorhinchus_milii-6.1.3.pep.all.fa.gz',
'GCA_901933205.1_STF_HiC' => 'camarhynchus_parvulus/pep/Camarhynchus_parvulus.STF_HiC.pep.all.fa.gz',
'GCF_901933205.1_STF_HiC' => 'camarhynchus_parvulus/pep/Camarhynchus_parvulus.STF_HiC.pep.all.fa.gz',
'GCA_000803125.2_CamDro2' => 'camelus_dromedarius/pep/Camelus_dromedarius.CamDro2.pep.all.fa.gz',
'GCA_003254725.1_ASM325472v1' => 'canis_lupus_dingo/pep/Canis_lupus_dingo.ASM325472v1.pep.all.fa.gz',
'GCF_003254725.1_ASM325472v1' => 'canis_lupus_dingo/pep/Canis_lupus_dingo.ASM325472v1.pep.all.fa.gz',
'GCA_000002285.2_CanFam3.1' => 'canis_lupus_familiaris/pep/Canis_lupus_familiaris.CanFam3.1.pep.all.fa.gz',
'GCF_000002285.3_CanFam3.1' => 'canis_lupus_familiaris/pep/Canis_lupus_familiaris.CanFam3.1.pep.all.fa.gz',
'canFam3' => 'canis_lupus_familiaris/pep/Canis_lupus_familiaris.CanFam3.1.pep.all.fa.gz',
'GCA_004886185.1_Basenji_breed-1.1' => 'canis_lupus_familiarisbasenji/pep/Canis_lupus_familiarisbasenji.Basenji_breed-1.1.pep.all.fa.gz',
'GCA_005444595.1_UMICH_Zoey_3.1' => 'canis_lupus_familiarisgreatdane/pep/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.pep.all.fa.gz',
'canFam5' => 'canis_lupus_familiarisgreatdane/pep/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.pep.all.fa.gz',
'GCA_001704415.1_ARS1' => 'capra_hircus/pep/Capra_hircus.ARS1.pep.all.fa.gz',
'GCF_001704415.1_ARS1' => 'capra_hircus/pep/Capra_hircus.ARS1.pep.all.fa.gz',
'GCA_004361675.1_CVASU_BBG_1.0' => 'capra_hircus_blackbengal/pep/Capra_hircus_blackbengal.CVASU_BBG_1.0.pep.all.fa.gz',
'GCA_003368295.1_ASM336829v1' => 'carassius_auratus/pep/Carassius_auratus.ASM336829v1.pep.all.fa.gz',
'GCF_003368295.1_ASM336829v1' => 'carassius_auratus/pep/Carassius_auratus.ASM336829v1.pep.all.fa.gz',
'GCA_000164805.2_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'GCF_000164805.1_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'tarSyr2' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'GCA_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/pep/Castor_canadensis.C.can_genome_v1.0.pep.all.fa.gz',
'GCF_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/pep/Castor_canadensis.C.can_genome_v1.0.pep.all.fa.gz',
'casCan1' => 'castor_canadensis/pep/Castor_canadensis.C.can_genome_v1.0.pep.all.fa.gz',
'GCA_004024745.2_CatWag_v2_BIUU_UCD' => 'catagonus_wagneri/pep/Catagonus_wagneri.CatWag_v2_BIUU_UCD.pep.all.fa.gz',
'GCA_009819885.1_bCatUst1.pri' => 'catharus_ustulatus/pep/Catharus_ustulatus.bCatUst1.pri.pep.all.fa.gz',
'GCF_009819885.1_bCatUst1.pri' => 'catharus_ustulatus/pep/Catharus_ustulatus.bCatUst1.pri.pep.all.fa.gz',
'GCA_000688575.1_CavAp1.0' => 'cavia_aperea/pep/Cavia_aperea.CavAp1.0.pep.all.fa.gz',
'cavApe1' => 'cavia_aperea/pep/Cavia_aperea.CavAp1.0.pep.all.fa.gz',
'GCA_000151735.1_Cavpor3.0' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'GCF_000151735.1_Cavpor3.0' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'GCA_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'GCF_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'cebCap1' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'GCA_000955945.1_Caty_1.0' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'cerAty1' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'GCA_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii/pep/Chelonoidis_abingdonii.ASM359739v1.pep.all.fa.gz',
'GCF_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii/pep/Chelonoidis_abingdonii.ASM359739v1.pep.all.fa.gz',
'GCA_007922165.1_Chelydra_serpentina-1.0' => 'chelydra_serpentina/pep/Chelydra_serpentina.Chelydra_serpentina-1.0.pep.all.fa.gz',
'GCA_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'chiLan1' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'GCA_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'GCF_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'GCA_000241765.2_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/pep/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.pep.all.fa.gz',
'GCF_000241765.3_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/pep/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.pep.all.fa.gz',
'chrPic2' => 'chrysemys_picta_bellii/pep/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.pep.all.fa.gz',
'GCA_003413605.1_Chrysolophus_pictus_GenomeV1.0' => 'chrysolophus_pictus/pep/Chrysolophus_pictus.Chrysolophus_pictus_GenomeV1.0.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'GCA_900700415.1_Ch_v2.0.2' => 'clupea_harengus/pep/Clupea_harengus.Ch_v2.0.2.pep.all.fa.gz',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus/pep/Clupea_harengus.Ch_v2.0.2.pep.all.fa.gz',
'GCA_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'GCF_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'colAng1' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'GCA_900634415.1_fCotGob3.1' => 'cottoperca_gobio/pep/Cottoperca_gobio.fCotGob3.1.pep.all.fa.gz',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio/pep/Cottoperca_gobio.fCotGob3.1.pep.all.fa.gz',
'GCA_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCA_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCF_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCF_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'cotJap2' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCA_900186095.1_CHOK1S_HZDv1' => 'cricetulus_griseus_chok1gshd/pep/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.pep.all.fa.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/pep/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.pep.all.fa.gz',
'GCA_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'GCF_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'GCA_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/pep/Cricetulus_griseus_picr.CriGri-PICR.pep.all.fa.gz',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/pep/Cricetulus_griseus_picr.CriGri-PICR.pep.all.fa.gz',
'GCA_001723895.1_CroPor_comp1' => 'crocodylus_porosus/pep/Crocodylus_porosus.CroPor_comp1.pep.all.fa.gz',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus/pep/Crocodylus_porosus.CroPor_comp1.pep.all.fa.gz',
'GCA_002901205.1_cyaCae2' => 'cyanistes_caeruleus/pep/Cyanistes_caeruleus.cyaCae2.pep.all.fa.gz',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus/pep/Cyanistes_caeruleus.cyaCae2.pep.all.fa.gz',
'GCA_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus/pep/Cyclopterus_lumpus.fCycLum1.pri.pep.all.fa.gz',
'GCF_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus/pep/Cyclopterus_lumpus.fCycLum1.pri.pep.all.fa.gz',
'GCA_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/pep/Cynoglossus_semilaevis.Cse_v1.0.pep.all.fa.gz',
'GCF_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/pep/Cynoglossus_semilaevis.Cse_v1.0.pep.all.fa.gz',
'cynSem1' => 'cynoglossus_semilaevis/pep/Cynoglossus_semilaevis.Cse_v1.0.pep.all.fa.gz',
'GCA_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/pep/Cyprinodon_variegatus.C_variegatus-1.0.pep.all.fa.gz',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/pep/Cyprinodon_variegatus.C_variegatus-1.0.pep.all.fa.gz',
'cypVar1' => 'cyprinodon_variegatus/pep/Cyprinodon_variegatus.C_variegatus-1.0.pep.all.fa.gz',
'GCA_000951615.2_common_carp_genome' => 'cyprinus_carpio/pep/Cyprinus_carpio.common_carp_genome.pep.all.fa.gz',
'GCF_000951615.1_common_carp_genome' => 'cyprinus_carpio/pep/Cyprinus_carpio.common_carp_genome.pep.all.fa.gz',
'GCA_004011555.1_German_Mirror_carp_1.0' => 'cyprinus_carpio_germanmirror/pep/Cyprinus_carpio_germanmirror.German_Mirror_carp_1.0.pep.all.fa.gz',
'GCA_004011595.1_Hebao_red_carp_1.0' => 'cyprinus_carpio_hebaored/pep/Cyprinus_carpio_hebaored.Hebao_red_carp_1.0.pep.all.fa.gz',
'GCA_004011575.1_Hunaghe_carp_2.0' => 'cyprinus_carpio_huanghe/pep/Cyprinus_carpio_huanghe.Hunaghe_carp_2.0.pep.all.fa.gz',
'GCA_000208655.2_Dasnov3.0' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'GCF_000208655.1_Dasnov3.0' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'GCA_002288925.3_ASM228892v3' => 'delphinapterus_leucas/pep/Delphinapterus_leucas.ASM228892v3.pep.all.fa.gz',
'GCF_002288925.2_ASM228892v3' => 'delphinapterus_leucas/pep/Delphinapterus_leucas.ASM228892v3.pep.all.fa.gz',
'GCA_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/pep/Denticeps_clupeoides.fDenClu1.1.pep.all.fa.gz',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/pep/Denticeps_clupeoides.fDenClu1.1.pep.all.fa.gz',
'GCA_000689215.1_seabass_V1.0' => 'dicentrarchus_labrax/pep/Dicentrarchus_labrax.seabass_V1.0.pep.all.fa.gz',
'dicLab1' => 'dicentrarchus_labrax/pep/Dicentrarchus_labrax.seabass_V1.0.pep.all.fa.gz',
'GCA_000151885.2_Dord_2.0' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'GCF_000151885.1_Dord_2.0' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'dipOrd2' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'GCA_003342905.1_droNov1' => 'dromaius_novaehollandiae/pep/Dromaius_novaehollandiae.droNov1.pep.all.fa.gz',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae/pep/Dromaius_novaehollandiae.droNov1.pep.all.fa.gz',
'GCF_000001215.4_Release_6_plus_ISO1_MT' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.32.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.32.pep.all.fa.gz',
'GCA_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/pep/Echeneis_naucrates.fEcheNa1.1.pep.all.fa.gz',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/pep/Echeneis_naucrates.fEcheNa1.1.pep.all.fa.gz',
'GCA_003665695.2_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/pep/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.pep.all.fa.gz',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/pep/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.pep.all.fa.gz',
'GCA_900186335.2_Eburgeri_3.2' => 'eptatretus_burgeri/pep/Eptatretus_burgeri.Eburgeri_3.2.pep.all.fa.gz',
'GCA_003033725.1_ASM303372v1' => 'equus_asinus_asinus/pep/Equus_asinus_asinus.ASM303372v1.pep.all.fa.gz',
'GCA_002863925.1_EquCab3.0' => 'equus_caballus/pep/Equus_caballus.EquCab3.0.pep.all.fa.gz',
'GCF_002863925.1_EquCab3.0' => 'equus_caballus/pep/Equus_caballus.EquCab3.0.pep.all.fa.gz',
'equCab3' => 'equus_caballus/pep/Equus_caballus.EquCab3.0.pep.all.fa.gz',
'GCA_900747795.2_fErpCal1.1' => 'erpetoichthys_calabaricus/pep/Erpetoichthys_calabaricus.fErpCal1.1.pep.all.fa.gz',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus/pep/Erpetoichthys_calabaricus.fErpCal1.1.pep.all.fa.gz',
'GCA_003676055.1_GouldianFinch' => 'erythrura_gouldiae/pep/Erythrura_gouldiae.GouldianFinch.pep.all.fa.gz',
'GCA_004634155.1_Eluc_v4' => 'esox_lucius/pep/Esox_lucius.Eluc_v4.pep.all.fa.gz',
'GCF_004634155.1_Eluc_v4' => 'esox_lucius/pep/Esox_lucius.Eluc_v4.pep.all.fa.gz',
'GCA_000181335.4_Felis_catus_9.0' => 'felis_catus/pep/Felis_catus.Felis_catus_9.0.pep.all.fa.gz',
'GCF_000181335.3_Felis_catus_9.0' => 'felis_catus/pep/Felis_catus.Felis_catus_9.0.pep.all.fa.gz',
'felCat9' => 'felis_catus/pep/Felis_catus.Felis_catus_9.0.pep.all.fa.gz',
'GCA_000743615.1_DMR_v1.0' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'GCF_000743615.1_DMR_v1.0' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'fukDam1' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'GCA_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/pep/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.pep.all.fa.gz',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/pep/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.pep.all.fa.gz',
'GCA_902167405.1_gadMor3.0' => 'gadus_morhua/pep/Gadus_morhua.gadMor3.0.pep.all.fa.gz',
'GCF_902167405.1_gadMor3.0' => 'gadus_morhua/pep/Gadus_morhua.gadMor3.0.pep.all.fa.gz',
'GCA_000002315.5_GRCg6a' => 'gallus_gallus/pep/Gallus_gallus.GRCg6a.pep.all.fa.gz',
'GCF_000002315.6_GRCg6a' => 'gallus_gallus/pep/Gallus_gallus.GRCg6a.pep.all.fa.gz',
'galGal6' => 'gallus_gallus/pep/Gallus_gallus.GRCg6a.pep.all.fa.gz',
'GCA_003097735.1_ASM309773v1' => 'gambusia_affinis/pep/Gambusia_affinis.ASM309773v1.pep.all.fa.gz',
'GCA_000277835.1_GeoFor_1.0' => 'geospiza_fortis/pep/Geospiza_fortis.GeoFor_1.0.pep.all.fa.gz',
'GCF_000277835.1_GeoFor_1.0' => 'geospiza_fortis/pep/Geospiza_fortis.GeoFor_1.0.pep.all.fa.gz',
'geoFor1' => 'geospiza_fortis/pep/Geospiza_fortis.GeoFor_1.0.pep.all.fa.gz',
'GCA_002896415.1_ASM289641v1' => 'gopherus_agassizii/pep/Gopherus_agassizii.ASM289641v1.pep.all.fa.gz',
'GCA_007399415.1_rGopEvg1_v1.p' => 'gopherus_evgoodei/pep/Gopherus_evgoodei.rGopEvg1_v1.p.pep.all.fa.gz',
'GCF_007399415.2_rGopEvg1_v1.p' => 'gopherus_evgoodei/pep/Gopherus_evgoodei.rGopEvg1_v1.p.pep.all.fa.gz',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor4.pep.all.fa.gz',
'gorGor4' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor4.pep.all.fa.gz',
'GCA_900634775.1_fGouWil2.1' => 'gouania_willdenowi/pep/Gouania_willdenowi.fGouWil2.1.pep.all.fa.gz',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi/pep/Gouania_willdenowi.fGouWil2.1.pep.all.fa.gz',
'GCA_000239415.1_AstBur1.0' => 'haplochromis_burtoni/pep/Haplochromis_burtoni.AstBur1.0.pep.all.fa.gz',
'GCF_000239415.1_AstBur1.0' => 'haplochromis_burtoni/pep/Haplochromis_burtoni.AstBur1.0.pep.all.fa.gz',
'hapBur1' => 'haplochromis_burtoni/pep/Haplochromis_burtoni.AstBur1.0.pep.all.fa.gz',
'GCA_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'GCF_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'hetGla2' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'GCA_000230445.1_HetGla_1.0' => 'heterocephalus_glaber_male/pep/Heterocephalus_glaber_male.HetGla_1.0.pep.all.fa.gz',
'hetGla1' => 'heterocephalus_glaber_male/pep/Heterocephalus_glaber_male.HetGla_1.0.pep.all.fa.gz',
'GCA_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/pep/Hippocampus_comes.H_comes_QL1_v1.pep.all.fa.gz',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/pep/Hippocampus_comes.H_comes_QL1_v1.pep.all.fa.gz',
'GCA_003317085.1_ASM331708v1' => 'hucho_hucho/pep/Hucho_hucho.ASM331708v1.pep.all.fa.gz',
'GCA_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/pep/Ictalurus_punctatus.IpCoco_1.2.pep.all.fa.gz',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/pep/Ictalurus_punctatus.IpCoco_1.2.pep.all.fa.gz',
'GCA_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'GCF_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'GCA_000280705.1_JacJac1.0' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'GCF_000280705.1_JacJac1.0' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'jacJac1' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'GCA_003829775.1_ASM382977v1' => 'junco_hyemalis/pep/Junco_hyemalis.ASM382977v1.pep.all.fa.gz',
'GCA_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/pep/Kryptolebias_marmoratus.ASM164957v1.pep.all.fa.gz',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/pep/Kryptolebias_marmoratus.ASM164957v1.pep.all.fa.gz',
'GCA_900080235.1_BallGen_V1' => 'labrus_bergylta/pep/Labrus_bergylta.BallGen_V1.pep.all.fa.gz',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta/pep/Labrus_bergylta.BallGen_V1.pep.all.fa.gz',
'GCA_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/pep/Larimichthys_crocea.L_crocea_2.0.pep.all.fa.gz',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/pep/Larimichthys_crocea.L_crocea_2.0.pep.all.fa.gz',
'GCA_001640805.1_ASM164080v1' => 'lates_calcarifer/pep/Lates_calcarifer.ASB_HGAPassembly_v1.pep.all.fa.gz',
'GCA_900066035.1_ASB_HGAPassembly_v1' => 'lates_calcarifer/pep/Lates_calcarifer.ASB_HGAPassembly_v1.pep.all.fa.gz',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer/pep/Lates_calcarifer.ASB_HGAPassembly_v1.pep.all.fa.gz',
'GCA_004320025.1_latLat_1.0' => 'laticauda_laticaudata/pep/Laticauda_laticaudata.latLat_1.0.pep.all.fa.gz',
'GCA_000225785.1_LatCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'GCF_000225785.1_LatCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'GCA_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/pep/Lepidothrix_coronata.Lepidothrix_coronata-1.0.pep.all.fa.gz',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/pep/Lepidothrix_coronata.Lepidothrix_coronata-1.0.pep.all.fa.gz',
'GCA_000242695.1_LepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'GCF_000242695.1_LepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'GCA_002197715.1_LonStrDom1' => 'lonchura_striata_domestica/pep/Lonchura_striata_domestica.LonStrDom1.pep.all.fa.gz',
'GCA_000001905.1_Loxafr3.0' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'GCF_000001905.1_Loxafr3.0' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'GCA_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/pep/Lynx_canadensis.mLynCan4_v1.p.pep.all.fa.gz',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/pep/Lynx_canadensis.mLynCan4_v1.p.pep.all.fa.gz',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_5.0.pep.all.fa.gz',
'GCA_011100615.1_Macaca_fascicularis_6.0' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_6.0.pep.all.fa.gz',
'GCA_003339765.3_Mmul_10' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_10.pep.all.fa.gz',
'GCF_003339765.1_Mmul_10' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_10.pep.all.fa.gz',
'rheMac10' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_10.pep.all.fa.gz',
'GCA_000956065.1_Mnem_1.0' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'macNem1' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'GCA_009741485.1_mCya_1.0' => 'malurus_cyaneus_samueli/pep/Malurus_cyaneus_samueli.mCya_1.0.pep.all.fa.gz',
'GCA_001715985.2_ASM171598v2' => 'manacus_vitellinus/pep/Manacus_vitellinus.ASM171598v2.pep.all.fa.gz',
'GCA_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'GCF_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'manLeu1' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'GCA_001458135.1_marMar2.1' => 'marmota_marmota_marmota/pep/Marmota_marmota_marmota.marMar2.1.pep.all.fa.gz',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota/pep/Marmota_marmota_marmota.marMar2.1.pep.all.fa.gz',
'GCA_900324485.1_fMasArm1.1' => 'mastacembelus_armatus/pep/Mastacembelus_armatus.fMasArm1.1.pep.all.fa.gz',
'GCA_900324485.2_fMasArm1.2' => 'mastacembelus_armatus/pep/Mastacembelus_armatus.fMasArm1.2.pep.all.fa.gz',
'GCF_900324485.2_fMasArm1.2' => 'mastacembelus_armatus/pep/Mastacembelus_armatus.fMasArm1.2.pep.all.fa.gz',
'GCA_000238955.5_M_zebra_UMD2a' => 'maylandia_zebra/pep/Maylandia_zebra.M_zebra_UMD2a.pep.all.fa.gz',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra/pep/Maylandia_zebra.M_zebra_UMD2a.pep.all.fa.gz',
'melGal1' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.Turkey_2.01.pep.all.fa.gz',
'GCA_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/pep/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.pep.all.fa.gz',
'GCF_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/pep/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.pep.all.fa.gz',
'melUnd1' => 'melopsittacus_undulatus/pep/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.pep.all.fa.gz',
'GCA_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/pep/Meriones_unguiculatus.MunDraft-v1.0.pep.all.fa.gz',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/pep/Meriones_unguiculatus.MunDraft-v1.0.pep.all.fa.gz',
'GCA_000349665.1_MesAur1.0' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'GCF_000349665.1_MesAur1.0' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'mesAur1' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'GCA_000165445.3_Mmur_3.0' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'GCF_000165445.2_Mmur_3.0' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'micMur3' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'GCA_000317375.1_MicOch1.0' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'GCF_000317375.1_MicOch1.0' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'micOch1' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'GCA_001698575.1_ASM169857v1' => 'mola_mola/pep/Mola_mola.ASM169857v1.pep.all.fa.gz',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica/pep/Monodelphis_domestica.ASM229v1.pep.all.fa.gz',
'GCA_005190385.2_NGI_Narwhal_1' => 'monodon_monoceros/pep/Monodon_monoceros.NGI_Narwhal_1.pep.all.fa.gz',
'GCF_005190385.1_NGI_Narwhal_1' => 'monodon_monoceros/pep/Monodon_monoceros.NGI_Narwhal_1.pep.all.fa.gz',
'GCA_001952655.1_M_albus_1.0' => 'monopterus_albus/pep/Monopterus_albus.M_albus_1.0.pep.all.fa.gz',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus/pep/Monopterus_albus.M_albus_1.0.pep.all.fa.gz',
'GCA_004024705.2_MosMos_v2_BIUU_UCD' => 'moschus_moschiferus/pep/Moschus_moschiferus.MosMos_v2_BIUU_UCD.pep.all.fa.gz',
'GCA_900094665.2_CAROLI_EIJ_v1.1' => 'mus_caroli/pep/Mus_caroli.CAROLI_EIJ_v1.1.pep.all.fa.gz',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli/pep/Mus_caroli.CAROLI_EIJ_v1.1.pep.all.fa.gz',
'GCF_000001635.27_GRCm39' => 'mus_musculus/pep/Mus_musculus.GRCm39.pep.all.fa.gz',
'mm39' => 'mus_musculus/pep/Mus_musculus.GRCm39.pep.all.fa.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/pep/Mus_musculus_129s1svimj.129S1_SvImJ_v1.pep.all.fa.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/pep/Mus_musculus_aj.A_J_v1.pep.all.fa.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/pep/Mus_musculus_akrj.AKR_J_v1.pep.all.fa.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_balbcj.BALB_cJ_v1.pep.all.fa.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/pep/Mus_musculus_c3hhej.C3H_HeJ_v1.pep.all.fa.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/pep/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.pep.all.fa.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/pep/Mus_musculus_casteij.CAST_EiJ_v1.pep.all.fa.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_cbaj.CBA_J_v1.pep.all.fa.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/pep/Mus_musculus_dba2j.DBA_2J_v1.pep.all.fa.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/pep/Mus_musculus_fvbnj.FVB_NJ_v1.pep.all.fa.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/pep/Mus_musculus_lpj.LP_J_v1.pep.all.fa.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/pep/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.pep.all.fa.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/pep/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.pep.all.fa.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/pep/Mus_musculus_pwkphj.PWK_PhJ_v1.pep.all.fa.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/pep/Mus_musculus_wsbeij.WSB_EiJ_v1.pep.all.fa.gz',
'GCA_900095145.2_PAHARI_EIJ_v1.1' => 'mus_pahari/pep/Mus_pahari.PAHARI_EIJ_v1.1.pep.all.fa.gz',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari/pep/Mus_pahari.PAHARI_EIJ_v1.1.pep.all.fa.gz',
'GCA_003336285.1_MUSP714' => 'mus_spicilegus/pep/Mus_spicilegus.MUSP714.pep.all.fa.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/pep/Mus_spretus.SPRET_EiJ_v1.pep.all.fa.gz',
'GCA_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'GCF_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'GCA_000147115.1_Myoluc2.0' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'GCF_000147115.1_Myoluc2.0' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'GCA_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/pep/Myripristis_murdjan.fMyrMur1.1.pep.all.fa.gz',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/pep/Myripristis_murdjan.fMyrMur1.1.pep.all.fa.gz',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'GCF_000622305.1_S.galili_v1.0' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'nanGal1' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'GCA_007210695.1_RGoby_Basel_V2' => 'neogobius_melanostomus/pep/Neogobius_melanostomus.RGoby_Basel_V2.pep.all.fa.gz',
'GCA_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/pep/Neolamprologus_brichardi.NeoBri1.0.pep.all.fa.gz',
'GCF_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/pep/Neolamprologus_brichardi.NeoBri1.0.pep.all.fa.gz',
'neoBri1' => 'neolamprologus_brichardi/pep/Neolamprologus_brichardi.NeoBri1.0.pep.all.fa.gz',
'GCA_900108605.1_NNQGG.v01' => 'neovison_vison/pep/Neovison_vison.NNQGG.v01.pep.all.fa.gz',
'GCA_000146795.3_Nleu_3.0' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu_3.0.pep.all.fa.gz',
'nomLeu3' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu_3.0.pep.all.fa.gz',
'GCA_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/pep/Notechis_scutatus.TS10Xv2-PRI.pep.all.fa.gz',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/pep/Notechis_scutatus.TS10Xv2-PRI.pep.all.fa.gz',
'GCA_001465895.2_Nfu_20140520' => 'nothobranchius_furzeri/pep/Nothobranchius_furzeri.Nfu_20140520.pep.all.fa.gz',
'GCF_001465895.1_Nfu_20140520' => 'nothobranchius_furzeri/pep/Nothobranchius_furzeri.Nfu_20140520.pep.all.fa.gz',
'GCA_003342845.1_notPer1' => 'nothoprocta_perdicaria/pep/Nothoprocta_perdicaria.notPer1.pep.all.fa.gz',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria/pep/Nothoprocta_perdicaria.notPer1.pep.all.fa.gz',
'GCA_002078875.2_NumMel1.0' => 'numida_meleagris/pep/Numida_meleagris.NumMel1.0.pep.all.fa.gz',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris/pep/Numida_meleagris.NumMel1.0.pep.all.fa.gz',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'GCF_000260255.1_OctDeg1.0' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'octDeg1' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'GCA_002021735.2_Okis_V2' => 'oncorhynchus_kisutch/pep/Oncorhynchus_kisutch.Okis_V2.pep.all.fa.gz',
'GCF_002021735.2_Okis_V2' => 'oncorhynchus_kisutch/pep/Oncorhynchus_kisutch.Okis_V2.pep.all.fa.gz',
'GCA_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss/pep/Oncorhynchus_mykiss.Omyk_1.0.pep.all.fa.gz',
'GCF_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss/pep/Oncorhynchus_mykiss.Omyk_1.0.pep.all.fa.gz',
'GCA_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha/pep/Oncorhynchus_tshawytscha.Otsh_v1.0.pep.all.fa.gz',
'GCF_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha/pep/Oncorhynchus_tshawytscha.Otsh_v1.0.pep.all.fa.gz',
'GCA_005870065.1_ASM587006v1' => 'oreochromis_aureus/pep/Oreochromis_aureus.ASM587006v1.pep.all.fa.gz',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus/pep/Oreochromis_aureus.ASM587006v1.pep.all.fa.gz',
'GCA_001858045.3_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.O_niloticus_UMD_NMBU.pep.all.fa.gz',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.O_niloticus_UMD_NMBU.pep.all.fa.gz',
'GCA_004115215.2_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.mOrnAna1.p.v1.pep.all.fa.gz',
'GCF_004115215.1_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.mOrnAna1.p.v1.pep.all.fa.gz',
'GCA_000003625.1_OryCun2.0' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'GCF_000003625.3_OryCun2.0' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'GCA_003999625.1_OJAV_1.1' => 'oryzias_javanicus/pep/Oryzias_javanicus.OJAV_1.1.pep.all.fa.gz',
'GCA_002234675.1_ASM223467v1' => 'oryzias_latipes/pep/Oryzias_latipes.ASM223467v1.pep.all.fa.gz',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes/pep/Oryzias_latipes.ASM223467v1.pep.all.fa.gz',
'GCA_002234715.1_ASM223471v1' => 'oryzias_latipes_hni/pep/Oryzias_latipes_hni.ASM223471v1.pep.all.fa.gz',
'GCA_002234695.1_ASM223469v1' => 'oryzias_latipes_hsok/pep/Oryzias_latipes_hsok.ASM223469v1.pep.all.fa.gz',
'GCA_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/pep/Oryzias_melastigma.Om_v0.7.RACA.pep.all.fa.gz',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/pep/Oryzias_melastigma.Om_v0.7.RACA.pep.all.fa.gz',
'GCA_008586565.1_ASM858656v1' => 'oryzias_sinensis/pep/Oryzias_sinensis.ASM858656v1.pep.all.fa.gz',
'GCA_000181295.3_OtoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'GCA_000298735.1_Oar_v3.1' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'GCA_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet/pep/Ovis_aries_rambouillet.Oar_rambouillet_v1.0.pep.all.fa.gz',
'GCF_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet/pep/Ovis_aries_rambouillet.Oar_rambouillet_v1.0.pep.all.fa.gz',
'GCA_000258655.2_panpan1.1' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'GCF_000258655.2_panpan1.1' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'panPan2' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'GCA_000001515.5_Pan_tro_3.0' => 'pan_troglodytes/pep/Pan_troglodytes.Pan_tro_3.0.pep.all.fa.gz',
'panTro5' => 'pan_troglodytes/pep/Pan_troglodytes.Pan_tro_3.0.pep.all.fa.gz',
'GCA_008795835.1_PanLeo1.0' => 'panthera_leo/pep/Panthera_leo.PanLeo1.0.pep.all.fa.gz',
'GCA_001857705.1_PanPar1.0' => 'panthera_pardus/pep/Panthera_pardus.PanPar1.0.pep.all.fa.gz',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus/pep/Panthera_pardus.PanPar1.0.pep.all.fa.gz',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/pep/Panthera_tigris_altaica.PanTig1.0.pep.all.fa.gz',
'GCF_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/pep/Panthera_tigris_altaica.PanTig1.0.pep.all.fa.gz',
'panTig1' => 'panthera_tigris_altaica/pep/Panthera_tigris_altaica.PanTig1.0.pep.all.fa.gz',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'GCF_000264685.3_Panu_3.0' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'papAnu4' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'GCA_900634625.1_fParRan2.1' => 'parambassis_ranga/pep/Parambassis_ranga.fParRan2.1.pep.all.fa.gz',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga/pep/Parambassis_ranga.fParRan2.1.pep.all.fa.gz',
'GCA_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/pep/Paramormyrops_kingsleyae.PKINGS_0.1.pep.all.fa.gz',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/pep/Paramormyrops_kingsleyae.PKINGS_0.1.pep.all.fa.gz',
'GCA_001522545.2_Parus_major1.1' => 'parus_major/pep/Parus_major.Parus_major1.1.pep.all.fa.gz',
'GCF_001522545.3_Parus_major1.1' => 'parus_major/pep/Parus_major.Parus_major1.1.pep.all.fa.gz',
'GCA_005519975.1_AIIM_Pcri_1.0' => 'pavo_cristatus/pep/Pavo_cristatus.AIIM_Pcri_1.0.pep.all.fa.gz',
'GCA_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'GCF_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'GCA_007922175.1_Pelusios_castaneus-1.0' => 'pelusios_castaneus/pep/Pelusios_castaneus.Pelusios_castaneus-1.0.pep.all.fa.gz',
'GCA_000787105.1_PM.fa' => 'periophthalmus_magnuspinnatus/pep/Periophthalmus_magnuspinnatus.PM.fa.pep.all.fa.gz',
'GCA_003704035.1_HU_Pman_2.1' => 'peromyscus_maniculatus_bairdii/pep/Peromyscus_maniculatus_bairdii.HU_Pman_2.1.pep.all.fa.gz',
'GCA_000148955.1_Petromyzon_marinus-7.0' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'GCA_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/pep/Phascolarctos_cinereus.phaCin_unsw_v4.1.pep.all.fa.gz',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/pep/Phascolarctos_cinereus.phaCin_unsw_v4.1.pep.all.fa.gz',
'GCA_004143745.1_ASM414374v1' => 'phasianus_colchicus/pep/Phasianus_colchicus.ASM414374v1.pep.all.fa.gz',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus/pep/Phasianus_colchicus.ASM414374v1.pep.all.fa.gz',
'GCA_008692025.1_mPhoSin1.pri' => 'phocoena_sinus/pep/Phocoena_sinus.mPhoSin1.pri.pep.all.fa.gz',
'GCF_008692025.1_mPhoSin1.pri' => 'phocoena_sinus/pep/Phocoena_sinus.mPhoSin1.pri.pep.all.fa.gz',
'GCA_002837175.2_ASM283717v2' => 'physeter_catodon/pep/Physeter_catodon.ASM283717v2.pep.all.fa.gz',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon/pep/Physeter_catodon.ASM283717v2.pep.all.fa.gz',
'GCA_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/pep/Piliocolobus_tephrosceles.ASM277652v2.pep.all.fa.gz',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/pep/Piliocolobus_tephrosceles.ASM277652v2.pep.all.fa.gz',
'GCA_004329235.1_PodMur_1.0' => 'podarcis_muralis/pep/Podarcis_muralis.PodMur_1.0.pep.all.fa.gz',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis/pep/Podarcis_muralis.PodMur_1.0.pep.all.fa.gz',
'GCA_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'GCF_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'GCA_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/pep/Poecilia_latipinna.P_latipinna-1.0.pep.all.fa.gz',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/pep/Poecilia_latipinna.P_latipinna-1.0.pep.all.fa.gz',
'GCA_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/pep/Poecilia_mexicana.P_mexicana-1.0.pep.all.fa.gz',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/pep/Poecilia_mexicana.P_mexicana-1.0.pep.all.fa.gz',
'GCA_000633615.2_Guppy_female_1.0_MT' => 'poecilia_reticulata/pep/Poecilia_reticulata.Guppy_female_1.0_MT.pep.all.fa.gz',
'GCF_000633615.1_Guppy_female_1.0_MT' => 'poecilia_reticulata/pep/Poecilia_reticulata.Guppy_female_1.0_MT.pep.all.fa.gz',
'poeRet1' => 'poecilia_reticulata/pep/Poecilia_reticulata.Guppy_female_1.0_MT.pep.all.fa.gz',
'GCA_900067755.1_pvi1.1' => 'pogona_vitticeps/pep/Pogona_vitticeps.pvi1.1.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus/pep/Prolemur_simus.Prosim_1.0.pep.all.fa.gz',
'GCA_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'GCF_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'proCoq1' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'GCA_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/pep/Pseudonaja_textilis.EBS10Xv2-PRI.pep.all.fa.gz',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/pep/Pseudonaja_textilis.EBS10Xv2-PRI.pep.all.fa.gz',
'GCA_000239375.1_PunNye1.0' => 'pundamilia_nyererei/pep/Pundamilia_nyererei.PunNye1.0.pep.all.fa.gz',
'GCF_000239375.1_PunNye1.0' => 'pundamilia_nyererei/pep/Pundamilia_nyererei.PunNye1.0.pep.all.fa.gz',
'punNye1' => 'pundamilia_nyererei/pep/Pundamilia_nyererei.PunNye1.0.pep.all.fa.gz',
'GCA_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/pep/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.pep.all.fa.gz',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/pep/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.pep.all.fa.gz',
'GCA_000001895.4_Rnor_6.0' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'GCF_000001895.5_Rnor_6.0' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'rn6' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/pep/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.pep.all.fa.gz',
'GCF_004115265.1_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/pep/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.pep.all.fa.gz',
'GCA_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'GCF_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'rhiBie1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'GCA_000769185.1_Rrox_v1' => 'rhinopithecus_roxellana/pep/Rhinopithecus_roxellana.Rrox_v1.pep.all.fa.gz',
'rhiRox1' => 'rhinopithecus_roxellana/pep/Rhinopithecus_roxellana.Rrox_v1.pep.all.fa.gz',
'GCA_000146045.2_R64-1-1' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'GCF_000146045.2_R64' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'GCA_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'GCF_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'GCA_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/pep/Salarias_fasciatus.fSalaFa1.1.pep.all.fa.gz',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/pep/Salarias_fasciatus.fSalaFa1.1.pep.all.fa.gz',
'GCA_000233375.4_ICSASG_v2' => 'salmo_salar/pep/Salmo_salar.ICSASG_v2.pep.all.fa.gz',
'GCA_901001165.1_fSalTru1.1' => 'salmo_trutta/pep/Salmo_trutta.fSalTru1.1.pep.all.fa.gz',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta/pep/Salmo_trutta.fSalTru1.1.pep.all.fa.gz',
'GCA_003586115.1_HLtupMer3' => 'salvator_merianae/pep/Salvator_merianae.HLtupMer3.pep.all.fa.gz',
'GCA_008315115.1_SLUC_FBN_1' => 'sander_lucioperca/pep/Sander_lucioperca.SLUC_FBN_1.pep.all.fa.gz',
'GCF_008315115.1_SLUC_FBN_1' => 'sander_lucioperca/pep/Sander_lucioperca.SLUC_FBN_1.pep.all.fa.gz',
'GCA_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.mSarHar1.11.pep.all.fa.gz',
'GCF_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.mSarHar1.11.pep.all.fa.gz',
'GCA_902686455.1_mSciVul1.1' => 'sciurus_vulgaris/pep/Sciurus_vulgaris.mSciVul1.1.pep.all.fa.gz',
'GCA_900964775.1_fSclFor1.1' => 'scleropages_formosus/pep/Scleropages_formosus.fSclFor1.1.pep.all.fa.gz',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus/pep/Scleropages_formosus.fSclFor1.1.pep.all.fa.gz',
'GCA_003186165.1_ASM318616v1' => 'scophthalmus_maximus/pep/Scophthalmus_maximus.ASM318616v1.pep.all.fa.gz',
'GCA_000534875.1_SCA1' => 'serinus_canaria/pep/Serinus_canaria.SCA1.pep.all.fa.gz',
'serCan1' => 'serinus_canaria/pep/Serinus_canaria.SCA1.pep.all.fa.gz',
'GCA_002260705.1_Sdu_1.0' => 'seriola_dumerili/pep/Seriola_dumerili.Sdu_1.0.pep.all.fa.gz',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili/pep/Seriola_dumerili.Sdu_1.0.pep.all.fa.gz',
'GCA_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/pep/Seriola_lalandi_dorsalis.Sedor1.pep.all.fa.gz',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/pep/Seriola_lalandi_dorsalis.Sedor1.pep.all.fa.gz',
'GCA_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/pep/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.pep.all.fa.gz',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/pep/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.pep.all.fa.gz',
'GCA_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/pep/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.pep.all.fa.gz',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/pep/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.pep.all.fa.gz',
'GCA_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/pep/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.pep.all.fa.gz',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/pep/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.pep.all.fa.gz',
'GCA_900880675.1_fSpaAur1.1' => 'sparus_aurata/pep/Sparus_aurata.fSpaAur1.1.pep.all.fa.gz',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata/pep/Sparus_aurata.fSpaAur1.1.pep.all.fa.gz',
'GCA_002406435.1_ASM240643v1' => 'spermophilus_dauricus/pep/Spermophilus_dauricus.ASM240643v1.pep.all.fa.gz',
'GCA_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/pep/Sphaeramia_orbicularis.fSphaOr1.1.pep.all.fa.gz',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/pep/Sphaeramia_orbicularis.fSphaOr1.1.pep.all.fa.gz',
'GCA_003113815.1_ASM311381v1' => 'sphenodon_punctatus/pep/Sphenodon_punctatus.ASM311381v1.pep.all.fa.gz',
'GCA_008694505.1_ASM869450v1' => 'stachyris_ruficeps/pep/Stachyris_ruficeps.ASM869450v1.pep.all.fa.gz',
'GCA_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/pep/Stegastes_partitus.Stegastes_partitus-1.0.2.pep.all.fa.gz',
'GCF_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/pep/Stegastes_partitus.Stegastes_partitus-1.0.2.pep.all.fa.gz',
'stePar1' => 'stegastes_partitus/pep/Stegastes_partitus.Stegastes_partitus-1.0.2.pep.all.fa.gz',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/pep/Strigops_habroptila.bStrHab1_v1.p.pep.all.fa.gz',
'GCF_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/pep/Strigops_habroptila.bStrHab1_v1.p.pep.all.fa.gz',
'GCA_002372975.1_Soccid_v01' => 'strix_occidentalis_caurina/pep/Strix_occidentalis_caurina.Soccid_v01.pep.all.fa.gz',
'GCA_000698965.1_ASM69896v1' => 'struthio_camelus_australis/pep/Struthio_camelus_australis.ASM69896v1.pep.all.fa.gz',
'GCF_000698965.1_ASM69896v1' => 'struthio_camelus_australis/pep/Struthio_camelus_australis.ASM69896v1.pep.all.fa.gz',
'strCam1' => 'struthio_camelus_australis/pep/Struthio_camelus_australis.ASM69896v1.pep.all.fa.gz',
'GCA_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/pep/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.pep.all.fa.gz',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/pep/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.pep.all.fa.gz',
'GCA_000003025.6_Sscrofa11.1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'GCF_000003025.6_Sscrofa11.1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'susScr11' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'GCA_001700235.1_Bamei_pig_v1' => 'sus_scrofa_bamei/pep/Sus_scrofa_bamei.Bamei_pig_v1.pep.all.fa.gz',
'GCA_001700575.1_Berkshire_pig_v1' => 'sus_scrofa_berkshire/pep/Sus_scrofa_berkshire.Berkshire_pig_v1.pep.all.fa.gz',
'GCA_001700165.1_Hampshire_pig_v1' => 'sus_scrofa_hampshire/pep/Sus_scrofa_hampshire.Hampshire_pig_v1.pep.all.fa.gz',
'GCA_001700295.1_Jinhua_pig_v1' => 'sus_scrofa_jinhua/pep/Sus_scrofa_jinhua.Jinhua_pig_v1.pep.all.fa.gz',
'GCA_001700215.1_Landrace_pig_v1' => 'sus_scrofa_landrace/pep/Sus_scrofa_landrace.Landrace_pig_v1.pep.all.fa.gz',
'GCA_001700135.1_Large_White_v1' => 'sus_scrofa_largewhite/pep/Sus_scrofa_largewhite.Large_White_v1.pep.all.fa.gz',
'GCA_001700195.1_Meishan_pig_v1' => 'sus_scrofa_meishan/pep/Sus_scrofa_meishan.Meishan_pig_v1.pep.all.fa.gz',
'GCA_001700255.1_Pietrain_pig_v1' => 'sus_scrofa_pietrain/pep/Sus_scrofa_pietrain.Pietrain_pig_v1.pep.all.fa.gz',
'GCA_001700155.1_Rongchang_pig_v1' => 'sus_scrofa_rongchang/pep/Sus_scrofa_rongchang.Rongchang_pig_v1.pep.all.fa.gz',
'GCA_000472085.2_Tibetan_Pig_v2' => 'sus_scrofa_tibetan/pep/Sus_scrofa_tibetan.Tibetan_Pig_v2.pep.all.fa.gz',
'GCA_002844635.1_USMARCv1.0' => 'sus_scrofa_usmarc/pep/Sus_scrofa_usmarc.USMARCv1.0.pep.all.fa.gz',
'GCA_000325925.2_minipig_v1.0' => 'sus_scrofa_wuzhishan/pep/Sus_scrofa_wuzhishan.minipig_v1.0.pep.all.fa.gz',
'GCA_003957565.2_bTaeGut1_v1.p' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.bTaeGut1_v1.p.pep.all.fa.gz',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.bTaeGut1_v1.p.pep.all.fa.gz',
'GCA_901000725.2_fTakRub1.2' => 'takifugu_rubripes/pep/Takifugu_rubripes.fTakRub1.2.pep.all.fa.gz',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes/pep/Takifugu_rubripes.fTakRub1.2.pep.all.fa.gz',
'GCA_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis/pep/Terrapene_carolina_triunguis.T_m_triunguis-2.0.pep.all.fa.gz',
'GCF_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis/pep/Terrapene_carolina_triunguis.T_m_triunguis-2.0.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada/pep/Theropithecus_gelada.Tgel_1.0.pep.all.fa.gz',
'GCF_003255815.1_Tgel_1.0' => 'theropithecus_gelada/pep/Theropithecus_gelada.Tgel_1.0.pep.all.fa.gz',
'GCA_003426925.1_ASM342692v1' => 'urocitellus_parryii/pep/Urocitellus_parryii.ASM342692v1.pep.all.fa.gz',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii/pep/Urocitellus_parryii.ASM342692v1.pep.all.fa.gz',
'GCA_003344425.1_ASM334442v1' => 'ursus_americanus/pep/Ursus_americanus.ASM334442v1.pep.all.fa.gz',
'GCA_000687225.1_UrsMar_1.0' => 'ursus_maritimus/pep/Ursus_maritimus.UrsMar_1.0.pep.all.fa.gz',
'GCF_000687225.1_UrsMar_1.0' => 'ursus_maritimus/pep/Ursus_maritimus.UrsMar_1.0.pep.all.fa.gz',
'ursMar1' => 'ursus_maritimus/pep/Ursus_maritimus.UrsMar_1.0.pep.all.fa.gz',
'GCA_009660055.1_ASM966005v1' => 'ursus_thibetanus_thibetanus/pep/Ursus_thibetanus_thibetanus.ASM966005v1.pep.all.fa.gz',
'GCA_004798865.1_ASM479886v1' => 'varanus_komodoensis/pep/Varanus_komodoensis.ASM479886v1.pep.all.fa.gz',
'GCA_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/pep/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.pep.all.fa.gz',
'GCF_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/pep/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.pep.all.fa.gz',
'GCA_003160815.1_VulVul2.2' => 'vulpes_vulpes/pep/Vulpes_vulpes.VulVul2.2.pep.all.fa.gz',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes/pep/Vulpes_vulpes.VulVul2.2.pep.all.fa.gz',
'GCA_000004195.3_Xenopus_tropicalis_v9.1' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.pep.all.fa.gz',
'xenTro9' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.pep.all.fa.gz',
'GCA_001444195.1_Xiphophorus_couchianus-4.0.1' => 'xiphophorus_couchianus/pep/Xiphophorus_couchianus.Xiphophorus_couchianus-4.0.1.pep.all.fa.gz',
'GCA_002775205.2_X_maculatus-5.0-male' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.X_maculatus-5.0-male.pep.all.fa.gz',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.X_maculatus-5.0-male.pep.all.fa.gz',
'GCA_009762305.1_mZalCal1.pri' => 'zalophus_californianus/pep/Zalophus_californianus.mZalCal1.pri.pep.all.fa.gz',
'GCA_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/pep/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.pep.all.fa.gz',
'GCF_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/pep/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.pep.all.fa.gz',
'zonAlb1' => 'zonotrichia_albicollis/pep/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.pep.all.fa.gz',
'GCA_001281735.1_ASM128173v1' => 'zosterops_lateralis_melanops/pep/Zosterops_lateralis_melanops.ASM128173v1.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_103 = (
'GCA_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus_core_103_1',
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus_core_103_1',
'GCA_004320145.1_Accipiter_nisus_ver1.0' => 'accipiter_nisus_core_103_1',
'GCF_000004335.2_AilMel_1.0' => 'ailuropoda_melanoleuca_core_103_2',
'GCF_002007445.1_ASM200744v2' => 'ailuropoda_melanoleuca_core_103_2',
'GCA_003947215.1_ASM394721v1' => 'amazona_collaria_core_103_1',
'GCA_000751415.1_Midas_v5' => 'amphilophus_citrinellus_core_103_5',
'GCA_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris_core_103_1',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris_core_103_1',
'GCA_003047355.1_Nemo_v1' => 'amphiprion_percula_core_103_1',
'GCA_900324465.1_fAnaTes1.1' => 'anabas_testudineus_core_103_12',
'GCA_900324465.2_fAnaTes1.2' => 'anabas_testudineus_core_103_12',
'GCF_900324465.2_fAnaTes1.2' => 'anabas_testudineus_core_103_12',
'GCA_008746955.1_ASM874695v1' => 'anas_platyrhynchos_core_103_1',
'GCA_002743455.1_CAU_duck1.0' => 'anas_platyrhynchos_platyrhynchos_core_103_1',
'GCA_002224875.1_ASM222487v1' => 'anas_zonorhyncha_core_103_1',
'GCA_000090745.2_AnoCar2.0' => 'anolis_carolinensis_core_103_2',
'GCF_000090745.1_AnoCar2.0' => 'anolis_carolinensis_core_103_2',
'anoCar2' => 'anolis_carolinensis_core_103_2',
'GCA_002592135.1_ASM259213v1' => 'anser_brachyrhynchus_core_103_1',
'GCA_002166845.1_GooseV1.0' => 'anser_cygnoides_core_103_1',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae_core_103_1',
'GCF_000952055.2_Anan_2.0' => 'aotus_nancymaae_core_103_1',
'aotNan1' => 'aotus_nancymaae_core_103_1',
'GCA_003342985.1_aptHaa1' => 'apteryx_haastii_core_103_1',
'GCA_003342965.1_aptOwe1' => 'apteryx_owenii_core_103_1',
'GCA_003343035.1_aptRow1' => 'apteryx_rowi_core_103_1',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi_core_103_1',
'GCA_900496995.2_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos_core_103_12',
'GCF_900496995.1_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos_core_103_12',
'GCA_900246225.3_fAstCal1.2' => 'astatotilapia_calliptera_core_103_12',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera_core_103_12',
'GCA_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus_core_103_2',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus_core_103_2',
'GCA_004802775.1_Astyanax_mexicanus-1.0.2' => 'astyanax_mexicanus_pachon_core_103_102',
'astMex1' => 'astyanax_mexicanus_pachon_core_103_102',
'GCA_003259725.1_athCun1' => 'athene_cunicularia_core_103_1',
'GCF_003259725.1_athCun1' => 'athene_cunicularia_core_103_1',
'GCA_009873245.2_mBalMus1.v2' => 'balaenoptera_musculus_core_103_2',
'GCA_900634795.2_fBetSpl5.2' => 'betta_splendens_core_103_52',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens_core_103_52',
'GCA_000754665.1_Bison_UMD1.0' => 'bison_bison_bison_core_103_1',
'bisBis1' => 'bison_bison_bison_core_103_1',
'GCA_005887515.1_LU_Bosgru_v3.0' => 'bos_grunniens_core_103_3',
'GCA_003369695.2_UOA_Brahman_1' => 'bos_indicus_hybrid_core_103_1',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid_core_103_1',
'GCA_000298355.1_BosGru_v2.0' => 'bos_mutus_core_103_2',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus_core_103_2',
'bosMut1' => 'bos_mutus_core_103_2',
'GCA_002263795.2_ARS-UCD1.2' => 'bos_taurus_core_103_12',
'GCF_002263795.1_ARS-UCD1.2' => 'bos_taurus_core_103_12',
'bosTau9' => 'bos_taurus_core_103_12',
'GCA_003369685.2_UOA_Angus_1' => 'bos_taurus_hybrid_core_103_1',
'GCF_000002985.6_WBcel235' => 'caenorhabditis_elegans_core_103_269',
'ce11' => 'caenorhabditis_elegans_core_103_269',
'GCA_009194515.1_CaiMos1.0' => 'cairina_moschata_domestica_core_103_1',
'GCA_001431845.1_ASM143184v1' => 'calidris_pugnax_core_103_1',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax_core_103_1',
'GCA_003697955.1_ASM369795v1' => 'calidris_pygmaea_core_103_1',
'GCA_002754865.1_ASM275486v1' => 'callithrix_jacchus_core_103_1',
'GCA_000165045.2_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii_core_103_613',
'GCF_000165045.1_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii_core_103_613',
'calMil1' => 'callorhinchus_milii_core_103_613',
'GCA_901933205.1_STF_HiC' => 'camarhynchus_parvulus_core_103_1',
'GCF_901933205.1_STF_HiC' => 'camarhynchus_parvulus_core_103_1',
'GCA_000803125.2_CamDro2' => 'camelus_dromedarius_core_103_2',
'GCA_003254725.1_ASM325472v1' => 'canis_lupus_dingo_core_103_1',
'GCF_003254725.1_ASM325472v1' => 'canis_lupus_dingo_core_103_1',
'GCA_000002285.2_CanFam3.1' => 'canis_lupus_familiaris_core_103_31',
'GCF_000002285.3_CanFam3.1' => 'canis_lupus_familiaris_core_103_31',
'canFam3' => 'canis_lupus_familiaris_core_103_31',
'GCA_004886185.1_Basenji_breed-1.1' => 'canis_lupus_familiarisbasenji_core_103_11',
'GCA_005444595.1_UMICH_Zoey_3.1' => 'canis_lupus_familiarisgreatdane_core_103_31',
'canFam5' => 'canis_lupus_familiarisgreatdane_core_103_31',
'GCA_001704415.1_ARS1' => 'capra_hircus_core_103_1',
'GCF_001704415.1_ARS1' => 'capra_hircus_core_103_1',
'GCA_004361675.1_CVASU_BBG_1.0' => 'capra_hircus_blackbengal_core_103_1',
'GCA_003368295.1_ASM336829v1' => 'carassius_auratus_core_103_1',
'GCF_003368295.1_ASM336829v1' => 'carassius_auratus_core_103_1',
'GCA_000164805.2_Tarsius_syrichta-2.0.1' => 'carlito_syrichta_core_103_2',
'GCF_000164805.1_Tarsius_syrichta-2.0.1' => 'carlito_syrichta_core_103_2',
'tarSyr2' => 'carlito_syrichta_core_103_2',
'GCA_001984765.1_C.can_genome_v1.0' => 'castor_canadensis_core_103_1',
'GCF_001984765.1_C.can_genome_v1.0' => 'castor_canadensis_core_103_1',
'casCan1' => 'castor_canadensis_core_103_1',
'GCA_004024745.2_CatWag_v2_BIUU_UCD' => 'catagonus_wagneri_core_103_2',
'GCA_009819885.1_bCatUst1.pri' => 'catharus_ustulatus_core_103_1',
'GCF_009819885.1_bCatUst1.pri' => 'catharus_ustulatus_core_103_1',
'GCA_000688575.1_CavAp1.0' => 'cavia_aperea_core_103_10',
'cavApe1' => 'cavia_aperea_core_103_10',
'GCA_000151735.1_Cavpor3.0' => 'cavia_porcellus_core_103_4',
'GCF_000151735.1_Cavpor3.0' => 'cavia_porcellus_core_103_4',
'cavPor3' => 'cavia_porcellus_core_103_4',
'GCA_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus_core_103_1',
'GCF_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus_core_103_1',
'cebCap1' => 'cebus_capucinus_core_103_1',
'GCA_000955945.1_Caty_1.0' => 'cercocebus_atys_core_103_1',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys_core_103_1',
'cerAty1' => 'cercocebus_atys_core_103_1',
'GCA_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii_core_103_1',
'GCF_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii_core_103_1',
'GCA_007922165.1_Chelydra_serpentina-1.0' => 'chelydra_serpentina_core_103_1',
'GCA_000276665.1_ChiLan1.0' => 'chinchilla_lanigera_core_103_1',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera_core_103_1',
'chiLan1' => 'chinchilla_lanigera_core_103_1',
'GCA_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus_core_103_1',
'GCF_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus_core_103_1',
'chlSab2' => 'chlorocebus_sabaeus_core_103_1',
'GCA_000241765.2_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii_core_103_303',
'GCF_000241765.3_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii_core_103_303',
'chrPic2' => 'chrysemys_picta_bellii_core_103_303',
'GCA_003413605.1_Chrysolophus_pictus_GenomeV1.0' => 'chrysolophus_pictus_core_103_1',
'ci3' => 'ciona_intestinalis_core_103_3',
'cioSav2' => 'ciona_savignyi_core_103_2',
'GCA_900700415.1_Ch_v2.0.2' => 'clupea_harengus_core_103_202',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus_core_103_202',
'GCA_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus_core_103_1',
'GCF_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus_core_103_1',
'colAng1' => 'colobus_angolensis_palliatus_core_103_1',
'GCA_900634415.1_fCotGob3.1' => 'cottoperca_gobio_core_103_31',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio_core_103_31',
'GCA_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica_core_103_2',
'GCA_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica_core_103_2',
'GCF_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica_core_103_2',
'GCF_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica_core_103_2',
'cotJap2' => 'coturnix_japonica_core_103_2',
'GCA_900186095.1_CHOK1S_HZDv1' => 'cricetulus_griseus_chok1gshd_core_103_1',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd_core_103_1',
'GCA_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri_core_103_1',
'GCF_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri_core_103_1',
'criGriChoV1' => 'cricetulus_griseus_crigri_core_103_1',
'GCA_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr_core_103_1',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr_core_103_1',
'GCA_001723895.1_CroPor_comp1' => 'crocodylus_porosus_core_103_1',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus_core_103_1',
'GCA_002901205.1_cyaCae2' => 'cyanistes_caeruleus_core_103_2',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus_core_103_2',
'GCA_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus_core_103_1',
'GCF_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus_core_103_1',
'GCA_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis_core_103_1',
'GCF_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis_core_103_1',
'cynSem1' => 'cynoglossus_semilaevis_core_103_1',
'GCA_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus_core_103_1',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus_core_103_1',
'cypVar1' => 'cyprinodon_variegatus_core_103_1',
'GCA_000951615.2_common_carp_genome' => 'cyprinus_carpio_core_103_2',
'GCF_000951615.1_common_carp_genome' => 'cyprinus_carpio_core_103_2',
'GCA_004011555.1_German_Mirror_carp_1.0' => 'cyprinus_carpio_germanmirror_core_103_10',
'GCA_004011595.1_Hebao_red_carp_1.0' => 'cyprinus_carpio_hebaored_core_103_10',
'GCA_004011575.1_Hunaghe_carp_2.0' => 'cyprinus_carpio_huanghe_core_103_20',
'GCA_000208655.2_Dasnov3.0' => 'dasypus_novemcinctus_core_103_3',
'GCF_000208655.1_Dasnov3.0' => 'dasypus_novemcinctus_core_103_3',
'dasNov3' => 'dasypus_novemcinctus_core_103_3',
'GCA_002288925.3_ASM228892v3' => 'delphinapterus_leucas_core_103_3',
'GCF_002288925.2_ASM228892v3' => 'delphinapterus_leucas_core_103_3',
'GCA_900700375.1_fDenClu1.1' => 'denticeps_clupeoides_core_103_11',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides_core_103_11',
'GCA_000689215.1_seabass_V1.0' => 'dicentrarchus_labrax_core_103_1',
'dicLab1' => 'dicentrarchus_labrax_core_103_1',
'GCA_000151885.2_Dord_2.0' => 'dipodomys_ordii_core_103_2',
'GCF_000151885.1_Dord_2.0' => 'dipodomys_ordii_core_103_2',
'dipOrd2' => 'dipodomys_ordii_core_103_2',
'GCA_003342905.1_droNov1' => 'dromaius_novaehollandiae_core_103_1',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae_core_103_1',
'GCF_000001215.4_Release_6_plus_ISO1_MT' => 'drosophila_melanogaster_core_103_9',
'dm6' => 'drosophila_melanogaster_core_103_9',
'GCA_900963305.1_fEcheNa1.1' => 'echeneis_naucrates_core_103_11',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates_core_103_11',
'GCA_003665695.2_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus_core_103_2',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus_core_103_2',
'GCA_900186335.2_Eburgeri_3.2' => 'eptatretus_burgeri_core_103_32',
'GCA_003033725.1_ASM303372v1' => 'equus_asinus_asinus_core_103_1',
'GCA_002863925.1_EquCab3.0' => 'equus_caballus_core_103_3',
'GCF_002863925.1_EquCab3.0' => 'equus_caballus_core_103_3',
'equCab3' => 'equus_caballus_core_103_3',
'GCA_900747795.2_fErpCal1.1' => 'erpetoichthys_calabaricus_core_103_11',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus_core_103_11',
'GCA_003676055.1_GouldianFinch' => 'erythrura_gouldiae_core_103_1',
'GCA_004634155.1_Eluc_v4' => 'esox_lucius_core_103_4',
'GCF_004634155.1_Eluc_v4' => 'esox_lucius_core_103_4',
'GCA_000181335.4_Felis_catus_9.0' => 'felis_catus_core_103_9',
'GCF_000181335.3_Felis_catus_9.0' => 'felis_catus_core_103_9',
'felCat9' => 'felis_catus_core_103_9',
'GCA_000743615.1_DMR_v1.0' => 'fukomys_damarensis_core_103_1',
'GCF_000743615.1_DMR_v1.0' => 'fukomys_damarensis_core_103_1',
'fukDam1' => 'fukomys_damarensis_core_103_1',
'GCA_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus_core_103_302',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus_core_103_302',
'GCA_902167405.1_gadMor3.0' => 'gadus_morhua_core_103_3',
'GCF_902167405.1_gadMor3.0' => 'gadus_morhua_core_103_3',
'GCA_000002315.5_GRCg6a' => 'gallus_gallus_core_103_6',
'GCF_000002315.6_GRCg6a' => 'gallus_gallus_core_103_6',
'galGal6' => 'gallus_gallus_core_103_6',
'GCA_003097735.1_ASM309773v1' => 'gambusia_affinis_core_103_1',
'GCA_000277835.1_GeoFor_1.0' => 'geospiza_fortis_core_103_1',
'GCF_000277835.1_GeoFor_1.0' => 'geospiza_fortis_core_103_1',
'geoFor1' => 'geospiza_fortis_core_103_1',
'GCA_002896415.1_ASM289641v1' => 'gopherus_agassizii_core_103_1',
'GCA_007399415.1_rGopEvg1_v1.p' => 'gopherus_evgoodei_core_103_1',
'GCF_007399415.2_rGopEvg1_v1.p' => 'gopherus_evgoodei_core_103_1',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla_core_103_4',
'gorGor4' => 'gorilla_gorilla_core_103_4',
'GCA_900634775.1_fGouWil2.1' => 'gouania_willdenowi_core_103_21',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi_core_103_21',
'GCA_000239415.1_AstBur1.0' => 'haplochromis_burtoni_core_103_1',
'GCF_000239415.1_AstBur1.0' => 'haplochromis_burtoni_core_103_1',
'hapBur1' => 'haplochromis_burtoni_core_103_1',
'GCA_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female_core_103_1',
'GCF_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female_core_103_1',
'hetGla2' => 'heterocephalus_glaber_female_core_103_1',
'GCA_000230445.1_HetGla_1.0' => 'heterocephalus_glaber_male_core_103_1',
'hetGla1' => 'heterocephalus_glaber_male_core_103_1',
'GCA_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes_core_103_1',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes_core_103_1',
'GCA_003317085.1_ASM331708v1' => 'hucho_hucho_core_103_1',
'GCA_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus_core_103_12',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus_core_103_12',
'GCA_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus_core_103_3',
'GCF_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus_core_103_3',
'speTri2' => 'ictidomys_tridecemlineatus_core_103_3',
'GCA_000280705.1_JacJac1.0' => 'jaculus_jaculus_core_103_10',
'GCF_000280705.1_JacJac1.0' => 'jaculus_jaculus_core_103_10',
'jacJac1' => 'jaculus_jaculus_core_103_10',
'GCA_003829775.1_ASM382977v1' => 'junco_hyemalis_core_103_1',
'GCA_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus_core_103_1',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus_core_103_1',
'GCA_900080235.1_BallGen_V1' => 'labrus_bergylta_core_103_1',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta_core_103_1',
'GCA_000972845.2_L_crocea_2.0' => 'larimichthys_crocea_core_103_20',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea_core_103_20',
'GCA_001640805.1_ASM164080v1' => 'lates_calcarifer_core_103_1',
'GCA_900066035.1_ASB_HGAPassembly_v1' => 'lates_calcarifer_core_103_1',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer_core_103_1',
'GCA_004320025.1_latLat_1.0' => 'laticauda_laticaudata_core_103_1',
'GCA_000225785.1_LatCha1' => 'latimeria_chalumnae_core_103_1',
'GCF_000225785.1_LatCha1' => 'latimeria_chalumnae_core_103_1',
'latCha1' => 'latimeria_chalumnae_core_103_1',
'GCA_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata_core_103_1',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata_core_103_1',
'GCA_000242695.1_LepOcu1' => 'lepisosteus_oculatus_core_103_1',
'GCF_000242695.1_LepOcu1' => 'lepisosteus_oculatus_core_103_1',
'lepOcu1' => 'lepisosteus_oculatus_core_103_1',
'GCA_002197715.1_LonStrDom1' => 'lonchura_striata_domestica_core_103_1',
'GCA_000001905.1_Loxafr3.0' => 'loxodonta_africana_core_103_3',
'GCF_000001905.1_Loxafr3.0' => 'loxodonta_africana_core_103_3',
'loxAfr3' => 'loxodonta_africana_core_103_3',
'GCA_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis_core_103_41',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis_core_103_41',
'GCA_011100615.1_Macaca_fascicularis_6.0' => 'macaca_fascicularis_core_103_6',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis_core_103_6',
'GCA_003339765.3_Mmul_10' => 'macaca_mulatta_core_103_10',
'GCF_003339765.1_Mmul_10' => 'macaca_mulatta_core_103_10',
'rheMac10' => 'macaca_mulatta_core_103_10',
'GCA_000956065.1_Mnem_1.0' => 'macaca_nemestrina_core_103_1',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina_core_103_1',
'macNem1' => 'macaca_nemestrina_core_103_1',
'GCA_009741485.1_mCya_1.0' => 'malurus_cyaneus_samueli_core_103_1',
'GCA_001715985.2_ASM171598v2' => 'manacus_vitellinus_core_103_2',
'GCA_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus_core_103_1',
'GCF_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus_core_103_1',
'manLeu1' => 'mandrillus_leucophaeus_core_103_1',
'GCA_001458135.1_marMar2.1' => 'marmota_marmota_marmota_core_103_21',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota_core_103_21',
'GCA_900324485.1_fMasArm1.1' => 'mastacembelus_armatus_core_103_12',
'GCA_900324485.2_fMasArm1.2' => 'mastacembelus_armatus_core_103_12',
'GCF_900324485.2_fMasArm1.2' => 'mastacembelus_armatus_core_103_12',
'GCA_000238955.5_M_zebra_UMD2a' => 'maylandia_zebra_core_103_2',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra_core_103_2',
'melGal1' => 'meleagris_gallopavo_core_103_21',
'GCA_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus_core_103_63',
'GCF_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus_core_103_63',
'melUnd1' => 'melopsittacus_undulatus_core_103_63',
'GCA_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus_core_103_1',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus_core_103_1',
'GCA_000349665.1_MesAur1.0' => 'mesocricetus_auratus_core_103_10',
'GCF_000349665.1_MesAur1.0' => 'mesocricetus_auratus_core_103_10',
'mesAur1' => 'mesocricetus_auratus_core_103_10',
'GCA_000165445.3_Mmur_3.0' => 'microcebus_murinus_core_103_3',
'GCF_000165445.2_Mmur_3.0' => 'microcebus_murinus_core_103_3',
'micMur3' => 'microcebus_murinus_core_103_3',
'GCA_000317375.1_MicOch1.0' => 'microtus_ochrogaster_core_103_10',
'GCF_000317375.1_MicOch1.0' => 'microtus_ochrogaster_core_103_10',
'micOch1' => 'microtus_ochrogaster_core_103_10',
'GCA_001698575.1_ASM169857v1' => 'mola_mola_core_103_1',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica_core_103_1',
'GCA_005190385.2_NGI_Narwhal_1' => 'monodon_monoceros_core_103_1',
'GCF_005190385.1_NGI_Narwhal_1' => 'monodon_monoceros_core_103_1',
'GCA_001952655.1_M_albus_1.0' => 'monopterus_albus_core_103_1',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus_core_103_1',
'GCA_004024705.2_MosMos_v2_BIUU_UCD' => 'moschus_moschiferus_core_103_2',
'GCA_900094665.2_CAROLI_EIJ_v1.1' => 'mus_caroli_core_103_11',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli_core_103_11',
'GCF_000001635.27_GRCm39' => 'mus_musculus_core_103_39',
'mm39' => 'mus_musculus_core_103_39',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj_core_103_1',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj_core_103_1',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj_core_103_1',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj_core_103_1',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej_core_103_1',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj_core_103_1',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij_core_103_1',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj_core_103_1',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j_core_103_1',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj_core_103_1',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj_core_103_1',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj_core_103_1',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj_core_103_1',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj_core_103_1',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij_core_103_1',
'GCA_900095145.2_PAHARI_EIJ_v1.1' => 'mus_pahari_core_103_11',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari_core_103_11',
'GCA_003336285.1_MUSP714' => 'mus_spicilegus_core_103_714',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_core_103_1',
'GCA_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo_core_103_1',
'GCF_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo_core_103_1',
'musFur1' => 'mustela_putorius_furo_core_103_1',
'GCA_000147115.1_Myoluc2.0' => 'myotis_lucifugus_core_103_2',
'GCF_000147115.1_Myoluc2.0' => 'myotis_lucifugus_core_103_2',
'myoLuc2' => 'myotis_lucifugus_core_103_2',
'GCA_902150065.1_fMyrMur1.1' => 'myripristis_murdjan_core_103_11',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan_core_103_11',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili_core_103_10',
'GCF_000622305.1_S.galili_v1.0' => 'nannospalax_galili_core_103_10',
'nanGal1' => 'nannospalax_galili_core_103_10',
'GCA_007210695.1_RGoby_Basel_V2' => 'neogobius_melanostomus_core_103_2',
'GCA_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi_core_103_1',
'GCF_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi_core_103_1',
'neoBri1' => 'neolamprologus_brichardi_core_103_1',
'GCA_900108605.1_NNQGG.v01' => 'neovison_vison_core_103_1',
'GCA_000146795.3_Nleu_3.0' => 'nomascus_leucogenys_core_103_3',
'nomLeu3' => 'nomascus_leucogenys_core_103_3',
'GCA_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus_core_103_2',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus_core_103_2',
'GCA_001465895.2_Nfu_20140520' => 'nothobranchius_furzeri_core_103_2',
'GCF_001465895.1_Nfu_20140520' => 'nothobranchius_furzeri_core_103_2',
'GCA_003342845.1_notPer1' => 'nothoprocta_perdicaria_core_103_1',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria_core_103_1',
'GCA_002078875.2_NumMel1.0' => 'numida_meleagris_core_103_1',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris_core_103_1',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus_core_103_1',
'GCF_000260255.1_OctDeg1.0' => 'octodon_degus_core_103_1',
'octDeg1' => 'octodon_degus_core_103_1',
'GCA_002021735.2_Okis_V2' => 'oncorhynchus_kisutch_core_103_2',
'GCF_002021735.2_Okis_V2' => 'oncorhynchus_kisutch_core_103_2',
'GCA_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss_core_103_1',
'GCF_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss_core_103_1',
'GCA_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha_core_103_1',
'GCF_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha_core_103_1',
'GCA_005870065.1_ASM587006v1' => 'oreochromis_aureus_core_103_1',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus_core_103_1',
'GCA_001858045.3_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus_core_103_3',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus_core_103_3',
'GCA_004115215.2_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus_core_103_1',
'GCF_004115215.1_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus_core_103_1',
'GCA_000003625.1_OryCun2.0' => 'oryctolagus_cuniculus_core_103_2',
'GCF_000003625.3_OryCun2.0' => 'oryctolagus_cuniculus_core_103_2',
'oryCun2' => 'oryctolagus_cuniculus_core_103_2',
'GCA_003999625.1_OJAV_1.1' => 'oryzias_javanicus_core_103_11',
'GCA_002234675.1_ASM223467v1' => 'oryzias_latipes_core_103_1',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes_core_103_1',
'GCA_002234715.1_ASM223471v1' => 'oryzias_latipes_hni_core_103_1',
'GCA_002234695.1_ASM223469v1' => 'oryzias_latipes_hsok_core_103_1',
'GCA_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma_core_103_07',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma_core_103_07',
'GCA_008586565.1_ASM858656v1' => 'oryzias_sinensis_core_103_1',
'GCA_000181295.3_OtoGar3' => 'otolemur_garnettii_core_103_3',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii_core_103_3',
'otoGar3' => 'otolemur_garnettii_core_103_3',
'GCA_000298735.1_Oar_v3.1' => 'ovis_aries_core_103_31',
'oviAri3' => 'ovis_aries_core_103_31',
'GCA_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet_core_103_1',
'GCF_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet_core_103_1',
'GCA_000258655.2_panpan1.1' => 'pan_paniscus_core_103_1',
'GCF_000258655.2_panpan1.1' => 'pan_paniscus_core_103_1',
'panPan2' => 'pan_paniscus_core_103_1',
'GCA_000001515.5_Pan_tro_3.0' => 'pan_troglodytes_core_103_3',
'panTro5' => 'pan_troglodytes_core_103_3',
'GCA_008795835.1_PanLeo1.0' => 'panthera_leo_core_103_1',
'GCA_001857705.1_PanPar1.0' => 'panthera_pardus_core_103_1',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus_core_103_1',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica_core_103_1',
'GCF_000464555.1_PanTig1.0' => 'panthera_tigris_altaica_core_103_1',
'panTig1' => 'panthera_tigris_altaica_core_103_1',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis_core_103_3',
'GCF_000264685.3_Panu_3.0' => 'papio_anubis_core_103_3',
'papAnu4' => 'papio_anubis_core_103_3',
'GCA_900634625.1_fParRan2.1' => 'parambassis_ranga_core_103_21',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga_core_103_21',
'GCA_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae_core_103_1',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae_core_103_1',
'GCA_001522545.2_Parus_major1.1' => 'parus_major_core_103_1',
'GCF_001522545.3_Parus_major1.1' => 'parus_major_core_103_1',
'GCA_005519975.1_AIIM_Pcri_1.0' => 'pavo_cristatus_core_103_1',
'GCA_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis_core_103_1',
'GCF_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis_core_103_1',
'pelSin1' => 'pelodiscus_sinensis_core_103_1',
'GCA_007922175.1_Pelusios_castaneus-1.0' => 'pelusios_castaneus_core_103_1',
'GCA_000787105.1_PM.fa' => 'periophthalmus_magnuspinnatus_core_103_1',
'GCA_003704035.1_HU_Pman_2.1' => 'peromyscus_maniculatus_bairdii_core_103_21',
'GCA_000148955.1_Petromyzon_marinus-7.0' => 'petromyzon_marinus_core_103_7',
'petMar2' => 'petromyzon_marinus_core_103_7',
'GCA_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus_core_103_41',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus_core_103_41',
'GCA_004143745.1_ASM414374v1' => 'phasianus_colchicus_core_103_1',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus_core_103_1',
'GCA_008692025.1_mPhoSin1.pri' => 'phocoena_sinus_core_103_1',
'GCF_008692025.1_mPhoSin1.pri' => 'phocoena_sinus_core_103_1',
'GCA_002837175.2_ASM283717v2' => 'physeter_catodon_core_103_2',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon_core_103_2',
'GCA_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles_core_103_2',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles_core_103_2',
'GCA_004329235.1_PodMur_1.0' => 'podarcis_muralis_core_103_1',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis_core_103_1',
'GCA_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa_core_103_512',
'GCF_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa_core_103_512',
'poeFor1' => 'poecilia_formosa_core_103_512',
'GCA_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna_core_103_1',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna_core_103_1',
'GCA_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana_core_103_1',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana_core_103_1',
'GCA_000633615.2_Guppy_female_1.0_MT' => 'poecilia_reticulata_core_103_1',
'GCF_000633615.1_Guppy_female_1.0_MT' => 'poecilia_reticulata_core_103_1',
'poeRet1' => 'poecilia_reticulata_core_103_1',
'GCA_900067755.1_pvi1.1' => 'pogona_vitticeps_core_103_11',
'ponAbe2' => 'pongo_abelii_core_103_1',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus_core_103_1',
'GCA_000956105.1_Pcoq_1.0' => 'propithecus_coquereli_core_103_1',
'GCF_000956105.1_Pcoq_1.0' => 'propithecus_coquereli_core_103_1',
'proCoq1' => 'propithecus_coquereli_core_103_1',
'GCA_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis_core_103_2',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis_core_103_2',
'GCA_000239375.1_PunNye1.0' => 'pundamilia_nyererei_core_103_1',
'GCF_000239375.1_PunNye1.0' => 'pundamilia_nyererei_core_103_1',
'punNye1' => 'pundamilia_nyererei_core_103_1',
'GCA_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri_core_103_102',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri_core_103_102',
'GCA_000001895.4_Rnor_6.0' => 'rattus_norvegicus_core_103_6',
'GCF_000001895.5_Rnor_6.0' => 'rattus_norvegicus_core_103_6',
'rn6' => 'rattus_norvegicus_core_103_6',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum_core_103_1',
'GCF_004115265.1_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum_core_103_1',
'GCA_001698545.1_ASM169854v1' => 'rhinopithecus_bieti_core_103_1',
'GCF_001698545.1_ASM169854v1' => 'rhinopithecus_bieti_core_103_1',
'rhiBie1' => 'rhinopithecus_bieti_core_103_1',
'GCA_000769185.1_Rrox_v1' => 'rhinopithecus_roxellana_core_103_1',
'rhiRox1' => 'rhinopithecus_roxellana_core_103_1',
'GCA_000146045.2_R64-1-1' => 'saccharomyces_cerevisiae_core_103_4',
'GCF_000146045.2_R64' => 'saccharomyces_cerevisiae_core_103_4',
'sacCer3' => 'saccharomyces_cerevisiae_core_103_4',
'GCA_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis_core_103_1',
'GCF_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis_core_103_1',
'saiBol1' => 'saimiri_boliviensis_boliviensis_core_103_1',
'GCA_902148845.1_fSalaFa1.1' => 'salarias_fasciatus_core_103_11',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus_core_103_11',
'GCA_000233375.4_ICSASG_v2' => 'salmo_salar_core_103_2',
'GCA_901001165.1_fSalTru1.1' => 'salmo_trutta_core_103_11',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta_core_103_11',
'GCA_003586115.1_HLtupMer3' => 'salvator_merianae_core_103_3',
'GCA_008315115.1_SLUC_FBN_1' => 'sander_lucioperca_core_103_1',
'GCF_008315115.1_SLUC_FBN_1' => 'sander_lucioperca_core_103_1',
'GCA_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii_core_103_1',
'GCF_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii_core_103_1',
'GCA_902686455.1_mSciVul1.1' => 'sciurus_vulgaris_core_103_1',
'GCA_900964775.1_fSclFor1.1' => 'scleropages_formosus_core_103_11',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus_core_103_11',
'GCA_003186165.1_ASM318616v1' => 'scophthalmus_maximus_core_103_1',
'GCA_000534875.1_SCA1' => 'serinus_canaria_core_103_12',
'serCan1' => 'serinus_canaria_core_103_12',
'GCA_002260705.1_Sdu_1.0' => 'seriola_dumerili_core_103_1',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili_core_103_1',
'GCA_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis_core_103_1',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis_core_103_1',
'GCA_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis_core_103_11',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis_core_103_11',
'GCA_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami_core_103_11',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami_core_103_11',
'GCA_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous_core_103_11',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous_core_103_11',
'GCA_900880675.1_fSpaAur1.1' => 'sparus_aurata_core_103_11',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata_core_103_11',
'GCA_002406435.1_ASM240643v1' => 'spermophilus_dauricus_core_103_1',
'GCA_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis_core_103_11',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis_core_103_11',
'GCA_003113815.1_ASM311381v1' => 'sphenodon_punctatus_core_103_1',
'GCA_008694505.1_ASM869450v1' => 'stachyris_ruficeps_core_103_1',
'GCA_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus_core_103_1',
'GCF_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus_core_103_1',
'stePar1' => 'stegastes_partitus_core_103_1',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila_core_103_11',
'GCF_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila_core_103_11',
'GCA_002372975.1_Soccid_v01' => 'strix_occidentalis_caurina_core_103_1',
'GCA_000698965.1_ASM69896v1' => 'struthio_camelus_australis_core_103_1',
'GCF_000698965.1_ASM69896v1' => 'struthio_camelus_australis_core_103_1',
'strCam1' => 'struthio_camelus_australis_core_103_1',
'GCA_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta_core_103_1',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta_core_103_1',
'GCA_000003025.6_Sscrofa11.1' => 'sus_scrofa_core_103_111',
'GCF_000003025.6_Sscrofa11.1' => 'sus_scrofa_core_103_111',
'susScr11' => 'sus_scrofa_core_103_111',
'GCA_001700235.1_Bamei_pig_v1' => 'sus_scrofa_bamei_core_103_1',
'GCA_001700575.1_Berkshire_pig_v1' => 'sus_scrofa_berkshire_core_103_1',
'GCA_001700165.1_Hampshire_pig_v1' => 'sus_scrofa_hampshire_core_103_1',
'GCA_001700295.1_Jinhua_pig_v1' => 'sus_scrofa_jinhua_core_103_1',
'GCA_001700215.1_Landrace_pig_v1' => 'sus_scrofa_landrace_core_103_1',
'GCA_001700135.1_Large_White_v1' => 'sus_scrofa_largewhite_core_103_1',
'GCA_001700195.1_Meishan_pig_v1' => 'sus_scrofa_meishan_core_103_1',
'GCA_001700255.1_Pietrain_pig_v1' => 'sus_scrofa_pietrain_core_103_1',
'GCA_001700155.1_Rongchang_pig_v1' => 'sus_scrofa_rongchang_core_103_1',
'GCA_000472085.2_Tibetan_Pig_v2' => 'sus_scrofa_tibetan_core_103_2',
'GCA_002844635.1_USMARCv1.0' => 'sus_scrofa_usmarc_core_103_1',
'GCA_000325925.2_minipig_v1.0' => 'sus_scrofa_wuzhishan_core_103_10',
'GCA_003957565.2_bTaeGut1_v1.p' => 'taeniopygia_guttata_core_103_12',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata_core_103_12',
'GCA_901000725.2_fTakRub1.2' => 'takifugu_rubripes_core_103_12',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes_core_103_12',
'GCA_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis_core_103_2',
'GCF_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis_core_103_2',
'tetNig2' => 'tetraodon_nigroviridis_core_103_8',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada_core_103_1',
'GCF_003255815.1_Tgel_1.0' => 'theropithecus_gelada_core_103_1',
'GCA_003426925.1_ASM342692v1' => 'urocitellus_parryii_core_103_1',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii_core_103_1',
'GCA_003344425.1_ASM334442v1' => 'ursus_americanus_core_103_1',
'GCA_000687225.1_UrsMar_1.0' => 'ursus_maritimus_core_103_1',
'GCF_000687225.1_UrsMar_1.0' => 'ursus_maritimus_core_103_1',
'ursMar1' => 'ursus_maritimus_core_103_1',
'GCA_009660055.1_ASM966005v1' => 'ursus_thibetanus_thibetanus_core_103_1',
'GCA_004798865.1_ASM479886v1' => 'varanus_komodoensis_core_103_1',
'GCA_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus_core_103_1',
'GCF_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus_core_103_1',
'GCA_003160815.1_VulVul2.2' => 'vulpes_vulpes_core_103_22',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes_core_103_22',
'GCA_000004195.3_Xenopus_tropicalis_v9.1' => 'xenopus_tropicalis_core_103_91',
'xenTro9' => 'xenopus_tropicalis_core_103_91',
'GCA_001444195.1_Xiphophorus_couchianus-4.0.1' => 'xiphophorus_couchianus_core_103_401',
'GCA_002775205.2_X_maculatus-5.0-male' => 'xiphophorus_maculatus_core_103_5',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus_core_103_5',
'GCA_009762305.1_mZalCal1.pri' => 'zalophus_californianus_core_103_1',
'GCA_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis_core_103_101',
'GCF_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis_core_103_101',
'zonAlb1' => 'zonotrichia_albicollis_core_103_101',
'GCA_001281735.1_ASM128173v1' => 'zosterops_lateralis_melanops_core_103_1',
);

my %ensGeneGtfFileNames_104 = (
'GCA_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/Acanthochromis_polyacanthus.ASM210954v1.104.gtf.gz',
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/Acanthochromis_polyacanthus.ASM210954v1.104.gtf.gz',
'GCA_004320145.1_Accipiter_nisus_ver1.0' => 'accipiter_nisus/Accipiter_nisus.Accipiter_nisus_ver1.0.104.gtf.gz',
'GCA_002007445.2_ASM200744v2' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ASM200744v2.104.gtf.gz',
'GCF_002007445.1_ASM200744v2' => 'ailuropoda_melanoleuca/Ailuropoda_melanoleuca.ASM200744v2.104.gtf.gz',
'GCA_003947215.1_ASM394721v1' => 'amazona_collaria/Amazona_collaria.ASM394721v1.104.gtf.gz',
'GCA_000751415.1_Midas_v5' => 'amphilophus_citrinellus/Amphilophus_citrinellus.Midas_v5.104.gtf.gz',
'GCA_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/Amphiprion_ocellaris.AmpOce1.0.104.gtf.gz',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/Amphiprion_ocellaris.AmpOce1.0.104.gtf.gz',
'GCA_003047355.1_Nemo_v1' => 'amphiprion_percula/Amphiprion_percula.Nemo_v1.104.gtf.gz',
'GCA_900324465.1_fAnaTes1.1' => 'anabas_testudineus/Anabas_testudineus.fAnaTes1.1.104.gtf.gz',
'GCA_900324465.2_fAnaTes1.2' => 'anabas_testudineus/Anabas_testudineus.fAnaTes1.2.104.gtf.gz',
'GCF_900324465.2_fAnaTes1.2' => 'anabas_testudineus/Anabas_testudineus.fAnaTes1.2.104.gtf.gz',
'GCA_008746955.1_ASM874695v1' => 'anas_platyrhynchos/Anas_platyrhynchos.ASM874695v1.104.gtf.gz',
'GCA_002743455.1_CAU_duck1.0' => 'anas_platyrhynchos_platyrhynchos/Anas_platyrhynchos_platyrhynchos.CAU_duck1.0.104.gtf.gz',
'GCA_002224875.1_ASM222487v1' => 'anas_zonorhyncha/Anas_zonorhyncha.ASM222487v1.104.gtf.gz',
'GCA_000090745.2_AnoCar2.0' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0v2.104.gtf.gz',
'GCF_000090745.1_AnoCar2.0' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0v2.104.gtf.gz',
'anoCar2' => 'anolis_carolinensis/Anolis_carolinensis.AnoCar2.0v2.104.gtf.gz',
'GCA_002592135.1_ASM259213v1' => 'anser_brachyrhynchus/Anser_brachyrhynchus.ASM259213v1.104.gtf.gz',
'GCA_002166845.1_GooseV1.0' => 'anser_cygnoides/Anser_cygnoides.GooseV1.0.104.gtf.gz',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.104.gtf.gz',
'GCF_000952055.2_Anan_2.0' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.104.gtf.gz',
'aotNan1' => 'aotus_nancymaae/Aotus_nancymaae.Anan_2.0.104.gtf.gz',
'GCA_003342985.1_aptHaa1' => 'apteryx_haastii/Apteryx_haastii.aptHaa1.104.gtf.gz',
'GCA_003342965.1_aptOwe1' => 'apteryx_owenii/Apteryx_owenii.aptOwe1.104.gtf.gz',
'GCA_003343035.1_aptRow1' => 'apteryx_rowi/Apteryx_rowi.aptRow1.104.gtf.gz',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi/Apteryx_rowi.aptRow1.104.gtf.gz',
'GCA_900496995.2_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/Aquila_chrysaetos_chrysaetos.bAquChr1.2.104.gtf.gz',
'GCF_900496995.1_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/Aquila_chrysaetos_chrysaetos.bAquChr1.2.104.gtf.gz',
'GCA_900246225.3_fAstCal1.2' => 'astatotilapia_calliptera/Astatotilapia_calliptera.fAstCal1.2.104.gtf.gz',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera/Astatotilapia_calliptera.fAstCal1.2.104.gtf.gz',
'GCA_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/Astyanax_mexicanus.Astyanax_mexicanus-2.0.104.gtf.gz',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/Astyanax_mexicanus.Astyanax_mexicanus-2.0.104.gtf.gz',
'GCA_004802775.1_Astyanax_mexicanus-1.0.2' => 'astyanax_mexicanus_pachon/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.104.gtf.gz',
'astMex1' => 'astyanax_mexicanus_pachon/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.104.gtf.gz',
'GCA_003259725.1_athCun1' => 'athene_cunicularia/Athene_cunicularia.athCun1.104.gtf.gz',
'GCF_003259725.1_athCun1' => 'athene_cunicularia/Athene_cunicularia.athCun1.104.gtf.gz',
'GCA_009873245.2_mBalMus1.v2' => 'balaenoptera_musculus/Balaenoptera_musculus.mBalMus1.v2.104.gtf.gz',
'GCA_900634795.2_fBetSpl5.2' => 'betta_splendens/Betta_splendens.fBetSpl5.2.104.gtf.gz',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens/Betta_splendens.fBetSpl5.2.104.gtf.gz',
'GCA_000754665.1_Bison_UMD1.0' => 'bison_bison_bison/Bison_bison_bison.Bison_UMD1.0.104.gtf.gz',
'bisBis1' => 'bison_bison_bison/Bison_bison_bison.Bison_UMD1.0.104.gtf.gz',
'GCA_005887515.1_LU_Bosgru_v3.0' => 'bos_grunniens/Bos_grunniens.LU_Bosgru_v3.0.104.gtf.gz',
'GCA_003369695.2_UOA_Brahman_1' => 'bos_indicus_hybrid/Bos_indicus_hybrid.UOA_Brahman_1.104.gtf.gz',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid/Bos_indicus_hybrid.UOA_Brahman_1.104.gtf.gz',
'GCA_000298355.1_BosGru_v2.0' => 'bos_mutus/Bos_mutus.BosGru_v2.0.104.gtf.gz',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus/Bos_mutus.BosGru_v2.0.104.gtf.gz',
'bosMut1' => 'bos_mutus/Bos_mutus.BosGru_v2.0.104.gtf.gz',
'GCA_002263795.2_ARS-UCD1.2' => 'bos_taurus/Bos_taurus.ARS-UCD1.2.104.gtf.gz',
'GCF_002263795.1_ARS-UCD1.2' => 'bos_taurus/Bos_taurus.ARS-UCD1.2.104.gtf.gz',
'bosTau9' => 'bos_taurus/Bos_taurus.ARS-UCD1.2.104.gtf.gz',
'GCA_003369685.2_UOA_Angus_1' => 'bos_taurus_hybrid/Bos_taurus_hybrid.UOA_Angus_1.104.gtf.gz',
'GCA_010303855.1_BubBub1.0' => 'bubo_bubo/Bubo_bubo.BubBub1.0.104.gtf.gz',
'GCA_010312235.1_ButJap1.0' => 'buteo_japonicus/Buteo_japonicus.ButJap1.0.104.gtf.gz',
'GCF_000002985.6_WBcel235' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.104.gtf.gz',
'ce11' => 'caenorhabditis_elegans/Caenorhabditis_elegans.WBcel235.104.gtf.gz',
'GCA_009194515.1_CaiMos1.0' => 'cairina_moschata_domestica/Cairina_moschata_domestica.CaiMos1.0.104.gtf.gz',
'GCA_001431845.1_ASM143184v1' => 'calidris_pugnax/Calidris_pugnax.ASM143184v1.104.gtf.gz',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax/Calidris_pugnax.ASM143184v1.104.gtf.gz',
'GCA_003697955.1_ASM369795v1' => 'calidris_pygmaea/Calidris_pygmaea.ASM369795v1.104.gtf.gz',
'GCA_002754865.1_ASM275486v1' => 'callithrix_jacchus/Callithrix_jacchus.ASM275486v1.104.gtf.gz',
'GCA_000165045.2_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/Callorhinchus_milii.Callorhinchus_milii-6.1.3.104.gtf.gz',
'GCF_000165045.1_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/Callorhinchus_milii.Callorhinchus_milii-6.1.3.104.gtf.gz',
'calMil1' => 'callorhinchus_milii/Callorhinchus_milii.Callorhinchus_milii-6.1.3.104.gtf.gz',
'GCA_901933205.1_STF_HiC' => 'camarhynchus_parvulus/Camarhynchus_parvulus.STF_HiC.104.gtf.gz',
'GCF_901933205.1_STF_HiC' => 'camarhynchus_parvulus/Camarhynchus_parvulus.STF_HiC.104.gtf.gz',
'GCA_000803125.2_CamDro2' => 'camelus_dromedarius/Camelus_dromedarius.CamDro2.104.gtf.gz',
'GCA_003254725.1_ASM325472v1' => 'canis_lupus_dingo/Canis_lupus_dingo.ASM325472v1.104.gtf.gz',
'GCF_003254725.1_ASM325472v1' => 'canis_lupus_dingo/Canis_lupus_dingo.ASM325472v1.104.gtf.gz',
'GCA_000002285.2_CanFam3.1' => 'canis_lupus_familiaris/Canis_lupus_familiaris.CanFam3.1.104.gtf.gz',
'GCF_000002285.3_CanFam3.1' => 'canis_lupus_familiaris/Canis_lupus_familiaris.CanFam3.1.104.gtf.gz',
'canFam3' => 'canis_lupus_familiaris/Canis_lupus_familiaris.CanFam3.1.104.gtf.gz',
'GCA_004886185.1_Basenji_breed-1.1' => 'canis_lupus_familiarisbasenji/Canis_lupus_familiarisbasenji.Basenji_breed-1.1.104.gtf.gz',
'GCA_005444595.1_UMICH_Zoey_3.1' => 'canis_lupus_familiarisgreatdane/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.104.gtf.gz',
'canFam5' => 'canis_lupus_familiarisgreatdane/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.104.gtf.gz',
'GCA_001704415.1_ARS1' => 'capra_hircus/Capra_hircus.ARS1.104.gtf.gz',
'GCF_001704415.1_ARS1' => 'capra_hircus/Capra_hircus.ARS1.104.gtf.gz',
'GCA_004361675.1_CVASU_BBG_1.0' => 'capra_hircus_blackbengal/Capra_hircus_blackbengal.CVASU_BBG_1.0.104.gtf.gz',
'GCA_003368295.1_ASM336829v1' => 'carassius_auratus/Carassius_auratus.ASM336829v1.104.gtf.gz',
'GCF_003368295.1_ASM336829v1' => 'carassius_auratus/Carassius_auratus.ASM336829v1.104.gtf.gz',
'GCA_000164805.2_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.104.gtf.gz',
'GCF_000164805.1_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.104.gtf.gz',
'tarSyr2' => 'carlito_syrichta/Carlito_syrichta.Tarsius_syrichta-2.0.1.104.gtf.gz',
'GCA_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/Castor_canadensis.C.can_genome_v1.0.104.gtf.gz',
'GCF_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/Castor_canadensis.C.can_genome_v1.0.104.gtf.gz',
'casCan1' => 'castor_canadensis/Castor_canadensis.C.can_genome_v1.0.104.gtf.gz',
'GCA_004024745.2_CatWag_v2_BIUU_UCD' => 'catagonus_wagneri/Catagonus_wagneri.CatWag_v2_BIUU_UCD.104.gtf.gz',
'GCA_009819885.1_bCatUst1.pri' => 'catharus_ustulatus/Catharus_ustulatus.bCatUst1.pri.104.gtf.gz',
'GCF_009819885.1_bCatUst1.pri' => 'catharus_ustulatus/Catharus_ustulatus.bCatUst1.pri.104.gtf.gz',
'GCA_000688575.1_CavAp1.0' => 'cavia_aperea/Cavia_aperea.CavAp1.0.104.gtf.gz',
'cavApe1' => 'cavia_aperea/Cavia_aperea.CavAp1.0.104.gtf.gz',
'GCA_000151735.1_Cavpor3.0' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.104.gtf.gz',
'GCF_000151735.1_Cavpor3.0' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.104.gtf.gz',
'cavPor3' => 'cavia_porcellus/Cavia_porcellus.Cavpor3.0.104.gtf.gz',
'GCA_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.104.gtf.gz',
'GCF_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.104.gtf.gz',
'cebCap1' => 'cebus_capucinus/Cebus_capucinus.Cebus_imitator-1.0.104.gtf.gz',
'GCA_000955945.1_Caty_1.0' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.104.gtf.gz',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.104.gtf.gz',
'cerAty1' => 'cercocebus_atys/Cercocebus_atys.Caty_1.0.104.gtf.gz',
'GCA_010411085.1_CEY_v1' => 'cervus_hanglu_yarkandensis/Cervus_hanglu_yarkandensis.CEY_v1.104.gtf.gz',
'GCA_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii/Chelonoidis_abingdonii.ASM359739v1.104.gtf.gz',
'GCF_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii/Chelonoidis_abingdonii.ASM359739v1.104.gtf.gz',
'GCA_007922165.1_Chelydra_serpentina-1.0' => 'chelydra_serpentina/Chelydra_serpentina.Chelydra_serpentina-1.0.104.gtf.gz',
'GCA_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.104.gtf.gz',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.104.gtf.gz',
'chiLan1' => 'chinchilla_lanigera/Chinchilla_lanigera.ChiLan1.0.104.gtf.gz',
'GCA_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.104.gtf.gz',
'GCF_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.104.gtf.gz',
'chlSab2' => 'chlorocebus_sabaeus/Chlorocebus_sabaeus.ChlSab1.1.104.gtf.gz',
'GCA_000241765.2_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.104.gtf.gz',
'GCF_000241765.3_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.104.gtf.gz',
'chrPic2' => 'chrysemys_picta_bellii/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.104.gtf.gz',
'GCA_003413605.1_Chrysolophus_pictus_GenomeV1.0' => 'chrysolophus_pictus/Chrysolophus_pictus.Chrysolophus_pictus_GenomeV1.0.104.gtf.gz',
'ci3' => 'ciona_intestinalis/Ciona_intestinalis.KH.104.gtf.gz',
'cioSav2' => 'ciona_savignyi/Ciona_savignyi.CSAV2.0.104.gtf.gz',
'GCA_900700415.1_Ch_v2.0.2' => 'clupea_harengus/Clupea_harengus.Ch_v2.0.2.104.gtf.gz',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus/Clupea_harengus.Ch_v2.0.2.104.gtf.gz',
'GCA_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.104.gtf.gz',
'GCF_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.104.gtf.gz',
'colAng1' => 'colobus_angolensis_palliatus/Colobus_angolensis_palliatus.Cang.pa_1.0.104.gtf.gz',
'GCA_009650515.1_UO_Cmon_1.0' => 'corvus_moneduloides/Corvus_moneduloides.UO_Cmon_1.0.104.gtf.gz',
'GCA_900634415.1_fCotGob3.1' => 'cottoperca_gobio/Cottoperca_gobio.fCotGob3.1.104.gtf.gz',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio/Cottoperca_gobio.fCotGob3.1.104.gtf.gz',
'GCA_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.104.gtf.gz',
'GCA_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.104.gtf.gz',
'GCF_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.104.gtf.gz',
'GCF_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.104.gtf.gz',
'cotJap2' => 'coturnix_japonica/Coturnix_japonica.Coturnix_japonica_2.0.104.gtf.gz',
'GCA_900186095.1_CHOK1S_HZDv1' => 'cricetulus_griseus_chok1gshd/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.104.gtf.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.104.gtf.gz',
'GCA_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.104.gtf.gz',
'GCF_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.104.gtf.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/Cricetulus_griseus_crigri.CriGri_1.0.104.gtf.gz',
'GCA_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/Cricetulus_griseus_picr.CriGri-PICR.104.gtf.gz',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/Cricetulus_griseus_picr.CriGri-PICR.104.gtf.gz',
'GCA_001723895.1_CroPor_comp1' => 'crocodylus_porosus/Crocodylus_porosus.CroPor_comp1.104.gtf.gz',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus/Crocodylus_porosus.CroPor_comp1.104.gtf.gz',
'GCA_002901205.1_cyaCae2' => 'cyanistes_caeruleus/Cyanistes_caeruleus.cyaCae2.104.gtf.gz',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus/Cyanistes_caeruleus.cyaCae2.104.gtf.gz',
'GCA_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus/Cyclopterus_lumpus.fCycLum1.pri.104.gtf.gz',
'GCF_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus/Cyclopterus_lumpus.fCycLum1.pri.104.gtf.gz',
'GCA_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/Cynoglossus_semilaevis.Cse_v1.0.104.gtf.gz',
'GCF_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/Cynoglossus_semilaevis.Cse_v1.0.104.gtf.gz',
'cynSem1' => 'cynoglossus_semilaevis/Cynoglossus_semilaevis.Cse_v1.0.104.gtf.gz',
'GCA_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/Cyprinodon_variegatus.C_variegatus-1.0.104.gtf.gz',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/Cyprinodon_variegatus.C_variegatus-1.0.104.gtf.gz',
'cypVar1' => 'cyprinodon_variegatus/Cyprinodon_variegatus.C_variegatus-1.0.104.gtf.gz',
'GCA_000951615.2_common_carp_genome' => 'cyprinus_carpio/Cyprinus_carpio.common_carp_genome.104.gtf.gz',
'GCF_000951615.1_common_carp_genome' => 'cyprinus_carpio/Cyprinus_carpio.common_carp_genome.104.gtf.gz',
'GCA_004011555.1_German_Mirror_carp_1.0' => 'cyprinus_carpio_germanmirror/Cyprinus_carpio_germanmirror.German_Mirror_carp_1.0.104.gtf.gz',
'GCA_004011595.1_Hebao_red_carp_1.0' => 'cyprinus_carpio_hebaored/Cyprinus_carpio_hebaored.Hebao_red_carp_1.0.104.gtf.gz',
'GCA_004011575.1_Hunaghe_carp_2.0' => 'cyprinus_carpio_huanghe/Cyprinus_carpio_huanghe.Hunaghe_carp_2.0.104.gtf.gz',
'GCA_000208655.2_Dasnov3.0' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.104.gtf.gz',
'GCF_000208655.1_Dasnov3.0' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.104.gtf.gz',
'dasNov3' => 'dasypus_novemcinctus/Dasypus_novemcinctus.Dasnov3.0.104.gtf.gz',
'GCA_002288925.3_ASM228892v3' => 'delphinapterus_leucas/Delphinapterus_leucas.ASM228892v3.104.gtf.gz',
'GCF_002288925.2_ASM228892v3' => 'delphinapterus_leucas/Delphinapterus_leucas.ASM228892v3.104.gtf.gz',
'GCA_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/Denticeps_clupeoides.fDenClu1.1.104.gtf.gz',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/Denticeps_clupeoides.fDenClu1.1.104.gtf.gz',
'GCA_000689215.1_seabass_V1.0' => 'dicentrarchus_labrax/Dicentrarchus_labrax.seabass_V1.0.104.gtf.gz',
'dicLab1' => 'dicentrarchus_labrax/Dicentrarchus_labrax.seabass_V1.0.104.gtf.gz',
'GCA_000151885.2_Dord_2.0' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.104.gtf.gz',
'GCF_000151885.1_Dord_2.0' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.104.gtf.gz',
'dipOrd2' => 'dipodomys_ordii/Dipodomys_ordii.Dord_2.0.104.gtf.gz',
'GCA_003342905.1_droNov1' => 'dromaius_novaehollandiae/Dromaius_novaehollandiae.droNov1.104.gtf.gz',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae/Dromaius_novaehollandiae.droNov1.104.gtf.gz',
'GCA_000001215.4_Release_6_plus_ISO1_MT' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.32.104.gtf.gz',
'GCF_000001215.4_Release_6_plus_ISO1_MT' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.32.104.gtf.gz',
'dm6' => 'drosophila_melanogaster/Drosophila_melanogaster.BDGP6.32.104.gtf.gz',
'GCA_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/Echeneis_naucrates.fEcheNa1.1.104.gtf.gz',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/Echeneis_naucrates.fEcheNa1.1.104.gtf.gz',
'GCA_003665695.2_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.104.gtf.gz',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.104.gtf.gz',
'GCA_900186335.2_Eburgeri_3.2' => 'eptatretus_burgeri/Eptatretus_burgeri.Eburgeri_3.2.104.gtf.gz',
'GCA_003033725.1_ASM303372v1' => 'equus_asinus_asinus/Equus_asinus_asinus.ASM303372v1.104.gtf.gz',
'GCA_002863925.1_EquCab3.0' => 'equus_caballus/Equus_caballus.EquCab3.0.104.gtf.gz',
'GCF_002863925.1_EquCab3.0' => 'equus_caballus/Equus_caballus.EquCab3.0.104.gtf.gz',
'equCab3' => 'equus_caballus/Equus_caballus.EquCab3.0.104.gtf.gz',
'GCA_900747795.2_fErpCal1.1' => 'erpetoichthys_calabaricus/Erpetoichthys_calabaricus.fErpCal1.1.104.gtf.gz',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus/Erpetoichthys_calabaricus.fErpCal1.1.104.gtf.gz',
'GCA_003676055.1_GouldianFinch' => 'erythrura_gouldiae/Erythrura_gouldiae.GouldianFinch.104.gtf.gz',
'GCA_004634155.1_Eluc_v4' => 'esox_lucius/Esox_lucius.Eluc_v4.104.gtf.gz',
'GCF_004634155.1_Eluc_v4' => 'esox_lucius/Esox_lucius.Eluc_v4.104.gtf.gz',
'GCA_010332995.1_FalTin1.0' => 'falco_tinnunculus/Falco_tinnunculus.FalTin1.0.104.gtf.gz',
'GCA_000181335.4_Felis_catus_9.0' => 'felis_catus/Felis_catus.Felis_catus_9.0.104.gtf.gz',
'GCF_000181335.3_Felis_catus_9.0' => 'felis_catus/Felis_catus.Felis_catus_9.0.104.gtf.gz',
'felCat9' => 'felis_catus/Felis_catus.Felis_catus_9.0.104.gtf.gz',
'GCA_000247815.2_FicAlb1.5' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb1.5.104.gtf.gz',
'GCF_000247815.1_FicAlb1.5' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb1.5.104.gtf.gz',
'ficAlb1' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb1.5.104.gtf.gz',
'ficAlb2' => 'ficedula_albicollis/Ficedula_albicollis.FicAlb1.5.104.gtf.gz',
'GCA_000743615.1_DMR_v1.0' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.104.gtf.gz',
'GCF_000743615.1_DMR_v1.0' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.104.gtf.gz',
'fukDam1' => 'fukomys_damarensis/Fukomys_damarensis.DMR_v1.0.104.gtf.gz',
'GCA_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.104.gtf.gz',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.104.gtf.gz',
'GCA_902167405.1_gadMor3.0' => 'gadus_morhua/Gadus_morhua.gadMor3.0.104.gtf.gz',
'GCF_902167405.1_gadMor3.0' => 'gadus_morhua/Gadus_morhua.gadMor3.0.104.gtf.gz',
'GCA_000002315.5_GRCg6a' => 'gallus_gallus/Gallus_gallus.GRCg6a.104.gtf.gz',
'GCF_000002315.6_GRCg6a' => 'gallus_gallus/Gallus_gallus.GRCg6a.104.gtf.gz',
'galGal6' => 'gallus_gallus/Gallus_gallus.GRCg6a.104.gtf.gz',
'GCA_003097735.1_ASM309773v1' => 'gambusia_affinis/Gambusia_affinis.ASM309773v1.104.gtf.gz',
'GCA_000277835.1_GeoFor_1.0' => 'geospiza_fortis/Geospiza_fortis.GeoFor_1.0.104.gtf.gz',
'GCF_000277835.1_GeoFor_1.0' => 'geospiza_fortis/Geospiza_fortis.GeoFor_1.0.104.gtf.gz',
'geoFor1' => 'geospiza_fortis/Geospiza_fortis.GeoFor_1.0.104.gtf.gz',
'GCA_002896415.1_ASM289641v1' => 'gopherus_agassizii/Gopherus_agassizii.ASM289641v1.104.gtf.gz',
'GCA_007399415.1_rGopEvg1_v1.p' => 'gopherus_evgoodei/Gopherus_evgoodei.rGopEvg1_v1.p.104.gtf.gz',
'GCF_007399415.2_rGopEvg1_v1.p' => 'gopherus_evgoodei/Gopherus_evgoodei.rGopEvg1_v1.p.104.gtf.gz',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla/Gorilla_gorilla.gorGor4.104.gtf.gz',
'gorGor4' => 'gorilla_gorilla/Gorilla_gorilla.gorGor4.104.gtf.gz',
'GCA_900634775.1_fGouWil2.1' => 'gouania_willdenowi/Gouania_willdenowi.fGouWil2.1.104.gtf.gz',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi/Gouania_willdenowi.fGouWil2.1.104.gtf.gz',
'GCA_000239415.1_AstBur1.0' => 'haplochromis_burtoni/Haplochromis_burtoni.AstBur1.0.104.gtf.gz',
'GCF_000239415.1_AstBur1.0' => 'haplochromis_burtoni/Haplochromis_burtoni.AstBur1.0.104.gtf.gz',
'hapBur1' => 'haplochromis_burtoni/Haplochromis_burtoni.AstBur1.0.104.gtf.gz',
'GCA_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.104.gtf.gz',
'GCF_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.104.gtf.gz',
'hetGla2' => 'heterocephalus_glaber_female/Heterocephalus_glaber_female.HetGla_female_1.0.104.gtf.gz',
'GCA_000230445.1_HetGla_1.0' => 'heterocephalus_glaber_male/Heterocephalus_glaber_male.HetGla_1.0.104.gtf.gz',
'hetGla1' => 'heterocephalus_glaber_male/Heterocephalus_glaber_male.HetGla_1.0.104.gtf.gz',
'GCA_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/Hippocampus_comes.H_comes_QL1_v1.104.gtf.gz',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/Hippocampus_comes.H_comes_QL1_v1.104.gtf.gz',
'GCA_003317085.1_ASM331708v1' => 'hucho_hucho/Hucho_hucho.ASM331708v1.104.gtf.gz',
'GCA_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/Ictalurus_punctatus.IpCoco_1.2.104.gtf.gz',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/Ictalurus_punctatus.IpCoco_1.2.104.gtf.gz',
'GCA_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.104.gtf.gz',
'GCF_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.104.gtf.gz',
'speTri2' => 'ictidomys_tridecemlineatus/Ictidomys_tridecemlineatus.SpeTri2.0.104.gtf.gz',
'GCA_000280705.1_JacJac1.0' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.104.gtf.gz',
'GCF_000280705.1_JacJac1.0' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.104.gtf.gz',
'jacJac1' => 'jaculus_jaculus/Jaculus_jaculus.JacJac1.0.104.gtf.gz',
'GCA_003829775.1_ASM382977v1' => 'junco_hyemalis/Junco_hyemalis.ASM382977v1.104.gtf.gz',
'GCA_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/Kryptolebias_marmoratus.ASM164957v1.104.gtf.gz',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/Kryptolebias_marmoratus.ASM164957v1.104.gtf.gz',
'GCA_900080235.1_BallGen_V1' => 'labrus_bergylta/Labrus_bergylta.BallGen_V1.104.gtf.gz',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta/Labrus_bergylta.BallGen_V1.104.gtf.gz',
'GCA_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/Larimichthys_crocea.L_crocea_2.0.104.gtf.gz',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/Larimichthys_crocea.L_crocea_2.0.104.gtf.gz',
'GCA_001640805.1_ASM164080v1' => 'lates_calcarifer/Lates_calcarifer.ASB_HGAPassembly_v1.104.gtf.gz',
'GCA_900066035.1_ASB_HGAPassembly_v1' => 'lates_calcarifer/Lates_calcarifer.ASB_HGAPassembly_v1.104.gtf.gz',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer/Lates_calcarifer.ASB_HGAPassembly_v1.104.gtf.gz',
'GCA_004320025.1_latLat_1.0' => 'laticauda_laticaudata/Laticauda_laticaudata.latLat_1.0.104.gtf.gz',
'GCA_000225785.1_LatCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.104.gtf.gz',
'GCF_000225785.1_LatCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.104.gtf.gz',
'latCha1' => 'latimeria_chalumnae/Latimeria_chalumnae.LatCha1.104.gtf.gz',
'GCA_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/Lepidothrix_coronata.Lepidothrix_coronata-1.0.104.gtf.gz',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/Lepidothrix_coronata.Lepidothrix_coronata-1.0.104.gtf.gz',
'GCA_000242695.1_LepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.104.gtf.gz',
'GCF_000242695.1_LepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.104.gtf.gz',
'lepOcu1' => 'lepisosteus_oculatus/Lepisosteus_oculatus.LepOcu1.104.gtf.gz',
'GCA_009667805.1_ASM966780v1' => 'leptobrachium_leishanense/Leptobrachium_leishanense.ASM966780v1.104.gtf.gz',
'GCA_002197715.1_LonStrDom1' => 'lonchura_striata_domestica/Lonchura_striata_domestica.LonStrDom1.104.gtf.gz',
'GCA_000001905.1_Loxafr3.0' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.104.gtf.gz',
'GCF_000001905.1_Loxafr3.0' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.104.gtf.gz',
'loxAfr3' => 'loxodonta_africana/Loxodonta_africana.loxAfr3.104.gtf.gz',
'GCA_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/Lynx_canadensis.mLynCan4_v1.p.104.gtf.gz',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/Lynx_canadensis.mLynCan4_v1.p.104.gtf.gz',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_5.0.104.gtf.gz',
'GCA_011100615.1_Macaca_fascicularis_6.0' => 'macaca_fascicularis/Macaca_fascicularis.Macaca_fascicularis_6.0.104.gtf.gz',
'GCA_003339765.3_Mmul_10' => 'macaca_mulatta/Macaca_mulatta.Mmul_10.104.gtf.gz',
'GCF_003339765.1_Mmul_10' => 'macaca_mulatta/Macaca_mulatta.Mmul_10.104.gtf.gz',
'rheMac10' => 'macaca_mulatta/Macaca_mulatta.Mmul_10.104.gtf.gz',
'GCA_000956065.1_Mnem_1.0' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.104.gtf.gz',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.104.gtf.gz',
'macNem1' => 'macaca_nemestrina/Macaca_nemestrina.Mnem_1.0.104.gtf.gz',
'GCA_009741485.1_mCya_1.0' => 'malurus_cyaneus_samueli/Malurus_cyaneus_samueli.mCya_1.0.104.gtf.gz',
'GCA_001715985.2_ASM171598v2' => 'manacus_vitellinus/Manacus_vitellinus.ASM171598v2.104.gtf.gz',
'GCA_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.104.gtf.gz',
'GCF_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.104.gtf.gz',
'manLeu1' => 'mandrillus_leucophaeus/Mandrillus_leucophaeus.Mleu.le_1.0.104.gtf.gz',
'GCA_001458135.1_marMar2.1' => 'marmota_marmota_marmota/Marmota_marmota_marmota.marMar2.1.104.gtf.gz',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota/Marmota_marmota_marmota.marMar2.1.104.gtf.gz',
'GCA_900324485.1_fMasArm1.1' => 'mastacembelus_armatus/Mastacembelus_armatus.fMasArm1.1.104.gtf.gz',
'GCA_900324485.2_fMasArm1.2' => 'mastacembelus_armatus/Mastacembelus_armatus.fMasArm1.2.104.gtf.gz',
'GCF_900324485.2_fMasArm1.2' => 'mastacembelus_armatus/Mastacembelus_armatus.fMasArm1.2.104.gtf.gz',
'GCA_000238955.5_M_zebra_UMD2a' => 'maylandia_zebra/Maylandia_zebra.M_zebra_UMD2a.104.gtf.gz',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra/Maylandia_zebra.M_zebra_UMD2a.104.gtf.gz',
'GCA_000146605.2_Turkey_2.01' => 'meleagris_gallopavo/Meleagris_gallopavo.Turkey_2.01.104.gtf.gz',
'melGal5' => 'meleagris_gallopavo/Meleagris_gallopavo.Turkey_5.1.104.gtf.gz',
'GCA_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.104.gtf.gz',
'GCF_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.104.gtf.gz',
'melUnd1' => 'melopsittacus_undulatus/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.104.gtf.gz',
'GCA_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/Meriones_unguiculatus.MunDraft-v1.0.104.gtf.gz',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/Meriones_unguiculatus.MunDraft-v1.0.104.gtf.gz',
'GCA_000349665.1_MesAur1.0' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.104.gtf.gz',
'GCF_000349665.1_MesAur1.0' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.104.gtf.gz',
'mesAur1' => 'mesocricetus_auratus/Mesocricetus_auratus.MesAur1.0.104.gtf.gz',
'GCA_000165445.3_Mmur_3.0' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.104.gtf.gz',
'GCF_000165445.2_Mmur_3.0' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.104.gtf.gz',
'micMur3' => 'microcebus_murinus/Microcebus_murinus.Mmur_3.0.104.gtf.gz',
'GCA_000317375.1_MicOch1.0' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.104.gtf.gz',
'GCF_000317375.1_MicOch1.0' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.104.gtf.gz',
'micOch1' => 'microtus_ochrogaster/Microtus_ochrogaster.MicOch1.0.104.gtf.gz',
'GCA_001698575.1_ASM169857v1' => 'mola_mola/Mola_mola.ASM169857v1.104.gtf.gz',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica/Monodelphis_domestica.ASM229v1.104.gtf.gz',
'GCA_005190385.2_NGI_Narwhal_1' => 'monodon_monoceros/Monodon_monoceros.NGI_Narwhal_1.104.gtf.gz',
'GCF_005190385.1_NGI_Narwhal_1' => 'monodon_monoceros/Monodon_monoceros.NGI_Narwhal_1.104.gtf.gz',
'GCA_001952655.1_M_albus_1.0' => 'monopterus_albus/Monopterus_albus.M_albus_1.0.104.gtf.gz',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus/Monopterus_albus.M_albus_1.0.104.gtf.gz',
'GCA_004024705.2_MosMos_v2_BIUU_UCD' => 'moschus_moschiferus/Moschus_moschiferus.MosMos_v2_BIUU_UCD.104.gtf.gz',
'GCA_900094665.2_CAROLI_EIJ_v1.1' => 'mus_caroli/Mus_caroli.CAROLI_EIJ_v1.1.104.gtf.gz',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli/Mus_caroli.CAROLI_EIJ_v1.1.104.gtf.gz',
'GCA_000001635.9_GRCm39' => 'mus_musculus/Mus_musculus.GRCm39.104.gtf.gz',
'GCF_000001635.27_GRCm39' => 'mus_musculus/Mus_musculus.GRCm39.104.gtf.gz',
'mm39' => 'mus_musculus/Mus_musculus.GRCm39.104.gtf.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/Mus_musculus_129s1svimj.129S1_SvImJ_v1.104.gtf.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/Mus_musculus_aj.A_J_v1.104.gtf.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/Mus_musculus_akrj.AKR_J_v1.104.gtf.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/Mus_musculus_balbcj.BALB_cJ_v1.104.gtf.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/Mus_musculus_c3hhej.C3H_HeJ_v1.104.gtf.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.104.gtf.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/Mus_musculus_casteij.CAST_EiJ_v1.104.gtf.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/Mus_musculus_cbaj.CBA_J_v1.104.gtf.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/Mus_musculus_dba2j.DBA_2J_v1.104.gtf.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/Mus_musculus_fvbnj.FVB_NJ_v1.104.gtf.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/Mus_musculus_lpj.LP_J_v1.104.gtf.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.104.gtf.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.104.gtf.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/Mus_musculus_pwkphj.PWK_PhJ_v1.104.gtf.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/Mus_musculus_wsbeij.WSB_EiJ_v1.104.gtf.gz',
'GCA_900095145.2_PAHARI_EIJ_v1.1' => 'mus_pahari/Mus_pahari.PAHARI_EIJ_v1.1.104.gtf.gz',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari/Mus_pahari.PAHARI_EIJ_v1.1.104.gtf.gz',
'GCA_003336285.1_MUSP714' => 'mus_spicilegus/Mus_spicilegus.MUSP714.104.gtf.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/Mus_spretus.SPRET_EiJ_v1.104.gtf.gz',
'GCA_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.104.gtf.gz',
'GCF_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.104.gtf.gz',
'musFur1' => 'mustela_putorius_furo/Mustela_putorius_furo.MusPutFur1.0.104.gtf.gz',
'GCA_000147115.1_Myoluc2.0' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.104.gtf.gz',
'GCF_000147115.1_Myoluc2.0' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.104.gtf.gz',
'myoLuc2' => 'myotis_lucifugus/Myotis_lucifugus.Myoluc2.0.104.gtf.gz',
'GCA_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/Myripristis_murdjan.fMyrMur1.1.104.gtf.gz',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/Myripristis_murdjan.fMyrMur1.1.104.gtf.gz',
'GCA_009733165.1_Nana_v5' => 'naja_naja/Naja_naja.Nana_v5.104.gtf.gz',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.104.gtf.gz',
'GCF_000622305.1_S.galili_v1.0' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.104.gtf.gz',
'nanGal1' => 'nannospalax_galili/Nannospalax_galili.S.galili_v1.0.104.gtf.gz',
'GCA_007210695.1_RGoby_Basel_V2' => 'neogobius_melanostomus/Neogobius_melanostomus.RGoby_Basel_V2.104.gtf.gz',
'GCA_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/Neolamprologus_brichardi.NeoBri1.0.104.gtf.gz',
'GCF_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/Neolamprologus_brichardi.NeoBri1.0.104.gtf.gz',
'neoBri1' => 'neolamprologus_brichardi/Neolamprologus_brichardi.NeoBri1.0.104.gtf.gz',
'GCA_900108605.1_NNQGG.v01' => 'neovison_vison/Neovison_vison.NNQGG.v01.104.gtf.gz',
'GCA_000146795.3_Nleu_3.0' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu_3.0.104.gtf.gz',
'nomLeu3' => 'nomascus_leucogenys/Nomascus_leucogenys.Nleu_3.0.104.gtf.gz',
'GCA_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/Notechis_scutatus.TS10Xv2-PRI.104.gtf.gz',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/Notechis_scutatus.TS10Xv2-PRI.104.gtf.gz',
'GCA_001465895.2_Nfu_20140520' => 'nothobranchius_furzeri/Nothobranchius_furzeri.Nfu_20140520.104.gtf.gz',
'GCF_001465895.1_Nfu_20140520' => 'nothobranchius_furzeri/Nothobranchius_furzeri.Nfu_20140520.104.gtf.gz',
'GCA_003342845.1_notPer1' => 'nothoprocta_perdicaria/Nothoprocta_perdicaria.notPer1.104.gtf.gz',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria/Nothoprocta_perdicaria.notPer1.104.gtf.gz',
'GCA_002078875.2_NumMel1.0' => 'numida_meleagris/Numida_meleagris.NumMel1.0.104.gtf.gz',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris/Numida_meleagris.NumMel1.0.104.gtf.gz',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus/Octodon_degus.OctDeg1.0.104.gtf.gz',
'GCF_000260255.1_OctDeg1.0' => 'octodon_degus/Octodon_degus.OctDeg1.0.104.gtf.gz',
'octDeg1' => 'octodon_degus/Octodon_degus.OctDeg1.0.104.gtf.gz',
'GCA_002021735.2_Okis_V2' => 'oncorhynchus_kisutch/Oncorhynchus_kisutch.Okis_V2.104.gtf.gz',
'GCF_002021735.2_Okis_V2' => 'oncorhynchus_kisutch/Oncorhynchus_kisutch.Okis_V2.104.gtf.gz',
'GCA_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss/Oncorhynchus_mykiss.Omyk_1.0.104.gtf.gz',
'GCF_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss/Oncorhynchus_mykiss.Omyk_1.0.104.gtf.gz',
'GCA_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha/Oncorhynchus_tshawytscha.Otsh_v1.0.104.gtf.gz',
'GCF_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha/Oncorhynchus_tshawytscha.Otsh_v1.0.104.gtf.gz',
'GCA_005870065.1_ASM587006v1' => 'oreochromis_aureus/Oreochromis_aureus.ASM587006v1.104.gtf.gz',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus/Oreochromis_aureus.ASM587006v1.104.gtf.gz',
'GCA_001858045.3_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/Oreochromis_niloticus.O_niloticus_UMD_NMBU.104.gtf.gz',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/Oreochromis_niloticus.O_niloticus_UMD_NMBU.104.gtf.gz',
'GCA_004115215.2_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.mOrnAna1.p.v1.104.gtf.gz',
'GCF_004115215.1_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus/Ornithorhynchus_anatinus.mOrnAna1.p.v1.104.gtf.gz',
'GCA_000003625.1_OryCun2.0' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.104.gtf.gz',
'GCF_000003625.3_OryCun2.0' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.104.gtf.gz',
'oryCun2' => 'oryctolagus_cuniculus/Oryctolagus_cuniculus.OryCun2.0.104.gtf.gz',
'GCA_003999625.1_OJAV_1.1' => 'oryzias_javanicus/Oryzias_javanicus.OJAV_1.1.104.gtf.gz',
'GCA_002234675.1_ASM223467v1' => 'oryzias_latipes/Oryzias_latipes.ASM223467v1.104.gtf.gz',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes/Oryzias_latipes.ASM223467v1.104.gtf.gz',
'GCA_002234715.1_ASM223471v1' => 'oryzias_latipes_hni/Oryzias_latipes_hni.ASM223471v1.104.gtf.gz',
'GCA_002234695.1_ASM223469v1' => 'oryzias_latipes_hsok/Oryzias_latipes_hsok.ASM223469v1.104.gtf.gz',
'GCA_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/Oryzias_melastigma.Om_v0.7.RACA.104.gtf.gz',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/Oryzias_melastigma.Om_v0.7.RACA.104.gtf.gz',
'GCA_008586565.1_ASM858656v1' => 'oryzias_sinensis/Oryzias_sinensis.ASM858656v1.104.gtf.gz',
'GCA_000181295.3_OtoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.104.gtf.gz',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.104.gtf.gz',
'otoGar3' => 'otolemur_garnettii/Otolemur_garnettii.OtoGar3.104.gtf.gz',
'GCA_010365825.1_OtuSun1.0' => 'otus_sunia/Otus_sunia.OtuSun1.0.104.gtf.gz',
'GCA_000298735.1_Oar_v3.1' => 'ovis_aries/Ovis_aries.Oar_v3.1.104.gtf.gz',
'oviAri3' => 'ovis_aries/Ovis_aries.Oar_v3.1.104.gtf.gz',
'GCA_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet/Ovis_aries_rambouillet.Oar_rambouillet_v1.0.104.gtf.gz',
'GCF_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet/Ovis_aries_rambouillet.Oar_rambouillet_v1.0.104.gtf.gz',
'GCA_000258655.2_panpan1.1' => 'pan_paniscus/Pan_paniscus.panpan1.1.104.gtf.gz',
'GCF_000258655.2_panpan1.1' => 'pan_paniscus/Pan_paniscus.panpan1.1.104.gtf.gz',
'panPan2' => 'pan_paniscus/Pan_paniscus.panpan1.1.104.gtf.gz',
'GCA_000001515.5_Pan_tro_3.0' => 'pan_troglodytes/Pan_troglodytes.Pan_tro_3.0.104.gtf.gz',
'panTro5' => 'pan_troglodytes/Pan_troglodytes.Pan_tro_3.0.104.gtf.gz',
'GCA_008795835.1_PanLeo1.0' => 'panthera_leo/Panthera_leo.PanLeo1.0.104.gtf.gz',
'GCA_001857705.1_PanPar1.0' => 'panthera_pardus/Panthera_pardus.PanPar1.0.104.gtf.gz',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus/Panthera_pardus.PanPar1.0.104.gtf.gz',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/Panthera_tigris_altaica.PanTig1.0.104.gtf.gz',
'GCF_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/Panthera_tigris_altaica.PanTig1.0.104.gtf.gz',
'panTig1' => 'panthera_tigris_altaica/Panthera_tigris_altaica.PanTig1.0.104.gtf.gz',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis/Papio_anubis.Panu_3.0.104.gtf.gz',
'GCF_000264685.3_Panu_3.0' => 'papio_anubis/Papio_anubis.Panu_3.0.104.gtf.gz',
'papAnu4' => 'papio_anubis/Papio_anubis.Panu_3.0.104.gtf.gz',
'GCA_900634625.1_fParRan2.1' => 'parambassis_ranga/Parambassis_ranga.fParRan2.1.104.gtf.gz',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga/Parambassis_ranga.fParRan2.1.104.gtf.gz',
'GCA_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/Paramormyrops_kingsleyae.PKINGS_0.1.104.gtf.gz',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/Paramormyrops_kingsleyae.PKINGS_0.1.104.gtf.gz',
'GCA_001522545.2_Parus_major1.1' => 'parus_major/Parus_major.Parus_major1.1.104.gtf.gz',
'GCF_001522545.3_Parus_major1.1' => 'parus_major/Parus_major.Parus_major1.1.104.gtf.gz',
'GCA_005519975.1_AIIM_Pcri_1.0' => 'pavo_cristatus/Pavo_cristatus.AIIM_Pcri_1.0.104.gtf.gz',
'GCA_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.104.gtf.gz',
'GCF_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.104.gtf.gz',
'pelSin1' => 'pelodiscus_sinensis/Pelodiscus_sinensis.PelSin_1.0.104.gtf.gz',
'GCA_007922175.1_Pelusios_castaneus-1.0' => 'pelusios_castaneus/Pelusios_castaneus.Pelusios_castaneus-1.0.104.gtf.gz',
'GCA_000787105.1_PM.fa' => 'periophthalmus_magnuspinnatus/Periophthalmus_magnuspinnatus.PM.fa.104.gtf.gz',
'GCA_003704035.1_HU_Pman_2.1' => 'peromyscus_maniculatus_bairdii/Peromyscus_maniculatus_bairdii.HU_Pman_2.1.104.gtf.gz',
'GCA_000148955.1_Petromyzon_marinus-7.0' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.104.gtf.gz',
'petMar2' => 'petromyzon_marinus/Petromyzon_marinus.Pmarinus_7.0.104.gtf.gz',
'GCA_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/Phascolarctos_cinereus.phaCin_unsw_v4.1.104.gtf.gz',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/Phascolarctos_cinereus.phaCin_unsw_v4.1.104.gtf.gz',
'GCA_004143745.1_ASM414374v1' => 'phasianus_colchicus/Phasianus_colchicus.ASM414374v1.104.gtf.gz',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus/Phasianus_colchicus.ASM414374v1.104.gtf.gz',
'GCA_008692025.1_mPhoSin1.pri' => 'phocoena_sinus/Phocoena_sinus.mPhoSin1.pri.104.gtf.gz',
'GCF_008692025.1_mPhoSin1.pri' => 'phocoena_sinus/Phocoena_sinus.mPhoSin1.pri.104.gtf.gz',
'GCA_002837175.2_ASM283717v2' => 'physeter_catodon/Physeter_catodon.ASM283717v2.104.gtf.gz',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon/Physeter_catodon.ASM283717v2.104.gtf.gz',
'GCA_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/Piliocolobus_tephrosceles.ASM277652v2.104.gtf.gz',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/Piliocolobus_tephrosceles.ASM277652v2.104.gtf.gz',
'GCA_004329235.1_PodMur_1.0' => 'podarcis_muralis/Podarcis_muralis.PodMur_1.0.104.gtf.gz',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis/Podarcis_muralis.PodMur_1.0.104.gtf.gz',
'GCA_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.104.gtf.gz',
'GCF_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.104.gtf.gz',
'poeFor1' => 'poecilia_formosa/Poecilia_formosa.PoeFor_5.1.2.104.gtf.gz',
'GCA_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/Poecilia_latipinna.P_latipinna-1.0.104.gtf.gz',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/Poecilia_latipinna.P_latipinna-1.0.104.gtf.gz',
'GCA_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/Poecilia_mexicana.P_mexicana-1.0.104.gtf.gz',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/Poecilia_mexicana.P_mexicana-1.0.104.gtf.gz',
'GCA_000633615.2_Guppy_female_1.0_MT' => 'poecilia_reticulata/Poecilia_reticulata.Guppy_female_1.0_MT.104.gtf.gz',
'GCF_000633615.1_Guppy_female_1.0_MT' => 'poecilia_reticulata/Poecilia_reticulata.Guppy_female_1.0_MT.104.gtf.gz',
'poeRet1' => 'poecilia_reticulata/Poecilia_reticulata.Guppy_female_1.0_MT.104.gtf.gz',
'GCA_900067755.1_pvi1.1' => 'pogona_vitticeps/Pogona_vitticeps.pvi1.1.104.gtf.gz',
'ponAbe2' => 'pongo_abelii/Pongo_abelii.PPYG2.104.gtf.gz',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus/Prolemur_simus.Prosim_1.0.104.gtf.gz',
'GCA_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.104.gtf.gz',
'GCF_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.104.gtf.gz',
'proCoq1' => 'propithecus_coquereli/Propithecus_coquereli.Pcoq_1.0.104.gtf.gz',
'GCA_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/Pseudonaja_textilis.EBS10Xv2-PRI.104.gtf.gz',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/Pseudonaja_textilis.EBS10Xv2-PRI.104.gtf.gz',
'GCA_000239375.1_PunNye1.0' => 'pundamilia_nyererei/Pundamilia_nyererei.PunNye1.0.104.gtf.gz',
'GCF_000239375.1_PunNye1.0' => 'pundamilia_nyererei/Pundamilia_nyererei.PunNye1.0.104.gtf.gz',
'punNye1' => 'pundamilia_nyererei/Pundamilia_nyererei.PunNye1.0.104.gtf.gz',
'GCA_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.104.gtf.gz',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.104.gtf.gz',
'GCA_000001895.4_Rnor_6.0' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.104.gtf.gz',
'GCF_000001895.5_Rnor_6.0' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.104.gtf.gz',
'rn6' => 'rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.104.gtf.gz',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.104.gtf.gz',
'GCF_004115265.1_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.104.gtf.gz',
'GCA_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.104.gtf.gz',
'GCF_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.104.gtf.gz',
'rhiBie1' => 'rhinopithecus_bieti/Rhinopithecus_bieti.ASM169854v1.104.gtf.gz',
'GCA_000769185.1_Rrox_v1' => 'rhinopithecus_roxellana/Rhinopithecus_roxellana.Rrox_v1.104.gtf.gz',
'rhiRox1' => 'rhinopithecus_roxellana/Rhinopithecus_roxellana.Rrox_v1.104.gtf.gz',
'GCA_000146045.2_R64-1-1' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.104.gtf.gz',
'GCF_000146045.2_R64' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.104.gtf.gz',
'sacCer3' => 'saccharomyces_cerevisiae/Saccharomyces_cerevisiae.R64-1-1.104.gtf.gz',
'GCA_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.104.gtf.gz',
'GCF_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.104.gtf.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/Saimiri_boliviensis_boliviensis.SaiBol1.0.104.gtf.gz',
'GCA_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/Salarias_fasciatus.fSalaFa1.1.104.gtf.gz',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/Salarias_fasciatus.fSalaFa1.1.104.gtf.gz',
'GCA_000233375.4_ICSASG_v2' => 'salmo_salar/Salmo_salar.ICSASG_v2.104.gtf.gz',
'GCA_901001165.1_fSalTru1.1' => 'salmo_trutta/Salmo_trutta.fSalTru1.1.104.gtf.gz',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta/Salmo_trutta.fSalTru1.1.104.gtf.gz',
'GCA_003586115.1_HLtupMer3' => 'salvator_merianae/Salvator_merianae.HLtupMer3.104.gtf.gz',
'GCA_008315115.1_SLUC_FBN_1' => 'sander_lucioperca/Sander_lucioperca.SLUC_FBN_1.104.gtf.gz',
'GCF_008315115.1_SLUC_FBN_1' => 'sander_lucioperca/Sander_lucioperca.SLUC_FBN_1.104.gtf.gz',
'GCA_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii/Sarcophilus_harrisii.mSarHar1.11.104.gtf.gz',
'GCF_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii/Sarcophilus_harrisii.mSarHar1.11.104.gtf.gz',
'GCA_902686455.1_mSciVul1.1' => 'sciurus_vulgaris/Sciurus_vulgaris.mSciVul1.1.104.gtf.gz',
'GCA_900964775.1_fSclFor1.1' => 'scleropages_formosus/Scleropages_formosus.fSclFor1.1.104.gtf.gz',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus/Scleropages_formosus.fSclFor1.1.104.gtf.gz',
'GCF_013347765.1_ASM1334776v1' => 'scophthalmus_maximus/Scophthalmus_maximus.ASM1334776v1.104.gtf.gz',
'GCA_003186165.1_ASM318616v1' => 'scophthalmus_maximus/Scophthalmus_maximus.ASM318616v1.104.gtf.gz',
'GCA_000534875.1_SCA1' => 'serinus_canaria/Serinus_canaria.SCA1.104.gtf.gz',
'serCan1' => 'serinus_canaria/Serinus_canaria.SCA1.104.gtf.gz',
'GCA_002260705.1_Sdu_1.0' => 'seriola_dumerili/Seriola_dumerili.Sdu_1.0.104.gtf.gz',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili/Seriola_dumerili.Sdu_1.0.104.gtf.gz',
'GCA_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/Seriola_lalandi_dorsalis.Sedor1.104.gtf.gz',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/Seriola_lalandi_dorsalis.Sedor1.104.gtf.gz',
'GCA_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.104.gtf.gz',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.104.gtf.gz',
'GCA_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.104.gtf.gz',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.104.gtf.gz',
'GCA_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.104.gtf.gz',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.104.gtf.gz',
'GCA_900880675.1_fSpaAur1.1' => 'sparus_aurata/Sparus_aurata.fSpaAur1.1.104.gtf.gz',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata/Sparus_aurata.fSpaAur1.1.104.gtf.gz',
'GCA_002406435.1_ASM240643v1' => 'spermophilus_dauricus/Spermophilus_dauricus.ASM240643v1.104.gtf.gz',
'GCA_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/Sphaeramia_orbicularis.fSphaOr1.1.104.gtf.gz',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/Sphaeramia_orbicularis.fSphaOr1.1.104.gtf.gz',
'GCA_003113815.1_ASM311381v1' => 'sphenodon_punctatus/Sphenodon_punctatus.ASM311381v1.104.gtf.gz',
'GCA_008694505.1_ASM869450v1' => 'stachyris_ruficeps/Stachyris_ruficeps.ASM869450v1.104.gtf.gz',
'GCA_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/Stegastes_partitus.Stegastes_partitus-1.0.2.104.gtf.gz',
'GCF_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/Stegastes_partitus.Stegastes_partitus-1.0.2.104.gtf.gz',
'stePar1' => 'stegastes_partitus/Stegastes_partitus.Stegastes_partitus-1.0.2.104.gtf.gz',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/Strigops_habroptila.bStrHab1_v1.p.104.gtf.gz',
'GCF_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/Strigops_habroptila.bStrHab1_v1.p.104.gtf.gz',
'GCA_002372975.1_Soccid_v01' => 'strix_occidentalis_caurina/Strix_occidentalis_caurina.Soccid_v01.104.gtf.gz',
'GCA_000698965.1_ASM69896v1' => 'struthio_camelus_australis/Struthio_camelus_australis.ASM69896v1.104.gtf.gz',
'GCF_000698965.1_ASM69896v1' => 'struthio_camelus_australis/Struthio_camelus_australis.ASM69896v1.104.gtf.gz',
'strCam1' => 'struthio_camelus_australis/Struthio_camelus_australis.ASM69896v1.104.gtf.gz',
'GCA_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.104.gtf.gz',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.104.gtf.gz',
'GCA_000003025.6_Sscrofa11.1' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.104.gtf.gz',
'GCF_000003025.6_Sscrofa11.1' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.104.gtf.gz',
'susScr11' => 'sus_scrofa/Sus_scrofa.Sscrofa11.1.104.gtf.gz',
'GCA_001700235.1_Bamei_pig_v1' => 'sus_scrofa_bamei/Sus_scrofa_bamei.Bamei_pig_v1.104.gtf.gz',
'GCA_001700575.1_Berkshire_pig_v1' => 'sus_scrofa_berkshire/Sus_scrofa_berkshire.Berkshire_pig_v1.104.gtf.gz',
'GCA_001700165.1_Hampshire_pig_v1' => 'sus_scrofa_hampshire/Sus_scrofa_hampshire.Hampshire_pig_v1.104.gtf.gz',
'GCA_001700295.1_Jinhua_pig_v1' => 'sus_scrofa_jinhua/Sus_scrofa_jinhua.Jinhua_pig_v1.104.gtf.gz',
'GCA_001700215.1_Landrace_pig_v1' => 'sus_scrofa_landrace/Sus_scrofa_landrace.Landrace_pig_v1.104.gtf.gz',
'GCA_001700135.1_Large_White_v1' => 'sus_scrofa_largewhite/Sus_scrofa_largewhite.Large_White_v1.104.gtf.gz',
'GCA_001700195.1_Meishan_pig_v1' => 'sus_scrofa_meishan/Sus_scrofa_meishan.Meishan_pig_v1.104.gtf.gz',
'GCA_001700255.1_Pietrain_pig_v1' => 'sus_scrofa_pietrain/Sus_scrofa_pietrain.Pietrain_pig_v1.104.gtf.gz',
'GCA_001700155.1_Rongchang_pig_v1' => 'sus_scrofa_rongchang/Sus_scrofa_rongchang.Rongchang_pig_v1.104.gtf.gz',
'GCA_000472085.2_Tibetan_Pig_v2' => 'sus_scrofa_tibetan/Sus_scrofa_tibetan.Tibetan_Pig_v2.104.gtf.gz',
'GCA_002844635.1_USMARCv1.0' => 'sus_scrofa_usmarc/Sus_scrofa_usmarc.USMARCv1.0.104.gtf.gz',
'GCA_000325925.2_minipig_v1.0' => 'sus_scrofa_wuzhishan/Sus_scrofa_wuzhishan.minipig_v1.0.104.gtf.gz',
'GCA_003957565.2_bTaeGut1_v1.p' => 'taeniopygia_guttata/Taeniopygia_guttata.bTaeGut1_v1.p.104.gtf.gz',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata/Taeniopygia_guttata.bTaeGut1_v1.p.104.gtf.gz',
'GCA_901000725.2_fTakRub1.2' => 'takifugu_rubripes/Takifugu_rubripes.fTakRub1.2.104.gtf.gz',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes/Takifugu_rubripes.fTakRub1.2.104.gtf.gz',
'GCA_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis/Terrapene_carolina_triunguis.T_m_triunguis-2.0.104.gtf.gz',
'GCF_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis/Terrapene_carolina_triunguis.T_m_triunguis-2.0.104.gtf.gz',
'tetNig2' => 'tetraodon_nigroviridis/Tetraodon_nigroviridis.TETRAODON8.104.gtf.gz',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada/Theropithecus_gelada.Tgel_1.0.104.gtf.gz',
'GCF_003255815.1_Tgel_1.0' => 'theropithecus_gelada/Theropithecus_gelada.Tgel_1.0.104.gtf.gz',
'GCA_003426925.1_ASM342692v1' => 'urocitellus_parryii/Urocitellus_parryii.ASM342692v1.104.gtf.gz',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii/Urocitellus_parryii.ASM342692v1.104.gtf.gz',
'GCA_003344425.1_ASM334442v1' => 'ursus_americanus/Ursus_americanus.ASM334442v1.104.gtf.gz',
'GCA_000687225.1_UrsMar_1.0' => 'ursus_maritimus/Ursus_maritimus.UrsMar_1.0.104.gtf.gz',
'GCF_000687225.1_UrsMar_1.0' => 'ursus_maritimus/Ursus_maritimus.UrsMar_1.0.104.gtf.gz',
'ursMar1' => 'ursus_maritimus/Ursus_maritimus.UrsMar_1.0.104.gtf.gz',
'GCA_009660055.1_ASM966005v1' => 'ursus_thibetanus_thibetanus/Ursus_thibetanus_thibetanus.ASM966005v1.104.gtf.gz',
'GCA_004798865.1_ASM479886v1' => 'varanus_komodoensis/Varanus_komodoensis.ASM479886v1.104.gtf.gz',
'GCA_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.104.gtf.gz',
'GCF_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.104.gtf.gz',
'GCA_003160815.1_VulVul2.2' => 'vulpes_vulpes/Vulpes_vulpes.VulVul2.2.104.gtf.gz',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes/Vulpes_vulpes.VulVul2.2.104.gtf.gz',
'GCA_000004195.3_Xenopus_tropicalis_v9.1' => 'xenopus_tropicalis/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.104.gtf.gz',
'xenTro9' => 'xenopus_tropicalis/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.104.gtf.gz',
'GCA_001444195.1_Xiphophorus_couchianus-4.0.1' => 'xiphophorus_couchianus/Xiphophorus_couchianus.Xiphophorus_couchianus-4.0.1.104.gtf.gz',
'GCA_002775205.2_X_maculatus-5.0-male' => 'xiphophorus_maculatus/Xiphophorus_maculatus.X_maculatus-5.0-male.104.gtf.gz',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus/Xiphophorus_maculatus.X_maculatus-5.0-male.104.gtf.gz',
'GCA_009762305.1_mZalCal1.pri' => 'zalophus_californianus/Zalophus_californianus.mZalCal1.pri.104.gtf.gz',
'GCA_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.104.gtf.gz',
'GCF_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.104.gtf.gz',
'zonAlb1' => 'zonotrichia_albicollis/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.104.gtf.gz',
'GCA_001281735.1_ASM128173v1' => 'zosterops_lateralis_melanops/Zosterops_lateralis_melanops.ASM128173v1.104.gtf.gz',
);

my %ensGeneFtpPeptideFileNames_104 = (
'GCA_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/pep/Acanthochromis_polyacanthus.ASM210954v1.pep.all.fa.gz',
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus/pep/Acanthochromis_polyacanthus.ASM210954v1.pep.all.fa.gz',
'GCA_004320145.1_Accipiter_nisus_ver1.0' => 'accipiter_nisus/pep/Accipiter_nisus.Accipiter_nisus_ver1.0.pep.all.fa.gz',
'GCA_002007445.2_ASM200744v2' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ASM200744v2.pep.all.fa.gz',
'GCF_002007445.1_ASM200744v2' => 'ailuropoda_melanoleuca/pep/Ailuropoda_melanoleuca.ASM200744v2.pep.all.fa.gz',
'GCA_003947215.1_ASM394721v1' => 'amazona_collaria/pep/Amazona_collaria.ASM394721v1.pep.all.fa.gz',
'GCA_000751415.1_Midas_v5' => 'amphilophus_citrinellus/pep/Amphilophus_citrinellus.Midas_v5.pep.all.fa.gz',
'GCA_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/pep/Amphiprion_ocellaris.AmpOce1.0.pep.all.fa.gz',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris/pep/Amphiprion_ocellaris.AmpOce1.0.pep.all.fa.gz',
'GCA_003047355.1_Nemo_v1' => 'amphiprion_percula/pep/Amphiprion_percula.Nemo_v1.pep.all.fa.gz',
'GCA_900324465.1_fAnaTes1.1' => 'anabas_testudineus/pep/Anabas_testudineus.fAnaTes1.1.pep.all.fa.gz',
'GCA_900324465.2_fAnaTes1.2' => 'anabas_testudineus/pep/Anabas_testudineus.fAnaTes1.2.pep.all.fa.gz',
'GCF_900324465.2_fAnaTes1.2' => 'anabas_testudineus/pep/Anabas_testudineus.fAnaTes1.2.pep.all.fa.gz',
'GCA_008746955.1_ASM874695v1' => 'anas_platyrhynchos/pep/Anas_platyrhynchos.ASM874695v1.pep.all.fa.gz',
'GCA_002743455.1_CAU_duck1.0' => 'anas_platyrhynchos_platyrhynchos/pep/Anas_platyrhynchos_platyrhynchos.CAU_duck1.0.pep.all.fa.gz',
'GCA_002224875.1_ASM222487v1' => 'anas_zonorhyncha/pep/Anas_zonorhyncha.ASM222487v1.pep.all.fa.gz',
'GCA_000090745.2_AnoCar2.0' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0v2.pep.all.fa.gz',
'GCF_000090745.1_AnoCar2.0' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0v2.pep.all.fa.gz',
'anoCar2' => 'anolis_carolinensis/pep/Anolis_carolinensis.AnoCar2.0v2.pep.all.fa.gz',
'GCA_002592135.1_ASM259213v1' => 'anser_brachyrhynchus/pep/Anser_brachyrhynchus.ASM259213v1.pep.all.fa.gz',
'GCA_002166845.1_GooseV1.0' => 'anser_cygnoides/pep/Anser_cygnoides.GooseV1.0.pep.all.fa.gz',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'GCF_000952055.2_Anan_2.0' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'aotNan1' => 'aotus_nancymaae/pep/Aotus_nancymaae.Anan_2.0.pep.all.fa.gz',
'GCA_003342985.1_aptHaa1' => 'apteryx_haastii/pep/Apteryx_haastii.aptHaa1.pep.all.fa.gz',
'GCA_003342965.1_aptOwe1' => 'apteryx_owenii/pep/Apteryx_owenii.aptOwe1.pep.all.fa.gz',
'GCA_003343035.1_aptRow1' => 'apteryx_rowi/pep/Apteryx_rowi.aptRow1.pep.all.fa.gz',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi/pep/Apteryx_rowi.aptRow1.pep.all.fa.gz',
'GCA_900496995.2_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/pep/Aquila_chrysaetos_chrysaetos.bAquChr1.2.pep.all.fa.gz',
'GCF_900496995.1_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos/pep/Aquila_chrysaetos_chrysaetos.bAquChr1.2.pep.all.fa.gz',
'GCA_900246225.3_fAstCal1.2' => 'astatotilapia_calliptera/pep/Astatotilapia_calliptera.fAstCal1.2.pep.all.fa.gz',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera/pep/Astatotilapia_calliptera.fAstCal1.2.pep.all.fa.gz',
'GCA_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.Astyanax_mexicanus-2.0.pep.all.fa.gz',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus/pep/Astyanax_mexicanus.Astyanax_mexicanus-2.0.pep.all.fa.gz',
'GCA_004802775.1_Astyanax_mexicanus-1.0.2' => 'astyanax_mexicanus_pachon/pep/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.pep.all.fa.gz',
'astMex1' => 'astyanax_mexicanus_pachon/pep/Astyanax_mexicanus_pachon.Astyanax_mexicanus-1.0.2.pep.all.fa.gz',
'GCA_003259725.1_athCun1' => 'athene_cunicularia/pep/Athene_cunicularia.athCun1.pep.all.fa.gz',
'GCF_003259725.1_athCun1' => 'athene_cunicularia/pep/Athene_cunicularia.athCun1.pep.all.fa.gz',
'GCA_009873245.2_mBalMus1.v2' => 'balaenoptera_musculus/pep/Balaenoptera_musculus.mBalMus1.v2.pep.all.fa.gz',
'GCA_900634795.2_fBetSpl5.2' => 'betta_splendens/pep/Betta_splendens.fBetSpl5.2.pep.all.fa.gz',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens/pep/Betta_splendens.fBetSpl5.2.pep.all.fa.gz',
'GCA_000754665.1_Bison_UMD1.0' => 'bison_bison_bison/pep/Bison_bison_bison.Bison_UMD1.0.pep.all.fa.gz',
'bisBis1' => 'bison_bison_bison/pep/Bison_bison_bison.Bison_UMD1.0.pep.all.fa.gz',
'GCA_005887515.1_LU_Bosgru_v3.0' => 'bos_grunniens/pep/Bos_grunniens.LU_Bosgru_v3.0.pep.all.fa.gz',
'GCA_003369695.2_UOA_Brahman_1' => 'bos_indicus_hybrid/pep/Bos_indicus_hybrid.UOA_Brahman_1.pep.all.fa.gz',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid/pep/Bos_indicus_hybrid.UOA_Brahman_1.pep.all.fa.gz',
'GCA_000298355.1_BosGru_v2.0' => 'bos_mutus/pep/Bos_mutus.BosGru_v2.0.pep.all.fa.gz',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus/pep/Bos_mutus.BosGru_v2.0.pep.all.fa.gz',
'bosMut1' => 'bos_mutus/pep/Bos_mutus.BosGru_v2.0.pep.all.fa.gz',
'GCA_002263795.2_ARS-UCD1.2' => 'bos_taurus/pep/Bos_taurus.ARS-UCD1.2.pep.all.fa.gz',
'GCF_002263795.1_ARS-UCD1.2' => 'bos_taurus/pep/Bos_taurus.ARS-UCD1.2.pep.all.fa.gz',
'bosTau9' => 'bos_taurus/pep/Bos_taurus.ARS-UCD1.2.pep.all.fa.gz',
'GCA_003369685.2_UOA_Angus_1' => 'bos_taurus_hybrid/pep/Bos_taurus_hybrid.UOA_Angus_1.pep.all.fa.gz',
'GCA_010303855.1_BubBub1.0' => 'bubo_bubo/pep/Bubo_bubo.BubBub1.0.pep.all.fa.gz',
'GCA_010312235.1_ButJap1.0' => 'buteo_japonicus/pep/Buteo_japonicus.ButJap1.0.pep.all.fa.gz',
'GCF_000002985.6_WBcel235' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'ce11' => 'caenorhabditis_elegans/pep/Caenorhabditis_elegans.WBcel235.pep.all.fa.gz',
'GCA_009194515.1_CaiMos1.0' => 'cairina_moschata_domestica/pep/Cairina_moschata_domestica.CaiMos1.0.pep.all.fa.gz',
'GCA_001431845.1_ASM143184v1' => 'calidris_pugnax/pep/Calidris_pugnax.ASM143184v1.pep.all.fa.gz',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax/pep/Calidris_pugnax.ASM143184v1.pep.all.fa.gz',
'GCA_003697955.1_ASM369795v1' => 'calidris_pygmaea/pep/Calidris_pygmaea.ASM369795v1.pep.all.fa.gz',
'GCA_002754865.1_ASM275486v1' => 'callithrix_jacchus/pep/Callithrix_jacchus.ASM275486v1.pep.all.fa.gz',
'GCA_000165045.2_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/pep/Callorhinchus_milii.Callorhinchus_milii-6.1.3.pep.all.fa.gz',
'GCF_000165045.1_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii/pep/Callorhinchus_milii.Callorhinchus_milii-6.1.3.pep.all.fa.gz',
'calMil1' => 'callorhinchus_milii/pep/Callorhinchus_milii.Callorhinchus_milii-6.1.3.pep.all.fa.gz',
'GCA_901933205.1_STF_HiC' => 'camarhynchus_parvulus/pep/Camarhynchus_parvulus.STF_HiC.pep.all.fa.gz',
'GCF_901933205.1_STF_HiC' => 'camarhynchus_parvulus/pep/Camarhynchus_parvulus.STF_HiC.pep.all.fa.gz',
'GCA_000803125.2_CamDro2' => 'camelus_dromedarius/pep/Camelus_dromedarius.CamDro2.pep.all.fa.gz',
'GCA_003254725.1_ASM325472v1' => 'canis_lupus_dingo/pep/Canis_lupus_dingo.ASM325472v1.pep.all.fa.gz',
'GCF_003254725.1_ASM325472v1' => 'canis_lupus_dingo/pep/Canis_lupus_dingo.ASM325472v1.pep.all.fa.gz',
'GCA_000002285.2_CanFam3.1' => 'canis_lupus_familiaris/pep/Canis_lupus_familiaris.CanFam3.1.pep.all.fa.gz',
'GCF_000002285.3_CanFam3.1' => 'canis_lupus_familiaris/pep/Canis_lupus_familiaris.CanFam3.1.pep.all.fa.gz',
'canFam3' => 'canis_lupus_familiaris/pep/Canis_lupus_familiaris.CanFam3.1.pep.all.fa.gz',
'GCA_004886185.1_Basenji_breed-1.1' => 'canis_lupus_familiarisbasenji/pep/Canis_lupus_familiarisbasenji.Basenji_breed-1.1.pep.all.fa.gz',
'GCA_005444595.1_UMICH_Zoey_3.1' => 'canis_lupus_familiarisgreatdane/pep/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.pep.all.fa.gz',
'canFam5' => 'canis_lupus_familiarisgreatdane/pep/Canis_lupus_familiarisgreatdane.UMICH_Zoey_3.1.pep.all.fa.gz',
'GCA_001704415.1_ARS1' => 'capra_hircus/pep/Capra_hircus.ARS1.pep.all.fa.gz',
'GCF_001704415.1_ARS1' => 'capra_hircus/pep/Capra_hircus.ARS1.pep.all.fa.gz',
'GCA_004361675.1_CVASU_BBG_1.0' => 'capra_hircus_blackbengal/pep/Capra_hircus_blackbengal.CVASU_BBG_1.0.pep.all.fa.gz',
'GCA_003368295.1_ASM336829v1' => 'carassius_auratus/pep/Carassius_auratus.ASM336829v1.pep.all.fa.gz',
'GCF_003368295.1_ASM336829v1' => 'carassius_auratus/pep/Carassius_auratus.ASM336829v1.pep.all.fa.gz',
'GCA_000164805.2_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'GCF_000164805.1_Tarsius_syrichta-2.0.1' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'tarSyr2' => 'carlito_syrichta/pep/Carlito_syrichta.Tarsius_syrichta-2.0.1.pep.all.fa.gz',
'GCA_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/pep/Castor_canadensis.C.can_genome_v1.0.pep.all.fa.gz',
'GCF_001984765.1_C.can_genome_v1.0' => 'castor_canadensis/pep/Castor_canadensis.C.can_genome_v1.0.pep.all.fa.gz',
'casCan1' => 'castor_canadensis/pep/Castor_canadensis.C.can_genome_v1.0.pep.all.fa.gz',
'GCA_004024745.2_CatWag_v2_BIUU_UCD' => 'catagonus_wagneri/pep/Catagonus_wagneri.CatWag_v2_BIUU_UCD.pep.all.fa.gz',
'GCA_009819885.1_bCatUst1.pri' => 'catharus_ustulatus/pep/Catharus_ustulatus.bCatUst1.pri.pep.all.fa.gz',
'GCF_009819885.1_bCatUst1.pri' => 'catharus_ustulatus/pep/Catharus_ustulatus.bCatUst1.pri.pep.all.fa.gz',
'GCA_000688575.1_CavAp1.0' => 'cavia_aperea/pep/Cavia_aperea.CavAp1.0.pep.all.fa.gz',
'cavApe1' => 'cavia_aperea/pep/Cavia_aperea.CavAp1.0.pep.all.fa.gz',
'GCA_000151735.1_Cavpor3.0' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'GCF_000151735.1_Cavpor3.0' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'cavPor3' => 'cavia_porcellus/pep/Cavia_porcellus.Cavpor3.0.pep.all.fa.gz',
'GCA_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'GCF_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'cebCap1' => 'cebus_capucinus/pep/Cebus_capucinus.Cebus_imitator-1.0.pep.all.fa.gz',
'GCA_000955945.1_Caty_1.0' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'cerAty1' => 'cercocebus_atys/pep/Cercocebus_atys.Caty_1.0.pep.all.fa.gz',
'GCA_010411085.1_CEY_v1' => 'cervus_hanglu_yarkandensis/pep/Cervus_hanglu_yarkandensis.CEY_v1.pep.all.fa.gz',
'GCA_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii/pep/Chelonoidis_abingdonii.ASM359739v1.pep.all.fa.gz',
'GCF_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii/pep/Chelonoidis_abingdonii.ASM359739v1.pep.all.fa.gz',
'GCA_007922165.1_Chelydra_serpentina-1.0' => 'chelydra_serpentina/pep/Chelydra_serpentina.Chelydra_serpentina-1.0.pep.all.fa.gz',
'GCA_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'chiLan1' => 'chinchilla_lanigera/pep/Chinchilla_lanigera.ChiLan1.0.pep.all.fa.gz',
'GCA_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'GCF_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'chlSab2' => 'chlorocebus_sabaeus/pep/Chlorocebus_sabaeus.ChlSab1.1.pep.all.fa.gz',
'GCA_000241765.2_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/pep/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.pep.all.fa.gz',
'GCF_000241765.3_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii/pep/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.pep.all.fa.gz',
'chrPic2' => 'chrysemys_picta_bellii/pep/Chrysemys_picta_bellii.Chrysemys_picta_bellii-3.0.3.pep.all.fa.gz',
'GCA_003413605.1_Chrysolophus_pictus_GenomeV1.0' => 'chrysolophus_pictus/pep/Chrysolophus_pictus.Chrysolophus_pictus_GenomeV1.0.pep.all.fa.gz',
'ci3' => 'ciona_intestinalis/pep/Ciona_intestinalis.KH.pep.all.fa.gz',
'cioSav2' => 'ciona_savignyi/pep/Ciona_savignyi.CSAV2.0.pep.all.fa.gz',
'GCA_900700415.1_Ch_v2.0.2' => 'clupea_harengus/pep/Clupea_harengus.Ch_v2.0.2.pep.all.fa.gz',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus/pep/Clupea_harengus.Ch_v2.0.2.pep.all.fa.gz',
'GCA_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'GCF_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'colAng1' => 'colobus_angolensis_palliatus/pep/Colobus_angolensis_palliatus.Cang.pa_1.0.pep.all.fa.gz',
'GCA_009650515.1_UO_Cmon_1.0' => 'corvus_moneduloides/pep/Corvus_moneduloides.UO_Cmon_1.0.pep.all.fa.gz',
'GCA_900634415.1_fCotGob3.1' => 'cottoperca_gobio/pep/Cottoperca_gobio.fCotGob3.1.pep.all.fa.gz',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio/pep/Cottoperca_gobio.fCotGob3.1.pep.all.fa.gz',
'GCA_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCA_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCF_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCF_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'cotJap2' => 'coturnix_japonica/pep/Coturnix_japonica.Coturnix_japonica_2.0.pep.all.fa.gz',
'GCA_900186095.1_CHOK1S_HZDv1' => 'cricetulus_griseus_chok1gshd/pep/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.pep.all.fa.gz',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd/pep/Cricetulus_griseus_chok1gshd.CHOK1GS_HDv1.pep.all.fa.gz',
'GCA_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'GCF_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'criGriChoV1' => 'cricetulus_griseus_crigri/pep/Cricetulus_griseus_crigri.CriGri_1.0.pep.all.fa.gz',
'GCA_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/pep/Cricetulus_griseus_picr.CriGri-PICR.pep.all.fa.gz',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr/pep/Cricetulus_griseus_picr.CriGri-PICR.pep.all.fa.gz',
'GCA_001723895.1_CroPor_comp1' => 'crocodylus_porosus/pep/Crocodylus_porosus.CroPor_comp1.pep.all.fa.gz',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus/pep/Crocodylus_porosus.CroPor_comp1.pep.all.fa.gz',
'GCA_002901205.1_cyaCae2' => 'cyanistes_caeruleus/pep/Cyanistes_caeruleus.cyaCae2.pep.all.fa.gz',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus/pep/Cyanistes_caeruleus.cyaCae2.pep.all.fa.gz',
'GCA_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus/pep/Cyclopterus_lumpus.fCycLum1.pri.pep.all.fa.gz',
'GCF_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus/pep/Cyclopterus_lumpus.fCycLum1.pri.pep.all.fa.gz',
'GCA_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/pep/Cynoglossus_semilaevis.Cse_v1.0.pep.all.fa.gz',
'GCF_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis/pep/Cynoglossus_semilaevis.Cse_v1.0.pep.all.fa.gz',
'cynSem1' => 'cynoglossus_semilaevis/pep/Cynoglossus_semilaevis.Cse_v1.0.pep.all.fa.gz',
'GCA_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/pep/Cyprinodon_variegatus.C_variegatus-1.0.pep.all.fa.gz',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus/pep/Cyprinodon_variegatus.C_variegatus-1.0.pep.all.fa.gz',
'cypVar1' => 'cyprinodon_variegatus/pep/Cyprinodon_variegatus.C_variegatus-1.0.pep.all.fa.gz',
'GCA_000951615.2_common_carp_genome' => 'cyprinus_carpio/pep/Cyprinus_carpio.common_carp_genome.pep.all.fa.gz',
'GCF_000951615.1_common_carp_genome' => 'cyprinus_carpio/pep/Cyprinus_carpio.common_carp_genome.pep.all.fa.gz',
'GCA_004011555.1_German_Mirror_carp_1.0' => 'cyprinus_carpio_germanmirror/pep/Cyprinus_carpio_germanmirror.German_Mirror_carp_1.0.pep.all.fa.gz',
'GCA_004011595.1_Hebao_red_carp_1.0' => 'cyprinus_carpio_hebaored/pep/Cyprinus_carpio_hebaored.Hebao_red_carp_1.0.pep.all.fa.gz',
'GCA_004011575.1_Hunaghe_carp_2.0' => 'cyprinus_carpio_huanghe/pep/Cyprinus_carpio_huanghe.Hunaghe_carp_2.0.pep.all.fa.gz',
'GCA_000208655.2_Dasnov3.0' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'GCF_000208655.1_Dasnov3.0' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'dasNov3' => 'dasypus_novemcinctus/pep/Dasypus_novemcinctus.Dasnov3.0.pep.all.fa.gz',
'GCA_002288925.3_ASM228892v3' => 'delphinapterus_leucas/pep/Delphinapterus_leucas.ASM228892v3.pep.all.fa.gz',
'GCF_002288925.2_ASM228892v3' => 'delphinapterus_leucas/pep/Delphinapterus_leucas.ASM228892v3.pep.all.fa.gz',
'GCA_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/pep/Denticeps_clupeoides.fDenClu1.1.pep.all.fa.gz',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides/pep/Denticeps_clupeoides.fDenClu1.1.pep.all.fa.gz',
'GCA_000689215.1_seabass_V1.0' => 'dicentrarchus_labrax/pep/Dicentrarchus_labrax.seabass_V1.0.pep.all.fa.gz',
'dicLab1' => 'dicentrarchus_labrax/pep/Dicentrarchus_labrax.seabass_V1.0.pep.all.fa.gz',
'GCA_000151885.2_Dord_2.0' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'GCF_000151885.1_Dord_2.0' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'dipOrd2' => 'dipodomys_ordii/pep/Dipodomys_ordii.Dord_2.0.pep.all.fa.gz',
'GCA_003342905.1_droNov1' => 'dromaius_novaehollandiae/pep/Dromaius_novaehollandiae.droNov1.pep.all.fa.gz',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae/pep/Dromaius_novaehollandiae.droNov1.pep.all.fa.gz',
'GCA_000001215.4_Release_6_plus_ISO1_MT' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.32.pep.all.fa.gz',
'GCF_000001215.4_Release_6_plus_ISO1_MT' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.32.pep.all.fa.gz',
'dm6' => 'drosophila_melanogaster/pep/Drosophila_melanogaster.BDGP6.32.pep.all.fa.gz',
'GCA_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/pep/Echeneis_naucrates.fEcheNa1.1.pep.all.fa.gz',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates/pep/Echeneis_naucrates.fEcheNa1.1.pep.all.fa.gz',
'GCA_003665695.2_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/pep/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.pep.all.fa.gz',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus/pep/Electrophorus_electricus.Ee_SOAP_WITH_SSPACE.pep.all.fa.gz',
'GCA_900186335.2_Eburgeri_3.2' => 'eptatretus_burgeri/pep/Eptatretus_burgeri.Eburgeri_3.2.pep.all.fa.gz',
'GCA_003033725.1_ASM303372v1' => 'equus_asinus_asinus/pep/Equus_asinus_asinus.ASM303372v1.pep.all.fa.gz',
'GCA_002863925.1_EquCab3.0' => 'equus_caballus/pep/Equus_caballus.EquCab3.0.pep.all.fa.gz',
'GCF_002863925.1_EquCab3.0' => 'equus_caballus/pep/Equus_caballus.EquCab3.0.pep.all.fa.gz',
'equCab3' => 'equus_caballus/pep/Equus_caballus.EquCab3.0.pep.all.fa.gz',
'GCA_900747795.2_fErpCal1.1' => 'erpetoichthys_calabaricus/pep/Erpetoichthys_calabaricus.fErpCal1.1.pep.all.fa.gz',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus/pep/Erpetoichthys_calabaricus.fErpCal1.1.pep.all.fa.gz',
'GCA_003676055.1_GouldianFinch' => 'erythrura_gouldiae/pep/Erythrura_gouldiae.GouldianFinch.pep.all.fa.gz',
'GCA_004634155.1_Eluc_v4' => 'esox_lucius/pep/Esox_lucius.Eluc_v4.pep.all.fa.gz',
'GCF_004634155.1_Eluc_v4' => 'esox_lucius/pep/Esox_lucius.Eluc_v4.pep.all.fa.gz',
'GCA_010332995.1_FalTin1.0' => 'falco_tinnunculus/pep/Falco_tinnunculus.FalTin1.0.pep.all.fa.gz',
'GCA_000181335.4_Felis_catus_9.0' => 'felis_catus/pep/Felis_catus.Felis_catus_9.0.pep.all.fa.gz',
'GCF_000181335.3_Felis_catus_9.0' => 'felis_catus/pep/Felis_catus.Felis_catus_9.0.pep.all.fa.gz',
'felCat9' => 'felis_catus/pep/Felis_catus.Felis_catus_9.0.pep.all.fa.gz',
'GCA_000247815.2_FicAlb1.5' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb1.5.pep.all.fa.gz',
'GCF_000247815.1_FicAlb1.5' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb1.5.pep.all.fa.gz',
'ficAlb1' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb1.5.pep.all.fa.gz',
'ficAlb2' => 'ficedula_albicollis/pep/Ficedula_albicollis.FicAlb1.5.pep.all.fa.gz',
'GCA_000743615.1_DMR_v1.0' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'GCF_000743615.1_DMR_v1.0' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'fukDam1' => 'fukomys_damarensis/pep/Fukomys_damarensis.DMR_v1.0.pep.all.fa.gz',
'GCA_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/pep/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.pep.all.fa.gz',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus/pep/Fundulus_heteroclitus.Fundulus_heteroclitus-3.0.2.pep.all.fa.gz',
'GCA_902167405.1_gadMor3.0' => 'gadus_morhua/pep/Gadus_morhua.gadMor3.0.pep.all.fa.gz',
'GCF_902167405.1_gadMor3.0' => 'gadus_morhua/pep/Gadus_morhua.gadMor3.0.pep.all.fa.gz',
'GCA_000002315.5_GRCg6a' => 'gallus_gallus/pep/Gallus_gallus.GRCg6a.pep.all.fa.gz',
'GCF_000002315.6_GRCg6a' => 'gallus_gallus/pep/Gallus_gallus.GRCg6a.pep.all.fa.gz',
'galGal6' => 'gallus_gallus/pep/Gallus_gallus.GRCg6a.pep.all.fa.gz',
'GCA_003097735.1_ASM309773v1' => 'gambusia_affinis/pep/Gambusia_affinis.ASM309773v1.pep.all.fa.gz',
'GCA_000277835.1_GeoFor_1.0' => 'geospiza_fortis/pep/Geospiza_fortis.GeoFor_1.0.pep.all.fa.gz',
'GCF_000277835.1_GeoFor_1.0' => 'geospiza_fortis/pep/Geospiza_fortis.GeoFor_1.0.pep.all.fa.gz',
'geoFor1' => 'geospiza_fortis/pep/Geospiza_fortis.GeoFor_1.0.pep.all.fa.gz',
'GCA_002896415.1_ASM289641v1' => 'gopherus_agassizii/pep/Gopherus_agassizii.ASM289641v1.pep.all.fa.gz',
'GCA_007399415.1_rGopEvg1_v1.p' => 'gopherus_evgoodei/pep/Gopherus_evgoodei.rGopEvg1_v1.p.pep.all.fa.gz',
'GCF_007399415.2_rGopEvg1_v1.p' => 'gopherus_evgoodei/pep/Gopherus_evgoodei.rGopEvg1_v1.p.pep.all.fa.gz',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor4.pep.all.fa.gz',
'gorGor4' => 'gorilla_gorilla/pep/Gorilla_gorilla.gorGor4.pep.all.fa.gz',
'GCA_900634775.1_fGouWil2.1' => 'gouania_willdenowi/pep/Gouania_willdenowi.fGouWil2.1.pep.all.fa.gz',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi/pep/Gouania_willdenowi.fGouWil2.1.pep.all.fa.gz',
'GCA_000239415.1_AstBur1.0' => 'haplochromis_burtoni/pep/Haplochromis_burtoni.AstBur1.0.pep.all.fa.gz',
'GCF_000239415.1_AstBur1.0' => 'haplochromis_burtoni/pep/Haplochromis_burtoni.AstBur1.0.pep.all.fa.gz',
'hapBur1' => 'haplochromis_burtoni/pep/Haplochromis_burtoni.AstBur1.0.pep.all.fa.gz',
'GCA_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'GCF_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'hetGla2' => 'heterocephalus_glaber_female/pep/Heterocephalus_glaber_female.HetGla_female_1.0.pep.all.fa.gz',
'GCA_000230445.1_HetGla_1.0' => 'heterocephalus_glaber_male/pep/Heterocephalus_glaber_male.HetGla_1.0.pep.all.fa.gz',
'hetGla1' => 'heterocephalus_glaber_male/pep/Heterocephalus_glaber_male.HetGla_1.0.pep.all.fa.gz',
'GCA_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/pep/Hippocampus_comes.H_comes_QL1_v1.pep.all.fa.gz',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes/pep/Hippocampus_comes.H_comes_QL1_v1.pep.all.fa.gz',
'GCA_003317085.1_ASM331708v1' => 'hucho_hucho/pep/Hucho_hucho.ASM331708v1.pep.all.fa.gz',
'GCA_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/pep/Ictalurus_punctatus.IpCoco_1.2.pep.all.fa.gz',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus/pep/Ictalurus_punctatus.IpCoco_1.2.pep.all.fa.gz',
'GCA_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'GCF_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'speTri2' => 'ictidomys_tridecemlineatus/pep/Ictidomys_tridecemlineatus.SpeTri2.0.pep.all.fa.gz',
'GCA_000280705.1_JacJac1.0' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'GCF_000280705.1_JacJac1.0' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'jacJac1' => 'jaculus_jaculus/pep/Jaculus_jaculus.JacJac1.0.pep.all.fa.gz',
'GCA_003829775.1_ASM382977v1' => 'junco_hyemalis/pep/Junco_hyemalis.ASM382977v1.pep.all.fa.gz',
'GCA_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/pep/Kryptolebias_marmoratus.ASM164957v1.pep.all.fa.gz',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus/pep/Kryptolebias_marmoratus.ASM164957v1.pep.all.fa.gz',
'GCA_900080235.1_BallGen_V1' => 'labrus_bergylta/pep/Labrus_bergylta.BallGen_V1.pep.all.fa.gz',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta/pep/Labrus_bergylta.BallGen_V1.pep.all.fa.gz',
'GCA_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/pep/Larimichthys_crocea.L_crocea_2.0.pep.all.fa.gz',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea/pep/Larimichthys_crocea.L_crocea_2.0.pep.all.fa.gz',
'GCA_001640805.1_ASM164080v1' => 'lates_calcarifer/pep/Lates_calcarifer.ASB_HGAPassembly_v1.pep.all.fa.gz',
'GCA_900066035.1_ASB_HGAPassembly_v1' => 'lates_calcarifer/pep/Lates_calcarifer.ASB_HGAPassembly_v1.pep.all.fa.gz',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer/pep/Lates_calcarifer.ASB_HGAPassembly_v1.pep.all.fa.gz',
'GCA_004320025.1_latLat_1.0' => 'laticauda_laticaudata/pep/Laticauda_laticaudata.latLat_1.0.pep.all.fa.gz',
'GCA_000225785.1_LatCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'GCF_000225785.1_LatCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'latCha1' => 'latimeria_chalumnae/pep/Latimeria_chalumnae.LatCha1.pep.all.fa.gz',
'GCA_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/pep/Lepidothrix_coronata.Lepidothrix_coronata-1.0.pep.all.fa.gz',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata/pep/Lepidothrix_coronata.Lepidothrix_coronata-1.0.pep.all.fa.gz',
'GCA_000242695.1_LepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'GCF_000242695.1_LepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'lepOcu1' => 'lepisosteus_oculatus/pep/Lepisosteus_oculatus.LepOcu1.pep.all.fa.gz',
'GCA_009667805.1_ASM966780v1' => 'leptobrachium_leishanense/pep/Leptobrachium_leishanense.ASM966780v1.pep.all.fa.gz',
'GCA_002197715.1_LonStrDom1' => 'lonchura_striata_domestica/pep/Lonchura_striata_domestica.LonStrDom1.pep.all.fa.gz',
'GCA_000001905.1_Loxafr3.0' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'GCF_000001905.1_Loxafr3.0' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'loxAfr3' => 'loxodonta_africana/pep/Loxodonta_africana.loxAfr3.pep.all.fa.gz',
'GCA_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/pep/Lynx_canadensis.mLynCan4_v1.p.pep.all.fa.gz',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis/pep/Lynx_canadensis.mLynCan4_v1.p.pep.all.fa.gz',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_5.0.pep.all.fa.gz',
'GCA_011100615.1_Macaca_fascicularis_6.0' => 'macaca_fascicularis/pep/Macaca_fascicularis.Macaca_fascicularis_6.0.pep.all.fa.gz',
'GCA_003339765.3_Mmul_10' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_10.pep.all.fa.gz',
'GCF_003339765.1_Mmul_10' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_10.pep.all.fa.gz',
'rheMac10' => 'macaca_mulatta/pep/Macaca_mulatta.Mmul_10.pep.all.fa.gz',
'GCA_000956065.1_Mnem_1.0' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'macNem1' => 'macaca_nemestrina/pep/Macaca_nemestrina.Mnem_1.0.pep.all.fa.gz',
'GCA_009741485.1_mCya_1.0' => 'malurus_cyaneus_samueli/pep/Malurus_cyaneus_samueli.mCya_1.0.pep.all.fa.gz',
'GCA_001715985.2_ASM171598v2' => 'manacus_vitellinus/pep/Manacus_vitellinus.ASM171598v2.pep.all.fa.gz',
'GCA_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'GCF_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'manLeu1' => 'mandrillus_leucophaeus/pep/Mandrillus_leucophaeus.Mleu.le_1.0.pep.all.fa.gz',
'GCA_001458135.1_marMar2.1' => 'marmota_marmota_marmota/pep/Marmota_marmota_marmota.marMar2.1.pep.all.fa.gz',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota/pep/Marmota_marmota_marmota.marMar2.1.pep.all.fa.gz',
'GCA_900324485.1_fMasArm1.1' => 'mastacembelus_armatus/pep/Mastacembelus_armatus.fMasArm1.1.pep.all.fa.gz',
'GCA_900324485.2_fMasArm1.2' => 'mastacembelus_armatus/pep/Mastacembelus_armatus.fMasArm1.2.pep.all.fa.gz',
'GCF_900324485.2_fMasArm1.2' => 'mastacembelus_armatus/pep/Mastacembelus_armatus.fMasArm1.2.pep.all.fa.gz',
'GCA_000238955.5_M_zebra_UMD2a' => 'maylandia_zebra/pep/Maylandia_zebra.M_zebra_UMD2a.pep.all.fa.gz',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra/pep/Maylandia_zebra.M_zebra_UMD2a.pep.all.fa.gz',
'GCA_000146605.2_Turkey_2.01' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.Turkey_2.01.pep.all.fa.gz',
'melGal5' => 'meleagris_gallopavo/pep/Meleagris_gallopavo.Turkey_5.1.pep.all.fa.gz',
'GCA_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/pep/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.pep.all.fa.gz',
'GCF_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus/pep/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.pep.all.fa.gz',
'melUnd1' => 'melopsittacus_undulatus/pep/Melopsittacus_undulatus.Melopsittacus_undulatus_6.3.pep.all.fa.gz',
'GCA_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/pep/Meriones_unguiculatus.MunDraft-v1.0.pep.all.fa.gz',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus/pep/Meriones_unguiculatus.MunDraft-v1.0.pep.all.fa.gz',
'GCA_000349665.1_MesAur1.0' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'GCF_000349665.1_MesAur1.0' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'mesAur1' => 'mesocricetus_auratus/pep/Mesocricetus_auratus.MesAur1.0.pep.all.fa.gz',
'GCA_000165445.3_Mmur_3.0' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'GCF_000165445.2_Mmur_3.0' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'micMur3' => 'microcebus_murinus/pep/Microcebus_murinus.Mmur_3.0.pep.all.fa.gz',
'GCA_000317375.1_MicOch1.0' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'GCF_000317375.1_MicOch1.0' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'micOch1' => 'microtus_ochrogaster/pep/Microtus_ochrogaster.MicOch1.0.pep.all.fa.gz',
'GCA_001698575.1_ASM169857v1' => 'mola_mola/pep/Mola_mola.ASM169857v1.pep.all.fa.gz',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica/pep/Monodelphis_domestica.ASM229v1.pep.all.fa.gz',
'GCA_005190385.2_NGI_Narwhal_1' => 'monodon_monoceros/pep/Monodon_monoceros.NGI_Narwhal_1.pep.all.fa.gz',
'GCF_005190385.1_NGI_Narwhal_1' => 'monodon_monoceros/pep/Monodon_monoceros.NGI_Narwhal_1.pep.all.fa.gz',
'GCA_001952655.1_M_albus_1.0' => 'monopterus_albus/pep/Monopterus_albus.M_albus_1.0.pep.all.fa.gz',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus/pep/Monopterus_albus.M_albus_1.0.pep.all.fa.gz',
'GCA_004024705.2_MosMos_v2_BIUU_UCD' => 'moschus_moschiferus/pep/Moschus_moschiferus.MosMos_v2_BIUU_UCD.pep.all.fa.gz',
'GCA_900094665.2_CAROLI_EIJ_v1.1' => 'mus_caroli/pep/Mus_caroli.CAROLI_EIJ_v1.1.pep.all.fa.gz',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli/pep/Mus_caroli.CAROLI_EIJ_v1.1.pep.all.fa.gz',
'GCA_000001635.9_GRCm39' => 'mus_musculus/pep/Mus_musculus.GRCm39.pep.all.fa.gz',
'GCF_000001635.27_GRCm39' => 'mus_musculus/pep/Mus_musculus.GRCm39.pep.all.fa.gz',
'mm39' => 'mus_musculus/pep/Mus_musculus.GRCm39.pep.all.fa.gz',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj/pep/Mus_musculus_129s1svimj.129S1_SvImJ_v1.pep.all.fa.gz',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj/pep/Mus_musculus_aj.A_J_v1.pep.all.fa.gz',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj/pep/Mus_musculus_akrj.AKR_J_v1.pep.all.fa.gz',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj/pep/Mus_musculus_balbcj.BALB_cJ_v1.pep.all.fa.gz',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej/pep/Mus_musculus_c3hhej.C3H_HeJ_v1.pep.all.fa.gz',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj/pep/Mus_musculus_c57bl6nj.C57BL_6NJ_v1.pep.all.fa.gz',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij/pep/Mus_musculus_casteij.CAST_EiJ_v1.pep.all.fa.gz',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj/pep/Mus_musculus_cbaj.CBA_J_v1.pep.all.fa.gz',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j/pep/Mus_musculus_dba2j.DBA_2J_v1.pep.all.fa.gz',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj/pep/Mus_musculus_fvbnj.FVB_NJ_v1.pep.all.fa.gz',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj/pep/Mus_musculus_lpj.LP_J_v1.pep.all.fa.gz',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj/pep/Mus_musculus_nodshiltj.NOD_ShiLtJ_v1.pep.all.fa.gz',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj/pep/Mus_musculus_nzohlltj.NZO_HlLtJ_v1.pep.all.fa.gz',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj/pep/Mus_musculus_pwkphj.PWK_PhJ_v1.pep.all.fa.gz',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij/pep/Mus_musculus_wsbeij.WSB_EiJ_v1.pep.all.fa.gz',
'GCA_900095145.2_PAHARI_EIJ_v1.1' => 'mus_pahari/pep/Mus_pahari.PAHARI_EIJ_v1.1.pep.all.fa.gz',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari/pep/Mus_pahari.PAHARI_EIJ_v1.1.pep.all.fa.gz',
'GCA_003336285.1_MUSP714' => 'mus_spicilegus/pep/Mus_spicilegus.MUSP714.pep.all.fa.gz',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus/pep/Mus_spretus.SPRET_EiJ_v1.pep.all.fa.gz',
'GCA_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'GCF_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'musFur1' => 'mustela_putorius_furo/pep/Mustela_putorius_furo.MusPutFur1.0.pep.all.fa.gz',
'GCA_000147115.1_Myoluc2.0' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'GCF_000147115.1_Myoluc2.0' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'myoLuc2' => 'myotis_lucifugus/pep/Myotis_lucifugus.Myoluc2.0.pep.all.fa.gz',
'GCA_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/pep/Myripristis_murdjan.fMyrMur1.1.pep.all.fa.gz',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan/pep/Myripristis_murdjan.fMyrMur1.1.pep.all.fa.gz',
'GCA_009733165.1_Nana_v5' => 'naja_naja/pep/Naja_naja.Nana_v5.pep.all.fa.gz',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'GCF_000622305.1_S.galili_v1.0' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'nanGal1' => 'nannospalax_galili/pep/Nannospalax_galili.S.galili_v1.0.pep.all.fa.gz',
'GCA_007210695.1_RGoby_Basel_V2' => 'neogobius_melanostomus/pep/Neogobius_melanostomus.RGoby_Basel_V2.pep.all.fa.gz',
'GCA_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/pep/Neolamprologus_brichardi.NeoBri1.0.pep.all.fa.gz',
'GCF_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi/pep/Neolamprologus_brichardi.NeoBri1.0.pep.all.fa.gz',
'neoBri1' => 'neolamprologus_brichardi/pep/Neolamprologus_brichardi.NeoBri1.0.pep.all.fa.gz',
'GCA_900108605.1_NNQGG.v01' => 'neovison_vison/pep/Neovison_vison.NNQGG.v01.pep.all.fa.gz',
'GCA_000146795.3_Nleu_3.0' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu_3.0.pep.all.fa.gz',
'nomLeu3' => 'nomascus_leucogenys/pep/Nomascus_leucogenys.Nleu_3.0.pep.all.fa.gz',
'GCA_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/pep/Notechis_scutatus.TS10Xv2-PRI.pep.all.fa.gz',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus/pep/Notechis_scutatus.TS10Xv2-PRI.pep.all.fa.gz',
'GCA_001465895.2_Nfu_20140520' => 'nothobranchius_furzeri/pep/Nothobranchius_furzeri.Nfu_20140520.pep.all.fa.gz',
'GCF_001465895.1_Nfu_20140520' => 'nothobranchius_furzeri/pep/Nothobranchius_furzeri.Nfu_20140520.pep.all.fa.gz',
'GCA_003342845.1_notPer1' => 'nothoprocta_perdicaria/pep/Nothoprocta_perdicaria.notPer1.pep.all.fa.gz',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria/pep/Nothoprocta_perdicaria.notPer1.pep.all.fa.gz',
'GCA_002078875.2_NumMel1.0' => 'numida_meleagris/pep/Numida_meleagris.NumMel1.0.pep.all.fa.gz',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris/pep/Numida_meleagris.NumMel1.0.pep.all.fa.gz',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'GCF_000260255.1_OctDeg1.0' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'octDeg1' => 'octodon_degus/pep/Octodon_degus.OctDeg1.0.pep.all.fa.gz',
'GCA_002021735.2_Okis_V2' => 'oncorhynchus_kisutch/pep/Oncorhynchus_kisutch.Okis_V2.pep.all.fa.gz',
'GCF_002021735.2_Okis_V2' => 'oncorhynchus_kisutch/pep/Oncorhynchus_kisutch.Okis_V2.pep.all.fa.gz',
'GCA_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss/pep/Oncorhynchus_mykiss.Omyk_1.0.pep.all.fa.gz',
'GCF_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss/pep/Oncorhynchus_mykiss.Omyk_1.0.pep.all.fa.gz',
'GCA_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha/pep/Oncorhynchus_tshawytscha.Otsh_v1.0.pep.all.fa.gz',
'GCF_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha/pep/Oncorhynchus_tshawytscha.Otsh_v1.0.pep.all.fa.gz',
'GCA_005870065.1_ASM587006v1' => 'oreochromis_aureus/pep/Oreochromis_aureus.ASM587006v1.pep.all.fa.gz',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus/pep/Oreochromis_aureus.ASM587006v1.pep.all.fa.gz',
'GCA_001858045.3_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.O_niloticus_UMD_NMBU.pep.all.fa.gz',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus/pep/Oreochromis_niloticus.O_niloticus_UMD_NMBU.pep.all.fa.gz',
'GCA_004115215.2_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.mOrnAna1.p.v1.pep.all.fa.gz',
'GCF_004115215.1_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus/pep/Ornithorhynchus_anatinus.mOrnAna1.p.v1.pep.all.fa.gz',
'GCA_000003625.1_OryCun2.0' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'GCF_000003625.3_OryCun2.0' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'oryCun2' => 'oryctolagus_cuniculus/pep/Oryctolagus_cuniculus.OryCun2.0.pep.all.fa.gz',
'GCA_003999625.1_OJAV_1.1' => 'oryzias_javanicus/pep/Oryzias_javanicus.OJAV_1.1.pep.all.fa.gz',
'GCA_002234675.1_ASM223467v1' => 'oryzias_latipes/pep/Oryzias_latipes.ASM223467v1.pep.all.fa.gz',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes/pep/Oryzias_latipes.ASM223467v1.pep.all.fa.gz',
'GCA_002234715.1_ASM223471v1' => 'oryzias_latipes_hni/pep/Oryzias_latipes_hni.ASM223471v1.pep.all.fa.gz',
'GCA_002234695.1_ASM223469v1' => 'oryzias_latipes_hsok/pep/Oryzias_latipes_hsok.ASM223469v1.pep.all.fa.gz',
'GCA_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/pep/Oryzias_melastigma.Om_v0.7.RACA.pep.all.fa.gz',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma/pep/Oryzias_melastigma.Om_v0.7.RACA.pep.all.fa.gz',
'GCA_008586565.1_ASM858656v1' => 'oryzias_sinensis/pep/Oryzias_sinensis.ASM858656v1.pep.all.fa.gz',
'GCA_000181295.3_OtoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'otoGar3' => 'otolemur_garnettii/pep/Otolemur_garnettii.OtoGar3.pep.all.fa.gz',
'GCA_010365825.1_OtuSun1.0' => 'otus_sunia/pep/Otus_sunia.OtuSun1.0.pep.all.fa.gz',
'GCA_000298735.1_Oar_v3.1' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'oviAri3' => 'ovis_aries/pep/Ovis_aries.Oar_v3.1.pep.all.fa.gz',
'GCA_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet/pep/Ovis_aries_rambouillet.Oar_rambouillet_v1.0.pep.all.fa.gz',
'GCF_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet/pep/Ovis_aries_rambouillet.Oar_rambouillet_v1.0.pep.all.fa.gz',
'GCA_000258655.2_panpan1.1' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'GCF_000258655.2_panpan1.1' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'panPan2' => 'pan_paniscus/pep/Pan_paniscus.panpan1.1.pep.all.fa.gz',
'GCA_000001515.5_Pan_tro_3.0' => 'pan_troglodytes/pep/Pan_troglodytes.Pan_tro_3.0.pep.all.fa.gz',
'panTro5' => 'pan_troglodytes/pep/Pan_troglodytes.Pan_tro_3.0.pep.all.fa.gz',
'GCA_008795835.1_PanLeo1.0' => 'panthera_leo/pep/Panthera_leo.PanLeo1.0.pep.all.fa.gz',
'GCA_001857705.1_PanPar1.0' => 'panthera_pardus/pep/Panthera_pardus.PanPar1.0.pep.all.fa.gz',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus/pep/Panthera_pardus.PanPar1.0.pep.all.fa.gz',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/pep/Panthera_tigris_altaica.PanTig1.0.pep.all.fa.gz',
'GCF_000464555.1_PanTig1.0' => 'panthera_tigris_altaica/pep/Panthera_tigris_altaica.PanTig1.0.pep.all.fa.gz',
'panTig1' => 'panthera_tigris_altaica/pep/Panthera_tigris_altaica.PanTig1.0.pep.all.fa.gz',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'GCF_000264685.3_Panu_3.0' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'papAnu4' => 'papio_anubis/pep/Papio_anubis.Panu_3.0.pep.all.fa.gz',
'GCA_900634625.1_fParRan2.1' => 'parambassis_ranga/pep/Parambassis_ranga.fParRan2.1.pep.all.fa.gz',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga/pep/Parambassis_ranga.fParRan2.1.pep.all.fa.gz',
'GCA_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/pep/Paramormyrops_kingsleyae.PKINGS_0.1.pep.all.fa.gz',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae/pep/Paramormyrops_kingsleyae.PKINGS_0.1.pep.all.fa.gz',
'GCA_001522545.2_Parus_major1.1' => 'parus_major/pep/Parus_major.Parus_major1.1.pep.all.fa.gz',
'GCF_001522545.3_Parus_major1.1' => 'parus_major/pep/Parus_major.Parus_major1.1.pep.all.fa.gz',
'GCA_005519975.1_AIIM_Pcri_1.0' => 'pavo_cristatus/pep/Pavo_cristatus.AIIM_Pcri_1.0.pep.all.fa.gz',
'GCA_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'GCF_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'pelSin1' => 'pelodiscus_sinensis/pep/Pelodiscus_sinensis.PelSin_1.0.pep.all.fa.gz',
'GCA_007922175.1_Pelusios_castaneus-1.0' => 'pelusios_castaneus/pep/Pelusios_castaneus.Pelusios_castaneus-1.0.pep.all.fa.gz',
'GCA_000787105.1_PM.fa' => 'periophthalmus_magnuspinnatus/pep/Periophthalmus_magnuspinnatus.PM.fa.pep.all.fa.gz',
'GCA_003704035.1_HU_Pman_2.1' => 'peromyscus_maniculatus_bairdii/pep/Peromyscus_maniculatus_bairdii.HU_Pman_2.1.pep.all.fa.gz',
'GCA_000148955.1_Petromyzon_marinus-7.0' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'petMar2' => 'petromyzon_marinus/pep/Petromyzon_marinus.Pmarinus_7.0.pep.all.fa.gz',
'GCA_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/pep/Phascolarctos_cinereus.phaCin_unsw_v4.1.pep.all.fa.gz',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus/pep/Phascolarctos_cinereus.phaCin_unsw_v4.1.pep.all.fa.gz',
'GCA_004143745.1_ASM414374v1' => 'phasianus_colchicus/pep/Phasianus_colchicus.ASM414374v1.pep.all.fa.gz',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus/pep/Phasianus_colchicus.ASM414374v1.pep.all.fa.gz',
'GCA_008692025.1_mPhoSin1.pri' => 'phocoena_sinus/pep/Phocoena_sinus.mPhoSin1.pri.pep.all.fa.gz',
'GCF_008692025.1_mPhoSin1.pri' => 'phocoena_sinus/pep/Phocoena_sinus.mPhoSin1.pri.pep.all.fa.gz',
'GCA_002837175.2_ASM283717v2' => 'physeter_catodon/pep/Physeter_catodon.ASM283717v2.pep.all.fa.gz',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon/pep/Physeter_catodon.ASM283717v2.pep.all.fa.gz',
'GCA_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/pep/Piliocolobus_tephrosceles.ASM277652v2.pep.all.fa.gz',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles/pep/Piliocolobus_tephrosceles.ASM277652v2.pep.all.fa.gz',
'GCA_004329235.1_PodMur_1.0' => 'podarcis_muralis/pep/Podarcis_muralis.PodMur_1.0.pep.all.fa.gz',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis/pep/Podarcis_muralis.PodMur_1.0.pep.all.fa.gz',
'GCA_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'GCF_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'poeFor1' => 'poecilia_formosa/pep/Poecilia_formosa.PoeFor_5.1.2.pep.all.fa.gz',
'GCA_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/pep/Poecilia_latipinna.P_latipinna-1.0.pep.all.fa.gz',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna/pep/Poecilia_latipinna.P_latipinna-1.0.pep.all.fa.gz',
'GCA_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/pep/Poecilia_mexicana.P_mexicana-1.0.pep.all.fa.gz',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana/pep/Poecilia_mexicana.P_mexicana-1.0.pep.all.fa.gz',
'GCA_000633615.2_Guppy_female_1.0_MT' => 'poecilia_reticulata/pep/Poecilia_reticulata.Guppy_female_1.0_MT.pep.all.fa.gz',
'GCF_000633615.1_Guppy_female_1.0_MT' => 'poecilia_reticulata/pep/Poecilia_reticulata.Guppy_female_1.0_MT.pep.all.fa.gz',
'poeRet1' => 'poecilia_reticulata/pep/Poecilia_reticulata.Guppy_female_1.0_MT.pep.all.fa.gz',
'GCA_900067755.1_pvi1.1' => 'pogona_vitticeps/pep/Pogona_vitticeps.pvi1.1.pep.all.fa.gz',
'ponAbe2' => 'pongo_abelii/pep/Pongo_abelii.PPYG2.pep.all.fa.gz',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus/pep/Prolemur_simus.Prosim_1.0.pep.all.fa.gz',
'GCA_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'GCF_000956105.1_Pcoq_1.0' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'proCoq1' => 'propithecus_coquereli/pep/Propithecus_coquereli.Pcoq_1.0.pep.all.fa.gz',
'GCA_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/pep/Pseudonaja_textilis.EBS10Xv2-PRI.pep.all.fa.gz',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis/pep/Pseudonaja_textilis.EBS10Xv2-PRI.pep.all.fa.gz',
'GCA_000239375.1_PunNye1.0' => 'pundamilia_nyererei/pep/Pundamilia_nyererei.PunNye1.0.pep.all.fa.gz',
'GCF_000239375.1_PunNye1.0' => 'pundamilia_nyererei/pep/Pundamilia_nyererei.PunNye1.0.pep.all.fa.gz',
'punNye1' => 'pundamilia_nyererei/pep/Pundamilia_nyererei.PunNye1.0.pep.all.fa.gz',
'GCA_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/pep/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.pep.all.fa.gz',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri/pep/Pygocentrus_nattereri.Pygocentrus_nattereri-1.0.2.pep.all.fa.gz',
'GCA_000001895.4_Rnor_6.0' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'GCF_000001895.5_Rnor_6.0' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'rn6' => 'rattus_norvegicus/pep/Rattus_norvegicus.Rnor_6.0.pep.all.fa.gz',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/pep/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.pep.all.fa.gz',
'GCF_004115265.1_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum/pep/Rhinolophus_ferrumequinum.mRhiFer1_v1.p.pep.all.fa.gz',
'GCA_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'GCF_001698545.1_ASM169854v1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'rhiBie1' => 'rhinopithecus_bieti/pep/Rhinopithecus_bieti.ASM169854v1.pep.all.fa.gz',
'GCA_000769185.1_Rrox_v1' => 'rhinopithecus_roxellana/pep/Rhinopithecus_roxellana.Rrox_v1.pep.all.fa.gz',
'rhiRox1' => 'rhinopithecus_roxellana/pep/Rhinopithecus_roxellana.Rrox_v1.pep.all.fa.gz',
'GCA_000146045.2_R64-1-1' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'GCF_000146045.2_R64' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'sacCer3' => 'saccharomyces_cerevisiae/pep/Saccharomyces_cerevisiae.R64-1-1.pep.all.fa.gz',
'GCA_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'GCF_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'saiBol1' => 'saimiri_boliviensis_boliviensis/pep/Saimiri_boliviensis_boliviensis.SaiBol1.0.pep.all.fa.gz',
'GCA_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/pep/Salarias_fasciatus.fSalaFa1.1.pep.all.fa.gz',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus/pep/Salarias_fasciatus.fSalaFa1.1.pep.all.fa.gz',
'GCA_000233375.4_ICSASG_v2' => 'salmo_salar/pep/Salmo_salar.ICSASG_v2.pep.all.fa.gz',
'GCA_901001165.1_fSalTru1.1' => 'salmo_trutta/pep/Salmo_trutta.fSalTru1.1.pep.all.fa.gz',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta/pep/Salmo_trutta.fSalTru1.1.pep.all.fa.gz',
'GCA_003586115.1_HLtupMer3' => 'salvator_merianae/pep/Salvator_merianae.HLtupMer3.pep.all.fa.gz',
'GCA_008315115.1_SLUC_FBN_1' => 'sander_lucioperca/pep/Sander_lucioperca.SLUC_FBN_1.pep.all.fa.gz',
'GCF_008315115.1_SLUC_FBN_1' => 'sander_lucioperca/pep/Sander_lucioperca.SLUC_FBN_1.pep.all.fa.gz',
'GCA_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.mSarHar1.11.pep.all.fa.gz',
'GCF_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii/pep/Sarcophilus_harrisii.mSarHar1.11.pep.all.fa.gz',
'GCA_902686455.1_mSciVul1.1' => 'sciurus_vulgaris/pep/Sciurus_vulgaris.mSciVul1.1.pep.all.fa.gz',
'GCA_900964775.1_fSclFor1.1' => 'scleropages_formosus/pep/Scleropages_formosus.fSclFor1.1.pep.all.fa.gz',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus/pep/Scleropages_formosus.fSclFor1.1.pep.all.fa.gz',
'GCF_013347765.1_ASM1334776v1' => 'scophthalmus_maximus/pep/Scophthalmus_maximus.ASM1334776v1.pep.all.fa.gz',
'GCA_003186165.1_ASM318616v1' => 'scophthalmus_maximus/pep/Scophthalmus_maximus.ASM318616v1.pep.all.fa.gz',
'GCA_000534875.1_SCA1' => 'serinus_canaria/pep/Serinus_canaria.SCA1.pep.all.fa.gz',
'serCan1' => 'serinus_canaria/pep/Serinus_canaria.SCA1.pep.all.fa.gz',
'GCA_002260705.1_Sdu_1.0' => 'seriola_dumerili/pep/Seriola_dumerili.Sdu_1.0.pep.all.fa.gz',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili/pep/Seriola_dumerili.Sdu_1.0.pep.all.fa.gz',
'GCA_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/pep/Seriola_lalandi_dorsalis.Sedor1.pep.all.fa.gz',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis/pep/Seriola_lalandi_dorsalis.Sedor1.pep.all.fa.gz',
'GCA_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/pep/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.pep.all.fa.gz',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis/pep/Sinocyclocheilus_anshuiensis.SAMN03320099.WGS_v1.1.pep.all.fa.gz',
'GCA_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/pep/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.pep.all.fa.gz',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami/pep/Sinocyclocheilus_grahami.SAMN03320097.WGS_v1.1.pep.all.fa.gz',
'GCA_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/pep/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.pep.all.fa.gz',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous/pep/Sinocyclocheilus_rhinocerous.SAMN03320098_v1.1.pep.all.fa.gz',
'GCA_900880675.1_fSpaAur1.1' => 'sparus_aurata/pep/Sparus_aurata.fSpaAur1.1.pep.all.fa.gz',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata/pep/Sparus_aurata.fSpaAur1.1.pep.all.fa.gz',
'GCA_002406435.1_ASM240643v1' => 'spermophilus_dauricus/pep/Spermophilus_dauricus.ASM240643v1.pep.all.fa.gz',
'GCA_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/pep/Sphaeramia_orbicularis.fSphaOr1.1.pep.all.fa.gz',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis/pep/Sphaeramia_orbicularis.fSphaOr1.1.pep.all.fa.gz',
'GCA_003113815.1_ASM311381v1' => 'sphenodon_punctatus/pep/Sphenodon_punctatus.ASM311381v1.pep.all.fa.gz',
'GCA_008694505.1_ASM869450v1' => 'stachyris_ruficeps/pep/Stachyris_ruficeps.ASM869450v1.pep.all.fa.gz',
'GCA_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/pep/Stegastes_partitus.Stegastes_partitus-1.0.2.pep.all.fa.gz',
'GCF_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus/pep/Stegastes_partitus.Stegastes_partitus-1.0.2.pep.all.fa.gz',
'stePar1' => 'stegastes_partitus/pep/Stegastes_partitus.Stegastes_partitus-1.0.2.pep.all.fa.gz',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/pep/Strigops_habroptila.bStrHab1_v1.p.pep.all.fa.gz',
'GCF_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila/pep/Strigops_habroptila.bStrHab1_v1.p.pep.all.fa.gz',
'GCA_002372975.1_Soccid_v01' => 'strix_occidentalis_caurina/pep/Strix_occidentalis_caurina.Soccid_v01.pep.all.fa.gz',
'GCA_000698965.1_ASM69896v1' => 'struthio_camelus_australis/pep/Struthio_camelus_australis.ASM69896v1.pep.all.fa.gz',
'GCF_000698965.1_ASM69896v1' => 'struthio_camelus_australis/pep/Struthio_camelus_australis.ASM69896v1.pep.all.fa.gz',
'strCam1' => 'struthio_camelus_australis/pep/Struthio_camelus_australis.ASM69896v1.pep.all.fa.gz',
'GCA_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/pep/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.pep.all.fa.gz',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta/pep/Suricata_suricatta.meerkat_22Aug2017_6uvM2_HiC.pep.all.fa.gz',
'GCA_000003025.6_Sscrofa11.1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'GCF_000003025.6_Sscrofa11.1' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'susScr11' => 'sus_scrofa/pep/Sus_scrofa.Sscrofa11.1.pep.all.fa.gz',
'GCA_001700235.1_Bamei_pig_v1' => 'sus_scrofa_bamei/pep/Sus_scrofa_bamei.Bamei_pig_v1.pep.all.fa.gz',
'GCA_001700575.1_Berkshire_pig_v1' => 'sus_scrofa_berkshire/pep/Sus_scrofa_berkshire.Berkshire_pig_v1.pep.all.fa.gz',
'GCA_001700165.1_Hampshire_pig_v1' => 'sus_scrofa_hampshire/pep/Sus_scrofa_hampshire.Hampshire_pig_v1.pep.all.fa.gz',
'GCA_001700295.1_Jinhua_pig_v1' => 'sus_scrofa_jinhua/pep/Sus_scrofa_jinhua.Jinhua_pig_v1.pep.all.fa.gz',
'GCA_001700215.1_Landrace_pig_v1' => 'sus_scrofa_landrace/pep/Sus_scrofa_landrace.Landrace_pig_v1.pep.all.fa.gz',
'GCA_001700135.1_Large_White_v1' => 'sus_scrofa_largewhite/pep/Sus_scrofa_largewhite.Large_White_v1.pep.all.fa.gz',
'GCA_001700195.1_Meishan_pig_v1' => 'sus_scrofa_meishan/pep/Sus_scrofa_meishan.Meishan_pig_v1.pep.all.fa.gz',
'GCA_001700255.1_Pietrain_pig_v1' => 'sus_scrofa_pietrain/pep/Sus_scrofa_pietrain.Pietrain_pig_v1.pep.all.fa.gz',
'GCA_001700155.1_Rongchang_pig_v1' => 'sus_scrofa_rongchang/pep/Sus_scrofa_rongchang.Rongchang_pig_v1.pep.all.fa.gz',
'GCA_000472085.2_Tibetan_Pig_v2' => 'sus_scrofa_tibetan/pep/Sus_scrofa_tibetan.Tibetan_Pig_v2.pep.all.fa.gz',
'GCA_002844635.1_USMARCv1.0' => 'sus_scrofa_usmarc/pep/Sus_scrofa_usmarc.USMARCv1.0.pep.all.fa.gz',
'GCA_000325925.2_minipig_v1.0' => 'sus_scrofa_wuzhishan/pep/Sus_scrofa_wuzhishan.minipig_v1.0.pep.all.fa.gz',
'GCA_003957565.2_bTaeGut1_v1.p' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.bTaeGut1_v1.p.pep.all.fa.gz',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata/pep/Taeniopygia_guttata.bTaeGut1_v1.p.pep.all.fa.gz',
'GCA_901000725.2_fTakRub1.2' => 'takifugu_rubripes/pep/Takifugu_rubripes.fTakRub1.2.pep.all.fa.gz',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes/pep/Takifugu_rubripes.fTakRub1.2.pep.all.fa.gz',
'GCA_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis/pep/Terrapene_carolina_triunguis.T_m_triunguis-2.0.pep.all.fa.gz',
'GCF_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis/pep/Terrapene_carolina_triunguis.T_m_triunguis-2.0.pep.all.fa.gz',
'tetNig2' => 'tetraodon_nigroviridis/pep/Tetraodon_nigroviridis.TETRAODON8.pep.all.fa.gz',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada/pep/Theropithecus_gelada.Tgel_1.0.pep.all.fa.gz',
'GCF_003255815.1_Tgel_1.0' => 'theropithecus_gelada/pep/Theropithecus_gelada.Tgel_1.0.pep.all.fa.gz',
'GCA_003426925.1_ASM342692v1' => 'urocitellus_parryii/pep/Urocitellus_parryii.ASM342692v1.pep.all.fa.gz',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii/pep/Urocitellus_parryii.ASM342692v1.pep.all.fa.gz',
'GCA_003344425.1_ASM334442v1' => 'ursus_americanus/pep/Ursus_americanus.ASM334442v1.pep.all.fa.gz',
'GCA_000687225.1_UrsMar_1.0' => 'ursus_maritimus/pep/Ursus_maritimus.UrsMar_1.0.pep.all.fa.gz',
'GCF_000687225.1_UrsMar_1.0' => 'ursus_maritimus/pep/Ursus_maritimus.UrsMar_1.0.pep.all.fa.gz',
'ursMar1' => 'ursus_maritimus/pep/Ursus_maritimus.UrsMar_1.0.pep.all.fa.gz',
'GCA_009660055.1_ASM966005v1' => 'ursus_thibetanus_thibetanus/pep/Ursus_thibetanus_thibetanus.ASM966005v1.pep.all.fa.gz',
'GCA_004798865.1_ASM479886v1' => 'varanus_komodoensis/pep/Varanus_komodoensis.ASM479886v1.pep.all.fa.gz',
'GCA_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/pep/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.pep.all.fa.gz',
'GCF_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus/pep/Vombatus_ursinus.bare-nosed_wombat_genome_assembly.pep.all.fa.gz',
'GCA_003160815.1_VulVul2.2' => 'vulpes_vulpes/pep/Vulpes_vulpes.VulVul2.2.pep.all.fa.gz',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes/pep/Vulpes_vulpes.VulVul2.2.pep.all.fa.gz',
'GCA_000004195.3_Xenopus_tropicalis_v9.1' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.pep.all.fa.gz',
'xenTro9' => 'xenopus_tropicalis/pep/Xenopus_tropicalis.Xenopus_tropicalis_v9.1.pep.all.fa.gz',
'GCA_001444195.1_Xiphophorus_couchianus-4.0.1' => 'xiphophorus_couchianus/pep/Xiphophorus_couchianus.Xiphophorus_couchianus-4.0.1.pep.all.fa.gz',
'GCA_002775205.2_X_maculatus-5.0-male' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.X_maculatus-5.0-male.pep.all.fa.gz',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus/pep/Xiphophorus_maculatus.X_maculatus-5.0-male.pep.all.fa.gz',
'GCA_009762305.1_mZalCal1.pri' => 'zalophus_californianus/pep/Zalophus_californianus.mZalCal1.pri.pep.all.fa.gz',
'GCA_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/pep/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.pep.all.fa.gz',
'GCF_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis/pep/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.pep.all.fa.gz',
'zonAlb1' => 'zonotrichia_albicollis/pep/Zonotrichia_albicollis.Zonotrichia_albicollis-1.0.1.pep.all.fa.gz',
'GCA_001281735.1_ASM128173v1' => 'zosterops_lateralis_melanops/pep/Zosterops_lateralis_melanops.ASM128173v1.pep.all.fa.gz',
);

my %ensGeneFtpMySqlFileNames_104 = (
'GCA_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus_core_104_1',
'GCF_002109545.1_ASM210954v1' => 'acanthochromis_polyacanthus_core_104_1',
'GCA_004320145.1_Accipiter_nisus_ver1.0' => 'accipiter_nisus_core_104_1',
'GCA_002007445.2_ASM200744v2' => 'ailuropoda_melanoleuca_core_104_2',
'GCF_002007445.1_ASM200744v2' => 'ailuropoda_melanoleuca_core_104_2',
'GCA_003947215.1_ASM394721v1' => 'amazona_collaria_core_104_1',
'GCA_000751415.1_Midas_v5' => 'amphilophus_citrinellus_core_104_5',
'GCA_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris_core_104_1',
'GCF_002776465.1_AmpOce1.0' => 'amphiprion_ocellaris_core_104_1',
'GCA_003047355.1_Nemo_v1' => 'amphiprion_percula_core_104_1',
'GCA_900324465.1_fAnaTes1.1' => 'anabas_testudineus_core_104_12',
'GCA_900324465.2_fAnaTes1.2' => 'anabas_testudineus_core_104_12',
'GCF_900324465.2_fAnaTes1.2' => 'anabas_testudineus_core_104_12',
'GCA_008746955.1_ASM874695v1' => 'anas_platyrhynchos_core_104_1',
'GCA_002743455.1_CAU_duck1.0' => 'anas_platyrhynchos_platyrhynchos_core_104_1',
'GCA_002224875.1_ASM222487v1' => 'anas_zonorhyncha_core_104_1',
'GCA_000090745.2_AnoCar2.0' => 'anolis_carolinensis_core_104_2',
'GCF_000090745.1_AnoCar2.0' => 'anolis_carolinensis_core_104_2',
'anoCar2' => 'anolis_carolinensis_core_104_2',
'GCA_002592135.1_ASM259213v1' => 'anser_brachyrhynchus_core_104_1',
'GCA_002166845.1_GooseV1.0' => 'anser_cygnoides_core_104_1',
'GCA_000952055.2_Anan_2.0' => 'aotus_nancymaae_core_104_1',
'GCF_000952055.2_Anan_2.0' => 'aotus_nancymaae_core_104_1',
'aotNan1' => 'aotus_nancymaae_core_104_1',
'GCA_003342985.1_aptHaa1' => 'apteryx_haastii_core_104_1',
'GCA_003342965.1_aptOwe1' => 'apteryx_owenii_core_104_1',
'GCA_003343035.1_aptRow1' => 'apteryx_rowi_core_104_1',
'GCF_003343035.1_aptRow1' => 'apteryx_rowi_core_104_1',
'GCA_900496995.2_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos_core_104_12',
'GCF_900496995.1_bAquChr1.2' => 'aquila_chrysaetos_chrysaetos_core_104_12',
'GCA_900246225.3_fAstCal1.2' => 'astatotilapia_calliptera_core_104_12',
'GCF_900246225.1_fAstCal1.2' => 'astatotilapia_calliptera_core_104_12',
'GCA_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus_core_104_2',
'GCF_000372685.2_Astyanax_mexicanus-2.0' => 'astyanax_mexicanus_core_104_2',
'GCA_004802775.1_Astyanax_mexicanus-1.0.2' => 'astyanax_mexicanus_pachon_core_104_102',
'astMex1' => 'astyanax_mexicanus_pachon_core_104_102',
'GCA_003259725.1_athCun1' => 'athene_cunicularia_core_104_1',
'GCF_003259725.1_athCun1' => 'athene_cunicularia_core_104_1',
'GCA_009873245.2_mBalMus1.v2' => 'balaenoptera_musculus_core_104_2',
'GCA_900634795.2_fBetSpl5.2' => 'betta_splendens_core_104_52',
'GCF_900634795.2_fBetSpl5.2' => 'betta_splendens_core_104_52',
'GCA_000754665.1_Bison_UMD1.0' => 'bison_bison_bison_core_104_1',
'bisBis1' => 'bison_bison_bison_core_104_1',
'GCA_005887515.1_LU_Bosgru_v3.0' => 'bos_grunniens_core_104_3',
'GCA_003369695.2_UOA_Brahman_1' => 'bos_indicus_hybrid_core_104_1',
'GCF_003369695.1_UOA_Brahman_1' => 'bos_indicus_hybrid_core_104_1',
'GCA_000298355.1_BosGru_v2.0' => 'bos_mutus_core_104_2',
'GCF_000298355.1_BosGru_v2.0' => 'bos_mutus_core_104_2',
'bosMut1' => 'bos_mutus_core_104_2',
'GCA_002263795.2_ARS-UCD1.2' => 'bos_taurus_core_104_12',
'GCF_002263795.1_ARS-UCD1.2' => 'bos_taurus_core_104_12',
'bosTau9' => 'bos_taurus_core_104_12',
'GCA_003369685.2_UOA_Angus_1' => 'bos_taurus_hybrid_core_104_1',
'GCA_010303855.1_BubBub1.0' => 'bubo_bubo_core_104_1',
'GCA_010312235.1_ButJap1.0' => 'buteo_japonicus_core_104_1',
'GCF_000002985.6_WBcel235' => 'caenorhabditis_elegans_core_104_269',
'ce11' => 'caenorhabditis_elegans_core_104_269',
'GCA_009194515.1_CaiMos1.0' => 'cairina_moschata_domestica_core_104_1',
'GCA_001431845.1_ASM143184v1' => 'calidris_pugnax_core_104_1',
'GCF_001431845.1_ASM143184v1' => 'calidris_pugnax_core_104_1',
'GCA_003697955.1_ASM369795v1' => 'calidris_pygmaea_core_104_1',
'GCA_002754865.1_ASM275486v1' => 'callithrix_jacchus_core_104_1',
'GCA_000165045.2_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii_core_104_613',
'GCF_000165045.1_Callorhinchus_milii-6.1.3' => 'callorhinchus_milii_core_104_613',
'calMil1' => 'callorhinchus_milii_core_104_613',
'GCA_901933205.1_STF_HiC' => 'camarhynchus_parvulus_core_104_1',
'GCF_901933205.1_STF_HiC' => 'camarhynchus_parvulus_core_104_1',
'GCA_000803125.2_CamDro2' => 'camelus_dromedarius_core_104_2',
'GCA_003254725.1_ASM325472v1' => 'canis_lupus_dingo_core_104_1',
'GCF_003254725.1_ASM325472v1' => 'canis_lupus_dingo_core_104_1',
'GCA_000002285.2_CanFam3.1' => 'canis_lupus_familiaris_core_104_31',
'GCF_000002285.3_CanFam3.1' => 'canis_lupus_familiaris_core_104_31',
'canFam3' => 'canis_lupus_familiaris_core_104_31',
'GCA_004886185.1_Basenji_breed-1.1' => 'canis_lupus_familiarisbasenji_core_104_11',
'GCA_005444595.1_UMICH_Zoey_3.1' => 'canis_lupus_familiarisgreatdane_core_104_31',
'canFam5' => 'canis_lupus_familiarisgreatdane_core_104_31',
'GCA_001704415.1_ARS1' => 'capra_hircus_core_104_1',
'GCF_001704415.1_ARS1' => 'capra_hircus_core_104_1',
'GCA_004361675.1_CVASU_BBG_1.0' => 'capra_hircus_blackbengal_core_104_1',
'GCA_003368295.1_ASM336829v1' => 'carassius_auratus_core_104_1',
'GCF_003368295.1_ASM336829v1' => 'carassius_auratus_core_104_1',
'GCA_000164805.2_Tarsius_syrichta-2.0.1' => 'carlito_syrichta_core_104_2',
'GCF_000164805.1_Tarsius_syrichta-2.0.1' => 'carlito_syrichta_core_104_2',
'tarSyr2' => 'carlito_syrichta_core_104_2',
'GCA_001984765.1_C.can_genome_v1.0' => 'castor_canadensis_core_104_1',
'GCF_001984765.1_C.can_genome_v1.0' => 'castor_canadensis_core_104_1',
'casCan1' => 'castor_canadensis_core_104_1',
'GCA_004024745.2_CatWag_v2_BIUU_UCD' => 'catagonus_wagneri_core_104_2',
'GCA_009819885.1_bCatUst1.pri' => 'catharus_ustulatus_core_104_1',
'GCF_009819885.1_bCatUst1.pri' => 'catharus_ustulatus_core_104_1',
'GCA_000688575.1_CavAp1.0' => 'cavia_aperea_core_104_10',
'cavApe1' => 'cavia_aperea_core_104_10',
'GCA_000151735.1_Cavpor3.0' => 'cavia_porcellus_core_104_4',
'GCF_000151735.1_Cavpor3.0' => 'cavia_porcellus_core_104_4',
'cavPor3' => 'cavia_porcellus_core_104_4',
'GCA_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus_core_104_1',
'GCF_001604975.1_Cebus_imitator-1.0' => 'cebus_capucinus_core_104_1',
'cebCap1' => 'cebus_capucinus_core_104_1',
'GCA_000955945.1_Caty_1.0' => 'cercocebus_atys_core_104_1',
'GCF_000955945.1_Caty_1.0' => 'cercocebus_atys_core_104_1',
'cerAty1' => 'cercocebus_atys_core_104_1',
'GCA_010411085.1_CEY_v1' => 'cervus_hanglu_yarkandensis_core_104_1',
'GCA_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii_core_104_1',
'GCF_003597395.1_ASM359739v1' => 'chelonoidis_abingdonii_core_104_1',
'GCA_007922165.1_Chelydra_serpentina-1.0' => 'chelydra_serpentina_core_104_1',
'GCA_000276665.1_ChiLan1.0' => 'chinchilla_lanigera_core_104_1',
'GCF_000276665.1_ChiLan1.0' => 'chinchilla_lanigera_core_104_1',
'chiLan1' => 'chinchilla_lanigera_core_104_1',
'GCA_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus_core_104_1',
'GCF_000409795.2_Chlorocebus_sabeus_1.1' => 'chlorocebus_sabaeus_core_104_1',
'chlSab2' => 'chlorocebus_sabaeus_core_104_1',
'GCA_000241765.2_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii_core_104_303',
'GCF_000241765.3_Chrysemys_picta_bellii-3.0.3' => 'chrysemys_picta_bellii_core_104_303',
'chrPic2' => 'chrysemys_picta_bellii_core_104_303',
'GCA_003413605.1_Chrysolophus_pictus_GenomeV1.0' => 'chrysolophus_pictus_core_104_1',
'ci3' => 'ciona_intestinalis_core_104_3',
'cioSav2' => 'ciona_savignyi_core_104_2',
'GCA_900700415.1_Ch_v2.0.2' => 'clupea_harengus_core_104_202',
'GCF_900700415.1_Ch_v2.0.2' => 'clupea_harengus_core_104_202',
'GCA_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus_core_104_1',
'GCF_000951035.1_Cang.pa_1.0' => 'colobus_angolensis_palliatus_core_104_1',
'colAng1' => 'colobus_angolensis_palliatus_core_104_1',
'GCA_009650515.1_UO_Cmon_1.0' => 'corvus_moneduloides_core_104_1',
'GCA_900634415.1_fCotGob3.1' => 'cottoperca_gobio_core_104_31',
'GCF_900634415.1_fCotGob3.1' => 'cottoperca_gobio_core_104_31',
'GCA_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica_core_104_2',
'GCA_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica_core_104_2',
'GCF_001577835.1_Coturnix_japonica_2.0' => 'coturnix_japonica_core_104_2',
'GCF_001577835.2_Coturnix_japonica_2.1' => 'coturnix_japonica_core_104_2',
'cotJap2' => 'coturnix_japonica_core_104_2',
'GCA_900186095.1_CHOK1S_HZDv1' => 'cricetulus_griseus_chok1gshd_core_104_1',
'criGriChoV2' => 'cricetulus_griseus_chok1gshd_core_104_1',
'GCA_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri_core_104_1',
'GCF_000223135.1_CriGri_1.0' => 'cricetulus_griseus_crigri_core_104_1',
'criGriChoV1' => 'cricetulus_griseus_crigri_core_104_1',
'GCA_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr_core_104_1',
'GCF_003668045.1_CriGri-PICR' => 'cricetulus_griseus_picr_core_104_1',
'GCA_001723895.1_CroPor_comp1' => 'crocodylus_porosus_core_104_1',
'GCF_001723895.1_CroPor_comp1' => 'crocodylus_porosus_core_104_1',
'GCA_002901205.1_cyaCae2' => 'cyanistes_caeruleus_core_104_2',
'GCF_002901205.1_cyaCae2' => 'cyanistes_caeruleus_core_104_2',
'GCA_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus_core_104_1',
'GCF_009769545.1_fCycLum1.pri' => 'cyclopterus_lumpus_core_104_1',
'GCA_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis_core_104_1',
'GCF_000523025.1_Cse_v1.0' => 'cynoglossus_semilaevis_core_104_1',
'cynSem1' => 'cynoglossus_semilaevis_core_104_1',
'GCA_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus_core_104_1',
'GCF_000732505.1_C_variegatus-1.0' => 'cyprinodon_variegatus_core_104_1',
'cypVar1' => 'cyprinodon_variegatus_core_104_1',
'GCA_000951615.2_common_carp_genome' => 'cyprinus_carpio_core_104_2',
'GCF_000951615.1_common_carp_genome' => 'cyprinus_carpio_core_104_2',
'GCA_004011555.1_German_Mirror_carp_1.0' => 'cyprinus_carpio_germanmirror_core_104_10',
'GCA_004011595.1_Hebao_red_carp_1.0' => 'cyprinus_carpio_hebaored_core_104_10',
'GCA_004011575.1_Hunaghe_carp_2.0' => 'cyprinus_carpio_huanghe_core_104_20',
'GCA_000208655.2_Dasnov3.0' => 'dasypus_novemcinctus_core_104_3',
'GCF_000208655.1_Dasnov3.0' => 'dasypus_novemcinctus_core_104_3',
'dasNov3' => 'dasypus_novemcinctus_core_104_3',
'GCA_002288925.3_ASM228892v3' => 'delphinapterus_leucas_core_104_3',
'GCF_002288925.2_ASM228892v3' => 'delphinapterus_leucas_core_104_3',
'GCA_900700375.1_fDenClu1.1' => 'denticeps_clupeoides_core_104_11',
'GCF_900700375.1_fDenClu1.1' => 'denticeps_clupeoides_core_104_11',
'GCA_000689215.1_seabass_V1.0' => 'dicentrarchus_labrax_core_104_1',
'dicLab1' => 'dicentrarchus_labrax_core_104_1',
'GCA_000151885.2_Dord_2.0' => 'dipodomys_ordii_core_104_2',
'GCF_000151885.1_Dord_2.0' => 'dipodomys_ordii_core_104_2',
'dipOrd2' => 'dipodomys_ordii_core_104_2',
'GCA_003342905.1_droNov1' => 'dromaius_novaehollandiae_core_104_1',
'GCF_003342905.1_droNov1' => 'dromaius_novaehollandiae_core_104_1',
'GCA_000001215.4_Release_6_plus_ISO1_MT' => 'drosophila_melanogaster_core_104_9',
'GCF_000001215.4_Release_6_plus_ISO1_MT' => 'drosophila_melanogaster_core_104_9',
'dm6' => 'drosophila_melanogaster_core_104_9',
'GCA_900963305.1_fEcheNa1.1' => 'echeneis_naucrates_core_104_11',
'GCF_900963305.1_fEcheNa1.1' => 'echeneis_naucrates_core_104_11',
'GCA_003665695.2_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus_core_104_2',
'GCF_003665695.1_Ee_SOAP_WITH_SSPACE' => 'electrophorus_electricus_core_104_2',
'GCA_900186335.2_Eburgeri_3.2' => 'eptatretus_burgeri_core_104_32',
'GCA_003033725.1_ASM303372v1' => 'equus_asinus_asinus_core_104_1',
'GCA_002863925.1_EquCab3.0' => 'equus_caballus_core_104_3',
'GCF_002863925.1_EquCab3.0' => 'equus_caballus_core_104_3',
'equCab3' => 'equus_caballus_core_104_3',
'GCA_900747795.2_fErpCal1.1' => 'erpetoichthys_calabaricus_core_104_11',
'GCF_900747795.1_fErpCal1.1' => 'erpetoichthys_calabaricus_core_104_11',
'GCA_003676055.1_GouldianFinch' => 'erythrura_gouldiae_core_104_1',
'GCA_004634155.1_Eluc_v4' => 'esox_lucius_core_104_4',
'GCF_004634155.1_Eluc_v4' => 'esox_lucius_core_104_4',
'GCA_010332995.1_FalTin1.0' => 'falco_tinnunculus_core_104_1',
'GCA_000181335.4_Felis_catus_9.0' => 'felis_catus_core_104_9',
'GCF_000181335.3_Felis_catus_9.0' => 'felis_catus_core_104_9',
'felCat9' => 'felis_catus_core_104_9',
'GCA_000247815.2_FicAlb1.5' => 'ficedula_albicollis_core_104_15',
'GCF_000247815.1_FicAlb1.5' => 'ficedula_albicollis_core_104_15',
'ficAlb1' => 'ficedula_albicollis_core_104_15',
'ficAlb2' => 'ficedula_albicollis_core_104_15',
'GCA_000743615.1_DMR_v1.0' => 'fukomys_damarensis_core_104_1',
'GCF_000743615.1_DMR_v1.0' => 'fukomys_damarensis_core_104_1',
'fukDam1' => 'fukomys_damarensis_core_104_1',
'GCA_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus_core_104_302',
'GCF_000826765.1_Fundulus_heteroclitus-3.0.2' => 'fundulus_heteroclitus_core_104_302',
'GCA_902167405.1_gadMor3.0' => 'gadus_morhua_core_104_3',
'GCF_902167405.1_gadMor3.0' => 'gadus_morhua_core_104_3',
'GCA_000002315.5_GRCg6a' => 'gallus_gallus_core_104_6',
'GCF_000002315.6_GRCg6a' => 'gallus_gallus_core_104_6',
'galGal6' => 'gallus_gallus_core_104_6',
'GCA_003097735.1_ASM309773v1' => 'gambusia_affinis_core_104_1',
'GCA_000277835.1_GeoFor_1.0' => 'geospiza_fortis_core_104_1',
'GCF_000277835.1_GeoFor_1.0' => 'geospiza_fortis_core_104_1',
'geoFor1' => 'geospiza_fortis_core_104_1',
'GCA_002896415.1_ASM289641v1' => 'gopherus_agassizii_core_104_1',
'GCA_007399415.1_rGopEvg1_v1.p' => 'gopherus_evgoodei_core_104_1',
'GCF_007399415.2_rGopEvg1_v1.p' => 'gopherus_evgoodei_core_104_1',
'GCA_000151905.3_gorGor4' => 'gorilla_gorilla_core_104_4',
'gorGor4' => 'gorilla_gorilla_core_104_4',
'GCA_900634775.1_fGouWil2.1' => 'gouania_willdenowi_core_104_21',
'GCF_900634775.1_fGouWil2.1' => 'gouania_willdenowi_core_104_21',
'GCA_000239415.1_AstBur1.0' => 'haplochromis_burtoni_core_104_1',
'GCF_000239415.1_AstBur1.0' => 'haplochromis_burtoni_core_104_1',
'hapBur1' => 'haplochromis_burtoni_core_104_1',
'GCA_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female_core_104_1',
'GCF_000247695.1_HetGla_female_1.0' => 'heterocephalus_glaber_female_core_104_1',
'hetGla2' => 'heterocephalus_glaber_female_core_104_1',
'GCA_000230445.1_HetGla_1.0' => 'heterocephalus_glaber_male_core_104_1',
'hetGla1' => 'heterocephalus_glaber_male_core_104_1',
'GCA_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes_core_104_1',
'GCF_001891065.1_H_comes_QL1_v1' => 'hippocampus_comes_core_104_1',
'GCA_003317085.1_ASM331708v1' => 'hucho_hucho_core_104_1',
'GCA_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus_core_104_12',
'GCF_001660625.1_IpCoco_1.2' => 'ictalurus_punctatus_core_104_12',
'GCA_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus_core_104_3',
'GCF_000236235.1_SpeTri2.0' => 'ictidomys_tridecemlineatus_core_104_3',
'speTri2' => 'ictidomys_tridecemlineatus_core_104_3',
'GCA_000280705.1_JacJac1.0' => 'jaculus_jaculus_core_104_10',
'GCF_000280705.1_JacJac1.0' => 'jaculus_jaculus_core_104_10',
'jacJac1' => 'jaculus_jaculus_core_104_10',
'GCA_003829775.1_ASM382977v1' => 'junco_hyemalis_core_104_1',
'GCA_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus_core_104_1',
'GCF_001649575.1_ASM164957v1' => 'kryptolebias_marmoratus_core_104_1',
'GCA_900080235.1_BallGen_V1' => 'labrus_bergylta_core_104_1',
'GCF_900080235.1_BallGen_V1' => 'labrus_bergylta_core_104_1',
'GCA_000972845.2_L_crocea_2.0' => 'larimichthys_crocea_core_104_20',
'GCF_000972845.2_L_crocea_2.0' => 'larimichthys_crocea_core_104_20',
'GCA_001640805.1_ASM164080v1' => 'lates_calcarifer_core_104_1',
'GCA_900066035.1_ASB_HGAPassembly_v1' => 'lates_calcarifer_core_104_1',
'GCF_001640805.1_ASM164080v1' => 'lates_calcarifer_core_104_1',
'GCA_004320025.1_latLat_1.0' => 'laticauda_laticaudata_core_104_1',
'GCA_000225785.1_LatCha1' => 'latimeria_chalumnae_core_104_1',
'GCF_000225785.1_LatCha1' => 'latimeria_chalumnae_core_104_1',
'latCha1' => 'latimeria_chalumnae_core_104_1',
'GCA_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata_core_104_1',
'GCF_001604755.1_Lepidothrix_coronata-1.0' => 'lepidothrix_coronata_core_104_1',
'GCA_000242695.1_LepOcu1' => 'lepisosteus_oculatus_core_104_1',
'GCF_000242695.1_LepOcu1' => 'lepisosteus_oculatus_core_104_1',
'lepOcu1' => 'lepisosteus_oculatus_core_104_1',
'GCA_009667805.1_ASM966780v1' => 'leptobrachium_leishanense_core_104_1',
'GCA_002197715.1_LonStrDom1' => 'lonchura_striata_domestica_core_104_1',
'GCA_000001905.1_Loxafr3.0' => 'loxodonta_africana_core_104_3',
'GCF_000001905.1_Loxafr3.0' => 'loxodonta_africana_core_104_3',
'loxAfr3' => 'loxodonta_africana_core_104_3',
'GCA_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis_core_104_41',
'GCF_007474595.1_mLynCan4_v1.p' => 'lynx_canadensis_core_104_41',
'GCA_011100615.1_Macaca_fascicularis_6.0' => 'macaca_fascicularis_core_104_6',
'GCF_000364345.1_Macaca_fascicularis_5.0' => 'macaca_fascicularis_core_104_6',
'GCA_003339765.3_Mmul_10' => 'macaca_mulatta_core_104_10',
'GCF_003339765.1_Mmul_10' => 'macaca_mulatta_core_104_10',
'rheMac10' => 'macaca_mulatta_core_104_10',
'GCA_000956065.1_Mnem_1.0' => 'macaca_nemestrina_core_104_1',
'GCF_000956065.1_Mnem_1.0' => 'macaca_nemestrina_core_104_1',
'macNem1' => 'macaca_nemestrina_core_104_1',
'GCA_009741485.1_mCya_1.0' => 'malurus_cyaneus_samueli_core_104_1',
'GCA_001715985.2_ASM171598v2' => 'manacus_vitellinus_core_104_2',
'GCA_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus_core_104_1',
'GCF_000951045.1_Mleu.le_1.0' => 'mandrillus_leucophaeus_core_104_1',
'manLeu1' => 'mandrillus_leucophaeus_core_104_1',
'GCA_001458135.1_marMar2.1' => 'marmota_marmota_marmota_core_104_21',
'GCF_001458135.1_marMar2.1' => 'marmota_marmota_marmota_core_104_21',
'GCA_900324485.1_fMasArm1.1' => 'mastacembelus_armatus_core_104_12',
'GCA_900324485.2_fMasArm1.2' => 'mastacembelus_armatus_core_104_12',
'GCF_900324485.2_fMasArm1.2' => 'mastacembelus_armatus_core_104_12',
'GCA_000238955.5_M_zebra_UMD2a' => 'maylandia_zebra_core_104_2',
'GCF_000238955.4_M_zebra_UMD2a' => 'maylandia_zebra_core_104_2',
'GCA_000146605.2_Turkey_2.01' => 'meleagris_gallopavo_core_104_51',
'melGal5' => 'meleagris_gallopavo_core_104_51',
'GCA_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus_core_104_63',
'GCF_000238935.1_Melopsittacus_undulatus_6.3' => 'melopsittacus_undulatus_core_104_63',
'melUnd1' => 'melopsittacus_undulatus_core_104_63',
'GCA_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus_core_104_1',
'GCF_002204375.1_MunDraft-v1.0' => 'meriones_unguiculatus_core_104_1',
'GCA_000349665.1_MesAur1.0' => 'mesocricetus_auratus_core_104_10',
'GCF_000349665.1_MesAur1.0' => 'mesocricetus_auratus_core_104_10',
'mesAur1' => 'mesocricetus_auratus_core_104_10',
'GCA_000165445.3_Mmur_3.0' => 'microcebus_murinus_core_104_3',
'GCF_000165445.2_Mmur_3.0' => 'microcebus_murinus_core_104_3',
'micMur3' => 'microcebus_murinus_core_104_3',
'GCA_000317375.1_MicOch1.0' => 'microtus_ochrogaster_core_104_10',
'GCF_000317375.1_MicOch1.0' => 'microtus_ochrogaster_core_104_10',
'micOch1' => 'microtus_ochrogaster_core_104_10',
'GCA_001698575.1_ASM169857v1' => 'mola_mola_core_104_1',
'GCA_000002295.1_ASM229v1' => 'monodelphis_domestica_core_104_1',
'GCA_005190385.2_NGI_Narwhal_1' => 'monodon_monoceros_core_104_1',
'GCF_005190385.1_NGI_Narwhal_1' => 'monodon_monoceros_core_104_1',
'GCA_001952655.1_M_albus_1.0' => 'monopterus_albus_core_104_1',
'GCF_001952655.1_M_albus_1.0' => 'monopterus_albus_core_104_1',
'GCA_004024705.2_MosMos_v2_BIUU_UCD' => 'moschus_moschiferus_core_104_2',
'GCA_900094665.2_CAROLI_EIJ_v1.1' => 'mus_caroli_core_104_11',
'GCF_900094665.1_CAROLI_EIJ_v1.1' => 'mus_caroli_core_104_11',
'GCA_000001635.9_GRCm39' => 'mus_musculus_core_104_39',
'GCF_000001635.27_GRCm39' => 'mus_musculus_core_104_39',
'mm39' => 'mus_musculus_core_104_39',
'GCA_001624185.1_129S1_SvImJ_v1' => 'mus_musculus_129s1svimj_core_104_1',
'GCA_001624215.1_A_J_v1' => 'mus_musculus_aj_core_104_1',
'GCA_001624295.1_AKR_J_v1' => 'mus_musculus_akrj_core_104_1',
'GCA_001632525.1_BALB_cJ_v1' => 'mus_musculus_balbcj_core_104_1',
'GCA_001632575.1_C3H_HeJ_v1' => 'mus_musculus_c3hhej_core_104_1',
'GCA_001632555.1_C57BL_6NJ_v1' => 'mus_musculus_c57bl6nj_core_104_1',
'GCA_001624445.1_CAST_EiJ_v1' => 'mus_musculus_casteij_core_104_1',
'GCA_001624475.1_CBA_J_v1' => 'mus_musculus_cbaj_core_104_1',
'GCA_001624505.1_DBA_2J_v1' => 'mus_musculus_dba2j_core_104_1',
'GCA_001624535.1_FVB_NJ_v1' => 'mus_musculus_fvbnj_core_104_1',
'GCA_001632615.1_LP_J_v1' => 'mus_musculus_lpj_core_104_1',
'GCA_001624675.1_NOD_ShiLtJ_v1' => 'mus_musculus_nodshiltj_core_104_1',
'GCA_001624745.1_NZO_HlLtJ_v1' => 'mus_musculus_nzohlltj_core_104_1',
'GCA_001624775.1_PWK_PhJ_v1' => 'mus_musculus_pwkphj_core_104_1',
'GCA_001624835.1_WSB_EiJ_v1' => 'mus_musculus_wsbeij_core_104_1',
'GCA_900095145.2_PAHARI_EIJ_v1.1' => 'mus_pahari_core_104_11',
'GCF_900095145.1_PAHARI_EIJ_v1.1' => 'mus_pahari_core_104_11',
'GCA_003336285.1_MUSP714' => 'mus_spicilegus_core_104_714',
'GCA_001624865.1_SPRET_EiJ_v1' => 'mus_spretus_core_104_1',
'GCA_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo_core_104_1',
'GCF_000215625.1_MusPutFur1.0' => 'mustela_putorius_furo_core_104_1',
'musFur1' => 'mustela_putorius_furo_core_104_1',
'GCA_000147115.1_Myoluc2.0' => 'myotis_lucifugus_core_104_2',
'GCF_000147115.1_Myoluc2.0' => 'myotis_lucifugus_core_104_2',
'myoLuc2' => 'myotis_lucifugus_core_104_2',
'GCA_902150065.1_fMyrMur1.1' => 'myripristis_murdjan_core_104_11',
'GCF_902150065.1_fMyrMur1.1' => 'myripristis_murdjan_core_104_11',
'GCA_009733165.1_Nana_v5' => 'naja_naja_core_104_5',
'GCA_000622305.1_S.galili_v1.0' => 'nannospalax_galili_core_104_10',
'GCF_000622305.1_S.galili_v1.0' => 'nannospalax_galili_core_104_10',
'nanGal1' => 'nannospalax_galili_core_104_10',
'GCA_007210695.1_RGoby_Basel_V2' => 'neogobius_melanostomus_core_104_2',
'GCA_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi_core_104_1',
'GCF_000239395.1_NeoBri1.0' => 'neolamprologus_brichardi_core_104_1',
'neoBri1' => 'neolamprologus_brichardi_core_104_1',
'GCA_900108605.1_NNQGG.v01' => 'neovison_vison_core_104_1',
'GCA_000146795.3_Nleu_3.0' => 'nomascus_leucogenys_core_104_3',
'nomLeu3' => 'nomascus_leucogenys_core_104_3',
'GCA_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus_core_104_2',
'GCF_900518725.1_TS10Xv2-PRI' => 'notechis_scutatus_core_104_2',
'GCA_001465895.2_Nfu_20140520' => 'nothobranchius_furzeri_core_104_2',
'GCF_001465895.1_Nfu_20140520' => 'nothobranchius_furzeri_core_104_2',
'GCA_003342845.1_notPer1' => 'nothoprocta_perdicaria_core_104_1',
'GCF_003342845.1_notPer1' => 'nothoprocta_perdicaria_core_104_1',
'GCA_002078875.2_NumMel1.0' => 'numida_meleagris_core_104_1',
'GCF_002078875.1_NumMel1.0' => 'numida_meleagris_core_104_1',
'GCA_000260255.1_OctDeg1.0' => 'octodon_degus_core_104_1',
'GCF_000260255.1_OctDeg1.0' => 'octodon_degus_core_104_1',
'octDeg1' => 'octodon_degus_core_104_1',
'GCA_002021735.2_Okis_V2' => 'oncorhynchus_kisutch_core_104_2',
'GCF_002021735.2_Okis_V2' => 'oncorhynchus_kisutch_core_104_2',
'GCA_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss_core_104_1',
'GCF_002163495.1_Omyk_1.0' => 'oncorhynchus_mykiss_core_104_1',
'GCA_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha_core_104_1',
'GCF_002872995.1_Otsh_v1.0' => 'oncorhynchus_tshawytscha_core_104_1',
'GCA_005870065.1_ASM587006v1' => 'oreochromis_aureus_core_104_1',
'GCF_005870065.1_ASM587006v1' => 'oreochromis_aureus_core_104_1',
'GCA_001858045.3_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus_core_104_3',
'GCF_001858045.2_O_niloticus_UMD_NMBU' => 'oreochromis_niloticus_core_104_3',
'GCA_004115215.2_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus_core_104_1',
'GCF_004115215.1_mOrnAna1.p.v1' => 'ornithorhynchus_anatinus_core_104_1',
'GCA_000003625.1_OryCun2.0' => 'oryctolagus_cuniculus_core_104_2',
'GCF_000003625.3_OryCun2.0' => 'oryctolagus_cuniculus_core_104_2',
'oryCun2' => 'oryctolagus_cuniculus_core_104_2',
'GCA_003999625.1_OJAV_1.1' => 'oryzias_javanicus_core_104_11',
'GCA_002234675.1_ASM223467v1' => 'oryzias_latipes_core_104_1',
'GCF_002234675.1_ASM223467v1' => 'oryzias_latipes_core_104_1',
'GCA_002234715.1_ASM223471v1' => 'oryzias_latipes_hni_core_104_1',
'GCA_002234695.1_ASM223469v1' => 'oryzias_latipes_hsok_core_104_1',
'GCA_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma_core_104_07',
'GCF_002922805.1_Om_v0.7.RACA' => 'oryzias_melastigma_core_104_07',
'GCA_008586565.1_ASM858656v1' => 'oryzias_sinensis_core_104_1',
'GCA_000181295.3_OtoGar3' => 'otolemur_garnettii_core_104_3',
'GCF_000181295.1_OtoGar3' => 'otolemur_garnettii_core_104_3',
'otoGar3' => 'otolemur_garnettii_core_104_3',
'GCA_010365825.1_OtuSun1.0' => 'otus_sunia_core_104_1',
'GCA_000298735.1_Oar_v3.1' => 'ovis_aries_core_104_31',
'oviAri3' => 'ovis_aries_core_104_31',
'GCA_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet_core_104_1',
'GCF_002742125.1_Oar_rambouillet_v1.0' => 'ovis_aries_rambouillet_core_104_1',
'GCA_000258655.2_panpan1.1' => 'pan_paniscus_core_104_1',
'GCF_000258655.2_panpan1.1' => 'pan_paniscus_core_104_1',
'panPan2' => 'pan_paniscus_core_104_1',
'GCA_000001515.5_Pan_tro_3.0' => 'pan_troglodytes_core_104_3',
'panTro5' => 'pan_troglodytes_core_104_3',
'GCA_008795835.1_PanLeo1.0' => 'panthera_leo_core_104_1',
'GCA_001857705.1_PanPar1.0' => 'panthera_pardus_core_104_1',
'GCF_001857705.1_PanPar1.0' => 'panthera_pardus_core_104_1',
'GCA_000464555.1_PanTig1.0' => 'panthera_tigris_altaica_core_104_1',
'GCF_000464555.1_PanTig1.0' => 'panthera_tigris_altaica_core_104_1',
'panTig1' => 'panthera_tigris_altaica_core_104_1',
'GCA_000264685.2_Panu_3.0' => 'papio_anubis_core_104_3',
'GCF_000264685.3_Panu_3.0' => 'papio_anubis_core_104_3',
'papAnu4' => 'papio_anubis_core_104_3',
'GCA_900634625.1_fParRan2.1' => 'parambassis_ranga_core_104_21',
'GCF_900634625.1_fParRan2.1' => 'parambassis_ranga_core_104_21',
'GCA_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae_core_104_1',
'GCF_002872115.1_PKINGS_0.1' => 'paramormyrops_kingsleyae_core_104_1',
'GCA_001522545.2_Parus_major1.1' => 'parus_major_core_104_1',
'GCF_001522545.3_Parus_major1.1' => 'parus_major_core_104_1',
'GCA_005519975.1_AIIM_Pcri_1.0' => 'pavo_cristatus_core_104_1',
'GCA_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis_core_104_1',
'GCF_000230535.1_PelSin_1.0' => 'pelodiscus_sinensis_core_104_1',
'pelSin1' => 'pelodiscus_sinensis_core_104_1',
'GCA_007922175.1_Pelusios_castaneus-1.0' => 'pelusios_castaneus_core_104_1',
'GCA_000787105.1_PM.fa' => 'periophthalmus_magnuspinnatus_core_104_1',
'GCA_003704035.1_HU_Pman_2.1' => 'peromyscus_maniculatus_bairdii_core_104_21',
'GCA_000148955.1_Petromyzon_marinus-7.0' => 'petromyzon_marinus_core_104_7',
'petMar2' => 'petromyzon_marinus_core_104_7',
'GCA_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus_core_104_41',
'GCF_002099425.1_phaCin_unsw_v4.1' => 'phascolarctos_cinereus_core_104_41',
'GCA_004143745.1_ASM414374v1' => 'phasianus_colchicus_core_104_1',
'GCF_004143745.1_ASM414374v1' => 'phasianus_colchicus_core_104_1',
'GCA_008692025.1_mPhoSin1.pri' => 'phocoena_sinus_core_104_1',
'GCF_008692025.1_mPhoSin1.pri' => 'phocoena_sinus_core_104_1',
'GCA_002837175.2_ASM283717v2' => 'physeter_catodon_core_104_2',
'GCF_002837175.2_ASM283717v2' => 'physeter_catodon_core_104_2',
'GCA_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles_core_104_2',
'GCF_002776525.2_ASM277652v2' => 'piliocolobus_tephrosceles_core_104_2',
'GCA_004329235.1_PodMur_1.0' => 'podarcis_muralis_core_104_1',
'GCF_004329235.1_PodMur_1.0' => 'podarcis_muralis_core_104_1',
'GCA_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa_core_104_512',
'GCF_000485575.1_Poecilia_formosa-5.1.2' => 'poecilia_formosa_core_104_512',
'poeFor1' => 'poecilia_formosa_core_104_512',
'GCA_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna_core_104_1',
'GCF_001443285.1_P_latipinna-1.0' => 'poecilia_latipinna_core_104_1',
'GCA_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana_core_104_1',
'GCF_001443325.1_P_mexicana-1.0' => 'poecilia_mexicana_core_104_1',
'GCA_000633615.2_Guppy_female_1.0_MT' => 'poecilia_reticulata_core_104_1',
'GCF_000633615.1_Guppy_female_1.0_MT' => 'poecilia_reticulata_core_104_1',
'poeRet1' => 'poecilia_reticulata_core_104_1',
'GCA_900067755.1_pvi1.1' => 'pogona_vitticeps_core_104_11',
'ponAbe2' => 'pongo_abelii_core_104_1',
'GCA_003258685.1_Prosim_1.0' => 'prolemur_simus_core_104_1',
'GCA_000956105.1_Pcoq_1.0' => 'propithecus_coquereli_core_104_1',
'GCF_000956105.1_Pcoq_1.0' => 'propithecus_coquereli_core_104_1',
'proCoq1' => 'propithecus_coquereli_core_104_1',
'GCA_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis_core_104_2',
'GCF_900518735.1_EBS10Xv2-PRI' => 'pseudonaja_textilis_core_104_2',
'GCA_000239375.1_PunNye1.0' => 'pundamilia_nyererei_core_104_1',
'GCF_000239375.1_PunNye1.0' => 'pundamilia_nyererei_core_104_1',
'punNye1' => 'pundamilia_nyererei_core_104_1',
'GCA_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri_core_104_102',
'GCF_001682695.1_Pygocentrus_nattereri-1.0.2' => 'pygocentrus_nattereri_core_104_102',
'GCA_000001895.4_Rnor_6.0' => 'rattus_norvegicus_core_104_6',
'GCF_000001895.5_Rnor_6.0' => 'rattus_norvegicus_core_104_6',
'rn6' => 'rattus_norvegicus_core_104_6',
'GCA_004115265.2_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum_core_104_1',
'GCF_004115265.1_mRhiFer1_v1.p' => 'rhinolophus_ferrumequinum_core_104_1',
'GCA_001698545.1_ASM169854v1' => 'rhinopithecus_bieti_core_104_1',
'GCF_001698545.1_ASM169854v1' => 'rhinopithecus_bieti_core_104_1',
'rhiBie1' => 'rhinopithecus_bieti_core_104_1',
'GCA_000769185.1_Rrox_v1' => 'rhinopithecus_roxellana_core_104_1',
'rhiRox1' => 'rhinopithecus_roxellana_core_104_1',
'GCA_000146045.2_R64-1-1' => 'saccharomyces_cerevisiae_core_104_4',
'GCF_000146045.2_R64' => 'saccharomyces_cerevisiae_core_104_4',
'sacCer3' => 'saccharomyces_cerevisiae_core_104_4',
'GCA_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis_core_104_1',
'GCF_000235385.1_SaiBol1.0' => 'saimiri_boliviensis_boliviensis_core_104_1',
'saiBol1' => 'saimiri_boliviensis_boliviensis_core_104_1',
'GCA_902148845.1_fSalaFa1.1' => 'salarias_fasciatus_core_104_11',
'GCF_902148845.1_fSalaFa1.1' => 'salarias_fasciatus_core_104_11',
'GCA_000233375.4_ICSASG_v2' => 'salmo_salar_core_104_2',
'GCA_901001165.1_fSalTru1.1' => 'salmo_trutta_core_104_11',
'GCF_901001165.1_fSalTru1.1' => 'salmo_trutta_core_104_11',
'GCA_003586115.1_HLtupMer3' => 'salvator_merianae_core_104_3',
'GCA_008315115.1_SLUC_FBN_1' => 'sander_lucioperca_core_104_1',
'GCF_008315115.1_SLUC_FBN_1' => 'sander_lucioperca_core_104_1',
'GCA_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii_core_104_1',
'GCF_902635505.1_mSarHar1.11' => 'sarcophilus_harrisii_core_104_1',
'GCA_902686455.1_mSciVul1.1' => 'sciurus_vulgaris_core_104_1',
'GCA_900964775.1_fSclFor1.1' => 'scleropages_formosus_core_104_11',
'GCF_900964775.1_fSclFor1.1' => 'scleropages_formosus_core_104_11',
'GCA_003186165.1_ASM318616v1' => 'scophthalmus_maximus_core_104_1',
'GCF_013347765.1_ASM1334776v1' => 'scophthalmus_maximus_core_104_1',
'GCA_000534875.1_SCA1' => 'serinus_canaria_core_104_12',
'serCan1' => 'serinus_canaria_core_104_12',
'GCA_002260705.1_Sdu_1.0' => 'seriola_dumerili_core_104_1',
'GCF_002260705.1_Sdu_1.0' => 'seriola_dumerili_core_104_1',
'GCA_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis_core_104_1',
'GCF_002814215.1_Sedor1' => 'seriola_lalandi_dorsalis_core_104_1',
'GCA_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis_core_104_11',
'GCF_001515605.1_SAMN03320099.WGS_v1.1' => 'sinocyclocheilus_anshuiensis_core_104_11',
'GCA_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami_core_104_11',
'GCF_001515645.1_SAMN03320097.WGS_v1.1' => 'sinocyclocheilus_grahami_core_104_11',
'GCA_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous_core_104_11',
'GCF_001515625.1_SAMN03320098_v1.1' => 'sinocyclocheilus_rhinocerous_core_104_11',
'GCA_900880675.1_fSpaAur1.1' => 'sparus_aurata_core_104_11',
'GCF_900880675.1_fSpaAur1.1' => 'sparus_aurata_core_104_11',
'GCA_002406435.1_ASM240643v1' => 'spermophilus_dauricus_core_104_1',
'GCA_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis_core_104_11',
'GCF_902148855.1_fSphaOr1.1' => 'sphaeramia_orbicularis_core_104_11',
'GCA_003113815.1_ASM311381v1' => 'sphenodon_punctatus_core_104_1',
'GCA_008694505.1_ASM869450v1' => 'stachyris_ruficeps_core_104_1',
'GCA_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus_core_104_1',
'GCF_000690725.1_Stegastes_partitus-1.0.2' => 'stegastes_partitus_core_104_1',
'stePar1' => 'stegastes_partitus_core_104_1',
'GCA_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila_core_104_11',
'GCF_004027225.1_bStrHab1_v1.p' => 'strigops_habroptila_core_104_11',
'GCA_002372975.1_Soccid_v01' => 'strix_occidentalis_caurina_core_104_1',
'GCA_000698965.1_ASM69896v1' => 'struthio_camelus_australis_core_104_1',
'GCF_000698965.1_ASM69896v1' => 'struthio_camelus_australis_core_104_1',
'strCam1' => 'struthio_camelus_australis_core_104_1',
'GCA_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta_core_104_1',
'GCF_006229205.1_meerkat_22Aug2017_6uvM2_HiC' => 'suricata_suricatta_core_104_1',
'GCA_000003025.6_Sscrofa11.1' => 'sus_scrofa_core_104_111',
'GCF_000003025.6_Sscrofa11.1' => 'sus_scrofa_core_104_111',
'susScr11' => 'sus_scrofa_core_104_111',
'GCA_001700235.1_Bamei_pig_v1' => 'sus_scrofa_bamei_core_104_1',
'GCA_001700575.1_Berkshire_pig_v1' => 'sus_scrofa_berkshire_core_104_1',
'GCA_001700165.1_Hampshire_pig_v1' => 'sus_scrofa_hampshire_core_104_1',
'GCA_001700295.1_Jinhua_pig_v1' => 'sus_scrofa_jinhua_core_104_1',
'GCA_001700215.1_Landrace_pig_v1' => 'sus_scrofa_landrace_core_104_1',
'GCA_001700135.1_Large_White_v1' => 'sus_scrofa_largewhite_core_104_1',
'GCA_001700195.1_Meishan_pig_v1' => 'sus_scrofa_meishan_core_104_1',
'GCA_001700255.1_Pietrain_pig_v1' => 'sus_scrofa_pietrain_core_104_1',
'GCA_001700155.1_Rongchang_pig_v1' => 'sus_scrofa_rongchang_core_104_1',
'GCA_000472085.2_Tibetan_Pig_v2' => 'sus_scrofa_tibetan_core_104_2',
'GCA_002844635.1_USMARCv1.0' => 'sus_scrofa_usmarc_core_104_1',
'GCA_000325925.2_minipig_v1.0' => 'sus_scrofa_wuzhishan_core_104_10',
'GCA_003957565.2_bTaeGut1_v1.p' => 'taeniopygia_guttata_core_104_12',
'GCF_003957565.1_bTaeGut1_v1.p' => 'taeniopygia_guttata_core_104_12',
'GCA_901000725.2_fTakRub1.2' => 'takifugu_rubripes_core_104_12',
'GCF_901000725.2_fTakRub1.2' => 'takifugu_rubripes_core_104_12',
'GCA_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis_core_104_2',
'GCF_002925995.2_T_m_triunguis-2.0' => 'terrapene_carolina_triunguis_core_104_2',
'tetNig2' => 'tetraodon_nigroviridis_core_104_8',
'GCA_003255815.1_Tgel_1.0' => 'theropithecus_gelada_core_104_1',
'GCF_003255815.1_Tgel_1.0' => 'theropithecus_gelada_core_104_1',
'GCA_003426925.1_ASM342692v1' => 'urocitellus_parryii_core_104_1',
'GCF_003426925.1_ASM342692v1' => 'urocitellus_parryii_core_104_1',
'GCA_003344425.1_ASM334442v1' => 'ursus_americanus_core_104_1',
'GCA_000687225.1_UrsMar_1.0' => 'ursus_maritimus_core_104_1',
'GCF_000687225.1_UrsMar_1.0' => 'ursus_maritimus_core_104_1',
'ursMar1' => 'ursus_maritimus_core_104_1',
'GCA_009660055.1_ASM966005v1' => 'ursus_thibetanus_thibetanus_core_104_1',
'GCA_004798865.1_ASM479886v1' => 'varanus_komodoensis_core_104_1',
'GCA_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus_core_104_1',
'GCF_900497805.2_bare-nosed_wombat_genome_assembly' => 'vombatus_ursinus_core_104_1',
'GCA_003160815.1_VulVul2.2' => 'vulpes_vulpes_core_104_22',
'GCF_003160815.1_VulVul2.2' => 'vulpes_vulpes_core_104_22',
'GCA_000004195.3_Xenopus_tropicalis_v9.1' => 'xenopus_tropicalis_core_104_91',
'xenTro9' => 'xenopus_tropicalis_core_104_91',
'GCA_001444195.1_Xiphophorus_couchianus-4.0.1' => 'xiphophorus_couchianus_core_104_401',
'GCA_002775205.2_X_maculatus-5.0-male' => 'xiphophorus_maculatus_core_104_5',
'GCF_002775205.1_X_maculatus-5.0-male' => 'xiphophorus_maculatus_core_104_5',
'GCA_009762305.1_mZalCal1.pri' => 'zalophus_californianus_core_104_1',
'GCA_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis_core_104_101',
'GCF_000385455.1_Zonotrichia_albicollis-1.0.1' => 'zonotrichia_albicollis_core_104_101',
'zonAlb1' => 'zonotrichia_albicollis_core_104_101',
'GCA_001281735.1_ASM128173v1' => 'zosterops_lateralis_melanops_core_104_1',
);

my @versionList = qw( 104 103 101 99 95 92 91 90 89 86 85 83 81 79 78 76 75 74 73 72 71 70 69 68 67 65 64 63 62 61 60 59 58 57 56 55 54 52 51 50 49 48 47 46 35 );

my @ensGtfReference;
$ensGtfReference[104] = \%ensGeneGtfFileNames_104;
$ensGtfReference[103] = \%ensGeneGtfFileNames_103;
$ensGtfReference[101] = \%ensGeneGtfFileNames_101;
$ensGtfReference[99] = \%ensGeneGtfFileNames_99;
$ensGtfReference[95] = \%ensGeneGtfFileNames_95;
$ensGtfReference[92] = \%ensGeneGtfFileNames_92;
$ensGtfReference[91] = \%ensGeneGtfFileNames_91;
$ensGtfReference[90] = \%ensGeneGtfFileNames_90;
$ensGtfReference[89] = \%ensGeneGtfFileNames_89;
$ensGtfReference[86] = \%ensGeneGtfFileNames_86;
$ensGtfReference[85] = \%ensGeneGtfFileNames_85;
$ensGtfReference[83] = \%ensGeneGtfFileNames_83;
$ensGtfReference[81] = \%ensGeneGtfFileNames_81;
$ensGtfReference[79] = \%ensGeneGtfFileNames_79;
$ensGtfReference[78] = \%ensGeneGtfFileNames_78;
$ensGtfReference[76] = \%ensGeneGtfFileNames_76;
$ensGtfReference[75] = \%ensGeneGtfFileNames_75;
$ensGtfReference[74] = \%ensGeneGtfFileNames_74;
$ensGtfReference[73] = \%ensGeneGtfFileNames_73;
$ensGtfReference[72] = \%ensGeneGtfFileNames_72;
$ensGtfReference[71] = \%ensGeneGtfFileNames_71;
$ensGtfReference[70] = \%ensGeneGtfFileNames_70;
$ensGtfReference[69] = \%ensGeneGtfFileNames_69;
$ensGtfReference[68] = \%ensGeneGtfFileNames_68;
$ensGtfReference[67] = \%ensGeneGtfFileNames_67;
$ensGtfReference[65] = \%ensGeneGtfFileNames_65;
$ensGtfReference[64] = \%ensGeneGtfFileNames_64;
$ensGtfReference[63] = \%ensGeneGtfFileNames_63;
$ensGtfReference[62] = \%ensGeneGtfFileNames_62;
$ensGtfReference[61] = \%ensGeneGtfFileNames_61;
$ensGtfReference[60] = \%ensGeneGtfFileNames_60;
$ensGtfReference[59] = \%ensGeneGtfFileNames_59;
$ensGtfReference[58] = \%ensGeneGtfFileNames_58;
$ensGtfReference[57] = \%ensGeneGtfFileNames_57;
$ensGtfReference[56] = \%ensGeneGtfFileNames_56;
$ensGtfReference[55] = \%ensGeneGtfFileNames_55;
$ensGtfReference[54] = \%ensGeneGtfFileNames_54;
$ensGtfReference[52] = \%ensGeneGtfFileNames_52;
$ensGtfReference[51] = \%ensGeneGtfFileNames_51;
$ensGtfReference[50] = \%ensGeneGtfFileNames_50;
$ensGtfReference[49] = \%ensGeneGtfFileNames_49;
$ensGtfReference[48] = \%ensGeneGtfFileNames_48;
$ensGtfReference[47] = \%ensGeneGtfFileNames_47;
$ensGtfReference[46] = \%ensGeneGtfFileNames_46;
$ensGtfReference[35] = \%ensGeneGtfFileNames_35;
my @ensPepReference;
$ensPepReference[104] = \%ensGeneFtpPeptideFileNames_104;
$ensPepReference[103] = \%ensGeneFtpPeptideFileNames_103;
$ensPepReference[101] = \%ensGeneFtpPeptideFileNames_101;
$ensPepReference[99] = \%ensGeneFtpPeptideFileNames_99;
$ensPepReference[95] = \%ensGeneFtpPeptideFileNames_95;
$ensPepReference[92] = \%ensGeneFtpPeptideFileNames_92;
$ensPepReference[91] = \%ensGeneFtpPeptideFileNames_91;
$ensPepReference[90] = \%ensGeneFtpPeptideFileNames_90;
$ensPepReference[89] = \%ensGeneFtpPeptideFileNames_89;
$ensPepReference[86] = \%ensGeneFtpPeptideFileNames_86;
$ensPepReference[85] = \%ensGeneFtpPeptideFileNames_85;
$ensPepReference[83] = \%ensGeneFtpPeptideFileNames_83;
$ensPepReference[81] = \%ensGeneFtpPeptideFileNames_81;
$ensPepReference[79] = \%ensGeneFtpPeptideFileNames_79;
$ensPepReference[78] = \%ensGeneFtpPeptideFileNames_78;
$ensPepReference[76] = \%ensGeneFtpPeptideFileNames_76;
$ensPepReference[75] = \%ensGeneFtpPeptideFileNames_75;
$ensPepReference[74] = \%ensGeneFtpPeptideFileNames_74;
$ensPepReference[73] = \%ensGeneFtpPeptideFileNames_73;
$ensPepReference[72] = \%ensGeneFtpPeptideFileNames_72;
$ensPepReference[71] = \%ensGeneFtpPeptideFileNames_71;
$ensPepReference[70] = \%ensGeneFtpPeptideFileNames_70;
$ensPepReference[69] = \%ensGeneFtpPeptideFileNames_69;
$ensPepReference[68] = \%ensGeneFtpPeptideFileNames_68;
$ensPepReference[67] = \%ensGeneFtpPeptideFileNames_67;
$ensPepReference[65] = \%ensGeneFtpPeptideFileNames_65;
$ensPepReference[64] = \%ensGeneFtpPeptideFileNames_64;
$ensPepReference[63] = \%ensGeneFtpPeptideFileNames_63;
$ensPepReference[62] = \%ensGeneFtpPeptideFileNames_62;
$ensPepReference[61] = \%ensGeneFtpPeptideFileNames_61;
$ensPepReference[60] = \%ensGeneFtpPeptideFileNames_60;
$ensPepReference[59] = \%ensGeneFtpPeptideFileNames_59;
$ensPepReference[58] = \%ensGeneFtpPeptideFileNames_58;
$ensPepReference[57] = \%ensGeneFtpPeptideFileNames_57;
$ensPepReference[56] = \%ensGeneFtpPeptideFileNames_56;
$ensPepReference[55] = \%ensGeneFtpPeptideFileNames_55;
$ensPepReference[54] = \%ensGeneFtpPeptideFileNames_54;
$ensPepReference[52] = \%ensGeneFtpPeptideFileNames_52;
$ensPepReference[51] = \%ensGeneFtpPeptideFileNames_51;
$ensPepReference[50] = \%ensGeneFtpPeptideFileNames_50;
$ensPepReference[49] = \%ensGeneFtpPeptideFileNames_49;
$ensPepReference[48] = \%ensGeneFtpPeptideFileNames_48;
$ensPepReference[47] = \%ensGeneFtpPeptideFileNames_47;
$ensPepReference[46] = \%ensGeneFtpPeptideFileNames_46;
$ensPepReference[35] = \%ensGeneFtpPeptideFileNames_35;
my @ensMySqlReference;
$ensMySqlReference[104] = \%ensGeneFtpMySqlFileNames_104;
$ensMySqlReference[103] = \%ensGeneFtpMySqlFileNames_103;
$ensMySqlReference[101] = \%ensGeneFtpMySqlFileNames_101;
$ensMySqlReference[99] = \%ensGeneFtpMySqlFileNames_99;
$ensMySqlReference[95] = \%ensGeneFtpMySqlFileNames_95;
$ensMySqlReference[92] = \%ensGeneFtpMySqlFileNames_92;
$ensMySqlReference[91] = \%ensGeneFtpMySqlFileNames_91;
$ensMySqlReference[90] = \%ensGeneFtpMySqlFileNames_90;
$ensMySqlReference[89] = \%ensGeneFtpMySqlFileNames_89;
$ensMySqlReference[86] = \%ensGeneFtpMySqlFileNames_86;
$ensMySqlReference[85] = \%ensGeneFtpMySqlFileNames_85;
$ensMySqlReference[83] = \%ensGeneFtpMySqlFileNames_83;
$ensMySqlReference[81] = \%ensGeneFtpMySqlFileNames_81;
$ensMySqlReference[79] = \%ensGeneFtpMySqlFileNames_79;
$ensMySqlReference[78] = \%ensGeneFtpMySqlFileNames_78;
$ensMySqlReference[76] = \%ensGeneFtpMySqlFileNames_76;
$ensMySqlReference[75] = \%ensGeneFtpMySqlFileNames_75;
$ensMySqlReference[74] = \%ensGeneFtpMySqlFileNames_74;
$ensMySqlReference[73] = \%ensGeneFtpMySqlFileNames_73;
$ensMySqlReference[72] = \%ensGeneFtpMySqlFileNames_72;
$ensMySqlReference[71] = \%ensGeneFtpMySqlFileNames_71;
$ensMySqlReference[70] = \%ensGeneFtpMySqlFileNames_70;
$ensMySqlReference[69] = \%ensGeneFtpMySqlFileNames_69;
$ensMySqlReference[68] = \%ensGeneFtpMySqlFileNames_68;
$ensMySqlReference[67] = \%ensGeneFtpMySqlFileNames_67;
$ensMySqlReference[65] = \%ensGeneFtpMySqlFileNames_65;
$ensMySqlReference[64] = \%ensGeneFtpMySqlFileNames_64;
$ensMySqlReference[63] = \%ensGeneFtpMySqlFileNames_63;
$ensMySqlReference[62] = \%ensGeneFtpMySqlFileNames_62;
$ensMySqlReference[61] = \%ensGeneFtpMySqlFileNames_61;
$ensMySqlReference[60] = \%ensGeneFtpMySqlFileNames_60;
$ensMySqlReference[59] = \%ensGeneFtpMySqlFileNames_59;
$ensMySqlReference[58] = \%ensGeneFtpMySqlFileNames_58;
$ensMySqlReference[57] = \%ensGeneFtpMySqlFileNames_57;
$ensMySqlReference[56] = \%ensGeneFtpMySqlFileNames_56;
$ensMySqlReference[55] = \%ensGeneFtpMySqlFileNames_55;
$ensMySqlReference[54] = \%ensGeneFtpMySqlFileNames_54;
$ensMySqlReference[52] = \%ensGeneFtpMySqlFileNames_52;
$ensMySqlReference[51] = \%ensGeneFtpMySqlFileNames_51;
$ensMySqlReference[50] = \%ensGeneFtpMySqlFileNames_50;
$ensMySqlReference[49] = \%ensGeneFtpMySqlFileNames_49;
$ensMySqlReference[48] = \%ensGeneFtpMySqlFileNames_48;
$ensMySqlReference[47] = \%ensGeneFtpMySqlFileNames_47;
$ensMySqlReference[46] = \%ensGeneFtpMySqlFileNames_46;
$ensMySqlReference[35] = \%ensGeneFtpMySqlFileNames_35;

sub ensVersionList() {
   return @versionList;
}

sub ensGeneVersioning($$) {
#  given a UCSC db name, and an Ensembl version number, return
#	FTP gtf file name, peptide file name, MySql core directory
#	and archive version string
  my ($ucscDb, $ensVersion) = @_;
printf STDERR "# DBG ensGeneVersioning: checking '%s' '%s'\n", $ucscDb, $ensVersion;
  if (defined($ensGtfReference[$ensVersion]) &&
	defined($ensPepReference[$ensVersion])) {
    my $gtfReference = $ensGtfReference[$ensVersion];
    my $pepReference = $ensPepReference[$ensVersion];
    my $mySqlReference = $ensMySqlReference[$ensVersion];
    my $gtfDir = "release-$ensVersion/gtf/";
    my $pepDir = "release-$ensVersion/fasta/";
    my $mySqlDir = "release-$ensVersion/mysql/";
    if ($ensVersion < 47) {
	$gtfDir = "release-$ensVersion/";
	$pepDir = "release-$ensVersion/";
	$mySqlDir = "release-$ensVersion/";
    }
    if (! exists($gtfReference->{$ucscDb}) ) {
printf STDERR "# DBG ensGeneVersioning: can not find gtfReference: '%s' '%s'\n", $ucscDb, $ensVersion;
}
    if (! exists($pepReference->{$ucscDb}) ) {
printf STDERR "# DBG ensGeneVersioning: can not find pepReference: '%s' '%s'\n", $ucscDb, $ensVersion;
}
    if (! exists($mySqlReference->{$ucscDb}) ) {
printf STDERR "# DBG ensGeneVersioning: can not find mySqlReference: '%s' '%s'\n", $ucscDb, $ensVersion;
}
    if (exists($gtfReference->{$ucscDb}) &&
	exists($pepReference->{$ucscDb}) &&
	exists($mySqlReference->{$ucscDb}) ) {
	my $gtfName =  $ensemblFTP . $gtfDir . $gtfReference->{$ucscDb};
	my $pepName =  $ensemblFTP . $pepDir . $pepReference->{$ucscDb};
	my $mySqlName =  $ensemblFTP . $mySqlDir . $mySqlReference->{$ucscDb};
	return ($gtfName, $pepName, $mySqlName, $verToDate[$ensVersion]);
    }
  } else {
printf STDERR "# DBG ensGeneVersioning: not working: '%s' '%s'\n", $ucscDb, $ensVersion;
  }
  return (undef, undef, undef);
}
