#!/bin/bash

# *** Do not edit this file outside of the source tree. ***
# This file is from source tree:
#     kent/src/hg/utils/otto/genArk/updatgeHgcentral.sh
# called by otto cron job in /hive/data/inside/GenArk/
# and using the helper script:
#     kent/src/hg/utils/otto/genArk/genArkListToSql.pl

# exit on any error
set -beEu -o pipefail

function usage() {
  printf "usage: ./updateCentral.sh makeItSo\n" 1>&2
  printf "updates hgcentraltest.genark with the latest hub list from hgdownload\n" 1>&2
  printf "and the hgcentraltest.assemblyList table from NCBI listings.\n" 1>&2
}

# check for an 'unbound' variable safely
if [ -z "${1+x}" ]; then
  usage
  exit 255
fi
# something is in $1, verify is is 'makeItSo'
if [ "xxx$1" != "xxxmakeItSo" ]; then
  usage
  exit 255
fi

cd /hive/data/inside/GenArk
export DS=`date "+%F"`
export YYYY=`date "+%Y"`
export LC_NUMERIC=en_US
export msgTo="hclawson@ucsc.edu,otto-group@ucsc.edu"
export msgFile="/tmp/ottoGenArk.$$.txt"

###########################################################################
### helper functions
###########################################################################

function msgToFrom() {
  printf "To: %s\n" "${msgTo}" > ${msgFile}
  printf "From: hiram@soe.ucsc.edu\n" >> ${msgFile}
}

function sendMsg() {
  cat $msgFile | /usr/sbin/sendmail -t -oi
  rm -f $msgFile
}

function oddRowCounts() {
  todayCount=$1
  mysqlCount=$2
  msgToFrom
  printf "Subject: ALERT: hgcentraltest.genark update problem\n" >> ${msgFile}
  printf "\n" >> ${msgFile}
  printf "# puzzling, count in file %'d is not larger than the MySQL table %'d\n" "${todayCount}" "${mysqlCount}" >> ${msgFile}
  sendMsg
}

function updateIncorrect() {
  todayCount=$1
  mysqlCount=$2
  msgToFrom
  printf "Subject: ALERT: hgcentraltest.genark update problem\n" >> ${msgFile}
  printf "\n" >> ${msgFile}
  printf "# ERROR: hgcentraltest.genark table has been reloaded, but row count %'d is not larger than than previous MySQL table %'d\n" "${todayCount}" "${mysqlCount}" >> ${msgFile}
  sendMsg
}

function updateOK() {
  todayCount=$1
  mysqlCount=$2
  msgToFrom
  printf "Subject: NOTE: hgcentraltest.genark has been updated\n" >> ${msgFile}
  printf "\n" >> ${msgFile}
  printf "# this message is from the otto cron job:\n" >> "${msgFile}"
  printf "# 37 10 * * 2 /hive/data/inside/GenArk/updateHgcentral.sh makeItSo\n" >> "${msgFile}"
  printf "# today MySQL rowCount %'d vs. previous MySQL rowCount %'d\n" "${todayCount}" "${mysqlCount}" >> ${msgFile}
  sendMsg
}

###########################################################################
### begin processing
###########################################################################

# everything depends on this file from hgdownload
rsync -a qateam@hgdownload:/mirrordata/hubs/UCSC_GI.assemblyHubList.txt ./list.${DS}

#  see if it became newer than previous
newSum=`grep -v "^#" list.${DS} | sort | md5sum | cut -d' ' -f1`
prevSum=`grep -v "^#" previousList.txt | sort | md5sum | cut -d' ' -f1`

if [ "${prevSum}" = "${newSum}" ]; then
  rm -f list.${DS}
  ### new assemblyList table in hgcentraltest 2024-08-08
  /hive/data/inside/GenArk/addAssemblyList.sh
  exit 0
fi

# save this new list in history
mkdir -p history/${YYYY}
cp -p list.${DS} history/${YYYY}
countToday=`grep -v "^#" list.${DS} | wc -l`
rowCount=`hgsql -N hgcentraltest -e 'select count(*) from genark;' | cat`

if [ "${countToday}" -gt "${rowCount}" ]; then

  ./genArkListToSql.pl list.${DS} > genark.tsv
  hgsql hgcentraltest -e 'drop table genark;'
  hgsql hgcentraltest < /hive/data/inside/GenArk/genark.sql
 hgsql hgcentraltest -e "LOAD DATA LOCAL INFILE 'genark.tsv' INTO TABLE genark;"
  newCount=`hgsql -N hgcentraltest -e 'select count(*) from genark;' | cat`
  if [ "${newCount}" -gt "${rowCount}" ]; then
    updateOK "${newCount}" "${rowCount}"
    rm -f previousList.txt
    mv list.${DS} previousList.txt
  else
    updateIncorrect "${newCount}" "${rowCount}"
    exit 255
  fi
else
  oddRowCounts "${countToday}" "${rowCount}"
  exit 255
fi

### new assemblyList table in hgcentraltest 2024-08-08
/hive/data/inside/GenArk/addAssemblyList.sh

exit $?
