/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Maps;
import com.google.jstestdriver.BrowserInfo;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResult {
    private String result;
    private String message;
    private String parsedMessage;
    private String stack;
    private String log;
    private String testCaseName;
    private String testName;
    private float time;
    private BrowserInfo browserInfo;
    private Map<String, String> data = Maps.newHashMap();

    public Map<String, String> getData() {
        return this.data;
    }

    public TestResult(BrowserInfo browser, String result, String message, String log, String testCaseName, String testName, float time) {
        this.browserInfo = browser;
        this.result = result;
        this.message = message;
        this.log = log;
        this.testCaseName = testCaseName;
        this.testName = testName;
        this.time = time;
    }

    public TestResult() {
    }

    public Result getResult() {
        return Result.valueOf(this.result);
    }

    public String getMessage() {
        return this.message;
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    public String getTestName() {
        return this.testName;
    }

    public float getTime() {
        return this.time;
    }

    public void setBrowserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
    }

    public void setParsedMessage(String parsedMessage) {
        this.parsedMessage = parsedMessage;
    }

    public void setStack(String stack) {
        this.stack = stack;
    }

    public String getParsedMessage() {
        return this.parsedMessage;
    }

    public String getStack() {
        return this.stack;
    }

    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    public String getLog() {
        return this.log;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.browserInfo == null ? 0 : this.browserInfo.hashCode());
        result = 31 * result + (this.log == null ? 0 : this.log.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.parsedMessage == null ? 0 : this.parsedMessage.hashCode());
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        result = 31 * result + (this.stack == null ? 0 : this.stack.hashCode());
        result = 31 * result + (this.testCaseName == null ? 0 : this.testCaseName.hashCode());
        result = 31 * result + (this.testName == null ? 0 : this.testName.hashCode());
        result = 31 * result + Float.floatToIntBits(this.time);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestResult other = (TestResult)obj;
        if (this.browserInfo == null ? other.browserInfo != null : !this.browserInfo.equals(other.browserInfo)) {
            return false;
        }
        if (this.log == null ? other.log != null : !this.log.equals(other.log)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.parsedMessage == null ? other.parsedMessage != null : !this.parsedMessage.equals(other.parsedMessage)) {
            return false;
        }
        if (this.result == null ? other.result != null : !this.result.equals(other.result)) {
            return false;
        }
        if (this.stack == null ? other.stack != null : !this.stack.equals(other.stack)) {
            return false;
        }
        if (this.testCaseName == null ? other.testCaseName != null : !this.testCaseName.equals(other.testCaseName)) {
            return false;
        }
        if (this.testName == null ? other.testName != null : !this.testName.equals(other.testName)) {
            return false;
        }
        return Float.floatToIntBits(this.time) == Float.floatToIntBits(other.time);
    }

    public String toString() {
        return String.format("%s: %s; %s; %s; %s; %s,; %s; %s", this.getClass().getSimpleName(), this.browserInfo, this.result, this.message, this.log, this.testCaseName, this.testName, Float.valueOf(this.time));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        passed,
        failed,
        error,
        started;

    }
}

