/* cnpSebat2.c was originally generated by the autoSql program, which also 
 * generated cnpSebat2.h and cnpSebat2.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cnpSebat2.h"


void cnpSebat2StaticLoad(char **row, struct cnpSebat2 *ret)
/* Load a row from cnpSebat2 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->probes = sqlUnsigned(row[4]);
}

struct cnpSebat2 *cnpSebat2Load(char **row)
/* Load a cnpSebat2 from row fetched with select * from cnpSebat2
 * from database.  Dispose of this with cnpSebat2Free(). */
{
struct cnpSebat2 *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->probes = sqlUnsigned(row[4]);
return ret;
}

struct cnpSebat2 *cnpSebat2LoadAll(char *fileName) 
/* Load all cnpSebat2 from a whitespace-separated file.
 * Dispose of this with cnpSebat2FreeList(). */
{
struct cnpSebat2 *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = cnpSebat2Load(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpSebat2 *cnpSebat2LoadAllByChar(char *fileName, char chopper) 
/* Load all cnpSebat2 from a chopper separated file.
 * Dispose of this with cnpSebat2FreeList(). */
{
struct cnpSebat2 *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cnpSebat2Load(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpSebat2 *cnpSebat2CommaIn(char **pS, struct cnpSebat2 *ret)
/* Create a cnpSebat2 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cnpSebat2 */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->probes = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void cnpSebat2Free(struct cnpSebat2 **pEl)
/* Free a single dynamically allocated cnpSebat2 such as created
 * with cnpSebat2Load(). */
{
struct cnpSebat2 *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void cnpSebat2FreeList(struct cnpSebat2 **pList)
/* Free a list of dynamically allocated cnpSebat2's */
{
struct cnpSebat2 *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cnpSebat2Free(&el);
    }
*pList = NULL;
}

void cnpSebat2Output(struct cnpSebat2 *el, FILE *f, char sep, char lastSep) 
/* Print out cnpSebat2.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->probes);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

