/* recombRateMouse.c was originally generated by the autoSql program, which also 
 * generated recombRateMouse.h and recombRateMouse.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "recombRateMouse.h"


void recombRateMouseStaticLoad(char **row, struct recombRateMouse *ret)
/* Load a row from recombRateMouse table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->wiAvg = atof(row[4]);
ret->mgdAvg = atof(row[5]);
}

struct recombRateMouse *recombRateMouseLoad(char **row)
/* Load a recombRateMouse from row fetched with select * from recombRateMouse
 * from database.  Dispose of this with recombRateMouseFree(). */
{
struct recombRateMouse *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->wiAvg = atof(row[4]);
ret->mgdAvg = atof(row[5]);
return ret;
}

struct recombRateMouse *recombRateMouseLoadAll(char *fileName) 
/* Load all recombRateMouse from a whitespace-separated file.
 * Dispose of this with recombRateMouseFreeList(). */
{
struct recombRateMouse *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = recombRateMouseLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct recombRateMouse *recombRateMouseLoadAllByChar(char *fileName, char chopper) 
/* Load all recombRateMouse from a chopper separated file.
 * Dispose of this with recombRateMouseFreeList(). */
{
struct recombRateMouse *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = recombRateMouseLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct recombRateMouse *recombRateMouseCommaIn(char **pS, struct recombRateMouse *ret)
/* Create a recombRateMouse out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new recombRateMouse */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->wiAvg = sqlFloatComma(&s);
ret->mgdAvg = sqlFloatComma(&s);
*pS = s;
return ret;
}

void recombRateMouseFree(struct recombRateMouse **pEl)
/* Free a single dynamically allocated recombRateMouse such as created
 * with recombRateMouseLoad(). */
{
struct recombRateMouse *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void recombRateMouseFreeList(struct recombRateMouse **pList)
/* Free a list of dynamically allocated recombRateMouse's */
{
struct recombRateMouse *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    recombRateMouseFree(&el);
    }
*pList = NULL;
}

void recombRateMouseOutput(struct recombRateMouse *el, FILE *f, char sep, char lastSep) 
/* Print out recombRateMouse.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->wiAvg);
fputc(sep,f);
fprintf(f, "%f", el->mgdAvg);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

