/* singleNucDiff.c was originally generated by the autoSql program, which also 
 * generated singleNucDiff.h and singleNucDiff.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "simpleNucDiff.h"


void simpleNucDiffStaticLoad(char **row, struct simpleNucDiff *ret)
/* Load a row from simpleNucDiff table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->tSeq = row[3];
ret->qSeq = row[4];
}

struct simpleNucDiff *simpleNucDiffLoad(char **row)
/* Load a simpleNucDiff from row fetched with select * from simpleNucDiff
 * from database.  Dispose of this with simpleNucDiffFree(). */
{
struct simpleNucDiff *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->tSeq = cloneString(row[3]);
ret->qSeq = cloneString(row[4]);
return ret;
}

struct simpleNucDiff *simpleNucDiffLoadAll(char *fileName) 
/* Load all simpleNucDiff from a whitespace-separated file.
 * Dispose of this with simpleNucDiffFreeList(). */
{
struct simpleNucDiff *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = simpleNucDiffLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct simpleNucDiff *simpleNucDiffLoadAllByChar(char *fileName, char chopper) 
/* Load all simpleNucDiff from a chopper separated file.
 * Dispose of this with simpleNucDiffFreeList(). */
{
struct simpleNucDiff *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = simpleNucDiffLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct simpleNucDiff *simpleNucDiffCommaIn(char **pS, struct simpleNucDiff *ret)
/* Create a simpleNucDiff out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new simpleNucDiff */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->tSeq = sqlStringComma(&s);
ret->qSeq = sqlStringComma(&s);
*pS = s;
return ret;
}

void simpleNucDiffFree(struct simpleNucDiff **pEl)
/* Free a single dynamically allocated simpleNucDiff such as created
 * with simpleNucDiffLoad(). */
{
struct simpleNucDiff *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->tSeq);
freeMem(el->qSeq);
freez(pEl);
}

void simpleNucDiffFreeList(struct simpleNucDiff **pList)
/* Free a list of dynamically allocated simpleNucDiff's */
{
struct simpleNucDiff *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    simpleNucDiffFree(&el);
    }
*pList = NULL;
}

void simpleNucDiffOutput(struct simpleNucDiff *el, FILE *f, char sep, char lastSep) 
/* Print out simpleNucDiff.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tSeq);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->qSeq);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

