/* yaleGencodeAssoc.c was originally generated by the autoSql program, which also 
 * generated yaleGencodeAssoc.h and yaleGencodeAssoc.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "yaleGencodeAssoc.h"


void yaleGencodeAssocStaticLoad(char **row, struct yaleGencodeAssoc *ret)
/* Load a row from yaleGencodeAssoc table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->transcript = row[0];
ret->yaleId = row[1];
ret->locus = row[2];
}

struct yaleGencodeAssoc *yaleGencodeAssocLoad(char **row)
/* Load a yaleGencodeAssoc from row fetched with select * from yaleGencodeAssoc
 * from database.  Dispose of this with yaleGencodeAssocFree(). */
{
struct yaleGencodeAssoc *ret;

AllocVar(ret);
ret->transcript = cloneString(row[0]);
ret->yaleId = cloneString(row[1]);
ret->locus = cloneString(row[2]);
return ret;
}

struct yaleGencodeAssoc *yaleGencodeAssocLoadAll(char *fileName) 
/* Load all yaleGencodeAssoc from a whitespace-separated file.
 * Dispose of this with yaleGencodeAssocFreeList(). */
{
struct yaleGencodeAssoc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = yaleGencodeAssocLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct yaleGencodeAssoc *yaleGencodeAssocLoadAllByChar(char *fileName, char chopper) 
/* Load all yaleGencodeAssoc from a chopper separated file.
 * Dispose of this with yaleGencodeAssocFreeList(). */
{
struct yaleGencodeAssoc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = yaleGencodeAssocLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct yaleGencodeAssoc *yaleGencodeAssocCommaIn(char **pS, struct yaleGencodeAssoc *ret)
/* Create a yaleGencodeAssoc out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new yaleGencodeAssoc */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->transcript = sqlStringComma(&s);
ret->yaleId = sqlStringComma(&s);
ret->locus = sqlStringComma(&s);
*pS = s;
return ret;
}

void yaleGencodeAssocFree(struct yaleGencodeAssoc **pEl)
/* Free a single dynamically allocated yaleGencodeAssoc such as created
 * with yaleGencodeAssocLoad(). */
{
struct yaleGencodeAssoc *el;

if ((el = *pEl) == NULL) return;
freeMem(el->transcript);
freeMem(el->yaleId);
freeMem(el->locus);
freez(pEl);
}

void yaleGencodeAssocFreeList(struct yaleGencodeAssoc **pList)
/* Free a list of dynamically allocated yaleGencodeAssoc's */
{
struct yaleGencodeAssoc *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    yaleGencodeAssocFree(&el);
    }
*pList = NULL;
}

void yaleGencodeAssocOutput(struct yaleGencodeAssoc *el, FILE *f, char sep, char lastSep) 
/* Print out yaleGencodeAssoc.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->transcript);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->yaleId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->locus);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

