/* HInv.h was originally generated by the autoSql program, which also 
 * generated HInv.c and HInv.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2004 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef HINV_H
#define HINV_H

#define HINV_NUM_COLS 3

struct HInv
/* H-Invitational Gene data */
    {
    struct HInv *next;  /* Next in singly linked list. */
    char *geneId;	/* gene ID */
    char *clusterId;	/* gene cluster ID */
    char *mrnaAcc;	/* Genbank mRNA accession */
    };

void HInvStaticLoad(char **row, struct HInv *ret);
/* Load a row from HInv table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct HInv *HInvLoad(char **row);
/* Load a HInv from row fetched with select * from HInv
 * from database.  Dispose of this with HInvFree(). */

struct HInv *HInvLoadAll(char *fileName);
/* Load all HInv from whitespace-separated file.
 * Dispose of this with HInvFreeList(). */

struct HInv *HInvLoadAllByChar(char *fileName, char chopper);
/* Load all HInv from chopper separated file.
 * Dispose of this with HInvFreeList(). */

#define HInvLoadAllByTab(a) HInvLoadAllByChar(a, '\t');
/* Load all HInv from tab separated file.
 * Dispose of this with HInvFreeList(). */

struct HInv *HInvCommaIn(char **pS, struct HInv *ret);
/* Create a HInv out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new HInv */

void HInvFree(struct HInv **pEl);
/* Free a single dynamically allocated HInv such as created
 * with HInvLoad(). */

void HInvFreeList(struct HInv **pList);
/* Free a list of dynamically allocated HInv's */

void HInvOutput(struct HInv *el, FILE *f, char sep, char lastSep);
/* Print out HInv.  Separate fields with sep. Follow last field with lastSep. */

#define HInvTabOut(el,f) HInvOutput(el,f,'\t','\n');
/* Print out HInv as a line in a tab-separated file. */

#define HInvCommaOut(el,f) HInvOutput(el,f,',',',');
/* Print out HInv as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* HINV_H */

