/* alignInfo.h was originally generated by the autoSql program, which also 
 * generated alignInfo.c and alignInfo.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2009 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ALIGNINFO_H
#define ALIGNINFO_H

#define ALIGNINFO_NUM_COLS 11

struct alignInfo
/* Aligned Features Description */
    {
    struct alignInfo *next;  /* Next in singly linked list. */
    char *chrom;	/* chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* hit name */
    unsigned score;	/* Score from 900-1000.  1000 is best */
    char strand[2];	/* Value should be + or - */
    unsigned hasmatch;	/* If it has match in aligned species */
    char *orgn;	/* aligned organism */
    char *alignChrom;	/* chromosome for aligned species */
    unsigned alignChromStart;	/* Start position in chromosome for aligned species */
    unsigned alignChromEnd;	/* End position in chromosome for aligned species */
    };

void alignInfoStaticLoad(char **row, struct alignInfo *ret);
/* Load a row from alignInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct alignInfo *alignInfoLoad(char **row);
/* Load a alignInfo from row fetched with select * from alignInfo
 * from database.  Dispose of this with alignInfoFree(). */

struct alignInfo *alignInfoLoadAll(char *fileName);
/* Load all alignInfo from whitespace-separated file.
 * Dispose of this with alignInfoFreeList(). */

struct alignInfo *alignInfoLoadAllByChar(char *fileName, char chopper);
/* Load all alignInfo from chopper separated file.
 * Dispose of this with alignInfoFreeList(). */

#define alignInfoLoadAllByTab(a) alignInfoLoadAllByChar(a, '\t');
/* Load all alignInfo from tab separated file.
 * Dispose of this with alignInfoFreeList(). */

struct alignInfo *alignInfoCommaIn(char **pS, struct alignInfo *ret);
/* Create a alignInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new alignInfo */

void alignInfoFree(struct alignInfo **pEl);
/* Free a single dynamically allocated alignInfo such as created
 * with alignInfoLoad(). */

void alignInfoFreeList(struct alignInfo **pList);
/* Free a list of dynamically allocated alignInfo's */

void alignInfoOutput(struct alignInfo *el, FILE *f, char sep, char lastSep);
/* Print out alignInfo.  Separate fields with sep. Follow last field with lastSep. */

#define alignInfoTabOut(el,f) alignInfoOutput(el,f,'\t','\n');
/* Print out alignInfo as a line in a tab-separated file. */

#define alignInfoCommaOut(el,f) alignInfoOutput(el,f,',',',');
/* Print out alignInfo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ALIGNINFO_H */

