/* blastTab.h was originally generated by the autoSql program, which also 
 * generated blastTab.c and blastTab.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2003 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef BLASTTAB_H
#define BLASTTAB_H

#define BLASTTAB_NUM_COLS 12

struct blastTab
/* Tab-delimited blast output file */
    {
    struct blastTab *next;  /* Next in singly linked list. */
    char *query;	/* Name of query sequence */
    char *target;	/* Name of target sequence */
    float identity;	/* Percent identity */
    unsigned aliLength;	/* Length of alignment */
    unsigned mismatch;	/* Number of mismatches */
    unsigned gapOpen;	/* Number of gap openings */
    unsigned qStart;	/* Start in query (0 based) */
    unsigned qEnd;	/* End in query (non-inclusive) */
    unsigned tStart;	/* Start in target (0 based) */
    unsigned tEnd;	/* Start in query (non-inclusive) */
    double eValue;	/* Expectation value */
    double bitScore;	/* Bit score */
    };

void blastTabStaticLoad(char **row, struct blastTab *ret);
/* Load a row from blastTab table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct blastTab *blastTabNext(struct lineFile *lf);
/* get next blastTab from file */

struct blastTab *blastTabLoad(char **row);
/* Load a blastTab from row fetched with select * from blastTab
 * from database.  Dispose of this with blastTabFree(). */

struct blastTab *blastTabLoadAll(char *fileName);
/* Load all blastTab from whitespace-separated file.
 * Dispose of this with blastTabFreeList(). */

struct blastTab *blastTabCommaIn(char **pS, struct blastTab *ret);
/* Create a blastTab out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new blastTab */

void blastTabFree(struct blastTab **pEl);
/* Free a single dynamically allocated blastTab such as created
 * with blastTabLoad(). */

void blastTabFreeList(struct blastTab **pList);
/* Free a list of dynamically allocated blastTab's */

void blastTabOutput(struct blastTab *el, FILE *f, char sep, char lastSep);
/* Print out blastTab.  Separate fields with sep. Follow last field with lastSep. */

#define blastTabTabOut(el,f) blastTabOutput(el,f,'\t','\n');
/* Print out blastTab as a line in a tab-separated file. */

#define blastTabCommaOut(el,f) blastTabOutput(el,f,',',',');
/* Print out blastTab as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* BLASTTAB_H */

