/* cnpSebat.h was originally generated by the autoSql program, which also 
 * generated cnpSebat.c and cnpSebat.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef CNPSEBAT_H
#define CNPSEBAT_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define CNPSEBAT_NUM_COLS 6

struct cnpSebat
/* CNP Data from the Sebat lab */
    {
    struct cnpSebat *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* Gain or Loss */
    unsigned probes;	/* Number of probes */
    unsigned individuals;	/* Number of individuals */
    };

void cnpSebatStaticLoad(char **row, struct cnpSebat *ret);
/* Load a row from cnpSebat table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cnpSebat *cnpSebatLoad(char **row);
/* Load a cnpSebat from row fetched with select * from cnpSebat
 * from database.  Dispose of this with cnpSebatFree(). */

struct cnpSebat *cnpSebatLoadAll(char *fileName);
/* Load all cnpSebat from whitespace-separated file.
 * Dispose of this with cnpSebatFreeList(). */

struct cnpSebat *cnpSebatLoadAllByChar(char *fileName, char chopper);
/* Load all cnpSebat from chopper separated file.
 * Dispose of this with cnpSebatFreeList(). */

#define cnpSebatLoadAllByTab(a) cnpSebatLoadAllByChar(a, '\t');
/* Load all cnpSebat from tab separated file.
 * Dispose of this with cnpSebatFreeList(). */

struct cnpSebat *cnpSebatLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cnpSebat from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cnpSebatFreeList(). */

void cnpSebatSaveToDb(struct sqlConnection *conn, struct cnpSebat *el, char *tableName, int updateSize);
/* Save cnpSebat as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct cnpSebat *cnpSebatCommaIn(char **pS, struct cnpSebat *ret);
/* Create a cnpSebat out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cnpSebat */

void cnpSebatFree(struct cnpSebat **pEl);
/* Free a single dynamically allocated cnpSebat such as created
 * with cnpSebatLoad(). */

void cnpSebatFreeList(struct cnpSebat **pList);
/* Free a list of dynamically allocated cnpSebat's */

void cnpSebatOutput(struct cnpSebat *el, FILE *f, char sep, char lastSep);
/* Print out cnpSebat.  Separate fields with sep. Follow last field with lastSep. */

#define cnpSebatTabOut(el,f) cnpSebatOutput(el,f,'\t','\n');
/* Print out cnpSebat as a line in a tab-separated file. */

#define cnpSebatCommaOut(el,f) cnpSebatOutput(el,f,',',',');
/* Print out cnpSebat as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* CNPSEBAT_H */

