/* ld2.h was originally generated by the autoSql program, which also 
 * generated ld2.c and ld2.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef LD2_H
#define LD2_H

#define LD2_NUM_COLS 12

struct ld2
/* Linkage Disequilibrium values computed by Haploview and encoded by UCSC. */
    {
    struct ld2 *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* chromStart for reference marker */
    unsigned chromEnd;	/* chromEnd for last marker in list */
    char *name;	/* rsId at chromStart */
    unsigned ldCount;	/* Number of markers with LD values */
    char *dprime;	/* Encoded list (length=ldCount) of D' values */
    char *rsquared;	/* Encoded list (length=ldCount) of r^2 values */
    char *lod;	/* Encoded list (length=ldCount) of LOD values */
    char avgDprime;	/* Encoded average D' magnitude for dense display */
    char avgRsquared;	/* Encoded average r^2 value for dense display */
    char avgLod;	/* Encoded average LOD value for dense display */
    char tInt;	/* Encoded T-int value between this and next marker */
    };

void ld2StaticLoad(char **row, struct ld2 *ret);
/* Load a row from ld2 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct ld2 *ld2Load(char **row);
/* Load a ld2 from row fetched with select * from ld2
 * from database.  Dispose of this with ld2Free(). */

struct ld2 *ld2LoadAll(char *fileName);
/* Load all ld2 from whitespace-separated file.
 * Dispose of this with ld2FreeList(). */

struct ld2 *ld2LoadAllByChar(char *fileName, char chopper);
/* Load all ld2 from chopper separated file.
 * Dispose of this with ld2FreeList(). */

#define ld2LoadAllByTab(a) ld2LoadAllByChar(a, '\t');
/* Load all ld2 from tab separated file.
 * Dispose of this with ld2FreeList(). */

struct ld2 *ld2CommaIn(char **pS, struct ld2 *ret);
/* Create a ld2 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ld2 */

void ld2Free(struct ld2 **pEl);
/* Free a single dynamically allocated ld2 such as created
 * with ld2Load(). */

void ld2FreeList(struct ld2 **pList);
/* Free a list of dynamically allocated ld2's */

void ld2Output(struct ld2 *el, FILE *f, char sep, char lastSep);
/* Print out ld2.  Separate fields with sep. Follow last field with lastSep. */

#define ld2TabOut(el,f) ld2Output(el,f,'\t','\n');
/* Print out ld2 as a line in a tab-separated file. */

#define ld2CommaOut(el,f) ld2Output(el,f,',',',');
/* Print out ld2 as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* LD2_H */

