/* protVar.h was originally generated by the autoSql program, which also 
 * generated protVar.c and protVar.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef PROTVAR_H
#define PROTVAR_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define PROTVAR_NUM_COLS 6

struct protVar
/* track for mutation data */
    {
    struct protVar *next;  /* Next in singly linked list. */
    char *id;	/* unique ID for this mutation */
    char *name;	/* Official nomenclature description of mutation */
    char *srcId;	/* source ID for this mutation */
    char *baseChangeType;	/* enum('insertion', 'deletion', 'substitution','duplication','complex','unknown') */
    char *location;	/* enum('intron', 'exon', '5'' UTR', '3'' UTR', 'not within known transcription unit') */
    unsigned char coordinateAccuracy;	/* 0=estimated, 1=definite, others? */
    };

void protVarStaticLoad(char **row, struct protVar *ret);
/* Load a row from protVar table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct protVar *protVarLoad(char **row);
/* Load a protVar from row fetched with select * from protVar
 * from database.  Dispose of this with protVarFree(). */

struct protVar *protVarLoadAll(char *fileName);
/* Load all protVar from whitespace-separated file.
 * Dispose of this with protVarFreeList(). */

struct protVar *protVarLoadAllByChar(char *fileName, char chopper);
/* Load all protVar from chopper separated file.
 * Dispose of this with protVarFreeList(). */

#define protVarLoadAllByTab(a) protVarLoadAllByChar(a, '\t');
/* Load all protVar from tab separated file.
 * Dispose of this with protVarFreeList(). */

struct protVar *protVarLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all protVar from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with protVarFreeList(). */

void protVarSaveToDb(struct sqlConnection *conn, struct protVar *el, char *tableName, int updateSize);
/* Save protVar as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct protVar *protVarCommaIn(char **pS, struct protVar *ret);
/* Create a protVar out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new protVar */

void protVarFree(struct protVar **pEl);
/* Free a single dynamically allocated protVar such as created
 * with protVarLoad(). */

void protVarFreeList(struct protVar **pList);
/* Free a list of dynamically allocated protVar's */

void protVarOutput(struct protVar *el, FILE *f, char sep, char lastSep);
/* Print out protVar.  Separate fields with sep. Follow last field with lastSep. */

#define protVarTabOut(el,f) protVarOutput(el,f,'\t','\n');
/* Print out protVar as a line in a tab-separated file. */

#define protVarCommaOut(el,f) protVarOutput(el,f,',',',');
/* Print out protVar as a comma separated list including final comma. */

#define PROTVARPOS_NUM_COLS 7

struct protVarPos
/* location of mutation */
    {
    struct protVarPos *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* ID for this mutation */
    char strand[2];	/* + or - */
    char *label;	/* short official name for this mutation */
    unsigned short bin; /* A field to speed indexing */
    };

void protVarPosStaticLoad(char **row, struct protVarPos *ret);
/* Load a row from protVarPos table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct protVarPos *protVarPosLoad(char **row);
/* Load a protVarPos from row fetched with select * from protVarPos
 * from database.  Dispose of this with protVarPosFree(). */

struct protVarPos *protVarPosLoadAll(char *fileName);
/* Load all protVarPos from whitespace-separated file.
 * Dispose of this with protVarPosFreeList(). */

struct protVarPos *protVarPosLoadAllByChar(char *fileName, char chopper);
/* Load all protVarPos from chopper separated file.
 * Dispose of this with protVarPosFreeList(). */

#define protVarPosLoadAllByTab(a) protVarPosLoadAllByChar(a, '\t');
/* Load all protVarPos from tab separated file.
 * Dispose of this with protVarPosFreeList(). */

struct protVarPos *protVarPosLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all protVarPos from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with protVarPosFreeList(). */

void protVarPosSaveToDb(struct sqlConnection *conn, struct protVarPos *el, char *tableName, int updateSize);
/* Save protVarPos as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct protVarPos *protVarPosCommaIn(char **pS, struct protVarPos *ret);
/* Create a protVarPos out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new protVarPos */

void protVarPosFree(struct protVarPos **pEl);
/* Free a single dynamically allocated protVarPos such as created
 * with protVarPosLoad(). */

void protVarPosFreeList(struct protVarPos **pList);
/* Free a list of dynamically allocated protVarPos's */

void protVarPosOutput(struct protVarPos *el, FILE *f, char sep, char lastSep);
/* Print out protVarPos.  Separate fields with sep. Follow last field with lastSep. */

#define protVarPosTabOut(el,f) protVarPosOutput(el,f,'\t','\n');
/* Print out protVarPos as a line in a tab-separated file. */

#define protVarPosCommaOut(el,f) protVarPosOutput(el,f,',',',');
/* Print out protVarPos as a comma separated list including final comma. */

#define PROTVARATTR_NUM_COLS 3

struct protVarAttr
/* attributes asssociated with the mutation */
    {
    struct protVarAttr *next;  /* Next in singly linked list. */
    char *id;	/* mutation ID */
    char *attrType;	/* attribute type */
    char *attrVal;	/* value for this attribute */
    };

void protVarAttrStaticLoad(char **row, struct protVarAttr *ret);
/* Load a row from protVarAttr table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct protVarAttr *protVarAttrLoad(char **row);
/* Load a protVarAttr from row fetched with select * from protVarAttr
 * from database.  Dispose of this with protVarAttrFree(). */

struct protVarAttr *protVarAttrLoadAll(char *fileName);
/* Load all protVarAttr from whitespace-separated file.
 * Dispose of this with protVarAttrFreeList(). */

struct protVarAttr *protVarAttrLoadAllByChar(char *fileName, char chopper);
/* Load all protVarAttr from chopper separated file.
 * Dispose of this with protVarAttrFreeList(). */

#define protVarAttrLoadAllByTab(a) protVarAttrLoadAllByChar(a, '\t');
/* Load all protVarAttr from tab separated file.
 * Dispose of this with protVarAttrFreeList(). */

struct protVarAttr *protVarAttrLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all protVarAttr from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with protVarAttrFreeList(). */

void protVarAttrSaveToDb(struct sqlConnection *conn, struct protVarAttr *el, char *tableName, int updateSize);
/* Save protVarAttr as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct protVarAttr *protVarAttrCommaIn(char **pS, struct protVarAttr *ret);
/* Create a protVarAttr out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new protVarAttr */

void protVarAttrFree(struct protVarAttr **pEl);
/* Free a single dynamically allocated protVarAttr such as created
 * with protVarAttrLoad(). */

void protVarAttrFreeList(struct protVarAttr **pList);
/* Free a list of dynamically allocated protVarAttr's */

void protVarAttrOutput(struct protVarAttr *el, FILE *f, char sep, char lastSep);
/* Print out protVarAttr.  Separate fields with sep. Follow last field with lastSep. */

#define protVarAttrTabOut(el,f) protVarAttrOutput(el,f,'\t','\n');
/* Print out protVarAttr as a line in a tab-separated file. */

#define protVarAttrCommaOut(el,f) protVarAttrOutput(el,f,',',',');
/* Print out protVarAttr as a comma separated list including final comma. */

#define PROTVARLINK_NUM_COLS 5

struct protVarLink
/* links both urls and local table lookups */
    {
    struct protVarLink *next;  /* Next in singly linked list. */
    char *id;	/* id for attribute link */
    char *attrType;	/* attribute type */
    char *raKey;	/* key into .ra file on how to do link */
    char *acc;	/* accession or id used by link */
    char *displayVal;	/* value to display if different from acc */
    };

void protVarLinkStaticLoad(char **row, struct protVarLink *ret);
/* Load a row from protVarLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct protVarLink *protVarLinkLoad(char **row);
/* Load a protVarLink from row fetched with select * from protVarLink
 * from database.  Dispose of this with protVarLinkFree(). */

struct protVarLink *protVarLinkLoadAll(char *fileName);
/* Load all protVarLink from whitespace-separated file.
 * Dispose of this with protVarLinkFreeList(). */

struct protVarLink *protVarLinkLoadAllByChar(char *fileName, char chopper);
/* Load all protVarLink from chopper separated file.
 * Dispose of this with protVarLinkFreeList(). */

#define protVarLinkLoadAllByTab(a) protVarLinkLoadAllByChar(a, '\t');
/* Load all protVarLink from tab separated file.
 * Dispose of this with protVarLinkFreeList(). */

struct protVarLink *protVarLinkLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all protVarLink from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with protVarLinkFreeList(). */

void protVarLinkSaveToDb(struct sqlConnection *conn, struct protVarLink *el, char *tableName, int updateSize);
/* Save protVarLink as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct protVarLink *protVarLinkCommaIn(char **pS, struct protVarLink *ret);
/* Create a protVarLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new protVarLink */

void protVarLinkFree(struct protVarLink **pEl);
/* Free a single dynamically allocated protVarLink such as created
 * with protVarLinkLoad(). */

void protVarLinkFreeList(struct protVarLink **pList);
/* Free a list of dynamically allocated protVarLink's */

void protVarLinkOutput(struct protVarLink *el, FILE *f, char sep, char lastSep);
/* Print out protVarLink.  Separate fields with sep. Follow last field with lastSep. */

#define protVarLinkTabOut(el,f) protVarLinkOutput(el,f,'\t','\n');
/* Print out protVarLink as a line in a tab-separated file. */

#define protVarLinkCommaOut(el,f) protVarLinkOutput(el,f,',',',');
/* Print out protVarLink as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* PROTVAR_H */

