/* affy10K.c was originally generated by the autoSql program, which also 
 * generated affy10K.h and affy10K.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "affy10K.h"


void affy10KStaticLoad(char **row, struct affy10K *ret)
/* Load a row from affy10K table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
int sizeOne,i;
char *s;

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->affyId = sqlUnsigned(row[3]);
}

struct affy10K *affy10KLoad(char **row)
/* Load a affy10K from row fetched with select * from affy10K
 * from database.  Dispose of this with affy10KFree(). */
{
struct affy10K *ret;
int sizeOne,i;
char *s;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->affyId = sqlUnsigned(row[3]);
return ret;
}

struct affy10K *affy10KLoadAll(char *fileName) 
/* Load all affy10K from a whitespace-separated file.
 * Dispose of this with affy10KFreeList(). */
{
struct affy10K *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = affy10KLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct affy10K *affy10KLoadAllByChar(char *fileName, char chopper) 
/* Load all affy10K from a chopper separated file.
 * Dispose of this with affy10KFreeList(). */
{
struct affy10K *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = affy10KLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct affy10K *affy10KLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all affy10K from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with affy10KFreeList(). */
{
struct affy10K *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = affy10KLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void affy10KSaveToDb(struct sqlConnection *conn, struct affy10K *el, char *tableName, int updateSize)
/* Save affy10K as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s',%u,%u,%u)", 
	tableName,  el->chrom,  el->chromStart,  el->chromEnd,  el->affyId);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}


struct affy10K *affy10KCommaIn(char **pS, struct affy10K *ret)
/* Create a affy10K out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new affy10K */
{
char *s = *pS;
int i;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->affyId = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void affy10KFree(struct affy10K **pEl)
/* Free a single dynamically allocated affy10K such as created
 * with affy10KLoad(). */
{
struct affy10K *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freez(pEl);
}

void affy10KFreeList(struct affy10K **pList)
/* Free a list of dynamically allocated affy10K's */
{
struct affy10K *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    affy10KFree(&el);
    }
*pList = NULL;
}

void affy10KOutput(struct affy10K *el, FILE *f, char sep, char lastSep) 
/* Print out affy10K.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
fprintf(f, "%u", el->affyId);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

