/* assemblyList.c was originally generated by the autoSql program, which also
 * generated assemblyList.h and assemblyList.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "hgConfig.h"
#include "assemblyList.h"

char *assemblyListCommaSepFieldNames = "name,priority,commonName,scientificName,taxId,clade,description,browserExists,hubUrl,year,refSeqCategory,versionStatus,assemblyLevel";

void assemblyListStaticLoadWithNull(char **row, struct assemblyList *ret)
/* Load a row from assemblyList table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
if (row[1] != NULL)
    {
    ret->priority = needMem(sizeof(*(ret->priority)));
    *(ret->priority) = sqlUnsigned(row[1]);
    }
else
    {
    ret->priority = NULL;
    }
ret->commonName = row[2];
ret->scientificName = row[3];
if (row[4] != NULL)
    {
    ret->taxId = needMem(sizeof(*(ret->taxId)));
    *(ret->taxId) = sqlUnsigned(row[4]);
    }
else
    {
    ret->taxId = NULL;
    }
ret->clade = row[5];
ret->description = row[6];
if (row[7] != NULL)
    {
    ret->browserExists = needMem(sizeof(*(ret->browserExists)));
    *(ret->browserExists) = sqlUnsigned(row[7]);
    }
else
    {
    ret->browserExists = NULL;
    }
ret->hubUrl = row[8];
if (row[9] != NULL)
    {
    ret->year = needMem(sizeof(*(ret->year)));
    *(ret->year) = sqlUnsigned(row[9]);
    }
else
    {
    ret->year = NULL;
    }
ret->refSeqCategory = row[10];
ret->versionStatus = row[11];
ret->assemblyLevel = row[12];
}

struct assemblyList *assemblyListLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all assemblyList from table that satisfy the query given.
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something =
 * anotherTable.something'.
 * Dispose of this with assemblyListFreeList(). */
{
struct assemblyList *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = assemblyListLoadWithNull(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void assemblyListSaveToDb(struct sqlConnection *conn, struct assemblyList *el, char *tableName, int updateSize)
/* Save assemblyList as a row to the table specified by tableName.
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s',%u,'%s','%s',%u,'%s','%s',%u,'%s',%u,'%s','%s','%s')",
	tableName,  el->name,  *(el->priority),  el->commonName,  el->scientificName,  *(el->taxId),  el->clade,  el->description,  *(el->browserExists),  el->hubUrl,  *(el->year),  el->refSeqCategory,  el->versionStatus,  el->assemblyLevel);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct assemblyList *assemblyListLoadWithNull(char **row)
/* Load a assemblyList from row fetched with select * from assemblyList
 * from database.  Dispose of this with assemblyListFree(). */
{
struct assemblyList *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
if (row[1] != NULL)
    {
    ret->priority = needMem(sizeof(*(ret->priority)));
    *(ret->priority) = sqlUnsigned(row[1]);
    }
else
    {
    ret->priority = NULL;
    }
ret->commonName = cloneString(row[2]);
ret->scientificName = cloneString(row[3]);
if (row[4] != NULL)
    {
    ret->taxId = needMem(sizeof(*(ret->taxId)));
    *(ret->taxId) = sqlUnsigned(row[4]);
    }
else
    {
    ret->taxId = NULL;
    }
ret->clade = cloneString(row[5]);
ret->description = cloneString(row[6]);
if (row[7] != NULL)
    {
    ret->browserExists = needMem(sizeof(*(ret->browserExists)));
    *(ret->browserExists) = sqlUnsigned(row[7]);
    }
else
    {
    ret->browserExists = NULL;
    }
ret->hubUrl = cloneString(row[8]);
if (row[9] != NULL)
    {
    ret->year = needMem(sizeof(*(ret->year)));
    *(ret->year) = sqlUnsigned(row[9]);
    }
else
    {
    ret->year = NULL;
    }
ret->refSeqCategory = cloneString(row[10]);
ret->versionStatus = cloneString(row[11]);
ret->assemblyLevel = cloneString(row[12]);
return ret;
}

struct assemblyList *assemblyListLoadAll(char *fileName)
/* Load all assemblyList from a whitespace-separated file.
 * Dispose of this with assemblyListFreeList(). */
{
struct assemblyList *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[13];

while (lineFileRow(lf, row))
    {
    el = assemblyListLoadWithNull(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct assemblyList *assemblyListLoadAllByChar(char *fileName, char chopper)
/* Load all assemblyList from a chopper separated file.
 * Dispose of this with assemblyListFreeList(). */
{
struct assemblyList *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[13];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = assemblyListLoadWithNull(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct assemblyList *assemblyListCommaIn(char **pS, struct assemblyList *ret)
/* Create a assemblyList out of a comma separated string.
 * This will fill in ret if non-null, otherwise will
 * return a new assemblyList */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->priority = needMem(sizeof(unsigned));
*(ret->priority) = sqlUnsignedComma(&s);
ret->commonName = sqlStringComma(&s);
ret->scientificName = sqlStringComma(&s);
ret->taxId = needMem(sizeof(unsigned));
*(ret->taxId) = sqlUnsignedComma(&s);
ret->clade = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->browserExists = needMem(sizeof(unsigned));
*(ret->browserExists) = sqlUnsignedComma(&s);
ret->hubUrl = sqlStringComma(&s);
ret->year = needMem(sizeof(unsigned));
*(ret->year) = sqlUnsignedComma(&s);
ret->refSeqCategory = sqlStringComma(&s);
ret->versionStatus = sqlStringComma(&s);
ret->assemblyLevel = sqlStringComma(&s);
*pS = s;
return ret;
}

void assemblyListFree(struct assemblyList **pEl)
/* Free a single dynamically allocated assemblyList such as created
 * with assemblyListLoad(). */
{
struct assemblyList *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->commonName);
freeMem(el->scientificName);
freeMem(el->clade);
freeMem(el->description);
freeMem(el->hubUrl);
freeMem(el->refSeqCategory);
freeMem(el->versionStatus);
freeMem(el->assemblyLevel);
freez(pEl);
}

void assemblyListFreeList(struct assemblyList **pList)
/* Free a list of dynamically allocated assemblyList's */
{
struct assemblyList *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    assemblyListFree(&el);
    }
*pList = NULL;
}

void assemblyListOutput(struct assemblyList *el, FILE *f, char sep, char lastSep)
/* Print out assemblyList.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", *(el->priority));
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->commonName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->scientificName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", *(el->taxId));
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->clade);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", *(el->browserExists));
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->hubUrl);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", *(el->year));
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->refSeqCategory);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->versionStatus);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->assemblyLevel);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void assemblyListJsonOutput(struct assemblyList *el, FILE *f)
/* Print out assemblyList in JSON format. */
{
fputc('{',f);
fputc('"',f);
fprintf(f,"name");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->name);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"priority");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", *(el->priority));
fputc(',',f);
fputc('"',f);
fprintf(f,"commonName");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->commonName);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"scientificName");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->scientificName);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"taxId");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", *(el->taxId));
fputc(',',f);
fputc('"',f);
fprintf(f,"clade");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->clade);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"description");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->description);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"browserExists");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", *(el->browserExists));
fputc(',',f);
fputc('"',f);
fprintf(f,"hubUrl");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->hubUrl);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"year");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", *(el->year));
fputc(',',f);
fputc('"',f);
fprintf(f,"refSeqCategory");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->refSeqCategory);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"versionStatus");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->versionStatus);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"assemblyLevel");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->assemblyLevel);
fputc('"',f);
fputc('}',f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

static char *_assemblyListTableName = NULL;

char *assemblyListTableName()
/* return the assemblyList table name from the environment,
 * or hg.conf, or use the default.  Cache the result */
{
if (_assemblyListTableName == NULL)
    _assemblyListTableName = cfgOptionEnvDefault("HGDB_ASSEMBLYLIST_STATUS_TABLE",
	    assemblyListTableConfVariable, defaultAssemblyListTableName);

return _assemblyListTableName;
}

char *asmListMatchAllWords(char *searchString)
/* given a multiple word search string, fix it up so it will be
 *  a 'match all words' MySQL FULLTEXT query, with the required + signs
 *  in front of the words when appropriate
 */
{
struct dyString *allWords = dyStringNew(64);
int wordCount = wordCount = chopByWhite(searchString, NULL, 0);
/* single word ?  simply return it, doesn't need anything */
if (1 == wordCount)
    dyStringPrintf(allWords, "%s", searchString);
else
    {
    char **words;
    AllocArray(words, wordCount);
    (void) chopByWhite(searchString, words, wordCount);
    boolean inQuote = FALSE;
    for (int i = 0; i < wordCount; ++i)
	{
        if (inQuote)
	    {
	    dyStringPrintf(allWords, " %s", words[i]);
	    if ('"' == lastChar(words[i]))
		inQuote = FALSE;
	    }
        else if ('"' == words[i][0])
	    {	/* "quoted string" becomes: +"quoted string"	*/
	    dyStringPrintf(allWords, " +%s", words[i]);
	    inQuote = TRUE;
	    }
        else if ('+' == words[i][0] || '-' == words[i][0])
	    dyStringPrintf(allWords, " %s", words[i]);	/* nothing needed */
        else
	    dyStringPrintf(allWords, " +%s", words[i]);	/* add + to all words */
	}
    }
/* trimSpaces will remove any leading or trailing white space */
return trimSpaces(dyStringCannibalize(&allWords));
}
