/* clusterInputAwgDnase.c was originally generated by the autoSql program, which also 
 * generated clusterInputAwgDnase.h and clusterInputAwgDnase.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "clusterInputAwgDnase.h"


void clusterInputAwgDnaseStaticLoad(char **row, struct clusterInputAwgDnase *ret)
/* Load a row from clusterInputAwgDnase table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->tableName = row[0];
ret->cellType = row[1];
ret->treatment = row[2];
ret->lab = row[3];
}

struct clusterInputAwgDnase *clusterInputAwgDnaseLoad(char **row)
/* Load a clusterInputAwgDnase from row fetched with select * from clusterInputAwgDnase
 * from database.  Dispose of this with clusterInputAwgDnaseFree(). */
{
struct clusterInputAwgDnase *ret;

AllocVar(ret);
ret->tableName = cloneString(row[0]);
ret->cellType = cloneString(row[1]);
ret->treatment = cloneString(row[2]);
ret->lab = cloneString(row[3]);
return ret;
}

struct clusterInputAwgDnase *clusterInputAwgDnaseLoadAll(char *fileName) 
/* Load all clusterInputAwgDnase from a whitespace-separated file.
 * Dispose of this with clusterInputAwgDnaseFreeList(). */
{
struct clusterInputAwgDnase *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = clusterInputAwgDnaseLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct clusterInputAwgDnase *clusterInputAwgDnaseLoadAllByChar(char *fileName, char chopper) 
/* Load all clusterInputAwgDnase from a chopper separated file.
 * Dispose of this with clusterInputAwgDnaseFreeList(). */
{
struct clusterInputAwgDnase *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = clusterInputAwgDnaseLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct clusterInputAwgDnase *clusterInputAwgDnaseCommaIn(char **pS, struct clusterInputAwgDnase *ret)
/* Create a clusterInputAwgDnase out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new clusterInputAwgDnase */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->tableName = sqlStringComma(&s);
ret->cellType = sqlStringComma(&s);
ret->treatment = sqlStringComma(&s);
ret->lab = sqlStringComma(&s);
*pS = s;
return ret;
}

void clusterInputAwgDnaseFree(struct clusterInputAwgDnase **pEl)
/* Free a single dynamically allocated clusterInputAwgDnase such as created
 * with clusterInputAwgDnaseLoad(). */
{
struct clusterInputAwgDnase *el;

if ((el = *pEl) == NULL) return;
freeMem(el->tableName);
freeMem(el->cellType);
freeMem(el->treatment);
freeMem(el->lab);
freez(pEl);
}

void clusterInputAwgDnaseFreeList(struct clusterInputAwgDnase **pList)
/* Free a list of dynamically allocated clusterInputAwgDnase's */
{
struct clusterInputAwgDnase *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    clusterInputAwgDnaseFree(&el);
    }
*pList = NULL;
}

void clusterInputAwgDnaseOutput(struct clusterInputAwgDnase *el, FILE *f, char sep, char lastSep) 
/* Print out clusterInputAwgDnase.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tableName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cellType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->treatment);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->lab);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

