/* ecAttribute.c was originally generated by the autoSql program, which also 
 * generated ecAttribute.h and ecAttribute.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "ecAttribute.h"


void ecAttributeStaticLoad(char **row, struct ecAttribute *ret)
/* Load a row from ecAttribute table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->level1 = sqlUnsigned(row[1]);
ret->level2 = sqlUnsigned(row[2]);
ret->level3 = sqlUnsigned(row[3]);
ret->level4 = sqlUnsigned(row[4]);
ret->ec = row[5];
strcpy(ret->type, row[6]);
ret->description = row[7];
}

struct ecAttribute *ecAttributeLoad(char **row)
/* Load a ecAttribute from row fetched with select * from ecAttribute
 * from database.  Dispose of this with ecAttributeFree(). */
{
struct ecAttribute *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->level1 = sqlUnsigned(row[1]);
ret->level2 = sqlUnsigned(row[2]);
ret->level3 = sqlUnsigned(row[3]);
ret->level4 = sqlUnsigned(row[4]);
ret->ec = cloneString(row[5]);
strcpy(ret->type, row[6]);
ret->description = cloneString(row[7]);
return ret;
}

struct ecAttribute *ecAttributeLoadAll(char *fileName) 
/* Load all ecAttribute from a whitespace-separated file.
 * Dispose of this with ecAttributeFreeList(). */
{
struct ecAttribute *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = ecAttributeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ecAttribute *ecAttributeLoadAllByChar(char *fileName, char chopper) 
/* Load all ecAttribute from a chopper separated file.
 * Dispose of this with ecAttributeFreeList(). */
{
struct ecAttribute *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = ecAttributeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ecAttribute *ecAttributeCommaIn(char **pS, struct ecAttribute *ret)
/* Create a ecAttribute out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ecAttribute */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->level1 = sqlUnsignedComma(&s);
ret->level2 = sqlUnsignedComma(&s);
ret->level3 = sqlUnsignedComma(&s);
ret->level4 = sqlUnsignedComma(&s);
ret->ec = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->type, sizeof(ret->type));
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void ecAttributeFree(struct ecAttribute **pEl)
/* Free a single dynamically allocated ecAttribute such as created
 * with ecAttributeLoad(). */
{
struct ecAttribute *el;

if ((el = *pEl) == NULL) return;
freeMem(el->ec);
freeMem(el->description);
freez(pEl);
}

void ecAttributeFreeList(struct ecAttribute **pList)
/* Free a list of dynamically allocated ecAttribute's */
{
struct ecAttribute *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    ecAttributeFree(&el);
    }
*pList = NULL;
}

void ecAttributeOutput(struct ecAttribute *el, FILE *f, char sep, char lastSep) 
/* Print out ecAttribute.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->level1);
fputc(sep,f);
fprintf(f, "%u", el->level2);
fputc(sep,f);
fprintf(f, "%u", el->level3);
fputc(sep,f);
fprintf(f, "%u", el->level4);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ec);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

