/* encodeHapMapAlleleFreq.c was originally generated by the autoSql program, which also 
 * generated encodeHapMapAlleleFreq.h and encodeHapMapAlleleFreq.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2011 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "encode/encodeHapMapAlleleFreq.h"


void encodeHapMapAlleleFreqStaticLoad(char **row, struct encodeHapMapAlleleFreq *ret)
/* Load a row from encodeHapMapAlleleFreq table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->center = row[6];
strcpy(ret->refAllele, row[7]);
strcpy(ret->otherAllele, row[8]);
ret->refAlleleFreq = atof(row[9]);
ret->otherAlleleFreq = atof(row[10]);
ret->minorAlleleFreq = atof(row[11]);
ret->totalCount = sqlUnsigned(row[12]);
}

struct encodeHapMapAlleleFreq *encodeHapMapAlleleFreqLoad(char **row)
/* Load a encodeHapMapAlleleFreq from row fetched with select * from encodeHapMapAlleleFreq
 * from database.  Dispose of this with encodeHapMapAlleleFreqFree(). */
{
struct encodeHapMapAlleleFreq *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->center = cloneString(row[6]);
strcpy(ret->refAllele, row[7]);
strcpy(ret->otherAllele, row[8]);
ret->refAlleleFreq = atof(row[9]);
ret->otherAlleleFreq = atof(row[10]);
ret->minorAlleleFreq = atof(row[11]);
ret->totalCount = sqlUnsigned(row[12]);
return ret;
}

struct encodeHapMapAlleleFreq *encodeHapMapAlleleFreqLoadAll(char *fileName) 
/* Load all encodeHapMapAlleleFreq from a whitespace-separated file.
 * Dispose of this with encodeHapMapAlleleFreqFreeList(). */
{
struct encodeHapMapAlleleFreq *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[13];

while (lineFileRow(lf, row))
    {
    el = encodeHapMapAlleleFreqLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct encodeHapMapAlleleFreq *encodeHapMapAlleleFreqLoadAllByChar(char *fileName, char chopper) 
/* Load all encodeHapMapAlleleFreq from a chopper separated file.
 * Dispose of this with encodeHapMapAlleleFreqFreeList(). */
{
struct encodeHapMapAlleleFreq *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[13];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = encodeHapMapAlleleFreqLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct encodeHapMapAlleleFreq *encodeHapMapAlleleFreqCommaIn(char **pS, struct encodeHapMapAlleleFreq *ret)
/* Create a encodeHapMapAlleleFreq out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new encodeHapMapAlleleFreq */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->center = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->refAllele, sizeof(ret->refAllele));
sqlFixedStringComma(&s, ret->otherAllele, sizeof(ret->otherAllele));
ret->refAlleleFreq = sqlFloatComma(&s);
ret->otherAlleleFreq = sqlFloatComma(&s);
ret->minorAlleleFreq = sqlFloatComma(&s);
ret->totalCount = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void encodeHapMapAlleleFreqFree(struct encodeHapMapAlleleFreq **pEl)
/* Free a single dynamically allocated encodeHapMapAlleleFreq such as created
 * with encodeHapMapAlleleFreqLoad(). */
{
struct encodeHapMapAlleleFreq *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->center);
freez(pEl);
}

void encodeHapMapAlleleFreqFreeList(struct encodeHapMapAlleleFreq **pList)
/* Free a list of dynamically allocated encodeHapMapAlleleFreq's */
{
struct encodeHapMapAlleleFreq *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    encodeHapMapAlleleFreqFree(&el);
    }
*pList = NULL;
}

void encodeHapMapAlleleFreqOutput(struct encodeHapMapAlleleFreq *el, FILE *f, char sep, char lastSep) 
/* Print out encodeHapMapAlleleFreq.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->center);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->refAllele);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->otherAllele);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->refAlleleFreq);
fputc(sep,f);
fprintf(f, "%g", el->otherAlleleFreq);
fputc(sep,f);
fprintf(f, "%g", el->minorAlleleFreq);
fputc(sep,f);
fprintf(f, "%u", el->totalCount);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

