/* gtexAse.c was originally generated by the autoSql program, which also 
 * generated gtexAse.h and gtexAse.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gtexAse.h"



char *gtexAseCommaSepFieldNames = "chrom,chromStart,chromEnd,name,score,strand,thickStart,thickEnd,itemRgb,medianASE,coverage,samples,donors,minASE,q1ASE,q3ASE,maxASE,stdASE";

void gtexAseStaticLoad(char **row, struct gtexAse *ret)
/* Load a row from gtexAse table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->itemRgb = sqlUnsigned(row[8]);
ret->medianASE = sqlFloat(row[9]);
ret->coverage = sqlFloat(row[10]);
ret->samples = sqlUnsigned(row[11]);
ret->donors = sqlUnsigned(row[12]);
ret->minASE = sqlFloat(row[13]);
ret->q1ASE = sqlFloat(row[14]);
ret->q3ASE = sqlFloat(row[15]);
ret->maxASE = sqlFloat(row[16]);
ret->stdASE = sqlFloat(row[17]);
}

struct gtexAse *gtexAseLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all gtexAse from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with gtexAseFreeList(). */
{
struct gtexAse *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = gtexAseLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void gtexAseSaveToDb(struct sqlConnection *conn, struct gtexAse *el, char *tableName, int updateSize)
/* Save gtexAse as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s',%u,%u,'%s',%u,'%s',%u,%u,%u,%g,%g,%u,%u,%g,%g,%g,%g,%g)", 
	tableName,  el->chrom,  el->chromStart,  el->chromEnd,  el->name,  el->score,  el->strand,  el->thickStart,  el->thickEnd,  el->itemRgb,  el->medianASE,  el->coverage,  el->samples,  el->donors,  el->minASE,  el->q1ASE,  el->q3ASE,  el->maxASE,  el->stdASE);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct gtexAse *gtexAseLoad(char **row)
/* Load a gtexAse from row fetched with select * from gtexAse
 * from database.  Dispose of this with gtexAseFree(). */
{
struct gtexAse *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->itemRgb = sqlUnsigned(row[8]);
ret->medianASE = sqlFloat(row[9]);
ret->coverage = sqlFloat(row[10]);
ret->samples = sqlUnsigned(row[11]);
ret->donors = sqlUnsigned(row[12]);
ret->minASE = sqlFloat(row[13]);
ret->q1ASE = sqlFloat(row[14]);
ret->q3ASE = sqlFloat(row[15]);
ret->maxASE = sqlFloat(row[16]);
ret->stdASE = sqlFloat(row[17]);
return ret;
}

struct gtexAse *gtexAseLoadAll(char *fileName) 
/* Load all gtexAse from a whitespace-separated file.
 * Dispose of this with gtexAseFreeList(). */
{
struct gtexAse *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileRow(lf, row))
    {
    el = gtexAseLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexAse *gtexAseLoadAllByChar(char *fileName, char chopper) 
/* Load all gtexAse from a chopper separated file.
 * Dispose of this with gtexAseFreeList(). */
{
struct gtexAse *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gtexAseLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexAse *gtexAseCommaIn(char **pS, struct gtexAse *ret)
/* Create a gtexAse out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexAse */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->itemRgb = sqlUnsignedComma(&s);
ret->medianASE = sqlFloatComma(&s);
ret->coverage = sqlFloatComma(&s);
ret->samples = sqlUnsignedComma(&s);
ret->donors = sqlUnsignedComma(&s);
ret->minASE = sqlFloatComma(&s);
ret->q1ASE = sqlFloatComma(&s);
ret->q3ASE = sqlFloatComma(&s);
ret->maxASE = sqlFloatComma(&s);
ret->stdASE = sqlFloatComma(&s);
*pS = s;
return ret;
}

void gtexAseFree(struct gtexAse **pEl)
/* Free a single dynamically allocated gtexAse such as created
 * with gtexAseLoad(). */
{
struct gtexAse *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void gtexAseFreeList(struct gtexAse **pList)
/* Free a list of dynamically allocated gtexAse's */
{
struct gtexAse *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gtexAseFree(&el);
    }
*pList = NULL;
}

void gtexAseOutput(struct gtexAse *el, FILE *f, char sep, char lastSep) 
/* Print out gtexAse.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%u", el->itemRgb);
fputc(sep,f);
fprintf(f, "%g", el->medianASE);
fputc(sep,f);
fprintf(f, "%g", el->coverage);
fputc(sep,f);
fprintf(f, "%u", el->samples);
fputc(sep,f);
fprintf(f, "%u", el->donors);
fputc(sep,f);
fprintf(f, "%g", el->minASE);
fputc(sep,f);
fprintf(f, "%g", el->q1ASE);
fputc(sep,f);
fprintf(f, "%g", el->q3ASE);
fputc(sep,f);
fprintf(f, "%g", el->maxASE);
fputc(sep,f);
fprintf(f, "%g", el->stdASE);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

