/* lsSnpPdb.c was originally generated by the autoSql program, which also 
 * generated lsSnpPdb.h and lsSnpPdb.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "lsSnpPdb.h"


/* definitions for structType column */
static char *values_structType[] = {"XRay", "NMR", NULL};
static struct hash *valhash_structType = NULL;

void lsSnpPdbStaticLoad(char **row, struct lsSnpPdb *ret)
/* Load a row from lsSnpPdb table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->protId = row[0];
ret->pdbId = row[1];
ret->structType = sqlEnumParse(row[2], values_structType, &valhash_structType);
ret->chain = row[3][0];
ret->snpId = row[4];
ret->snpPdbLoc = sqlSigned(row[5]);
}

struct lsSnpPdb *lsSnpPdbLoad(char **row)
/* Load a lsSnpPdb from row fetched with select * from lsSnpPdb
 * from database.  Dispose of this with lsSnpPdbFree(). */
{
struct lsSnpPdb *ret;

AllocVar(ret);
ret->protId = cloneString(row[0]);
ret->pdbId = cloneString(row[1]);
ret->structType = sqlEnumParse(row[2], values_structType, &valhash_structType);
ret->chain = row[3][0];
ret->snpId = cloneString(row[4]);
ret->snpPdbLoc = sqlSigned(row[5]);
return ret;
}

struct lsSnpPdb *lsSnpPdbLoadAll(char *fileName) 
/* Load all lsSnpPdb from a whitespace-separated file.
 * Dispose of this with lsSnpPdbFreeList(). */
{
struct lsSnpPdb *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = lsSnpPdbLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct lsSnpPdb *lsSnpPdbLoadAllByChar(char *fileName, char chopper) 
/* Load all lsSnpPdb from a chopper separated file.
 * Dispose of this with lsSnpPdbFreeList(). */
{
struct lsSnpPdb *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = lsSnpPdbLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct lsSnpPdb *lsSnpPdbCommaIn(char **pS, struct lsSnpPdb *ret)
/* Create a lsSnpPdb out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new lsSnpPdb */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->protId = sqlStringComma(&s);
ret->pdbId = sqlStringComma(&s);
ret->structType = sqlEnumComma(&s, values_structType, &valhash_structType);
sqlFixedStringComma(&s, &(ret->chain), sizeof(ret->chain));
ret->snpId = sqlStringComma(&s);
ret->snpPdbLoc = sqlSignedComma(&s);
*pS = s;
return ret;
}

void lsSnpPdbFree(struct lsSnpPdb **pEl)
/* Free a single dynamically allocated lsSnpPdb such as created
 * with lsSnpPdbLoad(). */
{
struct lsSnpPdb *el;

if ((el = *pEl) == NULL) return;
freeMem(el->protId);
freeMem(el->pdbId);
freeMem(el->snpId);
freez(pEl);
}

void lsSnpPdbFreeList(struct lsSnpPdb **pList)
/* Free a list of dynamically allocated lsSnpPdb's */
{
struct lsSnpPdb *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    lsSnpPdbFree(&el);
    }
*pList = NULL;
}

void lsSnpPdbOutput(struct lsSnpPdb *el, FILE *f, char sep, char lastSep) 
/* Print out lsSnpPdb.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->protId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pdbId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
sqlEnumPrint(f, el->structType, values_structType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->chain);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->snpId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->snpPdbLoc);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

