/* defaultDb.h was originally generated by the autoSql program, which also 
 * generated defaultDb.c and defaultDb.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2003 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef DEFAULTDB_H
#define DEFAULTDB_H

struct defaultDb
/* Description of annotation database */
    {
    struct defaultDb *next;  /* Next in singly linked list. */
    char *name;	/* Short name of database.  'hg8' or the like */
    char *genome;	/* Unifying genome collection for which an assembly is the default */
    };

void defaultDbStaticLoad(char **row, struct defaultDb *ret);
/* Load a row from defaultDb table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct defaultDb *defaultDbLoad(char **row);
/* Load a defaultDb from row fetched with select * from defaultDb
 * from database.  Dispose of this with defaultDbFree(). */

struct defaultDb *defaultDbLoadAll(char *fileName);
/* Load all defaultDb from a tab-separated file.
 * Dispose of this with defaultDbFreeList(). */

struct defaultDb *defaultDbCommaIn(char **pS, struct defaultDb *ret);
/* Create a defaultDb out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new defaultDb */

void defaultDbFree(struct defaultDb **pEl);
/* Free a single dynamically allocated defaultDb such as created
 * with defaultDbLoad(). */

void defaultDbFreeList(struct defaultDb **pList);
/* Free a list of dynamically allocated defaultDb's */

void defaultDbOutput(struct defaultDb *el, FILE *f, char sep, char lastSep);
/* Print out defaultDb.  Separate fields with sep. Follow last field with lastSep. */

#define defaultDbTabOut(el,f) defaultDbOutput(el,f,'\t','\n');
/* Print out defaultDb as a line in a tab-separated file. */

#define defaultDbCommaOut(el,f) defaultDbOutput(el,f,',',',');
/* Print out defaultDb as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* DEFAULTDB_H */

