/* encodeHapMapAlleleFreq.h was originally generated by the autoSql program, which also 
 * generated encodeHapMapAlleleFreq.c and encodeHapMapAlleleFreq.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2008 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ENCODEHAPMAPALLELEFREQ_H
#define ENCODEHAPMAPALLELEFREQ_H

#define ENCODEHAPMAPALLELEFREQ_NUM_COLS 13

struct encodeHapMapAlleleFreq
/* HapMap SNPs in ENCODE regions */
    {
    struct encodeHapMapAlleleFreq *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position */
    unsigned chromEnd;	/* End position */
    char *name;	/* rsId or id */
    unsigned score;	/* Minor allele frequency from 500 to 1000 */
    char strand[2];	/* Strand */
    char *center;	/* Sequencing center */
    char refAllele[2];	/* Reference allele */
    char otherAllele[2];	/* Variant allele */
    float refAlleleFreq;	/* Reference allele frequency (between 0.0 and 1.0) */
    float otherAlleleFreq;	/* Variant allele frequency (between 0.0 and 1.0) */
    float minorAlleleFreq;	/* Smaller of the 2 frequencies (between 0.0 and 0.5) */
    unsigned totalCount;	/* Count of individuals */
    };

void encodeHapMapAlleleFreqStaticLoad(char **row, struct encodeHapMapAlleleFreq *ret);
/* Load a row from encodeHapMapAlleleFreq table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct encodeHapMapAlleleFreq *encodeHapMapAlleleFreqLoad(char **row);
/* Load a encodeHapMapAlleleFreq from row fetched with select * from encodeHapMapAlleleFreq
 * from database.  Dispose of this with encodeHapMapAlleleFreqFree(). */

struct encodeHapMapAlleleFreq *encodeHapMapAlleleFreqLoadAll(char *fileName);
/* Load all encodeHapMapAlleleFreq from whitespace-separated file.
 * Dispose of this with encodeHapMapAlleleFreqFreeList(). */

struct encodeHapMapAlleleFreq *encodeHapMapAlleleFreqLoadAllByChar(char *fileName, char chopper);
/* Load all encodeHapMapAlleleFreq from chopper separated file.
 * Dispose of this with encodeHapMapAlleleFreqFreeList(). */

#define encodeHapMapAlleleFreqLoadAllByTab(a) encodeHapMapAlleleFreqLoadAllByChar(a, '\t');
/* Load all encodeHapMapAlleleFreq from tab separated file.
 * Dispose of this with encodeHapMapAlleleFreqFreeList(). */

struct encodeHapMapAlleleFreq *encodeHapMapAlleleFreqCommaIn(char **pS, struct encodeHapMapAlleleFreq *ret);
/* Create a encodeHapMapAlleleFreq out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new encodeHapMapAlleleFreq */

void encodeHapMapAlleleFreqFree(struct encodeHapMapAlleleFreq **pEl);
/* Free a single dynamically allocated encodeHapMapAlleleFreq such as created
 * with encodeHapMapAlleleFreqLoad(). */

void encodeHapMapAlleleFreqFreeList(struct encodeHapMapAlleleFreq **pList);
/* Free a list of dynamically allocated encodeHapMapAlleleFreq's */

void encodeHapMapAlleleFreqOutput(struct encodeHapMapAlleleFreq *el, FILE *f, char sep, char lastSep);
/* Print out encodeHapMapAlleleFreq.  Separate fields with sep. Follow last field with lastSep. */

#define encodeHapMapAlleleFreqTabOut(el,f) encodeHapMapAlleleFreqOutput(el,f,'\t','\n');
/* Print out encodeHapMapAlleleFreq as a line in a tab-separated file. */

#define encodeHapMapAlleleFreqCommaOut(el,f) encodeHapMapAlleleFreqOutput(el,f,',',',');
/* Print out encodeHapMapAlleleFreq as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ENCODEHAPMAPALLELEFREQ_H */

