/* bacCloneAlias.c was originally generated by the autoSql program, which also 
 * generated bacCloneAlias.h and bacCloneAlias.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "bacCloneAlias.h"


void bacCloneAliasStaticLoad(char **row, struct bacCloneAlias *ret)
/* Load a row from bacCloneAlias table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->alias = row[0];
ret->sangerName = row[1];
}

struct bacCloneAlias *bacCloneAliasLoad(char **row)
/* Load a bacCloneAlias from row fetched with select * from bacCloneAlias
 * from database.  Dispose of this with bacCloneAliasFree(). */
{
struct bacCloneAlias *ret;

AllocVar(ret);
ret->alias = cloneString(row[0]);
ret->sangerName = cloneString(row[1]);
return ret;
}

struct bacCloneAlias *bacCloneAliasLoadAll(char *fileName) 
/* Load all bacCloneAlias from a whitespace-separated file.
 * Dispose of this with bacCloneAliasFreeList(). */
{
struct bacCloneAlias *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = bacCloneAliasLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bacCloneAlias *bacCloneAliasLoadAllByChar(char *fileName, char chopper) 
/* Load all bacCloneAlias from a chopper separated file.
 * Dispose of this with bacCloneAliasFreeList(). */
{
struct bacCloneAlias *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bacCloneAliasLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bacCloneAlias *bacCloneAliasCommaIn(char **pS, struct bacCloneAlias *ret)
/* Create a bacCloneAlias out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bacCloneAlias */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->alias = sqlStringComma(&s);
ret->sangerName = sqlStringComma(&s);
*pS = s;
return ret;
}

void bacCloneAliasFree(struct bacCloneAlias **pEl)
/* Free a single dynamically allocated bacCloneAlias such as created
 * with bacCloneAliasLoad(). */
{
struct bacCloneAlias *el;

if ((el = *pEl) == NULL) return;
freeMem(el->alias);
freeMem(el->sangerName);
freez(pEl);
}

void bacCloneAliasFreeList(struct bacCloneAlias **pList)
/* Free a list of dynamically allocated bacCloneAlias's */
{
struct bacCloneAlias *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bacCloneAliasFree(&el);
    }
*pList = NULL;
}

void bacCloneAliasOutput(struct bacCloneAlias *el, FILE *f, char sep, char lastSep) 
/* Print out bacCloneAlias.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->alias);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sangerName);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

