/* bigRmskBed.c was originally generated by the autoSql program, which also 
 * generated bigRmskBed.h and bigRmskBed.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "bigRmskBed.h"



char *bigRmskBedCommaSepFieldNames = "chrom,chromStart,chromEnd,name,score,strand,thickStart,thickEnd,reserved,blockCount,blockSizes,blockStarts,id,description";

void bigRmskBedStaticLoad(char **row, struct bigRmskBed *ret)
/* Load a row from bigRmskBed table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->reserved = sqlUnsigned(row[8]);
ret->blockCount = sqlUnsigned(row[9]);
ret->blockSizes = row[10];
ret->blockStarts = row[11];
ret->id = sqlUnsigned(row[12]);
ret->description = row[13];
}

struct bigRmskBed *bigRmskBedLoad(char **row)
/* Load a bigRmskBed from row fetched with select * from bigRmskBed
 * from database.  Dispose of this with bigRmskBedFree(). */
{
struct bigRmskBed *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->reserved = sqlUnsigned(row[8]);
ret->blockCount = sqlUnsigned(row[9]);
ret->blockSizes = cloneString(row[10]);
ret->blockStarts = cloneString(row[11]);
ret->id = sqlUnsigned(row[12]);
ret->description = cloneString(row[13]);
return ret;
}

struct bigRmskBed *bigRmskBedLoadAll(char *fileName) 
/* Load all bigRmskBed from a whitespace-separated file.
 * Dispose of this with bigRmskBedFreeList(). */
{
struct bigRmskBed *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = bigRmskBedLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bigRmskBed *bigRmskBedLoadAllByChar(char *fileName, char chopper) 
/* Load all bigRmskBed from a chopper separated file.
 * Dispose of this with bigRmskBedFreeList(). */
{
struct bigRmskBed *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bigRmskBedLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bigRmskBed *bigRmskBedCommaIn(char **pS, struct bigRmskBed *ret)
/* Create a bigRmskBed out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bigRmskBed */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->reserved = sqlUnsignedComma(&s);
ret->blockCount = sqlUnsignedComma(&s);
ret->blockSizes = sqlStringComma(&s);
ret->blockStarts = sqlStringComma(&s);
ret->id = sqlUnsignedComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void bigRmskBedFree(struct bigRmskBed **pEl)
/* Free a single dynamically allocated bigRmskBed such as created
 * with bigRmskBedLoad(). */
{
struct bigRmskBed *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->blockSizes);
freeMem(el->blockStarts);
freeMem(el->description);
freez(pEl);
}

void bigRmskBedFreeList(struct bigRmskBed **pList)
/* Free a list of dynamically allocated bigRmskBed's */
{
struct bigRmskBed *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bigRmskBedFree(&el);
    }
*pList = NULL;
}

void bigRmskBedOutput(struct bigRmskBed *el, FILE *f, char sep, char lastSep) 
/* Print out bigRmskBed.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%u", el->reserved);
fputc(sep,f);
fprintf(f, "%u", el->blockCount);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->blockSizes);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->blockStarts);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

