table edwFastqFileTest
"info on a file in fastq short read format beyond what's in edwValidFile"
    (
    uint id primary auto;  "ID in this table"
    uint fileId;	"ID in edwFile table"
    bigint sampleCount; "# of items in sample if we are just subsampling as we do for reads." 
    string sampleFileName; "Name of file containing sampleCount randomly selected items from file."
    bigint readCount; "# of reads in file"
    bigint baseCount; "# of bases in all reads added up"
    double readSizeMean; "Average read size"
    double readSizeStd;  "Standard deviation of read size"
    int readSizeMin;  "Minimum read size"
    int readSizeMax; "Maximum read size"
    double qualMean;  "Mean quality scored as 10*-log10(errorProbability) or close to it.  >25 is good"
    double qualStd;   "Standard deviation of quality"
    double qualMin;   "Minimum observed quality"
    double qualMax;   "Maximum observed quality"
    string qualType;  "For fastq files either 'sanger' or 'illumina'
    int qualZero;  "For fastq files offset to get to zero value in ascii encoding"
    double atRatio;  "Ratio of A+T to total sequence (not including Ns)"
    double aRatio; "Ratio of A to total sequence (including Ns)"
    double cRatio; "Ratio of C to total sequence (including Ns)"
    double gRatio; "Ratio of G to total sequence (including Ns)"
    double tRatio; "Ratio of T to total sequence (including Ns)"
    double nRatio; "Ratio of N or . to total sequence"
    int posCount; "Number of positions we sample for base-by-base averages"
    double[posCount] qualPos;  "Mean value for each position in a read up to some max."
    double[posCount] aAtPos;   "% of As at each pos"
    double[posCount] cAtPos;   "% of Cs at each pos"
    double[posCount] gAtPos;   "% of Gs at each pos"
    double[posCount] tAtPos;   "% of Ts at each pos"
    double[posCount] nAtPos;   "% of '.' or 'N' at each pos"
    )

